Rem drv: <create type="post_creation" pos="credentials/credentials_post_creation.sql-"/>
Rem
Rem $Header: sdk_post_creation.sql 07-aug-2007.00:32:54 aloganda Exp $
Rem
Rem sdk_post_creation.sql
Rem
Rem Copyright (c) 2002, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       aloganda 08/07/07 - ULN project
Rem       nqureshi 07/27/07 - provide powerbroker prompt flag
Rem       nqureshi 07/28/07 - Backport nqureshi_bug-6282479 from main
Rem       rattipal 07/26/07 - Adding PrereqCommands
Rem       jinslee  07/03/07 - Added stageAgentPatchScript
Rem       vsriram  12/01/06 - Add new command sleepWait
Rem       vsriram  06/04/07 - XbranchMerge vsriram_bug-5681904 from main
Rem       kmanicka 05/29/07 - 
Rem       nqureshi 04/18/07 - XbranchMerge kmanicka_pdp5 from main
Rem       kashukla 10/13/06 - registering PurgeDepLib
Rem       nqureshi 09/08/06 - pdp metadata
Rem       kmanicka 08/25/06 - trusted RemoteOp
Rem       joyoon   08/16/06 - Added RepointAgent job
Rem       sradhakr 10/23/06 - Backport sradhakr_bug-5382567 from main
Rem       rattipal 08/29/06 - Adding FreeIPAddressCommand
Rem       rattipal 09/13/06 - Backport rattipal_clear_ippool from main
Rem       vnukal   08/14/06 - XbranchMerge vnukal_reloc_job from main
Rem       ssdas    08/09/06 - Backport rshetty_cf3 from main
Rem       sacgoel  08/10/06 - 
Rem       paachary 03/16/06 - Added Template Comparison job registration script
Rem       pmodi    07/26/06 - Command for dy tgt eval 
Rem       kmanicka 05/18/06 - implement pdp
Rem       kmanicka 05/18/06 - implement pdp
Rem       neearora 06/06/06 - added entry for modifyTargetDispName command 
Rem       rshetty  05/25/06 - adding commands for congenital features 
Rem       kashukla 05/02/06 - registering SuiteDirectiveParamsCommand 
Rem       niramach 04/19/06 - Register DeleteEvalResults job command. 
Rem       kashukla 01/19/06 - adding SuiteAddRemoveHW 
Rem       adeb     01/30/06 - SSH changes for Cloning 
Rem       kchiasso 01/05/06 - 
Rem       kashukla 11/09/05 - adding UpdateHardwareStatusCommand 
Rem       prayarot 10/04/05 - ProvCreds type is added 
Rem       prayarot 09/30/05 - To register provision secure props in creds 
Rem                           table 
Rem       adeb     09/12/05 - clone user creation 
Rem    adeb        09/02/05 -integrate cloning provisioning 
Rem    prayarot    08/29/05 - To add Clean up 
Rem    tthakur     08/29/05 - do not raise exception when inserting duplicate 
Rem                           callbacks 
Rem    prayarot    08/11/05 - To add creds validator 
Rem    adeb        08/17/05 - To add clone provision commands 
Rem    prayarot    07/29/05 - To add Post commands 
Rem    pshroff     07/19/05 - adding StageOMSInfoCommand 
Rem    gpalrech    07/12/05 - adding StrayHomeCollectionCommand 
Rem    scgrover    07/06/05 - add extended sql trace 
Rem    pshroff     07/12/05 - To add ProvisionCreds
Rem    gsbhatia    07/03/05 - New repmgr header impl 
Rem    skini       06/06/05 - Ignore DUP_VAL_ON_INDEX more granularly in 
Rem                           credential creation 
Rem    prayarot    06/02/05 - To add CheckComamand 
Rem    rbhanush    05/19/05 - Adding updated components to image
Rem    prayarot    04/25/05 - 
Rem    rbhanush    04/20/05 - Added commands for default image
Rem    pkantawa    04/17/05 - Fix 4306791: Ignore DUP_VAL_ON_INDEX 
Rem    pshroff     04/11/05 - adding executeDirectiveCommand 
Rem    rbhanush    03/18/05 - Add commands for linux OS
Rem    chyu        03/19/05 - fixing the create role during the upgrade 
Rem                           scenario 
Rem    prayarot    02/23/05 - To add CopyProvisionProperties 
Rem    prayarot    02/08/05 - Add stageing executor 
Rem    prayarot    01/13/05 - To add New Suite commands 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    rkpandey    01/12/05 - Add Agent Deletion Command 
Rem    mfidanbo    12/16/04 - add remove collections command 
Rem    rmarripa    12/22/04 - add Webapp upgrade commands 
Rem    rpinnama    11/23/04 - Remove SP2 warning 
Rem    prayarot    11/19/04 - to add entry stage 
Rem    pshroff     11/14/04 - Remove ExecuteDirectivesCommand 
Rem    kashukla    10/26/04 - add commandname for PutFileSWLib 
Rem    pshroff     09/27/04 - Linux Provision 
Rem    kmanicka    09/21/04 - add user model callbacks
Rem    snakai      09/13/04 - Add BeaconTestUpdate Job 
Rem    skini       09/17/04 - Fix listener creds 
Rem    ranmath     09/10/04 - Adding Host Patching Job Commands. 
Rem    skini       09/08/04 - Add target addition callback to introduce new 
Rem                           credential sets 
Rem    skini       08/10/04 - Fix HostCredsPriv issue 
Rem    skini       07/29/04 - Fix case of cred column 
Rem    skini       07/26/04 - Metadata for interim 
Rem    lhan        04/13/04 - Remove captureBaseline and put it in db area
Rem    ysun        04/12/04 - Remove UpdateRacTargets
Rem    lhan        04/08/04 - Add captureBaseline
Rem    skini       12/04/03 - Comment out cred metadata insert for later 
Rem    skini       12/03/03 - Credential metadata for 4.0 agents 
Rem    skini       08/28/03 - Remove creds metadata 
Rem    ysun        08/27/03 - add update rac targets
Rem    skini       08/15/03 - Change definition of OH creds 
Rem    skini       08/14/03 - API changes 
Rem    skini       08/11/03 - Changes to credential sets 
Rem    aholser     07/23/03 - PUBLIC role
Rem    skini       07/10/03 - Schema changes
Rem    rzazueta    06/12/03 - Add entry for propagateTargetData command
Rem    streddy     04/29/03 - Added Master/Stanby commands
Rem    skini       06/09/03 - Changes for NLS ids
Rem    skini       05/20/03 - Create well-known credential types and sets
Rem    dcawley     03/07/03 - Remove ADD_SECURITY_POLICIES
Rem    skini       03/21/03 - Make email and repSQL long running
Rem    ychan       01/09/03 - Add ReloadTargetProperties
Rem    skini       09/18/02 - Add DiscardState command
Rem    skini       08/27/02 - Add ExecAndSuspend
Rem    skini       08/02/02 - Add StopBlackout command
Rem    skini       07/21/02 - Add StartBlackout and StopBlackout command
Rem     mgoodric   07/16/02 - Add automatic update of ARU table data
Rem     skini      07/03/02 - Add deleteTarget command
Rem     rpinnama   05/15/02 - rpinnama_reorg_rep_scripts
Rem     rpinnama   05/15/02 - Created
Rem



-- Register "built-in" commands
BEGIN
    mgmt_jobs.register_command('remoteOp',
                         'oracle.sysman.emdrep.jobs.commands.RemoteOp',
                         MGMT_JOBS.SHORT_RUNNING_COMMAND,
                         MGMT_JOBS.TRUSTABLE_COMMAND);
    
    mgmt_jobs.register_command('ComplianceEvaluation',
                         'oracle.sysman.emdrep.jobs.commands.ComplianceEvaluation');
    mgmt_jobs.register_command('DeleteEvalResults',
                         'oracle.sysman.emdrep.jobs.commands.DeleteEvalResults');                         
    mgmt_jobs.register_command('execAndSuspend',
                         'oracle.sysman.emdrep.jobs.commands.ExecAndSuspend');

    mgmt_jobs.register_command('getFile',
                         'oracle.sysman.emdrep.jobs.commands.GetFile',
                         MGMT_JOBS.LONG_RUNNING_COMMAND,
                         MGMT_JOBS.TRUSTABLE_COMMAND);

    mgmt_jobs.register_command('putFile',
                         'oracle.sysman.emdrep.jobs.commands.PutFile',
                         MGMT_JOBS.LONG_RUNNING_COMMANd,
                         MGMT_JOBS.TRUSTABLE_COMMAND);

    mgmt_jobs.register_command('sleepWait',
                         'oracle.sysman.emdrep.jobs.commands.SleepWait',
                         MGMT_JOBS.LONG_RUNNING_COMMAND,
                         MGMT_JOBS.TRUSTABLE_COMMAND);

    mgmt_jobs.register_command('provUp2date',
        'oracle.sysman.emdrep.jobs.commands.ProvisionUp2date',
        MGMT_JOBS.SHORT_RUNNING_COMMAND,
        MGMT_JOBS.TRUSTABLE_COMMAND);

    mgmt_jobs.register_command('putFileSWLib',
                         'oracle.sysman.emdrep.jobs.commands.PutFileSWLib',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('fileTransfer',
                         'oracle.sysman.emdrep.jobs.commands.FileTransfer',
                         MGMT_JOBS.SHORT_RUNNING_COMMAND,
                         MGMT_JOBS.TRUSTABLE_COMMAND);

    mgmt_jobs.register_command('email',
                         'oracle.sysman.emdrep.jobs.commands.Email',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('repSQL',
                         'oracle.sysman.emdrep.jobs.commands.RepSQL',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('addTarget',
                         'oracle.sysman.emdrep.jobs.commands.AddTarget');

    mgmt_jobs.register_command('modifyTargetDispName',
                         'oracle.sysman.emdrep.jobs.commands.ModifyTargetDispName');

    mgmt_jobs.register_command('reloadTargetProperties',
              'oracle.sysman.emdrep.jobs.commands.ReloadTargetProperties');

    mgmt_jobs.register_command('deleteTarget',
                         'oracle.sysman.emdrep.jobs.commands.DeleteTarget');

  mgmt_jobs.register_command('deleteAgentTarget',
                         'oracle.sysman.emdrep.jobs.commands.DeleteAgentTarget');
    mgmt_jobs.register_command('relocateTarget',
                         'oracle.sysman.emdrep.target.RelocateTarget');


    mgmt_jobs.register_command('pingCfmEMDDown',
                         'oracle.sysman.emdrep.ping.PingFailureCfm');

    mgmt_jobs.register_command('patchNotifyCommand',
                         'oracle.sysman.eml.ecm.executor.PatchNotifyExecutor',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('snapshotCollectionCommand',
                         'oracle.sysman.eml.ecm.track.SnapshotCollectionCommand',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('cachePatchFile',
                         'oracle.sysman.emdrep.jobs.commands.CachePatchFile',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);
    mgmt_jobs.register_command('updateARUTables',
                         'oracle.sysman.emdrep.jobs.commands.UpdateARUTables',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);
    mgmt_jobs.register_command('setMasterAgent',
                         'oracle.sysman.emdrep.jobs.commands.SetMasterAgent');
    mgmt_jobs.register_command('setStandbyAgent',
                         'oracle.sysman.emdrep.jobs.commands.SetStandbyAgent');
    mgmt_jobs.register_command('updatePackagesInfo',
                         'oracle.sysman.emdrep.jobs.commands.UpdatePackagesInfo',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);
    mgmt_jobs.register_command('collectComplianceInfo',
                         'oracle.sysman.emdrep.jobs.commands.CollectComplianceInfo',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('stageAgentPatchScript',
                         'oracle.sysman.emdrep.jobs.commands.StageAgentPatchScript');


    -- For debugging/examples only
    mgmt_jobs.register_command('echoParams',
                               'oracle.sysman.emdrep.jobs.commands.examples.EchoParams',
                               MGMT_JOBS.SHORT_RUNNING_COMMAND,
                               MGMT_JOBS.NON_TRUSTABLE_COMMAND);
    mgmt_jobs.register_command('vectorTargets',
                         'oracle.sysman.emdrep.jobs.commands.examples.VectorTargets');
    mgmt_jobs.register_command('vectorProperties',
                         'oracle.sysman.emdrep.jobs.commands.examples.VectorProperties',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    -- Internal commands
    mgmt_jobs.register_command('pingEMD',
                         'oracle.sysman.emdrep.jobs.commands.examples.PingEMD',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('startBlackout',
                         'oracle.sysman.emdrep.jobs.commands.StartBlackout',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);
    
     mgmt_jobs.register_command('stopBlackout',
                         'oracle.sysman.emdrep.jobs.commands.StopBlackout',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('discardState',
                         'oracle.sysman.emdrep.jobs.commands.DiscardState',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('propagateTargetData',
                         'oracle.sysman.emdrep.jobs.commands.PropagateTargetData',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('UpdateBeaconCollections',
                         'oracle.sysman.emdrep.jobs.commands.UpdateBeaconCollections',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('RemoveBeaconCollections',
                         'oracle.sysman.emdrep.jobs.commands.RemoveBeaconCollections',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('RemoveAgentTargetInstance',
                         'oracle.sysman.emdrep.jobs.commands.DeleteAgentTargetInstance',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('AddSimpleTargetInstance',
                         'oracle.sysman.emdrep.jobs.commands.AddSimpleTarget',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('UpgradeWebappTargetData',
                         'oracle.sysman.emdrep.jobs.commands.UpgradeWebappTargetData',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);


		
    -- all provision commands starts
    mgmt_jobs.register_command('UpdateProvisioningStatusCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.UpdateProvisioningStatusCommand');

    mgmt_jobs.register_command('InsertBinaryDataCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.InsertBinaryDataCommand');

    mgmt_jobs.register_command('InstallCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.InstallCommand');

    mgmt_jobs.register_command('UpdateInstallProgressCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.UpdateInstallProgressCommand');

    mgmt_jobs.register_command('ReportErrorCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.ReportErrorCommand');

    mgmt_jobs.register_command('PutBinaryCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.PutBinaryCommand');

    mgmt_jobs.register_command('getFileSWLib',
                         'oracle.sysman.emgc.provision.jobs.commands.GetFileSWLib',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);
    mgmt_jobs.register_command('DiagnosticsCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.DiagnosticsCommand');

    mgmt_jobs.register_command('CheckDiagnosticCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.CheckDiagnosticCommand');

     mgmt_jobs.register_command('StageCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.StageCommand');

     mgmt_jobs.register_command('StageImageCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.StageImageCommand');

     mgmt_jobs.register_command('StagingExecutor',
                         'oracle.sysman.emgc.provision.jobs.commands.StagingExecutor');

     mgmt_jobs.register_command('ResetInitialCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.ResetInitialCommand');

     mgmt_jobs.register_command('StageComponentCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.StageComponentCommand');

     mgmt_jobs.register_command('StageComponentLinkCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.StageComponentLinkCommand');

     mgmt_jobs.register_command('UpdateStageProgressCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.UpdateStageProgressCommand');
     
     mgmt_jobs.register_command('StageResetJobCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.StageResetJobCommand');

     mgmt_jobs.register_command('CheckSuiteCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.CheckSuiteCommand');

     mgmt_jobs.register_command('UpdateHardwareStatusCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.UpdateHardwareStatusCommand');

     mgmt_jobs.register_command('UpdateSuiteStatusCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.UpdateSuiteStatusCommand');

     mgmt_jobs.register_command('SuiteAddRemoveHWCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.SuiteAddRemoveHW');

     mgmt_jobs.register_command('SuiteDirectiveParamsCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.SuiteDirectiveParamsCommand');

     mgmt_jobs.register_command('SuitePostInstallCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.SuitePostInstallCommand');

     mgmt_jobs.register_command('SuiteProvisionCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.SuiteProvisionCommand');

     mgmt_jobs.register_command('CopyProvosionProperties',
                         'oracle.sysman.emgc.provision.jobs.commands.CopyProvosionProperties');

     mgmt_jobs.register_command('CredentialVerifierCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.CredentialVerifierCommand');

     mgmt_jobs.register_command('CreateRPMNamesFileCommand',
                        'oracle.sysman.emgc.provision.jobs.commands.CreateRPMNamesFileCommand');

     mgmt_jobs.register_command('GetRPMDirCommand',
                        'oracle.sysman.emgc.provision.jobs.commands.GetRPMDirCommand');

     mgmt_jobs.register_command('GetRPMListCommand',
                        'oracle.sysman.emgc.provision.jobs.commands.GetRPMListCommand', MGMT_JOBS.LONG_RUNNING_COMMAND);

     mgmt_jobs.register_command('AddBinaryToComponentCommand',
                        'oracle.sysman.emgc.provision.jobs.commands.AddBinaryToComponentCommand', MGMT_JOBS.LONG_RUNNING_COMMAND);

     mgmt_jobs.register_command('GetFolderPathCommand',
                        'oracle.sysman.emgc.provision.jobs.commands.GetFolderPathCommand', MGMT_JOBS.LONG_RUNNING_COMMAND);

     mgmt_jobs.register_command('ExecuteDirectiveCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.ExecuteDirectiveCommand', MGMT_JOBS.LONG_RUNNING_COMMAND);

     mgmt_jobs.register_command('GetDefaultRPMListCommand', 'oracle.sysman.emgc.provision.jobs.commands.GetDefaultRPMListCommand');

     mgmt_jobs.register_command('CreateDefaultComponentsCommand', 'oracle.sysman.emgc.provision.jobs.commands.CreateDefaultComponentsCommand');

     mgmt_jobs.register_command('AddComponentsToImageCommand', 'oracle.sysman.emgc.provision.jobs.commands.AddComponentsToImageCommand');

     mgmt_jobs.register_command('GetDefaultDirectivesLocCommand', 'oracle.sysman.emgc.provision.jobs.commands.GetDefaultDirectivesLocCommand');

    mgmt_jobs.register_command('StageNetworkCompCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.StageNetworkCompCommand');

     mgmt_jobs.register_command('CheckClusterCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.CheckClusterCommand');

     mgmt_jobs.register_command('ClusterProvisionCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.ClusterProvisionCommand');

     mgmt_jobs.register_command('ClusterDirectivesCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.ClusterDirectivesCommand');

     mgmt_jobs.register_command('PostAddRemoveNodeCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.PostAddRemoveNodeCommand');

     mgmt_jobs.register_command('PostInstallCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.PostInstallCommand');

     mgmt_jobs.register_command('PostStageCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.PostStageCommand');


     mgmt_jobs.register_command('StageOMSInfoCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.StageOMSInfoCommand');

     mgmt_jobs.register_command('CheckRunCloneCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.CheckRunCloneCommand');
     mgmt_jobs.register_command('CheckCloneCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.CheckCloneCommand');
     mgmt_jobs.register_command('CloneJobArgsCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.CloneJobArgsCommand');

     mgmt_jobs.register_command('CloneDoneCheckCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.CloneDoneCheckCommand');

     mgmt_jobs.register_command('CreateCloneUsersCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.CreateCloneUsersCommand');
     mgmt_jobs.register_command('SSHParamsCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.SSHParamsCommand');    
     mgmt_jobs.register_command('CleanUpStageCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.CleanUpStageCommand');

     mgmt_jobs.register_command('AddHardwareToPatchGroupCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.AddHardwareToPatchGroupCommand');

     mgmt_jobs.register_command('ApplyMonitoringTemplateCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.ApplyMonitoringTemplateToHardwareCommand');

     mgmt_jobs.register_command('FreeIPAddressCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.FreeIPAddressCommand');
    mgmt_jobs.register_command('TargetPrereqCommand',
                        'oracle.sysman.emgc.provision.jobs.commands.TargetPrereqCommand');
    mgmt_jobs.register_command('StagePrereqCommand',
                        'oracle.sysman.emgc.provision.jobs.commands.StagePrereqCommand');
    mgmt_jobs.register_command('RefPrereqCommand',
                        'oracle.sysman.emgc.provision.jobs.commands.RefPrereqCommand');
    mgmt_jobs.register_command('SetSudoPathCommand',
                        'oracle.sysman.emgc.provision.jobs.commands.SetSudoPathCommand');
                         
                                
                            
                         
     mgmt_jobs.register_command('PurgeDepLibCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.PurgeDepLibCommand');
                         
    -- all provision commands ends
     mgmt_jobs.register_command('StrayHomeCollectionCommand',
                         'oracle.sysman.emdrep.jobs.commands.StrayHomeCollectionCommand');

   -- Template Comparison Job registered here
    mgmt_jobs.register_command('templateComparisonCommand',
                               'oracle.sysman.eml.metrics.template.TemplateComparisonCommand');

END;
/
COMMIT;


-- Create PULBIC role
BEGIN
  IF mgmt_user.has_role('SYSMAN','PUBLIC',0) = MGMT_USER.USER_HAS_ROLE
  THEN RETURN;
  ELSE
    mgmt_user.create_role('PUBLIC','');
  END IF;
END;
/
COMMIT;


BEGIN
DECLARE 
l_host_type_cols MGMT_CRED_TYPE_COL_ARRAY := MGMT_CRED_TYPE_COL_ARRAY();
l_db_type_cols MGMT_CRED_TYPE_COL_ARRAY := MGMT_CRED_TYPE_COL_ARRAY();
l_db_host_type_cols MGMT_CRED_TYPE_COL_ARRAY := MGMT_CRED_TYPE_COL_ARRAY();
l_lsnr_type_cols MGMT_CRED_TYPE_COL_ARRAY := MGMT_CRED_TYPE_COL_ARRAY();
l_role_col_vals MGMT_CRED_TYPE_COL_VAL_ARRAY := MGMT_CRED_TYPE_COL_VAL_ARRAY();
l_prov_type_cols MGMT_CRED_TYPE_COL_ARRAY := MGMT_CRED_TYPE_COL_ARRAY();

l_host_set_cols MGMT_CRED_SET_COL_ARRAY := MGMT_CRED_SET_COL_ARRAY();
l_db_set_cols MGMT_CRED_SET_COL_ARRAY := MGMT_CRED_SET_COL_ARRAY();
l_oh_set_cols MGMT_CRED_SET_COL_ARRAY := MGMT_CRED_SET_COL_ARRAY();
l_provision_set_cols MGMT_CRED_SET_COL_ARRAY := MGMT_CRED_SET_COL_ARRAY();
l_db_host_set_cols MGMT_CRED_SET_COL_ARRAY := MGMT_CRED_SET_COL_ARRAY();
l_lsnr_set_cols MGMT_CRED_SET_COL_ARRAY := MGMT_CRED_SET_COL_ARRAY();

l_host_ref MGMT_CRED_TYPE_REF;
l_refs MGMT_CRED_TYPE_REF_ARRAY := MGMT_CRED_TYPE_REF_ARRAY();
BEGIN
    BEGIN
    -- Create the host type HostCreds
    l_host_type_cols.extend(2);
    l_host_type_cols(1) := MGMT_CRED_TYPE_COL_RECORD('HostUserName', 1,
                                                     null, null,
                                                     'UserName', 
                                                     'CREDS_HOST_USERNAME',
                                                     null);
    l_host_type_cols(2) := MGMT_CRED_TYPE_COL_RECORD('HostPassword', 0,
                                                     null, null,
                                                     'Password',
                                                     'CREDS_HOST_PASSWORD',
                                                     null);

    MGMT_CREDENTIAL.create_credential_type('host', 'HostCreds', '2.0',
                                           'Host Credentials',
                                           'CREDS_HOST_HOSTCREDS',
                                           'Base type for host credentials', 
                                           null, l_host_type_cols);
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
        NULL;
    END;

    BEGIN    
    -- Create the database type DBCreds
    -- Values for the DBRole type column
    l_role_col_vals.extend(2);
    l_role_col_vals(1) := MGMT_CRED_TYPE_COL_VAL('normal', 1);
    l_role_col_vals(2) := MGMT_CRED_TYPE_COL_VAL('sysdba', 0);

    -- First, create the type DBCreds
    l_db_type_cols.extend(3);
    l_db_type_cols(1) := MGMT_CRED_TYPE_COL_RECORD('DBUserName', 1,
                                                   null, null,
                                                   'UserName', 
                                                   'CREDS_DATABASE_USERNAME',
                                                   null);
    l_db_type_cols(2) := MGMT_CRED_TYPE_COL_RECORD('DBPassword', 0,
                                                   null, null,
                                                   'Password',
                                                   'CREDS_DATABASE_PASSWORD',
                                                   null);
    l_db_type_cols(3) := MGMT_CRED_TYPE_COL_RECORD('DBRole', 0,
                                                   null, null,
                                                   'Role',
                                                   'CREDS_DATABASE_ROLE',
                                                   l_role_col_vals);

    MGMT_CREDENTIAL.create_credential_type('oracle_database', 
                                           'DBCreds', '3.0',
                                           'Database credentials', 
                                           'CREDS_DATABASE_DBCREDS',
                                           'database credentials', null, 
                                           l_db_type_cols);
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
        NULL;
    END;

    BEGIN
    -- Create the type DBHostCreds
    l_host_ref := MGMT_CRED_TYPE_REF('HostRef', 'HostCreds', 'host', '2.0', 'host');
    l_refs.extend(1);
    l_refs(1) := l_host_ref;

    l_db_host_type_cols.extend(2);
    l_db_host_type_cols(1) := MGMT_CRED_TYPE_COL_RECORD('HostUserName', 1,
                                                   'HostRef', 'HostUserName',
                                                   'Host UserName', 
                                                   'CREDS_DATABASE_HOSTTYPE_USERNAME',
                                                   null);
    l_db_host_type_cols(2) := MGMT_CRED_TYPE_COL_RECORD('HostPassword', 0,
                                                   'HostRef', 'HostPassword',
                                                   'Host Password',
                                                   'CREDS_DATABASE_HOSTTYPE_PASSWORD',
                                                   null);


    MGMT_CREDENTIAL.create_credential_type('oracle_database', 
                                           'DBHostCreds', '3.0',
                                           'Database host credentials', 
                                           'CREDS_DATABASE_DBHOSTCREDS',
                                           'database host credentials', 
                                           l_refs,
                                           l_db_host_type_cols);
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
        NULL;
    END;

    BEGIN
    -- Create the type LsnrCreds
    l_lsnr_type_cols.extend(1);
    l_lsnr_type_cols(1) := MGMT_CRED_TYPE_COL_RECORD('Password', 1,
                                                   null, null,
                                                   'Password', 
                                                   'CREDS_LISTENER_PASSWORD',
                                                   null);



    MGMT_CREDENTIAL.create_credential_type('oracle_listener', 
                                           'LsnrCreds', '1.0',
                                           'Listener credentials', 
                                           'CREDS_LISTENER_CREDS',
                                           'listener credentials', null, 
                                           l_lsnr_type_cols);
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
        NULL;
    END;


    BEGIN
    -- Create the type Provcreds
    l_prov_type_cols.extend(4);
    l_prov_type_cols(1) := MGMT_CRED_TYPE_COL_RECORD('OMSRegistrationPassword', 1, 
						      null, null, 
						      'RegPassword', 
						      'CREDS_OMS_REGISTRATION_PASSWORD',  null);

    l_prov_type_cols(2) := MGMT_CRED_TYPE_COL_RECORD('InstallUserName', 1, 
							null, null, 
							'InstallUserName',
						  	'CREDS_INSTALL_USER',  null);

    l_prov_type_cols(3) := MGMT_CRED_TYPE_COL_RECORD('InstallPassword', 1, 
							 null, null,  
							'InstallPassword',  
							'CREDS_INSTALL_PASSWORD',  null);

    l_prov_type_cols(4) := MGMT_CRED_TYPE_COL_RECORD('ProvCompPasswd', 1, 
					 	     null, null, 
						     'CompSecretProperty',
						     'CREDS_COMP_SECRET_PASSWORD',  null);	                                                   

    MGMT_CREDENTIAL.create_credential_type('host',  
					   'ProvisionCreds', '2.0',
                                           'provision credentials', 
                          		   'CREDS_PROVISION',  
 					   'provision credentials', null,
					   l_prov_type_cols);
EXCEPTION
WHEN DUP_VAL_ON_INDEX THEN
	NULL;
END;


    BEGIN
    -- Create the credential set HostCredsNormal
    l_host_set_cols.extend(2);
    l_host_set_cols(1) := MGMT_CRED_SET_COL_RECORD('HostUserName', 
                                                   'username',     
                                                   'UserName',
                                                   'CREDS_NORMAL_USER',
                                                   null);
                                                   
    l_host_set_cols(2) := MGMT_CRED_SET_COL_RECORD('HostPassword', 
                                                   'password',
                                                   'Password',
                                                   'CREDS_NORMAL_PASSWORD',
                                                   null);

    MGMT_CREDENTIAL.create_credential_set('host', '2.0',
                                          'HostCredsNormal',
                                          MGMT_CREDENTIAL.PREFCRED_SET_USAGE,
                                          MGMT_CREDENTIAL.TARGET_SET_CONTEXT_TYPE,
                                          null,
                                          'Normal Host Credentials',
                                          'CREDS_HOST_NORMAL',
                                          'HostCreds', l_host_set_cols);
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
        NULL;
    END;

    BEGIN
    -- Insert the credential set HostCredsPriv
    l_host_set_cols(1) := MGMT_CRED_SET_COL_RECORD('HostUserName', 
                                                   'username',     
                                                   'Privileged UserName',
                                                   'CREDS_PRIV_USER',
                                                   null);
                                                   
    l_host_set_cols(2) := MGMT_CRED_SET_COL_RECORD('HostPassword', 
                                                   'password',
                                                   'Privileged Password',
                                                   'CREDS_PRIV_PASSWORD',
                                                   null);

    MGMT_CREDENTIAL.create_credential_set('host', '2.0',
                                          'HostCredsPriv',
                                          MGMT_CREDENTIAL.PREFCRED_SET_USAGE,
                                          MGMT_CREDENTIAL.TARGET_SET_CONTEXT_TYPE,
                                          null,
                                          'Privileged Host Credentials',
                                          'CREDS_HOST_PRIV',
                                          'HostCreds', l_host_set_cols);
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
        NULL;
    END;

    BEGIN
    -- Create the credential set DBCredsNormal
    l_db_set_cols.extend(3);
    l_db_set_cols(1) := MGMT_CRED_SET_COL_RECORD('DBUserName', 
                                                 'username',   
                                                 'UserName',
                                                 'CREDS_NORMAL_USER',
                                                 null);
                                                 
    l_db_set_cols(2) := MGMT_CRED_SET_COL_RECORD('DBPassword', 
                                                 'password',
                                                 'Password',
                                                 'CREDS_NORMAL_PASSWORD',
                                                  null);

    l_db_set_cols(3) := MGMT_CRED_SET_COL_RECORD('DBRole', 
                                                 'role',
                                                 'Role',
                                                 'CREDS_NORMAL_ROLE',
                                                 null);

    MGMT_CREDENTIAL.create_credential_set('oracle_database', '3.0',
                                          'DBCredsNormal', 
                                          MGMT_CREDENTIAL.PREFCRED_SET_USAGE,
                                          MGMT_CREDENTIAL.TARGET_SET_CONTEXT_TYPE,
                                          null,
                                          'Normal Database Credentials',
                                          'CREDS_DATABASE_NORMAL',
                                          'DBCreds', l_db_set_cols);
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
        NULL;
    END;

    BEGIN
    -- Create the credential set DBCredsSYSDBA
    l_db_set_cols(1) := MGMT_CRED_SET_COL_RECORD('DBUserName', 
                                                 'sysDBAUserName',   
                                                 'SYSDBA UserName',
                                                 'CREDS_SYSDBA_USER',
                                                 null);
                                                 
    l_db_set_cols(2) := MGMT_CRED_SET_COL_RECORD('DBPassword', 
                                                 'sysDBAPassword',
                                                 'SYSDBA Password',
                                                 'CREDS_SYSDBA_PASSWORD',
                                                 null);

    l_db_set_cols(3) := MGMT_CRED_SET_COL_RECORD('DBRole', 
                                                 'sysDBARole',
                                                 'SYSDBA Role',
                                                 'CREDS_SYSDBA_ROLE',
                                                 null);

    MGMT_CREDENTIAL.create_credential_set('oracle_database', '3.0',
                                          'DBCredsSYSDBA', 
                                          MGMT_CREDENTIAL.PREFCRED_SET_USAGE,
                                          MGMT_CREDENTIAL.TARGET_SET_CONTEXT_TYPE,
                                          null,
                                          'SYSDBA Database Credentials',
                                          'CREDS_DATABASE_SYSDBA',
                                          'DBCreds', l_db_set_cols);
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
        NULL;
    END;

    BEGIN
    -- Create the credential set DBHostCreds
    l_db_host_set_cols.extend(2);
    l_db_host_set_cols(1) := MGMT_CRED_SET_COL_RECORD('HostUserName', 
                                                 'HostUsername',   
                                                 'Host UserName',
                                                 'CREDS_HOST_USER',
                                                 null);
                                                 
    l_db_host_set_cols(2) := MGMT_CRED_SET_COL_RECORD('HostPassword', 
                                                 'HostPassword',
                                                 'Host Password',
                                                 'CREDS_HOST_PASSWORD',
                                                  null);


    MGMT_CREDENTIAL.create_credential_set('oracle_database', '3.0',
                                          'DBHostCreds', 
                                          MGMT_CREDENTIAL.PREFCRED_SET_USAGE,
                                          MGMT_CREDENTIAL.TARGET_SET_CONTEXT_TYPE,
                                          null,
                                          'Database Host Credentials',
                                          'CREDS_HOST',
                                          'DBHostCreds', l_db_host_set_cols);
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
        NULL;
    END;

    BEGIN
    -- Create the credential set OHCreds
    l_oh_set_cols.extend(2);
    l_oh_set_cols(1) := MGMT_CRED_SET_COL_RECORD('HostUserName', 
                                                 'OHUsername',   
                                                 'Oracle Home User',
                                                 'CREDS_OH_USER',
                                                 null);
                                                 
    l_oh_set_cols(2) := MGMT_CRED_SET_COL_RECORD('HostPassword', 
                                                 'OHPassword',
                                                 'Oracle Home Password',
                                                 'CREDS_OH_PASSWORD',
                                                 null);


    MGMT_CREDENTIAL.create_credential_set('host', '2.0',
                                          'OHCreds', 
                                          MGMT_CREDENTIAL.PREFCRED_SET_USAGE,
                                          MGMT_CREDENTIAL.CONTAINER_SET_CONTEXT_TYPE,
                                          MGMT_CREDENTIAL.CONTAINER_TYPE_ORACLEHOME,
                                          'Oracle Home Credentials',
                                          'CREDS_OH',
                                          'HostCreds', l_oh_set_cols);
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
        NULL;
    END;

    -- Create the credential set ProvisionCreds
   BEGIN
    l_provision_set_cols.extend(4);
    l_provision_set_cols(1) := MGMT_CRED_SET_COL_RECORD('OMSRegistrationPassword',
                                                 'OMS_REGISTRATION_PASSWORD',
                                                 'OMS Registration Password',
                                                 'CREDS_OMS_REGISTRATION_PASSWORD',
                                                 null);

    l_provision_set_cols(2) := MGMT_CRED_SET_COL_RECORD('InstallUserName', 
                                                 'INSTALLUSERNAME',
                                                 'Install User',
                                                 'CREDS_INSTALL_USER',
                                                 null);
                                                 
    l_provision_set_cols(3) := MGMT_CRED_SET_COL_RECORD('InstallPassword', 
                                                 'INSTALLPASSWORD',
                                                 'Install Password',
                                                 'CREDS_INSTALL_PASSWORD',
                                                 null);

    l_provision_set_cols(4) := MGMT_CRED_SET_COL_RECORD('ProvCompPasswd',
                                                 'COMP_SECRET_PROPERTY',
                                                 'Comp secret  Password',
                                                 'CREDS_COMP_SECRET_PASSWORD',
                                                 null);



    MGMT_CREDENTIAL.create_credential_set('host', '2.0',
                                          'ProvisionCredsPref', 
                                          MGMT_CREDENTIAL.PREFCRED_SET_USAGE,
                                          MGMT_CREDENTIAL.CONTAINER_SET_CONTEXT_TYPE,
                                          MGMT_CREDENTIAL.CONTAINER_TYPE_ORACLEHOME,
                                          'Provisioning Credentials',
                                          'CREDS_PROVISION',
                                          'ProvisionCreds', l_provision_set_cols);
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
        NULL;
    END;

   BEGIN
   -- Create the credential set LsnrCreds
   l_lsnr_set_cols.extend(1);
   l_lsnr_set_cols(1) := MGMT_CRED_SET_COL_RECORD('Password', 
                                                 'password',   
                                                 'Listener password',
                                                 'CREDS_LISTENER_PASSWORD',
                                                 null);
   
    MGMT_CREDENTIAL.create_credential_set('oracle_listener', '1.0',
                                          'LsnrCreds', 
                                          MGMT_CREDENTIAL.PREFCRED_SET_USAGE,
                                          MGMT_CREDENTIAL.TARGET_SET_CONTEXT_TYPE,
                                          null,
                                          'Listener Credentials',
                                          'CREDS_OH',
                                          'LsnrCreds', l_lsnr_set_cols);
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
        NULL;
    END;
END;

END;
/
COMMIT;
-- create sudo pdp type
BEGIN
DECLARE
l_pdp_columns MGMT_PDP_COLUMN_META_ARRAY := MGMT_PDP_COLUMN_META_ARRAY();
l_pdp_settings MGMT_PDP_SETTING_META_ARRAY := MGMT_PDP_SETTING_META_ARRAY();
l_pdp_params MGMT_PDP_PARAM_META_ARRAY := MGMT_PDP_PARAM_META_ARRAY();
l_pdp MGMT_PDP_META;
BEGIN
NULL;
    l_pdp_columns.extend(1);
    l_pdp_columns(1) := MGMT_PDP_COLUMN_META.NEW(MGMT_CREDENTIAL.PDP_COLUMN_RUNAS,1);
    
    l_pdp_settings.extend(1);
    l_pdp_settings(1) := MGMT_PDP_SETTING_META.NEW(MGMT_CREDENTIAL.PDP_SUDO_SETTING,
                                                   MGMT_CREDENTIAL.PDP_SETTING_REQUIRED,
                                                   'PDP_SUDO_COMMAND_DESC',
                                                   'Sudo Command',
                                                   'PDP_SUDO_COMMAND_HINT_DESC',
                                                   'Sudo Command');   

    l_pdp_params.extend(4);
    l_pdp_params(1) := MGMT_PDP_PARAM_META.NEW(MGMT_CREDENTIAL.PDP_PARAM_COMMAND,
                                               'PDP_SUDO_COMMAND_DESC',
                                               'Command to be run.');

    l_pdp_params(2) := MGMT_PDP_PARAM_META.NEW(MGMT_CREDENTIAL.PDP_PARAM_USERNAME,
                                               'PDP_PARAM_USERNAME_DESC',
                                               'Name of the user running the command.');

    l_pdp_params(3) := MGMT_PDP_PARAM_META.NEW(MGMT_CREDENTIAL.PDP_PARAM_PASSWORD,
                                               'PDP_PARAM_PASSWORD_DESC',
                                               'Password of the user running the command.');

    l_pdp_params(4) := MGMT_PDP_PARAM_META.NEW(MGMT_CREDENTIAL.PDP_PARAM_RUNAS,
                                               'PDP_PARAM_RUNAS_DESC',
                                               'Run the command as this user.');


    l_pdp := MGMT_PDP_META.NEW(MGMT_CREDENTIAL.PDP_SUDO,
                               'HostCreds',
                               l_pdp_columns,
                               l_pdp_settings,
                               l_pdp_params); 
                               
    MGMT_CREDENTIAL.create_pdp_type(l_pdp); 

END;
END;
/



-- create powerbroker pdp type
BEGIN
DECLARE
l_pdp_columns MGMT_PDP_COLUMN_META_ARRAY := MGMT_PDP_COLUMN_META_ARRAY();
l_pdp_settings MGMT_PDP_SETTING_META_ARRAY := MGMT_PDP_SETTING_META_ARRAY();
l_pdp_params MGMT_PDP_PARAM_META_ARRAY := MGMT_PDP_PARAM_META_ARRAY();
l_pdp MGMT_PDP_META;
BEGIN
NULL;
    l_pdp_columns.extend(2);
    l_pdp_columns(1) := MGMT_PDP_COLUMN_META.NEW(MGMT_CREDENTIAL.PDP_COLUMN_RUNAS,1);
    l_pdp_columns(2) := MGMT_PDP_COLUMN_META.NEW(MGMT_CREDENTIAL.PDP_COLUMN_PROFILE,0);
    
    l_pdp_settings.extend(2);
    l_pdp_settings(1) := MGMT_PDP_SETTING_META.NEW(MGMT_CREDENTIAL.PDP_POWERBROKER_SETTING,
                                                   MGMT_CREDENTIAL.PDP_SETTING_REQUIRED,
                                                   'PDP_POWERBROKER_SETTING_DESC',
                                                   'Power Broker command.',
                                                   'PDP_POWERBROKER_SETTING_HINT_DESC',
                                                   'Power Broker command.');   
    l_pdp_settings(2) := MGMT_PDP_SETTING_META.NEW(MGMT_CREDENTIAL.PDP_PASSWORD_PROMPT_STRING,
                                                   MGMT_CREDENTIAL.PDP_SETTING_NOT_REQUIRED,
                                                   'PDP_POWERBROKER_PASSWORD_PROMPT_STRING_DESC',
                                                   'Power Broker command prompt.',
                                                   'PDP_POWERBROKER_PASSWORD_PROMPT_STRING_HINT_DESC',
                                                   'Power Broker command prompt.');   

    l_pdp_params.extend(5);
    l_pdp_params(1) := MGMT_PDP_PARAM_META.NEW(MGMT_CREDENTIAL.PDP_PARAM_COMMAND,
                                               'PDP_SUDO_COMMAND_DESC',
                                               'Command to be run.');

    l_pdp_params(2) := MGMT_PDP_PARAM_META.NEW(MGMT_CREDENTIAL.PDP_PARAM_USERNAME,
                                               'PDP_PARAM_USERNAME_DESC',
                                               'Name of the user running the command.');

    l_pdp_params(3) := MGMT_PDP_PARAM_META.NEW(MGMT_CREDENTIAL.PDP_PARAM_PASSWORD,
                                               'PDP_PARAM_PASSWORD_DESC',
                                               'Password of the user running the command.');

    l_pdp_params(4) := MGMT_PDP_PARAM_META.NEW(MGMT_CREDENTIAL.PDP_PARAM_RUNAS,
                                               'PDP_PARAM_RUNAS_DESC',
                                               'Run the command as this user.');

    l_pdp_params(5) := MGMT_PDP_PARAM_META.NEW(MGMT_CREDENTIAL.PDP_PARAM_PROFILE,
                                               'PDP_PARAM_PROFILE_DESC',
                                               'Use this profile to run the command.');

    l_pdp := MGMT_PDP_META.NEW(MGMT_CREDENTIAL.PDP_POWERBROKER,
                               'HostCreds',
                               l_pdp_columns,
                               l_pdp_settings,
                               l_pdp_params); 
                               
    MGMT_CREDENTIAL.create_pdp_type(l_pdp); 


END;
END;
/




-- register user model callbacks
BEGIN
    -- for templates                        
    MGMT_USER.add_callback('MGMT_TEMPLATE.get_user_templates', MGMT_USER.GET_USER_OBJECTS_CALLBACK);
    MGMT_USER.add_callback('MGMT_TEMPLATE.drop_user_templates', MGMT_USER.USER_DROPPED_CALLBACK);
    MGMT_USER.add_callback('MGMT_TEMPLATE.reassign_user_templates', MGMT_USER.USER_REASSIGN_CALLBACK);
    -- for targets          
    MGMT_USER.add_callback('MGMT_TARGET.get_user_targets', MGMT_USER.GET_USER_OBJECTS_CALLBACK);
    MGMT_USER.add_callback('MGMT_TARGET.drop_user_targets', MGMT_USER.USER_DROPPED_CALLBACK);
    MGMT_USER.add_callback('MGMT_TARGET.reassign_user_targets', MGMT_USER.USER_REASSIGN_CALLBACK);
END;
/
COMMIT;

-- Add a target addition callback to introduce host credentials on
-- target addition
BEGIN
    EMD_LOADER.add_target_addition_callback('EM_CREDENTIAL.add_host_credential_info');
EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN NULL;
END;
/
COMMIT;

BEGIN
    mgmt_log.register_logging_module (MGMT_SQLTRACE.EST_LOG_NAME, MGMT_SQLTRACE.EST_LOG_DISPLAY_NAME);
END;
/
COMMIT;

-- Add target meta version update callback to introduce default host credential sets
-- for met_ver updated targets Bug#5382567
BEGIN
  MGMT_TARGET.add_metaver_catprop_callback(
    p_callback_name => 'EM_CREDENTIAL.handle_target_metaver_update',
    p_target_type   => ' ');
EXCEPTION
  WHEN OTHERS THEN
    -- Ignore duplicate registrations
    dbms_output.put_line( 'EXCEPTION registering meta ver update callback for all targets other than host and db'|| SQLCODE );
    NULL;
END;
/
COMMIT;
