Rem drv: <create type="procs"/>
Rem
Rem $Header: sdk_procs.sql 17-jun-2005.06:35:31 kmanicka Exp $
Rem
Rem sdk_procs.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_procs.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    kmanicka    06/17/05 - oms based encryption key 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    dcawley     12/16/04 - Add opertions for invalidating contexts 
Rem    dcawley     09/01/03 - Add new ops 
Rem    dcawley     07/21/03 - Remove logon and logoff procedures
Rem    dcawley     06/14/02 - Add OP_LOGON
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Created
Rem

--
-- PURPOSE
--
--  Sets the user context for EM, calculates the security predicate and
--  builds caches of visible objects based on user's privilege set
--
-- PARAMETERS
-- 
--  EM_CLIENT_IN - the name of the EMD user
--
--  OP_IN - the operation to perform
--
--          OP_SET_IDENTIFIER - set the current user and build visible object
--                              caches if necessary
--          OP_CLEAR_IDENTIFIER - clear the current user 
--          OP_CLEAR_CONTEXT - clear the user's caches
--          OP_CLEAR_CONTEXTS - clear all caches
--          OP_CREATE_TARGET_CONTEXT - create the user's visible target cache
--          OP_CREATE_JOB_CONTEXT - create the user's visible job cache
--          OP_CREATE_TEMPLATE_CONTEXT - create the user's visible template 
--                                       cache
--          OP_CREATE_REPORT_DEF_CONTEXT - create the user's visible report 
--                                         definition cache
--          OP_CREATE_CA_CONTEXT - create the user's visible corrective action 
--                                 cache
--          OP_INVALIDATE_TARGET_CONTEXT - invalidate the user's visible target --                                         cache
--          OP_INVALIDATE_JOB_CONTEXT - invalidate the user's visible job cache
--          OP_INVALIDATE_TEMPLATE_CONTEXT - invalidate the user's visible 
--                                           template cache
--          OP_INVALIDATE_REPORT_CONTEXT - invalidate the user's visible report
--                                         definition cache
--          OP_INVALIDATE_CA_CONTEXT - invalidate the user's visible corrective --                                     action cache
--
-- NOTE:
--  This is very powerful and only the repository owner should be granted 
--  execute permission on it
--
CREATE OR REPLACE PROCEDURE SETEMUSERCONTEXT(em_client_in IN VARCHAR2,
                                             op_in        IN INTEGER,
                                             time_coff    IN VARCHAR2 DEFAULT NULL)
IS
BEGIN
 IF time_coff IS NOT NULL THEN
   MGMT_TIME_SYNC.setTimeCoff(time_coff);
 END IF;  
 
 MGMT_USER.SET_EM_USER_CONTEXT(em_client_in, op_in);
END;
/
show errors;

