Rem
Rem $Header: emcore/source/oracle/sysman/emdrep/sql/core/latest/sdk/sdk_schema_pkgbody.sql /st_emcore_10.2.0.4.2db11.2/1 2009/02/26 20:39:36 jsadras Exp $
Rem
Rem sdk_schema_pkgbody.sql
Rem
Rem Copyright (c) 2002, 2009, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      sdk_schema_pkgbody.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jsadras     11/19/08 - Fix perf issues
Rem    scgrover    07/12/06 - Backport scgrover_bug-5043773 from main
Rem    jsadras     08/17/05 - Bug:4548286 null violation type 
Rem    jsadras     03/10/05 - Bug:4215429, violation_type 
Rem    niramach    10/01/04 - Changing mgmt_severity -> mgmt_violations for 
Rem                           addSeverityAnnotation. 
Rem    jsadras     09/21/04 - eval_func replaced 
Rem    rpinnama    09/13/04 - mgmt_severity -> mgmt_violations 
Rem    streddy     08/10/04 - Add is_transposed to create_metric 
Rem    streddy     09/25/03 - Added type_meta_ver support for rep metric 
Rem    ancheng     09/24/03 - bug 3139898 
Rem    aholser     09/07/03 - fix add_table_metric_column 
Rem    ancheng     07/31/03 - add add_severity_annotation
Rem    streddy     07/11/03 - Add message_nlsid to add_severity
Rem    rpinnama    05/13/03 - Pass category props to add_metric procedures
Rem    streddy     03/03/03 - Added severity_eval_proc to add_metric API
Rem    sgrover     03/19/03 - remove variance, load_timestamp
Rem    njagathe    11/15/02 - Review comments
Rem    njagathe    11/15/02 - Increase size based on key_column widening
Rem    dcawley     09/23/02 - Add load_time parameter
Rem    rpinnama    05/16/02 - rpinnama_reorg_rep_scripts_2
Rem    rpinnama    05/16/02 - Created
Rem


----------------------
-- The package body --
----------------------
CREATE OR REPLACE PACKAGE BODY EMD_SCHEMA
IS

----------------------------------------------
-- Procedures for adding metric definitions --
----------------------------------------------

-- PURPOSE
--   Procedure to add a metric. 
PROCEDURE ADD_METRIC(v_target_type        IN VARCHAR2,
                     v_metric_name        IN VARCHAR2,
                     v_metric_type        IN NUMBER,
                     v_label              IN VARCHAR2 DEFAULT NULL,
                     v_description        IN VARCHAR2 DEFAULT ' ',
                     v_eval_proc          IN VARCHAR2 DEFAULT NULL,
                     v_unit               IN VARCHAR2 DEFAULT ' ',
                     v_short_name         IN VARCHAR2 DEFAULT NULL,
                     v_is_for_summary     IN NUMBER   DEFAULT 0,
                     v_label_nlsid        IN VARCHAR2 DEFAULT NULL,
	             v_is_transposed      IN NUMBER   DEFAULT 0)
IS
BEGIN

  -- Add metric with default version
  ADD_METRIC_FOR_VERSION(v_target_type, v_metric_name, v_metric_type, 
          '1.0', ' ', ' ', ' ', ' ', ' ', v_label, v_description, v_eval_proc, v_unit, 
	  v_short_name, v_is_for_summary, v_label_nlsid, v_is_transposed);

END ADD_METRIC;


-- PURPOSE
--   Procedure to add a metric (that supports metric versioning)
PROCEDURE ADD_METRIC_FOR_VERSION
                            (v_target_type        IN VARCHAR2,
                             v_metric_name        IN VARCHAR2,
                             v_metric_type        IN NUMBER,
                             v_type_meta_ver      IN VARCHAR2 DEFAULT '1.0',
                             v_category_prop_1    IN VARCHAR2 DEFAULT ' ',
                             v_category_prop_2    IN VARCHAR2 DEFAULT ' ',
                             v_category_prop_3    IN VARCHAR2 DEFAULT ' ',
                             v_category_prop_4    IN VARCHAR2 DEFAULT ' ',
                             v_category_prop_5    IN VARCHAR2 DEFAULT ' ',
                             v_label              IN VARCHAR2 DEFAULT NULL,
                             v_description        IN VARCHAR2 DEFAULT ' ',
                             v_eval_proc          IN VARCHAR2 DEFAULT NULL,
                             v_unit               IN VARCHAR2 DEFAULT ' ',
                             v_short_name         IN VARCHAR2 DEFAULT NULL,
                             v_is_for_summary     IN NUMBER   DEFAULT 0,
                             v_label_nlsid        IN VARCHAR2 DEFAULT NULL,
                             v_is_transposed      IN NUMBER   DEFAULT 0)
IS
  p_metric_guid MGMT_METRICS.metric_guid%TYPE;
BEGIN
  -- Generate the new metric guid. 
  p_metric_guid := dbms_obfuscation_toolkit.md5(
                          input => utl_raw.cast_to_raw(v_target_type ||
                            ';'|| v_metric_name));

  -- Insert into MGMT_METRICS.
  INSERT INTO MGMT_METRICS (target_type, metric_name, metric_guid, metric_type, 
                            type_meta_ver, category_prop_1, category_prop_2, 
			    category_prop_3, category_prop_4, category_prop_5, 
                            metric_label, description, unit, short_name, 
                            is_for_summary, source_type,source, eval_func,
                            metric_label_nlsid, is_transposed)
  VALUES (v_target_type, v_metric_name, p_metric_guid, v_metric_type, 
          v_type_meta_ver, v_category_prop_1, v_category_prop_2, v_category_prop_3,
	  v_category_prop_4, v_category_prop_5, v_label, v_description, v_unit, 
	  v_short_name, v_is_for_summary, MGMT_GLOBAL.G_METRIC_SOURCE_OLD_PLSQL,
          v_eval_proc, v_eval_proc, v_label_nlsid, v_is_transposed);

END ADD_METRIC_FOR_VERSION;


-- PURPOSE
--   Procedure to add a column to a table metric
PROCEDURE ADD_TABLE_METRIC_COLUMN(v_target_type        IN VARCHAR2,
                                  v_metric_name        IN VARCHAR2,
                                  v_metric_type        IN NUMBER,
                                  v_metric_column      IN VARCHAR2,
                                  v_is_key             IN NUMBER,
                                  v_label              IN VARCHAR2 DEFAULT NULL,
                                  v_description        IN VARCHAR2 DEFAULT ' ',
                                  v_unit               IN VARCHAR2 DEFAULT ' ',
                                  v_short_name         IN VARCHAR2 DEFAULT NULL,
                                  v_is_for_summary     IN NUMBER   DEFAULT 0,
                                  v_severity_eval_proc IN VARCHAR2 DEFAULT NULL,
                                  v_label_nlsid        IN VARCHAR2 DEFAULT NULL)
IS
  key_col MGMT_METRICS.key_column%TYPE;
  p_metric_guid RAW(16);
BEGIN

  -- Add table metric column for default version.
  ADD_METRIC_COLUMN_FOR_VERSION( v_target_type, v_metric_name, v_metric_type,
      v_metric_column, v_is_key, '1.0', ' ', ' ', ' ', ' ', ' ',
      v_label, v_description, v_unit, v_short_name, v_is_for_summary, v_severity_eval_proc,
      v_label_nlsid);

END ADD_TABLE_METRIC_COLUMN;


-- PURPOSE
--   Procedure to add a column to a table metric (supporting metric version)
PROCEDURE ADD_METRIC_COLUMN_FOR_VERSION
                                 (v_target_type        IN VARCHAR2,
                                  v_metric_name        IN VARCHAR2,
                                  v_metric_type        IN NUMBER,
                                  v_metric_column      IN VARCHAR2,
                                  v_is_key             IN NUMBER,
                                  v_type_meta_ver      IN VARCHAR2 DEFAULT '1.0',
                                  v_category_prop_1    IN VARCHAR2 DEFAULT ' ',
                                  v_category_prop_2    IN VARCHAR2 DEFAULT ' ',
                                  v_category_prop_3    IN VARCHAR2 DEFAULT ' ',
                                  v_category_prop_4    IN VARCHAR2 DEFAULT ' ',
                                  v_category_prop_5    IN VARCHAR2 DEFAULT ' ',
                                  v_label              IN VARCHAR2 DEFAULT NULL,
                                  v_description        IN VARCHAR2 DEFAULT ' ',
                                  v_unit               IN VARCHAR2 DEFAULT ' ',
                                  v_short_name         IN VARCHAR2 DEFAULT NULL,
                                  v_is_for_summary     IN NUMBER   DEFAULT 0,
                                  v_severity_eval_proc IN VARCHAR2 DEFAULT NULL,
                                  v_label_nlsid        IN VARCHAR2 DEFAULT NULL)
IS
  key_col MGMT_METRICS.key_column%TYPE;
  l_label_col VARCHAR(64);
  l_is_transposed MGMT_METRICS.is_transposed%TYPE;
  p_metric_guid MGMT_METRICS.metric_guid%TYPE;
BEGIN
  -- Generate the new metric guid. 
  p_metric_guid := dbms_obfuscation_toolkit.md5(
                          input => utl_raw.cast_to_raw(v_target_type ||
                            ';'|| v_metric_name ||';'|| v_metric_column));

  -- Check that the table has been added. A NO_DATA_FOUND exception will
  -- be thrown if the select statement does not return a row. If a key
  -- column has already been added, then it can be selected from the row 
  -- describing the table metric although it may just have the default value of ' '
  SELECT key_column,metric_label,is_transposed
    INTO key_col,l_label_col,l_is_transposed
    FROM mgmt_metrics 
  WHERE target_type = v_target_type 
    AND metric_name = v_metric_name 
    AND type_meta_ver = v_type_meta_ver
    AND category_prop_1 = v_category_prop_1
    AND category_prop_2 = v_category_prop_2
    AND category_prop_3 = v_category_prop_3
    AND category_prop_4 = v_category_prop_4
    AND category_prop_5 = v_category_prop_5
    AND metric_type IN (MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
                        MGMT_GLOBAL.G_METRIC_TYPE_REPOS_TABLE);

  -- If a key column is being added, then make sure a key column does not
  -- already exist
  IF v_is_key = 1
  THEN
    IF key_col <> ' '
    THEN
      raise_application_error(-20000, 'Key column already defined!');
    ELSE
      key_col := v_metric_column;
     
      -- Update any other columns with the name of the key column
      UPDATE mgmt_metrics SET key_column = v_metric_column
       WHERE target_type = v_target_type 
         AND metric_name = v_metric_name
         AND type_meta_ver = v_type_meta_ver
         AND category_prop_1 = v_category_prop_1
         AND category_prop_2 = v_category_prop_2
         AND category_prop_3 = v_category_prop_3
         AND category_prop_4 = v_category_prop_4
         AND category_prop_5 = v_category_prop_5;

    END IF;  
  END IF;
  
  -- Add the key column
  INSERT INTO MGMT_METRICS (target_type, metric_name, metric_type, metric_column,
                            metric_label,
                            metric_guid, type_meta_ver, category_prop_1, category_prop_2, 
			    category_prop_3, category_prop_4, category_prop_5, 
			    key_column, column_label, description,
                            unit, short_name, is_for_summary, source_type,source,
                            column_label_nlsid, is_transposed)
  VALUES (v_target_type, v_metric_name, v_metric_type, v_metric_column, 
          l_label_col,
          p_metric_guid, v_type_meta_ver, v_category_prop_1, v_category_prop_2, 
	  v_category_prop_3, v_category_prop_4, v_category_prop_5, 
	  key_col, v_label, v_description, v_unit, v_short_name, v_is_for_summary,
          MGMT_GLOBAL.G_METRIC_SOURCE_OLD_PLSQL,v_severity_eval_proc, v_label_nlsid, l_is_transposed);

EXCEPTION
  WHEN NO_DATA_FOUND
  THEN
    raise_application_error(-20000, 'You must call ADD_METRIC first!');

END ADD_METRIC_COLUMN_FOR_VERSION;




-- PURPOSE
--   Procedure to delete a metric
PROCEDURE DELETE_METRIC(v_target_type   IN VARCHAR2,
                        v_metric_name   IN VARCHAR2)
IS
  CURSOR metric_cursor IS
    SELECT metric_column, type_meta_ver
      FROM mgmt_metrics
     WHERE metric_name = v_metric_name
       AND target_type = v_target_type;

  l_metric_desc MGMT_METRIC_DESC;

  mguid RAW(16);
BEGIN

  BEGIN
    -- Get the metric type to see if this is a collection
    SELECT distinct metric_guid INTO mguid FROM MGMT_METRICS
    WHERE target_type = v_target_type 
      AND metric_name = v_metric_name 
      AND metric_type IN (MGMT_GLOBAL.G_METRIC_TYPE_REPOS_TABLE,
                          MGMT_GLOBAL.G_METRIC_TYPE_REPOS_NUMBER,
                          MGMT_GLOBAL.G_METRIC_TYPE_REPOS_STRING,
			  MGMT_GLOBAL.G_METRIC_TYPE_REPOS_EVENT);

  EXCEPTION
  WHEN OTHERS THEN NULL;
  END;

  -- Delete the metric dependencies if any
  FOR metric in metric_cursor 
  LOOP
     l_metric_desc := MGMT_METRIC_DESC.NEW(v_target_type, v_metric_name,
                                           metric.metric_column,
                                           metric.type_meta_ver);
     mgmt_target.delete_metric_severity_deps(l_metric_desc);
  END LOOP;

  DELETE FROM MGMT_METRICS
   WHERE target_type = v_target_type 
     AND metric_name = v_metric_name;

END DELETE_METRIC;

---------------------------------------
-- Procedures for adding metric data --
---------------------------------------

-- PURPOSE
--   Procedure to add a number value for a simple metric
PROCEDURE ADD_METRIC_DATA (v_target_name IN VARCHAR2,
                           v_target_type IN VARCHAR2,
                           v_metric_name IN VARCHAR2,
                           v_value       IN NUMBER,
                           v_timestamp   IN DATE DEFAULT SYSDATE)
IS
  tguid RAW(16);
  mguid RAW(16);
BEGIN

  SELECT target_guid INTO tguid FROM MGMT_TARGETS 
  WHERE target_name = v_target_name AND target_type = v_target_type; 

  SELECT distinct metric_guid INTO mguid FROM MGMT_METRICS
  WHERE target_type = v_target_type 
    AND metric_name = v_metric_name 
    AND metric_column = ' ' 
    AND key_column = ' '; 

  EMD_LOADER.ADD_METRIC_DATA(tguid, mguid, ' ', v_value, v_timestamp);

END ADD_METRIC_DATA;

-- PURPOSE
--   Procedure to add a string value for a simple metric
PROCEDURE ADD_METRIC_DATA (v_target_name   IN VARCHAR2,
                           v_target_type   IN VARCHAR2,
                           v_metric_name   IN VARCHAR2,
                           v_string_value  IN VARCHAR2,
                           v_timestamp     IN DATE DEFAULT SYSDATE)
IS
  tguid RAW(16);
  mguid RAW(16);
BEGIN

  SELECT target_guid INTO tguid FROM MGMT_TARGETS 
  WHERE target_name = v_target_name AND target_type = v_target_type; 

  SELECT distinct metric_guid INTO mguid 
    FROM MGMT_METRICS
  WHERE target_type = v_target_type 
    AND metric_name = v_metric_name 
    AND metric_column = ' ' 
    AND key_column = ' '; 

  EMD_LOADER.ADD_METRIC_DATA(tguid, mguid, ' ', v_string_value, v_timestamp);

END ADD_METRIC_DATA;

-- PURPOSE
--   Procedure to add a number value for a column in a table metric
PROCEDURE ADD_METRIC_DATA (v_target_name   IN VARCHAR2,
                           v_target_type   IN VARCHAR2,
                           v_metric_name   IN VARCHAR2,
                           v_metric_column IN VARCHAR2,
                           v_key_value     IN VARCHAR2 DEFAULT ' ',
                           v_value         IN NUMBER,
                           v_timestamp     IN DATE DEFAULT SYSDATE)
IS
  tguid RAW(16);
  mguid RAW(16);
BEGIN

  SELECT target_guid INTO tguid FROM MGMT_TARGETS 
  WHERE target_name = v_target_name AND target_type = v_target_type; 

  SELECT distinct metric_guid INTO mguid 
    FROM MGMT_METRICS
  WHERE target_type = v_target_type 
    AND metric_name = v_metric_name 
    AND metric_column = v_metric_column; 

  EMD_LOADER.ADD_METRIC_DATA(tguid, mguid, v_key_value, v_value, v_timestamp);

END ADD_METRIC_DATA;

-- PURPOSE
--   Procedure to add a string value for a column in a table metric
PROCEDURE ADD_METRIC_DATA (v_target_name   IN VARCHAR2,
                           v_target_type   IN VARCHAR2,
                           v_metric_name   IN VARCHAR2,
                           v_metric_column IN VARCHAR2,
                           v_key_value     IN VARCHAR2 DEFAULT ' ',
                           v_string_value  IN VARCHAR2,
                           v_timestamp     IN DATE DEFAULT SYSDATE)
IS
  tguid RAW(16);
  mguid RAW(16);
BEGIN

  SELECT target_guid INTO tguid FROM MGMT_TARGETS 
  WHERE target_name = v_target_name AND target_type = v_target_type; 

  SELECT distinct metric_guid INTO mguid 
    FROM MGMT_METRICS
  WHERE target_type = v_target_type 
    AND metric_name = v_metric_name 
    AND metric_column = v_metric_column; 

  EMD_LOADER.ADD_METRIC_DATA(tguid, mguid, v_key_value, v_string_value, v_timestamp);

END ADD_METRIC_DATA;

------------------------------------------------
-- Procedures for adding severity occurrences --
------------------------------------------------

-- PURPOSE
--   Procedure to add a warning severity occurrence for a simple metric
PROCEDURE ADD_WARNING_SEVERITY(v_target_name   IN VARCHAR2,
                               v_target_type   IN VARCHAR2,
                               v_metric_name   IN VARCHAR2,
                               v_severity_type IN NUMBER,
                               v_annotation    IN VARCHAR2,
                               v_message       IN VARCHAR2,
                               v_message_nlsid IN VARCHAR2 DEFAULT NULL,
                               v_message_params IN VARCHAR2 DEFAULT NULL)
IS
BEGIN

  ADD_SEVERITY(v_target_name, v_target_type, v_metric_name, ' ', ' ', 
               20, v_severity_type, v_annotation, v_message, 
               v_message_nlsid, v_message_params);

END ADD_WARNING_SEVERITY;

-- PURPOSE
--   Procedure to add a warning severity occurrence for a table metric
PROCEDURE ADD_WARNING_SEVERITY(v_target_name   IN VARCHAR2,
                               v_target_type   IN VARCHAR2,
                               v_metric_name   IN VARCHAR2,
                               v_metric_column IN VARCHAR2,
                               v_key_value     IN VARCHAR2 DEFAULT ' ',
                               v_severity_type IN NUMBER,
                               v_annotation    IN VARCHAR2,
                               v_message       IN VARCHAR2,
                               v_message_nlsid IN VARCHAR2 DEFAULT NULL,
                               v_message_params IN VARCHAR2 DEFAULT NULL)
IS
BEGIN

  ADD_SEVERITY(v_target_name, v_target_type, v_metric_name, v_metric_column, 
               v_key_value, 20, v_severity_type, v_annotation, v_message,
               v_message_nlsid, v_message_params);

END ADD_WARNING_SEVERITY;

-- PURPOSE
--   Procedure to add a critical severity occurrence for a simple metric
PROCEDURE ADD_CRITICAL_SEVERITY(v_target_name   IN VARCHAR2,
                                v_target_type   IN VARCHAR2,
                                v_metric_name   IN VARCHAR2,
                                v_severity_type IN NUMBER,
                                v_annotation    IN VARCHAR2,
                                v_message       IN VARCHAR2,
                                v_message_nlsid IN VARCHAR2 DEFAULT NULL,
                                v_message_params IN VARCHAR2 DEFAULT NULL)
IS
BEGIN

  ADD_SEVERITY(v_target_name, v_target_type, v_metric_name, ' ', ' ', 
               25, v_severity_type, v_annotation, v_message,
               v_message_nlsid, v_message_params);

END ADD_CRITICAL_SEVERITY;

-- PURPOSE
--   Procedure to add a critical severity occurrence for a table metric
--
-- PARAMETERS
--
-- NOTES
PROCEDURE ADD_CRITICAL_SEVERITY(v_target_name   IN VARCHAR2,
                                v_target_type   IN VARCHAR2,
                                v_metric_name   IN VARCHAR2,
                                v_metric_column IN VARCHAR2,
                                v_key_value     IN VARCHAR2,
                                v_severity_type IN NUMBER,
                                v_annotation    IN VARCHAR2,
                                v_message       IN VARCHAR2,
                                v_message_nlsid IN VARCHAR2 DEFAULT NULL,
                                v_message_params IN VARCHAR2 DEFAULT NULL)
IS
BEGIN

  ADD_SEVERITY(v_target_name, v_target_type, v_metric_name, v_metric_column, 
               v_key_value, 25, v_severity_type, v_annotation, v_message,
               v_message_nlsid, v_message_params);

END ADD_CRITICAL_SEVERITY;

-- PURPOSE
--   Procedure to add a severity clear occurrence for a simple metric
PROCEDURE ADD_SEVERITY_CLEAR(v_target_name   IN VARCHAR2,
                             v_target_type   IN VARCHAR2,
                             v_metric_name   IN VARCHAR2,
                             v_severity_type IN NUMBER,
                             v_annotation    IN VARCHAR2,
                             v_message       IN VARCHAR2,
                             v_message_nlsid IN VARCHAR2 DEFAULT NULL,
                             v_message_params IN VARCHAR2 DEFAULT NULL)
IS
BEGIN

    ADD_SEVERITY(v_target_name, v_target_type, v_metric_name, ' ', ' ', 
                 15, v_severity_type, v_annotation, v_message,
                 v_message_nlsid, v_message_params);

END ADD_SEVERITY_CLEAR;

-- PURPOSE
--   Procedure to add a severity clear occurrence for a table metric
PROCEDURE ADD_SEVERITY_CLEAR(v_target_name   IN VARCHAR2,
                             v_target_type   IN VARCHAR2,
                             v_metric_name   IN VARCHAR2,
                             v_metric_column IN VARCHAR2,
                             v_key_value     IN VARCHAR2,
                             v_severity_type IN NUMBER,
                             v_annotation    IN VARCHAR2,
                             v_message       IN VARCHAR2,
                             v_message_nlsid IN VARCHAR2 DEFAULT NULL,
                             v_message_params IN VARCHAR2 DEFAULT NULL)
IS
BEGIN

  ADD_SEVERITY(v_target_name, v_target_type, v_metric_name, v_metric_column, 
               v_key_value, 15, v_severity_type, v_annotation, v_message,
               v_message_nlsid, v_message_params);

END ADD_SEVERITY_CLEAR;

-- PURPOSE
--   Procedure to add a severity occurrence
PROCEDURE ADD_SEVERITY(v_target_name          IN VARCHAR2,
                       v_target_type          IN VARCHAR2,
                       v_metric_name          IN VARCHAR2,
                       v_metric_column        IN VARCHAR2,
                       v_key_value            IN VARCHAR2,
                       v_severity_code        IN NUMBER,
                       v_severity_type        IN NUMBER,
                       v_annotation           IN VARCHAR2,
                       v_message              IN VARCHAR2,
                       v_message_nlsid        IN VARCHAR2 DEFAULT NULL,
                       v_message_params       IN VARCHAR2 DEFAULT NULL)
IS
  tguid     RAW(16);
  mguid     RAW(16);
  sguid     RAW(16) := SYS_GUID();
  anno_flag NUMBER := 0;
  l_current_time DATE;
BEGIN

  SELECT target_guid ,
         MGMT_GLOBAL.SYSDATE_TZRGN(timezone_region)
   INTO tguid,
        l_current_time
   FROM MGMT_TARGETS 
  WHERE target_name = v_target_name AND 
        target_type = v_target_type; 

  SELECT distinct metric_guid INTO mguid FROM MGMT_METRICS
  WHERE target_type = v_target_type 
    AND metric_name = v_metric_name 
    AND metric_column = v_metric_column; 

  IF v_annotation IS NOT NULL
  THEN
    anno_flag := 1;
    add_severity_annotation(sguid,
                            v_annotation,
                            mgmt_user.get_current_em_user(),
                            l_current_time) ;
  END IF;  

  INSERT INTO mgmt_violations 
     (target_guid, key_value, policy_guid, violation_guid, 
      collection_timestamp, violation_level, 
      violation_type, annotated_flag, notification_status,  message,
      message_nlsid, message_params)
  VALUES 
     (tguid, v_key_value, mguid, sguid, 
      l_current_time, v_severity_code, 
      v_severity_type, anno_flag, 1, v_message,
      v_message_nlsid, v_message_params);

END ADD_SEVERITY;

-- PURPOSE
--   Procedure to add a severity annotation
PROCEDURE add_severity_annotation_ttzr(v_severity_guid   IN RAW,
                                       v_message         IN VARCHAR2,
                                       v_user_name       IN VARCHAR2 DEFAULT '<SYSTEM>',
                                       v_annotation_type IN VARCHAR2 DEFAULT NULL)
IS

  l_timezone_region mgmt_targets.timezone_region%TYPE;

BEGIN

  BEGIN
    SELECT tgt.timezone_region INTO l_timezone_region
      FROM mgmt_violations sev, mgmt_targets tgt
     WHERE sev.violation_guid = v_severity_guid
       AND sev.target_guid = tgt.target_guid;

    EXCEPTION
      WHEN NO_DATA_FOUND
        THEN raise;
  END;

  INSERT INTO mgmt_severity_annotation
    (severity_guid, collection_timestamp, annotation_type, user_name, message)
  VALUES
    (v_severity_guid, MGMT_GLOBAL.SYSDATE_TZRGN(l_timezone_region),
     v_annotation_type, v_user_name, v_message);

END;

-- PURPOSE
--   Procedure to add a severity annotation
PROCEDURE add_severity_annotation(v_severity_guid   IN RAW,
                                  v_message         IN VARCHAR2,
                                  v_user_name       IN VARCHAR2 DEFAULT '<SYSTEM>',
                                  v_timestamp       IN DATE DEFAULT SYSDATE,
                                  v_annotation_type IN VARCHAR2 DEFAULT NULL)
IS
BEGIN

  INSERT INTO mgmt_severity_annotation
    (severity_guid, collection_timestamp, annotation_type, user_name, message)
  VALUES
    (v_severity_guid, v_timestamp, v_annotation_type, v_user_name, v_message);

END;

---------------------------------------
-- Procedures for deleting metric data --
---------------------------------------

-- PURPOSE
--   Procedure to delete all data related to a given metric.
PROCEDURE DELETE_METRIC_DATA (v_target_name IN VARCHAR2,
                              v_target_type IN VARCHAR2,
                              v_metric_name IN VARCHAR2)
IS

  tguid     RAW(16);
  mguid     RAW(16);

BEGIN

  SELECT target_guid INTO tguid FROM MGMT_TARGETS
  WHERE target_name = v_target_name AND
        target_type = v_target_type;

  DELETE FROM mgmt_metrics_raw
   WHERE target_guid = tguid AND
         metric_guid IN 
             ( SELECT metric_guid 
                 FROM mgmt_metrics 
                WHERE target_type = v_target_type AND
                      metric_name = v_metric_name );

  DELETE FROM mgmt_metrics_1hour
   WHERE target_guid = tguid AND
         metric_guid IN 
             ( SELECT metric_guid 
                 FROM mgmt_metrics 
                WHERE target_type = v_target_type AND
                      metric_name = v_metric_name );

  DELETE FROM mgmt_metrics_1day
   WHERE target_guid = tguid AND
         metric_guid IN 
             ( SELECT metric_guid 
                 FROM mgmt_metrics 
                WHERE target_type = v_target_type AND
                      metric_name = v_metric_name );

END DELETE_METRIC_DATA;

END EMD_SCHEMA;
/
show errors

