Rem
Rem $Header: sdk_service_level_pkgbody.sql 18-aug-2006.04:01:08 skotha Exp $
Rem
Rem sdk_service_level_pkgbody.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_service_level_pkgbody.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    skotha      07/21/06 - Exposing get_services_sla_value 
Rem    skotha      07/21/06 - Created
Rem

CREATE OR REPLACE PACKAGE BODY MGMT_SERVICE_LEVEL AS

------------------------------------------------------------------------------
-- FUNCTION: GET_SERVICE_LEVEL_VALUE
------------------------------------------------------------------------------
--
-- PURPOSE
--   To compute the service level for a given service with in a given
--   time period.
-- RETURNS
--   Service Level value
-- PARAMETERS
--   p_service_name : Service name
--   p_service_type : Service type
--   p_start_time   : Start time (format 'MM-DD-YYYY HH24:MI:SS')
--   p_end_time     : End time (format 'MM-DD-YYYY HH24:MI:SS')
--   p_timezone     : Timezone
--
FUNCTION GET_SERVICE_LEVEL_VALUE(p_service_name IN VARCHAR2,
                                 p_service_type IN VARCHAR2,
                                 p_start_time   IN VARCHAR2,
                                 p_end_time     IN VARCHAR2,
                                 p_timezone     IN VARCHAR2)
RETURN NUMBER 
IS
    l_sla_computed        NUMBER;
    l_target_guid         MGMT_TARGETS.TARGET_GUID%TYPE;
    l_target_guid_array   TARGET_GUID_ARRAY;
    l_sla_array           SMP_EMD_NVPAIR_ARRAY;
    l_name_array          SMP_EMD_NVPAIR_ARRAY;
    l_sla_pie_array       PIE_TIME_RECORD_ARRAY;
    l_sla_expected_array  SMP_EMD_NVPAIR_ARRAY;
    
BEGIN
    -- Obtain TARGET_GUID for the given service and type
    l_target_guid := MGMT_SERVICE.GET_SERVICE_GUID(p_service_name, p_service_type);
    
    -- Call the method in dashboard_service package to compute sla
    l_target_guid_array := TARGET_GUID_ARRAY();
    l_target_guid_array.extend(1);
    l_target_guid_array(1) := l_target_guid;
    em_dashboard_service.get_services_sla_value(l_target_guid_array,
                              p_start_time, p_end_time, p_timezone,
                              l_sla_array, l_name_array, l_sla_pie_array,
                              l_sla_expected_array);
    
    l_sla_computed := l_sla_array(1).value;
    
    RETURN l_sla_computed;
    
END GET_SERVICE_LEVEL_VALUE;

END MGMT_SERVICE_LEVEL;
/
SHOW ERRORS;
