Rem
Rem $Header: sdk_service_pkgbody.sql 14-jul-2006.16:49:39 skkunise Exp $
Rem
Rem sdk_service_pkgbody.sql
Rem
Rem Copyright (c) 2002, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_service_pkgbody.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       skkunise 07/14/06 - Adding Business category 
Rem       gan      03/21/06 - Backport gan_bug-5049342 from main 
Rem       andyao   07/26/05 - fix bug 4518501, consume 
Rem                           P_USE_DEF_TEST_TYPE_THRESH 
Rem       gan      07/21/05 - depends on assoc property 
Rem       gan      06/21/05 - catch dup coll name exception (Rajagopal) 
Rem       yxie     05/25/05 - fix bug 4390544
Rem       mfidanbo 06/09/05 - call add_dummy_collection for test_based avail 
Rem       gan      05/02/05 - bug 4327079 
Rem       andyao   04/22/05 - remove deprecated CREATE_SERVICE api 
Rem       yxie     04/16/05 - remove membership association between service 
Rem                           and key components 
Rem       andyao   03/29/05 - add step/stepgroup threshold to create_service
Rem       gan      03/22/05 - check loop containment 
Rem       andyao   03/17/05 - add step thresholds/stepgroup thresholds 
Rem       ramalhot 03/13/05 - create service/ create aggregate service 
Rem                           modified 
Rem       gan      03/11/05 - use bulk assoc API 
Rem       rmarripa 02/21/05 - fix_test_based_avail
Rem       pmodi    02/23/05 - set default p_tz_rgn to NULL in 
Rem                           create_aggregate_service 
Rem       andyao   02/14/05 - fix bug 4126754 - CREATE SERVICE API should 
Rem                           promote default test promotion 
Rem       mfidanbo 02/07/05 - fix agent_url bug in create_service,. 
Rem       gan      02/08/05 - emcli error checking 
Rem       gan      02/04/05 - check agg svc type 
Rem       gan      01/20/05 - add set/remove system for agg svc 
Rem       ramalhot 01/18/05 - assoc_def_member --> assoc_def_contains 
Rem       mfidanbo 12/06/04 - user model changes 
Rem       gan      12/01/04 - delete dep detail 
Rem       rmarripa 11/23/04 - first associate beacons and then create txn 
Rem       rmarripa 11/29/04 - fix get_service_guid API 
Rem       jpyang   11/23/04 - fix get_service_guid to use type property 
Rem       rmarripa 11/03/04 - add GET_SVC_AVAIL_COMP_METHOD 
Rem       rmarripa 10/21/04 - associate beacons after creating test 
Rem       streddy  10/08/04 - Delete dependency update 
Rem       rmarripa 09/16/04 - repository only target should be default for 
Rem                           services 
Rem       streddy  10/03/04 - Service metric column name changes 
Rem       gan      09/17/04 - use add_repo_metric_collection 
Rem       gan      09/14/04 - add chart api 
Rem       rmarripa 09/11/04 - do not check for service targets in agg services 
Rem       rmarripa 09/11/04 - do not check for service targets in agg services 
Rem       rmarripa 08/20/04 - Add Leaf Level Service Backend APIs 
Rem       streddy  08/16/04 - streddy_agr_svc_apis
Rem       gan      08/13/04 - use assoc package var 
Rem    gan,streddy 08/10/04    Created
Rem

CREATE OR REPLACE PACKAGE BODY MGMT_SERVICE AS

-- Cursor to return targets' guid associated with p_target_name by 
-- p_assoc_type association

CURSOR assoc_targets_cur (p_target_name IN VARCHAR2, p_target_type IN VARCHAR2,
                      p_assoc_guid IN RAW) IS
     SELECT t.target_name, t.target_type 
     FROM  mgmt_target_assocs a, mgmt_targets tt,
           mgmt_targets t
     WHERE a.assoc_guid = p_assoc_guid
       AND a.source_target_guid = tt.target_guid
       AND tt.target_name = p_target_name 
       AND tt.target_type = p_target_type
       AND t.target_guid = a.assoc_target_guid;

-- Cursor to get all ancestor aggregate service for a target, start with the 
-- most close ancestor aggregate service
/*
CURSOR ancestor_services_cur (p_target_name IN VARCHAR2, 
                              p_target_type IN VARCHAR2) 
IS
   SELECT t.target_name
   FROM mgmt_target_assocs a, mgmt_target_assoc_defs d,
            mgmt_targets t, mgmt_target_properties p
   WHERE t.target_guid = a.source_target_guid
     AND a.assoc_guid = d.assoc_guid
     AND d.association_type = MGMT_ASSOC.ASSOC_TYPE_DEPENDS_ON
     AND t.target_type = MGMT_GLOBAL.G_GENERIC_SERVICE_TYPE
     AND t.target_guid = p.target_guid
     AND p.property_name = MGMT_GLOBAL.G_IS_AGGREGATE_SERVICE_PROP
     AND p.property_type = MGMT_GLOBAL.G_INSTANCE_PROP_TYPE
     AND p.property_value = '1'
   START WITH assoc_target_guid =  (SELECT target_guid 
                                      FROM mgmt_targets
                                      WHERE target_name = p_target_name
                                        AND target_type = p_target_type 
                                   )
   CONNECT BY PRIOR a.source_target_guid = a.assoc_target_guid;

*/

-- Forward declaration 
PROCEDURE SET_SYSTEM_FOR_AGG_SVC(p_agg_svc_name IN VARCHAR2,
                                 p_agg_svc_type IN VARCHAR2,
                                 p_system_name IN VARCHAR2,
                                 p_system_type IN VARCHAR2);
PROCEDURE REMOVE_SYSTEM_FROM_AGG_SVC(p_agg_service_name IN VARCHAR2,
                                     p_agg_service_type IN VARCHAR2);

---------------------------------PRIVATE PROCEDURES----------------------

--
-- CHECK_AGG_SVC_TYPE
--
PROCEDURE CHECK_AGG_SVC_TYPE(p_service_type IN VARCHAR2)
AS
l_is_agg NUMBER;
BEGIN
   l_is_agg := is_aggregate_service(p_service_type);
   IF l_is_agg = 0 THEN
      raise_application_error(mgmt_global.INVALID_AGG_SVC_TYPE_ERR,
                mgmt_global.INVALID_AGG_SVC_TYPE_ERR_M || ' '
                || p_service_type);
   END IF;
END CHECK_AGG_SVC_TYPE;
--
-- PURPOSE: Checks if the given target is a system and returns target_guid.
-- Exception: TARGET_DOES_NOT_EXISTS
--
FUNCTION GET_SYSTEM_GUID(p_service_name IN VARCHAR2, 
                          p_target_type IN VARCHAR2 )
RETURN RAW
IS
   l_system_guid RAW(16);
   l_is_service NUMBER := 0;
BEGIN
   
    l_system_guid := mgmt_target.get_target_guid(p_service_name, p_target_type); 
     
    --check for "is_system" instance property
    /*******
    RAJ TBD: This can not be enabled until is_system is implemented. 
    BEGIN
        SELECT DECODE(property_value, '1', 1, 0)
          INTO l_is_service
          FROM mgmt_target_properties
         WHERE target_guid = l_system_guid
           AND property_name = MGMT_GLOBAL.G_IS_SERVICE_PROP;
    EXCEPTION
        WHEN NO_DATA_FOUND THEN
            l_is_service := 0;
    END;
    
    IF ( l_is_service = 0 ) THEN 
        raise_application_error(MGMT_GLOBAL.TARGET_DOES_NOT_EXIST_ERR, 
                            MGMT_GLOBAL.TARGET_DOES_NOT_EXIST_ERR_M ||
                            p_service_name || ' (' || p_target_type || ')');
    END IF;
    */ 
    RETURN l_system_guid; 
END GET_SYSTEM_GUID;


--
-- PURPOSE: Creates a "Runs-on" association from service to system. This utility 
--  method does not check the validity of the system. This is a private procedure 
--  and caller of this procedure are performing checks in different places, before 
--  calling this procedure. 
-- PROCEDURE: ADD_SYSTEM_ASSOCIATION
-- IN PARAMETERS:
--    p_service_name: Name of the service
--    p_service_target_type: Service target type
--    p_system_name: Name of the system
--    p_system_type: Type of the system
--
PROCEDURE ADD_SYSTEM_ASSOCIATION( p_service_name IN VARCHAR2,
                                  p_service_type IN VARCHAR2,
                                  p_system_name IN VARCHAR2, 
                                  p_system_type IN VARCHAR2)
IS
BEGIN
   IF ( p_service_name IS NULL ) OR ( p_service_type IS NULL ) OR 
      (p_system_name IS NULL)  OR (p_system_type IS NULL ) THEN
       return;
   END IF;
   MGMT_ASSOC.create_target_assoc(MGMT_ASSOC.ASSOC_DEF_RUNS_ON,
                                   p_service_name,
                                   p_service_type,
                                   p_system_name,
                                   p_system_type);

END ADD_SYSTEM_ASSOCIATION; 

--
-- PURPOSE: internal procedure to delete the current system association
-- PROCEDURE: DELETE_SYSTEM_ASSOC
-- IN PARAMETERS:
--    p_service_name: Name of the service
--    p_service_type: Service target type
-- 
PROCEDURE DELETE_SYSTEM_ASSOC(p_service_name IN VARCHAR2,
                              p_service_type IN VARCHAR2)
IS
  l_system_name MGMT_TARGETS.target_name%TYPE;
  l_system_type MGMT_TARGETS.target_type%TYPE;

BEGIN
   -- remove any previous RUNS_ON assoc for service
   get_system(p_service_name, p_service_type, l_system_name, l_system_type);
   
   IF ( l_system_name IS NOT NULL ) AND ( l_system_type IS NOT NULL ) THEN 
       MGMT_ASSOC.delete_target_assoc(MGMT_ASSOC.ASSOC_DEF_RUNS_ON, 
                                      p_service_name,
                                      p_service_type, 
                                      l_system_name, 
                                      l_system_type);
   END IF;

EXCEPTION
  WHEN NO_DATA_FOUND THEN
   -- system not defined, treat this as a non-error case
    NULL;

END DELETE_SYSTEM_ASSOC;

--
-- PURPOSE: Creates a "Depends-on" association from service to critical 
--   components. This utility procedure does not check the validity 
--   (member of system and whether it has availability) of the critical 
--   components. This is a private procedure and caller of this procedure 
--   are performing checks in different places, before calling this procedure. 
-- PROCEDURE: ADD_CRITICAL_COMP_ASSOCIATION
-- 
-- IN PARAMETERS:
--    p_service_name: Name of the service
--    p_service_target_type: Service target type
--    p_critical_components: List of critical components
--
PROCEDURE ADD_CRITICAL_COMP_ASSOCIATION( p_service_name IN VARCHAR2,
                                         p_service_target_type IN VARCHAR2,
                                         p_critical_components IN SMP_EMD_NVPAIR_ARRAY
                                       ) 
IS
    l_component SMP_EMD_NVPAIR := NULL;
    l_comp_guid RAW(16);
BEGIN
    IF EMDW_LOG.P_IS_INFO_SET
    THEN
      EMDW_LOG.INFO('ADD_CRITICAL_COMP_ASSOCIATION: Enter', G_MODULE_NAME) ;
    END IF ;

    IF ( p_service_name IS NULL ) OR (p_service_target_type IS NULL ) THEN
        return;
    END IF;

    IF p_critical_components IS NOT NULL AND 
       p_critical_components.COUNT > 0 
    THEN
        FOR i IN p_critical_components.FIRST .. p_critical_components.LAST
        LOOP
            l_component := p_critical_components(i);
            IF l_component IS NOT NULL THEN
                l_comp_guid := mgmt_target.get_target_guid( 
                                     l_component.name, l_component.value); 
            END IF;
        END LOOP;
        mgmt_assoc.create_target_assocs(MGMT_ASSOC.ASSOC_DEF_DEPENDS_ON,
                                            p_service_name,
                                            p_service_target_type,
                                            p_critical_components);
        FOR i IN p_critical_components.FIRST .. p_critical_components.LAST
        LOOP
           mgmt_assoc.add_assoc_property(
                                     MGMT_ASSOC.ASSOC_DEF_DEPENDS_ON,
                                     p_service_name,
                                     p_service_target_type,
                                     p_critical_components(i).name,
                                     p_critical_components(i).value,
                                     mgmt_assoc.GLOBAL_SCOPE_TARGET_NAME,
                                     mgmt_assoc.GLOBAL_SCOPE_TARGET_TYPE,
                                     mgmt_service.G_SYSTEM_DEPENDS_ON_PROP,
                                     '1');
        END LOOP;
    END IF;

    IF EMDW_LOG.P_IS_INFO_SET
    THEN
      EMDW_LOG.INFO('ADD_CRITICAL_COMP_ASSOCIATION: Exit', G_MODULE_NAME) ;
    END IF ;

END ADD_CRITICAL_COMP_ASSOCIATION; 

--
-- PURPOSE: Deletes a "Depends-on" association from service to critical 
--   components. This utility procedure does not check the validity of 
--   the critical components. This is a private procedure and caller of 
--   this procedure are performing checks in different places, before 
--   calling this procedure. 
--   If p_critical_components list is NULL it will delete all Critical 
--   components. 
--
-- ASSUMPTION: All "Depends-on" associations are created by System only.
--   This procedure will remove all "Depends-on" associations from service. 
--   This is a safe assumption for Leaf level Services. This assumption will 
--   be invalid if a service has "Depends-On" association out side the scope 
--   of the "System". This procedure will be invoked whenever "System" is 
--   changed or removed. 
--
-- PROCEDURE: DELETE_CRITICAL_COMPONENTS
-- 
-- IN PARAMETERS:
--    p_service_name: Name of the service
--    p_service_target_type: Service target type
--
PROCEDURE DELETE_CRITICAL_COMPONENTS( p_service_name IN VARCHAR2,
                                      p_service_target_type IN VARCHAR2,
                                       p_critical_components IN SMP_EMD_NVPAIR_ARRAY)
IS
    l_assoc_targets SMP_EMD_NVPAIR_ARRAY := SMP_EMD_NVPAIR_ARRAY();
    l_tgt_guid MGMT_TARGETS.target_guid%TYPE;
    l_guid   RAW(16);
CURSOR assoc_targets_with_id_cur (p_target_name IN VARCHAR2, p_target_type IN VARCHAR2,
                      p_assoc_guid IN RAW) IS
     SELECT assoc_t.target_name, assoc_t.target_type, assoc_t.target_guid  
     FROM  mgmt_target_assocs a, mgmt_targets src_t,
           mgmt_targets assoc_t
     WHERE a.assoc_guid = p_assoc_guid
       AND a.source_target_guid = src_t.target_guid
       AND src_t.target_name = p_target_name 
       AND src_t.target_type = p_target_type
       AND assoc_t.target_guid = a.assoc_target_guid;


BEGIN
    IF EMDW_LOG.P_IS_INFO_SET
    THEN
      EMDW_LOG.INFO('DELETE_CRITICAL_COMPONENTS: Enter', G_MODULE_NAME) ;
    END IF ;

    IF ( p_service_name IS NULL ) OR (p_service_target_type IS NULL ) THEN
        return;
    END IF;
 
    BEGIN
        SELECT target_guid
          INTO l_tgt_guid
          FROM mgmt_targets 
         WHERE target_name = p_service_name
           AND target_type = p_service_target_type;
    EXCEPTION
        WHEN NO_DATA_FOUND THEN
            IF EMDW_LOG.P_IS_INFO_SET THEN
                EMDW_LOG.INFO(
                             'DELETE_CRITICAL_COMPONENTS: Exception NO_DATA_FOUND',
                                          G_MODULE_NAME) ;
                END IF ;
                raise_application_error(MGMT_GLOBAL.TARGET_DOES_NOT_EXIST_ERR,
                        MGMT_GLOBAL.TARGET_DOES_NOT_EXIST_ERR_M ||
                        p_service_name|| ' (' || p_service_target_type|| ')');
    END;

    IF ( ( p_critical_components IS NULL ) OR ( p_critical_components.COUNT <= 0 ) ) THEN 
        -- Get depends-on targets
        FOR sub_rec IN assoc_targets_with_id_cur (p_service_name,
                                         p_service_target_type,
                                         MGMT_ASSOC.g_depends_on_guid)
        LOOP
            -- Delete the metric dependencies
            em_rep_metric.delete_dependency_target(l_tgt_guid, sub_rec.target_guid );

        END LOOP;
        MGMT_ASSOC.delete_target_assocs(MGMT_ASSOC.ASSOC_DEF_DEPENDS_ON,
                                        p_service_name,
                                        p_service_target_type);


    ELSE
        FOR i IN p_critical_components.FIRST .. p_critical_components.LAST 
        LOOP
            l_guid := mgmt_target.get_target_guid( p_critical_components(i).name, 
                                p_critical_components(i).value ); 
            -- Delete the metric dependencies
            em_rep_metric.delete_dependency_target( l_tgt_guid, l_guid);

            MGMT_ASSOC.delete_target_assoc(MGMT_ASSOC.ASSOC_DEF_DEPENDS_ON,
                                           p_service_name,
                                           p_service_target_type,
                                           p_critical_components(i).name, 
                                           p_critical_components(i).value);
        END LOOP;
    END IF;

    IF EMDW_LOG.P_IS_INFO_SET
    THEN
      EMDW_LOG.INFO('DELETE_CRITICAL_COMPONENTS: Exit', G_MODULE_NAME) ;
    END IF ;

END DELETE_CRITICAL_COMPONENTS; 

--
-- PURPOSE: Updates critcal components of a service based on a given 
--  new set of critical components. Deletes the critical components 
--  associations, which are not in the new list and adds new critical 
--  components from the list. 
--  This utility procedure does not check the validity of 
--  the critical components. This is a private procedure and caller of 
--  this procedure are performing checks in different places, before 
--  calling this procedure. 
--
-- PROCEDURE: UPDATE_CRITICAL_COMPONENTS
-- 
PROCEDURE UPDATE_CRITICAL_COMPONENTS(p_service_target_name IN VARCHAR2, 
                                     p_service_target_type IN VARCHAR2, 
                                     p_new_critical_components IN SMP_EMD_NVPAIR_ARRAY)
IS
    -- cursor to get the new critical components to add
    CURSOR new_assoc_tgts (p_target_name IN VARCHAR2,
                       p_target_type IN VARCHAR2,
                       p_comps IN SMP_EMD_NVPAIR_ARRAY,
                       p_assoc_guid IN RAW) IS

    SELECT new_targets.new_tgt as new_tgt, new_targets.new_tgt_type as new_tgt_type
    FROM
    (
        SELECT distinct p_comps.name as new_tgt,
                        p_comps.value as new_tgt_type
          FROM
          (
              SELECT *
                FROM TABLE(CAST(p_comps AS SMP_EMD_NVPAIR_ARRAY))
          )p_comps
          MINUS
          SELECT assoc_t.target_name, assoc_t.target_type
            FROM  mgmt_target_assocs a, mgmt_targets src_t,
                  mgmt_targets assoc_t
           WHERE a.assoc_guid = p_assoc_guid
             AND src_t.target_name = p_target_name
             AND src_t.target_type = p_target_type
             AND a.source_target_guid = src_t.target_guid
             AND assoc_t.target_guid = a.assoc_target_guid
    ) new_targets;

    -- cursor to get the old critical components to delete
    CURSOR old_assoc_tgts (p_target_name IN VARCHAR2,
                       p_target_type IN VARCHAR2,
                       p_comps IN SMP_EMD_NVPAIR_ARRAY,
                       p_assoc_guid IN RAW) IS

    SELECT old_targets.old_tgt as old_tgt, old_targets.old_tgt_type as old_tgt_type
    FROM
    (
          SELECT assoc_t.target_name as old_tgt, assoc_t.target_type as old_tgt_type
            FROM  mgmt_target_assocs a, mgmt_targets src_t,
                  mgmt_targets assoc_t
           WHERE a.assoc_guid = p_assoc_guid
             AND src_t.target_name = p_target_name
             AND src_t.target_type = p_target_type
             AND a.source_target_guid = src_t.target_guid
             AND assoc_t.target_guid = a.assoc_target_guid
          MINUS
          SELECT distinct p_comps.name as tgt_name,
                          p_comps.value as tgt_type
          FROM
          (
              SELECT *
                FROM TABLE(CAST(p_comps AS SMP_EMD_NVPAIR_ARRAY))
          )p_comps
    ) old_targets;
    l_add_crit_comp_list SMP_EMD_NVPAIR_ARRAY := NULL;
    l_del_crit_comp_list SMP_EMD_NVPAIR_ARRAY := NULL;

BEGIN
    IF EMDW_LOG.P_IS_INFO_SET 
    THEN
      EMDW_LOG.INFO('update_critical_components: Enter', G_MODULE_NAME) ; 
    END IF ;

    IF ( p_service_target_name IS NULL ) OR (p_service_target_type IS NULL ) THEN
        return;
    END IF;

    IF ( p_new_critical_components IS NULL ) THEN 
        --delete all existing components. 
        delete_critical_components( p_service_target_name, p_service_target_type, NULL);
        return;
    END IF; 

    FOR sub_rec IN new_assoc_tgts (p_service_target_name, p_service_target_type,
                    p_new_critical_components, MGMT_ASSOC.g_depends_on_guid)
    LOOP
        IF ( l_add_crit_comp_list IS NULL )  THEN
            l_add_crit_comp_list := SMP_EMD_NVPAIR_ARRAY();
        END IF;
        l_add_crit_comp_list.extend;
        l_add_crit_comp_list(new_assoc_tgts%ROWCOUNT) :=
                      SMP_EMD_NVPAIR(sub_rec.new_tgt, sub_rec.new_tgt_type);
    END LOOP;

    IF ( l_add_crit_comp_list IS NOT NULL ) AND (l_add_crit_comp_list.COUNT > 0 ) THEN
        --add critical components
        add_critical_comp_association( p_service_target_name, p_service_target_type,
                                         l_add_crit_comp_list );
    END IF;

    FOR sub_rec IN old_assoc_tgts (p_service_target_name, p_service_target_type,
                    p_new_critical_components, MGMT_ASSOC.g_depends_on_guid)
    LOOP
        IF ( l_del_crit_comp_list IS NULL )  THEN
            l_del_crit_comp_list := SMP_EMD_NVPAIR_ARRAY();
        END IF;
        l_del_crit_comp_list.extend;
        l_del_crit_comp_list(old_assoc_tgts%ROWCOUNT) :=
                      SMP_EMD_NVPAIR(sub_rec.old_tgt, sub_rec.old_tgt_type);
    END LOOP;

    IF ( l_del_crit_comp_list IS NOT NULL ) AND (l_del_crit_comp_list.COUNT > 0 ) THEN
        --add critical components
        delete_critical_components( p_service_target_name, p_service_target_type,
                                         l_del_crit_comp_list );
    END IF;

    IF EMDW_LOG.P_IS_INFO_SET 
    THEN
      EMDW_LOG.INFO('update_critical_components: Exit', G_MODULE_NAME) ; 
    END IF ;
END UPDATE_CRITICAL_COMPONENTS;

--
--PURPOSE: add associations,
-- 
PROCEDURE add_sub_services_assoc(p_service_name IN VARCHAR2,
                           p_target_type IN VARCHAR2,
                           p_sub_services IN SMP_EMD_NVPAIR_ARRAY) AS
    l_sub_service SMP_EMD_NVPAIR;
    l_sub_service_guid RAW(16);
BEGIN
    IF EMDW_LOG.P_IS_INFO_SET 
    THEN
      EMDW_LOG.INFO('add_sub_services_assoc: Enter', G_MODULE_NAME) ; 
    END IF ;

    IF p_sub_services IS NOT NULL THEN
       -- check the existence of subservices
       FOR i IN p_sub_services.FIRST .. p_sub_services.LAST
       LOOP
         l_sub_service := p_sub_services(i);
         IF l_sub_service IS NOT NULL THEN
            --NOTE to GAN, STREDDY - regressions should use service targets for sub services 
            -- this call should check for service guid not just for target guid.
 
            l_sub_service_guid := mgmt_target.get_target_guid(l_sub_service.name,
                                                              l_sub_service.value); 
         END IF;
       END LOOP;
       MGMT_ASSOC.create_target_assocs(MGMT_ASSOC.ASSOC_DEF_DEPENDS_ON, 
                                       p_service_name, 
                                       p_target_type,
                                       p_sub_services);
       FOR i IN p_sub_services.FIRST .. p_sub_services.LAST
       LOOP
         mgmt_assoc.add_assoc_property(
                                     MGMT_ASSOC.ASSOC_DEF_DEPENDS_ON,
                                     p_service_name,
                                     p_target_type,
                                     p_sub_services(i).name,
                                     p_sub_services(i).value,
                                     mgmt_assoc.GLOBAL_SCOPE_TARGET_NAME,
                                     mgmt_assoc.GLOBAL_SCOPE_TARGET_TYPE,
                                     mgmt_service.G_SYSTEM_DEPENDS_ON_PROP,
                                     '1');
       END LOOP;
    END IF;

    IF EMDW_LOG.P_IS_INFO_SET 
    THEN
      EMDW_LOG.INFO('add_sub_services_assoc: Exit', G_MODULE_NAME) ; 
    END IF ;

END add_sub_services_assoc;

--
--PURPOSE: delete associations, 
--
PROCEDURE delete_sub_services_assoc(p_service_name IN VARCHAR2,
                           p_target_type IN VARCHAR2,
                           p_sub_services IN SMP_EMD_NVPAIR_ARRAY) AS
    l_sub_service SMP_EMD_NVPAIR;
    l_sub_service_guid RAW(16);
    l_service_guid RAW(16);
BEGIN
    IF EMDW_LOG.P_IS_INFO_SET 
    THEN
      EMDW_LOG.INFO('delete_sub_services_assoc: Enter', G_MODULE_NAME) ; 
    END IF ;

    IF p_sub_services IS NOT NULL THEN
       -- check the existence of sub-services
       FOR i IN p_sub_services.FIRST .. p_sub_services.LAST
       LOOP
         l_sub_service := p_sub_services(i);
         IF l_sub_service IS NOT NULL THEN
            --NOTE to GAN, STREDDY - regressions should use service targets for sub services 
            -- this call should check for service guid not just for target guid. 
            l_sub_service_guid := mgmt_target.get_target_guid( l_sub_service.name, l_sub_service.value); 
            l_service_guid := mgmt_target.get_target_guid(p_service_name,
                                                         p_target_type);
            MGMT_ASSOC.delete_target_assoc(MGMT_ASSOC.ASSOC_DEF_DEPENDS_ON, 
                                      p_service_name, 
                                      p_target_type,
                                      l_sub_service.name,
                                      l_sub_service.value);
            em_rep_metric.delete_dependency_target(l_service_guid,
                                                   l_sub_service_guid);
         END IF;
       END LOOP;
    END IF;
    IF EMDW_LOG.P_IS_INFO_SET 
    THEN
      EMDW_LOG.INFO('delete_sub_services_assoc: Exit', G_MODULE_NAME) ; 
    END IF ;

END delete_sub_services_assoc;

--
--PROCEDURE: CHECK_INVALID_CRIT_COMPS. This procedure should be called after making 
--           sure that the system target is valid. 
--PURPOSE: Check if the given set of critical components are member (recursively)
--         of System or not. A component is considered as a member of system 
--         even if it is a member of sub group of system.
-- IN PARAMETERS:
--    p_system_target_guid: Target guid of system target.
--    p_critical_components: List of critical components
-- OUT PARAMETERS: 
--    p_invalid_crit_components: List of critical components, which are not members 
--                               of given system. 
-- Exception:
--   MGMT_GLOBAL.INVALID_CRITICAL_COMPONENT_ERR: If critical components are not part of 
--     system or if they do not have availability state. 
--   
PROCEDURE CHECK_INVALID_CRIT_COMPS ( p_system_target_guid IN RAW,
                                  p_critical_components IN SMP_EMD_NVPAIR_ARRAY 
                                )
IS
    l_invalid_targets SMP_EMD_NVPAIR_ARRAY := NULL;
    l_err_msg VARCHAR2(1000) := NULL;
    l_msg VARCHAR2(256) := NULL;
    l_counter NUMBER := 0;
BEGIN

    IF EMDW_LOG.P_IS_INFO_SET 
    THEN
      EMDW_LOG.INFO('CHECK_INVALID_CRIT_COMPS: Enter', G_MODULE_NAME) ; 
    END IF ;
   
    --Ideally target_guid of the system shoul not be null. The caller of this procedure
    -- will call it only if the system target is valid. 
    IF (p_system_target_guid IS NULL ) OR 
       (p_critical_components IS NULL) OR 
       (p_critical_components.COUNT <= 0) THEN
        return;
    END IF;


    --Check for the existance of critical components in the system flat list 
    -- of associations. 
    SELECT SMP_EMD_NVPAIR(invalid_targets.invalid_tgt , invalid_targets.invalid_tgt_type)
      BULK COLLECT INTO l_invalid_targets
      FROM
      (
          SELECT distinct crit_comps.name as invalid_tgt, 
                          crit_comps.value as invalid_tgt_type
            FROM
            (
                SELECT * 
                  FROM TABLE(CAST(p_critical_components AS SMP_EMD_NVPAIR_ARRAY))
            )crit_comps
          MINUS
          SELECT dest.target_name as dest_target_name, 
                   dest.target_type as dest_target_type
            FROM  mgmt_flat_target_assoc flat, mgmt_targets dest
            WHERE flat.source_target_guid = p_system_target_guid
              AND flat.assoc_target_guid = dest.target_guid
      )invalid_targets;

    --Raise Application exception if there are invalid critical components
    IF ( l_invalid_targets IS NOT NULL ) AND (l_invalid_targets.COUNT > 0 ) THEN
        l_err_msg := MGMT_GLOBAL.INVALID_CRIT_COMPONENTS_ERR_M ; 
        FOR l_counter IN l_invalid_targets.FIRST..l_invalid_targets.LAST LOOP
            l_msg := '; '||l_invalid_targets(l_counter).name ||', '||
                          l_invalid_targets(l_counter).value;
            IF (LENGTH( CONCAT(l_err_msg, l_msg) ) > 950) THEN
                l_err_msg := CONCAT ( l_err_msg, '...');
                EXIT;
            END IF;
            l_err_msg := CONCAT(l_err_msg, l_msg);
        END LOOP;
        raise_application_error(MGMT_GLOBAL.INVALID_CRIT_COMPONENTS_ERR, l_err_msg);
    END IF;


    --Check if the critical components have availability by checking the
    -- existance of their MGMT_GLOBAL.G_AVAIL_METRIC_NAME(Response) and 
    -- MGMT_GLOBAL.G_AVAIL_METRIC_COLUMN (Status). 
    l_invalid_targets := NULL;

    SELECT SMP_EMD_NVPAIR(invalid_targets.invalid_tgt , invalid_targets.invalid_tgt_type)
      BULK COLLECT INTO l_invalid_targets
      FROM
      (
           SELECT DISTINCT crit_comps.name as invalid_tgt, crit_comps.value as invalid_tgt_type
             FROM
             (
                 SELECT * 
                   FROM TABLE(CAST(p_critical_components AS SMP_EMD_NVPAIR_ARRAY))
             )crit_comps
            WHERE crit_comps.value
            NOT IN 
                (
                    SELECT target_type 
                      FROM mgmt_metrics
                     WHERE metric_name = MGMT_GLOBAL.G_AVAIL_METRIC_NAME
                       AND metric_column = MGMT_GLOBAL.G_AVAIL_METRIC_COLUMN
                )
      )invalid_targets;

    --Raise Application exception if there are invalid critical components
    IF ( l_invalid_targets IS NOT NULL ) AND (l_invalid_targets.COUNT > 0 ) THEN
        l_err_msg := 'One or more critical components do not have '||
                       MGMT_GLOBAL.G_AVAIL_METRIC_NAME ||', '||
                       MGMT_GLOBAL.G_AVAIL_METRIC_COLUMN ||' metric';

        FOR l_counter IN l_invalid_targets.FIRST..l_invalid_targets.LAST LOOP
            l_msg := '; '||l_invalid_targets(l_counter).name ||', '||
                          l_invalid_targets(l_counter).value;
            IF (LENGTH( CONCAT(l_err_msg, l_msg) ) > 950) THEN
                l_err_msg := CONCAT ( l_err_msg, '...');
                EXIT;
            END IF;
            l_err_msg := CONCAT(l_err_msg, l_msg);
        END LOOP;
        raise_application_error(MGMT_GLOBAL.INVALID_CRIT_COMPONENTS_ERR, l_err_msg);
    END IF;


    IF EMDW_LOG.P_IS_INFO_SET 
    THEN
      EMDW_LOG.INFO('CHECK_INVALID_CRIT_COMPS: Exit', G_MODULE_NAME) ; 
    END IF ;


END CHECK_INVALID_CRIT_COMPS;


--PROCEDURE: SET_SVC_AVAIL_COMP_TGT_PROP
--PURPOSE: Sets the Service target instance property G_AVAIL_COMPUTATION_MECH 
-- (service_avail_comp_mechanism) to the given availability computation 
-- mechanism. 
-- IN PARAMETERS:
-- p_service_guid: Service Target guid
-- p_avail_comp: Availability computataion mechanism. Only Test based and 
-- system based availability are supported. 
-- EXCEPTION:
--  INVALID_SVC_AVAIL_COMP_ERR
--
PROCEDURE SET_SVC_AVAIL_COMP_TGT_PROP( p_service_guid IN RAW, 
                                        p_avail_comp IN VARCHAR2)
IS
BEGIN
    IF EMDW_LOG.P_IS_INFO_SET THEN
       EMDW_LOG.INFO('set_service_avail_tgt_prop: Enter', G_MODULE_NAME) ; 
    END IF;

    IF ( p_service_guid IS NULL ) THEN
        RETURN;
    END IF;

    IF (p_avail_comp IS NULL ) OR ( (p_avail_comp != G_TEST_BASED_AVAIL_COMP ) AND 
         (p_avail_comp != G_SYSTEM_BASED_AVAIL_COMP ) )THEN 
        raise_application_error(MGMT_GLOBAL.INVALID_SVC_AVAIL_COMP_ERR,
                        MGMT_GLOBAL.INVALID_SVC_AVAIL_COMP_ERR_M ||
                        p_avail_comp );
    END IF;


    UPDATE MGMT_TARGET_PROPERTIES
       SET property_value = p_avail_comp
     WHERE target_guid = p_service_guid
       AND property_name = G_AVAIL_COMPUTATION_MECH
       AND property_type = MGMT_GLOBAL.G_INSTANCE_PROP_TYPE;
    IF SQL%NOTFOUND THEN
        INSERT INTO MGMT_TARGET_PROPERTIES(target_guid, property_name,
                property_type, property_value) 
              VALUES ( p_service_guid, 
                           G_AVAIL_COMPUTATION_MECH, MGMT_GLOBAL.G_INSTANCE_PROP_TYPE, p_avail_comp);
    END IF;

    IF EMDW_LOG.P_IS_INFO_SET 
    THEN
       EMDW_LOG.INFO('set_service_avail_tgt_prop: Exit', G_MODULE_NAME) ; 
    END IF;
END SET_SVC_AVAIL_COMP_TGT_PROP;

--PROCEDURE: REMOVE_TEST_BASED_AVAIL
--PURPOSE: Removes the test availability computation from beacon availability
-- computation job. 
--
PROCEDURE REMOVE_TEST_BASED_AVAIL(p_service_target_name IN VARCHAR2, p_service_target_type IN VARCHAR2)
IS
    l_service_guid RAW(16);
    l_current_user       VARCHAR2(256) := mgmt_user.get_current_em_user();
BEGIN
    IF EMDW_LOG.P_IS_INFO_SET 
    THEN
       EMDW_LOG.INFO('remove_test_based_avail: Enter', G_MODULE_NAME) ; 
    END IF ;
 
    IF ( p_service_target_name IS NULL ) OR (p_service_target_type IS NULL ) THEN
        RETURN;
    END IF;

    l_service_guid := mgmt_service.get_service_guid(p_service_target_name, p_service_target_type);
    
    IF( MGMT_USER.has_priv (  l_current_user, MGMT_USER.OPERATOR_TARGET, l_service_guid) = MGMT_USER.USER_DOES_NOT_HAVE_PRIV ) THEN
      raise_application_error(MGMT_GLOBAL.INSUFFICIENT_PRIVILEGES_ERR,
        'MGMT_GENSVC.REMOVE_TEST_BASED_AVAIL: The current user (' 
        || l_current_user || 
        ') does not have sufficient privileges to perform this operation');
    END IF;
    
    mgmt_gensvc_avail.disable_avail(p_service_target_name, p_service_target_type);
     -- Deletes the target instance property G_AVAIL_COMPUTATION_MECH 
     -- (service_avail_comp_mechanism)
    DELETE 
      FROM MGMT_TARGET_PROPERTIES
     WHERE target_guid = l_service_guid
       AND property_name = MGMT_SERVICE.G_AVAIL_COMPUTATION_MECH
       AND property_type = MGMT_GLOBAL.G_INSTANCE_PROP_TYPE
       AND property_value = G_TEST_BASED_AVAIL_COMP;

   -- remove the dummy collection associated with test_availability
   BEGIN
    EM_REP_METRIC.DELETE_DUMMY_COLLECTION(p_service_target_name,
                                          p_service_target_type,
                                          MGMT_GLOBAL.G_AVAIL_METRIC_NAME,
                                          MGMT_GLOBAL.G_AVAIL_METRIC_COLUMN,
                                          ' ');
    EXCEPTION
      WHEN NO_DATA_FOUND THEN
        NULL;
  END;             

   IF EMDW_LOG.P_IS_INFO_SET 
   THEN
      EMDW_LOG.INFO('remove_test_based_avail: Exit', G_MODULE_NAME) ; 
   END IF ;
END REMOVE_TEST_BASED_AVAIL;


-- TBD RAJ: THIS SHOULD BE A PRIVATE PROCEDURE 
--TBD RAJ: Signature of this procedure may change after multiple test 
-- availability implementation.
--
-- PROCEDURE: setup_test_based_avail
-- PURPOSE: setup test based availability for Service. This procedure consumes 
--  list of availability tests and availability beacons from corresponding tables 
--  and registers with Test based availability. Before calling this procedure 
--  availability tests and beacons shoudl be specified using corresponding APIs. 
-- IN PARAMETERS:
--    p_service_target_name: Name of the service
--    p_target_target_type: type name
-- OUT PARAMETERS: none
-- Exception:
--   TARGET_DOES_NOT_EXIST: if the service does not exist
--   
PROCEDURE SETUP_TEST_BASED_AVAIL(p_service_target_name IN VARCHAR2, 
                                 p_service_target_type IN VARCHAR2,
                                 p_avail_eval_func IN VARCHAR2 )
IS
    CURSOR key_tests(tgt_id RAW) IS
        SELECT txn_guid, name, txn_type, is_representative, state
          FROM mgmt_bcn_Txn_defn 
         WHERE target_guid = tgt_id;
    CURSOR key_beacons(tgt_id RAW) IS
        SELECT tgt.target_name as bcn_name
          FROM mgmt_bcn_target bcn, mgmt_targets tgt
         WHERE bcn.target_guid = tgt_id
           AND bcn.beacon_target_guid = tgt.target_guid
           AND bcn.participates_avail = 'Y' 
           AND tgt.target_type = mgmt_global.G_BEACON_TARGET_TYPE;
    l_service_guid   RAW(16);
    l_metric_guid   RAW(16);
    l_txn_name mgmt_bcn_txn_defn.NAME%TYPE;
    l_key_test_list     MGMT_GENSVC_AV_TEST_ARRAY := null;
    l_key_bcn_list      MGMT_GENSVC_TGT_NAME_ARRAY := null;
    l_key_test          MGMT_GENSVC_AV_TEST;
    l_met_name          VARCHAR2(64) := null;
    l_met_col           VARCHAR2(64) := null;
    l_state             NUMBER;
    l_avail             NUMBER;
    l_avail_eval        NUMBER;
    l_current_user       VARCHAR2(256) := mgmt_user.get_current_em_user();
BEGIN
    IF EMDW_LOG.P_IS_INFO_SET 
    THEN
       EMDW_LOG.INFO('setup_test_based_avail: Enter', G_MODULE_NAME) ; 
    END IF;


    IF ( p_service_target_name IS NULL ) OR (p_service_target_type IS NULL ) THEN
        RETURN;
    END IF;

    --NOTE to GAN, STREDDY - regressions should use service targets for sub services 
    -- this call should check for service guid not just for target guid. 
    l_service_guid := mgmt_target.get_target_guid(p_service_target_name, p_service_target_type);
    l_metric_guid := mgmt_target.get_metric_guid(p_service_target_type, 
                       MGMT_GLOBAL.G_AVAIL_METRIC_NAME, MGMT_GLOBAL.G_AVAIL_METRIC_COLUMN);

    IF ( l_metric_guid IS NULL ) THEN 
        raise_application_error(MGMT_GLOBAL.INVALID_TARGET_ERR,
           MGMT_GLOBAL.INVALID_TARGET_ERR_M || p_service_target_name || ', ' || p_service_target_type || '. '||MGMT_GLOBAL.G_AVAIL_METRIC_NAME || '/' ||MGMT_GLOBAL.G_AVAIL_METRIC_COLUMN || ' metric not found. ');
    END IF;

    IF( MGMT_USER.has_priv (  l_current_user, MGMT_USER.OPERATOR_TARGET, l_service_guid) = MGMT_USER.USER_DOES_NOT_HAVE_PRIV ) THEN
      raise_application_error(MGMT_GLOBAL.INSUFFICIENT_PRIVILEGES_ERR,
        'MGMT_GENSVC.REMOVE_TEST_BASED_AVAIL: The current user (' 
        || l_current_user || 
        ') does not have sufficient privileges to perform this operation');
    END IF;

    --Register key tests and beacons with availability framework
    --prepare key beacon list
    FOR sub_rec in key_beacons(l_service_guid) 
    LOOP
        IF ( l_key_bcn_list IS NULL ) THEN
            l_key_bcn_list := MGMT_GENSVC_TGT_NAME_ARRAY();
        END IF;
        l_key_bcn_list.extend;
        l_key_bcn_list(key_beacons%ROWCOUNT) := sub_rec.bcn_name;
    END LOOP;

    --prepare key test list
    FOR sub_rec in key_tests(l_service_guid) 
    LOOP
        IF ( l_key_test_list IS NULL ) THEN
            l_key_test_list := MGMT_GENSVC_AV_TEST_ARRAY();
        END IF;
        l_key_test_list.extend;
        mgmt_test_metadata_read.get_avail_metric(sub_rec.txn_type, l_met_name, l_met_col );

        IF ( sub_rec.state = 'M' ) THEN 
            l_state := 1;
        ELSE
            l_state := 0;
        END IF;

        IF ( sub_rec.is_representative = 'Y' ) THEN 
            l_avail := 1;
        ELSE
            l_avail := 0;
        END IF;

        l_key_test := MGMT_GENSVC_AV_TEST(sub_rec.name, sub_rec.txn_type, 
                            l_met_name, l_met_col, l_avail, l_state ); 
        l_key_test_list(key_tests%ROWCOUNT) := l_key_test;
    END LOOP;

    IF( p_avail_eval_func = mgmt_severity_helper.g_or_avail_eval_proc_name ) THEN 
        l_avail_eval := mgmt_gensvc_avail.k_or_eval;
    ELSIF ( p_avail_eval_func = mgmt_severity_helper.g_and_avail_eval_proc_name ) THEN 
        l_avail_eval := mgmt_gensvc_avail.k_and_eval;
    ELSE
        l_avail_eval := mgmt_gensvc_avail.k_and_eval;
    END IF;
 
    IF ( l_key_test_list  IS NULL ) THEN 
            raise_application_error(MGMT_GLOBAL.INVALID_TARGET_ERR,
               MGMT_GLOBAL.INVALID_TARGET_ERR_M || p_service_target_name || ', ' || p_service_target_type || '. '||MGMT_GLOBAL.G_AVAIL_METRIC_NAME || '/' ||MGMT_GLOBAL.G_AVAIL_METRIC_COLUMN || ' Availability transaction not defined. ');
    END IF;

    mgmt_gensvc_avail.enable_avail( p_service_target_name, p_service_target_type,
          l_key_test_list, l_key_bcn_list, l_avail_eval) ;

    --Set service availability computation target property to test
    --based availability.
    set_svc_avail_comp_tgt_prop(l_service_guid, G_TEST_BASED_AVAIL_COMP);

    -- Recompute the beacon availability of the target.

  -- no matter the service is test or system based
  -- it will have an availability_metric for which we need to add
  -- a dummy collection. 

  BEGIN
    em_rep_metric.add_dummy_collection(p_service_target_name,
                                       p_service_target_type,
                                       MGMT_GLOBAL.G_AVAIL_METRIC_NAME,
                                       MGMT_GLOBAL.G_AVAIL_METRIC_COLUMN,
                                       ' ');
    EXCEPTION
      WHEN DUP_VAL_ON_INDEX OR mgmt_global.key_already_exists THEN
         -- Ingore duplicate entries
        NULL;
  END;             

   IF EMDW_LOG.P_IS_INFO_SET 
   THEN
      EMDW_LOG.INFO('setup_test_based_avail: Exit', G_MODULE_NAME) ; 
   END IF ;

END SETUP_TEST_BASED_AVAIL;

--PROCEDURE: DEL_ALL_SYS_BASED_DEP_METRICS
-- PURPOSE: Deletes all system based aggregated metrics. This procedure will only
-- delete the dependency metrics. It will not delete the source (aggregate) metric
PROCEDURE DEL_ALL_SYS_BASED_DEP_METRICS( p_service_target_name IN VARCHAR2,
                                            p_service_target_type IN VARCHAR2 )
IS 
    l_sys_guid mgmt_targets.target_guid%TYPE;
    l_sys_name mgmt_targets.target_name%TYPE;
    l_sys_type mgmt_targets.target_type%TYPE;
    l_svc_guid mgmt_targets.target_guid%TYPE;
BEGIN
    l_svc_guid := get_service_guid(p_service_target_name, p_service_target_type);
    get_system(p_service_target_name, p_service_target_type, l_sys_name, l_sys_type);
    l_sys_guid := mgmt_target.get_target_guid(l_sys_name, l_sys_type);
    
    FOR sub_rec IN (
                    SELECT distinct tgt.target_name, tgt.target_type, tgt.target_guid
                      FROM mgmt_targets tgt, mgmt_flat_target_assoc flat,
                           mgmt_metric_dependency_details dep
                     WHERE flat.source_target_guid = l_sys_guid
                       AND dep.target_guid = l_svc_guid
                       AND flat.assoc_target_guid = dep.dep_target_guid
                       AND tgt.target_guid = dep.dep_target_guid 
                   ) 
    LOOP
       em_rep_metric.delete_dependency_target(l_svc_guid,  sub_rec.target_guid );
    END LOOP;

END DEL_ALL_SYS_BASED_DEP_METRICS;

--------------------END PRIVATE FUNCTION --------------------------------------
--
-- PURPOSE: Checks if the given target is a service and returns target_guid.
-- Exception: TARGET_DOES_NOT_EXISTS
--
FUNCTION GET_SERVICE_GUID(p_service_name IN VARCHAR2, 
                          p_target_type IN VARCHAR2 ) 
   RETURN RAW
IS
   l_service_guid RAW(16);
   l_is_service NUMBER := 0;
BEGIN
  
    l_service_guid := mgmt_target.get_target_guid(p_service_name, p_target_type);
    --Check for "is_service" instance property
    BEGIN
        SELECT DECODE(property_value, '1', 1, 0)
          INTO l_is_service
          FROM mgmt_type_properties
         WHERE target_type = p_target_type 
           AND property_name = MGMT_GLOBAL.G_IS_SERVICE_PROP;
    EXCEPTION
        WHEN NO_DATA_FOUND THEN
            l_is_service := 0;
    END;
    
    IF ( l_is_service = 0 ) THEN 
        raise_application_error(MGMT_GLOBAL.TARGET_DOES_NOT_EXIST_ERR, 
                            MGMT_GLOBAL.TARGET_DOES_NOT_EXIST_ERR_M ||
                            p_service_name || ' (' || p_target_type || ')');
    END IF; 
    RETURN l_service_guid; 
END GET_SERVICE_GUID;

-- PROCEDURE ADD_SVC_TO_AGENT (internal)
-- This procedure adds the target instance specified by target_name,
-- target_type to agent. AddTargetJob is used to submit the job.

PROCEDURE ADD_SVC_TO_AGENT (p_target_name IN VARCHAR2, 
                            p_target_type IN VARCHAR2)

IS
  l_operation_guid     RAW(16);
  l_job_targets        MGMT_JOB_TARGET_LIST;
  l_job_target_list    MGMT_JOB_TARGET_LIST_ARRAY;
  l_job_params         MGMT_JOB_PARAM_LIST;
  l_job_name           MGMT_JOB.job_name%TYPE;
  l_job_id             MGMT_JOB.job_id%TYPE;
  l_execution_ids      MGMT_JOB_GUID_ARRAY;
  l_queue_names        SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
  l_schedule           MGMT_JOB_SCHEDULE_RECORD; 
  l_count              INTEGER;
BEGIN

  -- Submit add target job to agent
  l_job_targets := MGMT_JOB_TARGET_LIST();
  l_job_targets.EXTEND(1);
  l_job_targets(1) := MGMT_JOB_TARGET_RECORD(p_target_name, 
                                             p_target_type);
  l_job_target_list := MGMT_JOB_TARGET_LIST_ARRAY();
  l_job_target_list.EXTEND(1);
  l_job_target_list(1) := l_job_targets;

  l_operation_guid := SYS_GUID();
  l_job_name := 'ADD_TARGET_JOB' || l_operation_guid;
  
  l_job_params := MGMT_JOB_PARAM_LIST();
  l_job_params.extend(3);
  l_job_params(1) := MGMT_JOB_PARAM_RECORD('job_target_names', 1, 
                                           p_target_name, null);
  l_job_params(2) := MGMT_JOB_PARAM_RECORD('job_target_types', 1, 
                                           p_target_type, null);
  l_job_params(3) := MGMT_JOB_PARAM_RECORD('add_member_info', 1, 
                                           'F', null);

  l_schedule := null;  

  -- Create the queue if not already created
  l_queue_names.extend(1);
  l_queue_names(1) := 'ADD_TARGET_JOB' || p_target_name || ' ' || p_target_type;
  SELECT count(1) INTO l_count
    FROM MGMT_JOB_QUEUES
   WHERE queue_name = l_queue_names(1);

  IF l_count=0 THEN
    MGMT_JOB_ENGINE.create_job_queue(l_queue_names(1));
  END IF;

  -- Submit the job
  MGMT_JOBS.submit_job( l_job_name,
                        'Add target instance to agent.', 
                        0,
                        'AddTargetJob',
                        l_job_target_list,
                        l_job_params,
                        l_schedule,
                        -1,
                        l_job_id,
                        l_execution_ids,
                        null,
                        MGMT_JOB_ENGINE.SYSTEM_JOB_RETRY,
                        null,
                        null,
                        l_queue_names);

END ADD_SVC_TO_AGENT;

--
--
-- PROCEDURE: create_service
-- IN PARAMETERS:
--     p_service_target_name: Name of Service target
--     p_service_target_type: Service target type
--     p_target_display_name: Target display name 
--     p_host_name: This will be null for repository only target. If this is not null 
--                  then this host, timezone, agent_url of this host will be used for 
--                  the newly created target. 
--     p_agent_url: This will be null for repository only target. If this is not null
--                  then the host, time zone, agent url of this agent will be used for
--                  the newly created target. 
--     p_tz_rgn: The timezone region that target belongs to. 
--     p_svc_props: Service target level properties
--     p_system: Name of the system to associates the service 
--     p_system_type: system target type
--     p_critical_components: Critical components of the system on which the service depends. 
--     p_avail_eval_func: Availability evaluation function
--     p_type_meta_ver: Target type meta version
--     p_category_prop_1: Category property 1
--     p_category_prop_2: Category property 2
--     p_category_prop_3: Category property 3
--     p_category_prop_4: Category property 4
--     p_category_prop_5: Category property 5
--     p_repository_only_target: Repository only target 
-- OUT PARAMETERS: none
-- Exception:
-- MGMT_GLOBAL.TARGET_DOES_NOT_EXIST_ERR
-- MGMT_GLOBAL.INVALID_PARAMS_ERR
-- MGMT_GLOBAL.INVALID_CRITICAL_COMPONENT_ERR
--
PROCEDURE CREATE_SERVICE ( p_service_target_name IN VARCHAR2,
                           p_service_target_type IN VARCHAR2,
                           p_target_display_name IN VARCHAR2 DEFAULT NULL,
                           p_host_name IN VARCHAR2,
                           p_agent_url IN VARCHAR2, 
                           p_tz_rgn IN VARCHAR2,
                           p_svc_props IN MGMT_TARGET_PROPERTY_LIST,
                           p_system IN VARCHAR2,
                           p_system_type IN VARCHAR2,
                           p_critical_components IN SMP_EMD_NVPAIR_ARRAY,
                           p_avail_eval_func IN VARCHAR2,
                           p_type_meta_ver IN VARCHAR2 DEFAULT '1.0',
                           p_category_prop_1 IN VARCHAR2 DEFAULT ' ',
                           p_category_prop_2 IN VARCHAR2 DEFAULT ' ',
                           p_category_prop_3 IN VARCHAR2 DEFAULT ' ',
                           p_category_prop_4 IN VARCHAR2 DEFAULT ' ',
                           p_category_prop_5 IN VARCHAR2 DEFAULT ' ',
                           p_repository_only_target IN NUMBER DEFAULT 1 ) IS
    l_system_tgt_guid RAW(16) := NULL;
    l_target_guid mgmt_targets.target_guid%TYPE;
BEGIN
    IF EMDW_LOG.P_IS_INFO_SET 
    THEN
      EMDW_LOG.INFO('create_service: Enter', G_MODULE_NAME) ; 
    END IF ;
         
    IF p_service_target_name IS NULL OR p_service_target_type IS NULL THEN
        raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
        'One of Service Target name, Target type, System target name, System target type is Null');
    END IF;

    --Checks if target exists. 
    IF p_system IS NOT NULL AND p_system_type IS NOT NULL THEN 
        l_system_tgt_guid := get_system_guid( p_system, p_system_type);
    
        --Retrieve the list of invalid critical components. If there are no
        -- invalid components, if will return a list with size 0. 
        --This call also checks the existance of System target. It throws 
        --MGMT_GLOBAL.TARGET_DOES_NOT_EXIST_ERR exception, if the system 
        -- does not exist. 
        check_invalid_crit_comps(l_system_tgt_guid, p_critical_components);
    END IF;

    --Create target instance in the repository. 
    EM_TARGET.add_target(p_target_name => p_service_target_name, 
                           p_target_type => p_service_target_type,
                           p_host_name => p_host_name,
                           p_agent_url => p_agent_url, 
                           p_properties => p_svc_props,
                           p_target_display_name => p_target_display_name,
                           p_tz_rgn => p_tz_rgn, 
                           p_type_meta_ver => p_type_meta_ver,
                           p_category_prop_1 => p_category_prop_1, 
                           p_category_prop_2 => p_category_prop_2, 
                           p_category_prop_3 => p_category_prop_3, 
                           p_category_prop_4 => p_category_prop_4, 
                           p_category_prop_5 => p_category_prop_5, 
                           p_repository_only_target => p_repository_only_target,
                           p_target_guid => l_target_guid);

   IF (p_agent_url IS NOT NULL OR p_host_name IS NOT NULL) THEN
     ADD_SVC_TO_AGENT(p_service_target_name, p_service_target_type);
   END IF;

   --Create "is_service" instance property
   INSERT INTO MGMT_TARGET_PROPERTIES(target_guid, property_name,
            property_type, property_value) 
          VALUES (l_target_guid, 
                       MGMT_GLOBAL.G_IS_SERVICE_PROP,
                       MGMT_GLOBAL.G_INSTANCE_PROP_TYPE, '1');

   --Add Service association with system
   add_system_association(p_service_target_name, p_service_target_type, 
                          p_system, p_system_type);
 
   --Add Service association with critical components 
   add_critical_comp_association(p_service_target_name, p_service_target_type, 
                                   p_critical_components);
 
   --setup system based availability. 
   setup_system_based_avail(p_service_target_name, p_service_target_type, p_avail_eval_func);

    --Add the supports_eum_on associations
    IF (MGMT_WEBSITE_TARGET.is_eume2e_supported(p_service_target_type, MGMT_WEBSITE_TARGET.ASSOC_DEF_SUPPORTS_EUM_ON))
    THEN
      MGMT_WEBSITE_TARGET.add_eume2e_associations(p_service_target_name, p_service_target_type, MGMT_WEBSITE_TARGET.ASSOC_DEF_SUPPORTS_EUM_ON);
    END IF;

    --Add the supports_e2e_on associations
    IF (MGMT_WEBSITE_TARGET.is_eume2e_supported(p_service_target_type, MGMT_WEBSITE_TARGET.ASSOC_DEF_SUPPORTS_E2E_ON))
    THEN
      MGMT_WEBSITE_TARGET.add_eume2e_associations(p_service_target_name, p_service_target_type, MGMT_WEBSITE_TARGET.ASSOC_DEF_SUPPORTS_E2E_ON);
    END IF;

   IF EMDW_LOG.P_IS_INFO_SET 
   THEN
      EMDW_LOG.INFO('create_aggregate_service: Exit', G_MODULE_NAME) ; 
   END IF ;


END CREATE_SERVICE;

--
-- PROCEDURE: create_service
-- IN PARAMETERS:
--     p_service_target_name: Name of Service target
--     p_service_target_type: Service target type
--     p_target_display_name: Target display name 
--     p_host_name: This will be null for repository only target. If this is not null 
--                  then this host, timezone, agent_url of this host will be used for 
--                  the newly created target. 
--     p_agent_url: This will be null for repository only target. If this is not null
--                  then the host, time zone, agent url of this agent will be used for
--                  the newly created target. 
--     p_tz_rgn: The timezone region that target belongs to. 
--     p_svc_props: Service target level properties
--     p_system: Name of the system to associates the service 
--     p_system_type: system target type
--     p_critical_components: Critical components of the system on which the service depends. 
--     p_test_defn_with_props: Test definition with properties. This test will be used for 
--                             determining the availability of service target.  
--     p_test_thresholds: Per beacon and default thresholds defined on response metrics 
--                        collected by the test. 
--     p_steps_thresholds: Per beacon and step level thresholds collected by the test (Optional).
--     p_stepgroups_thresholds: Per beacon and step group level thresholds collected by the test (Optional). 
--     p_use_def_test_type_thresh: The defult thresholds defined as test part of test meta 
--                                 data will be used as thresholds, if this value is 'Y'. This
--                                 value will be ignored if thresholds are specified.
--     p_assoc_bcn_list: List of beacons to monitor the Service tests. This list identify the 
--                       the availability beacons. 
--     p_use_default_met_prom: If the value is 'Y', default metric promotions defined as part 
--                             of test meta data will be used to promote to Service level 
--                             performance metrics. 
--     p_type_meta_ver: Target type meta version
--     p_category_prop_1: Category property 1
--     p_category_prop_2: Category property 2
--     p_category_prop_3: Category property 3
--     p_category_prop_4: Category property 4
--     p_category_prop_5: Category property 5
--     p_repository_only_target: Repository only target 
-- OUT PARAMETERS: none
-- Exception:
-- MGMT_GLOBAL.TARGET_DOES_NOT_EXIST_ERR
-- MGMT_GLOBAL.INVALID_PARAMS_ERR
-- MGMT_GLOBAL.INVALID_CRITICAL_COMPONENT_ERR
--   
PROCEDURE CREATE_SERVICE ( p_service_target_name IN VARCHAR2,
                           p_service_target_type IN VARCHAR2,
                           p_target_display_name IN VARCHAR2 DEFAULT NULL,
                           p_host_name IN VARCHAR2, 
                           p_agent_url IN VARCHAR2, 
                           p_tz_rgn IN VARCHAR2,  
                           p_svc_props IN MGMT_TARGET_PROPERTY_LIST,
                           p_system IN VARCHAR2, 
                           p_system_type IN VARCHAR2,
                           p_critical_components IN SMP_EMD_NVPAIR_ARRAY,
                           p_test_defn_with_props IN MGMT_BCN_TXN_WITH_PROPS,
                           p_steps_defn_with_props IN MGMT_BCN_STEP_WITH_PROPS_ARRAY,
                           p_stepgroups_defn IN MGMT_BCN_STEPGROUP_ARRAY,
                           p_test_thresholds IN MGMT_BCN_THRESHOLD_ARRAY,
                           p_steps_thresholds IN MGMT_BCN_THRESHOLD_ARRAY,
                           p_stepgroups_thresholds IN MGMT_BCN_THRESHOLD_ARRAY,
                           p_use_def_test_type_thresh IN CHAR DEFAULT 'N',
                           p_assoc_bcn_list IN MGMT_BCN_ASSOC_ARRAY,
                           p_use_default_met_prom IN CHAR DEFAULT 'N',
                           p_type_meta_ver IN VARCHAR2 DEFAULT '1.0',
                           p_category_prop_1 IN VARCHAR2 DEFAULT ' ',
                           p_category_prop_2 IN VARCHAR2 DEFAULT ' ',
                           p_category_prop_3 IN VARCHAR2 DEFAULT ' ',
                           p_category_prop_4 IN VARCHAR2 DEFAULT ' ',
                           p_category_prop_5 IN VARCHAR2 DEFAULT ' ', 
                           p_repository_only_target IN NUMBER DEFAULT 1 ) IS
    l_system_tgt_guid RAW(16) := NULL;
    l_tgt_guid mgmt_targets.target_guid%TYPE := NULL;
    l_new_txn_id VARCHAR2(32) := NULL;
    l_new_version INTEGER;
    l_result INTEGER;
    l_err_desc VARCHAR2(2048);
    l_bcn_list MGMT_BCN_ARRAY := NULL;
    l_test_thresholds  MGMT_BCN_THRESHOLD_ARRAY;
BEGIN
    IF EMDW_LOG.P_IS_INFO_SET 
    THEN
      EMDW_LOG.INFO('create_service: Enter', G_MODULE_NAME) ; 
    END IF ;
         
    IF p_service_target_name IS NULL OR p_service_target_type IS NULL THEN
        raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
        'One of Service Target name, Target type, is Null');
    END IF;

    IF p_test_defn_with_props IS NULL OR p_assoc_bcn_list IS NULL THEN
        raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
        'One of Test definition of beacon list is Null');
    END IF;

    --Checks if target exists. 
    IF p_system IS NOT NULL AND p_system_type IS NOT NULL THEN 
        l_system_tgt_guid := get_system_guid( p_system, p_system_type);

        --Retrieve the list of invalid critical components. If there are no
        -- invalid components, if will return a list with size 0. 
        --This call also checks the existance of System target. It throws 
        --MGMT_GLOBAL.TARGET_DOES_NOT_EXIST_ERR exception, if the system 
        -- does not exist. 
        check_invalid_crit_comps(l_system_tgt_guid, p_critical_components);
    END IF;

    --Create target instance in the repository. 
    EM_TARGET.add_target(p_target_name => p_service_target_name, 
                           p_target_type => p_service_target_type,
                           p_host_name => p_host_name,
                           p_agent_url => p_agent_url,
                           p_properties => p_svc_props,
                           p_target_display_name => p_target_display_name,
                           p_tz_rgn => p_tz_rgn, 
                           p_type_meta_ver => p_type_meta_ver,
                           p_category_prop_1 => p_category_prop_1, 
                           p_category_prop_2 => p_category_prop_2, 
                           p_category_prop_3 => p_category_prop_3, 
                           p_category_prop_4 => p_category_prop_4, 
                           p_category_prop_5 => p_category_prop_5, 
                           p_repository_only_target => p_repository_only_target,
                           p_target_guid => l_tgt_guid);

   IF (p_agent_url IS NOT NULL OR p_host_name IS NOT NULL) THEN
     ADD_SVC_TO_AGENT(p_service_target_name, p_service_target_type);
   END IF;


    --Create "is_service" instance property
    INSERT INTO MGMT_TARGET_PROPERTIES(target_guid, property_name,
            property_type, property_value) 
          VALUES ( l_tgt_guid ,
                       MGMT_GLOBAL.G_IS_SERVICE_PROP,
                       MGMT_GLOBAL.G_INSTANCE_PROP_TYPE, '1');

    --Add Service association with system
    IF p_system IS NOT NULL AND p_system_type IS NOT NULL THEN 
        add_system_association(p_service_target_name, p_service_target_type, 
                          p_system, p_system_type);
 
        --Add Service association with critical components 
        add_critical_comp_association(p_service_target_name, p_service_target_type, 
                                   p_critical_components);
    END IF;

    --Consume Test meta data and apply default test thresholds
    IF p_use_def_test_type_thresh = 'Y' AND (p_test_thresholds IS NULL OR p_test_thresholds.count = 0)
    THEN
      gensvc.get_test_def_thresh(p_service_target_name,
                                 p_service_target_type,
                                 p_test_defn_with_props.txn_defn.name,
                                 p_test_defn_with_props.txn_defn.txn_type,
                                 l_test_thresholds);
    ELSE
      l_test_thresholds := p_test_thresholds;
    END IF;                                 
 
    -- Create Service Test
    emd_bcntxn.emd_bcn_txn_create( RAWTOHEX(l_tgt_guid), p_test_defn_with_props, 
        p_steps_defn_with_props, p_stepgroups_defn,
        l_test_thresholds, p_steps_thresholds, p_stepgroups_thresholds, 'Y', l_new_txn_id, l_new_version, l_bcn_list);

    -- Associate Beacons
    emd_bcntxn.emd_bcn_associate_beacons( p_service_target_name, p_service_target_type, p_assoc_bcn_list );

    --setup test based availability. 
    setup_test_based_avail(p_service_target_name, p_service_target_type, NULL);
 
    --Consume Test meta data and promote service performance metric
    IF p_use_default_met_prom = 'Y'
    THEN
    gensvc.add_test_based_def_prom(p_service_target_name, 
                                   p_service_target_type,
                                   p_test_defn_with_props.txn_defn.name,
                                   p_test_defn_with_props.txn_defn.txn_type);
    END IF;

    --Add the supports_eum_on associations
    IF (MGMT_WEBSITE_TARGET.is_eume2e_supported(p_service_target_type, MGMT_WEBSITE_TARGET.ASSOC_DEF_SUPPORTS_EUM_ON))
    THEN
      MGMT_WEBSITE_TARGET.add_eume2e_associations(p_service_target_name, p_service_target_type, MGMT_WEBSITE_TARGET.ASSOC_DEF_SUPPORTS_EUM_ON);
    END IF;

    --Add the supports_e2e_on associations
    IF (MGMT_WEBSITE_TARGET.is_eume2e_supported(p_service_target_type, MGMT_WEBSITE_TARGET.ASSOC_DEF_SUPPORTS_E2E_ON))
    THEN
      MGMT_WEBSITE_TARGET.add_eume2e_associations(p_service_target_name, p_service_target_type, MGMT_WEBSITE_TARGET.ASSOC_DEF_SUPPORTS_E2E_ON);
    END IF;

   IF EMDW_LOG.P_IS_INFO_SET 
   THEN
      EMDW_LOG.INFO('create_service: Exit', G_MODULE_NAME) ; 
   END IF ;


END CREATE_SERVICE;




--
-- PROCEDURE: create_aggregate_service
-- PURPOSE: create end user defined aggregate service
-- IN PARAMETERS:
--    p_service_name: Name of the service
--    p_sub_services: NV pair containing sub_service names and types
--    p_avail_eval_func: fuction to evaluate the availability
--    p_tz_rgn : Default value of this parameter CAN NOT be set as timezone of SYSTIMESTAMP 
--               because if there is no time zone set for repository DB then SYSTIMESTAMP would 
--               return only offset value and not the correct timezone of repositoty.
--               And hence if p_tz_rgn is NULL, at the time of creating service  then system will 
--               read default time zone defined for EM repository in MGMT_PARAMETERS. 
--               It is always desirable that user should pass correct value of timezone, for service which is being added.
-- OUT PARAMETERS: none
-- Exception:
--   TARGET_DOES_NOT_EXIST: if any sub service does not exist
--   
PROCEDURE CREATE_AGGREGATE_SERVICE(p_service_name IN VARCHAR2,
                                   p_target_type IN VARCHAR2,
                                   p_sub_services IN SMP_EMD_NVPAIR_ARRAY,
                                   p_avail_eval_func IN VARCHAR2,
                                   p_tz_rgn IN VARCHAR2 DEFAULT NULL ) AS
  l_service_guid mgmt_targets.target_guid%TYPE;

BEGIN
    IF EMDW_LOG.P_IS_INFO_SET 
    THEN
      EMDW_LOG.INFO('create_aggregate_service: Enter', G_MODULE_NAME) ; 
    END IF ;
    
    check_agg_svc_type(p_target_type);
     
    EM_TARGET.add_aggregate_target(p_target_name => p_service_name, 
                           p_target_type => p_target_type,
                           p_host_name => NULL,
                           p_tz_rgn => p_tz_rgn,
                           p_target_guid => l_service_guid,
                           p_member_targets => p_sub_services);
   add_sub_services_assoc(p_service_name, p_target_type, p_sub_services);
   SETUP_SYSTEM_BASED_AVAIL(p_service_name, p_target_type, p_avail_eval_func);
   EM_SERVICE.infer_system(p_service_name, p_target_type);
   IF EMDW_LOG.P_IS_INFO_SET 
   THEN
      EMDW_LOG.INFO('create_aggregate_service: Exit', G_MODULE_NAME) ; 
   END IF ;

END CREATE_AGGREGATE_SERVICE;

--
-- PROCEDURE: modify_aggregate_service
-- PURPOSE: modify end user defined aggregate service
-- IN PARAMETERS:
--    p_service_name: Name of the service
--    p_sub_services_to_add:  sub_service to add
--    p_sub_services_to_del; sub service to delete
--    p_avail_eval_func: fuction to evaluate the availability, if null, no change
--    p_tz_rgn:  timezone region of the service, default to repository time zone, if null
--               no change
-- OUT PARAMETERS: none
-- Exception:
--   TARGET_DOES_NOT_EXIST: if any sub service does not exist
--   INSUFFICIENT_PRIVILEGES: user doesn't have TARGET_OPERATOR privilidge on this service
--   
PROCEDURE MODIFY_AGGREGATE_SERVICE(p_service_name IN VARCHAR2,
                               p_target_type IN VARCHAR2,
                               p_sub_services_to_add IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL,
                               p_sub_services_to_del IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL,
                               p_avail_eval_func IN VARCHAR2 DEFAULT NULL,
                               p_tz_rgn IN VARCHAR2 DEFAULT NULL) AS
    l_service_guid RAW(16);
    l_current_user VARCHAR2(256) := MGMT_USER.get_current_em_user();
    l_lock_handle VARCHAR2(256);
    l_status NUMBER;
    l_member_changed BOOLEAN := FALSE;
    l_service_avail MGMT_METRIC_INSTANCE;
    l_avail_eval_func MGMT_METRIC_DEPENDENCY.eval_func%TYPE;
BEGIN
    IF EMDW_LOG.P_IS_INFO_SET 
    THEN
      EMDW_LOG.INFO('modify_aggregate_service: Enter', G_MODULE_NAME) ; 
    END IF ;
    
    check_agg_svc_type(p_target_type);
    --NOTE to GAN, STREDDY - regressions should use service targets for sub services 
    -- this call should check for service guid not just for target guid. 

    -- lock the target
    l_lock_handle := mgmt_lock_util.get_exclusive_lock('TARGET_LOCK',
              p_service_name);
    BEGIN
       IF p_avail_eval_func IS NOT NULL THEN
          l_service_avail := MGMT_METRIC_INSTANCE(p_service_name, p_target_type, 
                             MGMT_GLOBAL.G_AVAIL_METRIC_NAME, 
                             MGMT_GLOBAL.G_AVAIL_METRIC_COLUMN,
                             ' ');

          MGMT_TARGET.SET_REPO_METRIC_EVAL_PROC(l_service_avail, p_avail_eval_func);
       END IF;

      EM_TARGET.modify_aggregate_target(p_target_guid =>l_service_guid,
                                        p_target_name =>p_service_name,
                                        p_target_type =>p_target_type,
                                        p_member_targets_to_add => p_sub_services_to_add,
                                        p_member_targets_to_remove => p_sub_services_to_del,
                                        p_tz_rgn => p_tz_rgn,
                                        p_required_target_priv => MGMT_USER.OPERATOR_TARGET,
                                        p_required_member_priv => MGMT_USER.VIEW_TARGET
                                       );
  
       IF p_sub_services_to_add IS NOT NULL AND
          p_sub_services_to_add.COUNT > 0 
       THEN
          add_sub_services_assoc(p_service_name, p_target_type, p_sub_services_to_add);
          l_member_changed := TRUE;
       END IF;
  
       IF p_sub_services_to_del IS NOT NULL AND
          p_sub_services_to_del.COUNT > 0 
       THEN
          delete_sub_services_assoc(p_service_name, p_target_type, p_sub_services_to_del);
          l_member_changed := TRUE;
       END IF;

       IF l_member_changed THEN
          IF p_avail_eval_func IS NULL THEN
             GET_AVAIL_EVAL_FUNC(p_service_name,
                       p_target_type,
                       l_avail_eval_func);
          ELSE
             l_avail_eval_func := p_avail_eval_func;
          END IF;

          SETUP_SYSTEM_BASED_AVAIL(p_service_name, p_target_type, 
                          l_avail_eval_func);
          EM_SERVICE.infer_system(p_service_name, p_target_type);
       END IF;

    EXCEPTION
      WHEN OTHERS THEN
        l_status :=mgmt_lock_util.release_lock(l_lock_handle);
        raise;
    END;
    l_status :=mgmt_lock_util.release_lock(l_lock_handle);

    IF EMDW_LOG.P_IS_INFO_SET 
    THEN
      EMDW_LOG.INFO('modify_aggregate_service: Exit', G_MODULE_NAME) ; 
    END IF ;
 
END MODIFY_AGGREGATE_SERVICE;


--
-- PROCEDURE: get_aggregate_service_info
-- PURPOSE: get information of the user defined aggregate service
-- IN PARAMETERS:
--    p_service_name: Name of the service
-- OUT PARAMETERS:
--    p_sub_servicesd:  sub_services' name and type aray
--    p_avail_eval_func: fuction to evaluate the availability
--    p_tz_rgn:  timezone region of the service
-- Exception:
--   TARGET_DOES_NOT_EXIST: if the service does not exist
--   

PROCEDURE GET_AGGREGATE_SERVICE_INFO(p_service_name IN VARCHAR2,
               p_target_type IN VARCHAR2,
               p_sub_services OUT SMP_EMD_NVPAIR_ARRAY,
               p_avail_eval_func OUT VARCHAR2,
               p_tz_rgn OUT VARCHAR2) AS
    l_sub_services SMP_EMD_NVPAIR_ARRAY := SMP_EMD_NVPAIR_ARRAY();
BEGIN
   IF EMDW_LOG.P_IS_INFO_SET 
   THEN
      EMDW_LOG.INFO('get_aggregate_service_info: Enter', G_MODULE_NAME) ; 
   END IF ;
   
   check_agg_svc_type(p_target_type);

   BEGIN
     SELECT timezone_region INTO p_tz_rgn 
      FROM mgmt_targets 
      WHERE target_name = p_service_name 
        AND target_type = p_target_type;
   EXCEPTION
     WHEN NO_DATA_FOUND THEN
         raise_application_error(MGMT_GLOBAL.TARGET_DOES_NOT_EXIST_ERR, 
                            MGMT_GLOBAL.TARGET_DOES_NOT_EXIST_ERR_M ||
                            p_service_name || ':' || 
                            p_target_type);
   END;
   -- get eval fucntion for availability 
   SELECT d.eval_func INTO p_avail_eval_func 
   FROM mgmt_targets t, mgmt_metrics m, mgmt_metric_dependency d
   WHERE t.target_guid = d.target_guid
     AND m.metric_guid = d.metric_guid
     AND t.target_type = m.target_type
     AND t.type_meta_ver = m.type_meta_ver
     AND m.metric_name = MGMT_GLOBAL.G_AVAIL_METRIC_NAME
     AND m.metric_column = MGMT_GLOBAL.G_AVAIL_METRIC_COLUMN
     AND d.key_value = ' '
     AND t.target_name = p_service_name
     AND t.target_type = p_target_type;
 
   -- Get first level sub services  
   FOR sub_rec IN assoc_targets_cur (p_service_name, 
                                     p_target_type,
                                     MGMT_ASSOC.g_depends_on_guid)
   LOOP
      l_sub_services.extend;
      l_sub_services(assoc_targets_cur%ROWCOUNT) := 
                      SMP_EMD_NVPAIR(sub_rec.target_name, sub_rec.target_type); 
   END LOOP;
   p_sub_services := l_sub_services;
  
   IF EMDW_LOG.P_IS_INFO_SET 
   THEN
      EMDW_LOG.INFO('get_aggregate_service_info: Exit', G_MODULE_NAME) ; 
   END IF ;

END GET_AGGREGATE_SERVICE_INFO;

-- PROCEDURE: SET_SERVICE_AVAILABILITY
-- PURPOSE:Set the availability computation method to either System or Test
--  based availability. 
--   p_servie_target_name: Service name
--   p_service_target_type: target type
--   p_svc_avail_comp_mech: Availability computation mechanism. It should be either
--    MGMT_SERVICE.SYSTEM_BASED_AVAIL_COMP or MGMT_SERVICE.TEST_BASED_AVAIL_COMP
--   p_avail_eval_func: availability evaluation function. TBD RAJ: What is it going to 
--   be after multiple transaction availability. 
--   p_avail_eval_func: Availability evaluation function. 

PROCEDURE SET_SERVICE_AVAILABILITY( p_service_target_name IN VARCHAR2,
                                    p_service_target_type IN VARCHAR2,
                                    p_svc_avail_comp_mech IN VARCHAR2, 
                                    p_avail_eval_func IN VARCHAR2) 
IS
    l_service_guid RAW(16);
    l_avail_comp_mech mgmt_target_properties.property_value%TYPE;
    l_avail_eval_func mgmt_metric_dependency.eval_func%TYPE;
    l_current_user       VARCHAR2(256) := mgmt_user.get_current_em_user();
BEGIN
    IF EMDW_LOG.P_IS_INFO_SET 
    THEN
       EMDW_LOG.INFO('set_service_availability: Enter', G_MODULE_NAME) ; 
    END IF;

    IF ( p_service_target_name IS NULL ) OR (p_service_target_type IS NULL ) THEN
        RETURN;
    END IF;

    IF ((p_svc_avail_comp_mech IS NULL ) OR 
        ( (p_svc_avail_comp_mech != G_TEST_BASED_AVAIL_COMP ) AND 
         (p_svc_avail_comp_mech != G_SYSTEM_BASED_AVAIL_COMP ) ))THEN 
        raise_application_error(MGMT_GLOBAL.INVALID_SVC_AVAIL_COMP_ERR,
                        MGMT_GLOBAL.INVALID_SVC_AVAIL_COMP_ERR_M ||
                        p_svc_avail_comp_mech );
    END IF;

    l_service_guid := get_service_guid( p_service_target_name, p_service_target_type);

    IF( MGMT_USER.has_priv (  l_current_user, MGMT_USER.OPERATOR_TARGET, l_service_guid) = MGMT_USER.USER_DOES_NOT_HAVE_PRIV ) THEN
     raise_application_error(MGMT_GLOBAL.INSUFFICIENT_PRIVILEGES_ERR,
       'MGMT_GENSVC.SET_SERVICE_AVAILABILITY: The current user (' 
       || l_current_user || 
       ') does not have sufficient privileges to perform this operation');
    END IF;
    

    --get the current availability mechanism
    BEGIN
        SELECT property_value 
          INTO l_avail_comp_mech 
          FROM MGMT_TARGET_PROPERTIES
         WHERE target_guid = l_service_guid
           AND property_name = G_AVAIL_COMPUTATION_MECH
           AND property_type = MGMT_GLOBAL.G_INSTANCE_PROP_TYPE;
    EXCEPTION
        WHEN NO_DATA_FOUND THEN 
            l_avail_comp_mech := NULL;
    END;

    IF ( p_svc_avail_comp_mech = G_SYSTEM_BASED_AVAIL_COMP ) THEN
        IF ( l_avail_comp_mech = G_TEST_BASED_AVAIL_COMP ) THEN
            remove_test_based_avail( p_service_target_name, p_service_target_type );
        END IF;
        setup_system_based_avail(p_service_target_name, p_service_target_type,
                                      p_avail_eval_func);
    ELSIF ( p_svc_avail_comp_mech = G_TEST_BASED_AVAIL_COMP ) THEN
        IF ( l_avail_comp_mech = G_SYSTEM_BASED_AVAIL_COMP ) THEN
            remove_system_based_avail( p_service_target_name, p_service_target_type); 
        END IF;
        setup_test_based_avail(p_service_target_name, p_service_target_type, NULL);

    END IF;

    IF EMDW_LOG.P_IS_INFO_SET 
    THEN
       EMDW_LOG.INFO('set_service_availability: Exit', G_MODULE_NAME) ; 
    END IF;
END SET_SERVICE_AVAILABILITY;

--TBD RAJ: THIS SHOULD BE A PRIVATE PROEDURE
-- PROCEDURE: setup_system_based_avail
-- PURPOSE: setup response metrics dependency for the aggregate service,
--   handle both create/modify of a service
-- IN PARAMETERS:
--    p_service_name: Name of the service
--    p_target_type: type name
--    p_avail_eval_func: fuction to evaluate the availability
-- OUT PARAMETERS: none
-- Exception:
--   TARGET_DOES_NOT_EXIST: if the service does not exist
--   
PROCEDURE SETUP_SYSTEM_BASED_AVAIL(p_service_name IN VARCHAR2,  
                                   p_target_type IN VARCHAR2,
                                   p_avail_eval_func IN VARCHAR2) AS
    l_service_guid   RAW(16);
    l_avail_metric_guid mgmt_metrics.metric_guid%TYPE;
    l_been_defined   NUMBER(1);
    l_service_avail MGMT_METRIC_INSTANCE;
    l_sub_services_avail MGMT_METRIC_INSTANCE_ARRAY := MGMT_METRIC_INSTANCE_ARRAY();
BEGIN
   IF EMDW_LOG.P_IS_INFO_SET 
   THEN
      EMDW_LOG.INFO('setup_system_based_avail: Enter', G_MODULE_NAME) ; 
   END IF ;

   l_service_avail := MGMT_METRIC_INSTANCE(p_service_name, p_target_type, 
                             MGMT_GLOBAL.G_AVAIL_METRIC_NAME, 
                             MGMT_GLOBAL.G_AVAIL_METRIC_COLUMN,
                             ' ');

   FOR sub_rec IN assoc_targets_cur (p_service_name, p_target_type,
                                     MGMT_ASSOC.g_depends_on_guid)
   LOOP
      l_sub_services_avail.extend;
      l_sub_services_avail(assoc_targets_cur%ROWCOUNT) := 
                      MGMT_METRIC_INSTANCE(sub_rec.target_name, sub_rec.target_type, 
                             MGMT_GLOBAL.G_AVAIL_METRIC_NAME, 
                             MGMT_GLOBAL.G_AVAIL_METRIC_COLUMN,
                             ' ');
   END LOOP;  
   
   l_service_guid := mgmt_target.get_target_guid( p_service_name, p_target_type);
   l_avail_metric_guid := mgmt_target.get_metric_guid(p_target_type,
                                         mgmt_global.g_avail_metric_name,
                                         mgmt_global.g_avail_metric_column);

   select count(*) into l_been_defined
     from mgmt_metric_dependency
    where target_guid = l_service_guid 
      and metric_guid = l_avail_metric_guid;
 
   IF l_been_defined = 0 THEN 
       MGMT_TARGET.add_repo_metric_collection(l_service_avail,
                                 p_avail_eval_func, l_sub_services_avail);
  
       --Set service availability computation target property to test
       --based availability.
       set_svc_avail_comp_tgt_prop(l_service_guid, G_SYSTEM_BASED_AVAIL_COMP);
   ELSE
      MGMT_TARGET.modify_repo_metric_collection(l_service_avail, 
                                                p_avail_eval_func, 
                                                l_sub_services_avail);
   END IF;

   IF EMDW_LOG.P_IS_INFO_SET 
   THEN
      EMDW_LOG.INFO('setup_system_based_avail: Exit', G_MODULE_NAME) ; 
   END IF ;

END SETUP_SYSTEM_BASED_AVAIL;

--TBD RAJ: THIS SHOULD BE A PRIVATE PROEDURE
--
-- PROCEDURE: remove_system_based_avail
-- PURPOSE: remove response metrics dependency for the aggregate service. 
-- IN PARAMETERS:
--    p_service_name: Name of the service
--    p_target_type: target type
-- OUT PARAMETERS: none
-- Exception:
--   TARGET_DOES_NOT_EXIST: if the service does not exist
--   
PROCEDURE REMOVE_SYSTEM_BASED_AVAIL(p_service_name IN VARCHAR2,
                                    p_target_type IN VARCHAR2)
AS
    l_service_guid   RAW(16);
    l_service_avail MGMT_METRIC_INSTANCE;
    l_current_user       VARCHAR2(256) := mgmt_user.get_current_em_user();
BEGIN
   IF EMDW_LOG.P_IS_INFO_SET 
   THEN
      EMDW_LOG.INFO('REMOVE_SYSTEM_BASED_AVAIL: Enter', G_MODULE_NAME) ; 
   END IF ;

   --NOTE to GAN, STREDDY - regressions should use service targets for sub services 
   -- this call should check for service guid not just for target guid. 
   l_service_guid := mgmt_target.get_target_guid(p_service_name, p_target_type);

   IF( MGMT_USER.has_priv (  l_current_user, MGMT_USER.OPERATOR_TARGET, l_service_guid) = MGMT_USER.USER_DOES_NOT_HAVE_PRIV ) THEN
     raise_application_error(MGMT_GLOBAL.INSUFFICIENT_PRIVILEGES_ERR,
       'MGMT_GENSVC.REMOVE_SYSTEM_BASED_AVAIL: The current user (' 
       || l_current_user || 
       ') does not have sufficient privileges to perform this operation');
   END IF;
    
   l_service_avail := MGMT_METRIC_INSTANCE(p_service_name, p_target_type, 
                             MGMT_GLOBAL.G_AVAIL_METRIC_NAME, 
                             MGMT_GLOBAL.G_AVAIL_METRIC_COLUMN,
                             ' ');

   -- clear any old setup
   em_rep_metric.DELETE_REPO_METRIC_COLLECTION(l_service_avail,
                                               mgmt_global.G_FALSE);

   -- Deletes the target instance property G_AVAIL_COMPUTATION_MECH 
   -- (service_avail_comp_mechanism)
   DELETE
     FROM MGMT_TARGET_PROPERTIES
    WHERE target_guid = l_service_guid
      AND property_name = G_AVAIL_COMPUTATION_MECH
      AND property_type = MGMT_GLOBAL.G_INSTANCE_PROP_TYPE
      AND property_value = G_TEST_BASED_AVAIL_COMP;


   IF EMDW_LOG.P_IS_INFO_SET 
   THEN
      EMDW_LOG.INFO('REMOVE_SYSTEM_BASED_AVAIL: Exit', G_MODULE_NAME) ; 
   END IF ;

END REMOVE_SYSTEM_BASED_AVAIL;

-- PURPOSE: query if avail metric is setup based on dependency. 
--    It will check the avail metric has eval function set
-- IN PARAMETERS:
--   p_service_name
--   p_target_type
--  OUT PARAMETER:
--    p_avail_eval_func: avail evaluation func being set. 
--                       NULL if no avail metric is not set
-- Exception:
--   TARGET_DOES_NOT_EXIST, if target (p_service_name) is not existing

PROCEDURE GET_AVAIL_EVAL_FUNC(p_service_name IN VARCHAR2,
                       p_target_type IN VARCHAR2,
                       p_avail_eval_func OUT VARCHAR2)
IS
    l_guid RAW(16);
    l_avail_func MGMT_METRIC_DEPENDENCY.eval_func%TYPE;
BEGIN
    --check existance of the target
   --NOTE to GAN, STREDDY - regressions should use service targets for sub services 
   -- this call should check for service guid not just for target guid. 
   l_guid :=  mgmt_target.get_target_guid(p_service_name, p_target_type);

    BEGIN
     SELECT d.eval_func INTO l_avail_func
     FROM MGMT_TARGETS t, MGMT_METRICS m, MGMT_METRIC_DEPENDENCY d
     WHERE t.target_guid = l_guid
       AND t.target_type = m.target_type
       AND t.type_meta_ver = m.type_meta_ver
       AND m.metric_name = MGMT_GLOBAL.G_AVAIL_METRIC_NAME
       AND m.metric_column = MGMT_GLOBAL.G_AVAIL_METRIC_COLUMN
       AND d.target_guid = l_guid
       AND d.metric_guid = m.metric_guid;
    EXCEPTION
       WHEN NO_DATA_FOUND THEN
          NULL;
    END;

    p_avail_eval_func := l_avail_func;

END GET_AVAIL_EVAL_FUNC;


-- PURPOSE: query if the service is using test based availability 
--    or system based avaialbility. 
-- IN PARAMETERS:
--   p_service_name
--   p_target_type
--  OUT PARAMETER:
--    p_avail_comp_method: avail computation method. Returns 
--    either MGMT_SERVICE.G_TEST_BASED_AVAIL_COMP or 
--    MGMT_SERVICE.G_SYSTEM_BASED_AVAIL_COMP or NULL if no avail method is set
-- Exception:
--   TARGET_DOES_NOT_EXIST, if target (p_service_name) is not existing
FUNCTION GET_SVC_AVAIL_COMP_METHOD( p_service_target_name IN VARCHAR2, 
                               p_service_target_type IN VARCHAR2) 
          RETURN VARCHAR2 
IS 
    l_guid RAW(16);
    l_avail_comp_method VARCHAR2(256):=NULL;
BEGIN
   l_guid := get_service_guid(p_service_target_name, p_service_target_type);

    --get the current availability mechanism
    BEGIN
        SELECT property_value
          INTO l_avail_comp_method
          FROM MGMT_TARGET_PROPERTIES
         WHERE target_guid = l_guid
           AND property_name = G_AVAIL_COMPUTATION_MECH
           AND property_type = MGMT_GLOBAL.G_INSTANCE_PROP_TYPE;
    EXCEPTION
        WHEN NO_DATA_FOUND THEN
            l_avail_comp_method := NULL;
    END;

    RETURN l_avail_comp_method;
END;

--
--   Helper function to determine if the specified target implements service 
--   interface or not.
--
FUNCTION IMPLEMENTS_SERVICE_INTERFACE(v_target_type IN VARCHAR2)
   RETURN NUMBER
IS
  l_is_service NUMBER := 0;
BEGIN
  SELECT DECODE(property_value, '1', 1, 0)
    INTO l_is_service
    FROM mgmt_type_properties
   WHERE target_type = v_target_type
     AND property_name = MGMT_GLOBAL.G_IS_SERVICE_PROP;

  return l_is_service;

EXCEPTION
  WHEN NO_DATA_FOUND THEN
   -- if the property is not defined, then it is not a service
    return 0;

END IMPLEMENTS_SERVICE_INTERFACE;

FUNCTION IS_AGGREGATE_SERVICE(p_service_type IN VARCHAR2)
                    RETURN NUMBER
IS
  l_is_aggr NUMBER;
BEGIN

  SELECT DECODE(property_value, '1', 1, 0)
    INTO l_is_aggr
    FROM mgmt_type_properties
   WHERE target_type = p_service_type
     AND property_name = MGMT_GLOBAL.G_IS_AGGREGATE_SERVICE_PROP;

  return l_is_aggr;

EXCEPTION
  WHEN NO_DATA_FOUND THEN
   -- if the property is not defined, then it is not an aggregate service
    return 0;

END IS_AGGREGATE_SERVICE;

--
--   Gets the system for the specified service.
--
PROCEDURE GET_SYSTEM(p_service_name IN VARCHAR2,
                     p_service_type IN VARCHAR2,
                     p_system_name OUT VARCHAR2,
                     p_system_type OUT  VARCHAR2)
IS
BEGIN

   p_system_name := NULL;
   p_system_type := NULL;

   SELECT t2.target_name, t2.target_type
      INTO p_system_name, p_system_type
      FROM mgmt_targets t1,
           mgmt_targets t2, 
           mgmt_target_assocs a
     WHERE t1.target_name = p_service_name
       AND t1.target_type = p_service_type
       AND t1.target_guid = a.source_target_guid
       AND t2.target_guid = a.assoc_target_guid
       AND a.assoc_guid = mgmt_assoc.g_runs_on_guid;


EXCEPTION
  WHEN NO_DATA_FOUND THEN
   -- we return null as system name/type when no system
   -- is defined
      p_system_name := NULL;
      p_system_type := NULL;

END GET_SYSTEM;


--
--PURPOSE: Associates system and critical components with the servie. If the
-- service is not currently associated with the system, then it creates new 
-- associations. If there is already an existing system and is not same as the 
-- one passed in, it will remove the existing system, critical components 
-- association and add new associations with new system and critical components. 
-- If the system is same as the one passed then it will just updates the 
-- critical components. 
-- Calling this API with null p_critical_components will delete all existing 
-- critical components. 
--PROCEDURE: SET_SYSTEM
--
PROCEDURE SET_SYSTEM(p_service_target_name IN VARCHAR2,
                     p_service_target_type IN VARCHAR2,
                     p_system_name IN VARCHAR2,
                     p_system_type IN VARCHAR2,
                     p_critical_components IN SMP_EMD_NVPAIR_ARRAY)
IS
    l_curr_sys_name mgmt_targets.target_name%TYPE;
    l_curr_sys_type mgmt_targets.target_type%TYPE;
    l_system_tgt_guid mgmt_targets.target_guid%TYPE;
    l_service_guid mgmt_targets.target_guid%TYPE;
    l_current_user       VARCHAR2(256) := mgmt_user.get_current_em_user();
    l_svc_avail_comp_mech VARCHAR2(256) := NULL;
    l_avail_eval_func MGMT_METRIC_DEPENDENCY.eval_func%TYPE;
BEGIN

    IF EMDW_LOG.P_IS_INFO_SET 
    THEN
      EMDW_LOG.INFO('set_system: Enter', G_MODULE_NAME) ; 
    END IF ;
         
    IF p_service_target_name IS NULL OR p_service_target_type IS NULL THEN
        raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
        'One of Service Target name, Target type, is Null');
    END IF;

    IF p_system_name IS NULL OR p_system_type IS NULL THEN 
        raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
        'System target is null ');
    END IF;

   l_service_guid := mgmt_target.get_target_guid(p_service_target_name, p_service_target_type);

   IF( MGMT_USER.has_priv (  l_current_user, MGMT_USER.OPERATOR_TARGET, l_service_guid) = MGMT_USER.USER_DOES_NOT_HAVE_PRIV ) THEN
     raise_application_error(MGMT_GLOBAL.INSUFFICIENT_PRIVILEGES_ERR,
       'MGMT_GENSVC.SET_SYSTEM: The current user (' 
       || l_current_user || 
       ') does not have sufficient privileges to perform this operation');
   END IF;

    --Checks if target exists. 
    l_system_tgt_guid := get_system_guid( p_system_name, p_system_type);
    
    em_service.check_loop_containment(p_service_target_name, 
                                      p_service_target_type,
                                      p_system_name,
                                      p_system_type);

    -- Handle aggregate service
    IF (is_aggregate_service(p_service_target_type) = 1)
    THEN
        set_system_for_agg_svc(p_service_target_name,
                               p_service_target_type,
                               p_system_name,
                               p_system_type);
        IF EMDW_LOG.P_IS_INFO_SET 
        THEN
           EMDW_LOG.INFO('set_system: Exit', G_MODULE_NAME) ; 
        END IF ;
        RETURN;
    END IF; 
   
    -- Handle leaf service

    --Retrieve the list of invalid critical components. If there are no
    -- invalid components, if will return a list with size 0. 
    --This call also checks the existance of System target. It throws 
    --MGMT_GLOBAL.TARGET_DOES_NOT_EXIST_ERR exception, if the system 
    -- does not exist. 
    check_invalid_crit_comps(l_system_tgt_guid, p_critical_components);

    -- Get the current system associated with the service
    get_system(p_service_target_name, p_service_target_type, l_curr_sys_name, l_curr_sys_type);
  
    IF ( l_curr_sys_name IS NOT NULL ) AND ( l_curr_sys_type IS NOT NULL ) THEN 
        -- check if the system passed in is same as the current system 
        IF ( ( l_curr_sys_name != p_system_name ) OR 
             ( l_curr_sys_type != p_system_type ) ) THEN
            --changing the system. Delete the existing system and add new system. 
            remove_system( p_service_target_name, p_service_target_type);                      
            --add new system association 
            add_system_association(p_service_target_name, p_service_target_type, 
                          p_system_name, p_system_type);
            -- add new critical components 
            add_critical_comp_association(p_service_target_name, p_service_target_type, 
                                   p_critical_components);
        ELSE
            --Same system with updated critcal components
            update_critical_components(p_service_target_name, p_service_target_type, p_critical_components);
        END IF;
       
    ELSE
        -- There is not association with system existing. Add system and 
        -- critical components. 
        add_system_association(p_service_target_name, p_service_target_type, 
                          p_system_name, p_system_type);
 
        add_critical_comp_association(p_service_target_name, p_service_target_type, 
                                   p_critical_components);
 
    END IF;

    --get the current availability mechanism
    l_svc_avail_comp_mech := 
          get_svc_avail_comp_method(p_service_target_name, p_service_target_type);

    --Update the availability to new critical components. 
    IF ( l_svc_avail_comp_mech = G_SYSTEM_BASED_AVAIL_COMP ) THEN
        --Get the current availability eval func
        get_avail_eval_func( p_service_target_name, p_service_target_type, l_avail_eval_func ); 
        setup_system_based_avail(p_service_target_name, p_service_target_type, l_avail_eval_func);
    END IF;

    --Update the supports_eum_on associations
    IF (MGMT_WEBSITE_TARGET.is_eume2e_supported(p_service_target_type, MGMT_WEBSITE_TARGET.ASSOC_DEF_SUPPORTS_EUM_ON))
    THEN
      MGMT_WEBSITE_TARGET.del_old_eume2e_assocs(p_service_target_name, p_service_target_type, MGMT_WEBSITE_TARGET.ASSOC_DEF_SUPPORTS_EUM_ON);
      MGMT_WEBSITE_TARGET.add_eume2e_associations(p_service_target_name, p_service_target_type, MGMT_WEBSITE_TARGET.ASSOC_DEF_SUPPORTS_EUM_ON);
    END IF;

    --Update the supports_e2e_on associations
    IF (MGMT_WEBSITE_TARGET.is_eume2e_supported(p_service_target_type, MGMT_WEBSITE_TARGET.ASSOC_DEF_SUPPORTS_E2E_ON))
    THEN
      MGMT_WEBSITE_TARGET.del_old_eume2e_assocs(p_service_target_name, p_service_target_type, MGMT_WEBSITE_TARGET.ASSOC_DEF_SUPPORTS_E2E_ON);
      MGMT_WEBSITE_TARGET.add_eume2e_associations(p_service_target_name, p_service_target_type, MGMT_WEBSITE_TARGET.ASSOC_DEF_SUPPORTS_E2E_ON);
    END IF;

    IF EMDW_LOG.P_IS_INFO_SET 
    THEN
      EMDW_LOG.INFO('set_system: Exit', G_MODULE_NAME) ; 
    END IF ;
         
END SET_SYSTEM;

--
--PURPOSE: Deletes service association with system and all critical components.
--  This will also deletes all depenedency metrics for performance, usage and 
--  availability metrics. 
--PROCEDURE: REMOVE_SYSTEM
PROCEDURE REMOVE_SYSTEM(p_service_target_name IN VARCHAR2,
                        p_service_target_type IN VARCHAR2)
IS
    l_system_tgt_guid mgmt_targets.target_guid%TYPE;
    l_service_guid mgmt_targets.target_guid%TYPE;
    l_current_user       VARCHAR2(256) := mgmt_user.get_current_em_user();
BEGIN
    IF EMDW_LOG.P_IS_INFO_SET 
    THEN
      EMDW_LOG.INFO('remove_system: Enter', G_MODULE_NAME) ; 
    END IF ;
         
    IF p_service_target_name IS NULL OR p_service_target_type IS NULL THEN
        raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
        'One of Service Target name, Target type, is Null');
    END IF;

    l_service_guid := mgmt_target.get_target_guid(p_service_target_name, p_service_target_type);
    
    IF( MGMT_USER.has_priv (  l_current_user, MGMT_USER.OPERATOR_TARGET, l_service_guid) = MGMT_USER.USER_DOES_NOT_HAVE_PRIV ) THEN
     raise_application_error(MGMT_GLOBAL.INSUFFICIENT_PRIVILEGES_ERR,
       'MGMT_GENSVC.REMOVE_SYSTEM: The current user (' 
       || l_current_user || 
       ') does not have sufficient privileges to perform this operation');
    END IF;

    -- Handle aggregate service
    IF (is_aggregate_service(p_service_target_type) = 1)
    THEN
        remove_system_from_agg_svc(p_service_target_name,
                                   p_service_target_type);
        IF EMDW_LOG.P_IS_INFO_SET 
        THEN
           EMDW_LOG.INFO('remove_system: Exit', G_MODULE_NAME) ; 
        END IF ;
        RETURN;
    END IF;

    -- Handle leaf service
    --delete all critical components associations and dependency metrics 
    delete_critical_components( p_service_target_name, p_service_target_type, NULL);

    -- delete all system based dependency metrics
    del_all_sys_based_dep_metrics( p_service_target_name, p_service_target_type );

    -- delete system assocaition
    delete_system_assoc(p_service_target_name, p_service_target_type);

    IF EMDW_LOG.P_IS_INFO_SET 
    THEN
      EMDW_LOG.INFO('remove_system: Exit', G_MODULE_NAME) ; 
    END IF ;
         
END REMOVE_SYSTEM;


--
--   Returns the usage metrics of a service target type
--
FUNCTION GET_USAGE_METRICS(v_target_type   IN VARCHAR2,
	                   v_type_meta_ver IN VARCHAR2 DEFAULT NULL)
  RETURN SMP_EMD_NVPAIR_ARRAY
IS
   l_metrics SMP_EMD_NVPAIR_ARRAY;
BEGIN

   SELECT SMP_EMD_NVPAIR(metric_name, metric_column)
     BULK COLLECT INTO l_metrics
     FROM  mgmt_metrics m,
           mgmt_category_map c
     WHERE c.target_type = v_target_type
       AND (c.type_meta_ver = v_type_meta_ver OR
            v_type_meta_ver IS NULL)
       AND c.object_guid = m.metric_guid
       AND c.target_type = m.target_type
       AND c.type_meta_ver = m.type_meta_ver
       AND c.object_type = mgmt_global.G_TYPE_THRESHOLD_METRIC
       AND c.class_name = mgmt_global.G_CATEGORY_CLASS_SERVICE
       AND c.category_name = mgmt_global.G_SERVICE_CATEGORY_USAGE;
      

  return l_metrics;

END GET_USAGE_METRICS;


--
--   Returns the performance metrics of a service target type
--
FUNCTION GET_PERFORMANCE_METRICS(v_target_type   IN VARCHAR2,
	                      v_type_meta_ver IN VARCHAR2 DEFAULT NULL)
  RETURN SMP_EMD_NVPAIR_ARRAY
IS
   l_metrics SMP_EMD_NVPAIR_ARRAY;
BEGIN
   SELECT SMP_EMD_NVPAIR(metric_name, metric_column)
     BULK COLLECT INTO l_metrics
     FROM  mgmt_metrics m,
           mgmt_category_map c
     WHERE c.target_type = v_target_type
       AND (c.type_meta_ver = v_type_meta_ver OR
            v_type_meta_ver IS NULL)
       AND c.object_guid = m.metric_guid
       AND c.target_type = m.target_type
       AND c.type_meta_ver = m.type_meta_ver
       AND c.object_type = mgmt_global.G_TYPE_THRESHOLD_METRIC
       AND c.class_name = mgmt_global.G_CATEGORY_CLASS_SERVICE
       AND c.category_name = mgmt_global.G_SERVICE_CATEGORY_PERFORMANCE;

  return l_metrics;

END GET_PERFORMANCE_METRICS;

--
--   Returns the business metrics of a service target type
--
FUNCTION GET_BUSINESS_METRICS(v_target_type   IN VARCHAR2,
                              v_type_meta_ver IN VARCHAR2 DEFAULT NULL)
  RETURN SMP_EMD_NVPAIR_ARRAY
IS
   l_metrics SMP_EMD_NVPAIR_ARRAY;
BEGIN
   SELECT SMP_EMD_NVPAIR(metric_name, metric_column)
     BULK COLLECT INTO l_metrics
     FROM  mgmt_metrics m,
           mgmt_category_map c
     WHERE c.target_type = v_target_type
       AND (c.type_meta_ver = v_type_meta_ver OR
            v_type_meta_ver IS NULL)
       AND c.object_guid = m.metric_guid
       AND c.target_type = m.target_type
       AND c.type_meta_ver = m.type_meta_ver
       AND c.object_type = mgmt_global.G_TYPE_THRESHOLD_METRIC
       AND c.class_name = mgmt_global.G_CATEGORY_CLASS_SERVICE
       AND c.category_name = mgmt_global.G_SERVICE_CATEGORY_BUSINESS;

  return l_metrics;

END GET_BUSINESS_METRICS;

--
--   Returns the response metrics of a service target type
--
FUNCTION GET_RESPONSE_METRICS(v_target_type   IN VARCHAR2,
	                      v_type_meta_ver IN VARCHAR2 DEFAULT NULL)
  RETURN SMP_EMD_NVPAIR_ARRAY
IS
BEGIN
    return get_performance_metrics(v_target_type, v_type_meta_ver);
END GET_RESPONSE_METRICS;


--private function to help SET_HOMEPAGE_USAGE_CHART and SET_HOMEPAGE_PERF_CHART
PROCEDURE SET_TARGET_PROP(p_target_guid IN RAW,
                          p_name IN VARCHAR2,
                          p_value IN VARCHAR2)
AS
BEGIN
  BEGIN 
    INSERT INTO MGMT_TARGET_PROPERTIES(target_guid, property_name, 
                                      property_value)
    VALUES(p_target_guid, p_name, p_value);
  EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
       UPDATE MGMT_TARGET_PROPERTIES
       SET property_value = p_value
       WHERE target_guid = p_target_guid
         AND property_name = p_name;
  END;
END SET_TARGET_PROP;
                          
-- PROCEDURE: SET_HOMEPAGE_USAGE_CHART
--
-- PURPOSE
--   Sets the metric for usage homepage chart 
-- PARAMETERS
--    p_service_name : Service target name
--    p_service_type : type
--    p_metric_name  : Metric name
--    p_metric_colu  : Metric column
--    p_key_value    : Key value 
--
PROCEDURE SET_HOMEPAGE_USAGE_CHART(p_service_name IN VARCHAR2,
                                    p_service_type IN VARCHAR2,
                                    p_metric_name IN VARCHAR2,
                                    p_metric_column IN VARCHAR2,
                                    p_key_value   IN VARCHAR2 DEFAULT ' ')
AS
l_target_guid RAW(16);
BEGIN
   l_target_guid := mgmt_target.get_target_guid(p_service_name, 
                                                p_service_type);
   SET_TARGET_PROP(l_target_guid, EM_SERVICE.G_SVC_HP_USAGE_METRIC_NAME, 
                                                      p_metric_name);
   SET_TARGET_PROP(l_target_guid, EM_SERVICE.G_SVC_HP_USAGE_METRIC_COL,
                                                     p_metric_column);
   SET_TARGET_PROP(l_target_guid, EM_SERVICE.G_SVC_HP_USAGE_KEY,
                                                     p_key_value);
END SET_HOMEPAGE_USAGE_CHART;

-- PROCEDURE: GET_HOMEPAGE_USAGE_CHART
--
-- PURPOSE
--   Retrieves the metric for usage homepage chart 
-- PARAMETERS
--    p_service_name : Service target name
--    p_service_type : type
--    p_metric_name  : Metric name, NULL if not set
--    p_metric_colu  : Metric column, NULL if not set
--    p_key_value    : Key value, NULL if not set 
--
PROCEDURE GET_HOMEPAGE_USAGE_CHART (p_service_name IN VARCHAR2,
                                    p_service_type IN VARCHAR2,
                                    p_metric_name  OUT VARCHAR2,
                                    p_metric_column  OUT VARCHAR2,
                                    p_key_value    OUT VARCHAR2)
AS
l_props SMP_EMD_NVPAIR_ARRAY;
l_target_guid RAW(16);
BEGIN
   p_metric_name := NULL;
   p_metric_column := NULL;
   p_key_value := NULL;

   l_target_guid := mgmt_target.get_target_guid(p_service_name,
                                                p_service_type);
   SELECT SMP_EMD_NVPAIR(property_name, property_value)
     BULK COLLECT INTO l_props
   FROM mgmt_target_properties
   WHERE target_guid = l_target_guid;

   FOR indx IN l_props.FIRST..l_props.LAST
   LOOP
     CASE l_props(indx).name
     WHEN EM_SERVICE.G_SVC_HP_USAGE_METRIC_NAME THEN
        p_metric_name := l_props(indx).value;
     WHEN EM_SERVICE.G_SVC_HP_USAGE_METRIC_COL THEN
        p_metric_column := l_props(indx).value;
     WHEN EM_SERVICE.G_SVC_HP_USAGE_KEY THEN
        p_key_value := l_props(indx).value;
     ELSE
       NULL;
     END CASE;
   END LOOP;
     
END GET_HOMEPAGE_USAGE_CHART;

-- PROCEDURE: SET_HOMEPAGE_PERF_CHART
--
-- PURPOSE
--   Sets the metric for homepage peformance chart 
-- PARAMETERS
--    p_service_name : Service target name
--    p_service_type : type
--    p_metric_name  : Metric name
--    p_metric_colu  : Metric column
--    p_key_value    : Key value 
--
PROCEDURE SET_HOMEPAGE_PERF_CHART(p_service_name IN VARCHAR2,
                                    p_service_type IN VARCHAR2,
                                    p_metric_name IN VARCHAR2,
                                    p_metric_column IN VARCHAR2,
                                    p_key_value   IN VARCHAR2 DEFAULT ' ')
AS
l_target_guid RAW(16);
BEGIN
   l_target_guid := mgmt_target.get_target_guid(p_service_name, 
                                                p_service_type);
   SET_TARGET_PROP(l_target_guid, EM_SERVICE.G_SVC_HP_PERF_METRIC_NAME, 
                                                      p_metric_name);
   SET_TARGET_PROP(l_target_guid, EM_SERVICE.G_SVC_HP_PERF_METRIC_COL,
                                                     p_metric_column);
   SET_TARGET_PROP(l_target_guid, EM_SERVICE.G_SVC_HP_PERF_KEY,
                                                     p_key_value);
      
END SET_HOMEPAGE_PERF_CHART;


-- PROCEDURE: GET_HOMEPAGE_PERF_CHART
--
-- PURPOSE
--   Retrieves the metric for homepage peformance chart
-- PARAMETERS
--    p_service_name : Service target name
--    p_service_type : type
--    p_metric_name  : Metric name, NULL if not set
--    p_metric_colu  : Metric column, NULL if not set
--    p_key_value    : Key value, NULL if not set 
--
PROCEDURE GET_HOMEPAGE_PERF_CHART (p_service_name IN VARCHAR2,
                                    p_service_type IN VARCHAR2,
                                    p_metric_name  OUT VARCHAR2,
                                    p_metric_column  OUT VARCHAR2,
                                    p_key_value    OUT VARCHAR2)
AS
l_props SMP_EMD_NVPAIR_ARRAY;
l_target_guid RAW(16);
BEGIN
   p_metric_name := NULL;
   p_metric_column := NULL;
   p_key_value :=NULL;

   l_target_guid := mgmt_target.get_target_guid(p_service_name,
                                                p_service_type);
   SELECT SMP_EMD_NVPAIR(property_name, property_value)
     BULK COLLECT INTO l_props
   FROM mgmt_target_properties
   WHERE target_guid = l_target_guid;

   FOR indx IN l_props.FIRST..l_props.LAST
   LOOP
     CASE l_props(indx).name
     WHEN EM_SERVICE.G_SVC_HP_PERF_METRIC_NAME THEN
        p_metric_name := l_props(indx).value;
     WHEN EM_SERVICE.G_SVC_HP_PERF_METRIC_COL THEN
        p_metric_column := l_props(indx).value;
     WHEN EM_SERVICE.G_SVC_HP_PERF_KEY THEN
        p_key_value := l_props(indx).value;
     ELSE
       NULL;
     END CASE;
   END LOOP;
END GET_HOMEPAGE_PERF_CHART;

PROCEDURE SET_SYSTEM_FOR_AGG_SVC(p_agg_svc_name IN VARCHAR2,
                                 p_agg_svc_type IN VARCHAR2,
                                 p_system_name IN VARCHAR2,
                                 p_system_type IN VARCHAR2)
AS
    l_curr_sys_name mgmt_targets.target_name%TYPE;
    l_curr_sys_type mgmt_targets.target_type%TYPE;
BEGIN

    IF EMDW_LOG.P_IS_INFO_SET 
    THEN
      EMDW_LOG.INFO('set_system_for_agg_svc: Enter', G_MODULE_NAME) ; 
    END IF ;
         
    -- Get the current system associated with the service
    get_system(p_agg_svc_name, p_agg_svc_type, l_curr_sys_name, l_curr_sys_type);
  
    IF ( l_curr_sys_name IS NOT NULL ) AND ( l_curr_sys_type IS NOT NULL ) THEN 
        -- check if the system passed in is same as the current system 
        IF ( ( l_curr_sys_name != p_system_name ) OR 
             ( l_curr_sys_type != p_system_type ) ) THEN
            --changing the system. Delete the existing system and add new system. 
            delete_system_assoc(p_agg_svc_name, p_agg_svc_type);                      
            --add new system association 
            add_system_association(p_agg_svc_name, p_agg_svc_type, 
                                   p_system_name, p_system_type);
        END IF;
       
    ELSE
        -- There is not association with system existing. Add system and 
        -- critical components. 
        add_system_association(p_agg_svc_name, p_agg_svc_type, 
                              p_system_name, p_system_type);
 
    END IF;

    IF EMDW_LOG.P_IS_INFO_SET 
    THEN
      EMDW_LOG.INFO('set_system_for_agg_svc: Exit', G_MODULE_NAME) ; 
    END IF ;
END SET_SYSTEM_FOR_AGG_SVC;

PROCEDURE REMOVE_SYSTEM_FROM_AGG_SVC(p_agg_service_name IN VARCHAR2,
                                     p_agg_service_type IN VARCHAR2)
AS
BEGIN
    IF EMDW_LOG.P_IS_INFO_SET 
    THEN
      EMDW_LOG.INFO('remove_system_from_agg_svc: Enter', G_MODULE_NAME) ; 
    END IF ;
         
    -- delete the system associated with the aggregate service
    delete_system_assoc(p_agg_service_name, p_agg_service_type);
    -- re-infer system for the aggregate service
    EM_SERVICE.infer_system(p_agg_service_name, p_agg_service_type);

    IF EMDW_LOG.P_IS_INFO_SET 
    THEN
      EMDW_LOG.INFO('remove_system_from_agg_svc: Exit', G_MODULE_NAME) ; 
    END IF ;
END REMOVE_SYSTEM_FROM_AGG_SVC;

END MGMT_SERVICE;
/
show error;

