Rem
Rem $Header: sdk_service_pkgdef.sql 03-apr-2006.13:52:00 eporter Exp $
Rem
Rem sdk_service_pkgdef.sql
Rem
Rem Copyright (c) 2002, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_service_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       eporter  04/03/06 - Add pages needing Business customizations 
Rem       skkunise 07/14/06 - Adding Business category 
Rem       gan      07/21/05 - depends on assoc property 
Rem       andyao   04/22/05 - remove deprecated CREATE_SERVICE api 
Rem       andyao   03/17/05 - add step thresholds/stepgroup thresholds 
Rem       pmodi    02/23/05 - set default p_tz_rgn to NULL in 
Rem                           create_aggregate_service 
Rem       gan      02/04/05 - check agg svc type 
Rem       gan      01/20/05 - add set/remove system for agg svc 
Rem       rmarripa 11/24/04 - change remove test based avail signature 
Rem       rmarripa 11/03/04 - add GET_SVC_AVAIL_COMP_METHOD 
Rem       andyao   10/19/04 - export test based availability PL/SQL 
Rem       rmarripa 09/16/04 - repository only target should be default for 
Rem                           services 
Rem       streddy  10/03/04 - Service metric column name changes 
Rem       gan      09/13/04 - add chart api 
Rem       rmarripa 09/10/04 - review comments 
Rem       rmarripa 08/20/04 - Add Leaf Level Service Backend APIs 
Rem       streddy  08/16/04 - streddy_agr_svc_apis
Rem    gan,streddy 08/10/04    Created
Rem


CREATE OR REPLACE PACKAGE MGMT_SERVICE AS

G_MODULE_NAME constant VARCHAR2(20) := 'MGMT_SERVICE';

-- Constants that define assoc property name
G_RUNS_ON_SYSTEM_INFERED_PROP CONSTANT 
                                mgmt_target_assoc_prop.property_name%TYPE
                                := 'RUNS_ON_SYSTEM_INFERED';
G_SYSTEM_DEPENDS_ON_PROP CONSTANT
                                mgmt_target_assoc_prop.property_name%TYPE
                                := 'DEPENDS_ON_FROM_SYSTEM';

-- usage metric
G_USAGE_METRIC_NAME constant    VARCHAR2(16) := 'Usage';
G_USAGE_KEY_COL_NAME constant   VARCHAR2(16) := 'MetricName';
G_USAGE_VALUE_COL_NAME constant VARCHAR2(16) := 'UsageValue';

-- performance metric -- 
G_PERFORMANCE_METRIC_NAME constant    VARCHAR2(16) := 'Performance';
G_PERFORMANCE_KEY_COL_NAME constant   VARCHAR2(16) := 'MetricName';
G_PERFORMANCE_VALUE_COL_NAME constant VARCHAR2(32) := 'PerformanceValue';

-- business metric --
G_BUSINESS_METRIC_NAME constant    VARCHAR2(16) := 'Business';
G_BUSINESS_KEY_COL_NAME constant   VARCHAR2(16) := 'MetricName';
G_BUSINESS_VALUE_COL_NAME constant VARCHAR2(32) := 'BusinessValue';

-- ** These are obsolete *** - use G_PERFORMANCE_XXX INSTEAD
-- response metric -- 
G_RESPONSE_METRIC_NAME constant    VARCHAR2(16) := 'ResponseTime';
G_RESPONSE_KEY_COL_NAME constant   VARCHAR2(16) := 'Name';
G_RESPONSE_VALUE_COL_NAME constant VARCHAR2(16) := 'Value';

-- service availability
G_TEST_BASED_AVAIL_COMP constant    VARCHAR2(32) := 'service_test_based_availability';
G_SYSTEM_BASED_AVAIL_COMP constant  VARCHAR2(32) := 'system_based_availability';
G_AVAIL_COMPUTATION_MECH  constant  VARCHAR2(64) := 'service_avail_comp_mechanism';

-- Pages customizable for Business Metrics
G_SERVICE_HOME_PAGE constant VARCHAR(32)   := 'SERVICE_HOME_PAGE';
G_SERVICE_CHARTS_PAGE constant VARCHAR(32) := 'SERVICE_CHARTS_PAGE';

--PROCEDURE: REMOVE_TEST_BASED_AVAIL
--PURPOSE: Removes the test availability computation from beacon availability
-- computation job. 
--
PROCEDURE REMOVE_TEST_BASED_AVAIL(p_service_target_name IN VARCHAR2,
                                  p_service_target_type IN VARCHAR2);

-- TBD RAJ: THIS SHOULD BE A PRIVATE PROCEDURE 
--TBD RAJ: Signature of this procedure may change after multiple test 
-- availability implementation.
--
-- PROCEDURE: setup_test_based_avail
-- PURPOSE: setup test based availability for Service. This procedure consumes 
--  list of availability tests and availability beacons from corresponding tables 
--  and registers with Test based availability. Before calling this procedure 
--  availability tests and beacons shoudl be specified using corresponding APIs. 
-- IN PARAMETERS:
--    p_service_target_name: Name of the service
--    p_target_target_type: type name
-- OUT PARAMETERS: none
-- Exception:
--   TARGET_DOES_NOT_EXIST: if the service does not exist
--   
PROCEDURE SETUP_TEST_BASED_AVAIL(p_service_target_name IN VARCHAR2, 
                                 p_service_target_type IN VARCHAR2,
                                 p_avail_eval_func IN VARCHAR2 );


--
-- PURPOSE: Checks if the given target is a service and returns target_guid.
-- Exception: TARGET_DOES_NOT_EXISTS
--
FUNCTION GET_SERVICE_GUID(p_service_name IN VARCHAR2, 
                          p_target_type IN VARCHAR2 )
    RETURN RAW; 

--
-- PROCEDURE: create_service
-- PURPOSE: create a service of any target type, with association with a system 
-- target and identified critical components in the system. The Service target 
-- can either be a reposiotry only target or can have an instance at the agent. 
-- This procedure will create a service target with availabiltiy based on critical
-- components and uses the availability method passed in as argument. 
--
--
-- IN PARAMETERS:
--     p_service_target_name: Name of Service target
--     p_service_target_type: Service target type
--     p_target_display_name: Target display name 
--     p_host_name: This will be null for repository only target. If this is not null 
--                  then this host, timezone, agent_url of this host will be used for 
--                  the newly created target. 
--     p_agnet_url: This will be null for repository only target. If this is not null
--                  then the host, time zone, agent url of this agent will be used for
--                  the newly created target. 
--     p_tz_rgn: The timezone region that target belongs to. 
--     p_svc_props: Service target level properties
--     p_system: Name of the system to associates the service 
--     p_system_type: system target type
--     p_critical_components: Critical components of the system on which the service depends. 
--     p_avail_eval_func: This procedure will create a target with system based availability,
--                        with dependency on critical components passed in. p_avail_eval_func
--                        is the availability evaluation function, which will compute the 
--                        system based availability. 
--                        MGMT_SEVERITY_HELPER.G_OR_AVAIL_EVAL_PROC_NAME ("Or" on critical components)
--                        MGMT_SEVERITY_HELPER.G_AND_AVAIL_EVAL_PROC_NAME ("And" on critical components)
--     p_type_meta_ver: Target type meta version
--     p_category_prop_1: Category property 1
--     p_category_prop_2: Category property 2
--     p_category_prop_3: Category property 3
--     p_category_prop_4: Category property 4
--     p_category_prop_5: Category property 5
--     p_repository_only_target: Repository only target 
-- OUT PARAMETERS: none
-- Exception:
--   TARGET_DOES_NOT_EXIST: if any sub service does not exist
--   
PROCEDURE CREATE_SERVICE ( p_service_target_name IN VARCHAR2,
                           p_service_target_type IN VARCHAR2,
                           p_target_display_name IN VARCHAR2 DEFAULT NULL,
                           p_host_name IN VARCHAR2, 
                           p_agent_url IN VARCHAR2, 
                           p_tz_rgn IN VARCHAR2,  
                           p_svc_props IN MGMT_TARGET_PROPERTY_LIST,
                           p_system IN VARCHAR2, 
                           p_system_type IN VARCHAR2,
                           p_critical_components IN SMP_EMD_NVPAIR_ARRAY,
                           p_avail_eval_func IN VARCHAR2,
                           p_type_meta_ver IN VARCHAR2 DEFAULT '1.0',
                           p_category_prop_1 IN VARCHAR2 DEFAULT ' ',
                           p_category_prop_2 IN VARCHAR2 DEFAULT ' ',
                           p_category_prop_3 IN VARCHAR2 DEFAULT ' ',
                           p_category_prop_4 IN VARCHAR2 DEFAULT ' ',
                           p_category_prop_5 IN VARCHAR2 DEFAULT ' ', 
                           p_repository_only_target IN NUMBER DEFAULT 1 );


--
-- PROCEDURE: create_service
-- PURPOSE: create a service of any target type, with association with a system 
-- target and identified critical components in the system. The Service target 
-- can either be a reposiotry only target or can have an instance at the agent. 
-- This procedure will create a service target with availabiltiy based on critical
-- components and uses the availability method passed in as argument. 
--
--
-- IN PARAMETERS:
--     p_service_target_name: Name of Service target
--     p_service_target_type: Service target type
--     p_target_display_name: Target display name 
--     p_host_name: This will be null for repository only target. If this is not null 
--                  then this host, timezone, agent_url of this host will be used for 
--                  the newly created target. 
--     p_agent_url: This will be null for repository only target. If this is not null
--                  then the host, time zone, agent url of this agent will be used for
--                  the newly created target. 
--     p_tz_rgn: The timezone region that target belongs to. 
--     p_svc_props: Service target level properties
--     p_system: Name of the system to associates the service 
--     p_system_type: system target type
--     p_critical_components: Critical components of the system on which the service depends. 
--     p_test_defn_with_props: Test definition with properties. This test will be used for 
--                             determining the availability of service target.  
--     p_test_thresholds: Per beacon and default thresholds defined on response metrics 
--                        collected by the test. 
--     p_steps_thresholds: Per beacon and step level thresholds collected by the test (Optional).
--     p_stepgroups_thresholds: Per beacon and step group level thresholds collected by the test (Optional).
--     p_use_def_test_type_thresh: The defult thresholds defined as test part of test meta 
--                                 data will be used as thresholds, if this value is 'Y'. This
--                                 value will be ignored if thresholds are specified.
--     p_assoc_bcn_list: List of beacons to monitor the Service tests. This list identify the 
--                       the availability beacons. 
--     p_use_default_met_prom: If the value is 'Y', default metric promotions defined as part 
--                             of test meta data will be used to promote to Service level 
--                             performance metrics. 
--     p_type_meta_ver: Target type meta version
--     p_category_prop_1: Category property 1
--     p_category_prop_2: Category property 2
--     p_category_prop_3: Category property 3
--     p_category_prop_4: Category property 4
--     p_category_prop_5: Category property 5
--     p_repository_only_target: Repository only target 
-- OUT PARAMETERS: none
-- Exception:
--   TARGET_DOES_NOT_EXIST: if any sub service does not exist
--   
PROCEDURE CREATE_SERVICE ( p_service_target_name IN VARCHAR2,
                           p_service_target_type IN VARCHAR2,
                           p_target_display_name IN VARCHAR2 DEFAULT NULL,
                           p_host_name IN VARCHAR2, 
                           p_agent_url IN VARCHAR2, 
                           p_tz_rgn IN VARCHAR2,  
                           p_svc_props IN MGMT_TARGET_PROPERTY_LIST,
                           p_system IN VARCHAR2, 
                           p_system_type IN VARCHAR2,
                           p_critical_components IN SMP_EMD_NVPAIR_ARRAY,
                           p_test_defn_with_props IN MGMT_BCN_TXN_WITH_PROPS,
                           p_steps_defn_with_props IN MGMT_BCN_STEP_WITH_PROPS_ARRAY,
                           p_stepgroups_defn IN MGMT_BCN_STEPGROUP_ARRAY,
                           p_test_thresholds IN MGMT_BCN_THRESHOLD_ARRAY,
                           p_steps_thresholds IN MGMT_BCN_THRESHOLD_ARRAY,
                           p_stepgroups_thresholds IN MGMT_BCN_THRESHOLD_ARRAY,
                           p_use_def_test_type_thresh IN CHAR DEFAULT 'N',
                           p_assoc_bcn_list IN MGMT_BCN_ASSOC_ARRAY,
                           p_use_default_met_prom IN CHAR DEFAULT 'N',
                           p_type_meta_ver IN VARCHAR2 DEFAULT '1.0',
                           p_category_prop_1 IN VARCHAR2 DEFAULT ' ',
                           p_category_prop_2 IN VARCHAR2 DEFAULT ' ',
                           p_category_prop_3 IN VARCHAR2 DEFAULT ' ',
                           p_category_prop_4 IN VARCHAR2 DEFAULT ' ',
                           p_category_prop_5 IN VARCHAR2 DEFAULT ' ', 
                           p_repository_only_target IN NUMBER DEFAULT 1 );

--
-- PROCEDURE: create_aggregate_service
-- PURPOSE: create end user defined aggregate service
-- IN PARAMETERS:
--    p_service_name: Name of the service
--    p_sub_services: NV pair containing sub_service names and types
--    p_avail_eval_func: fuction to evaluate the availability
--    p_tz_rgn : Default value of this parameter should not be set as timezone of SYSTIMESTAMP 
--               because if there is no time zone set for repository DB then SYSTIMESTAMP would 
--               return only offset value and not the correct timezone of repositoty.
--               And hence if p_tz_rgn is NULL, at the time of creating service  then system will 
--               read default time zone defined for EM repository in MGMT_PARAMETERS. 
--               It is always desirable that user should pass correct value of timezone, for service which is being added.

-- OUT PARAMETERS: none
-- Exception:
--   TARGET_DOES_NOT_EXIST: if any sub service does not exist
--   
PROCEDURE CREATE_AGGREGATE_SERVICE(p_service_name IN VARCHAR2,
                                   p_target_type IN VARCHAR2,
                                   p_sub_services IN SMP_EMD_NVPAIR_ARRAY,
                                   p_avail_eval_func IN VARCHAR2,
                                   p_tz_rgn IN VARCHAR2 DEFAULT NULL );

--
-- PROCEDURE: modify_aggregate_service
-- PURPOSE: modify end user defined aggregate service
-- IN PARAMETERS:
--    p_service_name: Name of the service
--    p_sub_services_to_add:  sub_service to add
--    p_sub_services_to_del; sub service to delete
--    p_avail_eval_func: fuction to evaluate the availability, if null, no change
--    p_tz_rgn:  timezone region of the service, default to repository time zone, if null
--               no change
-- OUT PARAMETERS: none
-- Exception:
--   TARGET_DOES_NOT_EXIST: if any sub service does not exist
--   INSUFFICIENT_PRIVILEGES: user doesn't have TARGET_OPERATOR privilidge on this service
--   
PROCEDURE MODIFY_AGGREGATE_SERVICE(p_service_name IN VARCHAR2,
                               p_target_type IN VARCHAR2,
                               p_sub_services_to_add IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL,
                               p_sub_services_to_del IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL,
                               p_avail_eval_func IN VARCHAR2 DEFAULT NULL,
                               p_tz_rgn IN VARCHAR2 DEFAULT NULL);
--
-- PROCEDURE: get_aggregate_service_info
-- PURPOSE: get information of the user defined aggregate service
-- IN PARAMETERS:
--    p_service_name: Name of the service
-- OUT PARAMETERS:
--    p_sub_servicesd:  sub_services' name and type aray
--    p_avail_eval_func: fuction to evaluate the availability
--    p_tz_rgn:  timezone region of the service
-- Exception:
--   TARGET_DOES_NOT_EXIST: if the service does not exist
--   

PROCEDURE GET_AGGREGATE_SERVICE_INFO(p_service_name IN VARCHAR2,
               p_target_type IN VARCHAR2,
               p_sub_services OUT SMP_EMD_NVPAIR_ARRAY,
               p_avail_eval_func OUT VARCHAR2,
               p_tz_rgn OUT VARCHAR2);


--
-- PROCEDURE: setup_system_based_avail
-- PURPOSE: setup response metrics dependency for the aggregate service. Handle
--    both create/modify. Caller is resposible to setup the dependency before call
--    it.
-- IN PARAMETERS:
--    p_service_name: Name of the service
--    p_target_type: target type
--    p_avail_eval_func: fuction to evaluate the availability
-- OUT PARAMETERS: none
-- Exception:
--   TARGET_DOES_NOT_EXIST: if the service does not exist
--   
PROCEDURE SETUP_SYSTEM_BASED_AVAIL(p_service_name IN VARCHAR2, p_target_type IN VARCHAR2,
                                          p_avail_eval_func IN VARCHAR2);

--
-- PROCEDURE: remove_system_based_avail
-- PURPOSE: remove response metrics dependency for the aggregate service. 
-- IN PARAMETERS:
--    p_service_name: Name of the service
--    p_target_type: target type
-- OUT PARAMETERS: none
-- Exception:
--   TARGET_DOES_NOT_EXIST: if the service does not exist
--   
PROCEDURE REMOVE_SYSTEM_BASED_AVAIL(p_service_name IN VARCHAR2,
                                    p_target_type IN VARCHAR2);

-- PURPOSE: query if avail metric is setup based on dependency. 
--    It will check the avail metric has eval function set
-- IN PARAMETERS:
--   p_service_name
--   p_target_type
--  OUT PARAMETER:
--    p_avail_eval_func: avail evaluation func being set. 
--                       NULL if no avail metric is not set
-- Exception:
--   TARGET_DOES_NOT_EXIST, if target (p_service_name) is not existing

PROCEDURE GET_AVAIL_EVAL_FUNC(p_service_name IN VARCHAR2,
                       p_target_type IN VARCHAR2,
                       p_avail_eval_func OUT VARCHAR2);

-- PURPOSE: query if the service is using test based availability 
--    or system based avaialbility. 
-- IN PARAMETERS:
--   p_service_name
--   p_target_type
--  OUT PARAMETER:
--    p_avail_comp_method: avail computation method. Returns 
--    either MGMT_SERVICE.G_TEST_BASED_AVAIL_COMP or 
--    MGMT_SERVICE.G_SYSTEM_BASED_AVAIL_COMP or NULL if no avail method is set
-- Exception:
--   TARGET_DOES_NOT_EXIST, if target (p_service_name) is not existing
FUNCTION GET_SVC_AVAIL_COMP_METHOD( p_service_target_name IN VARCHAR2, 
                               p_service_target_type IN VARCHAR2) RETURN VARCHAR2; 

--
-- FUNCTION: IMPLEMENTS_SERVICE_INTERFACE
--
-- PURPOSE
--   Helper function to determine if the specified target type implements service 
--   interface or not.
-- PARAMETERS
--   v_target_type : target type
-- RETURN
--    1 if the target type implements service interface
--    0 otherwise
-- ERROR CODES
--   TARGET_DOES_NOT_EXIST: If the target does not exist.
--
FUNCTION IMPLEMENTS_SERVICE_INTERFACE(v_target_type IN VARCHAR2)
   RETURN NUMBER;

--
-- FUNCTION: IS_AGGREGATE_SERVICE
-- PURPOSE:
--   Determines if the specified service type implements aggregate service
--      interface or not.
-- IN PARAMETERS
--   p_service_type: Service type.
-- RETURN
--    1 if yes; 0 otherwise
--
FUNCTION IS_AGGREGATE_SERVICE(p_service_type IN VARCHAR2)
                    RETURN NUMBER;


--
-- FUNCTION : GET_USAGE_METRICS
--
-- PURPOSE
--   Returns the usage metrics of a service target type
-- PARAMETERS
--   v_target_type   : target type
--   v_type_meta_ver : If type-meta ver is not passed then the usage
--                     metrics across type meta vers is returned.
-- RETURN
--   An NV array containing metric names and columns. 
--   NULL if there are no usage metrics.
--
FUNCTION GET_USAGE_METRICS(v_target_type IN VARCHAR2,
	                   v_type_meta_ver IN VARCHAR2 DEFAULT NULL)
  RETURN SMP_EMD_NVPAIR_ARRAY;

--
-- FUNCTION : GET_PERFORMANCE_METRICS
--
-- PURPOSE
--   Returns the performance metrics of a service target type
-- PARAMETERS
--   v_target_type   : target type
--   v_type_meta_ver : If type-meta ver is not passed then the performance
--                     metrics across type meta vers is returned.
-- RETURN
--   An NV array containing metric names and columns. 
--   NULL if there are no response metrics.
--
FUNCTION GET_PERFORMANCE_METRICS(v_target_type IN VARCHAR2,
	                         v_type_meta_ver IN VARCHAR2 DEFAULT NULL)
  RETURN SMP_EMD_NVPAIR_ARRAY;

--
-- FUNCTION : GET_BUSINESS_METRICS
--
-- PURPOSE
--   Returns the business metrics of a service target type
-- PARAMETERS
--   v_target_type   : target type
--   v_type_meta_ver : If type-meta ver is not passed then the business
--                     metrics across type meta vers is returned.
-- RETURN
--   An NV array containing metric names and columns.
--   NULL if there are no response metrics.
--
FUNCTION GET_BUSINESS_METRICS(v_target_type IN VARCHAR2,
                              v_type_meta_ver IN VARCHAR2 DEFAULT NULL)
  RETURN SMP_EMD_NVPAIR_ARRAY;

-- 
-- This is deprecated - Use GET_PERFORMANCE_METRICS instead.
--
FUNCTION GET_RESPONSE_METRICS(v_target_type IN VARCHAR2,
	                      v_type_meta_ver IN VARCHAR2 DEFAULT NULL)
  RETURN SMP_EMD_NVPAIR_ARRAY;

--
--PURPOSE: Associates system and critical components with the leaf servie.
-- For aggregate service, p_critical_components is ignored. If the
-- service is not currently associated with the system, then it creates new 
-- associations. If there is already an existing system and is not same as the 
-- one passed in, it will remove the existing system, critical components 
-- association and add new associations with new system and critical components. 
-- If the system is same as the one passed then it will just updates the 
-- critical components. 
-- Calling this API with null p_critical_components will delete all existing 
-- critical components. 
--PROCEDURE: SET_SYSTEM
--
PROCEDURE SET_SYSTEM(p_service_target_name IN VARCHAR2,
                     p_service_target_type IN VARCHAR2,
                     p_system_name IN VARCHAR2,
                     p_system_type IN VARCHAR2,
                     p_critical_components IN SMP_EMD_NVPAIR_ARRAY);

--
--PROCEDURE: remove_system
--PURPOSE: Deletes leaf service association with system 
--  and all its critical components.
--  This will also delete all depenedency metrics for performance, usage and 
--  availability metrics. 
--  For aggregate service, it only remove the association with its system.
--  It will reinfer system for the aggretate service.
PROCEDURE REMOVE_SYSTEM(p_service_target_name IN VARCHAR2,
                        p_service_target_type IN VARCHAR2);

-- PROCEDURE: SET_SERVICE_AVAILABILITY
-- PURPOSE:Set the availability computation method to either System or Test
--  based availability. 
--   p_servie_target_name: Service name
--   p_service_target_type: target type
--   p_svc_avail_comp_mech: Availability computation mechanism. It should be either
--    MGMT_SERVICE.SYSTEM_BASED_AVAIL_COMP or MGMT_SERVICE.TEST_BASED_AVAIL_COMP
--   p_avail_eval_func: availability evaluation function. TBD RAJ: What is it going to  
--   be after multiple transaction availability. 
--   p_avail_eval_func: Availability evaluation function. 

PROCEDURE SET_SERVICE_AVAILABILITY( p_service_target_name IN VARCHAR2,
                                    p_service_target_type IN VARCHAR2,
                                    p_svc_avail_comp_mech IN VARCHAR2,
                                    p_avail_eval_func IN VARCHAR2);

-- PROCEDURE: GET_SYSTEM
-- PURPOSE:
--   Gets the system for the specified service.
-- IN PARAMETERS:
--   p_service_name: Name of the service
--   p_service_type: Target type of the service
-- OUT PARAMETERS:
--   p_system_name: Name of the system; NULL if there is no system.
--   p_system_type: Target type of the system; NULL if there is no system
--
PROCEDURE GET_SYSTEM(p_service_name IN VARCHAR2,
                     p_service_type IN VARCHAR2,
                     p_system_name OUT VARCHAR2,
                     p_system_type OUT  VARCHAR2);

/*-- PROCEDURE: SET_SYSTEM
-- PURPOSE:
--   Sets the system for the specified service.
-- IN PARAMETERS:
--   p_service_name: Name of the service
--   p_service_type: Target type of the service
--   p_system_name: Name of the system; passing NULL will result
--                  in removing the old system
--   p_system_type: Target type of the system
-- OUT PARAMETERS:
--   NONE
-- ERROR CODES:
--   TARGET_DOES_NOT_EXIST if service or system does not exist.
PROCEDURE SET_SYSTEM(p_service_name IN VARCHAR2,
                     p_service_type IN VARCHAR2,
                     p_system_name IN VARCHAR2,
                     p_system_type IN VARCHAR2);


 */

-- PROCEDURE: SET_HOMEPAGE_USAGE_CHART
--
-- PURPOSE
--   Sets the metric for usage homepage chart 
-- PARAMETERS
--    p_service_name : Service target name
--    p_service_type : type
--    p_metric_name  : Metric name
--    p_metric_colu  : Metric column
--    p_key_value    : Key value 
--
PROCEDURE SET_HOMEPAGE_USAGE_CHART(p_service_name IN VARCHAR2,
                                    p_service_type IN VARCHAR2,
                                    p_metric_name IN VARCHAR2,
                                    p_metric_column IN VARCHAR2,
                                    p_key_value   IN VARCHAR2 DEFAULT ' ');

-- PROCEDURE: GET_HOMEPAGE_USAGE_CHART
--
-- PURPOSE
--   Retrieves the metric for usage homepage chart 
-- PARAMETERS
--    p_service_name : Service target name
--    p_service_type : type
--    p_metric_name  : Metric name, NULL if not set
--    p_metric_colu  : Metric column, NULL if not set
--    p_key_value    : Key value, NULL if not set 
--
PROCEDURE GET_HOMEPAGE_USAGE_CHART (p_service_name IN VARCHAR2,
                                    p_service_type IN VARCHAR2,
                                    p_metric_name  OUT VARCHAR2,
                                    p_metric_column  OUT VARCHAR2,
                                    p_key_value    OUT VARCHAR2);

-- PROCEDURE: SET_HOMEPAGE_PERF_CHART
--
-- PURPOSE
--   Sets the metric for homepage peformance chart 
-- PARAMETERS
--    p_service_name : Service target name
--    p_service_type : type
--    p_metric_name  : Metric name
--    p_metric_colu  : Metric column
--    p_key_value    : Key value 
--
PROCEDURE SET_HOMEPAGE_PERF_CHART(p_service_name IN VARCHAR2,
                                    p_service_type IN VARCHAR2,
                                    p_metric_name IN VARCHAR2,
                                    p_metric_column IN VARCHAR2,
                                    p_key_value   IN VARCHAR2 DEFAULT ' ');

-- PROCEDURE: GET_HOMEPAGE_PERF_CHART
--
-- PURPOSE
--   Retrieves the metric for homepage peformance chart
-- PARAMETERS
--    p_service_name : Service target name
--    p_service_type : type
--    p_metric_name  : Metric name, NULL if not set
--    p_metric_colu  : Metric column, NULL if not set
--    p_key_value    : Key value, NULL if not set 
--
PROCEDURE GET_HOMEPAGE_PERF_CHART (p_service_name IN VARCHAR2,
                                    p_service_type IN VARCHAR2,
                                    p_metric_name  OUT VARCHAR2,
                                    p_metric_column  OUT VARCHAR2,
                                    p_key_value    OUT VARCHAR2);

END;
/
show errors;



