Rem
Rem $Header: sdk_severity_helper_pkgdef.sql 13-jun-2005.16:40:07 gan Exp $
Rem
Rem sdk_severity_helper_pkgdef.sql
Rem
Rem Copyright (c) 2003, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_severity_helper_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gan         06/13/05 - nls message 
Rem    pmodi       01/24/05 - NLS string for repository side metrics 
Rem    gan         08/11/04 - define constants 
Rem    streddy     04/09/03 - streddy_composite_target_availability
Rem    streddy     03/06/03 - Created
Rem

CREATE OR REPLACE PACKAGE mgmt_severity_helper AS

G_OR_AVAIL_EVAL_PROC_NAME CONSTANT VARCHAR2(100) 
                         := 'MGMT_SEVERITY_HELPER.OR_AVAIL_EVAL_PROC';
G_AND_AVAIL_EVAL_PROC_NAME CONSTANT VARCHAR2(100) 
                         := 'MGMT_SEVERITY_HELPER.AND_AVAIL_EVAL_PROC';
--
-- PURPOSE
--    Calculate the new Response/Status severity state of a target based
--    on the dependency metric severities using OR predicate logic. This
--    proc assumes that at least one of the member severities have to in CLEAR
--    state for the overall target to be in CLEAR state. The possible severity
--    codes it returns are CLEAR, CRITICAL, UNREACHABLE, ERROR, UNKNOWN, and
--    BLACKOUT.
-- PARAMETERS
--     v_target_guid   Target guid
--     v_metric_guid   Metric guid
--     v_dependency_list List of metric dependencies and their severity
--                       values
--     v_sev_code        New severity code
--     v_message         Message for the severity
--     v_message_nlsid   Optional NLS ID for the message
--     v_message_params  Message parameters for NLS message
-- 
PROCEDURE OR_AVAIL_EVAL_PROC(v_target_guid       IN RAW, 
                             v_metric_guid       IN RAW,
                             v_dependency_list   IN MGMT_METRIC_DETAILS_ARRAY,
                             v_sev_code          OUT NUMBER,
                             v_message           OUT VARCHAR2,
                             v_message_nlsid     OUT VARCHAR2,
                             v_message_params    OUT VARCHAR2);

--
-- PURPOSE
--   Calculate the new severity state of a metric based on the dependency
--   metric severities using OR predicate logic. This proc assumes that
--   at least one of the member severities have to in CLEAR state for the
--   overall metric to be in CLEAR state. The possible severity codes it
--   returns are CLEAR, WARNING, CRITICAL, UNREACHABLE, ERROR, and UNKNOWN.
--
--- PARAMETERS
--    See OR_AVAIL_EVAL_PROC description.
-- 
PROCEDURE OR_SEVERITY_EVAL_PROC(v_target_guid    IN RAW, 
                             v_metric_guid       IN RAW,
                             v_dependency_list   IN MGMT_METRIC_DETAILS_ARRAY,
                             v_sev_code          OUT NUMBER,
                             v_message           OUT VARCHAR2,
                             v_message_nlsid     OUT VARCHAR2,
                             v_message_params    OUT VARCHAR2);

--
-- PURPOSE
--    Calculate the new Response/Status severity state of a target based
--    on the dependency metric severities using AND predicate logic. This
--    proc assumes that all the member severities have to in CLEAR
--    state for the overall target to be in CLEAR state. The possible severity
--    codes it returns are CLEAR, CRITICAL, UNREACHABLE, ERROR, UNKNOWN, and
--    BLACKOUT.
-- PARAMETERS
--    See OR_AVAIL_EVAL_PROC description.
-- 
PROCEDURE AND_AVAIL_EVAL_PROC(v_target_guid      IN RAW, 
                             v_metric_guid       IN RAW,
                             v_dependency_list   IN MGMT_METRIC_DETAILS_ARRAY,
                             v_sev_code          OUT NUMBER,
                             v_message           OUT VARCHAR2,
                             v_message_nlsid     OUT VARCHAR2,
                             v_message_params    OUT VARCHAR2);


--
-- PURPOSE
--   Calculate the new severity state of a metric based on the dependency
--   metric severities using AND predicate logic. This proc assumes that
--   at least one of the member severities have to in CLEAR state for the
--   overall metric to be in CLEAR state. The possible severity codes it
--   returns are CLEAR, WARNING, CRITICAL, AND ERROR.
--
--- PARAMETERS
--    See OR_AVAIL_EVAL_PROC description.
--- 
PROCEDURE AND_SEVERITY_EVAL_PROC(v_target_guid    IN RAW, 
                                 v_metric_guid       IN RAW,
                                 v_dependency_list   IN MGMT_METRIC_DETAILS_ARRAY,
                                 v_sev_code          OUT NUMBER,
                                 v_message           OUT VARCHAR2,
                                 v_message_nlsid     OUT VARCHAR2,
                                 v_message_params    OUT VARCHAR2);


--
-- PURPOSE
--   Analyze the list of dependency target list and gives out a total count for each status
PROCEDURE ANALYZE_STATUS_DETAILS(v_dependency_list IN MGMT_METRIC_DETAILS_ARRAY,
                                 v_up_count          OUT NUMBER,
                                 v_down_count        OUT NUMBER,
                                 v_agent_down_count  OUT NUMBER,
                                 v_unreachable_count OUT NUMBER,
                                 v_blackout_count    OUT NUMBER,
                                 v_unknown_count     OUT NUMBER,
                                 v_error_count       OUT NUMBER) ;


--
-- PURPOSE
--   Analyze the list of dependency target list and gives out a total count for each status
PROCEDURE ANALYZE_STATUS_DETAILS(v_dependency_list IN MGMT_METRIC_DETAILS_ARRAY,
                                 v_up_count          OUT NUMBER,
                                 v_down_count        OUT NUMBER,
                                 v_agent_down_count  OUT NUMBER,
                                 v_unreachable_count OUT NUMBER,
                                 v_blackout_count    OUT NUMBER,
                                 v_unknown_count     OUT NUMBER,
                                 v_error_count       OUT NUMBER,
                                 v_down_dependents   OUT MGMT_TARGET_ARRAY) ;

--
-- PURPOSE
--   Analyze the list of dependency target list and gives out a total count for each type of severity


PROCEDURE ANALYZE_SEVERITY_DETAILS(v_dependency_list IN MGMT_METRIC_DETAILS_ARRAY,
                                   v_clear_count          OUT NUMBER,
                                   v_warning_count        OUT NUMBER,
                                   v_critical_count       OUT NUMBER,
                                   v_error_count          OUT NUMBER) ;

END mgmt_severity_helper;

/
show errors


