Rem
Rem $Header: sdk_system_pkgbody.sql 01-aug-2005.00:18:47 neearora Exp $
Rem
Rem sdk_system_pkgbody.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_system_pkgbody.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    neearora    08/01/05 - Bug 4525467. modified create_system to accept
Rem                           type_meta_ver
Rem    dtsao       05/12/05 - continue
Rem    dtsao       05/12/05 - add type and instance UI initialization APIs 
Rem    dtsao       04/29/05 - add is_system 
Rem    neearora    03/01/05 - added owner input parameter in modify_system and 
Rem                           create_system procedure 
Rem    gan         10/05/04 - gan_system_api_1
Rem    gan         10/01/04 - Created
Rem
CREATE OR REPLACE PACKAGE BODY MGMT_SYSTEM AS

PROCEDURE CREATE_SYSTEM(p_system_name IN VARCHAR2,
                        p_system_type IN VARCHAR2,
                        p_members IN SMP_EMD_NVPAIR_ARRAY,
                        p_timezone_region IN VARCHAR2,
                        p_owner IN VARCHAR2 DEFAULT NULL,
                        p_type_meta_ver   IN VARCHAR2 DEFAULT '1.0'    
)
AS
BEGIN
  EM_SYSTEM.create_system(p_system_name, p_system_type, 
                         p_members, p_timezone_region, p_owner,p_type_meta_ver);
END CREATE_SYSTEM;

PROCEDURE MODIFY_SYSTEM(p_system_name IN VARCHAR2, 
                        p_system_type IN VARCHAR2,
                        p_members_add IN SMP_EMD_NVPAIR_ARRAY,
                        p_members_del IN SMP_EMD_NVPAIR_ARRAY,
                        p_owner IN VARCHAR2 DEFAULT NULL)
AS
BEGIN
  EM_SYSTEM.modify_system(p_system_name, 
                          p_system_type,
                          p_members_add,
                          p_members_del,
                          p_owner);
END MODIFY_SYSTEM;

PROCEDURE MODIFY_SYSTEM(p_system_name IN VARCHAR2, 
                        p_system_type IN VARCHAR2,
                        p_new_members IN SMP_EMD_NVPAIR_ARRAY,
                        p_owner IN VARCHAR2 DEFAULT NULL)
AS
BEGIN
  EM_SYSTEM.modify_system(p_system_name, 
                          p_system_type,
                          p_new_members,
                          p_owner);
END MODIFY_SYSTEM;

PROCEDURE DELETE_SYSTEM(p_system_name IN VARCHAR2, p_system_type IN VARCHAR2)
AS
BEGIN 
  EM_SYSTEM.delete_system(p_system_name, p_system_type);
END DELETE_SYSTEM;


FUNCTION is_system(p_type_name IN VARCHAR2) RETURN NUMBER
AS
l_ret NUMBER;
BEGIN
  l_ret := mgmt_target.get_type_property(p_type_name, 
                                         MGMT_GLOBAL.G_IS_SYSTEM_PROP,
                                         '0');
  RETURN l_ret;
END is_system;

PROCEDURE apply_target_ui_defaults(
                       p_target_name        IN mgmt_targets.target_name%TYPE,
                       p_target_type        IN mgmt_targets.target_type%TYPE,
                       p_targets_to_add     IN SMP_EMD_NVPAIR_ARRAY,
                       p_targets_to_remove  IN SMP_EMD_NVPAIR_ARRAY
)
IS
BEGIN
    em_groups_ui.apply_target_ui_defaults(p_target_name,
                                  p_target_type,
                                  p_targets_to_add,
                                  p_targets_to_remove);
END apply_target_ui_defaults;


PROCEDURE setup_type_ui_metadata(
                       p_target_type_in   IN mgmt_targets.target_type%TYPE
)
IS
BEGIN
    em_groups_ui.setup_type_ui_metadata(p_target_type_in);
END setup_type_ui_metadata;

END;
/
show error;
