Rem
Rem $Header: sdk_system_pkgdef.sql 01-aug-2005.00:17:53 neearora Exp $
Rem
Rem sdk_system_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_system_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    neearora    08/01/05 - Bug 4525467. modified create_system to accept
Rem                           type_meta_ver 
Rem    dtsao       05/12/05 - continue
Rem    dtsao       05/12/05 - add type and instance UI initialization APIs 
Rem    dtsao       04/29/05 - add is_system 
Rem    neearora    03/01/05 - added owner input parameter in modify_system and 
Rem                           create_system procedure 
Rem    gan         10/05/04 - gan_system_api_1
Rem    gan         10/01/04 - Created
Rem

CREATE or REPLACE PACKAGE MGMT_SYSTEM AS
-- PROCEDURE: CREATE_SYSTEM
-- PURPOSE:
--   Creates a system 
-- IN PARAMETERS
--   p_system_name: Name of the system
--   p_system_type: type of the system
--   p_members: NV pair containing member taret names and their types
--   p_timezone_region: time zone region for the system
--   p_owner: Owner of the system
-- OUT PARAMETERS
--   NONE
-- ERROR CODES:
--  TARGET_DOES_NOT_EXIST: If any of the members do not exist
--
--
PROCEDURE CREATE_SYSTEM(p_system_name IN VARCHAR2,
                        p_system_type IN VARCHAR2,
                        p_members IN SMP_EMD_NVPAIR_ARRAY,
                        p_timezone_region IN VARCHAR2,
                        p_owner IN VARCHAR2 DEFAULT NULL,
                        p_type_meta_ver   IN VARCHAR2 DEFAULT '1.0'
);

-- PROCEDURE: MODIFY_SYSTEM
-- PURPOSE:
--   Modifies the members of a system
-- IN PARAMETERS
--   p_system_name: Name of the system
--   p_system_type: type of the system
--   p_new_members: NV pair containing the new set of member taret names and their types
--                  to be added to the system
--   p_owner: New owner of the system
-- OUT PARAMETERS
--   NONE
-- ERROR CODES:
--  TARGET_DOES_NOT_EXIST: If any of the targets do not exist
PROCEDURE MODIFY_SYSTEM(p_system_name IN VARCHAR2, 
                        p_system_type IN VARCHAR2,
                        p_new_members IN SMP_EMD_NVPAIR_ARRAY,
                        p_owner IN VARCHAR2 DEFAULT NULL);

-- PROCEDURE: MODIFY_SYSTEM
-- PURPOSE:
--   Modifies the members of a system
-- IN PARAMETERS
--   p_system_name: Name of the system
--   p_system_type: type of the system
--   p_members_add: NV pair containing the member taret names and their types
--                  to be added to the system
--   p_members_del: NV pair containing the member taret names and their types
--                  to be deleted from the system. Any associations based on 
--                   these targets are also deleted.
--   p_owner: New owner of the system
-- OUT PARAMETERS
--   NONE
-- ERROR CODES:
--  TARGET_DOES_NOT_EXIST: If any of the targets do not exist
PROCEDURE MODIFY_SYSTEM(p_system_name IN VARCHAR2, p_system_type IN VARCHAR2,
                        p_members_add IN SMP_EMD_NVPAIR_ARRAY,
                        p_members_del IN SMP_EMD_NVPAIR_ARRAY,
                        p_owner IN VARCHAR2 DEFAULT NULL);

--
-- PROCEDURE: DELETE_SYSTEM
-- PURPOSE:
--   Deletes a system
-- IN PARAMETERS
--   p_system_name: Name of the system
--   p_system_type: type of the system
-- OUT PARAMETERS
--   NONE
-- ERROR CODES:
--  INSUFFICIENT_PRIV_ERR: If user does not have enough privileges
--
PROCEDURE DELETE_SYSTEM(p_system_name IN VARCHAR2, p_system_type IN VARCHAR2);

-- 
-- PURPOSE: check given type is a system type
-- PARAM IN:
--  p_type_name
-- RETURN:
--   1 for yes, 0 for no
--
FUNCTION is_system(p_type_name IN VARCHAR2) RETURN NUMBER;

--
-- PROCEDURE: SETUP_TYPE_UI_METADATA
--
-- PURPOSE:
--   Sets up type specific UI metadata for the types with is_system
--   property set.
--   This API must be called  immediately after the type is registered.
--
-- IN Parameters:
--   p_target_type_in: The type of the target for which ui metadata needs
--                     to be setup.
--
-- OUT Parameters:
--    NONE
--
PROCEDURE setup_type_ui_metadata(p_target_type_in IN mgmt_targets.target_type%TYPE);

--
-- PROCEDURE: APPLY_TARGET_UI_DEFAULTS
--
-- PURPOSE:
--   Applies UI specific customizations to the specified target instance.
--   The API in this package supports target instances of types with
--   is_system property set.
--
-- IN Parameters:
--   p_target_name: The name of the target
--   p_target_type: The type of the target
--   p_targets_to_add: If called after creation, use the same value
--                     specified in the p_member_targets param during creation.
--                     If called after modification, use the same value
--                     specified in p_targets_to_add param during modification
--   p_targets_to_remove: only applicable after modification, use the same
--                    value specified in p_targets_to_remove param during
--                    modification
--
-- OUT Parameters:
--    NONE
--
PROCEDURE apply_target_ui_defaults(
    p_target_name IN mgmt_targets.target_name%TYPE,
    p_target_type IN mgmt_targets.target_type%TYPE,
    p_targets_to_add IN SMP_EMD_NVPAIR_ARRAY,
    p_targets_to_remove IN SMP_EMD_NVPAIR_ARRAY);

END mgmt_system;
/
show error;
