Rem
Rem $Header: sdk_target_pkgdef.sql 07-may-2007.04:49:47 neearora Exp $
Rem
Rem sdk_target_pkgdef.sql
Rem
Rem Copyright (c) 2002, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_target_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    neearora    04/19/07 - bug 5116622. Added API evaluate_target_status
Rem    neearora    05/07/07 - Backport neearora_bug-5116622 from main
Rem    jsadras     08/19/05 - add_metaver_catprop_callback
Rem    gan         08/15/05 - add opt parameter 
Rem    rkpandey    07/27/05 - Added get_agent_version 
Rem    rkpandey    07/18/05 - Add remove_cluster_member 
Rem    rpinnama    06/23/05 - Add target tzrgn update callback 
Rem    jsadras     03/11/05 - Bug:4186866, add sysdate_target 
Rem    jsadras     03/14/05 - add target metaver callbacks 
Rem    dtsao       02/23/05 - Add new API def-- isAggreateType 
Rem    rpinnama    02/25/05 - Modify the default for delete_target_type
Rem    pmodi       02/22/05 - set default p_tz_rgn/p_timezone_rgn to NULL in add_target/add_group 
Rem    gan         02/01/05 - add coll interval to repo coll 
Rem    rpinnama    01/06/05 - 
Rem    asawant     01/04/05 - Modify delete_target_type
Rem    asawant     11/11/04 - Add version to register type 
Rem    rpinnama    11/29/04 - Add set_target_tz and set_agent_tz API to set 
Rem                           timezones 
Rem    streddy     11/08/04 - Moved redundancy group APIs to mgmt_group
Rem    streddy     11/04/04 - Deprecate add_group and modify_group APIS 
Rem    rpatti      10/22/04 - add definition for get_type_property 
Rem    ramalhot    10/20/04 - remove assoc related apis 
Rem    rkpandey    11/16/04 - Removed p_memberinfo_out p_memberinfodel_out from 
Rem                           get_delete_target_info 
Rem    gan         10/05/04 - add timezone region to add_group 
Rem    kmanicka    09/20/04 - added user model callbacks
Rem    kmanicka    09/20/04 - added support for target owner
Rem    ckumar      09/06/04 - 
Rem    rzkrishn    08/20/04 - using ' ' as default in relocation target 
Rem                           callbacks 
Rem    streddy     08/10/04 - Add metric dependency functions 
Rem    asawant     08/09/04 - Adding overloaded proc get_target_info() 
Rem    asawant     06/24/04 - Adding UDTP 
Rem    rzkrishn    07/30/04 - providing defaults for relocation callback 
Rem                           addition, deletion 
Rem    rzkrishn    07/07/04 - adding callbacks for target relocation 
Rem    mbhoopat    11/16/03 - Allow registering master changed callbacks for 
Rem                           all targets 
Rem    streddy     09/26/03 - Added cat_props to add_target 
Rem    rpinnama    09/25/03 - Add APIs for add_target_type_property(s) 
Rem    rpinnama    09/25/03 - Fix 3143083: Support adding and modifying target 
Rem                           types
Rem    skini       08/16/03 - Add APIs for creating associations 
Rem    streddy     07/22/03 - master agent APIs
Rem    rzazueta    06/25/03 - Add p_propagate_to_agent to modify_target
Rem    streddy     04/09/03 - Metric dependency support for composite severities
Rem    streddy     02/11/03 - Added is_multi_agent_target_type function
Rem    skini       02/17/03 - Add move_target
Rem    rpinnama    11/27/02 - 
Rem    rpinnama    11/25/02 - 
Rem    rpatti      09/12/02 - support custom folders
Rem    ancheng     08/06/02 - modify get_targets_summary
Rem    skini       07/02/02 - Make delete_target asynchronous
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Restructured.
Rem    ancheng     05/14/02 - fix changes
Rem    tzimmerm    05/09/02 - Performance work & bug fix to get_avail_pct_value
Rem    tzimmerm    05/01/02 - Updating get_avail_pct_value to use composite pseudo table
Rem    tzimmerm    04/30/02 - Updating get_avail_pct_value to reflect new availability calc.
Rem    rpatti      04/17/02 - allow nullarrays in modify_group
Rem    skini       04/16/02 - Fix bug 2315838: incorrect guid generated
Rem    rpatti      04/12/02 - remove blackout from avail pct calculation
Rem    rpatti      04/15/02 - fix groups folder query
Rem    skini       04/11/02 - Fix bug 2315828: use generated target guids in target APIs
Rem    skini       04/11/02 - Use generated target_guids
Rem    rpatti      04/10/02 - all targets page needs to know abt groups
Rem    rpatti      04/03/02 - change add group api to pickup type display names
Rem    tjaiswal    04/01/02 - Use mgmt current availability table
Rem    jpyang      03/13/02 - add display_name for add/modify targets 
Rem    ancheng     02/28/02 - use display_name for search
Rem    rpatti      02/25/02 - use function to get current user
Rem    skini       02/28/02 - Fix bug with null groups
Rem    skini       02/08/02 - Review comments
Rem    tjaiswal    02/04/02 - Use mgmt current availability
Rem    skini       02/04/02 - Enhance target APIs
Rem    skini       02/03/02 - Add create_target and  modify_target APIs
Rem    tjaiswal    01/22/02 - Fix all targets query
Rem    rpinnama    01/22/02 - Remove rownum=1 from the query.
Rem    rpatti      01/17/02 - change avail pct query to match availability packages
Rem    rpinnama    01/15/02 - Add unmonitored to the list of down time.
Rem    ancheng     01/16/02 - add procedures for folder
Rem    tjaiswal    01/04/02 - Change plsql for target subtabs
Rem    rpatti      12/26/01 - fix avail problem
Rem    ancheng     12/18/01 - change get_target_down_timestamp
Rem    tjaiswal    12/18/01 - Optimize all targets query
Rem    tjaiswal    12/17/01 - Add seperate api for all targets page
Rem    ancheng     12/11/01 - add get_target_down_timestamp
Rem    smishra     11/16/01 - Fix for 2087192.
Rem    rpatti      12/04/01 - spport availability of groups
Rem    tjaiswal    11/09/01 - Add get_traffic_light_info procedure
Rem    tjaiswal    11/06/01 - Add procedures for target list views
Rem    tjaiswal    10/31/01 - Optimize queries in get_target_monitoring_summary
Rem    tjaiswal    10/29/01 - Add get_member_monitoring_summary
Rem    tjaiswal    10/25/01 - Merged tjaiswal_remove_targetuistatus_usage
Rem    tjaiswal    10/22/01 - Created
Rem

-- 
-- Package: mgmt_target
--
-- PURPOSE: 
--   This package provides access to the target and metric 
--   metadata as well as the monitoring details for the targets.
--   It provides the actual values - both current as well as rolled up
--   for the metrics.
--
-- NOTES: 
--   A target is uniquely identified by its name and its type. 
--   A metric for a given target is uniquely identified by a metric 
--   name (that groups a set of related metrics) and its metric 
--   column name.
--
CREATE OR REPLACE PACKAGE mgmt_target
AS

  -- The module name for error and performance logging
  G_MODULE_NAME constant varchar2(40) := 'MGMT_TARGET';


--
-- Type and constant definitions
--
TYPE CURSOR_TYPE IS REF CURSOR;
SELECT_TYPE CONSTANT NUMBER(1) := 0;
SELECT_ITEM CONSTANT NUMBER(1) := 1;
SELECT_ALL CONSTANT NUMBER(1) := 2;

--
-- Constants for "well-known" associations
-- Needed for backword compatibility

ASSOC_HOST CONSTANT VARCHAR2(10) := 'host';
ASSOC_AGENT CONSTANT VARCHAR2(10) := 'agent';
ASSOC_PARENT CONSTANT VARCHAR2(10) := 'parent';
ASSOC_SELF CONSTANT VARCHAR2(10) := 'self';

G_DEFAULT_RESOURCE_BUNDLE CONSTANT VARCHAR2(32) := 'oracle.sysman.eml.rsc.gen';

--
-- PROCEDURE: register_target_type
--
-- PURPOSE: 
--   Registers the given target type to the repository.
--   If the target type is already registered, its properties are updated.
-- 
-- IN Parameters:
--   p_target_type_in  : VARCHAR2 
--       The name of the target type to be added
--   p_type_display_name_in : VARCHAR2
--       The display name of the target type to be added.
--       If NULL defaults to target type itself
--   p_type_display_nlsid_in  : VARCHAR2 
--       The NLS ID of the display name of the target type to be added.
--       If NULL, <target_type>_name is used 
--   p_type_property_list_in : SMP_EMD_NVPAIR_ARRAY
--       The list of type properties to be added
--       If NULL, no properties are added.
--   p_type_resource_bundle_in  : VARCHAR2 
--       The default resource bundle for the target type being added.
--       Defaults to oracle.sysman.eml.rsc.gen
--   p_type_meta_ver_in  : VARCHAR2 
--       The version of the type being added.
--       Defaults to '1.0'
--
-- OUT Parameters:
-- 
-- ERROR CODES:
--   INVALID_PARAMS_ERR : For invalid parameters
--
PROCEDURE register_target_type
  (p_target_type_in           IN VARCHAR2,
   p_type_display_name_in     IN VARCHAR2 DEFAULT NULL,
   p_type_display_nlsid_in    IN VARCHAR2 DEFAULT NULL,
   p_type_property_list_in    IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL,
   p_type_resource_bundle_in  IN VARCHAR2 DEFAULT NULL,
   p_type_meta_ver_in         IN VARCHAR2 DEFAULT '1.0');


--
-- PROCEDURE: delete_target_type
--
-- PURPOSE: 
--   Deletes the given target type
--   If NULL is provided for target type, all target types are deleted
-- 
-- IN Parameters:
--   target_type_in  : VARCHAR2 
--     The target type name to be deleted
--
-- OUT Parameters:
-- 
-- ERROR CODES:
--   INVALID_PARAMS_ERR : For invalid parameters
--
PROCEDURE delete_target_type
  (p_target_type_in           IN VARCHAR2,
   p_type_meta_ver_in         IN VARCHAR2 DEFAULT NULL);

--
-- PROCEDURE: add_target_type_property
--
-- PURPOSE: 
--   Adds a property to the given target type
--   If the property already exists for this target type, its value is 
--   updated.
-- 
-- IN Parameters:
--   p_target_type_in  : VARCHAR2 
--       The name of the target type for which the property has to be added
--   p_type_property_name_in  : VARCHAR2 
--       The name of the property to be added.
--   p_type_property_value_in  : VARCHAR2 
--       The value of the property to be added.
--
-- OUT Parameters:
-- 
-- ERROR CODES:
--   INVALID_PARAMS_ERR : For invalid parameters
--

PROCEDURE add_target_type_property
  (p_target_type_in         IN VARCHAR2,
   p_type_property_name_in  IN VARCHAR2,
   p_type_property_value_in IN VARCHAR2);

--
-- PROCEDURE: add_target_type_properties
--
-- PURPOSE: 
--   Adds a list of properties to the given target type
--   If a property already exists for this target type, its value is 
--   updated.
-- 
-- IN Parameters:
--   p_target_type_in  : VARCHAR2 
--       The name of the target type for which the property has to be added
--   p_type_property_list_in  : SMP_EMD_NVPAIR_ARRAY
--       The name of the property to be added.
--
-- OUT Parameters:
-- 
-- ERROR CODES:
--   INVALID_PARAMS_ERR : For invalid parameters
--
PROCEDURE add_target_type_properties
  (p_target_type_in         IN VARCHAR2,
   p_type_property_list_in  IN SMP_EMD_NVPAIR_ARRAY);


--
-- PROCEDURE: delete_target_type_property
--
-- PURPOSE: 
--   Removes the property for the given target type
-- 
-- IN Parameters:
--   p_target_type_in  : VARCHAR2 
--       The name of the target type for which the property has to be deleted
--   p_type_property_name_in  : VARCHAR2
--       The name of the property to be deleted.
--
-- OUT Parameters:
-- 
-- ERROR CODES:
--   INVALID_PARAMS_ERR : For invalid parameters
--
PROCEDURE delete_target_type_property
  (p_target_type_in         IN VARCHAR2,
   p_type_property_name_in  IN VARCHAR2);

--
-- FUNCTION: get_type_property
--
-- PURPOSE: 
--   Return the property value for a given type and property name
--    Can also define a default to be returned if the property is
--     nto found.
-- 
-- IN Parameters:
--   target_type: VARCHAR2 The type of the target
--   property_name: VARCHAR2 The name of the property
--   default: VARCHAR2 default value to return if no such property is found
-- 
-- OUT Parameters:
--   Value of the property
-- 
FUNCTION get_type_property(p_target_type VARCHAR2,
                           p_property_name VARCHAR2,
                           p_default VARCHAR2 DEFAULT NULL) 
RETURN VARCHAR2;



  -- Procedure ADD_TGTTYPE_ADDITION_CALLBACK
  --
  -- PURPOSE: To add a callback that will be called when a new target type is 
  --   registerd to the repository. 
  --   Note 1: All the exceptions raised by the callback are logged as system errors
  --   Note 1: Callback names are always stored in UPPER case.
  -- IN parameters:
  --   p_callback_name : The name of the callback procedure. This must
  --      have the following signature: 
  --      PROCEDURE PROC(p_target_type VARCHAR2, p_type_meta_ver VARCHAR2);
  --   p_target_type : Target type for which this callback should be called (optional).
  --                   If target type is not specified, then the callback is called
  --                   for targets of all types.
  --                   
  -- OUT parameters: 
  --   No out parameters 
  -- ERROR CODES:
  --   None 
  PROCEDURE add_tgttype_addition_callback(p_callback_name IN VARCHAR2,
                                          p_target_type   IN VARCHAR2 DEFAULT ' ');




  -- Procedure DEL_TGTTYPE_ADDITION_CALLBACK
  --
  -- PURPOSE: To remove a callback that will be called when a target type is 
  --   added to the repository.
  -- IN parameters:
  --   p_callback_name: The name of the callback procedure.
  --   p_target_type : Target type for which this callback should be removed (optional)
  -- OUT parameters: 
  --   No out parameters 
  -- ERROR CODES:
  --   None
  PROCEDURE del_tgttype_addition_callback(p_callback_name IN VARCHAR2,
                                          p_target_type   IN VARCHAR2 DEFAULT ' ');



--
-- PROCEDURE: get_target_monitoring_summary
--
-- PURPOSE: 
--   Returns a summary of monitoring details for a particular target
--     or all the targets if no target information is passed in.
--
-- IN Parameters:
--   target_name_in: VARCHAR2 The name of the target DEFAULTS TO NULL
--   target_type_in: VARCHAR2 The type of the target DEFAULTS TO NULL
--   search_target_name_in: VARCHAR2 The target name to be searched. 
--                            DEFAULTS TO NULL
--                            Also note that the calling code should pass in
--                            a processed value for search_target_name_in
--                            For example, it the search target string is
--                            "dlsun1285" then the actual passed in string for
--                            search_target_name_in should be %DLSUN1285%
--   timeperiod_in: NUMBER The timeperiod or which we want details
--                         DEFAULTS to MGMT_GLOBAL.G_DAY
--
-- OUT Parameters:
--   summary_out: CURSORTYPE A cursor which returns rows containing:
--     target_name: VARCHAR2 The name of the target 
--     target_type: VARCHAR2 The type of the target
--     display_name: VARCHAR2 The display name of the target
--     type_display_name: VARCHAR2 The display name of the target type
--     avail_pct: NUMBER The availability percent over the timeperiod
--     current_status: NUMBER The current availability status - check
--                           mgmt current availability table for definition of values.
--     warning_count: NUMBER The number of currently open warning alerts
--     critical_count: NUMBER The number of currently open critical alerts
--
-- ERROR CODES:
--   TARGET_DOES_NOT_EXIST_ERR: No such target was found. This could also mean
--     that the user does not have access to view this target.
--
PROCEDURE get_target_monitoring_summary
  (target_name_in  IN VARCHAR2 DEFAULT NULL,
   target_type_in  IN VARCHAR2 DEFAULT NULL,
   search_target_name_in IN VARCHAR2 DEFAULT NULL,
   timeperiod_in  IN NUMBER DEFAULT MGMT_GLOBAL.G_DAY,
   summary_out OUT CURSOR_TYPE);

--
-- PROCEDURE: get_all_targets_mntr_summary
--
-- PURPOSE: 
--   Returns a summary of monitoring details for all targets
--
-- IN Parameters:
--   search_target_name_in: VARCHAR2 The target name to be searched. 
--                            DEFAULTS TO NULL
--                            Also note that the calling code should pass in
--                            a processed value for search_target_name_in
--                            For example, it the search target string is
--                            "dlsun1285" then the actual passed in string for
--                            search_target_name_in should be %DLSUN1285%
--
-- OUT Parameters:
--   summary_out: CURSORTYPE A cursor which returns rows containing:
--     target_name: VARCHAR2 The name of the target 
--     target_type: VARCHAR2 The type of the target
--     display_name: VARCHAR2 The display name of the target
--     type_display_name: VARCHAR2 The display name of the target type
--     current_status: NUMBER The current availability status - check
--                           mgmt current availability table for definition of values.
--     warning_count: NUMBER The number of currently open warning alerts
--     critical_count: NUMBER The number of currently open critical alerts
--     target_guid: The GUID of the associated target
--     target_status_down: NUMBER 1 if the target type is of a typed group, 0
--                                otherwise
--     has_member_status: NUMBER 1 if the severity is for a target with member
--                               targets, 0 otherwise
--
PROCEDURE get_all_targets_mntr_summary
  (search_target_name_in IN VARCHAR2 DEFAULT NULL,
   summary_out OUT CURSOR_TYPE);

--
-- PROCEDURE: get_member_monitoring_summary
--
-- PURPOSE:
--   Returns a summary of monitoring details for the members of 
--     a particular target.
--
-- IN Parameters:
--   target_name_in: VARCHAR2 The name of the target 
--   target_type_in: VARCHAR2 The type of the target
--   member_target_type_in: VARCHAR2 The type of the member target
--   timeperiod_in: NUMBER The timeperiod or which we want details
--                         DEFAULTS to MGMT_GLOBAL.G_DAY
--
-- OUT Parameters:
--   summary_out: CURSORTYPE A cursor which returns rows containing:
--     target_name: VARCHAR2 The name of the target
--     target_type: VARCHAR2 The type of the target
--     display_name: VARCHAR2 The display name of the target
--     type_display_name: VARCHAR2 The display name of the target type
--     avail_pct: NUMBER The availability percent over the timeperiod
--     current_status: NUMBER The current availability status - check
--                           mgmt current availability table for definition of values.
--     warning_count: NUMBER The number of currently open warning alerts
--     critical_count: NUMBER The number of currently open critical alerts
--
-- ERROR CODES:
--   TARGET_DOES_NOT_EXIST_ERR: No such target was found. This could also mean
--     that the user does not have access to view this target.
--
PROCEDURE get_member_monitoring_summary
  (target_name_in  IN VARCHAR2,
   target_type_in  IN VARCHAR2,
   member_target_type_in IN VARCHAR2,
   timeperiod_in   IN NUMBER DEFAULT MGMT_GLOBAL.G_DAY,   
   summary_out OUT CURSOR_TYPE);

--
-- PROCEDURE: get_target_list_view_summary
--
-- PURPOSE: 
--   Returns a summary of monitoring details for the members of 
--     a particular target list view
--
-- IN Parameters:
--   targets_in: MGMT_GUID_ARRAY 
--               If list_mode_in is 0, then targets_in will consist of
--               an array of MGMT_GUID_OBJ with only "name" values filled
--               If list_mode_in is 1, then targets_in will consist of
--               an array of MGMT_GUID_OBJ with only "guid" values filled
--   list_mode_in: NUMBER 
--                 0 for list of target types, 1 for list of target guids
--   search_target_name_in: VARCHAR2 The target name to be searched. 
--                            DEFAULTS TO NULL
--                            Also note that the calling code should pass in
--                            a processed value for search_target_name_in
--                            For example, it the search target string is
--                            "dlsun1285" then the actual passed in string for
--                            search_target_name_in should be %DLSUN1285%
--   timeperiod_in: NUMBER The timeperiod or which we want details
--                         DEFAULTS to MGMT_GLOBAL.G_DAY
--
-- OUT Parameters:
--   summary_out: CURSORTYPE A cursor which returns rows containing:
--     target_name: VARCHAR2 The name of the target
--     target_type: VARCHAR2 The type of the target
--     display_name: VARCHAR2 The display name of the target
--     type_display_name: VARCHAR2 The display name of the target type
--     avail_pct: NUMBER The availability percent over the timeperiod
--     current_status: NUMBER The current availability status - check
--                           mgmt current availability table for definition of values.
--     warning_count: NUMBER The number of currently open warning alerts
--     critical_count: NUMBER The number of currently open critical alerts
--     target_status_down: NUMBER 1 if the target type is of a typed group, 0
--                                otherwise
--     has_member_status: NUMBER 1 if the severity is for a target with member
--                               targets, 0 otherwise
--
-- ERROR CODES:
--   None
--
PROCEDURE get_target_list_view_summary
  (targets_in     IN MGMT_GUID_ARRAY,
   list_mode_in   IN NUMBER,
   search_target_name_in IN VARCHAR2 DEFAULT NULL,
   timeperiod_in  IN NUMBER DEFAULT MGMT_GLOBAL.G_DAY,
   summary_out OUT CURSOR_TYPE);

--
-- PROCEDURE: get_target_subtab_summary
--
-- PURPOSE: 
--   Returns a summary of monitoring details for a target subtab
--
-- IN Parameters:
--   target_type_in: VARCHAR2 The type of the target subtab 
--   targets_in: MGMT_GUID_ARRAY 
--               The targets_in will consist of an array of MGMT_GUID_OBJ with 
--               only "guid" values filled
--   search_target_name_in: VARCHAR2 The target name to be searched. 
--                            DEFAULTS TO NULL
--                            Also note that the calling code should pass in
--                            a processed value for search_target_name_in
--                            For example, it the search target string is
--                            "dlsun1285" then the actual passed in string for
--                            search_target_name_in should be %DLSUN1285%
--   timeperiod_in: NUMBER The timeperiod or which we want details
--                         DEFAULTS to MGMT_GLOBAL.G_DAY
--
-- OUT Parameters:
--   summary_out: CURSORTYPE A cursor which returns rows containing:
--     target_name: VARCHAR2 The name of the target
--     target_type: VARCHAR2 The type of the target
--     display_name: VARCHAR2 The display name of the target
--     type_display_name: VARCHAR2 The display name of the target type
--     avail_pct: NUMBER The availability percent over the timeperiod
--     current_status: NUMBER The current availability status - check
--                           mgmt current availability table for definition of values.
--     warning_count: NUMBER The number of currently open warning alerts
--     critical_count: NUMBER The number of currently open critical alerts
--     target_status_down: NUMBER 1 if the target type is of a typed group, 0
--                                otherwise
--     has_member_status: NUMBER 1 if the severity is for a target with member
--                               targets, 0 otherwise
--
-- ERROR CODES:
--   None
--
PROCEDURE get_target_subtab_summary
  (target_type_in IN VARCHAR2,
   targets_in IN MGMT_GUID_ARRAY,
   search_target_name_in IN VARCHAR2 DEFAULT NULL,
   timeperiod_in  IN NUMBER DEFAULT MGMT_GLOBAL.G_DAY,
   summary_out OUT CURSOR_TYPE);

--
-- PROCEDURE: get_traffic_light_info
--
-- PURPOSE: 
--   Returns a summary of traffic light related data for a given target name,
--   target type
--
-- IN Parameters:
--   target_name_in: VARCHAR2 The name of the target
--   target_type_in: VARCHAR2 The type of the target  
--   timeperiod_in: NUMBER The timeperiod or which we want details
--                         DEFAULTS to MGMT_GLOBAL.G_DAY
--
-- OUT Parameters:
--   avail_pct_out: NUMBER The availability percent over the timeperiod
--   current_status_out: NUMBER The current availability status - check
--                         mgmt current availability table for definition of values.
--
-- ERROR CODES:
--   TARGET_DOES_NOT_EXIST_ERR: No such target was found. This could also mean
--     that the user does not have access to view this target.
--
PROCEDURE get_traffic_light_info
  (target_name_in  IN VARCHAR2,
   target_type_in  IN VARCHAR2,
   timeperiod_in IN NUMBER DEFAULT MGMT_GLOBAL.G_DAY,   
   avail_pct_out OUT NUMBER,
   current_status_out OUT NUMBER);

--
-- FUNCTION: get_target_guid
--
-- PURPOSE: 
--   The targets in the repository are identified by a globally unique
--   identifier (guid). This function returns the guid for a given target.
-- 
-- IN Parameters:
--   target_name_in: VARCHAR2 The name of the target
--   target_type_in: VARCHAR2 The type of the target
-- 
-- OUT Parameters:
--   The GUID for the given target.
-- 
-- ERROR CODES:
--   TARGET_DOES_NOT_EXIST: No such target was found. This could also mean
--     that the user does not have access to view this target.
--
-- NOTES:
--   This is primarily intended to be used by the SDK but it may also be used 
--   to write more customized PL/SQL to access the repository information.
--   Please remember to check to see if your requirements can be handled by 
--   the SDK. Writing customized PL/SQL has the problem of having to deal with 
--   changes to the underlying table structure.
--
FUNCTION get_target_guid
  (target_name_in  IN VARCHAR2,
   target_type_in  IN VARCHAR2) 
  RETURN mgmt_targets.target_guid%TYPE;

--
-- FUNCTION: get_metric_guid
--
-- PURPOSE:
--   The metrics in the repository are identified by a globally unique
--   identifier (guid). This function returns the guid for a given metric.
--   If the metric column in parameter is an empty string - it returns the
--   GUID that identifies the metric definition. If not it returns the 
--   GUID of the metric column in that metric.
-- 
-- IN Parameters:
--   target_type_in: VARCHAR2 The type of the target
--   metric_name_in: VARCHAR2 The name of the metric
--   metric_column_in: VARCHAR2 The name of the metric column. Can be NULL.
-- 
-- OUT Parameters:
--   The GUID for the given metric.
-- 
-- ERROR CODES:
--   NO_SUCH_METRIC_FOUND: No such metric was found. 
--
-- NOTES:
--   This is primarily intended to be used by the SDK but it may also be used 
--   to write more customized PL/SQL to access the repository information.
--   Please remember to check to see if your requirements can be handled by 
--   the SDK. Writing customized PL/SQL has the problem of having to deal with 
--   changes to the underlying table structure.
--

FUNCTION get_metric_guid
  (target_type_in  IN VARCHAR2,
   metric_name_in  IN VARCHAR2,
   metric_column_in IN VARCHAR2 DEFAULT ' ') 
  RETURN mgmt_metrics.metric_guid%TYPE;

--
-- FUNCTION: get_metric_column_guids
--
-- PURPOSE:
--   The metrics in the repository are identified by a globally unique
--   identifier (guid). This function returns all the metric column guids
--   for a given metric.
-- 
-- IN Parameters:
--   target_type_in: VARCHAR2 The type of the target
--   metric_name_in: VARCHAR2 The name of the metric
-- 
-- OUT Parameters:
--   SMP_EMD_NVPAIR_ARRAY The array of GUID, names for the metric columns.
--                        The name field has the name of the metric column
--                        The value field has the metric guid
-- 
-- ERROR CODES:
--   NO_SUCH_METRIC_FOUND: No such metric was found. 
--
-- NOTES:
--   This is primarily intended to be used by the SDK but it may also be used 
--   to write more customized PL/SQL to access the repository information.
--   Please remember to check to see if your requirements can be handled by 
--   the SDK. Writing customized PL/SQL has the problem of having to deal with 
--     This function returns this difference given a timeperiod constant.
--     Meant to be used internally - as this definition might change.

FUNCTION get_metric_column_guids
  (target_type_in  IN VARCHAR2,
   metric_name_in  IN VARCHAR2)
  RETURN SMP_EMD_NVPAIR_ARRAY;
--
-- FUNCTION: target_sysdate
--
-- PURPOSE:
--  Returns the system date as per the timezone at target
--
FUNCTION sysdate_target(p_target_guid IN RAW) 
RETURN DATE ;

--
-- FUNCTION: get_time_difference
--
-- PURPOSE:
--
-- IN Parameters:
--   timeperiod_in: NUMBER The timeperiod. Defaults to MGMT_GLOBAL.G_DAY.
--
-- OUT Parameters:
--   The NUMBER value of the difference in days.
--
-- NOTES:
--   This is primarily intended to be used by the SDK but it may also be used
--   to write more customized PL/SQL to access the repository information.
--   Please remember to check to see if your requirements can be handled by 
--   the SDK. Writing customized PL/SQL has the problem of having to deal with 
--   changes to the underlying table structure.
--

FUNCTION get_time_difference
   (timeperiod_in IN NUMBER DEFAULT MGMT_GLOBAL.G_DAY)
  RETURN NUMBER;

--
-- FUNCTION: get_avail_current_status
--
-- PURPOSE:
--   This function returns the availability current status of the given target 
--   guid
--
-- IN Parameters:
--   target_guid_in: RAW The target guid for which the availability current
--                       status needs to be found
--
-- OUT Parameters:
--   The NUMBER value of the availability current status value of the given
--   target guid
--
FUNCTION get_avail_current_status
  (target_guid_in  IN  mgmt_targets.target_guid%TYPE)
  RETURN NUMBER;

--
-- FUNCTION: get_avail_pct_value
--
-- PURPOSE:
--   This function returns the availability value as a percentage of the given 
--   target guid
--
-- IN Parameters:
--   target_name_in: VARCHAR2 The name of the target for which the availability
--                            pct value needs to be found
--   target_type_in: VARCHAR2 The type of the target for which the availability
--                            pct value needs to be found
--   num_of_days_in: NUMBER The duration for which the availability percentage
--                          value needs to be found - can be 1, 7, 31
--
-- OUT Parameters:
--   The NUMBER value of the availability percentage value of the given
--   target guid
--
-- ERROR CODES:
--   TARGET_DOES_NOT_EXIST: No such target was found. This could also mean
--     that the user does not have access to view this target.
--
FUNCTION get_avail_pct_value
  (target_name_in  IN VARCHAR2,
   target_type_in  IN VARCHAR2,
   num_of_days_in  IN  NUMBER)
  RETURN NUMBER;

--
-- FUNCTION: get_avail_pct_value
--
-- PURPOSE:
--   This function returns the availability value as a percentage of the given 
--   target guid
--
-- IN Parameters:
--   target_guid_in: RAW The target guid for which the availability percentage
--                       value needs to be found
--   num_of_days_in: NUMBER The duration for which the availability percentage
--                          value needs to be found - can be 1, 7, 31
--
-- OUT Parameters:
--   The NUMBER value of the availability percentage value of the given
--   target guid
--
FUNCTION get_avail_pct_value
  (target_guid_in  IN  mgmt_targets.target_guid%TYPE,
   num_of_days_in  IN  NUMBER)
  RETURN NUMBER;

--
-- FUNCTION: get_avail_pct_value
--
-- PURPOSE:
--   This function returns the availability value as a percentage of the given 
--   target guid
--
-- IN Parameters:
--   target_name_in: VARCHAR2 The name of the target for which the availability
--                            pct value needs to be found
--   target_type_in: VARCHAR2 The type of the target for which the availability
--                            pct value needs to be found
--   target_tz_delta_in: NUMBER The timezone delta value of the given target name, 
--                              target type
--   num_of_days_in: NUMBER The duration for which the availability percentage
--                          value needs to be found - can be 1, 7, 31
--
-- OUT Parameters:
--   The NUMBER value of the availability percentage value of the given
--   target guid
--
-- ERROR CODES:
--   TARGET_DOES_NOT_EXIST: No such target was found. This could also mean
--     that the user does not have access to view this target.
--
FUNCTION get_avail_pct_value
  (target_name_in IN VARCHAR2,
   target_type_in IN VARCHAR2,
   target_tz_delta_in IN mgmt_targets.timezone_delta%TYPE,
   num_of_days_in  IN  NUMBER)
  RETURN NUMBER;

--
-- FUNCTION: get_avail_pct_value
--
-- PURPOSE:
--   This function returns the availability value as a percentage of the given 
--   target guid
--
-- IN Parameters:
--   target_guid_in: RAW The target guid for which the availability percentage
--                       value needs to be found
--   target_tz_delta_in: NUMBER The timezone delta value of the target_guid - 
--                              target_guid_in
--   num_of_days_in: NUMBER The duration for which the availability percentage
--                          value needs to be found - can be 1, 7, 31
--
-- OUT Parameters:
--   The NUMBER value of the availability percentage value of the given
--   target guid
--
FUNCTION get_avail_pct_value
  (target_guid_in  IN  mgmt_targets.target_guid%TYPE,
   target_tz_delta_in IN mgmt_targets.timezone_delta%TYPE,
   num_of_days_in  IN  NUMBER)
  RETURN NUMBER;

--
-- FUNCTION: get_target_max_severity
--
-- PURPOSE:
--   This function returns the maximum severity for the given target name and
--   target type
--
-- IN Parameters:
--   target_name_in: VARCHAR2 The name of the target for which the max severity
--                            needs to be found
--   target_type_in: VARCHAR2 The type of the target for which the max severity
--                            needs to be found
--   target_guid_in: RAW The target guid for which the availability percentage
--                       value needs to be found
--
-- OUT Parameters:
--   The NUMBER value of the max severity for the given target name and target
--   type
--
-- ERROR CODES:
--   TARGET_DOES_NOT_EXIST: No such target was found. This could also mean
--     that the user does not have access to view this target.
--
FUNCTION get_target_max_severity
  (target_name_in IN VARCHAR2,
   target_type_in IN VARCHAR2)
  RETURN NUMBER;

--
-- FUNCTION: get_target_max_severity
--
-- PURPOSE:
--   This function returns the maximum severity for the given target name and
--   target type
--
-- IN Parameters:
--   target_guid_in: RAW The target guid for which the max severity needs to be
--                       found
--
-- OUT Parameters:
--   The NUMBER value of the max severity for the given target name and target
--   type
--
FUNCTION get_target_max_severity
  (target_guid_in  IN  mgmt_targets.target_guid%TYPE)
  RETURN NUMBER;

--
-- FUNCTION: get_target_num_severity
--
-- PURPOSE:
--   This function returns the number of severities for the given target guid
--
-- IN Parameters:
--   target_guid_in: RAW The target guid for which the number of severities needs
--                       to be found
--
-- OUT Parameters:
--   The INTEGER value of the number of severities for the given target guid
--
FUNCTION get_target_num_severity
  (target_guid_in IN mgmt_targets.target_guid%TYPE)
  RETURN INTEGER;

--
-- FUNCTION: get_current_status_timestamp
--
-- PURPOSE:
--   This function returns the start timestamp of current status of the given 
--   target guid or returns null if the timestamp is not found.
--
-- IN Parameters:
--   target_guid_in: RAW The target guid for which the timestamp
--                       needs to be found
--
-- OUT Parameters:
--   The Date value of the timestamp of the given target guid
--
FUNCTION get_current_status_timestamp
  (target_guid_in IN mgmt_targets.target_guid%TYPE)
  RETURN Date;

--
-- FUNCTION: generate_target_guid
--
-- PURPOSE:
--   Given a target name and target type, this function computes the
--   target guid for the target. The guid is an MD5 hash of the target
--   name and type. 
--
-- IN Parameters:
--   p_target_name: The name of the target
--   p_target_type: The type of the target
--
-- RETURN:
--   The generated target guid
--
FUNCTION generate_target_guid(p_target_name IN VARCHAR2,
                              p_target_type IN VARCHAR2) 
         RETURN RAW;


--
-- FUNCTION: generate_target_guid
--
-- PURPOSE:
--   Given a target type and metric name, this function computes the
--   metric guid for the metric. The guid is an MD5 hash of the target
--   type and metric name. 
--
-- IN Parameters:
--   p_target_type: The type of the target
--   p_metric_name: The name of the metric
--
-- RETURN:
--   The generated metric guid
--
FUNCTION generate_metric_guid(p_target_type IN VARCHAR2,
                              p_metric_name IN VARCHAR2)
    RETURN RAW;


--
-- FUNCTION: generate_metric_column_guid
--
-- PURPOSE:
--   Given a target type,  metric name and column name, this function 
--   computes the metric guid for the metric. The guid is an MD5 hash of
--   the target type and metric name. 
--
-- IN Parameters:
--   p_target_type: The type of the target
--   p_metric_name: The name of the metric
--   p_metric_column : The name of the column
--
-- RETURN:
--   The generated metric guid
--
FUNCTION generate_metric_column_guid(p_target_type IN VARCHAR2,
                                     p_metric_name IN VARCHAR2,
                                     p_metric_column IN VARCHAR2)
    RETURN RAW;

--
-- PROCEDURE: add_target
--
-- PURPOSE:
--   This procedure adds a new target to the repository, optionally
--   also adding the target to the specified set of groups. The user
--   calling this procedure must have the CREATE_TARGET system privilege.
--   The user must also have the CREATE_TARGET_IN_GROUP privilege
--   on *each* of the specified groups.
--
-- IN Parameters:
--   p_target_name: The target name to add
--   p_target_type: The target type
--   p_host_name: The host name of the target
--   p_properties: A set of properties to associate with the target
--   p_groups: A list of groups to add the target to
--   p_member_targets: If the target being added is a composite target,
--     a list of members of the target. Membership information can be
--     provided only if the target type has a property called
--     'is_composite' set to 1
--  p_monitoring_credentials: The credentials used for monitoring the
--      target, if any. These should always be specified separately
--      from the other properties
--  p_target_display_name: The display name of target
--  p_agent_url: The agent URL to which the target has to be added.
--  p_tz_rgn : Default value of this parameter should not be set as timezone of SYSTIMESTAMP 
--             because if there is no time zone set for repository DB then SYSTIMESTAMP would 
--             return only offset value and not the correct timezone of repositoty.
--             And hence if p_tz_rgn is NULL, at the time of adding target then system will 
--             read default time zone defined for EM repository in MGMT_PARAMETERS. 
--             It is always desirable that user should pass correct value of timezone, for target which is being added.
--  p_mon_mode : The monitoring mode. Possible values are:
--               MGMT_GLOBAL.G_MON_MODE_DEFAULT
--               MGMT_GLOBAL.G_MON_MODE_OMS_MEDIATED
--               MGMT_GLOBAL.G_MON_MODE_AGENT_MEDIATED    
--               Default: MGMT_GLOBAL.G_MON_MODE_DEFAULT
--  p_repository_only_target : targets not managed by agent, such as OVF
--  p_target_owner : the owner of the target if not specified it is 
--                   default to G_DEFAULT_TARGET_OWNER <SYSTEM>
--
-- OUT Parameters:
--    NONE
--
-- NOTES
--   This API can be used only to add targets and "regular"
--    composite targets (targets whose type has the is_composite=1 
--    property set). It can *not* be used to add a group. To add 
--    a group, use the add_group procedure instead.
--
PROCEDURE add_target(p_target_name IN VARCHAR2, 
                     p_target_type IN VARCHAR2,
                     p_host_name IN VARCHAR2,
                     p_properties IN MGMT_TARGET_PROPERTY_LIST,
                     p_groups IN SMP_EMD_NVPAIR_ARRAY,
                     p_member_targets IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL,
                     p_monitoring_credentials IN SMP_EMD_NVPAIR_ARRAY
                                              DEFAULT NULL,
                     p_target_display_name IN VARCHAR2 DEFAULT NULL,
		     p_agent_url IN VARCHAR2 DEFAULT NULL,
		     p_tz_rgn    IN VARCHAR2 DEFAULT NULL, 
                     p_mon_mode  IN NUMBER 
                         DEFAULT MGMT_GLOBAL.G_MON_MODE_DEFAULT,
                     p_type_meta_ver      IN VARCHAR2 DEFAULT '1.0',
                     p_category_prop_1    IN VARCHAR2 DEFAULT ' ',
                     p_category_prop_2    IN VARCHAR2 DEFAULT ' ',
                     p_category_prop_3    IN VARCHAR2 DEFAULT ' ',
                     p_category_prop_4    IN VARCHAR2 DEFAULT ' ',
                     p_category_prop_5    IN VARCHAR2 DEFAULT ' ',
                     p_repository_only_target IN NUMBER DEFAULT 0,
                     p_target_owner       IN VARCHAR2 DEFAULT NULL);

--
-- PROCEDURE: move_target
--
-- PURPOSE:
--   This procedure "moves" a target in the repository from one
--   emd to another. This is useful when a target is relocated
--   from one machine to another, or another emd is now monitoring
--   it.
--
-- IN Parameters:
--   p_target_name: The target name to add
--   p_target_type: The target type
--   p_new_emd_url: The new emd url for the target
--
-- OUT Parameters:
--     NONE
--
-- NOTES
--   This procedure only moves the target in the repository,
--   and not on the agent. It is the caller's responsibility to
--   ensure that the target is moved on the agent as well.
--
PROCEDURE move_target(p_target_name IN VARCHAR2,
                      p_target_type IN VARCHAR2,
                      p_new_emd_url IN VARCHAR2);
                                     
--
-- PROCEDURE: modify_target
--
-- PURPOSE:
--   Modify the specified properties of the target. If a property does
--   not currently exist, it is inserted
--
-- IN Parameters:
--   p_target_name: The target name to add
--   p_target_type: The target type
--   p_properties: A set of properties to associate with the target
--   p_member_targets_to_add: If non-null, a set of targets to ADD as members
--   p_member_targets_to_remove: If non-null, a set of targets to REMOVE as members
--   p_monitoring_credentials: The credentials used for monitoring the
--      target, if any. These should always be specified separately
--      from the other properties
--
--   p_target_display_name: The display target name
--   p_propagate_to_agent: This is a flag to indicate if the target data should 
--      be propagated to the Agent. If set to 1, the Agent is updated asynchronously 
--      via a job. If set to 0 (the default), the data is not propagated to the Agent.
--   p_target_owner : the new owner of the target  
--         
-- OUT Parameters:
--    NONE
--
PROCEDURE modify_target(p_target_name IN VARCHAR2, 
                        p_target_type IN VARCHAR2,
                        p_properties IN MGMT_TARGET_PROPERTY_LIST,
                        p_member_targets_to_add IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL,
                        p_member_targets_to_remove IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL,
                        p_monitoring_credentials IN SMP_EMD_NVPAIR_ARRAY
                                    DEFAULT NULL,
                        p_target_display_name IN VARCHAR2 DEFAULT NULL,
                        p_propagate_to_agent IN NUMBER DEFAULT 0,
                        p_target_owner       IN VARCHAR2 DEFAULT NULL);

--
-- This API is deprecated. Use mgmt_group.create_group instead.
--
PROCEDURE add_group(p_group_name IN VARCHAR2,
                    p_group_type IN VARCHAR2,
                    p_member_targets IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL,
                    p_group_owner       IN VARCHAR2 DEFAULT NULL,
                    p_timezone_rgn IN VARCHAR2 DEFAULT NULL );

--
-- This API is deprecated. Use mgmt_group.modify_group instead.
--
PROCEDURE modify_group(p_group_name IN VARCHAR2,
                       p_group_type IN VARCHAR2,
                       p_targets_to_add IN SMP_EMD_NVPAIR_ARRAY,
                       p_targets_to_remove IN SMP_EMD_NVPAIR_ARRAY,
                       p_group_owner       IN VARCHAR2 DEFAULT NULL);

PROCEDURE get_type_udtp(p_target_type   IN VARCHAR2,
                        p_type_meta_ver IN VARCHAR2,
                        p_udtp_defs_out OUT CURSOR_TYPE);

-- FOR INTERNAL USE ONLY
--
-- PROCEDURE: get_target_info
--
-- PURPOSE:
--  Retrieve information about the specified target
--   
--
-- IN Parameters:
--  p_target_name: Name of target
--  p_target_type: Type of target
--
-- OUT Parameters:
--  p_basic_info_out: A cursor that returns the following information:
--      target_guid, emd_url, display_name, host_name 
--  p_properties_out: A cursor that returns the following information:
--      property_name, property_value
--      NOTE: Only INSTANCE properties are returned by this method
--  p_prop_defs_out: A cursor that returns the property definitions for all
--      this target type's properties, it includes the following columns:
--        property_name, property_type, property_display_name,
--        property_display_nlsid, required_flag, credential_flag, default_value,
--        computed, all_versions
--      NOTE: Only INSTANCE properties are returned by this method
-- p_compositeinfo_out: A cursor that returns all targets that this target
--     is a member of. It contains the following information:
--       composite_target_name, composite_target_type
-- p_memberinfo_out: A cursor that returns all targets that are members
--     of this target. It contains the following information:
--       member_target_name, member_target_type
-- p_monitor_creds_out: A cursor that returns the monitoring credential
-- information for the target. It contains the following information:
--        credential_column_name, decrypted value
--
PROCEDURE get_target_info(p_target_name IN VARCHAR2,
                          p_target_type IN VARCHAR2,
                          p_basic_info_out OUT CURSOR_TYPE,
                          p_properties_out OUT CURSOR_TYPE,
                          p_prop_defs_out OUT CURSOR_TYPE,
                          p_compositeinfo_out OUT CURSOR_TYPE,
                          p_memberinfo_out OUT CURSOR_TYPE,
                          p_monitor_creds_out OUT CURSOR_TYPE);

PROCEDURE get_target_info(p_target_name IN VARCHAR2,
                          p_target_type IN VARCHAR2,
                          p_basic_info_out OUT CURSOR_TYPE,
                          p_properties_out OUT CURSOR_TYPE,
                          p_compositeinfo_out OUT CURSOR_TYPE,
                          p_memberinfo_out OUT CURSOR_TYPE,
                          p_monitor_creds_out OUT CURSOR_TYPE);

--
-- PROCEDURE: get_delete_target_info
--
-- PURPOSE:
--  Retrieve information about the specified target
--   
--
-- IN Parameters:
--  p_target_name: Name of target
--  p_target_type: Type of target
--
-- OUT Parameters:
--  p_basic_info_out: A cursor that returns the following information:
--      target_guid, emd_url, display_name, host_name 
--  p_properties_out: A cursor that returns the following information:
--      property_name, property_value
--      NOTE: Only INSTANCE properties are returned by this method
-- p_compositeinfo_out: A cursor that returns all targets that this target
--     is a member of. It contains the following information:
--       composite_target_name, composite_target_type
-- p_monitor_creds_out: A cursor that returns the monitoring credential
-- information for the target. It contains the following information:
--        credential_column_name, decrypted value
--
-- p_agent_url_list: A cursor that returns the list of agents for a 
--         multi-agent target.
--
PROCEDURE get_delete_target_info(p_target_name IN VARCHAR2,
                          p_target_type IN VARCHAR2,
                          p_basic_info_out OUT CURSOR_TYPE,
                          p_properties_out OUT CURSOR_TYPE,
                          p_compositeinfo_out OUT CURSOR_TYPE,
                          p_monitor_creds_out OUT CURSOR_TYPE,
                          p_agent_url_list_out OUT CURSOR_TYPE);


--
-- FUNCTION: is_multi_agent_target
--
-- PURPOSE:
--   Given the target name and its type, it determines if the
--   target is capable being registered with multiple agents.
--
-- IN Parameters:
--    p_target_name: the name of the target   
--    p_target_type: the type of the target   
--
-- RETURN
--    1 if this is a multi-agent target; else 0. Note that we are
--    deliberately returning an integer from here so that this
--    can be called from JDBC code
--
-- ERROR CODES:
--   TARGET_DOES_NOT_EXIST_ERR: No such target found in the repository.
--
FUNCTION is_multi_agent_target(p_target_name IN VARCHAR2,
                               p_target_type IN VARCHAR2)
   RETURN NUMBER;


--
-- FUNCTION: get_master_agent_url
--
-- PURPOSE
--   Given a multi-agent target, this function returns the current
--   master agent. Master agent is the agent that is currently
--   collecting metrics for the multi-agent target. RAC database is an
--   example of a multi-agent target.
-- IN parameters:
--   p_target_name : the the name of the target. NULL if this callback
--                   to be called for all targets of p_target_type.
--    p_target_type: the type of the target   
--
-- RETURN
--    EMD url of the master agent
--
-- ERROR CODES:
--   TARGET_DOES_NOT_EXIST_ERR: No such target found in the repository.
--
FUNCTION get_master_agent_url(p_target_name IN VARCHAR2,
                              p_target_type IN VARCHAR2)
   RETURN VARCHAR2;

--
-- FUNCTION: add_master_changed_callback
--
-- PURPOSE
--   Adds a callback that gets by the repository whenever master agent
--   changes for the specified target. The signature of the callback is:
--   PROCEDURE callback_name(v_target_name IN VARCHAR2,
--                           v_target_type IN VARCHAR2,
--                           v_master_agent_url IN VARCHAR2);
--
--  
PROCEDURE add_master_changed_callback(v_target_name IN VARCHAR2,
                                      v_target_type IN VARCHAR2,
                                      v_callback_name IN VARCHAR2);

--
-- FUNCTION: delete_master_changed_callback
--
-- PURPOSE
--   Deletes the callback added by add_master_changed_callback. If the
--   callback name is NULL, then all the callbacks are deleted for
--   the specified target.
--
PROCEDURE delete_master_changed_callback(v_target_name IN VARCHAR2,
                                     v_target_type IN VARCHAR2,
                                     v_callback_name IN VARCHAR2 DEFAULT NULL);


--
-- PROCEDURE: add_tgt_relocation_callback
-- 
-- PURPOSE
--   Adds a callback to the repository. This callback is called whenever 
--   that target is relocated from one agent to another.
-- 
--  PROCEDURE callback_name( target_name   IN VARCHAR2,
--                           target_type   IN VARCHAR2,
--                           old_agent_url IN VARCHAR2,
--                           new_agent_url IN VARCHAR2);
--
--
PROCEDURE add_tgt_relocation_callback( v_callback_name   IN VARCHAR2,
                                     v_target_name IN VARCHAR2 DEFAULT ' ',
                                     v_target_type IN VARCHAR2 DEFAULT ' ');

--
-- PROCEDURE: delete_tgt_relocation_callback
-- 
-- PURPOSE
--   Deletes a callback from repository. if the callback is NULL,
--   all the callbacks for the target is deleted.
-- 
--  PROCEDURE callback_name( target_name   IN VARCHAR2,
--                           target_type   IN VARCHAR2,
--                           old_agent_url IN VARCHAR2,
--                           new_agent_url IN VARCHAR2);
--
--
PROCEDURE delete_tgt_relocation_callback( v_callback_name IN VARCHAR2,
                                   v_target_name IN VARCHAR2 DEFAULT ' ',
                                   v_target_type IN VARCHAR2 DEFAULT ' ');

--
-- PROCEDURE: add_metaver_catprop_callback
-- 
-- PURPOSE
--  Adds a callback to the repository. This callback is called whenever 
--  the metaversion or category prop of a target changes.
--  Additionally the callback can  be restricted to specific target types 
--  and for specific meta versions. 
--
--  The callback is expected to have the following signature
--   
--  PROCEDURE callback_name( mgmt_target_meta_ver_cbk_obj) ;
--
-- It is the registered callback's responsibility to ignore category prop
-- changes  ( it can do : if from_meta_ver= to_meta_ver then return ;)
--
PROCEDURE add_metaver_catprop_callback(p_callback_name  IN VARCHAR2,
                                       p_target_type    IN VARCHAR2,
                                       p_to_meta_ver    IN VARCHAR2 := ' ',
                                       p_eval_order     IN NUMBER := 0
                                       ) ;

--
-- PROCEDURE: del_metaver_catprop_callback
-- 
-- PURPOSE
--  Deletes the callback from repository
--
PROCEDURE del_metaver_catprop_callback(p_callback_name  IN VARCHAR2,
                                       p_target_type    IN VARCHAR2,
                                       p_to_meta_ver    IN VARCHAR2  := ' '
                                     ) ;
--
-- DEPRECATED: Please do not use
-- Use add_metaver_catprop_callback instead
--
PROCEDURE add_metaver_upd_callback(p_callback_name  IN VARCHAR2,
                                   p_target_type    IN VARCHAR2,
                                   p_to_meta_ver    IN VARCHAR2 := ' ',
                                   p_eval_order     IN NUMBER := 0
                                   ) ;
--
-- DEPRECATED: Please do not use
-- Use del_metaver_catprop_callback instead
-- 
PROCEDURE del_metaver_upd_callback(p_callback_name  IN VARCHAR2,
                                   p_target_type    IN VARCHAR2,
                                   p_to_meta_ver    IN VARCHAR2  := ' '
                                 ) ;
--
--
-- PURPOSE
--   To add a list of dependencies that affects the severity state
--   of a metric. The dependencies themselves are metrics. These dependencies
--   are used by the repository to trigger the execution of metric's
--   severity_eval_proc.
--
--   This method allows specifying dependencies at a target type
--   level and meant to be used only for composite target types.
--   
-- PARAMTERS
--
--   v_metric_desc : A MGMT_METRIC_DESC object describing the metric.
--
--   v_dependency_list: A list of MGMT_METRIC_DESC objects containing
--                      the metric dependencies.
--      v_opt_code       : for severity evaluation optimization. 
--                         Constant defined in mgmt_global  
--                         G_REPO_SEV_OPT_NONE 0
--                         G_REPO_SEV_OPT_AND 1
--                         G_REPO_SEV_OPT_OR 2
--                         When the code is set to 1 or 2, availability
--                         evaluation logic will optimized once one dependent
--                         target's availability is enought to derive parent's
--                         availability
--                         If it is NULL and eval_func is standard AND/OR
--                         function defined in mgmt_severity_helper, opt_code
--                         will be derived accordingly.
--                     
-- ERROR CODES
--    NO_SUCH_METRIC_ERR: If the metric in metric_desc is not defined.
--    ALREADY_EXISTS_ERR: If dependencies are already defined for this
--                        metric -or- there are duplicate entries in the
--                        v_dependency_list. Call DELETE_METRIC_SEVERITY_DEPS
--                        to delete existing dependencies.
--
PROCEDURE ADD_METRIC_SEVERITY_DEPS(v_metric_desc IN MGMT_METRIC_DESC,
                                   v_dependency_list IN 
                                             MGMT_METRIC_DESC_ARRAY,
                                   v_opt_code IN NUMBER DEFAULT NULL);
                                            

--
-- PURPOSE
--     Remove the dependency list for a metric for an entire target
--     type.
-- PARAMTERS
--   v_metric_desc : A MGMT_METRIC_DESC object describing the metric.
-- ERROR CODES
--    NO_SUCH_METRIC_ERR  - If there is no such metric 
-- 
PROCEDURE DELETE_METRIC_SEVERITY_DEPS(v_metric_desc IN MGMT_METRIC_DESC);



--
-- This API is DEPRECATED - use add_repo_metric_collection API instead
-- PURPOSE
--   To add a list of dependencies that affects the severity state
--   of a metric for a specific target instance. The dependencies 
--   themselves are metrics. These dependencies are used by the repository
--   to trigger the execution of metric's severity_eval_proc. If 
--   dependency metrics already exist for this metric, then the new
--   dependencies are appended. Duplicate dependencies are ignored.
--
-- PARAMTERS
--
--   v_metric_instance: A MGMT_METRIC_INSTANCE object defining the metric. The
--                   'key_value' attribute is optional.
--
--   v_dependency_list: A list of MGMT_METRIC_INSTANCE objects containing
--                      the metric dependencies.  The 'key_value' attribute
--                      is optional.
--
-- ERROR
--   NO_SUCH_METRIC_ERROR: If any of the metrics don't exist.
--   TARGET_DOES_NOT_EXIST: If any of the targets don't exist.
--                     
PROCEDURE ADD_METRIC_SEVERITY_DEPS(v_metric_instance IN MGMT_METRIC_INSTANCE,
                                   v_dependency_list IN 
                                        MGMT_METRIC_INSTANCE_ARRAY); 


--
-- This API is DEPRECATED - use modify_repo_metric_deps and 
-- delete_repo_metric_collection APIs instead
--
-- PURPOSE
--     Remove the dependency list for a metric of a specific target
--     instance.
-- PARAMTERS
--   v_metric_instance:  A metric instance object.
--
--   v_dependency_list: If NULL, all dependencies are removed for this
--              metric. If not NULL, only the specified depenendecies
--              are removed.
-- 
-- ERROR CODES
--    NO_SUCH_METRIC_ERR  - If there is no such metric 
-- 
PROCEDURE DELETE_METRIC_SEVERITY_DEPS(v_metric_instance IN
                                            MGMT_METRIC_INSTANCE,
                                      v_dependency_list IN 
                                            MGMT_METRIC_INSTANCE_ARRAY); 

--
-- PURPOSE
--   Sets up a repository collection for the specified metric. The
--   collection will apply the eval_proc over the list of dependency
--   metrics to compute the metric. Duplicate dependencies are ignored.
--
-- PARAMTERS
--      v_metric         : The repository metric.
--
--      v_eval_proc      : Name of the eval func that computes the metric;
--                         mgmt_metric_helper package provides evaluation functions
--                         for MIN, MAX, AVG, SUM, MEDIAN cases
--
--      v_dep_metrics    : A list of metric dependencies.
--      v_coll_interval  : collection interval
--      v_opt_code       : for severity evaluation optimization. Constant defined 
--                         in mgmt_global 
--                         G_REPO_SEV_OPT_NONE 0
--                         G_REPO_SEV_OPT_AND 1
--                         G_REPO_SEV_OPT_OR 2
--                         When the code is set to 1 or 2, availability
--                         evaluation logic will optimized once one dependent
--                         target's availability is enought to derive parent's
--                         availability
--                         If it is NULL and eval_func is standard AND/OR
--                         function defined in mgmt_severity_helper, opt_code
--                         will be derived accordingly.
--   ERROR
--      NO_SUCH_METRIC_ERROR: If any of the metrics don't exist.
--      TARGET_DOES_NOT_EXIST: If any of the targets don't exist.
--                     
PROCEDURE ADD_REPO_METRIC_COLLECTION(v_metric          IN MGMT_METRIC_INSTANCE,
                                     v_eval_proc       IN VARCHAR2,
                                     v_dep_metrics     IN 
                                            MGMT_METRIC_INSTANCE_ARRAY,
                                     v_coll_interval IN NUMBER DEFAULT NULL,
                                     v_opt_code  IN NUMBER 
                                                 DEFAULT NULL); 



--
-- PURPOSE
--   Modifies repository collection details for the specified metric. 
--
-- PARAMTERS
--      v_metric     : The repository metric.
--
--      v_eval_proc  : Name of the eval func that computes the metric. The
--                     existing eval-proc will be replaced by this.
--
--      v_dep_metrics : Set of metric dependencies. The existing dependencies
--                      will be replaced by this list.
--      v_coll_interval: if it is null, no change
--      v_opt_code       : for severity evaluation optimization. Constant defined 
--                         in mgmt_global 
--                         G_REPO_SEV_OPT_NONE 0
--                         G_REPO_SEV_OPT_AND 1
--                         G_REPO_SEV_OPT_OR 2
--                         When the code is set to 1 or 2, availability
--                         evaluation logic will optimized once one dependent
--                         target's availability is enought to derive parent's
--                         availability
--                         If it is NULL and eval_func is standard AND/OR
--                         function defined in mgmt_severity_helper, opt_code
--                         will be derived accordingly.
--
--   ERROR
--      NO_SUCH_METRIC_ERROR: If any of the metrics don't exist.
--      TARGET_DOES_NOT_EXIST: If any of the targets don't exist.
--                     
PROCEDURE MODIFY_REPO_METRIC_COLLECTION(v_metric          IN MGMT_METRIC_INSTANCE,
                                        v_eval_proc       IN VARCHAR2,
                                        v_dep_metrics     IN 
                                            MGMT_METRIC_INSTANCE_ARRAY,
                                        v_coll_interval IN NUMBER DEFAULT NULL,
                                        v_opt_code  IN NUMBER 
                                                 DEFAULT NULL); 


--
-- PURPOSE
--   Modifies repository depenndecies details for the specified metric. 
--
-- PARAMTERS
--      v_metric : The repository metric.
--
--      v_dep_metrics_to_add : Metric dependencies to be added.
--
--      v_dep_metrics_to_del : Metric dependencies to be deleted.
--
--
--   ERROR
--      NO_SUCH_METRIC_ERROR: If any of the metrics don't exist.
--      TARGET_DOES_NOT_EXIST: If any of the targets don't exist.
--                     
PROCEDURE MODIFY_REPO_METRIC_DEPS(v_metric IN MGMT_METRIC_INSTANCE,
                                   v_dep_metrics_to_add IN 
                                        MGMT_METRIC_INSTANCE_ARRAY,
                                   v_dep_metrics_to_del IN 
                                        MGMT_METRIC_INSTANCE_ARRAY);

--
-- PURPOSE
--   Sets the eval proc for a repo collection
--      v_opt_code       : for severity evaluation optimization. Constant defined 
--                         in mgmt_global 
--                         G_REPO_SEV_OPT_NONE 0
--                         G_REPO_SEV_OPT_AND 1
--                         G_REPO_SEV_OPT_OR 2
--                         When the code is set to 1 or 2, availability
--                         evaluation logic will optimized once one dependent
--                         target's availability is enought to derive parent's
--                         availability
--                         If it is NULL and eval_func is standard AND/OR
--                         function defined in mgmt_severity_helper, opt_code
--                         will be derived accordingly.
--
PROCEDURE SET_REPO_METRIC_EVAL_PROC(v_metric          IN MGMT_METRIC_INSTANCE,
                                    v_eval_proc       IN VARCHAR2,
                                    v_opt_code  IN NUMBER 
                                                 DEFAULT NULL);


--
-- PURPOSE
--   Sets the eval proc for a repo collection
--
PROCEDURE GET_REPO_METRIC_EVAL_PROC(v_metric          IN MGMT_METRIC_INSTANCE,
                                    v_eval_proc       OUT VARCHAR2);


--
-- PURPOSE
--   Remove a repository metric collection. The metric data is not removed
--   as a result of deleting the collection.
-- PARAMETERS
--   v_metric : The repository metric
-- 
PROCEDURE DELETE_REPO_METRIC_COLLECTION(v_metric IN MGMT_METRIC_INSTANCE);


--
-- PURPOSE
--   populate table mgmt_target_prop_def. If duplicate record is found,
--   upsert happens.  Target name, type meta ver and property name are keys
-- PARAMTERS
--   v_target_type, target type
--   v_type_meta_ver, target type meta version
--   v_property_name, property name
--   v_property_type, property type, such as 'INSTANCE'
--   v_property_display_name,
--   v_property_display_nlsid
--   v_required_flag
--   v_credential_flag, is a credential column
--   v_default_value
--   v_computed_flag, is computed 
--   v_system_flag, is set by system
--   v_all_versions, is appliable to all versions
--   v_read_only_flag, is a read-only (UI) column
--   v_hidden_flag, is a hidden (UI) column
--
PROCEDURE UPSERT_TARGET_PROPERTY_DEF(v_target_type VARCHAR2,
                                  v_type_meta_ver VARCHAR2,
                                  v_property_name VARCHAR2,
                                  v_property_type VARCHAR2,
                                  v_property_display_name VARCHAR2,
                                  v_property_display_nlsid VARCHAR2 DEFAULT NULL,
                                  v_required_flag NUMBER DEFAULT 0,
                                  v_credential_flag NUMBER DEFAULT 0,
                                  v_default_value VARCHAR2 DEFAULT ' ',
                                  v_computed_flag NUMBER DEFAULT 0,
                                  v_system_flag NUMBER DEFAULT 1,
                                  v_all_versions NUMBER DEFAULT 0,
                                  v_read_only_flag NUMBER DEFAULT 0,
                                  v_hidden_flag NUMBER DEFAULT 0);

-- PURPOSE
--    delete target property def
-- PARAMETERS
--
PROCEDURE DELETE_TARGET_PROPERTY_DEF(v_target_type VARCHAR2,
                                     v_type_meta_ver VARCHAR2,
                                     v_property_name VARCHAR2);
                                     
--
-- PROCEDURE : get_user_targets
--
-- PURPOSE
--
--   this is a callback which will be registered to the user_model pkg 
--   user_model pkg will call this procedure to get a list of targets which the 
--   user has
--  
-- PARAMETERS
--
--  user_name_in     - name of the user
--  user_objects_out - list of targets will be appended to user_objects_out
--  type_in          - type of user model callback
--
-- NOTES
--
  
PROCEDURE get_user_targets(user_name_in      IN VARCHAR2,
                           user_objects_out  OUT MGMT_USER_OBJECTS,
                           type_in           IN NUMBER);

--
-- PROCEDURE : drop_user_targets
--
-- PURPOSE
--
--   this is a callback which will be registered to the user_model pkg 
--   user_model pkg will call this procedure to delete the target
--   owned by a user. the target will not be deleted but will be reassigned to "SYSTEM"
--  
-- PARAMETERS
--
--  user_name_in     - name of the user
--  new_user_name_in - the new user name
--  type_in          - type of user model callback
--
-- NOTES
--
        
PROCEDURE drop_user_targets(user_name_in      IN VARCHAR2,
                            type_in           IN NUMBER);

--
-- PROCEDURE : ressign_user_targets
--
-- PURPOSE
--
--   this is a callback which will be registered to the user_model pkg 
--   user_model pkg will call this procedure to ressign the target
--   owned by a user to the new user.
--  
-- PARAMETERS
--
--  user_name_in     - name of the user
--  new_user_name_in - the new user name
--  type_in          - type of user model callback
--
-- NOTES
--
        
PROCEDURE reassign_user_targets(user_name_in      IN VARCHAR2,
                                new_user_name_in  IN VARCHAR2,
                                type_in           IN NUMBER);



  --
  -- Procedure ADD_TZRGN_UPDATE_CALLLBACK
  --
  -- PURPOSE: To add a callback that will be called when a timezone region
  -- of a target is updated in the repository.
  --   Note 1: All the exceptions raised by the callback are logged as system errors
  --   Note 2: Callback names are always stored in UPPER case.
  -- IN parameters:
  --   p_callback_name : The name of the callback procedure. This must
  --      have the following signature: 
  --      PROCEDURE PROC(p_tzrgn_upd IN MGMT_TZRGN_UPDATE_CBK_OBJ)
  --   p_target_type : Target type for which this callback should be called (optional).
  --                   If target type is not specified, then the callback is called
  --                   for targets of all types.
  --                   
  -- OUT parameters: 
  --   No out parameters 
  -- ERROR CODES:
  --   None 
  PROCEDURE add_tzrgn_update_callback(p_callback_name IN VARCHAR2,
                                      p_target_type   IN VARCHAR2 DEFAULT '%',
                                      p_eval_order    IN NUMBER   DEFAULT 0);

  --
  -- Procedure DEL_TZRGN_UPDATE_CALLBACK
  --
  -- PURPOSE: To remove a callback that will be called when timezone region 
  --   of a target is updated in the repository.
  -- IN parameters:
  --   p_callback_name: The name of the callback procedure.
  --   p_target_type : Target type for which this callback should be removed (optional)
  -- OUT parameters: 
  --   No out parameters 
  -- ERROR CODES:
  --   None
  PROCEDURE del_tzrgn_update_callback(p_callback_name IN VARCHAR2,
                                      p_target_type   IN VARCHAR2 DEFAULT '%');

  --
  -- PROCEDURE : set_target_tzrgn
  --
  -- PURPOSE
  --
  --   This procedure updates the target timezone region to the specific region
  --  
  -- PARAMETERS
  --
  --  p_target_name     - name of the target
  --  p_target_type     - the type of the target
  --  p_timezone_region - the new timezone region 
  --
  -- NOTES
  --
  PROCEDURE set_target_tzrgn(p_target_name     IN VARCHAR2,
                             p_target_type     IN VARCHAR2,
                             p_timezone_region IN VARCHAR2);
        

  --
  -- PROCEDURE : set_agent_tzrgn
  --
  -- PURPOSE
  --
  --   This procedure updates the timezone region to the given timezone region
  --   for all the targets monitored by the given agent
  --  
  -- PARAMETERS
  --
  --  p_agent_name      - name of the target
  --  p_timezone_region - the new timezone region 
  --
  -- NOTES
  --
  PROCEDURE set_agent_tzrgn(p_agent_name      IN VARCHAR2,
                            p_timezone_region IN VARCHAR2);

--
-- PROCEDURE : set_instance_target_property
--
-- PURPOSE
--
--   Set the value of a target property with property type INSTANCE.
--  
-- PARAMETERS
--
--  See signature.
--
-- NOTES
-- WARNING: This function does not update any copies of the property that might
-- exist on any agent(s).
--
PROCEDURE set_instance_target_property(
         p_target_name    IN mgmt_targets.target_name%TYPE,
         p_target_type    IN mgmt_targets.target_type%TYPE,
         p_property_name  IN mgmt_target_properties.property_name%TYPE,
         p_property_value IN mgmt_target_properties.property_value%TYPE);

--
-- PROCEDURE : set_target_property
--
-- PURPOSE
--
--   Set the value of a target property.
--  
-- PARAMETERS
--
--  See signature.
--
-- NOTES
-- WARNING: This function does not update any copies of the property that might
-- exist on any agent(s).
--
PROCEDURE set_target_property(
         p_target_name    IN mgmt_targets.target_name%TYPE,
         p_target_type    IN mgmt_targets.target_type%TYPE,
         p_property_name  IN mgmt_target_properties.property_name%TYPE,
         p_property_type  IN mgmt_target_properties.property_type%TYPE,
         p_property_value IN mgmt_target_properties.property_value%TYPE);

--
-- PROCEDURE : set_target_properties
--
-- PURPOSE
--
--   Set the value of a set of target properties.
--  
-- PARAMETERS
--
--  See signature.
--
-- NOTES
-- WARNING: This function does not update any copies of the properties that 
-- might exist on any agent(s).
--
PROCEDURE set_target_properties(
         p_target_name    IN mgmt_targets.target_name%TYPE,
         p_target_type    IN mgmt_targets.target_type%TYPE,
         p_properties     IN MGMT_TARGET_PROPERTY_LIST);


--
-- FUNCTION: is_aggregate_type
--
-- PURPOSE: 
--   Return whether the sepecified target type is an aggregate type
-- 
-- IN Parameters:
--   p_target_type: VARCHAR2 The target type
-- 
-- Return Value:
--   0 the specified type is not an aggregate type
--   1 the specified type is an aggregate type

FUNCTION is_aggregate_type( p_target_type IN VARCHAR2)
                            RETURN NUMBER;

  --
  -- PROCEDURE : get_agent_version
  --
  -- PURPOSE
  --
  --   Gets the agent version.
  --  
  -- PARAMETERS
  --    IN parameters
  --         p_emd_url: emd_url of the agent
  --    OUT parameters 
  --         p_agent_version: version of the agent
  --  See signature.
  --
  -- NOTES
  --
  PROCEDURE get_agent_version
  (
    p_emd_url IN mgmt_targets.emd_url%TYPE,
    p_agent_version OUT mgmt_target_properties.property_value%TYPE
  );

  --
  -- PROCEDURE: remove_cluster_member
  --
  -- PURPOSE: 
  --   Remove the cluster member from the cluster target.
  -- 
  -- IN PARAMETERS:
  --   p_cluster_name: Name of the cluster target.
  --   p_cluster_type: Target type of the cluster target.
  --   p_member_name: Name of the member target.
  --   p_member_type: Target type of the member target.
  --   
  -- OUT PARAMETERS
  --   No out parameters.
  --
  -- NOTES
  --   This api does not delete the cluster member, it just removes the
  --   association with the cluster target.
  -- 
  PROCEDURE remove_cluster_member
  (
    p_cluster_name IN mgmt_targets.target_name%TYPE,
    p_cluster_type IN mgmt_targets.target_type%TYPE,
    p_member_name IN mgmt_targets.target_name%TYPE,
    p_member_type IN mgmt_targets.target_type%TYPE
  );

  --
  -- PROCEDURE: set_master_agent
  --
  -- PURPOSE:
  --   To set the specific agent to be the master agent.
  --
  -- IN PARAMETERS:
  --   p_target_name: The cluster target for which the master agent is to be set.
  --   p_target_type: The cluster target type.
  --   p_agent_name : The agent name which should be set as the master agent.
  --
  -- OUT PARAMETERS:
  --  No out parameters.
  --
  -- NOTES
  --
  PROCEDURE set_master_agent
  (
    p_target_name IN mgmt_targets.target_name%TYPE,
    p_target_type IN mgmt_targets.target_type%TYPE,
    p_agent_name IN  mgmt_targets.target_name%TYPE
  );

  --
  -- PROCEDURE: eval_repo_target_status 
  --
  -- PURPOSE: To evaluate the status of a target that has a repository side Response metric.
  --
  -- IN PARAMETERS:
  --   p_target_guid : GUID of the target whose status need to be evaluated.
  --
  -- OUT PARAMETERS
  --   NONE
  -- 
  --  This API will evaluate the status immediately if the group consist of only single target.
  --  If group has mulpliple memebers then staus evaluation can be postphomed depending upon the 
  --  marker timestamp of the members target.
  --
  PROCEDURE eval_repo_target_status
  (
    p_target_guid mgmt_targets.target_guid%type
  );

END mgmt_target;			       
/
show errors;

