Rem
Rem $Header: sdk_template_pkgdef.sql 21-jun-2007.11:12:05 dgiaimo Exp $
Rem
Rem sdk_template_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_template_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    dgiaimo     06/21/07 - Overloading get_template_settings
Rem    rkpandey    04/30/07 - Add COPY_ALL_WITH_RETAIN
Rem    vmotamar    02/09/06 - EMCLI template operations
Rem    pratagar    07/25/06 - Backport pratagar_bug-4653111 from main 
Rem    rzazueta    07/05/05 - Fix 4435559 
Rem    rzazueta    06/16/05 - Add new delete_template_copy 
Rem    rpinnama    06/23/05 - Add get_template_settings API 
Rem    rpinnama    03/02/05 - Move apply_template to SDK 
Rem    rpinnama    02/21/05 - Define constants for different types of template 
Rem                           copy 
Rem    rpinnama    02/18/05 - Add module name 
Rem    rpinnama    10/10/04 - Change template to mntr 
Rem    rpinnama    10/06/04 - Add UDM credential support while creating 
Rem                           template copy 
Rem    rpinnama    09/30/04 - 
Rem    kmanicka    09/20/04 - add user_model callbacks
Rem    rpinnama    09/28/04 - Modify the signature of modify_template 
Rem    rpinnama    09/22/04 - 
Rem    rpinnama    07/30/04 - Implement create_template API 
Rem    rpinnama    07/30/04 - Provide get_template_guid API 
Rem    rpinnama    07/26/04 - rpinnama_add_policy_api
Rem    rpinnama    07/14/04 - Created
Rem


CREATE OR REPLACE PACKAGE mgmt_template
AS

  -- The module name for error and performance logging
  G_MODULE_NAME constant varchar2(40) := 'MGMT_TEMPLATE';

  G_TEMPLATE_COPY_ALL          CONSTANT NUMBER := 0;
  G_TEMPLATE_COPY_COMMON       CONSTANT NUMBER := 1;
  G_TMPL_COPY_ALL_WITH_RETAIN   CONSTANT NUMBER  := 2;
  TYPE cursorType IS REF CURSOR;

  --
  -- FUNCTION: generate_template_guid
  --
  -- PURPOSE:
  --   Given a target type,  template name, this function 
  --   computes the template guid for the template. The guid is an MD5 hash of
  --   the target type and template name. 
  --
  -- IN Parameters:
  --   p_target_type: The type of the target
  --   p_template_name: The name of the template
  --
  -- RETURN:
  --   The generated template guid
  --
  FUNCTION generate_template_guid(p_target_type   IN VARCHAR2,
                                  p_template_name IN VARCHAR2)
    RETURN RAW;

  --
  -- FUNCTION: get_template_guid
  --
  -- PURPOSE:
  --   Given a target type,  template name, this function 
  --   looks up the template guid from the templates table.
  --
  -- IN Parameters:
  --   p_target_type: The type of the target
  --   p_template_name: The name of the template
  --
  -- RETURN:
  --   The fetched template guid
  --
  FUNCTION get_template_guid(p_target_type   IN VARCHAR2,
                             p_template_name IN VARCHAR2)
    RETURN RAW;


  -- 
  -- Gets the monitoring settings, which include
  --    List of metircs and thresholds specified on them
  --    List of policies and policy parameters specified for them
  --    List of collections (both agent and repository) with their properties, 
  --            schedule and credentials
  --
  PROCEDURE get_template_settings(
      p_target_type        IN VARCHAR2,
      p_template_name      IN VARCHAR2,
      p_metric_list        OUT MGMT_MNTR_METRIC_ARRAY,
      p_policy_list        OUT MGMT_MNTR_POLICY_ARRAY,
      p_collection_list    OUT MGMT_MNTR_COLLECTION_ARRAY);

  -- 
  -- Gets the monitoring settings for export to an xml file, which include
  --    Description
  --    Is Public Flag
  --    OMS Version
  --    Owner
  --    List of metrics and thresholds specified on them
  --    List of policies and policy parameters specified for them
  --    List of collections (both agent and repository) with their properties, 
  --            schedule and credentials
  --
  PROCEDURE get_template_settings(
      p_target_type        IN VARCHAR2,
      p_template_name      IN VARCHAR2,
      p_description        OUT VARCHAR2,
      p_is_public          OUT NUMBER,
      p_oms_version        OUT VARCHAR2,
      p_owner              OUT VARCHAR2,
      p_metric_list        OUT MGMT_MNTR_METRIC_ARRAY,
      p_policy_list        OUT MGMT_MNTR_POLICY_ARRAY,
      p_collection_list    OUT MGMT_MNTR_COLLECTION_ARRAY);

  --
  -- PROCEDURE: create_template
  --
  -- PURPOSE:
  --   Creates template for a given target type
  --
  PROCEDURE create_template(
      p_target_type        IN VARCHAR2,
      p_template_name      IN VARCHAR2,
      p_description        IN VARCHAR2 DEFAULT NULL,
      p_is_public          IN NUMBER   DEFAULT 0,
      p_access_list        IN MGMT_TEMPLATE_ACCESS_ARRAY DEFAULT NULL,
      p_metric_list        IN MGMT_MNTR_METRIC_ARRAY DEFAULT NULL,
      p_policy_list        IN MGMT_MNTR_POLICY_ARRAY DEFAULT NULL,
      p_collection_list    IN MGMT_MNTR_COLLECTION_ARRAY DEFAULT NULL);

  --
  -- PROCEDURE: modify_template
  --
  -- PURPOSE:
  --   Modifies the template definition and the list of metrics
  --   policies, collections associated with it
  --   Cannot change owner
  --
  -- p_target_type The target type 
  -- p_template_name The template name to be modified
  -- p_description   The modified description of the template
  --                 If NULL, the old description is retained
  -- p_is_public     Flag identifying whether the template is public or not.
  -- p_acess_list    A list of modified user privileges
  --                 Privileges supported are 
  --                  VIEW_TEMPLATE - Provides view access
  --                  FULL_TEMPLATE - Provides full access
  --                  NULL - No access to template
  -- p_metric_list   A list of metric configurations stored with the template
  -- p_policy_list   A list of policy configurations stored with the template
  -- p_collection_list A list of collection configurations stored with the template
  --
  PROCEDURE modify_template(
      p_target_type        IN VARCHAR2,
      p_template_name      IN VARCHAR2,
      p_description        IN VARCHAR2 DEFAULT NULL,
      p_is_public          IN NUMBER   DEFAULT NULL,
      p_access_list        IN MGMT_TEMPLATE_ACCESS_ARRAY DEFAULT NULL,
      p_metric_list        IN MGMT_MNTR_METRIC_ARRAY DEFAULT NULL,
      p_policy_list        IN MGMT_MNTR_POLICY_ARRAY DEFAULT NULL,
      p_collection_list    IN MGMT_MNTR_COLLECTION_ARRAY DEFAULT NULL);

  --
  -- PROCEDURE: delete_template
  --
  -- PURPOSE:
  --   Deletes a given template
  --
  PROCEDURE delete_template(
      p_target_type        IN VARCHAR2,
      p_template_name      IN VARCHAR2);


  -- 
  -- PROCEDURE apply_template 
  -- 
  -- PURPOSE:
  --   procedure to apply a template to a specified destination list. 
  -- 
  -- p_template_name The source template name 
  -- p_target_type The target type 
  -- p_destination_list The set of destination targets 
  -- p_copy_common_only_flags An array that is as large as the number of 
  --   destination targets. For each target, it specifies whether to  copy the common 
  --   thresholds only (1) or all the thresholds (0) from the source. 
  -- p_ca_creds A list of credentials for corrective actions.
  -- p_coll_creds A list of collection credentials
  -- p_update_master_agents This is a flag that indicates how to deal with multi-agent 
  --   targets in the destination list. If set to true (1), the master agent as well as all the 
  --   standby agents monitoring the multi-agent target are updated. If set to false (0), 
  --   only the standby agents are updated, but not the master. 
  -- p_schedule An optional schedule 
  -- 
  PROCEDURE apply_template(p_template_name IN VARCHAR2, 
                           p_target_type IN VARCHAR2, 
                           p_destination_list IN MGMT_TARGET_ARRAY, 
                           p_copy_common_only_flags IN MGMT_INTEGER_ARRAY, 
                           p_ca_creds IN MGMT_MNTR_CA_ARRAY DEFAULT NULL,
                           p_coll_creds IN MGMT_COLLECTION_CRED_ARRAY DEFAULT NULL,
                           p_update_master_agents IN NUMBER DEFAULT 1, 
                           p_schedule IN MGMT_JOB_SCHEDULE_RECORD DEFAULT NULL);


  -- Template copy API
  --
  -- FUNCTION: generate_template_copy_guid
  --
  -- PURPOSE:
  --   Generates a template copy guid with given target_type
  --   template_name, target_name and copy_req_guid
  --
  FUNCTION generate_template_copy_guid (
      p_target_type        IN VARCHAR2,
      p_template_name      IN VARCHAR2,
      p_target_name        IN VARCHAR2 DEFAULT ' ',
      p_copy_req_guid      IN RAW)
     RETURN RAW;

  --
  -- FUNCTION: get_template_copy_guid
  --
  -- PURPOSE:
  --   Looks up the template copy guid.
  --
  FUNCTION get_template_copy_guid (
      p_target_type        IN VARCHAR2,
      p_template_name      IN VARCHAR2,
      p_target_name        IN VARCHAR2 DEFAULT ' ',
      p_copy_req_guid      IN RAW)
     RETURN RAW;

  -- 
  -- Gets the monitoring settings, which include
  --    List of metircs and thresholds specified on them
  --    List of policies and policy parameters specified for them
  --    List of collections (both agent and repository) with their properties, 
  --            schedule and credentials
  --
  PROCEDURE get_template_copy_settings(
      p_target_type        IN VARCHAR2,
      p_template_name      IN VARCHAR2,
      p_target_name        IN VARCHAR2 DEFAULT ' ',
      p_copy_req_guid      IN RAW,
      p_metric_list        OUT MGMT_MNTR_METRIC_ARRAY,
      p_policy_list        OUT MGMT_MNTR_POLICY_ARRAY,
      p_collection_list    OUT MGMT_MNTR_COLLECTION_ARRAY);

  --
  --
  -- FUNCTION: create_template_copy
  --
  -- PURPOSE:
  --   Creates a template copy of the required template
  --
  FUNCTION create_template_copy (
      p_target_type       IN VARCHAR2,
      p_template_name     IN VARCHAR2,
      p_target_name       IN VARCHAR2 DEFAULT ' ',
      p_copy_req_guid     IN RAW,
      p_copy_type         IN NUMBER,
      p_ca_creds          IN MGMT_MNTR_CA_ARRAY DEFAULT NULL,
      p_coll_creds        IN MGMT_COLLECTION_CRED_ARRAY DEFAULT NULL)
    RETURN RAW;

  --
  --
  -- FUNCTION: create_template_clone
  --
  -- PURPOSE:
  --   Creates a cloned template copy of the required template
  --
  FUNCTION create_template_clone (
      p_target_type       IN VARCHAR2,
      p_template_name     IN VARCHAR2,
      p_target_name       IN VARCHAR2 DEFAULT ' ',
      p_copy_req_guid     IN RAW,
      p_copy_type         IN NUMBER,
      p_ca_creds          IN MGMT_MNTR_CA_ARRAY DEFAULT NULL,
      p_coll_creds        IN MGMT_COLLECTION_CRED_ARRAY DEFAULT NULL)
    RETURN RAW;

  --
  --
  -- FUNCTION: create_template_copy_clone
  --
  -- PURPOSE:
  --   Creates a template copy from a cloned template
  --
  FUNCTION create_template_copy_clone (
      p_target_type         IN VARCHAR2,
      p_template_clone_guid IN RAW,
      p_target_name         IN VARCHAR2 DEFAULT ' ',
      p_copy_req_guid       IN RAW)
    RETURN RAW;

  --
  -- PROCEDURE: delete_template_copy
  --
  -- PURPOSE:
  --   Deletes the specified template copy
  --
  PROCEDURE delete_template_copy (
      p_target_type        IN VARCHAR2,
      p_template_name      IN VARCHAR2,
      p_target_name        IN VARCHAR2 DEFAULT ' ',
      p_copy_req_guid      IN RAW
   );

  --
  -- PROCEDURE: delete_template_copy
  --
  -- PURPOSE:
  --   Deletes the specified template copy
  --
  PROCEDURE delete_template_copy (
      p_template_copy_guid IN RAW
   );

  --
  -- PROCEDURE: save_template_copy_to_target
  --
  -- PURPOSE:
  --   Saves the template copy to the target
  --
  PROCEDURE save_template_copy_to_target (
      p_template_copy_guid IN RAW,
      p_target_guid        IN RAW);

--
-- PROCEDURE : get_user_templates
--
-- PURPOSE
--
--   this is a callback which will be registered to the user_model pkg 
--   user_model pkg will call this procedure to get a list of templets which the 
--   user has
--  
-- PARAMETERS
--
--  user_name_in     - name of the user
--  user_objects_out - list of templets will be appended to user_objects_out
--  type_in          - type of user model callback
--
-- NOTES
--
  
    PROCEDURE get_user_templates(user_name_in      IN VARCHAR2,
                                 user_objects_out  OUT MGMT_USER_OBJECTS,
                                 type_in           IN NUMBER);

--
-- PROCEDURE : drop_user_templates
--
-- PURPOSE
--
--   this is a callback which will be registered to the user_model pkg 
--   user_model pkg will call this procedure to drop the templets
--   owned by a user.
--  
-- PARAMETERS
--
--  user_name_in     - name of the user
--  type_in          - type of user model callback
--
-- NOTES
--
        
  PROCEDURE drop_user_templates(user_name_in      IN VARCHAR2,
                                type_in           IN NUMBER);

--
-- PROCEDURE : reassign_user_templates
--
-- PURPOSE
--
--   this is a callback which will be registered to the user_model pkg 
--   user_model pkg will call this procedure to reassign the templets
--   owned by a user to the new user
--  
-- PARAMETERS
--
--  user_name_in     - name of the user
--  new_user_name_in - the new user name
--  type_in          - type of user model callback
--
-- NOTES
--
        
  PROCEDURE reassign_user_templates(user_name_in      IN VARCHAR2,
                                    new_user_name_in  IN VARCHAR2,
                                    type_in           IN NUMBER);


-- Purpose : To determine the template guid and applicable target type of template
-- Input Parameters
-- p_template_name	: Name of template, for which the info is reqd
-- Output Parameters
-- p_template_guid	: Template guid
-- p_target_type	: Target type to which the template is applicable to
   PROCEDURE get_template_info
   (
       p_template_name         IN  VARCHAR2,
       p_template_guid         OUT RAW,
       p_target_type           OUT VARCHAR2
   );

-- Purpose : Listed below 
--          1> Get the list of valid targets in database.
--          2> Scan the above list for composite target types.
--          3> Invoke the private function to get flattened list of applicable targets
--              in the composite targets types.
--          4> Append the flat targets to the original list of valid targets, remove duplicates
--          5> Populate the list of invalid targets (from the input the user has specified)
--          6> Populate the list of not applicable targets (from the input specified)
--          7> Populate the list of targets which are not supported by agent,etc
-- Input Parameters
-- p_template_target_type   : Target type, the template is applicable to
-- p_tgt_name_type_list     : Array of target names and their types
-- p_mode                   : Mode - wildcard/disabled collection etc
-- Output Parameters
-- p_targets_list               : List of valid target names and their types in database
-- p_na_targets_list            : List of not applicable target names and their types 
-- p_invalid_targets_list       : List of invalid target names and their types
-- p_invalid_mode_targets_list  : List of invalid target names and their types due to disabled 
--					                collection,etc
   PROCEDURE get_targets_info
   (
       p_template_target_type          IN  VARCHAR2,
       p_tgt_name_type_list            IN  MGMT_TARGET_ARRAY,
       p_mode                          IN  VARCHAR2 DEFAULT NULL,
       p_targets_list                  OUT MGMT_TARGET_ARRAY,
       p_na_targets_list               OUT MGMT_TARGET_ARRAY,
       p_invalid_targets_list          OUT MGMT_TARGET_ARRAY,
       p_invalid_mode_targets_list     OUT MGMT_TARGET_ARRAY
   );


END;
/

show errors;

