Rem
Rem $Header: sdk_topology_pkgdef.sql 10-jul-2005.22:24:21 nigupta Exp $
Rem
Rem sdk_topology_pkgdef.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_topology_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    nigupta     07/10/05 - nigupta_bug-4291620
Rem    nigupta     07/08/05 - Created
Rem

CREATE OR REPLACE PACKAGE mgmt_topology AS

  TYPE cursorType IS REF CURSOR;

  -- 
  -- PROCEDURE: get_background_image
  -- 
  -- PURPOSE:
  --   Returns the background image for a particular topoology graph.
  --
  -- IN Parameters:
  --   topo_page_type_in: mgmt_topo_bg_image.topo_page_type%TYPE The 
  --     for the type of topology page. For eg. for the System Topology page, 
  --     whose background image does not vary from instance to instance of of 
  --     the page, this parameter is sufficient to uniquely identify the 
  --     background image.
  --   page_instance_id_in: mgmt_topo_bg_image.page_instance_id%TYPE The 
  --     identifier for a page instance. For eg. System Topology page has 
  --     different background images for different systems, which are 
  --     identified by system's GUID. Here, page type and page instance id 
  --     together uniquely identify the background image.
  --
  --
  -- OUT Parameters:
  --   image_data_out: cursorType A cursor containing:
  --     image_name: mgmt_topo_page_bg_image.image_name%TYPE the name of the 
  --       background image..
  --     image_data: mgmt_topo_page_bg_image.image_data%TYPE the data for the 
  --       background image
  PROCEDURE get_background_image
    (topo_page_type_in IN mgmt_topo_page_bg_image.topo_page_type%TYPE,
     page_instance_id_in IN mgmt_topo_page_bg_image.page_instance_id%TYPE,
     image_data_out OUT cursorType);


  -- 
  -- PROCEDURE: update_background_image
  -- 
  -- PURPOSE:
  --   Updates the background image for a graph. 
  --
  -- IN Parameters:
  --   topo_page_type_in: mgmt_topo_bg_image.topo_page_type%TYPE The 
  --     for the type of topology page. 
  --   page_instance_id_in: mgmt_topo_bg_image.page_instance_id%TYPE The 
  --     identifier for a page instance. 
  --   edit_mode_in: INTEGER whether it is edit or create mode
  --   image_name_in: mgmt_topo_page_bg_image.image_name%TYPE The name of the 
  --     background image for the graph
  --   image_data_in: mgmt_topo_page_bg_image.image_data%TYPE The background 
  --     image for the graph 
  PROCEDURE update_background_image
    (topo_page_type_in IN mgmt_topo_page_bg_image.topo_page_type%TYPE,
     page_instance_id_in IN mgmt_topo_page_bg_image.page_instance_id%TYPE,
     edit_mode_in IN INTEGER,
     image_name_in IN mgmt_topo_page_bg_image.image_name%TYPE,
     image_data_in IN mgmt_topo_page_bg_image.image_data%TYPE);

END mgmt_topology;

/

show errors;

