Rem drv: <create type="types" params="EM_REPOS_USER" pos="-"/>
Rem
Rem $Header: sdk_types.sql 17-aug-2005.20:02:34 jsadras Exp $
Rem
Rem sdk_types.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_types.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jsadras     08/17/05 - type_meta_ver_cbk_obj/array additions 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    rpinnama    06/23/05 - Add mgmt_tzrgn_update_cbk_obj 
Rem    jsadras     05/30/05 - property change type 
Rem    jsadras     03/14/05 - target metaver callback object 
Rem    dcawley     03/03/05 - Create private application context 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    jsadras     12/23/04 - target name length 
Rem    jsadras     12/17/04 - target_array
Rem    jsadras     12/08/04 - mgmt_date_table
Rem    jsadras     11/09/04 - mgmt_metric_name_array
Rem    rzazueta    11/01/04 - Add EM_REPOS_USER parameter 
Rem    jsadras     10/13/04 - mgmt_integer_table
Rem    jsadras     10/06/04 - short_string_table
Rem    kmanicka    09/18/04 - Added type MGMT_USER_OBJECTS
Rem    streddy     08/10/04 - Added new function to metric objects 
Rem    dcawley     07/28/04 - Remove unused types 
Rem    jsadras     07/23/04 - add mgmt_target_guid_array 
Rem    rpinnama    06/20/04 - Add generic types like mgmt_integer_array 
Rem    streddy     09/25/03 - Added type_meta_ver 
Rem    streddy     03/18/03 - Added types for specifying metric dependencies
Rem    dcawley     12/10/02 - Change target_guid to guid
Rem    rpinnama    09/18/02 - Make all type creation create or replace
Rem    skini       07/12/02 - target_name column change
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Created
Rem

Rem 
Rem This script requires the following arguments
Rem  1. Name of the repository user
Rem 
DEFINE EM_REPOS_USER           = "&1"

--
-- Create the MGMT_USER role
--
CREATE ROLE MGMT_USER;
GRANT CREATE SESSION TO MGMT_USER;
GRANT MGMT_USER TO &EM_REPOS_USER WITH ADMIN OPTION;

--
-- Create the private application context for storing the current user
-- name
--
CREATE OR REPLACE CONTEXT em_user_context 
USING SETEMUSERCONTEXT;

-- Create the type for returning objects owned by the user
CREATE OR REPLACE TYPE MGMT_USER_OBJECT IS OBJECT
(
 object_type        VARCHAR2(20),
 object_name        VARCHAR2(256),
 object_sub_type    VARCHAR2(256),
 async_drop         INTEGER(1)
);
/

CREATE OR REPLACE TYPE MGMT_USER_OBJECTS IS TABLE OF MGMT_USER_OBJECT;
/

-- Create the type for returning privilege information
CREATE OR REPLACE TYPE MGMT_USER_PRIVILEGE IS OBJECT
(priv_name    VARCHAR2(30),
 priv_type    NUMBER,
 guid         RAW(16),
 target_name  VARCHAR2(256),
 target_type  VARCHAR2(1024),
 user_defined NUMBER
);
/
CREATE OR REPLACE TYPE MGMT_USER_PRIVILEGES IS TABLE OF MGMT_USER_PRIVILEGE;
/

CREATE OR REPLACE TYPE MGMT_USER_GUID_ARRAY IS TABLE OF RAW(16);
/


CREATE OR REPLACE TYPE MGMT_INTEGER_ARRAY AS VARRAY(5000) OF INTEGER;
/

CREATE OR REPLACE TYPE MGMT_SHORT_STRING_ARRAY AS VARRAY(5000) OF VARCHAR2(64);
/

CREATE OR REPLACE TYPE MGMT_MEDIUM_STRING_ARRAY AS VARRAY(5000) OF VARCHAR2(256);
/

CREATE OR REPLACE TYPE MGMT_LONG_STRING_ARRAY AS VARRAY(5000) OF VARCHAR2(1024);
/

CREATE OR REPLACE TYPE MGMT_MAX_STRING_ARRAY AS VARRAY(5000) OF VARCHAR2(4000);
/

CREATE OR REPLACE TYPE MGMT_SHORT_STRING_TABLE AS TABLE OF VARCHAR2(64);
/

CREATE OR REPLACE TYPE MGMT_MEDIUM_STRING_TABLE AS TABLE OF VARCHAR2(256)
/

CREATE OR REPLACE TYPE MGMT_INTEGER_TABLE AS TABLE OF INTEGER
/

CREATE OR REPLACE TYPE MGMT_DATE_TABLE AS TABLE OF DATE
/
CREATE OR REPLACE TYPE MGMT_TARGET_OBJ AS OBJECT 
(
  target_name VARCHAR2(256),
  target_type VARCHAR2(64),
  STATIC FUNCTION new(p_target_name VARCHAR2,
                      p_target_type VARCHAR2
                      )
 RETURN mgmt_target_obj
)
/

CREATE OR REPLACE TYPE MGMT_TARGET_ARRAY AS TABLE OF MGMT_TARGET_OBJ
/ 

CREATE OR REPLACE TYPE MGMT_TARGET_PROPERTY AS OBJECT (
    property_name VARCHAR2(64),
    property_type VARCHAR2(64),
    property_value VARCHAR2(1024)
);
/

CREATE OR REPLACE TYPE MGMT_TARGET_PROPERTY_LIST AS TABLE OF MGMT_TARGET_PROPERTY;
/

CREATE OR REPLACE TYPE MGMT_TARGET_GUID_ARRAY AS TABLE OF RAW(16)
/
--
--Callback objects for type meta version change
--
CREATE OR REPLACE TYPE MGMT_TARGET_META_VER_CBK_OBJ AS OBJECT (
 target_guid        RAW(16),
 target_type        VARCHAR2(64),
 from_meta_ver      VARCHAR2(64),
 to_meta_ver        VARCHAR2(64),
 from_catprop_array mgmt_short_string_array,
 to_catprop_array   mgmt_short_string_array,
 STATIC FUNCTION NEW(p_target_guid        RAW,
                     p_target_type        VARCHAR2,
                     p_from_meta_ver      VARCHAR2,
                     p_to_meta_ver        VARCHAR2,
                     p_from_catprop_array mgmt_short_string_array,
                     p_to_catprop_array   mgmt_short_string_array
                     )
 RETURN MGMT_TARGET_META_VER_CBK_OBJ
);
/

CREATE OR REPLACE TYPE MGMT_TARGET_META_VER_CBK_ARRAY AS TABLE OF MGMT_TARGET_META_VER_CBK_OBJ
/

--
-- Callback object for target property change
--
CREATE OR REPLACE TYPE MGMT_TARGET_PROPERTY_CBK_OBJ AS OBJECT (
  target_guid        RAW(16),
  property_name      VARCHAR2(64),
  old_property_value VARCHAR2(1024),
  new_property_value VARCHAR2(1024),
  STATIC FUNCTION NEW(p_target_guid        IN RAW,
                      p_property_name      IN VARCHAR2,
                      p_old_property_value IN VARCHAR2,
                      p_new_property_value IN VARCHAR2
                      )
  RETURN MGMT_TARGET_PROPERTY_CBK_OBJ
) ;
/

-- Object to describe a metric - used in mgmt_target APIs.
-- NOTE: Do not directly instantiate the object. Always
-- use the "NEW" function to instantiate the object to
-- avoid backwards compatibility problems.
CREATE OR REPLACE TYPE MGMT_METRIC_DESC as OBJECT (
    target_type        VARCHAR2(64),
    metric_name        VARCHAR2(64),
    metric_column      VARCHAR2(64),
    type_meta_ver      VARCHAR2(8),
    STATIC FUNCTION NEW(target_type    VARCHAR2,
                        metric_name    VARCHAR2,
                        metric_column  VARCHAR2,
                        type_meta_ver  VARCHAR2 DEFAULT '1.0')
   RETURN MGMT_METRIC_DESC
);
/

CREATE OR REPLACE TYPE MGMT_METRIC_DESC_ARRAY as TABLE of MGMT_METRIC_DESC;
/


-- Object to describe a metric instance - used in mgmt_target APIs.
-- NOTE: Use "NEW" function to instantiate the objects.
CREATE OR REPLACE TYPE MGMT_METRIC_INSTANCE as OBJECT (
    target_name        VARCHAR2(256),
    target_type        VARCHAR2(64),
    metric_name        VARCHAR2(64),
    metric_column      VARCHAR2(64),
    key_value          VARCHAR2(256),
    STATIC FUNCTION NEW(target_name    VARCHAR2,
	                target_type    VARCHAR2,
                        metric_name    VARCHAR2,
                        metric_column  VARCHAR2,
	                key_value      VARCHAR2)
     RETURN MGMT_METRIC_INSTANCE
);
/

CREATE OR REPLACE TYPE MGMT_METRIC_INSTANCE_ARRAY as TABLE of MGMT_METRIC_INSTANCE;
/

--
-- PURPOSE
--     Object to temporarily hold the state of a dependency metric
--     during severity calculations. 
--
--  MEMBERS
--     target_guid - guid of the dependency target
--     metric_guid - guid of the dependency metric
--     severity_code - severity code of the metric.
--     avail_status -  Availability state of the target 
CREATE OR REPLACE TYPE MGMT_METRIC_DETAILS as OBJECT (
   target_guid      RAW(16),
   metric_guid      RAW(16),
   key_value        VARCHAR2(256),
   severity_code    NUMBER,
   avail_status     NUMBER,
    STATIC FUNCTION NEW(target_guid    RAW,
	                metric_guid    RAW,
	                key_value      VARCHAR2,
                        severity_code  NUMBER,
	                avail_status   NUMBER)
     RETURN MGMT_METRIC_DETAILS 
);
/
CREATE OR REPLACE TYPE MGMT_METRIC_DETAILS_ARRAY 
    as TABLE of MGMT_METRIC_DETAILS;
/

CREATE OR REPLACE TYPE mgmt_metric_name_obj AS OBJECT
( metric_name   VARCHAR2(64),
  metric_column VARCHAR2(64),
  STATIC FUNCTION NEW(p_metric_name   IN VARCHAR2,
                      p_metric_column IN VARCHAR2 DEFAULT ' ')
  RETURN mgmt_metric_name_obj
)
/

CREATE OR REPLACE TYPE mgmt_metric_name_array AS TABLE of
mgmt_metric_name_obj
/

--
-- Callback objects for tzrgn update callback
--
CREATE OR REPLACE TYPE MGMT_TZRGN_UPDATE_CBK_OBJ AS OBJECT 
(
  target_guid   RAW(16),
  target_type   VARCHAR2(64),
  from_tzrgn    VARCHAR2(64),
  to_tzrgn      VARCHAR2(64),
  STATIC FUNCTION NEW(p_target_guid    RAW,
                      p_target_type    VARCHAR2,
                      p_from_tzrgn     VARCHAR2,
                      p_to_tzrgn       VARCHAR2
                     )
 RETURN MGMT_TZRGN_UPDATE_CBK_OBJ
);
/

