Rem
Rem $Header: emcore/source/oracle/sysman/emdrep/sql/core/latest/sdk/sdk_user_pkgdef.sql /st_emcore_10.2.0.4.2db11.2/1 2009/03/20 16:22:09 nmathuri Exp $
Rem
Rem sdk_user_pkgdef.sql
Rem
Rem Copyright (c) 2002, 2009, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      sdk_user_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      The package that implements the User Model for Project Mozart
Rem
Rem    NOTES
Rem     The list of available privileges are :
Rem
Rem      SYSTEM Privileges
Rem       CREATE_ANY_ROLE
Rem       CREATE_ANY_PRIVILEGE
Rem       CREATE_TARGET
Rem       DELETE_ANY_TARGET
Rem       VIEW_ANY_TARGET
Rem       VIEW_ANY_REPORT
Rem       USE_ANY_BEACON
Rem       EM_MONITOR
Rem       PUBLISH_REPORT
Rem       SUPER_USER
Rem
Rem      TARGET Privileges
Rem       VIEW_TARGET
Rem       OPERATOR_TARGET
Rem       MAINTAIN_TARGET (deprecated)
Rem       CLONE_FROM_TARGET (deprecated)
Rem       FULL_TARGET
Rem
Rem      TARGET_GROUP Privileges
Rem       CREATE_TARGET_IN_GROUP
Rem
Rem      JOB Privileges
Rem       VIEW_JOB
Rem       FULL_JOB
Rem
Rem      Template Privileges
Rem       VIEW_TEMPLATE
Rem       FULL_TEMPLATE
Rem
Rem      Report Privileges
Rem       VIEW_REPORT
Rem
Rem      Corrective Action Privileges
Rem       VIEW_CA
Rem       FULL_CA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rpatti      09/06/06 - XbranchMerge rpatti_bug-5503142 from main
Rem    nmathuri    08/07/06 - Backport nmathuri_bug-4725364 from main
Rem    dcawley     08/30/05 - Remove job grants 
Rem    dcawley     08/18/05 - Make procedure for building flat role table 
Rem                           public 
Rem    dcawley     04/14/05 - Change booleans to number 
Rem    bram        03/27/05 - Changed get_users,get_users_dbconsole
Rem    dcawley     03/03/05 - Add predicate function for stored reports 
Rem    dcawley     02/21/05 - Replace enter super user mode 
Rem    dcawley     02/17/05 - Add constant for public role 
Rem    ramalhot    02/02/05 - changed signature for handle_target_deleted 
Rem    nkhatri     02/04/05 - Changed approach of updating data for access page
Rem    nkhatri     02/01/05 - Made changes in access procs 
Rem    jaysmith    01/21/05 - change grant_ca_privs parameters 
Rem    dcawley     01/13/05 - Add priv granted callback 
Rem    dcawley     01/11/05 - Rename callback 
Rem    dcawley     01/06/05 - Add target deletion callback 
Rem    nkhatri     01/06/05 - Add procedures for access page. 
Rem    kmanicka    12/20/04 - bug 4065441 added USER_OBJECT_GROUP
Rem    dcawley     12/16/04 - Add opertions for invalidating contexts 
Rem    jabramso    12/06/04 - 2 args to revoke_view_report_all_except_owner 
Rem    jaysmith    11/24/04 - add ca update call 
Rem    dcawley     10/07/04 - Remove manage any user 
Rem    jabramso    10/07/04 - add VIEW_ANY_REPORT 
Rem    asawant     09/27/04 - Cutting over API to fetch user subtab prefs. 
Rem    jabramso    09/24/04 - Add report routines 
Rem    kmanicka    09/18/04 - reassign_user api and callbacks
Rem    dcawley     09/15/04 - target group modified is no longer used 
Rem    dcawley     09/14/04 - Remove beacon code 
Rem    dcawley     08/31/04 - Add callbacks for new objects 
Rem    dcawley     08/30/04 - Add association callback 
Rem    dcawley     08/13/04 - Remove version of has priv 
Rem    dcawley     07/29/04 - Add predicate functions 
Rem    dcawley     07/23/04 - 10gR2 changes 
Rem    aholser     06/10/04 - check user validity 
Rem    dcawley     04/15/04 - Make has_role public 
Rem    dcawley     03/24/04 - Add callback for nested jobs 
Rem    jsadras     03/18/04 - 
Rem    jsadras     03/17/04 - added get_read_lock 
Rem    jsadras     03/16/04 - 
Rem    dcawley     01/26/04 - Do not pass user when granting full job 
Rem    dcawley     01/16/04 - Make has_role public 
Rem    dcawley     11/17/03 - Rename predicate functions 
Rem    dcawley     11/12/03 - Fix deadlock 
Rem    dcawley     09/17/03 - Add procedure for granting full job to owner of 
Rem                           a job 
Rem    aholser     09/11/03 - add drop_user complete proc 
Rem    dcawley     09/01/03 - Add job vpd 
Rem    aholser     08/20/03 - add get_user_job_priv 
Rem    aholser     07/21/03 - more job changes
Rem    kdas        07/31/03 - support for DB Console mode
Rem    dcawley     07/24/03 - Add array version of HAS_PRIV
Rem    dcawley     07/21/03 - Remove OP_LOGON
Rem    aholser     07/07/03 - add job procs
Rem    yaofeng     03/24/03 - update user email with format
Rem    dcawley     03/06/03 - Remove references to dbms_rls
Rem    dcawley     03/05/03 - Change TARGET_GROUP_MODIFIED
Rem    dcawley     01/14/03 - Define user types
Rem    dcawley     11/12/02 - Add Job privileges
Rem    skini       01/03/03 - Add an additional OUT parameter to GET_MGMT_PRIVS
Rem    dcawley     10/31/02 - Fix role callbacks
Rem    jsoule      10/30/02 - add metric user prefs alias function
Rem    dcawley     10/23/02 - Add protected version of GET_MAX_PRIV
Rem    dcawley     10/17/02 - Add get_max_priv
Rem    dcawley     10/07/02 - Add constant for logging system
Rem    dcawley     09/27/02 - Remove AUTHID
Rem    tjaiswal    09/24/02 - Fix create user
Rem    rpinnama    09/18/02 - Remove authid current_user clause 
Rem    dcawley     09/11/02 - Add old APIs to create/modify users
Rem    dcawley     09/09/02 - Remove old version of CREATE_USER
Rem    dcawley     09/02/02 - Allow multiple emails be specified
Rem    rpatti      08/14/02 - add api to get target types based on privileges
Rem    aholser     08/15/02 - add get_mgmt_privs for em_monitor
Rem    dcawley     08/06/02 - Add EM_MONITOR
Rem    tjaiswal    08/05/02 - Add get targets api
Rem    dcawley     08/07/02 - Add GET_ALL_TARGET_PRIVS
Rem    tjaiswal    07/16/02 - Add get targets by priv for type api
Rem    dcawley     07/09/02 - Add callbacks
Rem    dcawley     06/13/02 - Update comments for USE_ANY_BEACON
Rem    dcawley     05/31/02 - API to get target list with a certain privilege.
Rem    aholser     05/20/02 - merge performance
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Restructured.
Rem    aholser     04/29/02 - Allow usernames with '.'.
Rem    rpinnama    04/19/02 - Drop from created users on error.
Rem    skini       04/18/02 - Fix bug 2330911
Rem    mbhoopat    04/18/02 - Fix bug 2330078..
Rem    dcawley     04/16/02 - Remove COMMITs from SETEMUSERCONTEXT.
Rem    rpinnama    04/16/02 - Add the user to MGMT_CREATED_USERS in CREATE_USER.
Rem    dcawley     04/12/02 - Make sure context is recreated after GRANT_PRIV.
Rem    aholser     04/12/02 - fix description edit.
Rem    skini       04/11/02 - Change documentation for node_list API
Rem    skini       04/10/02 - Change API to return only targets with permission
Rem    dcawley     04/08/02 - Make setemusercontext run in an autonomous transaction.
Rem    dcawley     04/05/02 - Remove check for DBMS JOB when logging off.
Rem    dcawley     04/04/02 - Fix recursive statements.
Rem    skini       04/01/02 - Continue implementation of API
Rem    jpyang      03/14/02 - Fix enter_super_user_mode
Rem    skini       03/28/02 - Add target list APIs
Rem    skini       03/08/02 - Fix merge problem
Rem    dcawley     03/05/02 - Do not clean up context for DBMS JOB.
Rem    dcawley     03/01/02 - Use dba_procedures.
Rem    dcawley     02/27/02 - Add operation to clean up all contexts.
Rem    rpatti      02/25/02 - call createfolders in mgmt_user
Rem    dcawley     02/22/02 - Add check for NULL.
Rem    dcawley     02/21/02 - Select predicate from global context.
Rem    dcawley     02/21/02 - Fix logoff trigger.
Rem    dcawley     02/20/02 - Store current user in private context.
Rem    dcawley     02/19/02 - Remove priv_name from setemusercontext.
Rem    skini       03/01/02 - Implement make_em_user
Rem    dcawley     02/11/02 - Add modify_role.
Rem    aholser     02/12/02 - fix get_role_users.
Rem    skini       02/07/02 - Include composite targets in group check
Rem    skini       02/07/02 - Implement add_member_target
Rem    skini       02/05/02 - Add methods to enter and leave super-user mode
Rem    ancheng     02/01/02 - check folders in modify_user
Rem    dcawley     02/01/02 - Standardize on NULL meaning no change in MODIFY_USER.
Rem    dcawley     02/01/02 - Add checks for 0 count.
Rem    dcawley     02/01/02 - Remove direct call to SET_TARGET_LIST.
Rem    dcawley     01/31/02 - Add callbacks to notify of privilege modification.
Rem    dcawley     01/29/02 - Change get_role_users to return available and selected.
Rem    dcawley     01/28/02 - Fix get_role_users.
Rem    dcawley     01/23/02 - Change VIEW_ALL_TARGETS_GROUP to VIEW_ANY_TARGET.
Rem    dcawley     01/21/02 - Only drop privs and roles if new ones have been passed into modify_user.
Rem    aholser     01/19/02 - don t return rep owner on get_role_users.
Rem    dcawley     01/18/02 - Remove typo.
Rem    dcawley     01/16/02 - Add new implementation of HAS_PRIV.
Rem    dcawley     01/16/02 - Remove MGMT_ROLE_PRIVS.
Rem    dcawley     01/16/02 - Remove debug statement.
Rem    dcawley     01/12/02 - Changes for making groups always propagating.
Rem    ancheng     01/22/02 - add/delete folders
Rem    skini       01/08/02 - Move setEMUserContext
Rem    dcawley     01/04/02 - Use cursors instead of arrays for return values
Rem    dcawley     01/03/02 - Fixes for the UI.
Rem    dcawley     12/19/01 - Add groups.
Rem    dcawley     01/03/02 - Fixes for the UI.
Rem    dcawley     12/19/01 - Add groups.
Rem    dcawley     12/17/01 - Allow use of target name and target type.
Rem    dcawley     12/12/01 - Add check for VIEW_ALL_TARGETS in set_target_list.
Rem    dcawley     12/07/01 - Allow the super user drop any privilege.
Rem    dcawley     12/04/01 - Add APIs for UI.
Rem    dcawley     11/28/01 - Do not allow SUPER_USER to be deleted.
Rem    dcawley     11/27/01 - Merged dcawley_add_user_model
Rem    dcawley     11/27/01 - Created
Rem

CREATE OR REPLACE PACKAGE MGMT_USER
IS

USERMODEL_MODULE_NAME constant varchar2(20) := 'MGMT_USER.User Model';

-- Value for NULL guid for use in System Privileges
NO_GUID constant raw(16) := '0000000000000000';

-- Value for user alias wildcard
WILDCARD_USER_NAME_ALIAS constant varchar2(1) := '*';

-- Operator definitions for SETCONTEXT
OP_SET_IDENTIFIER constant integer := 1;
OP_CLEAR_IDENTIFIER constant integer := 2;
OP_CLEAR_CONTEXT constant integer := 4;
OP_CLEAR_CONTEXTS constant integer := 5;
OP_CREATE_TARGET_CONTEXT constant integer := 3;
OP_CREATE_JOB_CONTEXT constant integer := 6;
OP_CREATE_TEMPLATE_CONTEXT constant integer := 7;
OP_CREATE_REPORT_DEF_CONTEXT constant integer := 8;
OP_CREATE_CA_CONTEXT constant integer := 10;
OP_INVALIDATE_TARGET_CONTEXT constant integer := 11;
OP_INVALIDATE_JOB_CONTEXT constant integer := 12;
OP_INVALIDATE_TEMPLATE_CONTEXT constant integer := 13;
OP_INVALIDATE_REPORT_CONTEXT constant integer := 14;
OP_INVALIDATE_CA_CONTEXT constant integer := 15;

-- Return codes for HAS_ROLE
NO_SUCH_ROLE constant integer := 0;
USER_DOES_NOT_HAVE_ROLE constant integer := 1;
USER_HAS_ROLE constant integer := 2;

-- Return codes for HAS_ROLE
USER_DOES_NOT_HAVE_PRIV constant number := 0;
USER_HAS_PRIV constant number := 1;

-- Return codes for VALID_PRIVILEGE
VALID_PRIV constant number := 0;
VALID_TARGET_PRIV constant number := 1;
VALID_GROUP_PRIV constant number := 2;
INVALID_PRIV constant number := 3;
INVALID_TARGET constant number := 4;

-- Names of the VPD policies
EM_TARGET_POLICY_NAME constant varchar2(16) := 'EM_TARGET_POLICY';
EM_JOB_POLICY_NAME constant varchar2(13) := 'EM_JOB_POLICY';
EM_TEMPLATE_POLICY_NAME constant varchar2(18) := 'EM_TEMPLATE_POLICY';
EM_REPORT_DEF_POLICY_NAME constant varchar2(20) := 'EM_REPORT_DEF_POLICY';
EM_REPORT_POLICY_NAME constant varchar2(20) := 'EM_REPORT_POLICY';
EM_CA_POLICY_NAME constant varchar2(12) := 'EM_CA_POLICY';

-- Variable names used in context
EM_TARGET_PREDICATE constant number := 1;
EM_JOB_PREDICATE constant number := 2;
EM_TEMPLATE_PREDICATE constant number := 3;
EM_REPORT_DEF_PREDICATE constant number := 4;
EM_CA_PREDICATE constant number := 5;

-- Values of predicates 
CREATE_PREDICATE constant number := -1;
ANY_PREDICATE constant number := 0;
PRIV_PREDICATE constant number := 1;

-- Predicate value specially for targets
EM_MONITOR_PREDICATE constant number := 2;

-- Privilege types
SYSTEM_PRIVILEGE constant number := 0;
TARGET_PRIVILEGE constant number := 1;
TARGET_GROUP_PRIVILEGE constant number := 2;
JOB_PRIVILEGE constant number := 3;
TEMPLATE_PRIVILEGE constant number := 4;
REPORT_PRIVILEGE constant number := 5;
CA_PRIVILEGE constant number := 6;

-- System privileges
CREATE_ANY_ROLE constant varchar2(15) := 'CREATE_ANY_ROLE';
CREATE_ANY_PRIVILEGE constant varchar2(20) := 'CREATE_ANY_PRIVILEGE';
CREATE_TARGET constant varchar2(13) := 'CREATE_TARGET';
DELETE_ANY_TARGET constant varchar2(17) := 'DELETE_ANY_TARGET';
VIEW_ANY_TARGET constant varchar2(15) := 'VIEW_ANY_TARGET';
VIEW_ANY_REPORT constant varchar2(15) := 'VIEW_ANY_REPORT';
USE_ANY_BEACON constant varchar2(14) := 'USE_ANY_BEACON';
EM_MONITOR constant varchar2(10) := 'EM_MONITOR';
PUBLISH_REPORT constant varchar2(14) := 'PUBLISH_REPORT';
SUPER_USER constant varchar2(10) := 'SUPER_USER';
FULL_ANY_TARGET constant varchar2(17) := 'FULL_ANY_TARGET';

-- Target privileges
VIEW_TARGET constant varchar2(11) := 'VIEW_TARGET';
OPERATOR_TARGET constant varchar2(15) := 'OPERATOR_TARGET';
MAINTAIN_TARGET constant varchar2(15) := 'MAINTAIN_TARGET';
CLONE_FROM_TARGET constant varchar2(17) := 'CLONE_FROM_TARGET';
FULL_TARGET constant varchar2(11) := 'FULL_TARGET';

-- Target group privileges
CREATE_TARGET_IN_GROUP constant varchar2(22) := 'CREATE_TARGET_IN_GROUP';

-- Job privileges
VIEW_JOB constant varchar2(8) := 'VIEW_JOB';
FULL_JOB constant varchar2(8) := 'FULL_JOB';

-- Template privileges
VIEW_TEMPLATE constant varchar2(13) := 'VIEW_TEMPLATE';
FULL_TEMPLATE constant varchar2(13) := 'FULL_TEMPLATE';

-- Report privileges
VIEW_REPORT constant varchar2(11) := 'VIEW_REPORT';

-- Corrective Action privileges
VIEW_CA constant varchar2(7) := 'VIEW_CA';
FULL_CA constant varchar2(7) := 'FULL_CA';

-- The PUBLIC role
PUBLIC_ROLE constant varchar2(6) := 'PUBLIC';

-- USER OBJECTS TYPE
USER_OBJECT_JOB        constant varchar2(20)  := 'Job';
USER_OBJECT_CA         constant varchar2(20)  := 'Corrective Action';
USER_OBJECT_BLACKOUT   constant varchar2(20)  := 'Blackout';
USER_OBJECT_TARGET     constant varchar2(20)  := 'Target';
USER_OBJECT_GROUP      constant varchar2(20)  := 'Group';
USER_OBJECT_TEMPLATE   constant varchar2(20)  := 'Template';
USER_OBJECT_REPORT_DEF constant varchar2(20)  := 'Report Definition';

-- Type of callback
USER_CREATED_CALLBACK        constant number := 0;
USER_DROPPED_CALLBACK        constant number := 1;
USER_REASSIGN_CALLBACK       constant number := 2;
-- Note that only target privileges are handled. There is no callback for
-- role grants/revokes since they are actually handled as privilege callbacks
PRIV_GRANTED_CALLBACK        constant number := 7;
PRIV_REVOKED_CALLBACK        constant number := 3;
CHECK_USER_DROPPED_CALLBACK  constant number := 4;
CHECK_USER_REASSIGN_CALLBACK constant number := 5;
GET_USER_OBJECTS_CALLBACK    constant number := 6;

-- Type of privilege grant callbacks. These values are passed to the privilege
-- granted callback and are not for use when registering a callback

-- A user has been granted a single privilege
USER_GRANTED_PRIV_CALLBACK    constant number := 8;
-- A role has been granted a single privilege
ROLE_GRANTED_PRIV_CALLBACK    constant number := 9;
-- A role has been granted another role which means the role can have been
-- granted multiple privileges
ROLE_GRANTED_ROLE_CALLBACK    constant number := 10;
-- A user has been granted a role which means the user can have been
-- granted multiple privileges
USER_GRANTED_ROLE_CALLBACK    constant number := 11;

-- Type of privilege revoke callbacks. These values are passed to the privilege
-- revoked callback and are not for use when registering a callback

-- A privilege has been revoked from a user
USER_REVOKED_PRIV_CALLBACK    constant number := 12;
-- A privilege has been revoked from a role
ROLE_REVOKED_PRIV_CALLBACK    constant number := 13;
-- A role has been revoked from another role which means multiple privileges
-- can have been revoked
ROLE_REVOKED_ROLE_CALLBACK    constant number := 14;
-- A role has been revoked from a user which means multiple privileges
-- can have been revoked
USER_REVOKED_ROLE_CALLBACK    constant number := 15;

-- 
SYNC_DROP_OBJECT             constant number := 0;
ASYNC_DROP_OBJECT            constant number := 1;

-- User types
EM_USER constant NUMBER := 0;
SYSTEM_USER constant NUMBER := 1;
SSO_USER constant NUMBER := 2;
ENTERPRISE_USER constant NUMBER := 3;

TYPE STRING_CURSOR IS REF CURSOR;
TYPE GUID_CURSOR IS REF CURSOR;
TYPE TARGET_PRIVS_CURSOR IS REF CURSOR;
TYPE TARGETS_CURSOR IS REF CURSOR;
TYPE PRIVS_CURSOR IS REF CURSOR;
TYPE NODELIST_CURSOR IS REF CURSOR;
TYPE ROLEDESC_CURSOR IS REF CURSOR;
TYPE CURSOR_TYPE IS REF CURSOR;
TYPE GRANT_CURSOR IS REF CURSOR;

-- Configuration parameters
TARGET_POLICY_ENABLED constant VARCHAR2(32) := 'TARGET_POLICY_ENABLED';
PROPAGATE_GROUP_PRIVILEGES constant VARCHAR2(30) := 'PROPAGATE_GROUP_PRIVILEGES';

--
-- PURPOSE
--
--  To create a user
--
-- PARAMETERS
--
--  USER_NAME_IN - the name of the user
--  PASSWORD_IN - the password of the user
--  EMAIL_ADDRESSES_IN - the email addresses of the user
--  ROLES_IN - the roles to grant to the user
--  PRIVILEGES_IN - the privileges to grant to the user
--  USER_TYPE_IN - type of user
--                 0 - EM_USER
--                 1 - SYSTEM_USER
--                 2 - SSO_USER
--                 3 - ENTERPRISE_USER
--
-- NOTES
--
--   When a user is created, it is granted the MGMT_USER role. This role is 
--   used to give the CONNECT privilege to the user and any other privileges 
--   that are necessary. The caller cannot grant any privileges that are more
--   powerful that those he/she has
--
PROCEDURE CREATE_USER(user_name_in       IN VARCHAR2,
                      password_in        IN VARCHAR2,
                      email_addresses_in IN SMP_EMD_STRING_ARRAY,
                      roles_in           IN SMP_EMD_STRING_ARRAY,
                      privileges_in      IN MGMT_USER_PRIVILEGES,
                      user_type_in       IN NUMBER DEFAULT EM_USER);

--
-- PURPOSE
--
--  To create a user
--
-- PARAMETERS
--
--  USER_NAME_IN - the name of the user
--  PASSWORD_IN - the password of the user
--  EMAIL_ADDRESS_IN - the email address of the user
--  ROLES_IN - the roles to grant to the user
--  PRIVILEGES_IN - the privileges to grant to the user
--  USER_TYPE_IN - type of user
--                 0 - EM_USER
--                 1 - SYSTEM_USER
--                 2 - SSO_USER
--                 3 - ENTERPRISE_USER
--
-- NOTES
--
--   When a user is created, it is granted the MGMT_USER role. This role is 
--   used to give the CONNECT privilege to the user and any other privileges 
--   that are necessary. The caller cannot grant any privileges that are more
--   powerful that those he/she has
--
PROCEDURE CREATE_USER(user_name_in       IN VARCHAR2,
                      password_in        IN VARCHAR2,
                      email_address_in   IN VARCHAR2 DEFAULT '',
                      roles_in           IN SMP_EMD_STRING_ARRAY DEFAULT NULL,
                      privileges_in      IN MGMT_USER_PRIVILEGES DEFAULT NULL,
                      user_type_in       IN NUMBER DEFAULT EM_USER);

--
-- PURPOSE
--
--  "Convert" an existing database user into an EM user, granting
--  the user the specified privileges and roles
--
-- PARAMETERS
--
--  USER_NAME_IN - the name of the user
--  EMAIL_ADDRESSES_IN - the email addresses of the user
--  ROLES_IN - the roles to grant to the user
--  PRIVILEGES_IN - the privileges to grant to the user
--
-- NOTES
--
--   The caller must have the SUPER_USER privilege.
--
PROCEDURE MAKE_EM_USER(user_name_in       IN VARCHAR2,
                       email_addresses_in IN SMP_EMD_STRING_ARRAY,
                       roles_in           IN SMP_EMD_STRING_ARRAY,
                       privileges_in      IN MGMT_USER_PRIVILEGES);

--
-- PURPOSE
--
--  "Convert" an existing database user into an EM user, granting
--  the user the specified privileges and roles
--
-- PARAMETERS
--
--  USER_NAME_IN - the name of the user
--  EMAIL_ADDRESSES_IN - the email address of the user
--  ROLES_IN - the roles to grant to the user
--  PRIVILEGES_IN - the privileges to grant to the user
--
-- NOTES
--
--   The caller must have the SUPER_USER privilege.
--
PROCEDURE MAKE_EM_USER(user_name_in       IN VARCHAR2,
                       email_address_in   IN VARCHAR2 DEFAULT '',
                       roles_in           IN SMP_EMD_STRING_ARRAY DEFAULT NULL,
                       privileges_in      IN MGMT_USER_PRIVILEGES DEFAULT NULL);
--
-- PURPOSE
--
--  To modify a user
--
-- PARAMETERS
--
--  USER_NAME_IN - the name of the user
--  PASSWORD_IN - the new password of the user
--  EMAIL_ADDRESSES_IN - the new email addresses of the user
--                       NULL - no change
--                       SMP_EMD_STRING_ARRAY() - to remove existing addresses
--                       SMP_EMD_STRING_ARRAY('a','b') - to set the addresses
--                                                       to a and b
--  ROLES_IN - the new roles to grant to the user
--  PRIVILEGES_IN - the new privileges to grant to the user
--
-- NOTES
--
--   The caller cannot grant any privileges that are more powerful that those 
--   he/she has.  All existing role and privileges are dropped before the new 
--   ones are granted provided all the new ones are valid
--
PROCEDURE MODIFY_USER(user_name_in       IN VARCHAR2,
                      password_in        IN VARCHAR2,
                      email_addresses_in IN SMP_EMD_STRING_ARRAY,
                      roles_in           IN SMP_EMD_STRING_ARRAY,
                      privileges_in      IN MGMT_USER_PRIVILEGES);


PROCEDURE MODIFY_DBCONSOLE_USER ( user_name_in       IN VARCHAR2,
                                  password_in        IN VARCHAR2,
                                  email_addresses_in IN SMP_EMD_STRING_ARRAY,
                                  roles_in           IN SMP_EMD_STRING_ARRAY,
                                  privileges_in      IN MGMT_USER_PRIVILEGES,
                                  to_grant_db_role_in IN NUMBER);
--
-- PURPOSE
--
--  To modify a user
--
-- PARAMETERS
--
--  USER_NAME_IN - the name of the user
--  PASSWORD_IN - the new password of the user
--  EMAIL_ADDRESS_IN - the new email address of the user
--                     NULL - no change
--                     'a@b.com' - set to a@b.com 
--                     ' ' - clear email address
--  ROLES_IN - the new roles to grant to the user
--  PRIVILEGES_IN - the new privileges to grant to the user
--
-- NOTES
--
--   The caller cannot grant any privileges that are more powerful that those 
--   he/she has.  All existing role and privileges are dropped before the new 
--   ones are granted provided all the new ones are valid
--
PROCEDURE MODIFY_USER(user_name_in       IN VARCHAR2,
                      password_in        IN VARCHAR2,
                      email_address_in   IN VARCHAR2 DEFAULT '',
                      roles_in           IN SMP_EMD_STRING_ARRAY DEFAULT NULL,
                      privileges_in      IN MGMT_USER_PRIVILEGES DEFAULT NULL);

--
-- PURPOSE
--
--  To drop a user
--
-- PARAMETERS
--
--  USER_NAME_IN - the name of the user
--  NEW_USER_NAME_IN - the name of the new user
--
-- NOTES
--
PROCEDURE DROP_USER(user_name_in IN VARCHAR2, 
                    new_user_name_in IN VARCHAR2 DEFAULT NULL);

--
-- PURPOSE
--
--  To complete dropping a user, called from the DelUser JOB
--
-- PARAMETERS
--
--  USER_NAME_IN - the name of the user
--  NEW_USER_NAME_IN - the name of the new user
--
-- NOTES
--
PROCEDURE DROP_USER_COMPLETE(user_name_in IN VARCHAR2, 
                             new_user_name_in IN VARCHAR2 DEFAULT NULL);

--
-- PURPOSE
--
--  To get a list of users
--
-- PARAMETERS
--
--  USER_NAMES_OUT - the names of the user
--
-- NOTES
--
--  This routines searches for all users that have the MGMT_USER role. It
--  will not return the repository owner, and will not return any 
--  users with the SUPER_USER privilege, if the caller is not a SUPER_USER.
--  Additional IN parameter (p_user) added to pass the SEACRH string
--  ,to restrict rows based on search condition and to support WIRLDCARD
--  SEARCH
PROCEDURE GET_USERS(user_names_out OUT STRING_CURSOR,
                    user_type_in IN NUMBER DEFAULT EM_USER,
                    p_user_srch  IN VARCHAR2 DEFAULT NULL);



--
-- PURPOSE
--
--  To create a privilege
--
-- PARAMETERS
--
--  PRIV_NAME_IN - name of the privilege  
--  PRIV_TYPE_IN - the type of the privilege
--                 1 - TARGET
--                 2 - TARGET GROUP
--  DESCRIPTION_IN - a description (max of 256 characters) of the privilege
--
-- NOTES
--
--  This should only be used to add user defined privileges. The caller
--  must have the CREATE_ANY_PRIVILEGE system privilege and the type of 
--  privilege must be either 1 or 2 depending on whether this privilege
--  applies to a target or a target group. An exception will be thrown if
--  the type is any other value
--
PROCEDURE CREATE_PRIV(priv_name_in   IN VARCHAR2, 
                      priv_type_in   IN NUMBER,
                      description_in IN VARCHAR2 DEFAULT '');

--
-- PURPOSE
--
--  To drop a privilege
--
-- PARAMETERS
--
--  PRIV_NAME_IN - name of the privilege  
--
-- NOTES
--
--  The caller must have created the privilege
--    
PROCEDURE DROP_PRIV(priv_name_in IN VARCHAR2);

--
-- PURPOSE
--
--  To create a role
--
-- PARAMETERS
--
--  ROLE_NAME_IN - name of the role
--  DESCRIPTION_IN - a description (max of 256 characters) of the role
--
-- NOTES
--
--  The caller must have the CREATE_ANY_ROLE privilege
--
PROCEDURE CREATE_ROLE(role_name_in   IN VARCHAR2, 
                      description_in IN VARCHAR2 DEFAULT '');

--
-- PURPOSE
--
--  To create a role, grant other roles to it, grant privileges to it and then
--  grant the created role to a list of users
--
-- PARAMETERS
--
--  ROLE_NAME_IN - name of the role
--  DESCRIPTION_IN - a description (max of 256 characters) of the role
--  ROLES_IN - the names of the roles to grant to the created role
--  PRIVILEGES_IN - the privileges to grant to the created role
--  USERS_IN - the names of the user to grant the created role to
--
-- NOTES
--
--  The caller must have the CREATE_ANY_ROLE system privilege and have already
--  been granted all the roles and privileges which are being assigned to the
--  role being created. 
--
PROCEDURE CREATE_ROLE(role_name_in IN VARCHAR2, 
                      description_in  IN VARCHAR2, 
                      roles_in IN SMP_EMD_STRING_ARRAY, 
                      privileges_in IN MGMT_USER_PRIVILEGES,
                      users_in IN SMP_EMD_STRING_ARRAY); 

--
-- PURPOSE
--
--  To modify a role. grant other roles to it, grant privileges to it and then
--  grant the created role to a list of users
--
-- PARAMETERS
--
--  ROLE_NAME_IN - name of the role
--
--  Note that if any of the parameters are NULL, they are ignored.
--
--  DESCRIPTION_IN - the new description (max of 256 characters) of the role.
--  ROLES_IN - the names of the roles to grant to the role, all existing roles
--             are revoked
--  PRIVILEGES_IN - the privileges to grant to the role, all existing 
--                  privileges are revoked
--  USERS_IN - the names of the user to grant the role to, the role is
--             revoked from all users that currently have the role
--
-- NOTES
--
-- 
--  The caller must have been granted the role with the with admin option and 
--  have already been granted all the roles and privileges which are being 
--  assigned to the role being modified. 
--
PROCEDURE MODIFY_ROLE(role_name_in IN VARCHAR2, 
                      description_in  IN VARCHAR2, 
                      roles_in IN SMP_EMD_STRING_ARRAY, 
                      privileges_in IN MGMT_USER_PRIVILEGES,
                      users_in IN SMP_EMD_STRING_ARRAY); 

--
-- PURPOSE
--
--  To drop a privilege
--
-- PARAMETERS
--
--  ROLE_NAME_IN - name of the role 
--
-- NOTES
--
--  The caller must have been granted the role with the WITH_ADMIN flag
--  set
--    
PROCEDURE DROP_ROLE(role_name_in IN VARCHAR2);

--
-- PURPOSE
--
--  To grant a privilege to a user or role
--
-- PARAMETERS
--
--  GRANTEE_IN - the name of the user or role
--  PRIV_NAME_IN - the name of the privilege which must be one of the supplied
--                 privileges (see list at top) or else the name of an 
--                 Integrator defined privilege that was added using CREATE_PRIV
--  GUID_IN - target guid in the case of a target privilege 
--            target group guid in the case of target group privilege 
--            job guid in the case of job privilege 
--            NULL in the case of system privilege 
--  INVALIDATE_IN - whether or not to invalidate users of the role.  Defaults to
--                 1 (invalidate)
--
-- NOTES
--
--   When granting to a role the user must have been granted the role with the 
--   WITH ADMIN option. The caller can not grant a privilege 
--   unless he/she has already been granted that privilege. This means that 
--   first time grants will have to be done by a SUPER_USER who has permission
--   to do anything
--
PROCEDURE GRANT_PRIV(grantee_in     IN VARCHAR2,
                     priv_name_in   IN VARCHAR2,
                     guid_in        IN RAW DEFAULT NO_GUID,
                     invalidate_in  IN NUMBER DEFAULT 1);
PROCEDURE GRANT_PRIV(grantee_in     IN VARCHAR2,
                     priv_name_in   IN VARCHAR2,
                     target_name_in IN VARCHAR2,
                     target_type_in IN VARCHAR2,
                     invalidate_in  IN NUMBER DEFAULT 1);

PROCEDURE GRANT_PRIVS(grantee_in     IN VARCHAR2,
                      privileges_in   IN MGMT_USER_PRIVILEGES);

--
--  To grant FULL_JOB to the owner of a job
--
-- PARAMETERS
--
--  GUID_IN - job guid 
--
-- NOTES 
--   The caller must be the job owner
PROCEDURE GRANT_FULL_JOB_TO_OWNER( guid_in IN RAW);


--
--  To grant view priveleges on a CA to the appropriate group of admins
--
-- PARAMETERS
--
--  P_GUID_IN - job id for the CA 
--  P_SCOPE_IN -- scope of the CA: one of CA_SCOPE_TARGET, CA_SCOPE_TEMPLATE,
--                CA_SCOPE_TARGET_TYPE, or CA_SCOPE_USER
--  P_TARGET_GUID_IN -- if a target-scoped CA, the guid of the target
--  P_TEMPLATE_GUID_IN -- if a template-scoped CA, the guid of the template
--  P_OWNER_IN -- the owner of the CA
PROCEDURE GRANT_CA_PRIVS(p_guid_in IN RAW,
                         p_scope_in IN NUMBER,
                         p_target_guid_in IN RAW,
                         p_template_guid_in IN RAW,
                         p_owner_in IN VARCHAR2);


--
-- PURPOSE
--
--  To revoke a privilege from a user or role
--
-- PARAMETERS
--
--  GRANTEE_IN - the name of the user or role 
--  PRIV_NAME_IN - the name of the privilege which must be one of the supplied
--                 privileges (see list at top) or else the name of an 
--                 Integrator defined privilege that was added using CREATE_PRIV
--  GUID_IN - target guid in the case of a target privilege 
--            target group guid in the case of target group privilege 
--            job guid in the case of job privilege 
--            NULL in the case of system privilege 
--  INVALIDATE_IN - whether or not to invalidate users of the role.  Defaults to
--                 1 (invalidate)
--
-- NOTES
--
--   The caller must have been granted a role with the WITH_ADMIN option to be 
--   able to revoke a privilege from the role.
--
PROCEDURE REVOKE_PRIV(grantee_in     IN VARCHAR2,
                      priv_name_in   IN VARCHAR2,
                      guid_in        IN RAW DEFAULT NO_GUID,
                      invalidate_in  IN NUMBER DEFAULT 1);
PROCEDURE REVOKE_PRIV(grantee_in     IN VARCHAR2,
                      priv_name_in   IN VARCHAR2,
                      target_name_in IN VARCHAR2,
                      target_type_in IN VARCHAR2,
                      invalidate_in  IN NUMBER DEFAULT 1);

PROCEDURE REVOKE_PRIVS(grantee_in      IN VARCHAR2,
                      privileges_in   IN MGMT_USER_PRIVILEGES);

--
-- PURPOSE
--
--  To grant a role to a user or another role
--
-- PARAMETERS
--
--  GRANTEE_IN - the name of the user or role
--  ROLE_NAME_IN - the name of the role to grant
--  WITH_ADMIN_IN - flag to indicate whether the role is to be granted
--                  allowing the grantee  the ability to modify it and grant it 
--                  to other users
--  INVALIDATE_IN - whether or not to invalidate users of the role.  Defaults to
--                 1 (invalidate)
--
-- NOTES
--
--   The caller must have already been granted the role with the WITH ADMIN 
--   flag set
--
PROCEDURE GRANT_ROLE(grantee_in  IN VARCHAR2,
                     role_name_in  IN VARCHAR2,
                     with_admin_in IN NUMBER DEFAULT 0,
                     invalidate_in  IN NUMBER DEFAULT 1);

--
-- PURPOSE
--
--  To grant bulk roles to a user or another role
--
-- PARAMETERS
--
--  p_grantee    - the name of the user or role
--  p_roles      - list of roles to be assigned
-- 
-- NOTES
--
--   The caller must have already been granted the role with the WITH ADMIN 
--   flag set
--
PROCEDURE GRANT_ROLES ( p_grantee  IN  VARCHAR2,
                        p_roles    IN  MGMT_SHORT_STRING_ARRAY);


--
-- PURPOSE
--
--  To revoke a role from a user or another role
--
-- PARAMETERS
--
--  GRANTEE_IN - the name of the user or role
--  ROLE_NAME_IN - the name of the role which can be one of the 
--                 pre-defined roles, SECURITY_ADMIN or TARGET_GROUP_ADMIN
--  INVALIDATE_IN - whether or not to invalidate users of the role.  Defaults to
--                 1 (invalidate)
-- NOTES
--
--   The caller must have been granted the role with the WITH ADMIN option 
--   if revoking the role from another role
--
--
PROCEDURE REVOKE_ROLE(grantee_in IN VARCHAR2,
                      role_name_in IN VARCHAR2,
                      invalidate_in  IN NUMBER DEFAULT 1);

--
-- PURPOSE
--
--  To revoke bulk roles from a user or another role
--
-- PARAMETERS
-- p_grantee - Name of user or role from which roles will be revoked
-- p_roles   - List of roles revokes from user or role 
-- 
-- NOTES
--
--   The caller must have been granted the role with the WITH ADMIN option 
--   if revoking the role from another role
--
--
PROCEDURE REVOKE_ROLES ( p_grantee  IN VARCHAR2,
			 p_roles    IN  MGMT_SHORT_STRING_ARRAY);


--
-- PURPOSE
--
--  To check if a user has a particular role
--
-- PARAMETERS
--
--  USER_NAME_IN - the name of the user
--  ROLE_NAME_IN - the name of the role
--  WITH_ADMIN_IN - the with_admin flag
--
-- NOTES
--
-- Return codes for HAS_ROLE
--
--   RETURNS : NO_SUCH_ROLE - if the role does not exist
--             USER_DOES_NOT_HAVE_ROLE - if the user does not have the role
--             USER_HAS_ROLE - if the user has the role
--
--
FUNCTION HAS_ROLE(user_name_in  IN VARCHAR2,
                  role_name_in  IN VARCHAR2,
                  with_admin_in IN NUMBER DEFAULT 0)
RETURN NUMBER;

--
-- PURPOSE
--
--  To rebuild the flattended list of role grants for a role
--
-- PARAMETERS
--
--  ROLE_NAME_IN - the name of the role
--
PROCEDURE UPDATE_FLAT_ROLE_GRANTS(role_name_in IN VARCHAR2);

--
-- PURPOSE
--
--  To check if a user has a privilege
--
-- PARAMETERS
--
--  USER_NAME_IN - the name of the user
--  PRIV_NAME_IN - the name of the privilege
--  GUID_IN - target guid in the case of a target privilege 
--            target group guid in the case of target group privilege 
--            job guid in the case of job privilege 
--            NO_GUID in the case of a system privilege 
--
-- NOTES
--
--   RETURNS 1 if the user has the privilege otherwise 0
--
FUNCTION HAS_PRIV(user_name_in   IN VARCHAR2,
                  priv_name_in   IN VARCHAR2,
                  guid_in        IN RAW DEFAULT NO_GUID)
RETURN NUMBER;
FUNCTION HAS_PRIV(user_name_in   IN VARCHAR2,
                  priv_name_in   IN VARCHAR2,
                  target_name_in IN VARCHAR2,
                  target_type_in IN VARCHAR2)
RETURN NUMBER;

--
-- PURPOSE
--
--  To check if the user exists
--
-- PARAMETERS
--
--  USER_NAMES - the names of the user
--
-- NOTES
--
--  This routines checks if the user exests in the mgmt_created_users table
--  raises an application error MGMT_GLOBAL.USER_DOES_NOT_EXIST if not
--

PROCEDURE CHECK_USER_EXISTS(user_name_in IN VARCHAR2);

--
-- PURPOSE
--
--   Takes an array of target guids and returns an array of the guids
--   that the user has the privilege on.
--
-- PARAMETERS
--
--  USER_NAME_IN - the name of the user
--  PRIV_NAME_IN - the name of the privilege
--  TARGET_GUIDS_IN - target guids to check
--
-- NOTES
--
--   RETURNS an array of the guids for which the user has the privilege. Note 
--   that the privilege must be something other than VIEW_TARGET
--
FUNCTION HAS_PRIV(user_name_in    IN VARCHAR2,
                  priv_name_in    IN VARCHAR2,
                  target_guids_in IN MGMT_USER_GUID_ARRAY)
RETURN GUID_CURSOR;

--
-- PURPOSE
--
--   Takes an array of guids and returns true if the user has the privilege
--   all the targets.
--
-- NOTES
--
--   RETURNS an array of the guids for which the user has the privilege. Note
--   that the privilege must be something other than VIEW_TARGET
--
FUNCTION HAS_PRIV_ON_ALL(user_name_in    IN VARCHAR2,
                         priv_name_in    IN VARCHAR2,
                         target_guids_in IN MGMT_USER_GUID_ARRAY)
RETURN NUMBER;

--
-- PURPOSE:
--
--  To get the list of targets on which a user has a certain privilege
--
--  If the user_name_in is empty and the current user is a super user,
--  the list of targets on which the current user(i.e the super user) has the 
--  privilege - priv_name_in will be returned
--  If the user_name_in is not empty and valid and the current user is a super 
--  user, the list of targets on which the user - user_name_in
--  has the privilege - priv_name_in will be returned
--  If target_type_in is empty, then the list of targets of all types
--  for the user - user_name_in having privilege - priv_name_in will be
--  returned
--  If target_type_in is not empty, then the list of targets of type - 
--  target_type_in for the user - user_name_in having privilege - priv_name_in 
--  will be returned
--  If the current user is not a super user, then insufficient privileges 
--  exception will be thrown
--
-- NOTE: 
--  This api should only be called by a privileged user(super user)
--
-- IN PARAMETERS:
--
--  USER_NAME_IN - the name of the user
--  TARGET_TYPE_IN - the type of the target
--  PRIV_NAME_IN - the name of the privilege
--
-- RETURNS:
--  TARGETS_CURSOR: CURSOR_TYPE
--    A cursor which returns rows containing the target related information
--    like target_guid, target_name, target_type etc
--
-- ERROR codes:
--  USER_DOES_NOT_EXIST_ERR: user does not exist error
--  INSUFFICIENT_PRIVILEGES_ERR: insufficient privileges error
--
FUNCTION GET_TARGETS(user_name_in IN VARCHAR2,
                     target_type_in IN VARCHAR2,
                     priv_name_in IN VARCHAR2)
RETURN TARGETS_CURSOR;

--
-- PURPOSE:
--
--  To get the list of targets on which the current user has a certain privilege
--
--  If target_type_in is empty, then the list of targets of all types
--  for the current user having privilege - priv_name_in will be
--  returned
--  If target_type_in is not empty, then the list of targets of type - 
--  target_type_in for the current user having privilege - priv_name_in 
--  will be returned
--
-- NOTE: 
--  This api can be called by any user
--
-- IN PARAMETERS:
--
--  TARGET_TYPE_IN - the type of the target
--  PRIV_NAME_IN - the name of the privilege
--
-- RETURNS:
--  TARGETS_CURSOR: CURSOR_TYPE
--    A cursor which returns rows containing the target related information
--    like target_guid, target_name, target_type etc
--
-- ERROR codes:
--  None.
--
FUNCTION GET_TARGETS(target_type_in IN VARCHAR2,
                     priv_name_in IN VARCHAR2)
RETURN TARGETS_CURSOR;

--
-- PURPOSE:
--
--  To get the list of target types on which the current
--    user has a certain privilege
--
-- NOTE: 
--  This api can be called by any user
--
-- IN PARAMETERS:
--
--  PRIV_NAME_IN - the name of the privilege
--
-- RETURNS:
--  CURSOR_TYPE
--    A cursor which returns rows containing the target type
--    related information: target_type, type_display_name
--
-- ERROR codes:
--  None.
--
FUNCTION GET_TARGET_TYPES(priv_name_in IN VARCHAR2)
RETURN CURSOR_TYPE;

--
-- PURPOSE
--
--   To check whether a target can be added to a group. The target can be
--   added only if the user has the same privileges on the target as the user
--   has on the group. For example if the user has MAINTAIN_TARGET on a group
--   then a target can only be added to the group if the user also has
--   MAINTAIN_TARGET on the group.
--
-- PARAMETERS
--
--  GROUP_GUID_IN - the target GUID of the group
--  MEMBER_GUID_IN - the target GUID of the member to be added
--
-- NOTES
--
--  Returns 1 if member can be added to a group
-- 
FUNCTION VALID_GROUP_MEMBER(group_guid_in  IN RAW,
                            member_guid_in IN RAW)
RETURN NUMBER;

--
-- PURPOSE
--
--  To notify the user model that a target has been deleted. This allows
--  the user model to recompute the targets visible to users whose visible
--  target list have been cached and to remove any grants for that target
--
--  PARAMETERS
--
--   TARGET_NAME_IN - the target name of the deleted target
--   TARGET_TYPE_IN - the type of the deleted target
--
PROCEDURE HANDLE_TARGET_DELETED(target_name_in IN VARCHAR2, 
                                target_type_in IN VARCHAR2,
                                target_guid_in IN RAW);

--
-- PURPOSE
--
--  To notify the user model that a target association has changed. This allows
--  the user model to recompute the targets visible to users whose visible
--  target list have been cached
--
-- PURPOSE
--   SOURCE_TARGET_GUID_IN - the target GUID of the modified target
--   ASSOC_TARGET_GUIDS_IN - the target GUIDs of the associated targets
--   CHANGE_IN - what has changed
--               0 = removed 1 = added
--
PROCEDURE TARGET_ASSOC_CHANGED(source_target_guid_in IN RAW,
                               assoc_target_guids_in IN MGMT_USER_GUID_ARRAY,
                               change_in IN NUMBER);

--
-- PURPOSE
--
--  To notify the user model that a job has been deleted. This allows
--  the User Model to remove any grants for that job
--
--  PARAMETERS
--
--   JOB_GUID_IN - the GUID of the deleted job
--
PROCEDURE JOB_DELETED(job_guid_in IN RAW);

--
-- PURPOSE
--
--  To notify the user model that a nested job has been added. This allows
--  the User Model to allow it be visible to all users having access to the
--  parent job by adding rows to the job cache
--
--  PARAMETERS
--
--   PARENT_JOBID_IN - the GUID of the parent job
--   NESTED_JOBID_IN - the GUID of the nested job
--
PROCEDURE NESTED_JOB_ADDED(parent_jobid_in IN RAW,
                           nested_jobid_in IN RAW);

--
-- PURPOSE
--
--  To notify the user model that a nested job has been deleted. This allows
--  the User Model to remove it from the job cache
--
--  PARAMETERS
--
--   NESTED_JOBID_IN - the GUID of the nested job
--
PROCEDURE NESTED_JOB_DELETED( nested_jobid_in IN RAW);

--
-- PURPOSE
--
--  To notify the user model that a report has been deleted. This allows
--  the User Model to remove any grants for that job
--
--  PARAMETERS
--
--   REPORT_GUID_IN - the GUID of the deleted report definition
--
PROCEDURE REPORT_DEFINITION_DELETED(report_guid_in IN RAW);
                                                                                
--
-- PURPOSE
--
--  To notify the user model that a template has been deleted. This allows
--  the User Model to remove any grants for that job
--
--  PARAMETERS
--
--   TEMPLATE_GUID_IN - the GUID of the deleted template
--
PROCEDURE TEMPLATE_DELETED(template_guid_in IN RAW);
                                                                                
--
-- PURPOSE
--
--  To notify the user model that a template has been deleted. This allows
--  the User Model to remove any grants for that job
--
--  PARAMETERS
--
--   JOB_GUID_IN - the GUID of the deleted corrective action
--
PROCEDURE CORRECTIVE_ACTION_DELETED(job_guid_in IN RAW);
                                                                                
--
-- PURPOSE
--
--  To add a callback that is invoked whenever one of the following happens:
--  * a user is created
--  * a user is dropped
--  * a user is reassigned to a new user
--  * a user has a privilege granted
--  * a user has a privilege revoked
--  * to get a list of objects owned by the user
--  * to check for conflicts while droping a user
--  * to check for conflicts while reassigning a user
--
-- PARAMETERS
--
--   TYPE_IN - the type of the callback
--             MGMT_USER.USER_CREATED_CALLBACK
--             MGMT_USER.USER_DROPPED_CALLBACK
--             MGMT_USER.USER_REASSIGN_CALLBACK
--             MGMT_USER.PRIV_GRANTED_CALLBACK
--             MGMT_USER.PRIV_REVOKED_CALLBACK
--             MGMT_USER.GET_USER_OBJECTS_CALLBACK
--             MGMT_USER.CHECK_DROP_USER_CALLBACK
--             MGMT_USER.CHECK_REASSIGN_USER_CALLBACK
--
--   PROC_IN - the name of the callback which must be defined as :
--
--            PROCEDURE USER_CREATED_CALLBACK(user_name_in  IN VARCHAR2,
--                                            type_in       IN NUMBER);
--
--            PROCEDURE USER_DROPED_CALLBACK(user_name_in  IN VARCHAR2,
--                                            type_in       IN NUMBER);
--
--            PROCEDURE USER_REASSIGN_CALLBACK(user_name_in     IN VARCHAR2,
--                                             new_user_name_in IN VARCHAR2,
--                                             type_in          IN NUMBER);
--
--            PROCEDURE PRIV_CALLBACK(user_names_in IN MGMT_MEDIUM_STRING_ARRAY,
--                                    priv_names_in IN MGMT_MEDIUM_STRING_ARRAY,
--                                    guids_in      IN MGMT_USER_GUID_ARRAY,
--                                    type_in       IN NUMBER);
--
--            PROCEDURE GET_USER_OBJECTS_CALLBACK(
--                                      user_name_in     IN VARCHAR2,
--                                      user_objects_out OUT MGMT_USER_OBJECTS,
--                                      type_in          IN NUMBER);
--
--            PROCEDURE CHECK_DROP_USER_CALLBACK(
--                                      user_name_in     IN VARCHAR2,
--                                      user_objects_out OUT MGMT_USER_OBJECTS,
--                                      type_in          IN NUMBER);
--
--            PROCEDURE CHECK_REASSIGN_USER_CALLBACK(
--                                      user_name_in     IN VARCHAR2,
--                                      new_user_name_in     IN VARCHAR2,
--                                      user_objects_out OUT MGMT_USER_OBJECTS,
--                                      type_in          IN NUMBER);
--
PROCEDURE ADD_CALLBACK(proc_in IN VARCHAR2,
                       type_in IN NUMBER);
--
-- PURPOSE
--
--  To remove a callback
--
-- PARAMETERS
--   PROC_IN - the name of the callback
--   TYPE_IN - the type of the callback
--
PROCEDURE REMOVE_CALLBACK(proc_in IN VARCHAR2,
                          type_in IN NUMBER);

--
-- PURPOSE
--
--   To check whether a target can be added to a group. The target can be
--   added only if the user has the same privileges on the target as the user
--   has on the group. For example if the user has MAINTAIN_TARGET on a group
--   then a target can only be added to the group if the user also has
--   MAINTAIN_TARGET on the group.
--
-- PARAMETERS
--
--  GROUP_GUID_IN - the target GUID of the group
--  MEMBER_TARGET_NAME_IN, MEMBER_TARGET_TYPE_IN: The name and type of the
--      member target
--
-- NOTES
--
--  Returns 1 if member can be added to a group
-- 
FUNCTION VALID_GROUP_MEMBER(group_guid_in  IN RAW,
                            member_target_name_in IN VARCHAR2,
                            member_target_type_in IN VARCHAR2)
RETURN NUMBER;

--
-- PURPOSE
--
--  To get the list of available privileges of a given type
--
-- PARAMETERS
--
--   PRIV_TYPE_IN - the type of privilege
--                  0 - SYSTEM
--                  1 - TARGET
--                  2 - TARGET_GROUP 
--                  -1 - All privileges 
--   USER_DEFINED_IN - flag to indicate whether user defined privs should be
--                     returned. 0 => no, 1 => yes
--   PRIVS_OUT - the privileges are returned here
--
-- NOTES
--
--
PROCEDURE GET_PRIVS(priv_type_in    IN NUMBER,
                    user_defined_in IN NUMBER,
                    privs_out       OUT SMP_EMD_STRING_ARRAY);

--
-- PURPOSE
--
--  To get the list of available privileges of a given type for a particular
--  user
--
-- PARAMETERS
--
--   USER_NAME_IN - the name of the user
--   PRIV_TYPE_IN - the type of privilege
--                  0 - SYSTEM
--                  1 - TARGET
--                  2 - TARGET_GROUP 
--                  -1 - All privileges 
--   USER_DEFINED_IN - flag to indicate whether user defined privs should be
--                     returned. 0 => no, 1 => yes
--   PRIVS_OUT - the privileges are returned here
--
-- NOTES
--
--
PROCEDURE GET_USER_PRIVS(user_name_in    IN VARCHAR2,
                         priv_type_in    IN NUMBER,
                         user_defined_in IN NUMBER,
                         privs_out       OUT PRIVS_CURSOR);

--
-- PURPOSE
--
--  To get the list of available roles
--
-- PARAMETERS
--
--   ROLES_OUT - the roles are returned here
--
-- NOTES
--
--  The NAME component of the SMP_EMD_NVPAIR contains the name of the role
--  and the VALUE component of the SMP_EMD_NVPAIR containst the description
--  of the role
--
PROCEDURE GET_ROLES(roles_out OUT ROLEDESC_CURSOR);

--
-- PURPOSE
--
--  To get the list of privileges of a given type for a particular role
--
-- PARAMETERS
--
--   ROLE_NAME_IN - the name of the role
--   PRIV_TYPE_IN - the type of privilege
--                  0 - SYSTEM
--                  1 - TARGET
--                  2 - TARGET_GROUP 
--                  -1 - All privileges 
--   USER_DEFINED_IN - flag to indicate whether user defined privs should be
--                     returned. 0 => no, 1 => yes
--   PRIVS_OUT - the privileges are returned here
--   USER_NAMES_OUT - the list of users who have been granted the role
--
-- NOTES
--
--
PROCEDURE GET_ROLE_PRIVS(role_name_in    IN VARCHAR2,
                         priv_type_in    IN NUMBER,
                         user_defined_in IN NUMBER,
                         privs_out       OUT PRIVS_CURSOR,
                         user_names_out  OUT STRING_CURSOR);

--
-- PURPOSE
--
--  To get the list of privileges and roles belonging to a role
--
-- PARAMETERS
--
--   ROLE_NAME_IN - the name of the roles
--   PRIVS_OUT - the privileges are returned here
--   ROLES_OUT - the roles are returned here
--
-- NOTES
--
--  If this procedure is used to get the list of permissions associated
--  with a role for display in a UI then another call will have to be made
--  to get the details of an included role i.e. this is not a flattened list
--
PROCEDURE GET_ROLE_GRANTS(role_name_in IN VARCHAR2,
                          privs_out    OUT PRIVS_CURSOR,
                          roles_out    OUT STRING_CURSOR);

--
-- PURPOSE
--
--  To get the list of users assigned a particular role
--
-- PARAMETERS
--
--   ROLE_NAME_IN - the name of the roles
--   AVAILABLE_USERS_OUT - the users that are not currently granted the role are
--                         returned here
--   GRANTED_USERS_OUT - the users that are currently granted the role are
--                       returned here
--
-- NOTES
--
PROCEDURE GET_ROLE_USERS(role_name_in        IN VARCHAR2,
                         available_users_out OUT STRING_CURSOR,
                         granted_users_out   OUT STRING_CURSOR);

--
-- PURPOSE
--
--  To get the list of roles granted to a user
--
-- PARAMETERS
--
--   USER_NAME_IN - the name of the user
--   ROLES_OUT - the roles are returned here
--
-- NOTES
--
--
PROCEDURE GET_USER_ROLES(user_name_in IN VARCHAR2,
                         roles_out    OUT STRING_CURSOR);

--
-- PURPOSE
--
--  To get the list of roles currently granted to a role and the list of
--  roles available for granting to that role
--
-- PARAMETERS
--
--   ROLE_NAME_IN - the name of the role
--   AVAILABLE_ROLES_OUT - the roles available for granting to ROLE_NAME_IN 
--                         are returned here
--   GRANTED_ROLES_OUT - the roles currently granted to ROLE_NAME_IN are
--                       returned here
--
-- NOTES
--
PROCEDURE GET_ROLES_FOR_ROLE(role_name_in        IN VARCHAR2, 
                             available_roles_out OUT STRING_CURSOR, 
                             granted_roles_out   OUT STRING_CURSOR);

--
-- PURPOSE
--
--  To get the list of targets that this role has FULL_TARGET privilege on
--
-- PARAMETERS
--
--   ROLE_NAME_IN - the name of the role
--   TARGETS_OUT - the distinct array of targets that have privileges granted
--                 on them by this role. 
--
-- NOTES
--
PROCEDURE GET_TARGETS_FOR_ROLE(role_name_in IN VARCHAR2,
                               targets_out  OUT TARGETS_CURSOR);

--
-- PURPOSE
--
--  To get the list of targets on which a user has been granted FULL_TARGET 
--  privilege
--
-- PARAMETERS
--
--   USER_NAME_IN - the name of the user
--   TARGETS_OUT - the distinct array of targets that the user has been granted
--                 privileges on   
--
-- NOTES
--
PROCEDURE GET_TARGETS_FOR_USER(user_name_in IN VARCHAR2,
                               targets_out  OUT TARGETS_CURSOR);

--
-- PURPOSE
--
--  To get the list of privileges for each target with an flag to indicate
--  whether :
--
--   * Privilege not granted to any of the roles passed in, or to the caller of
--     the procedure 
--   * Privilege granted to caller of the procedure and not granted to any of
--     the roles passed in
--   * Privilege granted to any of the roles passed in
--
-- PARAMETERS
--
--   ROLES_IN - the roles to check
--   TARGETS_IN - the list of target_guids
--   PRIVS_OUT - a cursor returning:
--               target_name
--               target_type   
--               target_privilege 
--               privilege_state (one of the three states listed above
--
-- NOTES
-- 
--  The privilege state can be :
--    0 => NOT GRANTED
--    1 => GRANTED TO CALLER
--    2 => GRANTED TO ROLE
--
--
PROCEDURE GET_TARGET_PRIVS(roles_in   IN SMP_EMD_STRING_ARRAY,
                           targets_in IN MGMT_USER_GUID_ARRAY,
                           privs_out  OUT TARGET_PRIVS_CURSOR);

--
-- PURPOSE
--
--  To get the max privilege a user has on any target. This will not include
--  user defined privilege. The privilege can be granted the privilege
--  directly, via a role, via a nested role or via a group privilege.
--
-- PARAMETERS
--
--  USER_NAME_IN - the name of the user
--
-- NOTES
--
--  Can only be called by a user with the SUPER_USER privilege
--
FUNCTION GET_MAX_PRIV(user_name_in IN VARCHAR2)
RETURN VARCHAR2;

--
-- PURPOSE
--
--  To get the max privilege the current user has on any target. This will not
--  include user defined privilege. The privilege can be granted the privilege
--  directly, via a role, via a nested role or via a group privilege.
--
FUNCTION GET_MAX_PRIV
RETURN VARCHAR2;

--
-- PURPOSE
--
--  To generate a security policy for a user accessing the MGMT_TARGETS table
--
FUNCTION EM47455450524544494341544554(p_schema IN VARCHAR2,
                                      p_object in VARCHAR2) 
RETURN VARCHAR2;

--
-- PURPOSE
--
--  To generate a security policy for a user accessing the MGMT_JOB table
--
FUNCTION EM4745545052454449434154454A(p_schema IN VARCHAR2,
                                      p_object in VARCHAR2) 
RETURN VARCHAR2;

--
-- PURPOSE
--
--  To generate a security policy for a user accessing the MGMT_TEMPLATES table
--
FUNCTION GET_TEMPLATE_PREDICATE(p_schema IN VARCHAR2,
                                p_object in VARCHAR2)
RETURN VARCHAR2;

--
-- PURPOSE
--
--  To generate a security policy for a user accessing the MGMT_IP_REPORT_DEF 
--  table
--
FUNCTION GET_REPORT_DEF_PREDICATE(p_schema IN VARCHAR2,
                                  p_object in VARCHAR2)
RETURN VARCHAR2;

--
-- PURPOSE
--
--  To generate a security policy for a user accessing the 
--  and MGMT_IP_STORED_REPORT table
--
FUNCTION GET_STORED_REPORT_PREDICATE(p_schema IN VARCHAR2,
                                     p_object in VARCHAR2)
RETURN VARCHAR2;

--
-- PURPOSE
--
--  To generate a security policy for a user accessing the 
--  MGMT_CORRECTIVE_ACTION table
--
FUNCTION GET_CA_PREDICATE(p_schema IN VARCHAR2,
                          p_object in VARCHAR2)
RETURN VARCHAR2;

--
-- PURPOSE
--
--  Sets the user context for EM, calculates the security predicate and 
--  builds caches of visible objects based on user's privilege set
--
-- PARAMETERS
--  
--  EM_CLIENT_IN - the name of the EMD user
--
--  OP_IN - the operation to perform
--
--          OP_SET_IDENTIFIER - set the current user and build visible object
--                              caches if necessary
--          OP_CLEAR_IDENTIFIER - clear the current user 
--          OP_CLEAR_CONTEXT - clear the user's caches
--          OP_CLEAR_CONTEXTS - clear all caches
--          OP_CREATE_TARGET_CONTEXT - create the user's visible target cache
--          OP_CREATE_JOB_CONTEXT - create the user's visible job cache
--          OP_CREATE_TEMPLATE_CONTEXT - create the user's visible template 
--                                       cache
--          OP_CREATE_REPORT_DEF_CONTEXT - create the user's visible report 
--                                         definition cache
--          OP_CREATE_CA_CONTEXT - create the user's visible corrective action 
--                                 cache
--          OP_INVALIDATE_TARGET_CONTEXT - invalidate the user's visible target
--                                         cache
--          OP_INVALIDATE_JOB_CONTEXT - invalidate the user's visible job cache
--          OP_INVALIDATE_TEMPLATE_CONTEXT - invalidate the user's visible 
--                                           template cache
--          OP_INVALIDATE_REPORT_CONTEXT - invalidate the user's visible report
--                                         definition cache
--          OP_INVALIDATE_CA_CONTEXT - invalidate the user's visible corrective
--                                     action cache
--
-- NOTE:
--  This procedure cannot be called directly - it must be called from the
--  procedure SETEMUSERCONTEXT. SETEMUSERCONTEXT is very powerful and 
--  only the repository owner should be granted execute permission on it
--
PROCEDURE SET_EM_USER_CONTEXT(em_client_in IN VARCHAR2,
                              op_in        IN INTEGER);

--
-- PURPOSE
--
--  To return the current EM user. Note that this is not necessarily
--  the owner of the database session (the pl/sql variable USER).
--
-- PARAMETERS
--  NONE
--
-- NOTES
--
FUNCTION GET_CURRENT_EM_USER RETURN VARCHAR2;

--
-- PURPOSE
--
--  To return the owner of the repository schema
--
-- PARAMETERS
--  NONE
--
-- NOTES
--
FUNCTION GET_REPOSITORY_OWNER RETURN VARCHAR2;

--
-- PURPOSE
--
--  To return all nodes in the repository, and specify, for each node,
--  whether there is at least one target on the node that the current user
--  has the specified privilege on.
--
-- INPUT PARAMETERS
--  p_privilege The privilege to check for
--
-- RETURN
--   A cursor that lists the nodes that have at least
--   one target that the user has the specified privilege on. This is a
--   cursor with three columns: the host name, emd url, and the last 
--   time any data was uploaded from that emd
--
-- NOTES
--
FUNCTION GET_NODE_LIST_WITH_PRIVILEGE(p_privilege IN VARCHAR2) RETURN NODELIST_CURSOR;

--
-- PURPOSE
--   To invalidate the cached security contexts of all users that have 
--   been granted a role that has been modified
--
-- PARAMETER
--   MODIFIED_ROLE_NAME_IN - the name of the role that has been modified
--
PROCEDURE INVALIDATE_USERS(modified_role_name_in   IN VARCHAR2);

--
-- PURPOSE
--
--  To return the management privileges for the logged on user
--
-- PARAMETERS
--
--  SUPER_USER_OUT - true(1) if the user is a superuser
--  EMREP_USER_OUT - true(1) if the user has access to the emrep target
--  EMD_USER_OUT - true(1) if the user has access to any emd target
--  VALID_EM_USER_OUT - true (1) if the user is a valid "EM" user
--
PROCEDURE GET_MGMT_PRIVS(super_user_out OUT INTEGER,
                         emrep_user_out OUT INTEGER,
                         emd_user_out OUT INTEGER,
                         valid_em_user_out OUT INTEGER);


-- PURPOSE
--
-- To update the pref email of the current user
--
-- PARAMETERS
--  user_name_in - the name of the user
--  user_email_in - the new list of email addresses
--
PROCEDURE UPDATE_USER_PREF_EMAIL( user_name_in IN VARCHAR2,
                                  user_email_in IN SMP_EMD_STRING_ARRAY );

-- PURPOSE
--
-- To update the pref email (and its format) of the current user
--
-- PARAMETERS
--  user_name_in - the name of the user
--  user_email_in - the new list of email addresses
--  user_email_format_in - the format of the new list of email addresses
--
PROCEDURE UPDATE_USER_PREF_EMAIL ( user_name_in IN VARCHAR2,
                                   user_email_in IN SMP_EMD_STRING_ARRAY,
                                   user_email_format_in IN SMP_EMD_INTEGER_ARRAY );

-- PURPOSE
--
-- To identify which alias to use for a user accessing subtab preferences.
--
-- PARAMETERS
--  user_name_in - the name of the user
--  subtab_name - the subtab being accessed
--
-- RETURN
--  user_name_in if preferences exist the user for the give subtab or wildcard 
--  otherwise (WILDCARD_USER_NAME_ALIAS).
FUNCTION GET_SUBTAB_PREFS_ALIAS(user_name_in   IN VARCHAR2,
                                subtab_name_in IN VARCHAR2)
  RETURN VARCHAR2;

-- PURPOSE
--
-- To identify which alias to use for a user accessing metric preferences.
-- This function only remains for backward compatability, new code should use
-- GET_SUBTAB_PREFS_ALIAS instead.
--
-- PARAMETERS
--  user_name_in - the name of the user
--  target_type_in - the target type to constrain to
--
-- RETURN
--  user_name_in if metric preferences exists for that user in that target
--  type, wildcard (WILDCARD_USER_NAME_ALIAS) otherwise.
FUNCTION GET_METRIC_PREFS_ALIAS(user_name_in   IN VARCHAR2,
                                target_type_in IN VARCHAR2)
  RETURN VARCHAR2;

--
-- PURPOSE
--  To get the list of targets associated with the repository target
--
-- PARAMETERS
--  INCLUDE_REPOSITORY_TARGET - flag to indicate whether the repository
--                              target itself should be included
--

FUNCTION GET_REPOSITORY_TARGETS(include_repository_target IN NUMBER DEFAULT 1)
   RETURN MGMT_USER_GUID_ARRAY;

PROCEDURE GET_USER_JOB_PRIV (job_id_in IN RAW,
                          user_name_in IN VARCHAR2,
                          admin_out OUT VARCHAR2,
                          priv_out OUT VARCHAR2);

--
-- To return a list of users and roles assigned the VIEW_REPORT privilege
-- for a particular report.
--
-- PARAMETERS
--  report_id_in - the report_id
--  owner_out - the name of the report owner 
--  grantees_out - a cursor - user/role name, type (ROLE,ADMIN) and
--  privilege
--
PROCEDURE GET_REPORT_GRANTS (report_id_in IN RAW,
                          owner_out OUT VARCHAR2,
                          grantees_out OUT GRANT_CURSOR);


-- PURPOSE
--
-- To revoke the VIEW_REPORT privilege for a particular report to
-- any users that currently have that privilege
-- for a particular report.
--
-- PARAMETERS
--  report_id_in - the report_id
--
PROCEDURE REVOKE_VIEW_REPORT_ALL(report_id_in IN RAW,
                                 owner_in IN VARCHAR2);

-- PURPOSE
--
-- To modify privileges for a particular job.
--
-- PARAMETERS
--  job_id_in - IN the jobid
--  replace_in - IN whether or not to replace the existing grants with the new set
--        Valid values 'Y' 'N' - defaults to 'Y'
--  grant_name_in - IN - an array of name/value grants.  The first is the user or role
--        name, the value is the privilege being granted (VIEW_JOB or FULL_JOB)
--
PROCEDURE MODIFY_JOB_GRANTS (job_id_in IN RAW,
                             replace_in IN VARCHAR2 DEFAULT 'Y', 
                             grant_name_in IN SMP_EMD_NVPAIR_ARRAY);
--
-- PURPOSE
--
--  To create a user in db console mode
--
-- PARAMETERS
--
--  USER_NAME_IN - the name of the user
--  PASSWORD_IN - the password of the user
--  EMAIL_ADDRESSES_IN - the email addresses of the user
--  ROLES_IN - the roles to grant to the user
--  PRIVILEGES_IN - the privileges to grant to the user
--  For more details, please look at CREATE_USER
--
PROCEDURE CREATE_USER_DBCONSOLE(user_name_in       IN VARCHAR2,
                      password_in        IN VARCHAR2,
                      email_addresses_in IN SMP_EMD_STRING_ARRAY,
                      roles_in           IN SMP_EMD_STRING_ARRAY DEFAULT NULL,
                      privileges_in      IN MGMT_USER_PRIVILEGES DEFAULT NULL);
--
-- PURPOSE
--
--  "Convert" an existing database user into an EM user
--   in DB Console mode
--   On top of MAKE_EM_USER, it grants the database user
--   SELECT ANY DICTIONARY system privilege.
-- PARAMETERS
--
--  USER_NAME_IN - the name of the user
--  EMAIL_ADDRESSES_IN - the email addresses of the user
--  ROLES_IN - the roles to grant to the user
--  PRIVILEGES_IN - the privileges to grant to the user
--  TO_GRANT_DB_PRIV_IN - whether to grant SELECT ANY DICTIONARY
--  System privilege to the database user, DEFAULT is TRUE
--
PROCEDURE MAKE_EM_USER_DBCONSOLE(user_name_in IN VARCHAR2,
                       email_addresses_in IN SMP_EMD_STRING_ARRAY,
                       roles_in           IN SMP_EMD_STRING_ARRAY, 
                       privileges_in      IN MGMT_USER_PRIVILEGES,
		       to_grant_db_priv_in IN NUMBER DEFAULT 1);

--
-- PURPOSE
--
--  To get a list of users
--
-- PARAMETERS
--
--  USER_NAMES_OUT - the names of the user
--
-- NOTES
--
--  This routines searches for all users that have the MGMT_USER role 
--  and are Database users. It
--  will not return the repository owner, and will not return any 
--  users with the SUPER_USER privilege, if the caller is not a SUPER_USER.
--  p_user-->IN parameter added to facilitate WILDCARD SEARCH
PROCEDURE GET_USERS_DBCONSOLE(user_names_out OUT STRING_CURSOR,
                              p_user_srch    IN VARCHAR2 DEFAULT NULL);
--
-- Acquires read lock for current em user 
-- so that the user  cannot be deleted when activity in progress
--
FUNCTION GET_READ_LOCK(exception_id_in IN NUMBER) RETURN VARCHAR2;
--
-- Releases the read lock
--
FUNCTION RELEASE_READ_LOCK(lock_handle_in IN VARCHAR2) RETURN NUMBER;


--
-- PURPOSE
--
--  To get a list of objects owned by the users
--
-- PARAMETERS
--
--  USER_NAME_IN - the names of the user
--
-- NOTES
--
--  This routines return a list of bjects owned by the user. which include  
--  jobs, jobtypes, blackouts, targets, corrective action, templates, reports 
--  and report definition
--
FUNCTION GET_USER_OBJECTS(user_name_in IN VARCHAR2) RETURN MGMT_USER_OBJECTS; 

--
-- PURPOSE
--
--  To check weather the user owns some objects which cant be droped
--  Returns a list of all conflicting objects
--
-- PARAMETERS
--
--  USER_NAME_IN - the names of the user
--
-- NOTES
--
--
FUNCTION CHECK_DROP_USER_CONFLICTS(user_name_in IN VARCHAR2) RETURN MGMT_USER_OBJECTS; 

--
-- PURPOSE
--
--  To check weather the user owns some objects which cant be reassigned to the 
--  new user. Returns a list of all conflicting objects
--
-- PARAMETERS
--
--  USER_NAME_IN - the names of the user
--
-- NOTES
--
--
FUNCTION CHECK_REASSIGN_USER_CONFLICTS(user_name_in IN VARCHAR2,
                                       new_user_name_in IN VARCHAR2) RETURN MGMT_USER_OBJECTS; 
--
-- PURPOSE
--
--  To get the list of users and roles.
--
-- PARAMETERS
--
--  p_given_object_name - the names of the user
--  p_object_name - Array of user/role names
--  p_object_description - Array of description for user/role
--
--
--
--
PROCEDURE GET_USER_ROLE_LIST(p_given_object_name IN VARCHAR2,
				p_object_name OUT VARCHAR2_TABLE,
    				   p_object_description OUT VARCHAR2_TABLE);
--
-- PURPOSE
--
--  To get the access info for targets..
--
-- PARAMETERS
--
--  p_target_name - Name of the target
--  p_target_type - Type of target
--  p_error_message - Error Message
--  p_user_name - Array of user/role names
--  p_user_description - Array of description of user/role
--  p_user_privilege - Array of privileges
--
--
--
procedure get_access_info(p_target_name IN VARCHAR2, 
                            p_target_type IN VARCHAR2,
                              p_error_message OUT VARCHAR2,
			       p_super_or_owner OUT VARCHAR2, 
                                p_user_name OUT VARCHAR2_TABLE, 
                                  p_user_description OUT VARCHAR2_TABLE,
                                    p_user_privilege OUT VARCHAR2_TABLE);
--
-- PURPOSE
--
--  To get the access info for templates..
--
-- PARAMETERS
--
--  p_target_name - Name of the target
--  p_target_type - Type of target
--  p_error_message - Error Message
--  p_user_name - Array of user/role names
--  p_user_description - Array of description of user/role
--  p_user_privilege - Array of privileges
--
--
--
procedure get_access_info_template(p_target_name IN VARCHAR2,
                                     p_target_type IN VARCHAR2,
                                       p_error_message OUT VARCHAR2,
				        p_super_or_owner OUT VARCHAR2,
                                         p_user_name OUT VARCHAR2_TABLE,
                                           p_user_description OUT VARCHAR2_TABLE,
                                              p_user_privilege OUT VARCHAR2_TABLE);
--
-- PURPOSE
--
--  To update the privileges.
--
-- PARAMETERS
--
--  p_target_name - Name of the target
--  p_target_type - Type of target
--  p_type - Either type is target or template
--  p_object_name - Array of user/role names
--  p_object_priv - Array of privileges of user/role
--
--
--

PROCEDURE update_privilige(p_target_name IN VARCHAR2,
                             p_target_type IN VARCHAR2,
                               p_type IN VARCHAR2, 
                                 p_object_name IN VARCHAR2_TABLE,
                                   p_object_priv IN VARCHAR2_TABLE);


--
-- PURPOSE
--
--  To update the privileges. This Procedure takes arrays as parameters and grant/update or revoke the 
--  privileges according to the condition.
--
-- PARAMETERS
--
--  p_target_name - Name of the target
--  p_target_type - Type of target
--  p_type - Either type is target or template
--  p_new_object_name - Array of new user/role names
--  p_new_object_priv - Array of new privileges of user/role
--  p_changed_object_name - Array of changed user/role names
--  p_changed_object_priv - Array of changed privileges of user/role
--  p_previous_object_name - Array of previous user/role names needed to revoke the privilege
--  p_previous_object_priv - Array of previous privileges of user/role needed to revoke the privilege
--  p_revoked_object_name - Array of revoked user/role names
--  p_revoked_object_priv - Array of revoked privileges of user/role
--
--

PROCEDURE update_privilege(p_target_name IN VARCHAR2,
                           p_target_type IN VARCHAR2,
                           p_type IN VARCHAR2,
                           p_new_object_name IN VARCHAR2_TABLE DEFAULT NULL,
                           p_new_object_priv IN VARCHAR2_TABLE DEFAULT NULL,
			   p_changed_object_name IN VARCHAR2_TABLE DEFAULT NULL,
                           p_changed_object_priv IN VARCHAR2_TABLE DEFAULT NULL,
			   p_previous_object_name IN VARCHAR2_TABLE DEFAULT NULL,
                           p_previous_object_priv IN VARCHAR2_TABLE DEFAULT NULL,
			   p_revoked_object_name IN VARCHAR2_TABLE DEFAULT NULL,
                           p_revoked_object_priv IN VARCHAR2_TABLE DEFAULT NULL);				


--
-- PURPOSE
--
--  To update the privileges. This Procedure is like an api which will be called from the MGMT_USER.update_privilege
--  procedure and according to the condition it will either grant or revoke the privilege.
--
-- PARAMETERS
--
--  p_guid - guid
--  p_revoke_or_grant - Either revoke or grant
--  p_object_name - Array of user/role name
--  p_object_priv - Array of new user/role privileges
--
--
PROCEDURE update_revoke_grant_privilege(p_guid IN RAW,
                           		p_revoke_or_grant IN VARCHAR2,
					p_object_name IN VARCHAR2_TABLE,
                                        p_object_priv IN VARCHAR2_TABLE);


END MGMT_USER;
/

show errors;


