Rem
Rem $Header: sdk_view_user_pkgdef.sql 02-may-2005.06:38:18 mkm Exp $
Rem
Rem sdk_view_user_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_view_user_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    mkm         05/02/05 - adding ADJUST_TZ 
Rem    mgoodric    10/26/04 - mgoodric_add_mgmt_view_package_041025
Rem    mgoodric    10/23/04 - moved from ecm_util_pkgdef
Rem

rem********************************************************************
rem
rem  PURPOSE
rem
rem     The MGMT_VIEW_UTIL package contains procedures and functions for various
rem     purposes to be used when accessed as the MGMT_VIEW user.
rem
rem
rem   The methods in this package do not make any assumptions about
rem   transacations.  Essentially, it is up to the caller to commit or rollback,
rem   unless otherwise noted.
rem
CREATE OR REPLACE PACKAGE MGMT_VIEW_UTIL
IS

  -- Given a text (alphanumeric) string, try to figure out if the string is a
  -- number (Numeric Value).  If yes, return the number else return NULL
  FUNCTION NV( v_textInQuestion IN VARCHAR2 )
    RETURN NUMBER;

  -- Function that returns a string that is a concatenated list
  -- of all the key's name-value pairs.  This can be used to display keys.
  --     Example result: 'Name: kernel; Type: Package'
  --
  FUNCTION GET_DELTA_KEY_NLS_STRING( v_key_row_guid RAW,
                                     v_target_type VARCHAR2,
                                     v_snapshot_type VARCHAR2,
                                     v_collection_type VARCHAR2,
                                     v_locale VARCHAR2 := NULL )
    RETURN NVARCHAR2;

  -- Function that returns a string that is the column's NLS display name
  --     Example result: 'Name' for NAME column
  --
  FUNCTION GET_DELTA_VALUE_NLS_STRING( v_column_name VARCHAR2,
                                       v_target_type VARCHAR2,
                                       v_snapshot_type VARCHAR2,
                                       v_collection_type VARCHAR2,
                                       v_locale VARCHAR2 := NULL )
    RETURN NVARCHAR2;

  -- Function that returns a string that is the resource id's NLS display name
  --     Example result: 'New Item' for INSERT value
  --
  FUNCTION GET_DELTA_RESOURCE_NLS_STRING( v_resource_id VARCHAR2,
                                          v_resource_bundle VARCHAR2,
                                          v_locale VARCHAR2 := NULL,
                                          v_default VARCHAR2 := NULL )
    RETURN NVARCHAR2;


-- To convert the timezone of the date from from-tz to to-tz
FUNCTION ADJUST_TZ(v_date_in DATE,
                   v_from_tz VARCHAR2,
                   v_to_tz VARCHAR2)
  RETURN DATE;
END MGMT_VIEW_UTIL;
/
show errors;


