Rem
Rem $Header: sdk_violation_pkgdef.sql 30-dec-2005.02:17:22 hbadheka Exp $
Rem
Rem sdk_violation_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_violation_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    hbadheka    12/25/05 - add get_violation_guid 
Rem    niramach    02/03/05 - exempt->suppress conversion. 
Rem    jsadras     01/20/05 - purge violations 
Rem    jsadras     12/07/04 - purge_apis
Rem    rpinnama    09/09/04 - Add cfg_* parameters to log_violation APIs 
Rem    rpinnama    07/26/04 - rpinnama_add_policy_api
Rem    rpinnama    07/14/04 - Created
Rem


CREATE OR REPLACE PACKAGE mgmt_violation
AS

  --
  -- API to log a metric threshold violation
  --
  PROCEDURE log_threshold_violation(
      p_target_type           IN VARCHAR2,
      p_target_name           IN VARCHAR2,
      p_metric_name           IN VARCHAR2,
      p_metric_column         IN VARCHAR2,
      p_key_value             IN VARCHAR2 DEFAULT ' ',
      p_collection_timestamp  IN DATE DEFAULT NULL,
      p_violation_level       IN NUMBER DEFAULT NULL,
      p_value                 IN NUMBER DEFAULT NULL,
      p_string_value          IN VARCHAR2 DEFAULT NULL,
      p_message               IN VARCHAR2 DEFAULT NULL,
      p_message_nlsid         IN VARCHAR2 DEFAULT NULL,
      p_message_params        IN VARCHAR2 DEFAULT NULL,
      p_action_message        IN VARCHAR2 DEFAULT NULL,
      p_action_message_nlsid   IN VARCHAR2 DEFAULT NULL,
      p_action_message_params IN VARCHAR2 DEFAULT NULL,
      p_advisory_id           IN VARCHAR2 DEFAULT NULL,
      p_cfg_coll_name         IN VARCHAR2 DEFAULT NULL,
      p_cfg_key_value         IN VARCHAR2 DEFAULT NULL,
      p_cfg_key_operator      IN NUMBER   DEFAULT NULL,
      p_violation_ctxt_list   IN MGMT_VIOL_NAME_VALUE_ARRAY DEFAULT NULL,
      p_notification_status   IN NUMBER DEFAULT MGMT_GLOBAL.G_NOTIF_STATUS_NEW);

  --
  -- API to log a policy violation
  --
  PROCEDURE log_policy_violation(
      p_target_type           IN VARCHAR2,
      p_target_name           IN VARCHAR2,
      p_policy_name           IN VARCHAR2,
      p_key_value             IN VARCHAR2 DEFAULT ' ',
      p_collection_timestamp  IN DATE DEFAULT NULL,
      p_violation_level       IN NUMBER DEFAULT NULL  ,
      p_action_message        IN VARCHAR2 DEFAULT NULL,
      p_action_message_nlsid  IN VARCHAR2 DEFAULT NULL,
      p_action_message_params IN VARCHAR2 DEFAULT NULL,
      p_advisory_id           IN VARCHAR2 DEFAULT NULL,
      p_cfg_coll_name         IN VARCHAR2 DEFAULT NULL,
      p_cfg_key_value         IN VARCHAR2 DEFAULT NULL,
      p_cfg_key_operator      IN NUMBER   DEFAULT NULL,
      p_violation_ctxt_list   IN MGMT_VIOL_NAME_VALUE_ARRAY DEFAULT NULL);

  --
  -- Log a violation given a target_guid, policy_guid
  --
  PROCEDURE log_violation(
      p_target_guid           IN RAW,
      p_policy_guid           IN VARCHAR2,
      p_key_value             IN VARCHAR2 DEFAULT ' ',
      p_collection_timestamp  IN DATE DEFAULT NULL,
      p_violation_level       IN NUMBER DEFAULT NULL,
      p_violation_type        IN NUMBER DEFAULT NULL,
      p_value                 IN NUMBER DEFAULT NULL,
      p_string_value          IN VARCHAR2 DEFAULT NULL,
      p_message               IN VARCHAR2 DEFAULT NULL,
      p_message_nlsid         IN VARCHAR2 DEFAULT NULL,
      p_message_params        IN VARCHAR2 DEFAULT NULL,
      p_action_message        IN VARCHAR2 DEFAULT NULL,
      p_action_message_nlsid  IN VARCHAR2 DEFAULT NULL,
      p_action_message_params IN VARCHAR2 DEFAULT NULL,
      p_advisory_id           IN VARCHAR2 DEFAULT NULL,
      p_cfg_coll_name         IN VARCHAR2 DEFAULT NULL,
      p_cfg_key_value         IN VARCHAR2 DEFAULT NULL,
      p_cfg_key_operator      IN NUMBER   DEFAULT NULL,
      p_violation_ctxt_list   IN MGMT_VIOL_NAME_VALUE_ARRAY DEFAULT NULL,
      p_notification_status   IN NUMBER DEFAULT MGMT_GLOBAL.G_NOTIF_STATUS_NEW);

  PROCEDURE add_violation_suppression(
      p_target_type           IN VARCHAR2,
      p_target_name           IN VARCHAR2,
      p_policy_name           IN VARCHAR2,
      p_key_value             IN VARCHAR2 DEFAULT ' ',
      p_suppress_code           IN NUMBER DEFAULT 0,
      p_suppress_until          IN DATE   DEFAULT NULL
  );

  FUNCTION get_viol_guid_with_keyGUID
     (
      p_target_guid           IN RAW,
      p_policy_guid           IN RAW,
      p_key_value_raw         IN RAW,
      p_collection_timestamp  IN DATE DEFAULT NULL
      )
  RETURN RAW ;
  
  FUNCTION get_viol_guid_with_keyString
     (
      p_target_guid           IN RAW,
      p_policy_guid           IN RAW,
      p_key_value             IN VARCHAR2 DEFAULT ' ',
      p_collection_timestamp  IN DATE DEFAULT NULL
      )
  RETURN RAW ;

  PROCEDURE add_violation_suppression(
      p_violation_guid        IN RAW,
      p_suppress_code           IN NUMBER DEFAULT 0,
      p_suppress_until          IN DATE   DEFAULT NULL
    );


  PROCEDURE remove_violation_suppression(
      p_target_type           IN VARCHAR2,
      p_target_name           IN VARCHAR2,
      p_policy_name           IN VARCHAR2,
      p_key_value             IN VARCHAR2 DEFAULT ' '
    );

  PROCEDURE remove_violation_suppression(
      p_violation_guid        IN RAW
    );
  -- 
  -- Purge all closed alerts for the given combination
  -- Parameters:
   -- IN Parameters:
  --   p_target_type: VARCHAR2 The type of the target
  --   p_target_name: VARCHAR2 The name of the target
  --   p_metric_name: VARCHAR2 The name of the metric
  --   p_metric_column: VARCHAR2 The name of the metric column
  --   p_key_values: list of key values, includes the key_part values
  --
  --   Example:A composite key metric with 2 key values
  --
  --     if you want to delete anything with the first key value like SYS%
  --     you would pass 
  --     mgmt_key_value_array(mgmt_key_value_obj('SYS%','%'))
  --    
  --     if you want to delete anything with first key value = SYS% or DB%
  --     you would pass 
  --     mgmt_key_value_array(mgmt_key_value_obj('SYS%','%'),
  --                          mgmt_key_value_obj('DB%','%'),
  --
  -- % is the wild card, if it is not present, it will be a exact search
  -- \ is the escape for %
  -- 
  -- CAUTION:
  -- if collection timestamp is null,  it purges for all closed alerts
  -- for the given target/metric/key combination
  --
  -- if key values is null then all alerts are purged for the target/metric
  --  and collection timestamp
  PROCEDURE purge_alerts(p_target_name          IN VARCHAR2,
                         p_target_type          IN VARCHAR2,
                         p_metric_name          IN VARCHAR2,
                         p_metric_column        IN VARCHAR2,
                         p_collection_timestamp IN DATE DEFAULT NULL,
                         p_key_values           IN mgmt_key_value_array 
                                                         DEFAULT NULL) ;
  --
  -- variation of above with this accepting key values directly
  -- if it is a 0 key metric, key_values is discarded
  -- if it is a 1 key metric, then key value should contain the list of 
  --                          key values to be purged
  -- if it is a multi-key metric, then key values should contain the list of 
  --                          composite key values to be purged
  --
  PROCEDURE purge_alerts(p_target_name          IN VARCHAR2,
                         p_target_type          IN VARCHAR2,
                         p_metric_name          IN VARCHAR2,
                         p_metric_column        IN VARCHAR2,
                         p_collection_timestamp IN DATE DEFAULT NULL,
                         p_key_values           IN mgmt_medium_string_table
                                                         DEFAULT NULL) ;
  --
  -- purging of violations on the same lines as alerts
  --
  PROCEDURE purge_violations
              (p_target_name          IN VARCHAR2,
               p_target_type          IN VARCHAR2,
               p_policy_name          IN VARCHAR2,
               p_collection_timestamp IN DATE DEFAULT NULL,
               p_key_values           IN mgmt_key_value_array DEFAULT NULL) ;

  PROCEDURE purge_violations(p_target_name          IN VARCHAR2,
                             p_target_type          IN VARCHAR2,
                             p_policy_name          IN VARCHAR2,
                             p_collection_timestamp IN DATE DEFAULT NULL,
                             p_key_values           IN mgmt_medium_string_table
                                                         DEFAULT NULL) ;

  --
  -- clear all open alerts for the given target/metric/key value combination
  -- key value same as for purge_alerts ( with mgmt_key_value_array)
  --
  PROCEDURE clear_open_alerts(p_target_name    IN VARCHAR2,
                              p_target_type    IN VARCHAR2,
                              p_metric_name    IN VARCHAR2,
                              p_metric_column  IN VARCHAR2,
                              p_key_values     IN mgmt_key_value_array 
                                                         DEFAULT NULL) ;
  --
  -- clear all open alerts for the given target/metric/key combination
  -- key_values same as for purge_alerts ( with mgmt_medium_string_table)
  --
  PROCEDURE clear_open_alerts(p_target_name    IN VARCHAR2,
                              p_target_type    IN VARCHAR2,
                              p_metric_name    IN VARCHAR2,
                              p_metric_column  IN VARCHAR2,
                              p_key_values     IN mgmt_medium_string_table) ;
  
END;
/

show errors
