Rem
Rem $Header: security_pkgdef.sql 25-jun-2007.04:57:46 pchebrol Exp $
Rem
Rem security_pkgdef.sql
Rem
Rem Copyright (c) 2002, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      security_pkgdef.sql - APIs to store/retreive security info
Rem
Rem    DESCRIPTION
Rem      APIs to store retreive EM Security info from tables defined
Rem      in security_tables.sql
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    pchebrol    06/22/07 - Backport shianand_core_5121288 from main
Rem    pchebrol    06/21/07 - 
Rem    shianand    07/23/05 - fix bug 3335221 
Rem    shianand    06/22/05 - fix bug 4242977 
Rem    neearora    06/10/05 - added procedure delete_agent_key  
Rem    izhang      01/16/03 - 
Rem    izhang      01/07/03 - api for multiple ipw management
Rem    izhang      11/13/02 - changing pki from varchar2 to BLOB
Rem    dmshah      10/18/02 - Deprecating set_agent_key(url)
Rem    izhang      10/11/02 - Adding api to take host,port
Rem    dmshah      10/03/02 - dmshah_security_repository_apis
Rem    dmshah      10/02/02 - Code review comments
Rem    dmshah      09/30/02 - 
Rem    dmshah      09/26/02 - Created
Rem

CREATE OR REPLACE PACKAGE EM_SEC
IS
-- Constants for setting the oms state 
OMS_STATE_UNSECURE      constant NUMBER(1) :=0;
OMS_STATE_SECURE        constant NUMBER(1) :=1;
OMS_STATE_SECURE_LOCK   constant NUMBER(1) :=2;

--Constants for request-id from the agent 
STATUS_UNINIT                 constant VARCHAR2(30) :='uninitialized';
STATUS_INIT                   constant VARCHAR2(30) :='init';
STATUS_INIT_COMPLETED         constant VARCHAR2(30) :='init_completed';
STATUS_AUTH                   constant VARCHAR2(30) :='auth';
STATUS_AUTH_COMPLETED         constant VARCHAR2(30) :='auth_completed';
STATUS_DOWNLOAD               constant VARCHAR2(30) :='download';
STATUS_DOWNLOAD_WALLET        constant VARCHAR2(30) :='wallet_downloaded';
STATUS_DOWNLOAD_LOCAL_CA      constant VARCHAR2(30) :='local_cert_downloaded';
STATUS_DOWNLOAD_INTERNTET_CA  constant VARCHAR2(30) :='internet_cert_downloaded';

--Constants for minimum secure agent protocol version supported by OMS
MIN_AGENT_SEC_VERSION   constant VARCHAR2(30) :='min_agent_sec_ver';

--Constants for slb secure port for Big IP configuration
SLB_SECURE_UPLOAD_PORT  constant VARCHAR2(30) :='slb_secure_upload_port';

--Constants for oms status for Big IP configuration
OMS_SECURE_STATUS       constant VARCHAR2(30) :='oms_secure_status';

--Constants for one time agent registration password
ONE_TIME_IPW            constant VARCHAR2(30) :='one-time';

--Constants for one time agent registration password
NORMAL_IPW              constant VARCHAR2(30) :='persistent';

--Constant for undefined port value in case of download request of older agents prior 11g
UNDEFINED_PORT          constant VARCHAR2(30) :='-1';

--Constant for undefined port value in case of download request of older agents prior 11g
MIN_COMPAT_AGENT_VER    constant VARCHAR2(30) := '10.1.0.2.0';

--Constants for delete one-time expired password from the repository;
IPW_ONE_TIME_EXP_SUCCESS         constant NUMBER(2) :=0;
IPW_VALID                        constant NUMBER(2) :=1;
IPW_EXPIRED                      constant NUMBER(2) :=2;
IPW_PERSISTENT                   constant NUMBER(2) :=3;
IPW_NOT_FOUND                    constant NUMBER(2) :=4;
IPW_ERROR                        constant NUMBER(2) :=5;
UPDATE_STATUS_SUCCESS            constant NUMBER(2) :=6;
UPDATE_STATUS_MANY_ROWS          constant NUMBER(2) :=7;
UPDATE_STATUS_ERROR              constant NUMBER(2) :=8;
PROCESS_INIT_FAILED              constant NUMBER(2) :=9;
PROCESS_AUTH_FAILED              constant NUMBER(2) :=10;

--Constansts of the Error messages
IPW_EXPIRED_MSG constant      VARCHAR2(256) :='agent registration password expired';
IPW_NOT_FOUND_MSG constant    VARCHAR2(256) :='invalid agent registration verifier';
VERIFY_IPW_ERR_MSG constant   VARCHAR2(256) :='error occured while verifying agent registration verifier';
INIT_NOT_DONE                 VARCHAR2(256) :='auth cannot be done before init';
INVALID_AUTH_STR              VARCHAR2(256) :='auth string doesnt match';
PROCESS_AUTH_FAILED_MSG       VARCHAR2(256) :='error occured during auth';
ONE_TIME_EXP_IPW_FAILED_MSG   VARCHAR2(256) :='updating one-time agent registration verifier to expired failed';
AUTH_NOT_DONE                 VARCHAR2(256) :='wallet cannot be downloaded before auth';
B64_LOC_NOT_DONE              VARCHAR2(256) :='b64 Internet Certificate cannot be downloaded before b64 Local Certificate';
WALLET_NOT_DONE               VARCHAR2(256) :='b64 Local Certificate cannot be downloaded before agent wallet';

-- Package level Type Definition 
   TYPE cursorType IS REF CURSOR;

--
-- PURPOSE
--
--   Set the Agent IPW
--
-- PARAMETERS
--
--   VERIFIER_IN - The initial Agent Installation Password that generates
--                 the actual agent key.
--
--
PROCEDURE SET_AGENT_IPW( verifier_in  IN VARCHAR2);

--
-- PURPOSE
--
--   Get the Agent IPW
--
-- PARAMETERS
--
--   VERIFIER_OUT - The initial Agent Installation Password that generates
--                  the actual agent key.
--
--
PROCEDURE GET_AGENT_IPW( verifier_out  OUT VARCHAR2);

--
-- PURPOSE
--
--   Set the Certificate Authority
--
-- PARAMETERS
--
--   PKI - The PKI material in the CA
--   CA_PWD - The PWD in the CA
--   CA     - The actual CA
--
PROCEDURE SET_CA( pki_in    IN RAW,
                  ca_pwd_in IN varchar2,
                  ca_in     IN RAW,
                  reset_in  IN NUMBER DEFAULT 0);

--
-- PURPOSE
--
--   Get the Certificate Authority
--
-- PARAMETERS
--
--   PKI - The PKI material in the CA
--   CA_PWD - The PWD in the CA
--   CA     - The actual CA
--
PROCEDURE GET_CA( pki_out    OUT RAW,
                  ca_pwd_out OUT varchar2,
                  ca_out     OUT RAW );

--
-- PURPOSE
--
--   Set Agent Key
--
-- PARAMETERS
--   HOST - host name of the agent
--   PORT - agent port
--   KEY  - agent key 
--
PROCEDURE SET_AGENT_KEY( host        IN varchar2,
                         port        IN varchar2,
                         key         IN varchar2); 

--
-- PURPOSE
--
--   Delete Agent Key corresponding to host and port .
--
-- PARAMETERS
--   HOST - host name of the agent
--   PORT - agent port
--
PROCEDURE DELETE_AGENT_KEY( host     IN varchar2,
                            port     IN varchar2);

--
-- PURPOSE
--
--   Get Agent Key
--
-- PARAMETERS
--
--   KEY    - The actual CA
--
PROCEDURE GET_AGENT_KEY( host         IN varchar2,
                         port         IN varchar2,
                         key_out     OUT varchar2 ); 

--
-- PURPOSE
--
--   Set An Agent IPW
--
--
--

PROCEDURE SET_IPW( pwd_idx_in   IN VARCHAR2,
                   pwd_in       IN VARCHAR2,
                   desc_str_in  IN VARCHAR2,
                   type_in      IN VARCHAR2,
                   expire_in    IN DATE);

--
-- PURPOSE
--
--   Get a specifed Agent IPW information 
--
-- PARAMETERS
--

PROCEDURE GET_IPW( pwd_idx_in    IN VARCHAR2,
                   pwd_out       OUT VARCHAR2,
                   desc_str_out  OUT VARCHAR2,
                   type_out      OUT VARCHAR2,
                   expire_out    OUT DATE);



--
-- PURPOSE
--
--   Get ALL Agent IPWs information in EM_IPW_INFO
--
-- PARAMETERS
--
--
PROCEDURE GET_IPW_INFO( pwd_info_out   OUT cursorType);


--
-- PURPOSE
--
-- Validates the given verifier with the verifier stored in the Repository   
--
-- Function returns the following:
-- 0 - If the verifier passed in the same as the one in the repository
-- 1 - If the verifier passed is not the same as the one in the repository
-- 2 - If no verifier is stored in the repository. 

FUNCTION VERIFY_IPW(verifier_in IN VARCHAR2) RETURN NUMBER; 

-- PURPOSE
-- 
-- This procedure updates the row with the b64 local certificate while securing oms.
-- 
-- 
PROCEDURE UPDATE_B64_LOCAL_CA(p_b64_local_ca_out OUT CLOB);


--
-- PURPOSE
-- 
-- This procedure updates the row with the b64 internet certificate while securing oms.
-- 
-- 
PROCEDURE UPDATE_B64_INTERNET_CA(p_b64_internet_ca_out OUT CLOB);


--
-- PURPOSE
-- 
-- This procedure updates the row with the agent-wallet generated during auth request.
-- 
-- 
PROCEDURE UPDATE_AGENT_EWALLET(p_agent_host_in IN VARCHAR2,
                            p_agent_port_in IN VARCHAR2,
                            p_request_status_in IN VARCHAR2,
                            p_agent_ewallet_out OUT BLOB);


--
-- PURPOSE
--
-- The procedure will set the agent random seed along with the agent-guid during
-- INIT request in the mgmt_agent_sec_info table.The procedure will also set the
-- oms random seed along with the agent-guid in the mgmt_agent_sec_info table.
-- 
-- 
PROCEDURE PROCESS_INIT(p_agent_host_in IN VARCHAR2,
                       p_agent_port_in IN VARCHAR2,
                       p_agent_seed_in IN VARCHAR2,
                       p_oms_seed_in IN VARCHAR2,
                       p_pwd_idx_in IN VARCHAR2,
                       p_agent_version_in IN VARCHAR2);


--
-- PURPOSE
-- 
-- This procedure carries out the auth, it checks the agent-seed and auth-str and pwd-idx then generates 
-- agent-key and stores it in the repository.
-- 
-- 
PROCEDURE PROCESS_AUTH(p_agent_host_in IN VARCHAR2,
                       p_agent_port_in IN VARCHAR2,
                       p_agent_seed_in IN VARCHAR2,
                       p_auth_str_in IN VARCHAR2,
                       p_pwd_idx_in IN VARCHAR2,
                       p_agent_version_in IN VARCHAR2,
                       p_agent_key_out OUT VARCHAR2);


--
-- PURPOSE
--
-- This procedure validates the pwd_idx and then open a outputstream of b64-Local-Certificate.
-- For older agents it also checks the agent_version to refine the search and avoid collisions.
-- Port undefined is the older agent case.
-- 
-- 
PROCEDURE GET_B64_LOCAL_CA(p_agent_host_in IN VARCHAR2,
                           p_agent_port_in IN VARCHAR2 DEFAULT UNDEFINED_PORT,
                           p_b64_local_ca_out OUT CLOB,
                           p_agent_version_in IN VARCHAR2,
                           p_pwd_idx_in IN VARCHAR2 DEFAULT NULL);


--
-- PURPOSE
--
-- This procedure validates the pwd_idx and then open a outputstream of b64-Internet-Certificate.
-- For older agents it also checks the agent_version to refine the search and avoid collisions.
-- Port undefined is the older agent case.
-- 
-- 
PROCEDURE GET_B64_INTERNET_CA(p_agent_host_in IN VARCHAR2,
                              p_agent_port_in IN VARCHAR2 DEFAULT UNDEFINED_PORT,
                              p_b64_internet_ca_out OUT CLOB,
                              p_agent_version_in IN VARCHAR2,
                              p_pwd_idx_in IN VARCHAR2 DEFAULT NULL);


--
-- PURPOSE
-- 
-- This procedure validates the pwd_idx and then open a outputstream of agent wallet corresponding 
-- agent-guid. For older agents it also checks the agent_version to refine the search and avoid collisions.
-- Port undefined is the older agent case
-- 
-- 
PROCEDURE GET_AGENT_EWALLET(p_agent_host_in IN VARCHAR2,
                            p_agent_port_in IN VARCHAR2 DEFAULT UNDEFINED_PORT,
                            p_agent_ewallet_out OUT BLOB,
                            p_agent_version_in IN VARCHAR2,
                            p_pwd_idx_in IN VARCHAR2 DEFAULT NULL);


--
-- PURPOSE
--
-- The procedure will get the secure slb port from mgmt_oms_parameters table.
-- 
-- 
-- 
PROCEDURE GET_SEC_SLB_PORT (p_oms_instance_in  IN VARCHAR2,
                            p_slb_sec_port_out OUT VARCHAR2);



END EM_SEC;
/

show errors;
