Rem drv: <create type="pkgdefs" pos="security/security_pkgdef.plb+"/>
Rem
Rem $Header: self_monitor_pkgdefs.sql 19-apr-2007.08:01:56 tsubrama Exp $
Rem
Rem self_monitor_pkgdefs.sql
Rem
Rem Copyright (c) 2002, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      self_monitor_pkgdefs.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      The sql procs used by the admin ui.  These are not part of the SDK.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    tsubrama    04/19/07 - Backport tsubrama_bug-4897258 from main
Rem    tsubrama    04/16/07 - fix for 4897258
Rem    jpyang      09/15/05 - add_metaver_catprop_callback
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    aholser     06/27/05 - performance
Rem    jsadras     06/02/05 - add task class to metric 
Rem    aholser     06/02/05 - NT
Rem    aholser     05/10/05 - agent frequency 
Rem    aholser     03/17/05 - remove date metrics 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    jsadras     01/07/05 - repoMetric
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    aholser     09/16/04 - adjust LOADER_INTERVAL per Nestor 
Rem    rpinnama    06/25/04 - Move types to self_monitor_types.sql 
Rem    aholser     05/12/04 - 10.2 metrics 
Rem    aholser     03/18/04 - change config interval to 1 hr 
Rem    aholser     03/16/04 - add no agents metric 
Rem    aholser     03/15/04 - return 'since' as timestamp for nlsing 
Rem    aholser     02/05/04 - add job_dispatcher_status metric 
Rem    lgloyd      11/04/03 - performance work 
Rem    aholser     10/10/03 - add emrep emd 
Rem    aholser     09/05/03 - add management loader status
Rem    aholser     08/21/03 - add callbacks for create/delete emrep target 
Rem    aholser     06/18/03 - add owner_name
Rem    aholser     06/03/03 - add ck for dbmsjob too old
Rem    aholser     05/30/03 - add deleted targets
Rem    aholser     05/23/03 - add dup target metric
Rem    aholser     04/21/03 - targets not uploading
Rem    aholser     03/28/03 - 4.1 changes
Rem    aholser     11/12/02 - use connectdescriptor
Rem    jpyang      10/22/02 - add get_node_list_with_priv 
Rem    rpinnama    09/18/02 - Remove authid current_user clause
Rem    aholser     09/20/02 - dup targets and metric errors count
Rem    jpyang      08/12/02 - add select host info
Rem    aholser     07/24/02 - add unresponsive targets
Rem    jpyang      07/15/02 - GET_AGENT_INFO update
Rem    aholser     07/10/02 - performance changes
Rem    aholser     06/25/02 - homepage changes
Rem    jpyang      06/12/02 - add single agent homepage
Rem    aholser     05/29/02 - system health.
Rem    aholser     05/20/02 - merge performance.
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Restructured.
Rem    aholser     04/26/02 - fix duplicate urls.
Rem    aholser     04/08/02 - notification changes.
Rem    aholser     03/31/02 - Switch to new tables
Rem    aholser     02/06/02 - fix divide by zero error.
Rem    aholser     02/02/02 - add loader back in.
Rem    skini       01/02/02 - Remove reference to MGM_ADMIN_REP
Rem    aholser     12/06/01 - more perf data.
Rem    aholser     11/09/01 - add chart details.
Rem    aholser     11/02/01 - add more rollup, loader data and charts.
Rem    rpinnama    10/15/01 - Rollback TIMESTAMP WITH TIMEZONE changes
Rem    aholser     10/11/01 - remove extraneous data
Rem    aholser     10/15/01 - get db and emd start times
Rem    aholser     10/04/01 - info page changes
Rem    aholser     09/28/01 - page layout changes
Rem    aholser     08/09/01 - review changes
Rem    aholser     07/17/01 - Created
Rem


CREATE OR REPLACE PACKAGE mgmt_admin_data
AS

NO_TARGET_GUID constant raw(16) := '0000000000000000';
OWNER_NAME VARCHAR2(30) := NULL;
MGMT_VIEW_NAME VARCHAR2(30) := 'MGMT_VIEW';
MGMT_LOG_NAME                 constant VARCHAR2(512) := 'MGMT_SYS_JOB';
MGMT_LOG_NAME_DESC            constant VARCHAR2(512) := 'Management System Metrics';

-- ANY CHANGES MUST BE DUPLICATED IN source/oracle/sysman/eml/rsc/gen/oracle_emrepExtMsg* files
-- The array of metric names
-- The Response metric is not being registered for the time being because of a problem with it
-- being registered as both an agent and repository metric.
METRIC_NAMES                  constant SMP_EMD_STRING_ARRAY := 
                                SMP_EMD_STRING_ARRAY(
                                  'Response',
                                  'Management_Servlet_Status',
                                  'DBMS_Job_Status',
                                  'Notification_Performance',
                                  'Job_Dispatcher_Performance',
                                  'Configuration',
                                  'Repository_sessions',
                                  'Duplicate_targets',
                                  'Management_Loader_Status',
                                  'Repository_Job_Dispatcher',
                                  'No_Agents',
                                  'Agent_Status',
                                  'Notification_Method_Performance'
                                  );

-- The array of metric labels
METRIC_LABELS                 constant SMP_EMD_STRING_ARRAY := 
                                SMP_EMD_STRING_ARRAY(
                                  'Response',
                                  'Active Management Servlets',
                                  'DBMS Job Status',
                                  'Notification Performance',
                                  'Job Dispatcher Performance',
                                  'Configuration',
                                  'Repository Sessions',
                                  'Duplicate Targets',
                                  'Active Loaders',
                                  'Repository Job Dispatcher',
                                  'Active Agents',
                                  'Agent Status',
                                  'Notification Method Performance');

-- The number of metrics
METRIC_COUNT                     constant NUMBER(2)    := METRIC_NAMES.COUNT;

-- The index in the arrays for the metrics
RESPONSE_INDEX                   constant NUMBER(2) := 1;
SERVLET_INDEX                    constant NUMBER(2) := 2;
DBMS_INDEX                       constant NUMBER(2) := 3;
NOTIFICATION_INDEX               constant NUMBER(2) := 4;
JOB_DISPATCHER_INDEX             constant NUMBER(2) := 5;
CONFIGURATION_INDEX              constant NUMBER(2) := 6;
SESSIONS_INDEX                   constant NUMBER(2) := 7;
DUP_TARGETS_INDEX                constant NUMBER(2) := 8;
LOADER_STATUS_INDEX              constant NUMBER(2) := 9;
REP_JOB_DISPATCHER_INDEX         constant NUMBER(2) := 10;
NO_AGENTS_INDEX                  constant NUMBER(2) := 11;
AGENT_STATUS_INDEX               constant NUMBER(2) := 12;
NOTIF_METHODS_INDEX              constant NUMBER(2) := 13;

-- The array of metric column name arrays
METRIC_COLUMN_NAMES           constant SMP_EMD_STRING_ARRAY_ARRAY := 
                                SMP_EMD_STRING_ARRAY_ARRAY(
                                  SMP_EMD_STRING_ARRAY(
                                    'Status',
                                    'Message'
                                  ),
                                  SMP_EMD_STRING_ARRAY(
                                    'servicename',
                                    'status',
                                    'load_backlog',
                                    'load_directory',
                                    'load_oldestfile',
                                    'notification_count'
                                  ),
                                  SMP_EMD_STRING_ARRAY(
                                    'jobName',
                                    'jobUpDown',
                                    'jobInvalidTime',
                                    'jobprocessing',
                                    'jobthroughput'
                                  ),
                                  SMP_EMD_STRING_ARRAY(
                                    'notificationUpDown',
                                    'notificationprocessing',
                                    'notificationthroughput',
                                    'waiting',
                                    'delivery_avg'
                                  ),
                                  SMP_EMD_STRING_ARRAY(
                                    'joburl',
                                    'processing',
                                    'throughput'
                                  ),
                                  SMP_EMD_STRING_ARRAY(
                                     'targetCount',
                                     'userCount',
                                     'roleCount',
                                     'groupCount',
                                     'totalRepSpace',
                                     'usedRepSpace',
                                     'targetAdditionRate',
                                     'userAdditionRate'
                                  ),
                                  SMP_EMD_STRING_ARRAY(
                                     'omsName',
                                     'sessionCount'
                                  ),
                                  SMP_EMD_STRING_ARRAY(
                                     'target_Count'
                                  ),
                                  SMP_EMD_STRING_ARRAY(
                                     'loadername',
                                     'loader_processing_hour',
                                     'load_run',
                                     'load_processing'
                                  ),
                                  SMP_EMD_STRING_ARRAY(
                                     'repository_job_backlog'
                                  ),
                                  SMP_EMD_STRING_ARRAY(
                                     'agent_Count'
                                  ),
                                  SMP_EMD_STRING_ARRAY(
                                     'agent_name',
                                     'restart_count'
                                  ),
                                  SMP_EMD_STRING_ARRAY(
                                     'method_type',
                                     'notifications_queued',
                                     'total_delivery_time'
                                  )
                                );

-- The array of metric column label arrays
METRIC_COLUMN_LABELS          constant SMP_EMD_STRING_ARRAY_ARRAY := 
                                SMP_EMD_STRING_ARRAY_ARRAY(
                                  SMP_EMD_STRING_ARRAY(
                                    'Status',
                                    'Message'
                                  ),
                                  SMP_EMD_STRING_ARRAY(
                                    'Management Service Name',
                                    'Management Service Status',
                                    'Files Pending Load',
                                    'Loader Directory',
                                    'Oldest Loader File',
                                    'Notifications Processed'
                                  ),
                                  SMP_EMD_STRING_ARRAY(
                                    'DBMS Job Name',
                                    'DBMS Job UpDown',
                                    'DBMS Job Invalid Schedule',
                                    'DBMS Job Processing Time (% of Last Hour)',
                                    'Throughput Per Second'
                                  ),
                                  SMP_EMD_STRING_ARRAY(
                                    'Notification UpDown',
                                    'Notification Processing Time (% of Last Hour)',
                                    'Throughput Per Second',
                                    'Notifications Waiting',
                                    'Notification Delivery Time'
                                  ),
                                  SMP_EMD_STRING_ARRAY(
                                    'Job Dispatcher Management Service',
                                    'Job Dispatcher Processing Time, (% of Last Hour)',
                                    'Steps Per Second'
                                  ),
                                  SMP_EMD_STRING_ARRAY(
                                    'Number of Targets',
                                    'Number of Administrators',
                                    'Number of Roles',
                                    'Number of Groups',
                                    'Total Repository Tablespace',
                                    'Repository Tablespace Used',
                                    'Target Addition Rate',
                                    'User Addition Rate'
                                  ),
                                  SMP_EMD_STRING_ARRAY(
                                     'Management Service Name',
                                     'Session Count'
                                  ),
                                  SMP_EMD_STRING_ARRAY(
                                    'Number of Duplicate Targets'
                                  ),
                                  SMP_EMD_STRING_ARRAY(
                                    'Loader Name',
                                    'Loader Throughput (rows per hour)',
                                    'Total Loader Runtime in the Last Hour (seconds)',
                                    'Loader Throughput (rows per second)'
                                  ),
                                  SMP_EMD_STRING_ARRAY(
                                    'Job Dispatcher Job Step Average Backlog'
                                  ),
                                  SMP_EMD_STRING_ARRAY(
                                    'Number of Active Agents'
                                  ),
                                  SMP_EMD_STRING_ARRAY(
                                    'Agent Name',
                                    'Restarts (past 24 hrs)'
                                  ),
                                  SMP_EMD_STRING_ARRAY(
                                    'Method Type',
                                    'Notifications Waiting',
                                    'Average Delivery Time (ms)'
                                  )
                                );

-- repo collection metric constants

REPO_PERFORMANCE_METRIC VARCHAR2(30) := 'Repo_Collection_Performance' ;
REPO_PERFORMANCE_METRIC_LABEL VARCHAR2(40) := 
                                  'Repository Collection Performance' ;
REPO_PERFORMANCE_COLUMNS CONSTANT MGMT_SHORT_STRING_ARRAY := 
                 MGMT_SHORT_STRING_ARRAY('task_class',
                                         'throughput',
                                         'worker_count',
                                         'pending_count',
                                         'processed_count',
                                         'duration'
                                         ) ;

REPO_PERFORMANCE_COLUMN_LABELS CONSTANT MGMT_SHORT_STRING_ARRAY := 
        MGMT_SHORT_STRING_ARRAY('Task class',
                                'Total throughput across workers',
                                'Number of Workers',
                                'Collections Waiting To Run',
                                'Collections Processed',
                                'Collection Duration (seconds)'
                                ) ;

REPO_PERFORMANCE_COLUMN_NLSIDS CONSTANT MGMT_SHORT_STRING_ARRAY := 
        MGMT_SHORT_STRING_ARRAY('repo_taskclass',
                                'repo_throughput',
                                'repo_workers',
                                'repo_waiting',
                                'repo_processing',
                                'repo_duration'
                                ) ;

-- agent repo collection metric constants
                                                                                                                   
AGENT_REPO_METRIC VARCHAR2(30) := 'Targets_not_uploading' ;
AGENT_REPO_METRIC_LABEL VARCHAR2(40) :=
                                  'Targets not uploading' ;
AGENT_REPO_METRIC_COLS CONSTANT MGMT_SHORT_STRING_ARRAY :=
        MGMT_SHORT_STRING_ARRAY('count'
                                );

AGENT_REPO_METRIC_COL_LABELS CONSTANT MGMT_SHORT_STRING_ARRAY :=
        MGMT_SHORT_STRING_ARRAY('Count of targets not uploading'
                                );

AGENT_REPO_METRIC_COL_NLSIDS CONSTANT MGMT_SHORT_STRING_ARRAY :=
        MGMT_SHORT_STRING_ARRAY('count'
                                );

AGENT_REPO_PROPERTY_NAME          VARCHAR2(10)   := 'window';
AGENT_REPO_WINDOW_DEF_VALUE       NUMBER         := 120;

-- The default sampling interval is 10 min, status is 5, configuration, loader are 1 hour
--REPO_INTERVAL is the interval for collection of repo collection performance metric.
--
RESPONSE_INTERVAL             constant NUMBER    := 5;
DEFAULT_INTERVAL              constant NUMBER    := 10;
LOADER_INTERVAL               constant NUMBER    := 10;
CONFIG_INTERVAL               constant NUMBER    := 60;
AGENT_INTERVAL                constant NUMBER    := 240;
REPO_COLLECT_INTERVAL         CONSTANT NUMBER    := 10 ;

TYPE CURSORTYPE IS REF CURSOR;
TYPE AGENTINFO_CURSOR IS REF CURSOR;
TYPE NODELIST_CURSOR IS REF CURSOR;

TARGET_ROLE_PREDICATE CONSTANT VARCHAR2(30) := 'MGMT_';
ROLE_ALL_TARGETS CONSTANT VARCHAR2(30) := 'MGMT_ACCESS_ANY_TARGET';


--
-- Procedure GET_HOME_DATA
--
-- PURPOSE: To retrieve the data for the MainData page
-- IN parameters:
--   rep_connectdescriptor_in: VARCHAR2 The connectdescriptor from the configuration file, used
-- OUT parameters: 
--   agemts_up_out: NUMBER The count of agents that are up
--   agemts_down_out: NUMBER The count of agents that are down
--   rep_string_array_out: SMP_EMD_STRING_ARRAY The targetnames for the repository if it is
--     currently being monitored, else a null string
--   host_string_array_out: SMP_EMD_STRING_ARRAY The targetnames for the repository host if it 
--     is being monitored. 
--   emd_string_array_out: SMP_EMD_STRING_ARRAY The agents monitoring the repository
--   tablespace_string_array_out: SMP_EMD_STRING_ARRAY The repository tablespace name
--   emrep_string_out: VARCHAR2 The repository
--   emrep_emd_string_out: VARCHAR2 The emrep agent
--   emrep_emd_disp_string_out: VARCHAR2 The emrep agent
--   avail_pct_out: NUMBER the percent of time the emrep target was up last 24 hrs
--   dup_target_count_out: NUMBER The count of duplicate targets
--   metric_error_ct_out: NUMBER The count of metric errors for our targets
--   rel_metric_error_ct_out: NUMBER The count of metric errors for our targets
--   session_count_out: NUMBER The count of active oms repository sessions
--   deleted_target_count_out: NUMBER The count of targets being deleted
--   target_count_out: NUMBER The count of targets
--   user_count_out: NUMBER The count of users
--   job_backlog_sev_out NUMBER the job backlog severity
--   related_alerts_out: NUMBER The count of related alerts
--   job_backlog_out NUMBER the number of job steps backlog
--   used_rep_space_out: NUMBER The space used by the repository in MB
--   total_rep_space_out: NUMBER The total space allocated to the repository in MB
--   oms_status_out: CURSOR The host_url, timestamp and status (UP/DOWN) for 
--     contacted oms's
--   alert_data_out: CURSOR The alerts for the system components - rep db, host and
--     emrep targets
-- ERROR CODES:
--   


PROCEDURE get_home_data
  (rep_connectdescriptor_in IN VARCHAR2,
  agents_up_out OUT NUMBER,
  agents_down_out OUT NUMBER,
  rep_string_array_out OUT SMP_EMD_STRING_ARRAY,
  host_string_array_out OUT SMP_EMD_STRING_ARRAY,
  emd_string_array_out OUT SMP_EMD_STRING_ARRAY,
  tablespace_string_array_out OUT SMP_EMD_STRING_ARRAY,
  emrep_string_out OUT VARCHAR2,
  emrep_emd_string_out OUT VARCHAR2,
  emrep_emd_disp_string_out OUT VARCHAR2,
  avail_pct_out OUT NUMBER,
  dup_target_count_out OUT NUMBER,
  metric_error_ct_out OUT NUMBER,
  rel_metric_error_ct_out OUT NUMBER,
  session_count_out OUT NUMBER,
  deleted_target_count_out OUT NUMBER,
  target_count_out OUT NUMBER,
  user_count_out OUT NUMBER,
  job_backlog_sev_out OUT NUMBER,
  related_alerts_out OUT NUMBER,
  job_backlog_out OUT NUMBER,
  used_rep_space_out OUT NUMBER,
  total_rep_space_out OUT NUMBER,
  oms_status_out OUT CURSORTYPE,
  alert_data_out OUT CURSORTYPE);

--
-- Procedure GET_RELATED_ALERTS
--
-- PURPOSE: To retrieve the alerts for targets related to the emrep target
-- IN parameters:
--   none
-- OUT parameters: 
--   alert_data_out: CURSOR The alerts for the related system components - rep db, host
--

PROCEDURE get_related_alerts
  (alert_data_out OUT CURSORTYPE);


-- Procedure GET_OMS_DATA
--
-- PURPOSE: To retrieve the data for the individual oms page
-- IN parameters:
--   oms_name_in: VARCHAR2 The name of the oms
-- OUT parameters:
--   host_name_out: VARCHAR2 The target_name of the host the oms is on
--   oc4j_name_out: VARCHAR2 The name of the ooc4j instance the oms is running under
--   ias_name_out: VARCHAR2 The name of the IAS instance the oms is running under
--   filesystem_out: VARCHAR2 The name of the filesystem the loader directory is in
--   upload_port_out: VARCHAR2 The name of the upload port
--   secure_upload_port_out: VARCHAR2 The name of the upload port
--   oc4j_composite_key_out: RAW The composite key for the oc4j page hits metric
--   cpu_pct_out: NUMBER the percent of time the process containing the oms is running
--   cpu_pctwarn_out: NUMBER the warning threshold percent of time the process containing the oms is running
--   cpu_pctcrit_out: NUMBER the critical threshold percent of time the process containing the oms is running
--   mem_mb_out: NUMBER the number of mb occupied by the process containing the oms
--   mem_mbwarn_out: NUMBER the warning threshold number of mb occupied by the process containing the oms
--   mem_mbcrit_out: NUMBER the critical threshold number of mb occupied by the process containing the oms
--   jvm_mem_out: NUMBER the number of MB occupied by the jvm the oms is using
--   jvm_memwarn_out: NUMBER the warning threshold number of MB occupied by the jvm the oms is using
--   jvm_memcrit_out: NUMBER the critical threshold number of MB occupied by the jvm the oms is using
--   fsspace_out: NUMBER the percent of the filesystem that is used
--   fsspacewarn_out: NUMBER the warning threshold percent of the filesystem that is used
--   fsspacecrit_out: NUMBER the critical threshold percent of the filesystem that is used
--   since_out: DATE the timestamp in date format for the oms - down since or up since
-- ERROR CODES:
--

PROCEDURE get_oms_data
  (oms_name_in IN VARCHAR2,
  host_name_out OUT VARCHAR2,
  oc4j_name_out OUT VARCHAR2,
  ias_name_out OUT VARCHAR2,
  filesystem_out OUT VARCHAR2,
  upload_port_out OUT VARCHAR2,
  secure_upload_port_out OUT VARCHAR2,
  oc4j_composite_key_out OUT RAW,
  cpu_pct_out OUT NUMBER,
  cpu_pctwarn_out OUT NUMBER,
  cpu_pctcrit_out OUT NUMBER,
  mem_mb_out OUT NUMBER,
  mem_mbwarn_out OUT NUMBER,
  mem_mbcrit_out OUT NUMBER,
  jvm_mem_out OUT NUMBER,
  jvm_memwarn_out OUT NUMBER,
  jvm_memcrit_out OUT NUMBER,
  fsspace_out OUT NUMBER,
  fsspacewarn_out OUT NUMBER,
  fsspacecrit_out OUT NUMBER,
  since_out OUT DATE);

--
-- Function getOmsUrls
--
-- PURPOSE: To get a comma-separated list of connected omsurls
-- IN parameters:
--   No IN parameters
-- RETURNS:
--   The list of connected host urls or an empty string if none are 
--

FUNCTION GETOMSURLS return VARCHAR2;

--
-- Function get_agent_info
--
-- PURPOSE: To get general information for single agent homepage 
-- IN parameters:
--   p_privilege The privilege to check for
--   p_emdurl emd url for the agent 
-- RETURNS:
--   The version, oracle home and host information
--

FUNCTION GET_AGENT_INFO(p_target_name IN VARCHAR2) return AGENTINFO_CURSOR;

--
-- Function get_node_list_with_privilege
--
-- PURPOSE: To retrieve a list of emds  
-- RETURNS:
--   The list of emds
--

FUNCTION GET_NODE_LIST_WITH_PRIVILEGE RETURN NODELIST_CURSOR;

--
-- PURPOSE
--  To get the list of targets associated with the repository target
--
FUNCTION GET_RELATED_TARGETS
(
  oms_hosts_in IN NUMBER DEFAULT 0
)
RETURN MGMT_USER_GUID_ARRAY;

-- Procedure EVALUATE_MGMT_METRICS
--
-- PURPOSE: To evaluate the management system metrics and make appropriate entries
-- IN parameters:
--   target_guid_in IN The target guid for the metric
--   metric_guid_in IN The metric guid for the specific metric
-- OUT parameters: 
--   metric_result_out OUT The result of the metric evaluation

PROCEDURE EVALUATE_MGMT_METRICS
(
  target_guid_in         IN RAW,
  metric_guid_in         IN RAW,
  metric_result_out      OUT MGMT_METRIC_RESULTS
);

-- These are the individual metric evaluation functions
-- They correspond to the metric names specified earlier
FUNCTION GET_METRIC_RESPONSE RETURN MGMT_METRIC_RESULTS;

FUNCTION GET_METRIC_SERVLET RETURN MGMT_METRIC_RESULTS;

FUNCTION GET_METRIC_DBMS RETURN MGMT_METRIC_RESULTS;

FUNCTION GET_METRIC_NOTIFICATION RETURN MGMT_METRIC_RESULTS;

FUNCTION GET_METRIC_JOB_DISPATCHER RETURN MGMT_METRIC_RESULTS;

FUNCTION GET_METRIC_CONFIGURATION RETURN MGMT_METRIC_RESULTS;

FUNCTION GET_METRIC_SESSIONS RETURN MGMT_METRIC_RESULTS;

FUNCTION GET_METRIC_DUP_TARGETS RETURN MGMT_METRIC_RESULTS;

FUNCTION GET_METRIC_LOADER_STATUS RETURN MGMT_METRIC_RESULTS;

FUNCTION GET_METRIC_REP_DISPATCHER RETURN MGMT_METRIC_RESULTS;

FUNCTION GET_METRIC_NO_AGENTS RETURN MGMT_METRIC_RESULTS;

FUNCTION GET_METRIC_AGENT_STATUS RETURN MGMT_METRIC_RESULTS;

FUNCTION GET_METRIC_NOTIF_METHODS RETURN MGMT_METRIC_RESULTS;

PROCEDURE eval_repo_performance(p_target_guid IN RAW,
                               p_metric_guid IN RAW,
                               p_coll_name   IN VARCHAR2,
                               p_metric_values OUT mgmt_metric_value_array);

PROCEDURE EVAL_AGENT_METRICS(target_guid_in IN mgmt_target_guid_array,
                             metric_guid_in IN RAW,
                             coll_name_in   IN VARCHAR2,
                             metric_values_out OUT mgmt_metric_value_array);

-- Procedure HANDLE_EMREP_METAVER_UPDATE
--
-- PURPOSE: Add target meta ver update call back to add oracle_emrep for the new type meta ver.  
-- IN parameters:
--   target_name_in IN The target name
--   target_type_in IN The target type
--   target_guid_in IN The target guid
-- OUT Parameters:

PROCEDURE HANDLE_EMREP_METAVER_UPDATE
 (p_callback_obj IN MGMT_TARGET_META_VER_CBK_OBJ);

-- Procedure ADD_EMREP_COLLECTIONS 
--
-- PURPOSE: register and start emrep target collection
-- IN parameters:
--   target_name_in IN The target name
--   target_type_in IN The target type
--   target_guid_in IN The target guid
-- OUT Parameters:
PROCEDURE ADD_EMREP_COLLECTIONS
          (target_name_in IN VARCHAR2,
           target_type_in IN VARCHAR2,
           target_guid_in IN RAW);

-- Procedure ADD_EMREP_CALLBACK
--
-- PURPOSE: The proc called when the emrep target is created. Starts metric collections 
-- IN parameters:
--   target_name_in IN The target name
--   target_type_in IN The target type
--   target_guid_in IN The target guid 
-- OUT parameters:

PROCEDURE ADD_EMREP_CALLBACK
(
  target_name_in IN VARCHAR2,
  target_type_in IN VARCHAR2,
  target_guid_in IN RAW
);

-- Procedure ADD_AGENT_CALLBACK
--
-- PURPOSE: The proc called when an agent is added. 
-- IN parameters:
--   target_name_in IN The target name
--   target_type_in IN The target type
--   target_guid_in IN The target guid
-- OUT parameters:
                                                                                                              
PROCEDURE ADD_AGENT_CALLBACK
(
  target_name_in IN VARCHAR2,
  target_type_in IN VARCHAR2,
  target_guid_in IN RAW
);

FUNCTION GET_REPOS_DBMS_JOBS RETURN CURSORTYPE;

END mgmt_admin_data;
/

SHOW ERRORS;



