Rem drv: <create type="post_creation" pos="metric/metric_init.sql+"/>
Rem
Rem $Header: self_monitor_post_creation.sql 15-sep-2005.12:23:52 jpyang Exp $
Rem
Rem self_monitor_post_creation.sql
Rem
Rem Copyright (c) 2003, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      self_monitor_post_creation.sql 
Rem
Rem    DESCRIPTION
Rem      This module creates the emrep target and it's default set of internal metrics
Rem
Rem    NOTES
Rem      Some metrics are gathered by the agent and not defined in this package
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jpyang      09/15/05 - register type_meta_ver updated callback 
Rem    neearora    09/08/05 - execution order changed 
Rem    jpyang      09/07/05 - fix 4587232 
Rem    aholser     08/17/05 - 
Rem    gsbhatia    07/03/05 - New repmgr header impl 
Rem    aholser     05/11/05 - use init file 
Rem    aholser     06/03/05 - grabtrans 'aholser_bug-4351634' 
Rem    aholser     05/18/05 - 
Rem    aholser     03/17/05 - remove date metrics 
Rem    aholser     02/19/05 - replace deprecated apis 
Rem    jsadras     01/05/05 - repoCollection Metric 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    shuberma    09/15/04 - Adding policy monitorying metrics. 
Rem    gan         07/02/04 - use add_target api 
Rem    aholser     05/12/04 - 10.2 metrics 
Rem    aholser     03/16/04 - add no agents metric 
Rem    aholser     02/09/04 - remove date metrics 
Rem    aholser     02/05/04 - add job displatcher status 
Rem    aholser     01/21/04 - 3272789 
Rem    aholser     10/21/03 - fix metrics 
Rem    aholser     09/05/03 - 
Rem    aholser     08/25/03 - 
Rem    aholser     08/25/03 - add nlsids 
Rem    aholser     08/21/03 - add callbacks for create/delete emrep target 
Rem    rpinnama    07/03/03 - 
Rem    rpinnama    07/03/03 - Use generated guid
Rem    aholser     06/03/03 - add ck for dbmsjob too old
Rem    aholser     05/23/03 - add dup target metric
Rem    aholser     04/15/03 - aholser_aa
Rem    aholser     03/27/03 - Created
Rem

BEGIN
 
 DECLARE l_target_name VARCHAR2(32);
         l_target_type VARCHAR2(32);
         l_host_name   gv$instance.host_name%TYPE;
         l_metric_name SMP_EMD_STRING_ARRAY;
         l_target_guid MGMT_TARGETS.target_guid%TYPE;

  BEGIN

    BEGIN
      mgmt_admin.add_target_addition_callback('mgmt_admin_data.add_emrep_callback', MGMT_GLOBAL.G_REPOSITORY_TARGET_TYPE);
    EXCEPTION
      WHEN OTHERS 
      THEN 
         dbms_output.put_line( 'EXCEPTION registering add_emrep callback '|| SQLCODE );
         RAISE;
    END;

    BEGIN
      mgmt_admin.add_target_addition_callback('mgmt_admin_data.add_agent_callback', MGMT_GLOBAL.G_AGENT_TARGET_TYPE);
    EXCEPTION
      WHEN OTHERS
      THEN
         dbms_output.put_line( 'EXCEPTION registering add_agent callback '|| SQLCODE );
         RAISE;
    END;

    BEGIN
      SELECT host_name,instance_name into l_host_name,l_target_name
        FROM v$instance WHERE rownum = 1;
      INSERT INTO mgmt_parameters 
        VALUES('management_system_name',
             mgmt_global.G_MANAGEMENT_SYSTEM||':'||l_host_name||':'||l_target_name,
             'The global name for the Management System',0); 
    EXCEPTION
      WHEN OTHERS 
      THEN 
         dbms_output.put_line( 'EXCEPTION inserting management system name '|| SQLCODE );
    END;

    BEGIN
      mgmt_log.register_logging_module(mgmt_admin_data.MGMT_LOG_NAME,mgmt_admin_data.MGMT_LOG_NAME_DESC);
    EXCEPTION
      WHEN OTHERS 
      THEN 
         dbms_output.put_line( 'EXCEPTION registering logging name '|| SQLCODE );
    END;
    BEGIN
      MGMT_TARGET.add_metaver_catprop_callback(
        p_callback_name => 'MGMT_ADMIN_DATA.HANDLE_EMREP_METAVER_UPDATE',
        p_target_type   => MGMT_GLOBAL.G_REPOSITORY_TARGET_TYPE);
    EXCEPTION
      WHEN OTHERS THEN
        -- Ignore duplicate registrations
        dbms_output.put_line( 'EXCEPTION registering meta ver update callback '|| SQLCODE );
        NULL;
    END;

  EXCEPTION
    WHEN OTHERS
    THEN
      dbms_output.put_line( 'EXCEPTION for create target '|| SQLCODE );
      RAISE;
  END;
  COMMIT;
END;
/

show errors;

@&EM_SQL_ROOT/core/v102010/self_monitor/self_monitor_init.sql
show errors;

/

show errors;
    --
    -- Create the emrep target
    --
BEGIN
                                                                                                                  
  DECLARE
  l_host_name gv$instance.host_name%TYPE;
  l_properties MGMT_TARGET_PROPERTY_LIST;
  l_groups SMP_EMD_NVPAIR_ARRAY;
  l_tz_rgn MGMT_TARGETS.timezone_region%TYPE := TO_CHAR(SYSTIMESTAMP,'TZR');

  BEGIN
    SELECT host_name into l_host_name FROM gv$instance WHERE ROWNUM=1;
    l_properties := MGMT_TARGET_PROPERTY_LIST();
    l_groups := SMP_EMD_NVPAIR_ARRAY();

    MGMT_TARGET.add_target(MGMT_GLOBAL.G_MANAGEMENT_SYSTEM,
                          MGMT_GLOBAL.G_REPOSITORY_TARGET_TYPE,
                          l_host_name, NULL, NULL, NULL,
                          NULL, MGMT_GLOBAL.G_MANAGEMENT_SYSTEM,
                          NULL, l_tz_rgn, MGMT_GLOBAL.G_MON_MODE_DEFAULT,
                          MGMT_GLOBAL.G_MGMT_SYS_TYPE_META_VER, ' ', ' ', ' ', ' ', ' ', 1);

  EXCEPTION
    WHEN OTHERS
    THEN
      dbms_output.put_line( 'EXCEPTION for create emrep target '|| SQLCODE );
      RAISE;
  END;
  COMMIT;
END;
/

show errors;



