Rem drv: <create type="pkgbodys" pos="storage/storage_pkgbodys.sql+"/>
Rem
Rem $Header: service_pkgbody.sql 09-aug-2006.05:57:32 nsalam Exp $
Rem
Rem service_pkgbody.sql
Rem
Rem Copyright (c) 2004, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      service_pkgbody.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    nsalam      08/09/06 - bug fix for RFI bug 5362184 especially for taking
Rem                           care of formsapp condition
Rem    skkunise    07/14/06 - Adding has_business property 
Rem    nsalam      07/10/06 - Backport saramasa_bug-4333138 from main 
Rem    gan         12/08/05 - Backport gan_bug-4624546 from main 
Rem    saramasa    11/30/05 - Fix for bug# 4333138 
Rem    mfidanbo    09/15/05 - add keys_from_mult_colls boolean to transpose 
Rem                           metrics and test_repsonse 
Rem    mfidanbo    09/02/05 - 
Rem    rmarripa    08/26/05 - add NLS IDs for Performance, Usage and Response 
Rem                           metrics 
Rem    mfidanbo    09/01/05 - add nlsids for test_response 
Rem    mfidanbo    08/19/05 - add metric creation to service initialization 
Rem    afontana    07/21/05 - add_target_type_property after add target type
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    afontana    06/24/05 - initialize_service registers provided 
Rem                           type_meta_ver 
Rem    gan         03/22/05 - check loop containment 
Rem    gan         03/22/05 - Add type display name 
Rem    gan         02/04/05 - agg svc type property 
Rem    gan         01/17/05 - respect manually configured system 
Rem    andyao      12/21/04 - remove baseline property 
Rem    gan         12/06/04 - assoc prop 
Rem    gan         12/01/04 - handle system is already set 
Rem    andyao      11/24/04 - add baselineable property 
Rem    streddy     11/09/04 - Fix metric type 
Rem    streddy     10/07/04 - Use new metric_coll APIs 
Rem    streddy     10/04/04 - Add a flag for aggregate 
Rem    streddy     10/04/04 - Move service creation code 
Rem    streddy     08/16/04 - streddy_agr_svc_apis
Rem    gan         08/13/04 - use global assoc guid  
Rem    gan         08/11/04 - Created
Rem

CREATE OR REPLACE PACKAGE BODY EM_SERVICE AS

PROCEDURE depends_change_callback(p_source_target_name IN VARCHAR2,
                                  p_source_target_type IN VARCHAR2,
                                  p_assoc_target_name IN VARCHAR2,
                                  p_assoc_target_type IN VARCHAR2)
AS
BEGIN
   IF EMDW_LOG.P_IS_INFO_SET 
   THEN
      EMDW_LOG.INFO('dependes_change_callback: Enter'
                   || p_source_target_name || '/'
                   || p_source_target_type || '/'
                   || p_assoc_target_name || '/'
                   || p_assoc_target_type , G_MODULE_NAME) ; 
   END IF ;
  
   IF  mgmt_service.is_aggregate_service(p_source_target_type) = 0 THEN
       IF EMDW_LOG.P_IS_INFO_SET 
       THEN
          EMDW_LOG.INFO('dependes_change_callback: Exit'
                       || p_source_target_type || ' is not aggregate_service' 
                       || ' exit '
                       , G_MODULE_NAME) ; 
       END IF;
       RETURN;
   END IF;

   INFER_SYSTEM(p_source_target_name, p_source_target_type);

   IF EMDW_LOG.P_IS_INFO_SET 
   THEN
      EMDW_LOG.INFO('dependes_change_callback: Exit'
                    , G_MODULE_NAME) ; 
   END IF ;

END depends_change_callback;

--
-- PRUPOSE: handle assoc change callback, when RUNs-ON assoc changes, re-infer
-- runs-on system for aggregate service. This procedure has to be reentrant.
PROCEDURE system_change_callback(p_assoc_def_name IN VARCHAR2,
                                 p_target_name IN VARCHAR2,
                                 p_target_type IN VARCHAR2)
AS
-- Cursor to get direct ancestor aggregate service for a target,  
CURSOR ancestor_services_cur (p_target_name IN VARCHAR2, 
                              p_target_type IN VARCHAR2) 
IS
   SELECT t.target_name, t.target_type
   FROM mgmt_target_assocs a,  mgmt_targets t, mgmt_type_properties p
   WHERE t.target_guid = a.source_target_guid
     AND a.assoc_guid = mgmt_assoc.g_depends_on_guid
     AND p.target_type = t.target_type
     AND p.property_name = MGMT_GLOBAL.G_IS_AGGREGATE_SERVICE_PROP
     AND p.property_value = '1'
     AND a.assoc_target_guid = (SELECT target_guid 
                                FROM mgmt_targets 
                                WHERE target_name = p_target_name
                                  AND target_type = p_target_type);

BEGIN
   IF EMDW_LOG.P_IS_INFO_SET 
   THEN
      EMDW_LOG.INFO('system_change_callback: Enter', G_MODULE_NAME) ; 
   END IF ;

   IF p_assoc_def_name != MGMT_ASSOC.ASSOC_DEF_RUNS_ON THEN
      RETURN;
   END IF;
 
   FOR rec IN  ancestor_services_cur(p_target_name,
                                      p_target_type)
   LOOP
      infer_system(rec.target_name, rec.target_type);
   END LOOP;

   IF EMDW_LOG.P_IS_INFO_SET 
   THEN
      EMDW_LOG.INFO('system_change_callback: Exit', G_MODULE_NAME) ; 
   END IF ;

END system_change_callback;

PROCEDURE add_system_assoc_for_agg_svc(p_service_name IN VARCHAR2,
                                       p_service_type IN VARCHAR2,
                                       p_system_name IN VARCHAR2,
                                       p_system_type IN VARCHAR2)
AS
BEGIN
         MGMT_ASSOC.create_target_assoc(MGMT_ASSOC.ASSOC_DEF_RUNS_ON, 
                                        p_service_name,
                                        p_service_type, 
                                        p_system_name,
                                        p_system_type);
         mgmt_assoc.add_assoc_property(
                                     MGMT_ASSOC.ASSOC_DEF_RUNS_ON,
                                     p_service_name,
                                     p_service_type,
                                     p_system_name,
                                     p_system_type,
                                     mgmt_assoc.GLOBAL_SCOPE_TARGET_NAME,
                                     mgmt_assoc.GLOBAL_SCOPE_TARGET_TYPE,
                                     mgmt_service.G_RUNS_ON_SYSTEM_INFERED_PROP,
                                     '1');
END add_system_assoc_for_agg_svc;
--
-- PURPOSE: infer the system for aggregate service, based on sytems of its 
--   current sub services. If all subservices have runs-on system and 
--  all systems are the same, use this as the system for aggregate service
--
PROCEDURE infer_system(p_service_name IN VARCHAR2,
                       p_target_type IN VARCHAR2) AS
l_sub_service_count NUMBER;
l_system_count NUMBER;
l_unique_system_count NUMBER;

l_temp_system_name MGMT_TARGETS.target_name%TYPE;
l_temp_system_type MGMT_TARGETS.target_type%TYPE;
l_old_system_name MGMT_TARGETS.target_name%TYPE;
l_old_system_type MGMT_TARGETS.target_type%TYPE;

l_user_system NUMBER;

BEGIN
    IF EMDW_LOG.P_IS_INFO_SET 
    THEN
      EMDW_LOG.INFO('infer_system: Enter', G_MODULE_NAME) ; 
    END IF ;
   
   -- check if user has manually configed a runs-on system
   SELECT count(*) INTO l_user_system
     FROM mgmt_target_assocs a, mgmt_targets t
    WHERE a.assoc_guid = mgmt_assoc.g_runs_on_guid
      AND a.source_target_guid = t.target_guid
      AND t.target_name = p_service_name
      AND t.target_type = p_target_type
      AND NOT EXISTS (SELECT * 
                        FROM mgmt_target_assoc_prop
                       WHERE assoc_guid = mgmt_assoc.g_runs_on_guid
                         AND source_target_guid = a.source_target_guid
                         AND property_name = 
                                     mgmt_service.G_RUNS_ON_SYSTEM_INFERED_PROP
                         AND property_value = '1');
   IF l_user_system > 0 THEN
      IF emdw_log.p_is_debug_set THEN
         emdw_log.debug('infer_system: service ' 
                       || p_service_name 
                       ||' has user configed system, dont infer system for it'
                       , G_MODULE_NAME);
      END IF;
      RETURN;
   END IF;
   
   SELECT count(a.assoc_target_guid) INTO l_sub_service_count
   FROM mgmt_target_assocs a, mgmt_targets t, mgmt_target_assoc_prop p
   WHERE a.assoc_guid = mgmt_assoc.g_depends_on_guid 
     AND a.source_target_guid = t.target_guid
     AND t.target_name = p_service_name
     AND t.target_type = p_target_type
     AND a.assoc_guid = p.assoc_guid
     AND a.source_target_guid = p.source_target_guid
     AND a.assoc_target_guid = p.assoc_target_guid
     AND a.scope_target_guid = p.scope_target_guid
     AND p.property_name = mgmt_service.G_SYSTEM_DEPENDS_ON_PROP
     AND p.property_value = '1';

   IF EMDW_LOG.P_IS_DEBUG_SET 
   THEN
      EMDW_LOG.DEBUG('infer_system: sub_services_count ' || l_sub_service_count, G_MODULE_NAME) ; 
   END IF ;


   SELECT count(a.assoc_target_guid), count(UNIQUE a.assoc_target_guid) 
       INTO l_system_count, l_unique_system_count
   FROM mgmt_target_assocs a    
   WHERE a.assoc_guid = mgmt_assoc.g_runs_on_guid
     AND a.source_target_guid IN
       (
               SELECT a.assoc_target_guid
               FROM mgmt_target_assocs a,
                    mgmt_targets t,
                    mgmt_target_assoc_prop p
               WHERE a.assoc_guid = mgmt_assoc.g_depends_on_guid 
               AND a.source_target_guid = t.target_guid
               AND t.target_name = p_service_name
               AND t.target_type = p_target_type
               AND a.assoc_guid = p.assoc_guid
               AND a.source_target_guid = p.source_target_guid
               AND a.assoc_target_guid = p.assoc_target_guid
               AND a.scope_target_guid = p.scope_target_guid
               AND p.property_name = mgmt_service.G_SYSTEM_DEPENDS_ON_PROP
               AND p.property_value = '1'
      );
    IF EMDW_LOG.P_IS_DEBUG_SET 
    THEN
      EMDW_LOG.DEBUG('infer_system: system_count ' || l_system_count || ' unique system count ' || l_unique_system_count, G_MODULE_NAME) ; 
    END IF ;

    IF l_sub_service_count = 0
       OR l_sub_service_count != l_system_count 
       OR l_unique_system_count > 1 THEN
       BEGIN
         -- remove any previous RUNS_ON assoc for aggregate service
         SELECT t.target_name, t.target_type INTO l_temp_system_name, l_temp_system_type
         FROM mgmt_targets t
         WHERE t.target_guid IN
           ( SELECT a.assoc_target_guid 
             FROM  mgmt_target_assocs a, mgmt_targets tt
             WHERE a.assoc_guid = mgmt_assoc.g_runs_on_guid
              AND  tt.target_guid = a.source_target_guid
              AND  tt.target_name = p_service_name
              AND  tt.target_type = p_target_type
           ); 
         MGMT_ASSOC.delete_target_assoc(MGMT_ASSOC.ASSOC_DEF_RUNS_ON, 
                           p_service_name,
                           p_target_type, 
                           l_temp_system_name, 
                           l_temp_system_type);
       EXCEPTION
          WHEN NO_DATA_FOUND THEN
               NULL;
       END;
    ELSE
      -- all subservices are running on the same system
      SELECT t.target_name, t.target_type INTO l_temp_system_name, l_temp_system_type
      FROM mgmt_targets t
      WHERE t.target_guid IN
       (
             SELECT UNIQUE a.assoc_target_guid
             FROM mgmt_target_assocs a
             WHERE a.assoc_guid = mgmt_assoc.g_runs_on_guid
             AND a.source_target_guid IN
             (
               SELECT a.assoc_target_guid
               FROM mgmt_target_assocs a, mgmt_targets t,
                    mgmt_target_assoc_prop p
               WHERE a.assoc_guid = mgmt_assoc.g_depends_on_guid 
               AND a.source_target_guid = t.target_guid
               AND t.target_name = p_service_name
               AND t.target_type = p_target_type
               AND a.assoc_guid = p.assoc_guid
               AND a.source_target_guid = p.source_target_guid
               AND a.assoc_target_guid = p.assoc_target_guid
               AND a.scope_target_guid = p.scope_target_guid
               AND p.property_name = mgmt_service.G_SYSTEM_DEPENDS_ON_PROP
               AND p.property_value = '1'
            )
      );

      mgmt_service.get_system(p_service_name, p_target_type,
                              l_old_system_name, l_old_system_type);
      IF emdw_log.p_is_debug_set THEN
         emdw_log.debug('Infer_system: old system is ' ||
                        l_old_system_name || '/' || l_old_system_type
                        || ' new system is ' ||
                        l_temp_system_name || '/' || l_temp_system_type,
                        G_MODULE_NAME);
      END IF;

      IF l_old_system_name IS NOT NULL AND
         l_old_system_type IS NOT NULL
      THEN
         IF l_old_system_name != l_temp_system_name OR
             l_old_system_type != l_temp_system_type
         THEN
            IF emdw_log.p_is_debug_set THEN
               emdw_log.debug('Infer_system: remove old system and set new one',
                               G_MODULE_NAME);
            END IF;

            MGMT_ASSOC.delete_target_assoc(MGMT_ASSOC.ASSOC_DEF_RUNS_ON, 
                                           p_service_name,
                                           p_target_type,
                                           l_old_system_name,
                                           l_old_system_type); 
         
            add_system_assoc_for_agg_svc(p_service_name,
                                         p_target_type,
                                         l_temp_system_name,
                                         l_temp_system_type);                
        END IF;
      ELSE
        IF emdw_log.p_is_debug_set THEN
           emdw_log.debug('Infer_system: set new system',
                          G_MODULE_NAME);
        END IF;

        add_system_assoc_for_agg_svc(p_service_name,
                                     p_target_type,
                                     l_temp_system_name,
                                     l_temp_system_type);     
      END IF; -- l_old_system_name IS NOT NULL
    END IF; -- l_subservice_count = 0
      
    IF EMDW_LOG.P_IS_INFO_SET 
    THEN
      EMDW_LOG.INFO('infer_system: Exit', G_MODULE_NAME) ; 
    END IF ;
    
END infer_system;

--
-- PROCEDURE: assoc_addition_callback
-- PURPOSE: recalculate inferred system for aggregate service, 
--      when sub service's RUNS-ON system changes. The process will apply 
--      to all aggregate service ancestors of the source targets

-- IN PARAMETERS: see sdk_assoc_pkgdef
--                       p_assoc_def_name VARCHAR2,
  --                     p_source_target_name VARCHAR2,
  --                     p_source_target_type VARCHAR2,
  --                     p_assoc_target_name  VARCHAR2,
  --                     p_assoc_target_type  VARCHAR2,
  --                     p_scope_target_name  VARCHAR2,
  --                     p_scope_target_type  VARCHAR2;
-- OUT PARAMETER: none
-- 
PROCEDURE ASSOC_ADDITION_CALLBACK(p_assoc_def_name VARCHAR2,
                                  p_source_target_name VARCHAR2,
                                  p_source_target_type VARCHAR2,
                                  p_assoc_target_name  VARCHAR2,
                                  p_assoc_target_type  VARCHAR2,
                                  p_scope_target_name  VARCHAR2,
                                  p_scope_target_type  VARCHAR2) AS
BEGIN
   IF emdw_log.P_IS_DEBUG_SET THEN
      emdw_log.debug('assoc_addition_callback: Enter ' 
               || p_assoc_def_name || '/' 
               || p_source_target_name || '/'
               || p_assoc_target_name, G_MODULE_NAME);
   END IF;

    IF p_assoc_def_name = MGMT_ASSOC.ASSOC_DEF_RUNS_ON THEN
      system_change_callback(p_assoc_def_name, 
                           p_source_target_name,
                           p_source_target_type);
    ELSIF p_assoc_def_name = MGMT_ASSOC.ASSOC_DEF_DEPENDS_ON THEN
      depends_change_callback(p_source_target_name,
                              p_source_target_type,
                              p_assoc_target_name,
                              p_assoc_target_type);

    END IF;
   IF emdw_log.P_IS_DEBUG_SET THEN
      emdw_log.debug('assoc_addition_callback: Exit ' 
                    , G_MODULE_NAME);
   END IF;

END ASSOC_ADDITION_CALLBACK;
--
-- PROCEDURE: assoc_deletion_callback
-- PURPOSE: recalculate inferred system for aggregate service, 
--      when sub service's RUNS-ON system changes. The process will apply 
--      to all aggregate service ancestors of the source targets

-- IN PARAMETERS: see sdk_assoc_pkgdef
--                       p_assoc_def_name VARCHAR2,
  --                     p_source_target_name VARCHAR2,
  --                     p_source_target_type VARCHAR2,
  --                     p_assoc_target_name  VARCHAR2,
  --                     p_assoc_target_type  VARCHAR2,
  --                     p_scope_target_name  VARCHAR2,
  --                     p_scope_target_type  VARCHAR2;
-- OUT PARAMETER: none
-- 
PROCEDURE ASSOC_DELETION_CALLBACK(p_assoc_def_name VARCHAR2,
                                  p_source_target_name VARCHAR2,
                                  p_source_target_type VARCHAR2,
                                  p_assoc_target_name  VARCHAR2,
                                  p_assoc_target_type  VARCHAR2,
                                  p_scope_target_name  VARCHAR2,
                                  p_scope_target_type  VARCHAR2) AS
BEGIN
   IF emdw_log.P_IS_DEBUG_SET THEN
      emdw_log.debug('assoc_deletion_callback: Enter ' 
               || p_assoc_def_name || '/' 
               || p_source_target_name || '/'
               || p_assoc_target_name, G_MODULE_NAME);
   END IF;

    IF p_assoc_def_name = MGMT_ASSOC.ASSOC_DEF_RUNS_ON THEN
      system_change_callback(p_assoc_def_name, 
                           p_source_target_name,
                           p_source_target_type);
    ELSIF p_assoc_def_name = MGMT_ASSOC.ASSOC_DEF_DEPENDS_ON THEN
      depends_change_callback(p_source_target_name,
                              p_source_target_type,
                              p_assoc_target_name,
                              p_assoc_target_type);

    END IF;
   IF emdw_log.P_IS_DEBUG_SET THEN
      emdw_log.debug('assoc_deletion_callback: Exit ' 
                    , G_MODULE_NAME);
   END IF;

END ASSOC_DELETION_CALLBACK;

--
-- PROCEDURE: create_service_type
-- PURPOSE: Internal procedure to initialize service types for end-user
-- defined services
PROCEDURE initialize_service_type(p_target_type   IN VARCHAR2,
                                  p_is_aggregate IN BOOLEAN,
                                  p_type_meta_ver IN VARCHAR2,
                                  p_type_display_name IN VARCHAR2 DEFAULT NULL)
IS
  l_metric_col_list MGMT_METRIC_COLUMN_ARRAY :=  MGMT_METRIC_COLUMN_ARRAY();
  l_cat_array MGMT_CATEGORY_ARRAY := MGMT_CATEGORY_ARRAY();
  l_type_meta_ver MGMT_TARGETS.TYPE_META_VER%TYPE := p_type_meta_ver;
  l_type_resource_bundle_in MGMT_TARGET_TYPES.TYPE_RESOURCE_BUNDLE%TYPE := NULL;
BEGIN

  -- Register the type first as a service type
  -- MGMT_TARGET.register_target_type(p_target_type_in => p_target_type, 
  --                               p_type_meta_ver_in => p_type_meta_ver,
  --                               p_type_display_name_in => p_type_display_name);


  -- Register Response/Status metric 
  l_metric_col_list.extend(1);
  l_metric_col_list(1) := MGMT_METRIC_COLUMN_OBJ.new(
                             p_column_name => MGMT_GLOBAL.G_AVAIL_METRIC_COLUMN,
                             p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_REPOS_EVENT,
                             p_column_label_nlsid => 'svc_resp_stat',
                             p_short_name_nlsid => 'svc_resp_stat');


  -- eval-proc name registered here is a dummy one. The real eval procs are
  -- registered at collection level
  begin
    mgmt_metric.create_metric(p_target_type => p_target_type,
                              p_metric_name => MGMT_GLOBAL.G_AVAIL_METRIC_NAME,
                              p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_REPOS_TABLE,
                              p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_SEVEVAL_PLSQL,
                              p_source =>      MGMT_SEVERITY_HELPER.G_OR_AVAIL_EVAL_PROC_NAME,
                              p_metric_label_nlsid => 'svc_resp',
                              p_short_name_nlsid => 'svc_resp',
                              p_type_meta_ver => p_type_meta_ver,
                              p_metric_column_list => l_metric_col_list,
                              p_is_repository => 1);
  exception when dup_val_on_index then
    null;
  end;


  -- Register Usage metric
  l_metric_col_list(1) := MGMT_METRIC_COLUMN_OBJ.new(
                             p_column_name => MGMT_SERVICE.G_USAGE_KEY_COL_NAME,
                             p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                             p_column_label_nlsid => 'svc_usage_metric_name',
                             p_short_name_nlsid => 'svc_usage_metric_name',
                             p_is_key => 1);


  l_metric_col_list.extend(1);
  l_metric_col_list(2) := MGMT_METRIC_COLUMN_OBJ.new(
                             p_column_name => MGMT_SERVICE.G_USAGE_VALUE_COL_NAME,
                             p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
                             p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_PLSQL,
                             p_column_label_nlsid => 'svc_usage_metric_value',
                             p_short_name_nlsid => 'svc_usage_metric_value',
                             p_source =>      MGMT_METRIC_HELPER.G_WRAPPER_EVAL_FUNC);

  l_cat_array.extend(1);
  l_cat_array(1) := MGMT_CATEGORY_OBJ.NEW(mgmt_global.G_CATEGORY_CLASS_SERVICE,
                                          mgmt_global.G_SERVICE_CATEGORY_USAGE);

  begin
    mgmt_metric.create_metric(p_target_type => p_target_type,
                              p_metric_name => MGMT_SERVICE.G_USAGE_METRIC_NAME,
                              p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_REPOS_TABLE,
                              p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_PLSQL,
                              p_source =>      MGMT_METRIC_HELPER.G_WRAPPER_EVAL_FUNC,
                              p_metric_label_nlsid => 'svc_usage',
                              p_short_name_nlsid => 'svc_usage',
                              p_type_meta_ver => p_type_meta_ver,
                              p_metric_column_list => l_metric_col_list,
                              p_category_list => l_cat_array,
                              p_is_transposed => 1,
                              p_is_repository => 1,
                              p_keys_from_mult_colls => 1);
  exception when dup_val_on_index then
    null;
  end;  

  -- Register performance metric
  l_metric_col_list(1) := MGMT_METRIC_COLUMN_OBJ.new(
                             p_column_name => MGMT_SERVICE.G_PERFORMANCE_KEY_COL_NAME,
                             p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                             p_column_label_nlsid => 'svc_perf_metric_name',
                             p_short_name_nlsid => 'svc_perf_metric_name',
                             p_is_key => 1);

  l_metric_col_list(2) := MGMT_METRIC_COLUMN_OBJ.new(
                             p_column_name => MGMT_SERVICE.G_PERFORMANCE_VALUE_COL_NAME,
                             p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
                             p_column_label_nlsid => 'svc_perf_metric_value',
                             p_short_name_nlsid => 'svc_perf_metric_value',
                             p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_PLSQL,
                             p_source =>      MGMT_METRIC_HELPER.G_WRAPPER_EVAL_FUNC);

  l_cat_array(1) := MGMT_CATEGORY_OBJ.NEW(mgmt_global.G_CATEGORY_CLASS_SERVICE,
                                          mgmt_global.G_SERVICE_CATEGORY_PERFORMANCE);

  begin
    mgmt_metric.create_metric(p_target_type => p_target_type,
                              p_metric_name => MGMT_SERVICE.G_PERFORMANCE_METRIC_NAME,
                              p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_REPOS_TABLE,
                              p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_PLSQL,
                              p_source =>      MGMT_METRIC_HELPER.G_WRAPPER_EVAL_FUNC,
                              p_metric_label_nlsid => 'svc_perf',
                              p_short_name_nlsid => 'svc_perf',
                              p_type_meta_ver => p_type_meta_ver,
                              p_metric_column_list => l_metric_col_list,
                              p_category_list => l_cat_array,
                              p_is_transposed => 1,
                              p_is_repository => 1,
                              p_keys_from_mult_colls => 1);
  exception when dup_val_on_index then
    null;
  end;

   -- Register business metric
  l_metric_col_list(1) := MGMT_METRIC_COLUMN_OBJ.new(
                             p_column_name => MGMT_SERVICE.G_BUSINESS_KEY_COL_NAME,
                             p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                             p_column_label_nlsid => 'svc_business_metric_name',
                             p_short_name_nlsid => 'svc_business_metric_name',
                             p_is_key => 1);

  l_metric_col_list(2) := MGMT_METRIC_COLUMN_OBJ.new(
                             p_column_name => MGMT_SERVICE.G_BUSINESS_VALUE_COL_NAME,
                             p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
                             p_column_label_nlsid => 'svc_business_metric_value',
                             p_short_name_nlsid => 'svc_business_metric_value',
                             p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_PLSQL,
                             p_source =>      MGMT_METRIC_HELPER.G_WRAPPER_EVAL_FUNC);

  l_cat_array(1) := MGMT_CATEGORY_OBJ.NEW(mgmt_global.G_CATEGORY_CLASS_SERVICE,
                                          mgmt_global.G_SERVICE_CATEGORY_BUSINESS);

  begin
    mgmt_metric.create_metric(p_target_type => p_target_type,
                              p_metric_name => MGMT_SERVICE.G_BUSINESS_METRIC_NAME,
                              p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_REPOS_TABLE,
                              p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_PLSQL,
                              p_source =>      MGMT_METRIC_HELPER.G_WRAPPER_EVAL_FUNC,
                              p_metric_label_nlsid => 'svc_business',
                              p_short_name_nlsid => 'svc_business',
                              p_type_meta_ver => p_type_meta_ver,
                              p_metric_column_list => l_metric_col_list,
                              p_category_list => l_cat_array,
                              p_is_transposed => 1,
                              p_is_repository => 1,
                              p_keys_from_mult_colls => 1);
  exception when dup_val_on_index then
    null;
  end;

  -- Fix for bug# 4333138

  if (p_target_type = MGMT_GLOBAL.G_GENERIC_SERVICE_TYPE or p_target_type = MGMT_GLOBAL.G_AGGREGATE_SERVICE_TYPE) then
    l_type_resource_bundle_in := 'oracle.sysman.resources.gensvc';
  elsif (p_target_type = MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE) then
    l_type_resource_bundle_in := 'oracle.sysman.resources.website';

  -- Fix for RFI bug# 5362184
  elsif (p_target_type = MGMT_GLOBAL.G_FORMSAPP_TARGET_TYPE) then
    l_type_resource_bundle_in := 'oracle.sysman.resources.formsapp';
  else
    l_type_resource_bundle_in := null;
  end if;

  -- Register the type first as a service type
  MGMT_TARGET.register_target_type(p_target_type_in => p_target_type,
                                 p_type_meta_ver_in => p_type_meta_ver,
                                 p_type_display_name_in => p_type_display_name,
                                 p_type_resource_bundle_in => l_type_resource_bundle_in);


  IF(p_is_aggregate = FALSE) THEN

    IF(p_target_type = MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE) THEN
      l_type_meta_ver := '1.0';
    END IF;

    -- Register the availability metric for test-based services
    -- aggregate services do not need this metric.
    l_metric_col_list := MGMT_METRIC_COLUMN_ARRAY();
  
    l_metric_col_list.extend(1);
    l_metric_col_list(l_metric_col_list.count) := 
    MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'transaction_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Transaction Name',
        p_is_key => 1);

    l_metric_col_list.extend(1);
    l_metric_col_list(l_metric_col_list.count) := 
    MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => MGMT_GLOBAL.G_AVAIL_METRIC_COLUMN,
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_REPOS_EVENT,
        p_column_label => '[Test Response] Status',
        p_column_label_nlsid => 'test_response_status',
        p_is_key => 0,
        p_short_name => 'Status',
        p_short_name_nlsid => 'test_response_status_short');

    begin

      mgmt_metric.create_metric(p_target_type => p_target_type,
                                p_metric_name => MGMT_GLOBAL.G_AVAIL_TEST_METRIC_NAME,
                                p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_REPOS_TABLE,
                                p_metric_label => MGMT_GLOBAL.G_AVAIL_TEST_METRIC_NAME,
                                p_metric_label_nlsid => 'test_response',
                                p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_SEVEVAL_PLSQL,
                                p_source =>      MGMT_SEVERITY_HELPER.G_OR_AVAIL_EVAL_PROC_NAME,
                                p_type_meta_ver => l_type_meta_ver,
                                p_metric_column_list => l_metric_col_list,
                                p_is_repository => 1,
                                p_remote     => 0,
                                p_keys_from_mult_colls => 1);
    exception when dup_val_on_index then
      null;
    end;

   END IF;


  MGMT_TARGET.add_target_type_property(p_target_type,
                                       MGMT_GLOBAL.G_IS_SERVICE_PROP, '1');
  IF (p_is_aggregate) THEN
     MGMT_TARGET.add_target_type_property(p_target_type,
                     MGMT_GLOBAL.G_IS_AGGREGATE_SERVICE_PROP, '1');
  END IF;

END initialize_service_type;


procedure check_loop_containment(p_service_name IN VARCHAR2,
                                 p_service_type IN VARCHAR2,
                                 p_system_name IN VARCHAR2,
                                 p_system_type IN VARCHAR2)
as
l_loop_count NUMBER;
begin
   IF emdw_log.P_IS_DEBUG_SET THEN
      emdw_log.debug('check_loop_containment:Exit', G_MODULE_NAME);
   END IF;

   SELECT count(t.target_name) INTO l_loop_count
     FROM mgmt_flat_target_assoc fa, mgmt_targets t,
          mgmt_targets t1
    WHERE fa.source_target_guid = t1.target_guid
      AND t1.target_name = p_system_name
      AND t1.target_type = p_system_type
      AND t.target_guid = fa.assoc_target_guid
      AND fa.is_membership = 1
      AND t.target_name = p_service_name
      AND t.target_type = p_service_type;
   IF l_loop_count > 0 THEN
      raise_application_error(mgmt_global.LOOP_CONTAINMENT_ERR,
                              mgmt_global.LOOP_CONTAINMENT_ERR_M ||
                   ' Service details:  ' || p_service_name || ':'
                                         || p_service_type
                   || ' System details: ' || p_system_name || ':'
                                          || p_system_type );
   END IF;
   IF emdw_log.P_IS_DEBUG_SET THEN
      emdw_log.debug('check_loop_containment:Exit', G_MODULE_NAME);
   END IF;

end check_loop_containment;

END;
/
show error;

