Rem drv: <create type="pkgdefs" pos="storage/storage_pkgdefs.sql+"/>
Rem
Rem $Header: service_pkgdef.sql 14-jul-2006.17:03:08 skkunise Exp $
Rem
Rem service_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      service_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    skkunise    07/14/06 - Adding has_business property 
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    gan         03/22/05 - check loop containment 
Rem    gan         03/22/05 - Add type display name 
Rem    streddy     10/04/04 - Move service creation code into this package
Rem    gan         09/14/04 - add target prop 
Rem    streddy     08/16/04 - streddy_agr_svc_apis
Rem    gan         08/11/04 - Created
Rem

CREATE OR REPLACE PACKAGE EM_SERVICE AS

G_MODULE_NAME CONSTANT VARCHAR2(50) := 'EM_SERVICE';

--PROPERT NAME for homepage chart
G_SVC_HP_USAGE_METRIC_NAME 
                  constant MGMT_TARGET_PROPERTIES.property_name%TYPE := 
                 'SVC_HP_USAGE_METRIC_NAME';
G_SVC_HP_USAGE_METRIC_COL 
                 constant MGMT_TARGET_PROPERTIES.property_name%TYPE :=                            'SVC_HP_USAGE_METRIC_COL';
G_SVC_HP_USAGE_KEY 
                 constant MGMT_TARGET_PROPERTIES.property_name%TYPE :=                            'SVC_HP_USAGE_KEY';
G_SVC_HP_PERF_METRIC_NAME 
                  constant MGMT_TARGET_PROPERTIES.property_name%TYPE := 
                 'SVC_HP_PERF_METRIC_NAME';
G_SVC_HP_PERF_METRIC_COL
                 constant MGMT_TARGET_PROPERTIES.property_name%TYPE := 
                 'SVC_HP_PERF_METRIC_COL';
G_SVC_HP_PERF_KEY 
                 constant MGMT_TARGET_PROPERTIES.property_name%TYPE :=                            'SVC_HP_PERF_KEY_PROP';
--PROPERTY NAME FOR HAS_BUSINESS
G_SVC_HAS_BUSINESS
                 constant MGMT_TARGET_PROPERTIES.property_name%TYPE :=                            'SVC_HAS_BUSINESS_PROP';

--
-- PROCEDURE: assoc_addition_callback
-- PURPOSE: recalculate inferred system for aggregate service, when sub service'--        s system change
-- IN PARAMETERS: see sdk_assoc_pkgdef
--                       p_assoc_def_name VARCHAR2,
  --                     p_source_target_name VARCHAR2,
  --                     p_source_target_type VARCHAR2,
  --                     p_assoc_target_name  VARCHAR2,
  --                     p_assoc_target_type  VARCHAR2,
  --                     p_scope_target_name  VARCHAR2,
  --                     p_scope_target_type  VARCHAR2;
-- OUT PARAMETER: none
-- 
PROCEDURE ASSOC_ADDITION_CALLBACK(p_assoc_def_name VARCHAR2,
                                  p_source_target_name VARCHAR2,
                                  p_source_target_type VARCHAR2,
                                  p_assoc_target_name  VARCHAR2,
                                  p_assoc_target_type  VARCHAR2,
                                  p_scope_target_name  VARCHAR2,
                                  p_scope_target_type  VARCHAR2);

--
-- PROCEDURE: assoc_deletion_callback
-- PURPOSE: recalculate inferred system for aggregate service, when sub service'--        s system change
-- IN PARAMETERS: see sdk_assoc_pkgdef
--                       p_assoc_def_name VARCHAR2,
  --                     p_source_target_name VARCHAR2,
  --                     p_source_target_type VARCHAR2,
  --                     p_assoc_target_name  VARCHAR2,
  --                     p_assoc_target_type  VARCHAR2,
  --                     p_scope_target_name  VARCHAR2,
  --                     p_scope_target_type  VARCHAR2;
-- OUT PARAMETER: none
-- 
PROCEDURE ASSOC_DELETION_CALLBACK(p_assoc_def_name VARCHAR2,
                                  p_source_target_name VARCHAR2,
                                  p_source_target_type VARCHAR2,
                                  p_assoc_target_name  VARCHAR2,
                                  p_assoc_target_type  VARCHAR2,
                                  p_scope_target_name  VARCHAR2,
                                  p_scope_target_type  VARCHAR2);

--
-- PURPOSE: infer the system for aggregate service, based on sytems of its 
--   current sub services. If all subservices have runs-on system and 
--  all systems are the same, use this as the system for aggregate service
--
PROCEDURE infer_system(p_service_name IN VARCHAR2,
                       p_target_type IN VARCHAR2);


--
-- PROCEDURE: create_service_type
-- PURPOSE: Internal procedure to initialize service types for end-user
-- defined services
PROCEDURE initialize_service_type(p_target_type IN VARCHAR2,
                                  p_is_aggregate IN BOOLEAN,
                                  p_type_meta_ver IN VARCHAR2,
                                  p_type_display_name IN VARCHAR2 DEFAULT NULL );

--
-- purpose: check if a service is a member of the system it is running on
-- exception: throw LOOP_CONTAINMENT exception
procedure check_loop_containment(p_service_name IN VARCHAR2,
                                 p_service_type IN VARCHAR2,
                                 p_system_name IN VARCHAR2,
                                 p_system_type IN VARCHAR2);


END EM_SERVICE;
/
show error;
