Rem
Rem $Header: severity_pkgdefs.sql 29-aug-2007.23:17:47 jsadras Exp $
Rem
Rem severity_pkgdefs.sql
Rem
Rem Copyright (c) 2002, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      severity_pkgdefs.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Utility functions used by severity trigger.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jsadras     08/29/07 - add collection disabled nlsid
Rem    jsadras     08/29/07 - Backport jsadras_bug-6363234 from main
Rem    pmodi       05/28/07 - Bug-6038522 Check previous status fro website
Rem                           target
Rem    pmodi       05/28/07 - Bug-6038522 Check previous status fro website
Rem                           target
Rem    pmodi       06/11/07 - Backport pmodi_bug-6038522 from main
Rem    pmodi       08/07/06 - Backport pmodi_bug-5095885 from main
Rem    neearora    07/24/06 - project 21470. Added exec_crs_event_callbacks 
Rem    pmodi       03/16/06 - Bug:5095885 Define new table data type 
Rem    jsadras     01/02/06 - log_external_alerts function 
Rem    hbadheka    12/27/05 - Add new function 
Rem    pmodi       12/01/05 - Backport pmodi_bug-4740910 from main 
Rem    pmodi       11/21/05 - Bug:4740910 Define guid collection to use in 
Rem                           delete violation trigger 
Rem    gan         08/30/05 - bug 4559108, split record when unreacable follows blackout 
Rem    jsadras     08/02/05 - Bug:4529040, add key exception clear constant 
Rem    rpinnama    07/25/05 - Fix 4415154 : Return new tatus from 
Rem                           process_unreachable_clear 
Rem    jsadras     07/04/05 - add cfg_ columns to current violation 
Rem                           add clear_alerts_and_errors
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    pmodi       06/20/05 - Bug:4389284- Change for NLS Message 
Rem    vkgarg      06/07/05 - return target timezone in get_severity_labels 
Rem    pmodi       06/10/05 - Bug:4406767 -New proc for key-val deletion 
Rem    rpinnama    05/17/05 - Change the violation_duration default to NULL 
Rem    rpinnama    04/20/05 - Fix 3981814: Calculate notif status based on 
Rem                           status before blackout 
Rem    jsadras     04/01/05 - t_urowid_list
Rem    rpinnama    04/05/05 - Add message parameter to clear_open_alers API 
Rem    neearora    03/06/05 - Removed entry for G_DEBUG 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    streddy     01/17/05 - Add p_sev_target_guid package level variable 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    jsadras     12/05/04 - purge_apis
Rem    rpinnama    09/20/04 - Add informational string 
Rem    rpinnama    09/07/04 - Add inser_violation API 
Rem    rpinnama    04/12/04 - Lock availability to serialize updates to 
Rem                           availability system
Rem    rpinnama    09/07/03 - Add purge policy callbacks 
Rem    streddy     07/10/03 - Added DATE_1900 constant
Rem    mbhoopat    05/13/03 - support server alerts
Rem    rpinnama    03/03/03 - Get avail cursor
Rem    rpinnama    03/14/03 - 
Rem    rpinnama    03/14/03 - Consolidate avail record cursor
Rem    rpinnama    11/08/02 - support add_target API
Rem    rpinnama    11/01/02 - Disable logging for heartbeats
Rem    yaofeng     08/27/02 - use raw data type for metric_guid
Rem    yaofeng     08/13/02 - simplify severity chart computation
Rem    rpinnama    07/19/02 - Log with emd_url
Rem    yaofeng     07/19/02 - add navigation on alert history page
Rem    rpinnama    06/25/02 - Add error messages
Rem    yaofeng     06/21/02 - add procedures for severity history chart
Rem    rpinnama    06/12/02 - rpinnama_tgt_avail
Rem    rpinnama    06/06/02 - Created
Rem

CREATE OR REPLACE PACKAGE EM_SEVERITY AS

  ---------------------------------------------------------
  -- Package Variables
  ---------------------------------------------------------

  -- Guid of the target for which last severity was processed.
  -- Used in the violations table statement level trigger
  P_LAST_TARGET_GUID RAW(16) := NULL;

  ---------------------------------------------------------
  -- Package Constants
  ---------------------------------------------------------
  MODULE CONSTANT VARCHAR2(64) := 'SEVERITY TRIGGER';

  SEVERITY_COMMENT_STR           CONSTANT VARCHAR2(20) := 'COMMENT';
  SEVERITY_CLEAR_STR             CONSTANT VARCHAR2(20) := 'CLEAR';
  SEVERITY_INFORMATIONAL_STR     CONSTANT VARCHAR2(20) := 'INFORMATIONAL';
  SEVERITY_WARNING_STR           CONSTANT VARCHAR2(20) := 'WARNING';
  SEVERITY_CRITICAL_STR          CONSTANT VARCHAR2(20) := 'CRITICAL';
  SEVERITY_UNREACHABLE_CLEAR_STR CONSTANT VARCHAR2(20) := 'UNREACHABLE CLEAR';
  SEVERITY_UNREACHABLE_START_STR CONSTANT VARCHAR2(20) := 'UNREACHABLE START';
  SEVERITY_BLACKOUT_END_STR      CONSTANT VARCHAR2(20) := 'BLACKOUT END';
  SEVERITY_BLACKOUT_START_STR    CONSTANT VARCHAR2(20) := 'BLACKOUT START';
  SEVERITY_ERROR_END_STR         CONSTANT VARCHAR2(20) := 'ERROR END';
  SEVERITY_ERROR_START_STR       CONSTANT VARCHAR2(20) := 'ERROR START';

  AVAIL_DOWN_STR                 CONSTANT VARCHAR2(16) := 'DOWN';
  AVAIL_UP_STR                   CONSTANT VARCHAR2(16) := 'UP';
  AVAIL_ERROR_STR                CONSTANT VARCHAR2(16) := 'METRIC ERROR';
  AVAIL_AGENT_DOWN_STR           CONSTANT VARCHAR2(16) := 'AGENT DOWN';
  AVAIL_UNREACHABLE_STR          CONSTANT VARCHAR2(16) := 'UNREACHABLE';
  AVAIL_BLACKOUT_STR             CONSTANT VARCHAR2(16) := 'BLACKOUT';
  AVAIL_UNKNOWN_STR              CONSTANT VARCHAR2(16) := 'UNKNOWN';

  -- metric guid for Target Type: cluster, Metric Name: crs_event, Metric Column: Status  
  CLUSTER_CRS_EVENT_METRIC_GUID  CONSTANT RAW(16)      := HEXTORAW('2B3903B93E8D6BC74BD3E41815A6CEAF'); 

  DATE_2100_01_01  CONSTANT DATE := TO_DATE('2100-01-01', 'YYYY-MM-DD');

  DATE_1900_01_01  CONSTANT DATE := TO_DATE('1900-01-01', 'YYYY-MM-DD');
  --
  -- This is set to true to prevent delete trigger from deleting data
  --
  G_FROM_PURGE_API  BOOLEAN := FALSE ;
  --
  -- number of records to delete  at one go from mgmt-violations
  -- 
  G_PURGE_BATCH_SIZE NUMBER := 1000 ;
  -- 
  -- number of life cycles to fetch in one batch
  --
  G_FETCH_BATCH_SIZE NUMBER := 100 ;

  ---------------------------------------------------------
  -- Package Types
  ---------------------------------------------------------
  TYPE t_rowid_list  IS TABLE OF ROWID INDEX BY BINARY_INTEGER;
  TYPE t_urowid_list IS TABLE OF UROWID INDEX BY BINARY_INTEGER;

  TYPE t_number_list IS TABLE OF NUMBER INDEX BY BINARY_INTEGER;

  TYPE t_varchar2_256_list IS TABLE OF VARCHAR2(256) INDEX BY BINARY_INTEGER;

  TYPE t_date_list IS TABLE OF DATE INDEX BY BINARY_INTEGER;

  TYPE t_guid_list IS TABLE OF RAW(16) INDEX BY BINARY_INTEGER;

  TYPE AVAIL_CURSOR IS REF CURSOR;
  -- Clear messages for alerts
  G_CLR_THRESHOLD_NULL_MSG CONSTANT VARCHAR2(50) 
        := 'CLEARED:NULL Thresholds' ;
  G_CLR_METRIC_REM_MSG      CONSTANT VARCHAR2(50) 
        := 'CLEARED: Metric association removed' ;
  G_CLR_METRIC_DISABLED_MSG CONSTANT VARCHAR2(50) 
        := 'CLEARED: Metric association disabled' ;
  G_CLR_POLICY_REM_MSG      CONSTANT VARCHAR2(50) 
        := 'CLEARED: Policy association removed' ;
  G_CLR_POLICY_DISABLED_MSG CONSTANT VARCHAR2(50) 
        := 'CLEARED: Policy association disabled' ;
  G_CLR_COLL_DISABLED_MSG CONSTANT VARCHAR2(50) 
        := 'CLEARED: Collection disabled' ;
  G_CLR_MANUAL_MSG CONSTANT VARCHAR2(50) 
        := 'CLEARED: Manual' ;
  G_CLR_KEY_EXCLUDED_MSG CONSTANT VARCHAR2(50) 
        := 'CLEARED: OBJECT EXCLUDED FROM EVALUATION' ;

  G_CLR_THRESHOLD_NULL_NLSID CONSTANT VARCHAR2(50)  := NULL ;
  G_CLR_METRIC_REM_NLSID      CONSTANT VARCHAR2(50) := NULL ;
  G_CLR_METRIC_DISABLED_NLSID CONSTANT VARCHAR2(50) := NULL ;
  G_CLR_POLICY_REM_NLSID      CONSTANT VARCHAR2(50) := NULL ;
  G_CLR_POLICY_DISABLED_NLSID CONSTANT VARCHAR2(50) := NULL ;
  G_CLR_COLL_DISABLED_NLSID CONSTANT VARCHAR2(64) := 
     'MntrResourceBundleID.COLLECTION_CURRENTLY_DISABLED_1' ;
  G_CLR_MANUAL_NLSID CONSTANT VARCHAR2(50) := NULL ;
  G_CLR_KEY_EXCLUDED_NLSID CONSTANT VARCHAR2(50)  := NULL ;

  -- GUID collection to be used in AFTER DELETE trigger on MGMT_VIOLATIONS
  -- for bulk delete
  p_violation_guids MGMT_TARGET_GUID_ARRAY := MGMT_TARGET_GUID_ARRAY();

  PROCEDURE add_target(p_target_guid IN RAW,
                       p_target_type IN VARCHAR2,
		       p_is_group    IN NUMBER,
                       p_timezone_region IN VARCHAR2);

  PROCEDURE lock_avail_for_tgt(p_target_guid IN RAW);

  PROCEDURE lock_avail_for_agt(p_emd_url IN VARCHAR2);

  FUNCTION is_sev_in_blackout(p_target_guid IN RAW,
                              p_coll_ts     IN DATE)
    RETURN BOOLEAN;

  --
  --  Violation API 
  --

  --
  -- Insert a violation row.
  --
  PROCEDURE insert_violation(
       p_target_guid           IN RAW,
       p_policy_guid           IN RAW,
       p_key_value             IN VARCHAR2 DEFAULT ' ',
       p_collection_timestamp  IN DATE     DEFAULT SYSDATE,
       p_violation_guid        IN RAW      DEFAULT SYS_GUID(),
       p_violation_level       IN NUMBER, 
       p_violation_type        IN NUMBER   DEFAULT 0,
       p_violation_duration    IN NUMBER   DEFAULT NULL,
       p_annotated_flag        IN NUMBER   DEFAULT 0,
       p_notification_status   IN NUMBER   DEFAULT 1,
       p_value                 IN NUMBER   DEFAULT NULL,
       p_string_value          IN VARCHAR2 DEFAULT NULL,
       p_message               IN VARCHAR2 DEFAULT NULL,
       p_message_nlsid         IN VARCHAR2 DEFAULT NULL,
       p_message_params        IN VARCHAR2 DEFAULT NULL,
       p_action_message        IN VARCHAR2 DEFAULT NULL,
       p_action_nlsid          IN VARCHAR2 DEFAULT NULL,    
       p_action_message_params IN VARCHAR2 DEFAULT NULL,
       p_advisory_id           IN VARCHAR2 DEFAULT NULL,
       p_cfg_coll_name         IN VARCHAR2 DEFAULT NULL,
       p_cfg_key_value         IN VARCHAR2 DEFAULT NULL,
       p_cfg_key_operator      IN NUMBER   DEFAULT NULL,
       p_load_timestamp        IN DATE     DEFAULT SYSDATE,
       p_user_name             IN VARCHAR2 DEFAULT '<SYSTEM>');

  --
  -- Update a violation row.
  --
  PROCEDURE update_violation(
       p_target_guid           IN RAW,
       p_policy_guid           IN RAW,
       p_key_value             IN VARCHAR2,
       p_collection_timestamp  IN DATE,
       p_violation_level       IN NUMBER   DEFAULT NULL,
       p_violation_type        IN NUMBER   DEFAULT NULL,
       p_violation_duration    IN NUMBER   DEFAULT NULL,
       p_annotated_flag        IN NUMBER   DEFAULT NULL,
       p_notification_status   IN NUMBER   DEFAULT NULL,
       p_value                 IN NUMBER   DEFAULT NULL,
       p_string_value          IN VARCHAR2 DEFAULT NULL,
       p_message               IN VARCHAR2 DEFAULT NULL,
       p_message_nlsid         IN VARCHAR2 DEFAULT NULL,
       p_message_params        IN VARCHAR2 DEFAULT NULL,
       p_action_message        IN VARCHAR2 DEFAULT NULL,
       p_action_nlsid          IN VARCHAR2 DEFAULT NULL,    
       p_action_message_params IN VARCHAR2 DEFAULT NULL,
       p_advisory_id           IN VARCHAR2 DEFAULT NULL,
       p_cfg_coll_name         IN VARCHAR2 DEFAULT NULL,
       p_cfg_key_value         IN VARCHAR2 DEFAULT NULL,
       p_cfg_key_operator      IN NUMBER   DEFAULT NULL,
       p_load_timestamp        IN DATE     DEFAULT NULL,
       p_user_name             IN VARCHAR2 DEFAULT NULL);


  --
  -- Delete a violation row.
  --
  PROCEDURE delete_violation(
       p_target_guid           IN RAW,
       p_policy_guid           IN RAW,
       p_key_value             IN VARCHAR2,
       p_collection_timestamp  IN DATE);

  --
  -- Insert a violation contex row
  PROCEDURE add_violation_ctxt_row(
       p_target_guid           IN RAW,
       p_policy_guid           IN RAW,
       p_key_value             IN VARCHAR2,
       p_collection_timestamp  IN DATE,
       p_column_name           IN VARCHAR2,
       p_column_type           IN NUMBER,
       p_column_value          IN NUMBER,
       p_column_str_value      IN VARCHAR2);

  --
  -- Insert all the violation context list
  PROCEDURE add_violation_context(
       p_target_guid           IN RAW,
       p_policy_guid           IN RAW,
       p_key_value             IN VARCHAR2,
       p_collection_timestamp  IN DATE,
       p_violation_ctxt_list   IN MGMT_VIOL_NAME_VALUE_ARRAY DEFAULT NULL);
  --
  -- Function to log a threshold alert
  -- and return the violation guid of the alert
  --
  FUNCTION log_external_alert
    (p_producer_id          IN VARCHAR2,
     p_target_type          IN VARCHAR2,
     p_target_name          IN VARCHAR2,
     p_metric_name          IN VARCHAR2,
     p_metric_column        IN VARCHAR2,
     p_key_parts            IN MGMT_MEDIUM_STRING_ARRAY,
     p_collection_timestamp IN DATE ,
     p_violation_level      IN NUMBER,
     p_value                IN VARCHAR2,
     p_message              IN VARCHAR2
     -- TBD: notify status
     )
  RETURN RAW ;
 
  -- 
  -- Deletes the violation context for the given 
  --   target, policy, key, collection_timestamp
  PROCEDURE remove_violation_context(
       p_target_guid           IN RAW,
       p_policy_guid           IN RAW,
       p_key_value             IN VARCHAR2,
       p_collection_timestamp  IN DATE,
       p_column_name           IN VARCHAR2);



  PROCEDURE update_current_severity(p_target_guid    IN RAW,
                                    p_metric_guid    IN RAW,
				    p_collection_ts  IN DATE,
				    p_load_timestamp IN DATE,
				    p_severity_code  IN NUMBER,
				    p_severity_type  IN NUMBER,
				    p_severity_guid  IN RAW,
				    p_annotated_flag IN NUMBER,
				    p_key_value      IN VARCHAR2,
				    p_message        IN VARCHAR2,
				    p_message_nlsid  IN VARCHAR2,
				    p_message_params IN VARCHAR2,
				    p_action_message IN VARCHAR2,
				    p_action_nlsid  IN VARCHAR2,
				    p_action_message_params IN VARCHAR2,
                                    p_advisory_id IN VARCHAR2);


  PROCEDURE delete_current_severity(p_target_guid IN RAW,
                                    p_metric_guid IN RAW,
				    p_key_value   IN VARCHAR2);

  --
  -- Upsert the current violation
  --   
  PROCEDURE update_current_violation(p_target_guid     IN RAW,
                                     p_policy_guid     IN RAW,
				     p_key_value       IN VARCHAR2,
				     p_collection_ts   IN DATE DEFAULT NULL,
				     p_violation_guid  IN RAW DEFAULT NULL,
				     p_violation_level IN NUMBER DEFAULT NULL,
				     p_violation_type  IN NUMBER DEFAULT NULL,
				     p_annotated_flag  IN NUMBER DEFAULT NULL,
				     p_value           IN NUMBER DEFAULT NULL,
				     p_string_value    IN VARCHAR2 DEFAULT NULL,
				     p_message         IN VARCHAR2 DEFAULT NULL,
				     p_message_nlsid   IN VARCHAR2 DEFAULT NULL,
				     p_message_params  IN VARCHAR2 DEFAULT NULL,
				     p_action_message  IN VARCHAR2 DEFAULT NULL,
				     p_action_nlsid    IN VARCHAR2 DEFAULT NULL,
				     p_action_message_params IN VARCHAR2 DEFAULT NULL,
                                     p_advisory_id     IN VARCHAR2 DEFAULT NULL,
				     p_exempt_code     IN NUMBER   DEFAULT NULL,
				     p_exempt_until    IN DATE     DEFAULT NULL,
				     p_exempt_by       IN VARCHAR2 DEFAULT NULL,
                                     p_cfg_coll_name   IN VARCHAR2 DEFAULT NULL,
                                     p_cfg_key_value   IN VARCHAR2 DEFAULT NULL,
                                     p_cfg_key_operator IN NUMBER  DEFAULT NULL);

  --
  -- Delete current violation 
  PROCEDURE delete_current_violation(p_target_guid IN RAW,
                                     p_policy_guid IN RAW,
				     p_key_value   IN VARCHAR2);
  --
  -- procedure to convert the user entered key values into key values
  -- 
  PROCEDURE convert_keys(p_target_guid          IN RAW,
                         p_policy_guid          IN RAW,
                         p_key_values_in        IN mgmt_key_value_array,
                         p_collection_timestamp IN DATE,
                         p_num_keys             IN NUMBER,
                         p_key_values_out       OUT NOCOPY mgmt_medium_string_table); 


  --
  -- purge the severity life cycle which contains the target/policy/key
  -- and collection timestamp
  -- If no life cycle is found then no errors are returned
  -- if more than one life cycle contains it, it is a error
  --
  PROCEDURE purge_cycle(p_target_guid         IN RAW,
                        p_policy_guid          IN RAW,
                        p_key_value            IN VARCHAR2,
                        p_collection_timestamp IN DATE) ;

  --
  -- Purges all the closed severity life cycles of the target/policy/key value 
  -- combination before the collection timestamp. 
  -- p_target_guid : Target_guid for which severity needs to be purged
  -- p_policy_guid : Policy guid for which severity needs to be purged, 
  --                 for metric thresholds, this is metric_guid
  -- p_key_value_list : List of key_values, if null then all key values
  --                    are purged, for 0 key metrics, null is to be passed
  -- p_collection_timestamp: The timestamp before which the violations needs to 
  --                    be purged. If null, then all closed severities are
  --                    purged.
  --
  PROCEDURE purge_violations(p_target_guid          IN RAW,
                             p_policy_guid          IN RAW,
                             p_key_values           IN mgmt_medium_string_table,
                             p_collection_timestamp IN DATE) ;
  --
  -- clear all open alerts for the target/policy/key value combination
  -- p_key_values : list of key values, if null then all key values are cleared
  -- p_is_metric: if metric_guid is passed in p_policy_guid then this has to be
  --              set to TRUE
  --
  PROCEDURE clear_open_alerts(p_target_guid IN RAW,
                              p_policy_guid IN RAW,
                              p_key_values  IN mgmt_medium_string_table,
                              p_is_metric   IN BOOLEAN := FALSE,
                              p_clear_message IN VARCHAR2 DEFAULT NULL,
                              p_clear_nlsid   IN VARCHAR2 DEFAULT NULL) ;
  --
  -- Clear violations for a excepted key
  -- called when a key is excepted from policy evaluation
  --
  PROCEDURE clear_excepted_key
               (p_target_guid      IN RAW,
                p_policy_guid      IN RAW,
                p_cfg_coll_name    IN VARCHAR2,
                p_cfg_key_value    IN VARCHAR2,
                p_cfg_key_operator IN NUMBER
                );
  --
  -- Clear alerts for a key configuration
  -- Called when a threshold is deleted or set to null
  --
  PROCEDURE clear_alerts_for_key
              (p_object_guid      IN RAW,
               p_policy_guid      IN RAW,
               p_cfg_coll_name    IN VARCHAR2,
               p_cfg_key_value    IN VARCHAR2,
               p_cfg_key_operator IN NUMBER,
               p_clear_message    IN VARCHAR2 DEFAULT G_CLR_THRESHOLD_NULL_MSG,
               p_clear_nlsid      IN VARCHAR2 DEFAULT G_CLR_THRESHOLD_NULL_NLSID
               ) ;

  --
  -- Clear outstanding alerts and errors for a target/collection
  -- if a collection is disabled 
  -- if a collection is removed from a target
  --
  PROCEDURE clear_alerts
              (p_target_guid      IN RAW,
               p_policy_guid      IN RAW,
               p_cfg_coll_name    IN VARCHAR2,
               p_clear_message    IN VARCHAR2 DEFAULT NULL,
               p_clear_nlsid      IN VARCHAR2 DEFAULT NULL,
               p_is_metric        IN BOOLEAN  DEFAULT FALSE
              ) ;

  PROCEDURE update_current_availability(p_target_guid         IN RAW,
                                        p_current_status      IN NUMBER,
				        p_start_collection_ts IN DATE,
				        p_severity_guid       IN RAW DEFAULT NULL);

  PROCEDURE update_group_availability(p_target_guid         IN RAW);

  PROCEDURE update_availability_marker(p_target_guid   IN RAW,
                                       p_marker_ts     IN DATE,
                                       p_marker_status IN NUMBER  DEFAULT NULL,
				       p_log_error     IN BOOLEAN DEFAULT TRUE);

  PROCEDURE process_simple_avail(p_availability_rowid  IN  UROWID,
                                 p_target_guid         IN  RAW,
                                 p_current_status      IN  NUMBER,
				 p_severity_guid       IN  RAW,
				 p_start_collection_ts IN  DATE,
				 p_error               OUT INTEGER);

  PROCEDURE extend_avail_marker(p_target_guid      IN  RAW,
                                p_new_marker_ts    IN  DATE,
				p_new_avail_status IN  NUMBER,
				p_error            OUT INTEGER);


  
  PROCEDURE process_unreachable_start(p_target_guid IN RAW,
                                      p_curr_avail_start_ts IN DATE,
                                      p_curr_avail_rowid IN UROWID,
                                      p_violation_guid IN RAW,
                                      p_error OUT VARCHAR2);

   
  PROCEDURE process_unreachable_clear(p_target_guid   IN     RAW,
                                      p_new_marker_ts IN     DATE,
	                              p_message       IN OUT VARCHAR2,
	                              p_error         OUT    INTEGER,
                                      p_message_nlsid IN OUT VARCHAR2,
                                      p_message_params IN OUT VARCHAR2,
                                      p_new_avail_status IN OUT NUMBER);

  PROCEDURE process_agent_down_sev(p_target_guid   IN  RAW,
                                   p_coll_ts       IN  DATE,
                                   p_emd_url       IN  VARCHAR2, 
                                   p_curr_stat     IN  NUMBER,
				   p_error         OUT INTEGER);

  PROCEDURE process_agent_up_sev(p_target_guid   IN  RAW,
                                 p_coll_ts       IN  DATE,
                                 p_emd_url       IN  VARCHAR2, 
                                 p_curr_stat     IN  NUMBER,
				 p_error         OUT INTEGER);

  FUNCTION state_matches_preblkout_state(p_target_guid IN RAW,
                                         p_violation_level IN NUMBER)
    RETURN NUMBER;

  PROCEDURE get_severity_segments(target_name_in  IN  VARCHAR2,
                                  target_type_in  IN  VARCHAR2,
                                  metric_name_in  IN  VARCHAR2,
                                  metric_col_in   IN  VARCHAR2,
                                  metric_guid_in  IN  RAW,
                                  key_value_in    IN  VARCHAR2,
                                  start_date_in   IN  DATE,
                                  end_date_in     IN  DATE,
                                  num_of_days_in  IN  NUMBER,
                                  pixel_size_in   IN  NUMBER,
                                  chart_record_out OUT EM_SEVERITY_HISTORY_ARRAY);

  PROCEDURE get_severity_labels(target_name_in   IN  VARCHAR2,
                                target_type_in   IN  VARCHAR2,
                                metric_name_in   IN  VARCHAR2,
                                metric_col_in    IN  VARCHAR2,
                                member_status_in IN  VARCHAR2,
                                start_date_in    IN  DATE,
                                end_date_in      IN  DATE,
                                num_of_days_in   IN  NUMBER,
                                display_name_out OUT VARCHAR2,
                                chart_data_out   OUT MGMT_TARGET.CURSOR_TYPE,
                                target_tzrgn_out OUT VARCHAR2);

  PROCEDURE log_error(target_guid_in IN RAW,
                      error_code_in  IN NUMBER,
		      error_msg_in   IN VARCHAR2);

  FUNCTION is_agent_unreachable(p_target_guid IN RAW) 
    RETURN BOOLEAN;

  FUNCTION get_agent_guid(p_target_guid IN RAW)
    RETURN RAW;

  FUNCTION get_status_order(p_current_status IN NUMBER)
    RETURN INTEGER;

  FUNCTION get_avail_cursor(p_target_guid IN RAW)
    RETURN AVAIL_CURSOR;

  FUNCTION get_avail_cursor_between(p_target_guid  IN RAW,
                                    p_start_marker IN DATE,
				    p_end_marker   IN DATE)
    RETURN AVAIL_CURSOR;
 
  FUNCTION get_severity_string(p_severity_code IN NUMBER)
    RETURN VARCHAR2;

  FUNCTION get_avail_string(p_avail_status IN NUMBER)
    RETURN VARCHAR2;

  -- Purge policies callbacks
  PROCEDURE SEVERITY_PURGE(pcb_params IN OUT MGMT_PURGE_CALLBACK_PARAMS);

  PROCEDURE STATELESS_SEVERITY_CLEAR(pcb_params IN OUT MGMT_PURGE_CALLBACK_PARAMS);

  PROCEDURE AVAILABILITY_PURGE(pcb_params IN OUT MGMT_PURGE_CALLBACK_PARAMS);

  
  -- Procedure for deletion of all violation based on target_guid, metric_guid and key-value
  -- Would be call by callback EM_METRIC.handle_metric_keyval_deletion

  PROCEDURE del_keyval_violation
  (
    p_target_guid  IN mgmt_targets.target_guid%TYPE,
    p_metric_guid  IN mgmt_metrics.metric_guid%TYPE,
    p_key_value    IN mgmt_metrics_raw.key_value%TYPE
  );

  -- Procedure for deletion of current violation based on target_guid, metric_guid and key-value
  -- Would be call by callback EM_METRIC.metric_keyval_deletion_sync

  PROCEDURE del_keyval_curr_violation
  (
    p_target_guid  IN mgmt_targets.target_guid%TYPE,
    p_metric_guid  IN mgmt_metrics.metric_guid%TYPE,
    p_key_value    IN mgmt_metrics_raw.key_value%TYPE
  );

  -- Internal procedure. Not to be called from outside except
  -- EM_POLICY.delete_policy_data.
  -- This procedure deletes all violations related record from other tables
  -- based on I/P violation guid collection.

  PROCEDURE purge_for_violation_guids
  (
    p_violation_guids    IN  MGMT_TARGET_GUID_ARRAY,
    p_annot_purged       OUT NUMBER,
    p_notify_log_purged  OUT NUMBER,
    p_notify_rq          OUT NUMBER
  );

  --wrapper function to get the OUT variable as NUMBER
 FUNCTION is_sev_in_blackout_wrap(p_target_guid IN RAW,
                              p_coll_ts     IN DATE)
    RETURN NUMBER;

 -- execute the callback registered for crs_event metric cluster target type. 
 PROCEDURE exec_crs_event_callbacks(p_violation IN MGMT_VIOLATION_SUMMARY_REC,
                                    p_save_violation OUT NUMBER);
 --
 -- Applicable only for beacon managed target
 -- FUNCTIOn to check the pre no_beacon_data severity
 -- If it is same as current violation level
 -- then ignore notification
 -- 
 FUNCTION viol_matches_pre_state
  (
    p_target_guid mgmt_violations.target_guid%type,
    p_policy_guid mgmt_violations.policy_guid%type,
    p_key_value mgmt_violations.key_value%type,
    p_new_viol_level NUMBER
  ) RETURN BOOLEAN ;

---------------------------------------------------------
-- Package Error Codes
---------------------------------------------------------
e_no_error           CONSTANT INTEGER := 0;

e_bad_params         CONSTANT INTEGER := 1;

e_no_avail_marker    CONSTANT INTEGER := 2;

---------------------------------------------------------
-- Package Exceptions
---------------------------------------------------------
severity_exception   EXCEPTION;

END EM_SEVERITY;
/
show errors;


