Rem drv: <create type="post_creation" pos="self_monitor/self_monitor_post_creation.sql-"/>
Rem
Rem $Header: severity_post_creation.sql 05-aug-2005.13:16:52 gan Exp $
Rem
Rem severity_post_creation.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      severity_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gan         08/05/05 - add repo sev parameter 
Rem    scgrover    07/07/05 - add extended sql trace 
Rem    gsbhatia    07/03/05 - New repmgr header impl 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    rpinnama    10/31/03 - Disable severity purge for central mode 
Rem    rpinnama    09/07/03 - Add severity purge policy 
Rem    aholser     08/15/03 - fix register 
Rem    rpinnama    07/03/03 - Move job submission to emd_maintenance.submit_em_dbms_jobs procedure
Rem    streddy     04/08/03 - Add severity eval job
Rem    rpinnama    10/18/02 - rpinnama_bug-2472358
Rem    rpinnama    10/18/02 - Created
Rem

-- Initialize performance names.
BEGIN
  mgmt_log.register_logging_module ('SEVERITY TRIGGER', 'Severity Sub system');
  mgmt_log.register_logging_module ('SEVERITY EVALUATION', 'Severity Evaluation Sub system','EM_SEVERITY_REPOS.EXECUTE_REPOS_SEVERITY_EVAL()');
  COMMIT;

END;
/

BEGIN
  -- Purge policy for MGMT_SEVERITY
  EM_PURGE.add_purge_policy('MGMT_SEVERITY',
                            EM_PURGE.G_POLICY_TYPE_TARGET,
                            'EM_SEVERITY.SEVERITY_PURGE',
                            0,
                            NULL, -- No rollup procedure
                            'Purge policy for Closed Severities.',
                            EM_PURGE.G_RETENTION_GROUP_ALERTS
                            );

  -- Disable the severity purge for central mode
  -- This has to be enabled once rollup for severities is supported.
  IF '&EM_REPOS_MODE' = 'CENTRAL' THEN
    EM_PURGE.disable_purge_policy('MGMT_SEVERITY');
  END IF;

  -- Purge policy for clearing stateless severities
  EM_PURGE.add_purge_policy('MGMT_STATELESS_SEVERITY',
                            EM_PURGE.G_POLICY_TYPE_TARGET,
                            'EM_SEVERITY.STATELESS_SEVERITY_CLEAR',
                            0,
                            NULL,
                            'Purge policy for Clearing Stateless Severities.',
                            EM_PURGE.G_RETENTION_GROUP_LVL2_SUMMARY
                            );

  -- Purge policy for availability data
  EM_PURGE.add_purge_policy('MGMT_AVAILABILITY',
                            EM_PURGE.G_POLICY_TYPE_TARGET,
                            'EM_SEVERITY.AVAILABILITY_PURGE',
                            0,
                            NULL, -- No rollup procedure
                            'Purge policy for Purging availability data.',
                            EM_PURGE.G_RETENTION_GROUP_ALERTS
                            );
  COMMIT;
END;
/

@@&&EM_SQL_ROOT/core/v102020/severity_data_upgrade.sql

-- insert REPO_SEV_ENABLE_OPT into mgmt_parameters table
BEGIN
  INSERT into mgmt_parameters (parameter_name, parameter_value, parameter_comment,
                              internal_flag)
          VALUES('REPO_SEV_ENABLE_OPT', '1', 'Enable (1) repository target severity calculation optimization',  1);
  COMMIT;
EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
    NULL;
END;
/
show errors;
