Rem
Rem $Header: severity_repos_pkgdef.sql 07-may-2007.04:49:49 neearora Exp $
Rem
Rem severity_repos_pkgdef.sql
Rem
Rem Copyright (c) 2003, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      severity_repos_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    neearora   05/07/07 - Backport neearora_bug-5116622 from main
Rem    neearora   04/23/07 - bug 5116622
Rem    scgrover   07/07/05 - add extended sql trace 
Rem    gan        06/07/05 - no sev for get_dependencies 
Rem    streddy    04/17/05 - Handle all member blackout case 
Rem    jsadras    03/17/05 - Bug:4148617, change to CONSTANT 
Rem    neearora   03/06/05 - Removed entry for debug_enabled 
Rem    streddy    01/09/05 - Added sync_eval_target_severities 
Rem    streddy    10/12/04 - Add timezone support 
Rem    streddy    09/14/04 - Add rs_metric to evaluate_metric_severity 
Rem    streddy    08/17/04 - Added evaluate_target_severities 
Rem    streddy    04/25/03 - Add constants for performance logging
Rem    streddy     04/16/03 - Handle unreachable states correctly
Rem    streddy     04/09/03 - streddy_composite_target_availability
Rem    streddy     03/31/03 - Created
Rem

CREATE OR REPLACE PACKAGE EM_SEVERITY_REPOS AS

--
-- Constants
--
MODULE CONSTANT VARCHAR2(64) := 'SEVERITY EVALUATION';
REPOSITORY_COLLECTION CONSTANT VARCHAR2(32) := 'Repository_Collection';
SEVERITY_EVALUATION_ACTION VARCHAR2(32) := 'SEVERITY EVALUATION';
TARGETS_PROCESSED_CNT_NAME CONSTANT VARCHAR2(32) := 'TARGETS_EVALUATED';
SEVERITIES_GENERATED_CNT_NAME CONSTANT VARCHAR2(32) := 'SEVERITIES_GENERATED';
ERRORS_ENCOUNTERED_CNT_NAME CONSTANT VARCHAR2(32) := 'EVALUATION_ERRORS';

-- counters for performance logging
p_target_cnt        NUMBER;
p_severity_cnt      NUMBER;
p_error_cnt         NUMBER;

NO_NEW_SEVERITY CONSTANT NUMBER(1) := -1;
NO_OLD_SEVERITY CONSTANT NUMBER(1) := -2;

EST_SEVERITY_NAME CONSTANT VARCHAR2(32) := 'EST_SEVERITY';

-- 
-- Error messages
--
E_SEV_EVAL_PROC_ERR     CONSTANT  INTEGER := -20200;
E_SEV_EVAL_PROC_ERR_M   CONSTANT  VARCHAR2(64) := 
               'Received an exception when evaluating sev_eval_proc for:'; 
sev_eval_proc_not_found EXCEPTION;
PRAGMA EXCEPTION_INIT(sev_eval_proc_not_found, -20200);

E_UNSUPPORTED_ERR CONSTANT  INTEGER := -20201;
E_UNSUPPORTED_ERR_M  CONSTANT VARCHAR2(256) := 'Cannot calculate severities on the repository side for the target because response/status metric is not defined as repository metric';
unsupported_target EXCEPTION;
PRAGMA EXCEPTION_INIT(unsupported_target, -20202);

E_CALLBACK_ERR     CONSTANT  INTEGER := -20203;
E_CALLBACK_ERR_M   CONSTANT VARCHAR2(64) := 'Callback failed with an error ';
sev_eval_proc_not_found EXCEPTION;
PRAGMA EXCEPTION_INIT(sev_eval_proc_not_found, -20203);

PROCEDURE DBMSJOB_EXTENDED_SQL_TRACE_ON(p_value IN BOOLEAN);

-- Procedure to synchronously evaluate severities parent target
-- severities based on member target severities
PROCEDURE SYNC_EVAL_PARENT_SEVERITIES(v_memb_target_guid IN RAW);

-- Procedure to synchronously evaluate status of the specified
-- target
PROCEDURE SYNC_EVAL_TARGET_SEVERITIES(v_target_guid IN RAW);

-- Procedure to evaluate severities for a single target
PROCEDURE EVALUATE_TARGET_SEVERITIES(v_target_guid IN RAW,
                                     v_sync_eval IN BOOLEAN DEFAULT FALSE);

-- Job that drives the severity evaluatio<n process
PROCEDURE EXECUTE_REPOS_SEVERITY_EVAL( p_target_guid RAW DEFAULT NULL);


--
-- INTERNAL FUNCTIONS/PROCEDURES -- These are the added to the package
-- definition for testing purposes. DO NOT CALL THEM FROM EXTERNAL
-- PACKAGES
-- 


-- get dependency metric array for a given metric
FUNCTION get_dependencies(v_target_guid IN RAW,
                          v_metric_guid IN RAW,
                          v_key_value   IN VARCHAR2,
                          v_timestamp   IN DATE DEFAULT NULL,
                          v_fetch_sevs  IN BOOLEAN DEFAULT TRUE)
  RETURN MGMT_METRIC_DETAILS_ARRAY;


-- get the minimum availability marker of the reachable member targets
PROCEDURE calc_dep_avail_marker(v_dep_array IN MGMT_METRIC_DETAILS_ARRAY,
                                v_curr_marker IN DATE,
                                v_all_membs_unrch OUT BOOLEAN,
                                v_all_membs_blkout OUT BOOLEAN,
                                v_max_marker  OUT DATE);

-- evaluates all non response/status severities of a target in the
-- specified time range
PROCEDURE evaluate_non_rs_severities(v_target_guid IN RAW,
                                     v_rs_metric_guid IN RAW,
                                     v_start_ts    IN DATE,
                                     v_end_ts      IN DATE,
                                     v_force_eval  IN NUMBER);



-- evaluates the severity of a single metric
PROCEDURE evaluate_metric_severity(v_target_guid IN RAW,
                                   v_metric_guid IN RAW,
                                   v_key_value   IN VARCHAR2 DEFAULT ' ',
                                   v_start_ts    IN DATE,
                                   v_end_ts      IN DATE,
                                   v_sev_code    OUT NUMBER,
                                   v_rs_metric   IN BOOLEAN DEFAULT TRUE,
                                   v_force_eval  IN NUMBER DEFAULT 0);

-- Internal helper function to check the compatibility of status and severity codes
FUNCTION status_sev_out_of_sync(v_status_code IN NUMBER, v_sev_code IN NUMBER)
   RETURN BOOLEAN;

-- Internal procedure to the set status of a target corresponding to the 
-- severity code
PROCEDURE set_target_status(v_target_guid IN RAW, 
                            v_metric_guid IN RAW, 
                            v_sev_code    IN NUMBER,  
                            v_timestamp   IN DATE,
	                    v_message     IN VARCHAR2,
	                    v_message_nlsid   IN VARCHAR2,
	                    v_message_params  IN VARCHAR2);

-- Variables to simulate error conditions
p_neg_test1_enabled BOOLEAN := FALSE;
p_neg_test2_enabled BOOLEAN := FALSE;


END EM_SEVERITY_REPOS;
/
show errors;
