Rem drv: <create type="tables" pos="security/security_tables.plb+"/>
Rem
Rem $Header: severity_tables.sql 21-jun-2007.00:47:26 neearora Exp $
Rem
Rem severity_tables.sql
Rem
Rem Copyright (c) 2002, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      severity_tables.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    neearora    06/21/07 - removed default value for acknowledged and
Rem                           acknowledged_by
Rem    neearora    05/06/07 - ER 5958873
Rem    jsadras     07/04/05 - Add cfg_ columns to current_violation 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    rpinnama    06/10/05 - Bug 4345566 : Store last violation in a separete 
Rem                           table for faster lookups 
Rem    rpinnama    05/17/05 - Change violation_duration default to NULL 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    jsadras     12/23/04 - length key_value 
Rem    jsadras     12/06/04 - cycle_guid
Rem    groyal      09/23/04 - Change default of 
Rem                           MGMT_CURRENT_VIOLATION.EXEMPT_BY 
Rem    rpinnama    09/13/04 - Remove mgmt_severity, mgmt_current_severity 
Rem    rpinnama    09/09/04 - Add cfg_coll_name, cfg_key_value, 
Rem                           cfg_key_operator columns to mgmt_violations 
Rem                           table 
Rem    rpinnama    06/17/04 - Add violation tables. 
Rem    streddy     07/10/03 - Add mgmt_severity_annotation view
Rem    mbhoopat    05/13/03 - Add cols to severity for server alerts
Rem    xxu         01/14/03 - add nlsid
Rem    tjaiswal    07/09/02 - Obsolete mgmt annotations table
Rem    rpinnama    07/09/02 - Modify comments to reflect severity codes
Rem    rpinnama    05/14/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/14/02 - Created
Rem

rem
rem  PURPOSE
rem
rem     The MGMT_VIOLATIONS table contains the violation information that was
rem     collected on the target system.  Severities are alerts that inform the
rem     user when a threshold/policy that was established on a target has been exceeded.
rem
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     COLLECTION_TIMESTAMP
rem                 - the date/time when the alert was triggered
rem
rem     POLICY_GUID
rem                 - A unique ID for the policy rule.
rem
rem     LOAD_TIMESTAMP
rem                 - the date/time when the severity was loaded
rem
rem     VIOLATION_LEVEL
rem                 - The event violation level for error, warning, critical, etc.
rem                   These codes are backward compatible to EM 9i.
rem
rem                         0 - non up/down severity occurence
rem                         1 - up/down severity occurence
rem                         3 - severity registration/deregistration
rem                        10 - use to identify annotation records
rem                        15 - clear
rem                        20 - warning
rem                        25 - alert
rem                       125 - agent unreachable
rem                       115 - agent unreachable clear
rem                       225 - blackout start
rem                       215 - blackout end
rem                       325 - metric evaluation error start
rem                       315 - metric evaluation error end
rem
rem     VIOLATION_DURATION      -  The delta time, in hours, from when the
rem                               violation was logged until it was cleared.
rem
rem     NOTIFICATION_STATUS
rem                 - This field is used by the notifcation subsystem to
rem                   determine the status of the severity.
rem
rem                         0 - CLEARED
rem                         1 - NEW
rem                         2 - DELIVERED
rem                         3 - ESCALATED
rem                         4 - UNHANDLED
rem                         5 - BEING_RETRIED
rem
rem     KEY_VALUE   - If the metric defined at collection time is a TABLE type, the
rem                   value of the column in the table that is designated as the
rem                   key for the row that identifies the value of this metric should
rem                   be written here.  This information is used during reporting to
rem                   uniquely identify the specific value in the table that was
rem                   collected.  KEY_VALUE is the identifying row.  Together with the
rem                   target name, target type, and metric name, the metric value can be
rem                   uniquely identified.  This allows us to flatten tables of metrics into
rem                   simple metric values.  For example, the value in this table might
rem                   be \usr if we were storing the SpaceUsed metric.
rem
rem     MESSAGE      - The content of the alert.  Alerts are sent as messages that
rem                    provide more details about what triggered the condition.
rem
rem     MESSAGE_NLSID
rem
rem                  - The nlsid of the severity message.
rem
rem     MESSAGE_PARAMS
rem
rem                  - URL encoded parameters separated by "&" to be used to format the severity message
rem
rem     ACTION_MESSAGE - Suggested action message in english for the severity
rem
rem     ACTION_NLSID - NLS id of action message 
rem
rem     ACTION_MESSAGE_PARAMS - Encoded parameters for translating ACTION_NLSID
rem
rem     ADVISORY_ID - Id of the advisory for the severity
rem
rem     ANNOTATED_FLAG
rem                  - This flag is used by the availability reporting mechanism to
rem                    determine whether a severity row has been annotated.  
rem
rem     VIOLATION_TYPE
rem                  - The severity type allows an application that is selecting
rem                     from this table to filter the rows returned by the type of
rem                     severity.  Values in this column are:
rem
rem                          0 - METRIC THREHOLD ALERT
rem                          1 - AVAILABILITY
rem                          3 - POLICY
rem
rem  NOTES
rem
rem
rem     The severity table currently serves two purposes:
rem
rem        1)  A log for any serverities that are triggered at the target for a metric
rem
rem        2)  A log for availability metric reporting
rem
rem     Severities can not be logged unless metric data exists for the metric that
rem     is triggering the severity.  When the metric definition is removed from the
rem     schema, the associated severity information will also be removed.
rem


CREATE TABLE mgmt_violations
(
    target_guid           RAW(16)        NOT NULL,
    policy_guid           RAW(16)        NOT NULL,
    key_value             VARCHAR2(256)  DEFAULT ' ',
    collection_timestamp  DATE           DEFAULT SYSDATE,
    violation_guid        RAW(16)        DEFAULT SYS_GUID(),
    violation_level       NUMBER         NOT NULL,
    violation_type        NUMBER         DEFAULT 0 NOT NULL,
    violation_duration    NUMBER         DEFAULT NULL,
    annotated_flag        NUMBER         DEFAULT 0,
    notification_status   NUMBER         DEFAULT 1,
    value                 NUMBER         DEFAULT NULL,
    string_value          VARCHAR2(1024) DEFAULT NULL,
    message               VARCHAR2(4000) DEFAULT NULL,
    message_nlsid         VARCHAR2(64)   DEFAULT NULL, 
    message_params        VARCHAR2(4000) DEFAULT NULL,
    action_message        VARCHAR2(4000) DEFAULT NULL,
    action_message_nlsid  VARCHAR2(64)   DEFAULT NULL,
    action_message_params VARCHAR2(4000) DEFAULT NULL,
    advisory_id           VARCHAR2(64)   DEFAULT NULL,
    cfg_coll_name         VARCHAR2(64)   DEFAULT NULL,
    cfg_key_value         VARCHAR2(256)  DEFAULT NULL,
    cfg_key_operator      NUMBER         DEFAULT NULL,
    load_timestamp        DATE           DEFAULT SYSDATE,
    user_name             VARCHAR2(64)   DEFAULT '<SYSTEM>',
    cycle_guid            RAW(16),        
    acknowledged          NUMBER(1),
    acknowledged_by       VARCHAR2(256)  
)
MONITORING;

COMMENT ON TABLE mgmt_violations IS
    'The MGMT_VIOLATIONS table contains the violation information.
    Violations are alerts that inform the user when a metric threshold
    Test or a policy violation has failed.';

COMMENT ON COLUMN mgmt_violations.target_guid IS
    ' The target guid of the violation';

COMMENT ON COLUMN mgmt_violations.policy_guid IS
    ' The policy rule guid of the violation';

COMMENT ON COLUMN mgmt_violations.key_value IS
    ' The key value of the violation';

COMMENT ON COLUMN mgmt_violations.collection_timestamp IS
    ' The timestamp at which the violation occurred';

COMMENT ON COLUMN mgmt_violations.violation_guid IS
    ' The unique id of the violation. Defaults to SYS_GUID()';

COMMENT ON COLUMN mgmt_violations.violation_level IS
    'The severity codes for error, warnin, critical etc.
    These codes are backwards compatible with EM 9i and EM 10gR1.
      15 - CLEAR
      18 - INFO
      20 - WARNING
      25 - CRITICAL
     115 - AGENT UNREACHABLE CLEART
     125 - AGENT UNREACHABLE START
     215 - BLACKOUT END
     225 - BLACKOUT START
     315 - METRIC ERROR END
     325 - METRIC ERROR START
    Codes 115 and above are applicable only for response/status metric';
    
COMMENT ON COLUMN mgmt_violations.violation_type IS
    ' The severity type allows an application that is selecting
      from this table to filter the rows returned by the type of
      severity.  Values in this column are:
           0 - METRIC THRESHOLD ALERT
           1 - AVAILABILITY
           3 - POLICY VIOLATION';

COMMENT ON COLUMN mgmt_violations.violation_duration IS
    'The delta time, in hours, from when the severity was logged
    until it was cleared.';
    
COMMENT ON COLUMN mgmt_violations.annotated_flag IS
   'A flag to indicate whether the severity is annotated or not.';
    
COMMENT ON COLUMN mgmt_violations.notification_status IS
   'The column used by the notification sub system to determine
    notification status of the severity.'; 
    
COMMENT ON COLUMN mgmt_violations.value IS
   'The numeric value of the column that violated the threshold. This column is
    populated if the threshold violation is for numeric metric column.';

COMMENT ON COLUMN mgmt_violations.string_value IS
   'The string value of the column that violated the threshold. This column is 
    populated if the thresholded violation is for a string metric column.';

COMMENT ON COLUMN mgmt_violations.message IS
    'The message of the severity.  The messages usually contain
    details about what triggered this severity.';

COMMENT ON COLUMN mgmt_violations.message_nlsid IS
    'The NLS ID of the severity message.';

COMMENT ON COLUMN mgmt_violations.message_params IS
    'URL encoded parameters separated by "&" to be used to
    format the severity message.';

COMMENT ON COLUMN mgmt_violations.action_message IS
    'Suggested action message in english for this severity';

COMMENT ON COLUMN mgmt_violations.action_message_nlsid IS
    'The NLS ID of the action message.';

COMMENT ON COLUMN mgmt_violations.action_message_params IS
    'URL encoded parameters for translating action message';

COMMENT ON COLUMN mgmt_violations.advisory_id IS
    'Advisory ID of the severity';

COMMENT ON COLUMN mgmt_violations.cfg_coll_name IS
    'The name of the collection that triggered the violation.';

COMMENT ON COLUMN mgmt_violations.cfg_key_value IS
    'The key value of the key configuration that trigged the violation.';

COMMENT ON COLUMN mgmt_violations.cfg_key_operator IS
    'The key operator of the key configuration that trigged the violation.';

COMMENT ON COLUMN mgmt_violations.load_timestamp IS
    'Date and time when the severity was loaded';

COMMENT ON COLUMN mgmt_violations.user_name IS
    'Name of the user to load the severity';

COMMENT ON COLUMN mgmt_violations.cycle_guid IS
    'Violation Guid of the first violation in the severity life cycle, this is meant
     to easily identify to which life cycle a violation belongs to' ;

COMMENT ON COLUMN mgmt_violations.acknowledged IS
    'Flag to indicate whether this violation has been acknowledged or not';

COMMENT ON COLUMN mgmt_violations.acknowledged_by IS
    'Name of the use who acknowledged this violation record';

rem
rem  PURPOSE
rem
rem     The mgmt_current_violation table contains the current severity for a metric.
rem     This table was created to improve the performance of queries requesting the
rem     current severity information for a metric.
rem
rem
rem  COLUMNS
rem
rem     See MGMT_VIOLATIONS
rem
rem
rem  NOTES
rem
rem     Once the loader mechanism support is added for this table, then we
rem     will change the current severity view to use it.
rem
rem     The primary key for this table doesn't include the timestamp.  We
rem     only want one record in this table for each metric.
rem

CREATE TABLE mgmt_current_violation
(
    target_guid           RAW(16)        NOT NULL,
    policy_guid           RAW(16)        NOT NULL,
    key_value             VARCHAR2(256)  DEFAULT ' ',
    collection_timestamp  DATE           DEFAULT SYSDATE,
    violation_guid        RAW(16)        DEFAULT SYS_GUID(),
    violation_level       NUMBER         NOT NULL,
    violation_type        NUMBER         DEFAULT 0 NOT NULL,
    annotated_flag        NUMBER         DEFAULT 0,
    value                 NUMBER         DEFAULT NULL,
    string_value          VARCHAR2(1024) DEFAULT NULL,
    message               VARCHAR2(4000) DEFAULT NULL,
    message_nlsid         VARCHAR2(64)   DEFAULT NULL,
    message_params        VARCHAR2(4000) DEFAULT NULL,
    action_message        VARCHAR2(4000) DEFAULT NULL,
    action_message_nlsid  VARCHAR2(64)   DEFAULT NULL,
    action_message_params VARCHAR2(4000) DEFAULT NULL,
    advisory_id           VARCHAR2(64)   DEFAULT NULL,
    exempt_code           NUMBER         DEFAULT 0,
    exempt_until          DATE           DEFAULT NULL,
    exempt_by             VARCHAR2(256)  DEFAULT NULL,
    load_timestamp        DATE           DEFAULT SYSDATE,
    cfg_coll_name         VARCHAR2(64)   DEFAULT NULL,
    cfg_key_value         VARCHAR2(256)  DEFAULT NULL,
    cfg_key_operator      NUMBER         DEFAULT NULL
)
MONITORING;

COMMENT ON TABLE mgmt_current_violation IS
    'The MGMT_CURRENT_VIOLATION table contains the information about
     active violations.'

COMMENT ON COLUMN mgmt_current_violation.target_guid IS
    ' The target guid of the active violation';

COMMENT ON COLUMN mgmt_current_violation.policy_guid IS
    ' The policy rule guid of the active violation';

COMMENT ON COLUMN mgmt_current_violation.key_value IS
    ' The key value of the active violation';

COMMENT ON COLUMN mgmt_current_violation.collection_timestamp IS
    ' The timestamp at which the violation occurred';

COMMENT ON COLUMN mgmt_current_violation.violation_guid IS
    ' The unique id of the violation. Defaults to SYS_GUID()';

COMMENT ON COLUMN mgmt_current_violation.violation_level IS
    'The severity codes for error, warnin, critical etc.
    These codes are backwards compatible with EM 9i anad EM 10gR1.
      15 - CLEAR
      18 - INFO
      20 - WARNING
      25 - CRITICAL
     115 - AGENT UNREACHABLE CLEART
     125 - AGENT UNREACHABLE START
     215 - BLACKOUT END
     225 - BLACKOUT START
     315 - METRIC ERROR END
     325 - METRIC ERROR START
    Codes 115 and above are applicable only for response/status metric';
    
COMMENT ON COLUMN mgmt_current_violation.violation_type IS
    ' The severity type allows an application that is selecting
      from this table to filter the rows returned by the type of
      severity.  Values in this column are:
           0 - METRIC THRESHOLD ALERT
           1 - AVAILABILITY
           3 - POLICY VIOLATION';

COMMENT ON COLUMN mgmt_current_violation.annotated_flag IS
   'A flag to indicate whether the severity is annotated or not.';

COMMENT ON COLUMN mgmt_current_violation.value IS
   'The numeric value of the column that violated the threshold. This column is 
    populated if the threshold violation is for numeric metric column.';

COMMENT ON COLUMN mgmt_current_violation.string_value IS
   'The string value of the column that violated the threshold. This column is   
    populated if the thresholded violation is for a string metric column.';

COMMENT ON COLUMN mgmt_current_violation.message IS
    'The message of the severity.  The messages usually contain
    details about what triggered this severity.';

COMMENT ON COLUMN mgmt_current_violation.message_nlsid IS
    'The NLS ID of the severity message.';

COMMENT ON COLUMN mgmt_current_violation.message_params IS
    'URL encoded parameters separated by "&" to be used to
    format the severity message.';

COMMENT ON COLUMN mgmt_current_violation.action_message IS
    'Suggested action message in english for this severity';

COMMENT ON COLUMN mgmt_current_violation.action_message_nlsid IS
    'The NLS ID of the action message.';

COMMENT ON COLUMN mgmt_current_violation.action_message_params IS
    'URL encoded parameters for translating action message';

COMMENT ON COLUMN mgmt_current_violation.advisory_id IS
    'Advisory ID of the severity';

COMMENT ON COLUMN mgmt_current_violation.load_timestamp IS
    'Date and time when the severity was loaded';

COMMENT ON COLUMN mgmt_current_violation.exempt_code IS
    'Indication of exemption status.  Legal values:
       0 - not exempt
       1 - exempt indefinitely
       2 - exempt until date specified in EXEMPT_UNTIL
       3 - exempt until next evaluation
     Default 0';

COMMENT ON COLUMN mgmt_current_violation.cfg_coll_name IS
    'The name of the collection that triggered the violation.';

COMMENT ON COLUMN mgmt_current_violation.cfg_key_value IS
    'The key value of the key configuration that trigged the violation.';

COMMENT ON COLUMN mgmt_current_violation.cfg_key_operator IS
    'The key operator of the key configuration that trigged the violation.';

COMMENT ON COLUMN mgmt_current_violation.exempt_until IS
    'Only application if EXEMPT_CODE is 2.  Specifies date
     until which exemption should be applied.';

COMMENT ON COLUMN mgmt_current_violation.exempt_by IS
    'The username of the EM user who applied the exemption.';




CREATE TABLE mgmt_violation_context
(
    target_guid           RAW(16)        NOT NULL,
    policy_guid           RAW(16)        NOT NULL,
    key_value             VARCHAR2(256)  DEFAULT ' ',
    collection_timestamp  DATE           DEFAULT SYSDATE,
    column_name           VARCHAR2(64)   DEFAULT ' ',
    column_type           NUMBER         DEFAULT 1,
    column_value          NUMBER         DEFAULT NULL,  
    column_str_value      VARCHAR2(4000) DEFAULT NULL
)
MONITORING;

COMMENT ON TABLE mgmt_violation_context IS
    'The MGMT_VIOLATION_CONTEXT table contains additional information about
     violations.'
    
COMMENT ON COLUMN mgmt_violation_context.target_guid IS
    ' The target guid of the violation for which the context is stored.';

COMMENT ON COLUMN mgmt_violation_context.policy_guid IS
    ' The policy rule guid of the violation for which the context is stored.';

COMMENT ON COLUMN mgmt_violation_context.key_value IS
    ' The key value of the violation for which the context is stored.';

COMMENT ON COLUMN mgmt_violation_context.collection_timestamp IS
    ' The timestamp at which the violation occurred';

COMMENT ON COLUMN mgmt_violation_context.column_name IS
    ' The name of the column of the violation context';

COMMENT ON COLUMN mgmt_violation_context.column_type IS
    ' The type of the column_name';

COMMENT ON COLUMN mgmt_violation_context.column_value IS
    ' The numeric value of the column name when the violation happened.
      Valid only if the column_type is NUMERIC.';

COMMENT ON COLUMN mgmt_violation_context.column_str_value IS
    ' The string value of the column_name when the violation happened.
      Applicable only if the column type is STRING. ';


CREATE TABLE mgmt_last_violation
(
    target_guid           RAW(16)        NOT NULL,
    policy_guid           RAW(16)        NOT NULL,
    key_value             VARCHAR2(256)  DEFAULT ' ',
    collection_timestamp  DATE           DEFAULT SYSDATE,
    CONSTRAINT mgmt_last_violation_pk
       PRIMARY KEY (target_guid, policy_guid, key_value)
)
ORGANIZATION INDEX 
COMPRESS 2 INITRANS 4
MONITORING;

COMMENT ON TABLE mgmt_last_violation IS
    'The MGMT_LAST_VIOLATION table contains details about the last violation.'

COMMENT ON COLUMN mgmt_last_violation.target_guid IS
    ' The target guid of the last violation.';

COMMENT ON COLUMN mgmt_last_violation.policy_guid IS
    ' The policy rule guid of the last violation.';

COMMENT ON COLUMN mgmt_last_violation.key_value IS
    ' The key value of the last violation.';

COMMENT ON COLUMN mgmt_last_violation.collection_timestamp IS
    ' The timestamp of the last violation for the target, policy, key.';


rem 
rem View for severity annotations
rem NOTE: There is no "$" in the view name because this view is created
rem with the intent of being used as a table for all practical purposes
rem and we may even make this a table if needed in future.
rem "1" is mgmt_global.G_ANNOTATION_SOURCE_SEVERITY for source_obj_type
rem 
CREATE OR REPLACE VIEW MGMT_SEVERITY_ANNOTATION
   (severity_guid, collection_timestamp, annotation_type, user_name, message)
AS
  SELECT source_obj_guid, timestamp, annotation_type, user_name, message
    FROM mgmt_annotation
   WHERE source_obj_type = 1;


rem
rem  PURPOSE
rem
rem     The MGMT_SEVERITY view contains the severity information that was
rem     collected on the target system.  Severities are alerts that inform the
rem     user when a threshold that was established on a target has been exceeded.
rem
rem  NOTE: There is no "$" in the view name because this view is created
rem  with the intent of being used as a table for all practical purposes
rem

CREATE OR REPLACE VIEW mgmt_severity
  (target_guid, metric_guid, key_value, collection_timestamp,
   severity_code, severity_type, severity_duration, severity_guid,
   annotated_flag, notification_status,
   message, message_nlsid, message_params,
   action_message, action_nlsid, action_message_params, advisory_id,
   load_timestamp, user_name)
AS
  SELECT target_guid, policy_guid, key_value, collection_timestamp,
         violation_level, violation_type, violation_duration, violation_guid,
	 annotated_flag, notification_status,
	 message, message_nlsid, message_params,
	 action_message, action_message_nlsid, action_message_params, advisory_id,
	 load_timestamp, user_name
    FROM mgmt_violations
   WHERE violation_type IN (0, 1, 2);

COMMENT ON TABLE mgmt_severity IS
    'The MGMT_SEVERITY view contains the severity information.
    Severities are alerts that inform the user when a metric threshold
    Test or a policy violation has failed.';

COMMENT ON COLUMN mgmt_severity.target_guid IS
    ' The target guid of the severity';

COMMENT ON COLUMN mgmt_severity.metric_guid IS
    ' The metric guid of the severity';

COMMENT ON COLUMN mgmt_severity.key_value IS
    ' The key value of the severity';

COMMENT ON COLUMN mgmt_severity.collection_timestamp IS
    ' The timestamp at which the severity occurred';

COMMENT ON COLUMN mgmt_severity.severity_guid IS
    ' The unique id of the severity. Defaults to SYS_GUID()';

COMMENT ON COLUMN mgmt_severity.severity_code IS
    'The severity codes for error, warnin, critical etc.
    These codes are backwards compatible with EM 9i and EM 10gR1.
      15 - CLEAR
      18 - INFO
      20 - WARNING
      25 - CRITICAL
     115 - AGENT UNREACHABLE CLEART
     125 - AGENT UNREACHABLE START
     215 - BLACKOUT END
     225 - BLACKOUT START
     315 - METRIC ERROR END
     325 - METRIC ERROR START
    Codes 115 and above are applicable only for response/status metric';
    
COMMENT ON COLUMN mgmt_severity.severity_type IS
    ' The severity type allows an application that is selecting
      from this table to filter the rows returned by the type of
      severity.  Values in this column are:
           0 - METRIC THRESHOLD ALERT
           1 - AVAILABILITY';

COMMENT ON COLUMN mgmt_severity.severity_duration IS
    'The delta time, in hours, from when the severity was logged
    until it was cleared.';
    
COMMENT ON COLUMN mgmt_severity.annotated_flag IS
   'A flag to indicate whether the severity is annotated or not.';
    
COMMENT ON COLUMN mgmt_severity.notification_status IS
   'The column used by the notification sub system to determine
    notification status of the severity.'; 
    
COMMENT ON COLUMN mgmt_severity.message IS
    'The message of the severity.  The messages usually contain
    details about what triggered this severity.';

COMMENT ON COLUMN mgmt_severity.message_nlsid IS
    'The NLS ID of the severity message.';

COMMENT ON COLUMN mgmt_severity.message_params IS
    'URL encoded parameters separated by "&" to be used to
    format the severity message.';

COMMENT ON COLUMN mgmt_severity.action_message IS
    'Suggested action message in english for this severity';

COMMENT ON COLUMN mgmt_severity.action_nlsid IS
    'The NLS ID of the action message.';

COMMENT ON COLUMN mgmt_severity.action_message_params IS
    'URL encoded parameters for translating action message';

COMMENT ON COLUMN mgmt_severity.advisory_id IS
    'Advisory ID of the severity';

COMMENT ON COLUMN mgmt_severity.load_timestamp IS
    'Date and time when the severity was loaded';

COMMENT ON COLUMN mgmt_severity.user_name IS
    'Name of the user to load the severity';

rem
rem  PURPOSE
rem
rem     The mgmt_current_severity table contains the current severity for a metric.
rem     This table was created to improve the performance of queries requesting the
rem     current severity information for a metric.
rem
rem
rem  COLUMNS
rem
rem     See MGMT_SEVERITY
rem
rem
rem  NOTES
rem
rem     Once the loader mechanism support is added for this table, then we
rem     will change the current severity view to use it.
rem
rem     The primary key for this table doesn't include the timestamp.  We
rem     only want one record in this table for each metric.
rem
rem  NOTE: There is no "$" in the view name because this view is created
rem  with the intent of being used as a table for all practical purposes
rem

CREATE OR REPLACE VIEW mgmt_current_severity
  (target_guid, metric_guid, key_value, collection_timestamp,
   severity_code, severity_type, severity_guid,
   annotated_flag, message, message_nlsid, message_params,
   action_message, action_nlsid, action_message_params, advisory_id,
   load_timestamp )
AS
  SELECT target_guid, policy_guid, key_value, collection_timestamp,
         violation_level, violation_type, violation_guid,
	 annotated_flag, message, message_nlsid, message_params,
	 action_message, action_message_nlsid, action_message_params, advisory_id,
	 load_timestamp
    FROM mgmt_current_violation
   WHERE violation_type IN (0, 1, 2);

COMMENT ON TABLE mgmt_current_severity IS
    'The mgmt_current_severity view contains the severity information.
    Severities are alerts that inform the user when a metric threshold
    Test or a policy violation has failed.';

COMMENT ON COLUMN mgmt_current_severity.target_guid IS
    ' The target guid of the severity';

COMMENT ON COLUMN mgmt_current_severity.metric_guid IS
    ' The metric guid of the severity';

COMMENT ON COLUMN mgmt_current_severity.key_value IS
    ' The key value of the severity';

COMMENT ON COLUMN mgmt_current_severity.collection_timestamp IS
    ' The timestamp at which the severity occurred';

COMMENT ON COLUMN mgmt_current_severity.severity_guid IS
    ' The unique id of the severity. Defaults to SYS_GUID()';

COMMENT ON COLUMN mgmt_current_severity.severity_code IS
    'The severity codes for error, warnin, critical etc.
    These codes are backwards compatible with EM 9i and EM 10gR1.
      15 - CLEAR
      18 - INFO
      20 - WARNING
      25 - CRITICAL
     115 - AGENT UNREACHABLE CLEART
     125 - AGENT UNREACHABLE START
     215 - BLACKOUT END
     225 - BLACKOUT START
     315 - METRIC ERROR END
     325 - METRIC ERROR START
    Codes 115 and above are applicable only for response/status metric';
    
COMMENT ON COLUMN mgmt_current_severity.severity_type IS
    ' The severity type allows an application that is selecting
      from this table to filter the rows returned by the type of
      severity.  Values in this column are:
           0 - METRIC THRESHOLD ALERT
           1 - AVAILABILITY';

COMMENT ON COLUMN mgmt_current_severity.message IS
    'The message of the severity.  The messages usually contain
    details about what triggered this severity.';

COMMENT ON COLUMN mgmt_current_severity.message_nlsid IS
    'The NLS ID of the severity message.';

COMMENT ON COLUMN mgmt_current_severity.message_params IS
    'URL encoded parameters separated by "&" to be used to
    format the severity message.';

COMMENT ON COLUMN mgmt_current_severity.action_message IS
    'Suggested action message in english for this severity';

COMMENT ON COLUMN mgmt_current_severity.action_nlsid IS
    'The NLS ID of the action message.';

COMMENT ON COLUMN mgmt_current_severity.action_message_params IS
    'URL encoded parameters for translating action message';

COMMENT ON COLUMN mgmt_current_severity.advisory_id IS
    'Advisory ID of the severity';

COMMENT ON COLUMN mgmt_current_severity.load_timestamp IS
    'Date and time when the severity was loaded';


