Rem
Rem $Header: bsln_dmlem.sql 11-feb-2005.10:17:21 jsoule Exp $
Rem
Rem bsln_dmlem.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      bsln_dmlem.sql - Baseline DML for EM deployment
Rem
Rem    DESCRIPTION
Rem      Deploys dynamic baselines out-of-box data for EM Grid Control,
Rem      primarily baseline-eligible metrics. 
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jsoule      02/11/05 - add other performance/usage metrics 
Rem    jberesni    10/19/04 - jberesni_update_thresholds
Rem    jberesni    10/15/04 - Created
Rem

-------------------------------------------
--  metrics for generic services
-------------------------------------------
begin
   insert into mgmt_bsln_metrics
      (METRIC_UID
      ,TAIL_ESTIMATOR
      ,THRESHOLD_METHOD_DEFAULT
      ,NUM_OCCURRENCES_DEFAULT
      ,WARNING_PARAM_DEFAULT
      ,CRITICAL_PARAM_DEFAULT
      )
   values
      -- generic service.performance metric UID
      (mgmt_bsln.metric_uid(HEXTORAW('2AF5045B41B1046D72D58FC22AB66592'))
      ,'EXPTAIL'
      ,mgmt_bsln.K_METHOD_SIGLVL
      ,mgmt_bsln.K_DEFAULT_NUM_OCCURS
      ,mgmt_bsln.K_SIGLVL_999
      ,mgmt_bsln.K_SIGLVL_9999
      );

   insert into mgmt_bsln_metrics
      (METRIC_UID
      ,TAIL_ESTIMATOR
      ,THRESHOLD_METHOD_DEFAULT
      ,NUM_OCCURRENCES_DEFAULT
      ,WARNING_PARAM_DEFAULT
      ,CRITICAL_PARAM_DEFAULT
      )
   values
      -- generic service.usage metric UID
      (mgmt_bsln.metric_uid(HEXTORAW('11736AED0AA5FE81CE3B328E0C14F266'))
      ,'EXPTAIL'
      ,mgmt_bsln.K_METHOD_SIGLVL
      ,mgmt_bsln.K_DEFAULT_NUM_OCCURS
      ,mgmt_bsln.K_SIGLVL_999
      ,mgmt_bsln.K_SIGLVL_9999
      );
commit;
end;
/

-------------------------------------------
--  metrics for aggregate services
-------------------------------------------
begin
   insert into mgmt_bsln_metrics
      (METRIC_UID
      ,TAIL_ESTIMATOR
      ,THRESHOLD_METHOD_DEFAULT
      ,NUM_OCCURRENCES_DEFAULT
      ,WARNING_PARAM_DEFAULT
      ,CRITICAL_PARAM_DEFAULT
      )
   values
      -- aggregate service.performance metric UID
      (mgmt_bsln.metric_uid(HEXTORAW('2C0557DBDB3864419BFBB54264D037BE'))
      ,'EXPTAIL'
      ,mgmt_bsln.K_METHOD_SIGLVL
      ,mgmt_bsln.K_DEFAULT_NUM_OCCURS
      ,mgmt_bsln.K_SIGLVL_999
      ,mgmt_bsln.K_SIGLVL_9999
      );

   insert into mgmt_bsln_metrics
      (METRIC_UID
      ,TAIL_ESTIMATOR
      ,THRESHOLD_METHOD_DEFAULT
      ,NUM_OCCURRENCES_DEFAULT
      ,WARNING_PARAM_DEFAULT
      ,CRITICAL_PARAM_DEFAULT
      )
   values
      -- aggregate service.usage metric UID
      (mgmt_bsln.metric_uid(HEXTORAW('4FE0E06B443EFEF25EED1E19A9EECB12'))
      ,'EXPTAIL'
      ,mgmt_bsln.K_METHOD_SIGLVL
      ,mgmt_bsln.K_DEFAULT_NUM_OCCURS
      ,mgmt_bsln.K_SIGLVL_999
      ,mgmt_bsln.K_SIGLVL_9999
      );
commit;
end;
/

-------------------------------------------
--  metrics for web applications
-------------------------------------------
begin
   insert into mgmt_bsln_metrics
      (METRIC_UID
      ,TAIL_ESTIMATOR
      ,THRESHOLD_METHOD_DEFAULT
      ,NUM_OCCURRENCES_DEFAULT
      ,WARNING_PARAM_DEFAULT
      ,CRITICAL_PARAM_DEFAULT
      )
   values
      -- web application.performance metric UID
      (mgmt_bsln.metric_uid(HEXTORAW('72DC44207FECD7FF21E0C92D7ADDC9FA'))
      ,'EXPTAIL'
      ,mgmt_bsln.K_METHOD_SIGLVL
      ,mgmt_bsln.K_DEFAULT_NUM_OCCURS
      ,mgmt_bsln.K_SIGLVL_999
      ,mgmt_bsln.K_SIGLVL_9999
      );

   insert into mgmt_bsln_metrics
      (METRIC_UID
      ,TAIL_ESTIMATOR
      ,THRESHOLD_METHOD_DEFAULT
      ,NUM_OCCURRENCES_DEFAULT
      ,WARNING_PARAM_DEFAULT
      ,CRITICAL_PARAM_DEFAULT
      )
   values
      -- web application.usage metric UID
      (mgmt_bsln.metric_uid(HEXTORAW('283A9020E4C4C6FB8396366E94C188DC'))
      ,'EXPTAIL'
      ,mgmt_bsln.K_METHOD_SIGLVL
      ,mgmt_bsln.K_DEFAULT_NUM_OCCURS
      ,mgmt_bsln.K_SIGLVL_999
      ,mgmt_bsln.K_SIGLVL_9999
      );
commit;
end;
/
