Rem
Rem $Header: bsln_triggers.sql 13-jun-2007.00:15:01 sktedla Exp $
Rem
Rem bsln_triggers.sql
Rem
Rem Copyright (c) 2004, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      bsln_triggers.sql - Triggers that support EM metric baselines
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sktedla     06/07/07 - Handling No Data Found for EM_adaptive_thresholds
Rem                           trigger - Bug#6082301
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    jberesni    10/07/04 - call pkg 
Rem    jberesni    10/06/04 - jberesni_metadata01
Rem    jberesni    10/06/04 - Created
Rem


Rem ------------------------------------------------------
Rem EM_adaptive_thresholds_INS
Rem
Rem Instead-of trigger that updates MGMT_POLICY_ASSOC_CFG
Rem table HAS_ACTIVE_BASELINE flag for metrics that are
Rem baseline-thresholded on 10gR2 targets.
Rem
Rem ------------------------------------------------------

create or replace trigger EM_adaptive_thresholds_INS
INSTEAD OF INSERT ON EM_adaptive_thresholds
FOR EACH ROW
declare
   l_metric_guid  mgmt_metrics.metric_guid%TYPE;
begin
   -----------------------------------------------------------
   -- get metric guid (10gR2 does not know this)
   -----------------------------------------------------------
   begin
   l_metric_guid := mgmt_bsln_internal.metric_guid_by_name
                      (target_type_in => :new.target_type
                      ,metric_name_in => :new.metric_name
                      ,metric_column_in => :new.metric_column
                     );
   -- Adding exception block - Bug#6082301
   exception
      -- ignore case when metric column not found
      when NO_DATA_FOUND then null;
   end;
   -----------------------------------------------------------
   -- update policy config for this metric across collections
   -----------------------------------------------------------
   if l_metric_guid is not null
   then
      mgmt_bsln_internal.set_metric_bsln_flag
                           (target_guid_in => :new.target_guid
                           ,metric_guid_in => l_metric_guid
                           ,key_value_in   => :new.key_value
                           ,flag_value_in  => :new.has_active_baseline
                           );
   end if;
end;
/
