Rem
Rem $Header: bslni_pkgdef.sql 22-jul-2005.18:43:32 jberesni Exp $
Rem
Rem bslni_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      bslni_pkgdef.sql - specification of baselines internal package
Rem
Rem    DESCRIPTION
Rem      This API is used by mgmt_bsln package, and should not be called
Rem      directly except by that package. 
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jberesni    07/22/05 - add overload for test_metrics_EM 
Rem    scgrover    07/07/05 - add extended sql trace 
Rem    jberesni    06/03/05 - beacon keyval delete callback 
Rem    jberesni    05/13/05 - add metric test fcns 
Rem    jberesni    05/12/05 - add target_delete_callback 
Rem    jberesni    04/16/05 - merge from DB control 
Rem    jberesni    03/29/05 - extend compute_load_stats cur 
Rem    jberesni    03/28/05 - job def constants now public
Rem    jberesni    03/22/05 - expose job defs for logging 
Rem    jberesni    03/05/05 - sync with DB control
Rem    jberesni    01/21/05 - refactor
Rem    jberesni    10/16/04 - EM update thresholds 
Rem    jberesni    10/07/04 - has_active_baseline flag 
Rem    jberesni    09/28/04 - migrate from DB control 
Rem    jberesni    08/13/04 - new estimator 
Rem    jberesni    08/10/04 - daynight
Rem    jberesni    08/01/04 - set_all_thresholds and unset_threshold
Rem    jberesni    07/26/04 - add compute_load_stats
Rem                           and set_sysmetric_thresholds
Rem    jberesni    07/23/04 - misc fixes 
Rem    jberesni    07/15/04 - candidate1
Rem    jberesni    07/15/04 - Created
Rem

create or replace 
package mgmt_bsln_internal 
-----------------------------
-- Grid Control deployment 0
-----------------------------
as
   --------------------------------------------------------------------------
   -- local subtypes anchored to MGMT_BSLN public package types
   --------------------------------------------------------------------------
   subtype guid_t             is MGMT_BSLN.guid_t;
   subtype subinterval_code_t is MGMT_BSLN.subinterval_code_t;
   subtype subinterval_key_t  is MGMT_BSLN.subinterval_key_t;
   subtype key_value_t        is MGMT_BSLN.key_value_t;
   subtype fail_action_t      is MGMT_BSLN.fail_action_t;
   subtype param_value_t      is MGMT_BSLN.param_value_t;
   subtype threshold_method_t is MGMT_BSLN.threshold_method_t;

   -----------------------------------------------------------------------------
   -- public job definition constants exposed for logging 
   -----------------------------------------------------------------------------
   K_SET_THRESHOLDS_JOB constant varchar2(256) := 
                        'BEGIN MGMT_BSLN.SET_ALL_THRESHOLDS;/*GC*/END;' ;
   K_COMPUTE_STATS_JOB  constant varchar2(256) := 
                        'BEGIN MGMT_BSLN_INTERNAL.PURGE_EXTRACT_RAWDATA;'||
                        'MGMT_BSLN.COMPUTE_ALL_STATISTICS;/*GC*/END;' ;

   ---------------------------------------------------------------
   -- public constant baseline name for test(_registered)_metrics 
   -- functions
   ---------------------------------------------------------------
   K_TESTBSLN_NAME  CONSTANT varchar2(64) := 'TEST_BASELINE';

   -- extended sql trace constant
   EST_BSLN_STAT_NAME CONSTANT VARCHAR(32) := 'EST_BSLN_STAT';
   EST_BSLN_THRESHOLDS_NAME CONSTANT VARCHAR(32) := 'EST_BSLN_THRESHOLDS';

   PROCEDURE DBMSJOB_EXTENDED_SQL_TRACE_ON(p_value IN BOOLEAN, p_num IN NUMBER);

   -----------------------------------------------------------------------------
   --
   --    entry points for deployment-specific set and unset operations
   --    on metric alert thresholds
   --
   -----------------------------------------------------------------------------
   procedure set_threshold_parameters
      (bsln_guid_in        in guid_t
      ,ds_guid_in          in guid_t
      ,threshold_method_in in threshold_method_t
      ,warning_param_in    in param_value_t
      ,critical_param_in   in param_value_t
      ,num_occurs_in       in integer := mgmt_bsln.K_DEFAULT_NUM_OCCURS
      ,fail_action_in      in fail_action_t := mgmt_bsln.K_FAIL_ACTION_UNSET
      );

   procedure unset_threshold_parameters
         (bsln_guid_in   in guid_t
         ,ds_guid_in     in guid_t
         );

   procedure set_all_thresholds(bsln_guid_in in guid_t := null);
   procedure unset_all_thresholds (bsln_guid_in in guid_t);

   -------------------------------------------------
   --
   --  deployment specific cursor definitions
   --
   -------------------------------------------------
   
   ------------------------------------------------------------------------
   cursor compute_statistics_cur
            (in_bsln_guid    guid_t
            ,in_target_uid   guid_t
            ,in_subinterval_key varchar2
            ,in_interval_begin  date
            ,in_interval_end    date)
   is
        select VALUE(S)
   from
        TABLE(MGMT_BSLN.extract_compute_stats(
              CURSOR(select
                            DS.datasource_guid
                           ,in_bsln_guid       as bsln_guid
                           ,in_subinterval_key as subinterval_key
                           ,RD.obs_time        as obs_time
                           ,RD.obs_value       as obs_value
                       from
                            mgmt_bsln_rawdata           RD  -- deployment specific source
                           ,mgmt_bsln_datasources       DS
                      where
                            RD.datasource_guid = DS.datasource_guid
                        and DS.target_uid = in_target_uid
                        and RD.obs_time between in_interval_begin
                                            and in_interval_end
                ))) S;
                
   -------------------------------------------------------------------
   -- original compute_load_stats_cur selects from ACTIVE, ROLLING
   -- baselines. called by nightly compute job
   -------------------------------------------------------------------
   cursor compute_load_stats_ARcur
            (in_compute_date date
            ,in_bsln_guid    guid_t)
   is
   select S.*
     from
          TABLE(MGMT_BSLN.extract_compute_stats(
                CURSOR(select
                              DS.datasource_guid
                             ,BL.bsln_guid
                             ,BL.subinterval_key
                             ,RD.obs_time        as obs_time
                             ,RD.obs_value       as obs_value
                         from
                              mgmt_bsln_rawdata       RD  -- deployment specific source
                             ,mgmt_bsln_datasources   DS
                             ,mgmt_bsln_baselines     BL
                             ,mgmt_bsln_intervals     AI
                        where
                              BL.target_uid = DS.target_uid
                          and BL.bsln_guid = NVL(in_bsln_guid,BL.bsln_guid)
                          and BL.status = 'ACTIVE'
                          and BL.type   = 'R'
                          and BL.bsln_guid = AI.bsln_guid
                          and RD.datasource_guid = DS.datasource_guid
                          and RD.obs_time between  in_compute_date - AI.interval_days
                                              and  in_compute_date
                  ))) S;

   -------------------------------------------------------
   -- computes and replaces stats for bsln on date
   -------------------------------------------------------
   procedure compute_load_stats
             (compute_date_IN IN date
             ,bsln_guid_IN IN varchar2
             );
   -----------------------------------------------------------------------------
   --
   --    submit and drop job queue/scheduler jobs to compute and set thresholds
   --
   -----------------------------------------------------------------------------
   procedure submit_bsln_jobs;
   procedure delete_bsln_jobs;

   -----------------------------------------------------------------------------
   --
   --    new enable/disable API
   --
   -----------------------------------------------------------------------------   
   function is_enabled return integer;

   -----------------------------------------------------------------------------
   --
   --    SLPA declarations for Design by Contract support
   --
   -----------------------------------------------------------------------------
   ASSERTFAIL     EXCEPTION;
   ASSERTFAIL_C   CONSTANT INTEGER := -20999;
   PRAGMA EXCEPTION_INIT(ASSERTFAIL, -20999);
   PKGNAME_C      CONSTANT VARCHAR2(20) := 'MGMT_BSLN_INTERNAL';
   -----------------------------------------------------------------------------
   -----------------------------------------------------------------------------
   --
   --    EM specific modules
   --
   -----------------------------------------------------------------------------
   procedure set_metric_bsln_flag
      (target_guid_in in guid_t
      ,metric_guid_in in guid_t
      ,key_value_in in key_value_t
      ,flag_value_in in integer);

   function metric_guid_by_name
      (target_type_in in mgmt_metrics.target_type%TYPE
      ,metric_name_in in mgmt_metrics.metric_name%TYPE
      ,metric_column_in in mgmt_metrics.metric_column%TYPE)
   return guid_t;


   procedure purge_rawdata (target_guid_in in mgmt_bsln.guid_t := null);

   procedure extract_rawdata
               (target_guid_in in mgmt_bsln.guid_t := null
               ,window_hrs_in in integer := 24);

   procedure purge_extract_rawdata
               (target_guid_in in mgmt_bsln.guid_t := null
               ,window_hrs_in in integer := 24);


   function rawdata_retention return integer;
   procedure set_rawdata_retention(retention_in in integer);


   function test_metrics_EM
            (metric_array_in   IN MGMT_METRIC_DETAILS_ARRAY
            ,window_days_in    IN number := 3 
            ,end_date_in       IN date := TRUNC(SYSDATE)+1
            )
   return bsln_statistics_set;

   function test_metrics_EM
            (metric_array_in   IN MGMT_METRIC_INSTANCE_ARRAY
            ,window_days_in    IN number := 3 
            ,end_date_in       IN date := TRUNC(SYSDATE)+1
            )
   return bsln_statistics_set;

   function test_registered_metrics_EM
            (target_guid_in     IN varchar2
            ,window_days_in    IN number := 3 
            ,end_date_in       IN date := TRUNC(SYSDATE)+1
            )
   return bsln_statistics_set;

   procedure target_delete_callback
      (target_name_in in varchar2
      ,target_type_in in varchar2
      ,target_guid_in in RAW);

   procedure beacon_keyval_del_callback
      (p_target_guid   MGMT_BSLN.guid_t
      ,p_metric_guid   MGMT_BSLN.guid_t
      ,p_key_value     MGMT_BSLN.key_value_t
      );
   -----------------------------------------------------------------------------
end mgmt_bsln_internal;
/
show errors

