Rem
Rem $Header: storage_common_pkgdef.sql 20-jul-2005.17:32:26 mgoodric Exp $
Rem
Rem storage_report_pkgdefs.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      common_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      PL/SQL package storage_ecm_pkg for post processing of the storage report ecm snapshot
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    mgoodric    07/20/05 - add additional parameter to after_load proc 
Rem    ajdsouza    05/05/05 - moved constant package variables from
Rem                           host|ntap utils 
Rem    ajdsouza    11/23/04 - 
Rem    ajdsouza    08/10/04 - ajdsouza_ecm_processing
Rem    ajdsouza    07/30/04 - ajdsouza_fix_storage_metrics
Rem    ajdsouza    07/28/04 - Moved to new component storage under functional unit common
Rem    ajdsouza    06/25/04 - storage reporting sources 
Rem    ajdsouza    05/12/04 - Created
Rem


CREATE OR REPLACE PACKAGE STORAGE_ECM_PKG AS

  c_host_target_type         CONSTANT mgmt_targets.target_type%TYPE :=
   MGMT_GLOBAL.G_HOST_TARGET_TYPE;

 c_metric_host_filesystems   CONSTANT mgmt_metrics.metric_name%TYPE   := 'Filesystems';
 c_host_mountpoint           CONSTANT mgmt_metrics.metric_column%TYPE := 'mountPoint';
 c_netapp_filer_target_type  CONSTANT mgmt_targets.target_type%TYPE := 'netapp_filer';

PROCEDURE POST_PROCESSING
( 
  v_snapshot_guid IN mgmt_ecm_gen_snapshot.snapshot_guid%TYPE,
  v_afterLoadInput IN SMP_EMD_NVPAIR_ARRAY
);

PROCEDURE LOG_ISSUE
(
  v_snapshot_guid mgmt_ecm_gen_snapshot.snapshot_guid%TYPE,
  v_message_id    INTEGER,
  v_msg_params    MGMT_MAX_STRING_ARRAY,
  v_action_id     INTEGER,
  v_action_params MGMT_MAX_STRING_ARRAY
);

FUNCTION DIGEST_GLOBAL_UNIQUE_ID
( 
  l_string VARCHAR2 
) 
 RETURN mgmt_storage_report_data.global_unique_id%TYPE;

PROCEDURE NFS_POST_PROCESSING 
( 
  v_snapshot_guid mgmt_ecm_gen_snapshot.snapshot_guid%TYPE 
);

PROCEDURE DB_POST_PROCESSING 
( 
  v_snapshot_guid mgmt_ecm_gen_snapshot.snapshot_guid%TYPE 
);                       

END STORAGE_ECM_PKG;
/
