Rem
Rem $Header: storage_rep_metrics_pkgdef.sql 31-aug-2005.11:09:41 ajdsouza Exp $
Rem
Rem storage_rep_metrics_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      storage_rep_metrics_pkgdef.sql - 
Rem        host storage repository metrics for storage history
Rem
Rem    DESCRIPTION
Rem        host storage repository metrics for storage history
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ajdsouza    08/31/05 - added interface test_rep_metrics
Rem    rmenon      03/25/05 - 
Rem    rmenon      03/10/05 - changed repository metric labels
Rem    rmenon      03/02/05 - changed repository metric labels
Rem                           as per Reddys suggestions.
Rem    rmenon      12/09/04 - 
Rem    rmenon      11/29/04 - change metric column constant names
Rem                           so that host and group use the same
Rem                           metric constant names.
Rem    rmenon      11/11/04 - 
Rem    rmenon      11/09/04 - formatting changes
Rem    rmenon      09/30/04 - 
Rem    rmenon      08/17/04 - rmenon_storage_refresh_errors_history_checkin
Rem    rmenon      08/16/04 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

CREATE OR REPLACE PACKAGE storage_rep_metrics_pkg 
AS
  /* Design Notes:
   * ------------
   * We have one metric for the entire host including db, 
   * local_fs and writeable nfs. We could have had four 
   * metrics - one each for host, db, local_fs and 
   * writeable NFS. There are no major differences between the 
   * two approaches - the one difference is that the first 
   * choice of having a single metric may be more performant if 
   * we can avoid calls to 4 pl/sql statements.
   */

  /*--------------------------------------------------------*/
  /*--------- constants common to host and group  ----------*/
  /*--------------------------------------------------------*/

  g_storage_col_interval_in_mins constant number := 24*60; -- 1 day
  g_storage_unit constant varchar2(5) := 'Bytes'; 

  /*--------------------------------------------------------*/
  /*---------- metric columns common to host and group------*/
  /*--------------------------------------------------------*/

  -- repository metric column names for host and group
  g_total_used constant varchar2(30) := 'total_used';
  g_total_free constant varchar2(30) := 'total_free';
  g_total_unallocated  constant varchar2(30) := 'total_unallocated';
  g_total_allocated  constant varchar2(30) := 'total_allocated';
  g_total_overhead constant varchar2(30) := 'total_overhead';
  g_db_used constant varchar2(30) := 'db_used';
  g_db_free constant varchar2(30) := 'db_free';
  g_local_fs_used constant varchar2(30) := 'local_fs_used';
  g_local_fs_free constant varchar2(30) := 'local_fs_free';
  g_writeable_nfs_used constant varchar2(30) := 
    'writeable_nfs_used';
  g_writeable_nfs_free constant varchar2(30) := 
    'writeable_nfs_free';
  g_vol_unallocated constant varchar2(30) := 'vol_unallocated';
  g_vol_allocated constant varchar2(30) := 'vol_allocated';
  g_vol_overhead constant varchar2(30) := 'vol_overhead';
  g_asm_allocated constant varchar2(30) := 'asm_allocated';
  g_asm_unallocated constant varchar2(30) := 'asm_unallocated';
  g_asm_overhead constant varchar2(30) := 'asm_overhead';
  g_disks_allocated constant varchar2(30) := 
    'disks_allocated';
  g_disks_unallocated constant varchar2(30) := 
    'disks_unallocated';
  g_total_hosts constant varchar2(30) := 
    'total_hosts';
  g_summarized_hosts constant varchar2(30) := 
    'summarized_hosts';
  g_total_dbs constant varchar2(30) := 
    'total_dbs';
  g_summarized_dbs constant varchar2(30) := 
    'summarized_dbs';
  g_total_asm constant varchar2(30) := 
    'total_asm';
  g_summarized_asm constant varchar2(30) := 
    'summarized_asm';
  g_unmonitored_nfs constant varchar2(30) := 
    'unmonitored_nfs';
  g_other_map_err constant varchar2(30) := 
    'other_map_err';
  g_host_metric_err constant varchar2(30) := 
    'host_metric_err';
  g_db_metric_err constant varchar2(30) := 
    'db_metric_err';
  g_asm_metric_err constant varchar2(30) := 
    'asm_metric_err';

  -- column labels
  g_total_used_lbl constant varchar2(40) := 'Total Storage Used (GB)';
  g_total_free_lbl constant varchar2(40) := 'Total Storage Free (GB)';
  g_total_unallocated_lbl  constant varchar2(40) := 
    'Total Storage Unallocated (GB)';
  g_total_allocated_lbl  constant varchar2(40) := 
    'Total Storage Allocated (GB)';
  g_total_overhead_lbl constant varchar2(40) := 
    'Total Storage Overhead (GB)';
  g_db_used_lbl constant varchar2(40) := 
    'Databases Storage Used (GB)';
  g_db_free_lbl constant varchar2(40) := 
    'Databases Storage Free (GB)';
  g_local_fs_used_lbl constant varchar2(40) := 
    'Local File Systems Storage Used (GB)';
  g_local_fs_free_lbl constant varchar2(40) := 
    'Local File Systems Storage Free (GB)';
  g_writeable_nfs_used_lbl constant varchar2(40) := 
    'Writeable NFS Storage Used (GB)';
  g_writeable_nfs_free_lbl constant varchar2(40) := 
    'Writeable NFS Storage Free (GB)';
  g_vol_unallocated_lbl constant varchar2(40) := 
    'Volumes Storage Unallocated (GB)';
  g_vol_allocated_lbl constant varchar2(40) := 
    'Volumes Storage Allocated (GB)';
  g_vol_overhead_lbl constant varchar2(40) := 
    'Volumes Storage Overhead (GB)';
  g_asm_allocated_lbl constant varchar2(40) := 
    'ASM Storage Allocated (GB)';
  g_asm_unallocated_lbl constant varchar2(40) := 
    'ASM Storage Unallocated (GB)';
  g_asm_overhead_lbl constant varchar2(40) := 
    'ASM Storage Overhead (GB)';
  g_disks_allocated_lbl constant varchar2(40) := 
    'Disk Storage Allocated (GB)';
  g_disks_unallocated_lbl constant varchar2(40) := 
    'Disk Storage Unallocated (GB)';
  g_total_hosts_lbl constant varchar2(40) := 
    'Total Number of Hosts';
  g_summarized_hosts_lbl constant varchar2(40) := 
    'Number of Hosts Summarized';
  g_total_dbs_lbl constant varchar2(40) := 
    'Total Number of Databases';
  g_summarized_dbs_lbl constant varchar2(40) := 
    'Number of Databases Summarized';
  g_total_asm_lbl constant varchar2(40) := 
    'Total Number of ASM Instances';
  g_summarized_asm_lbl constant varchar2(40) := 
    'Number of ASM Instances Summarized';
  g_unmonitored_nfs_lbl constant varchar2(50) := 
    'Unmonitored NFS Server Mapping Errors';
  g_other_map_err_lbl constant varchar2(50) := 
    'Other Mapping Errors';
  g_host_metric_err_lbl constant varchar2(50) := 
    'Host Storage Metric Collection Errors';
  g_db_metric_err_lbl constant varchar2(50) := 
    'Databases Storage Metric Collection Errors';
  g_asm_metric_err_lbl constant varchar2(50) := 
    'ASM Storage Metric Collection Errors';

  -- column NLS ids
  g_total_used_nlsid constant varchar2(30) := 'total_used_nls';
  g_total_free_nlsid constant varchar2(30) := 'total_free_nls';
  g_total_unallocated_nlsid  constant varchar2(30) := 'total_unallocated_nls';
  g_total_allocated_nlsid  constant varchar2(30) := 'total_allocated_nls';
  g_total_overhead_nlsid constant varchar2(30) := 'total_overhead_nls';
  g_db_used_nlsid constant varchar2(30) := 'db_used_nls';
  g_db_free_nlsid constant varchar2(30) := 'db_free_nls';
  g_local_fs_used_nlsid constant varchar2(30) := 'local_fs_used_nls';
  g_local_fs_free_nlsid constant varchar2(30) := 'local_fs_free_nls';
  g_writeable_nfs_used_nlsid constant varchar2(30) := 'writeable_nfs_used_nls';
  g_writeable_nfs_free_nlsid constant varchar2(30) := 'writeable_nfs_free_nls';
  g_vol_unallocated_nlsid constant varchar2(30) := 'vol_unallocated_nls';
  g_vol_allocated_nlsid constant varchar2(30) := 'vol_allocated_nls';
  g_vol_overhead_nlsid constant varchar2(30) := 'vol_overhead_nls';
  g_asm_allocated_nlsid constant varchar2(30) := 'asm_allocated_nls';
  g_asm_unallocated_nlsid constant varchar2(30) := 'asm_unallocated_nls';
  g_asm_overhead_nlsid constant varchar2(30) := 'asm_overhead_nls';
  g_disks_allocated_nlsid constant varchar2(30) := 
    'disks_allocated_nls';
  g_disks_unallocated_nlsid constant varchar2(30) := 
    'disks_unallocated_nls';
  g_total_hosts_nlsid constant varchar2(30) := 
    'total_hosts_nls';
  g_summarized_hosts_nlsid constant varchar2(30) := 
    'summarized_hosts_nls';
  g_total_dbs_nlsid constant varchar2(30) := 
    'total_dbs_nls';
  g_summarized_dbs_nlsid constant varchar2(30) := 
    'summarized_dbs_nls';
  g_total_asm_nlsid constant varchar2(30) := 
    'total_asm_nls';
  g_summarized_asm_nlsid constant varchar2(30) := 
    'summarized_asm_nls';
  g_unmonitored_nfs_nlsid constant varchar2(30) := 
    'unmonitored_nfs_nls';
  g_other_map_err_nlsid constant varchar2(30) := 
    'other_map_err_nls';
  g_host_metric_err_nlsid constant varchar2(30) := 
    'host_metric_err_nls';
  g_db_metric_err_nlsid constant varchar2(30) := 
    'db_metric_err_nls';
  g_asm_metric_err_nlsid constant varchar2(30) := 
    'asm_metric_err_nls';

  /*--------------------------------------------------------*/
  /*--------------- Host repository metric constants  ------*/
  /*--------------------------------------------------------*/

  -- different metric label is used for the "number of hosts summarized"
  -- metric for host
  
  g_host_summ_hosts_lbl constant varchar2(40) := 'Host Summarized';
  g_host_summ_hosts_nlsid constant varchar2(30) := 
    'host_summarized_hosts_nls';

  -- metric related constants for host target
  g_host_storage_rep_metric constant varchar2(30) 
    := 'host_storage_history';

  g_host_storage_rep_metric_lbl constant varchar2(30) := 
    'Storage Summary';
  g_host_storage_hist_met_nlsid constant varchar2(30) := 
    'host_hist_metric_nlsid';
  g_host_storage_hist_desc constant varchar2(50) := 
    'Host Storage History';
  g_host_storage_repmetric_short  constant varchar2(20) := 
    'Storage History';
  g_host_storage_rep_metric_proc  constant varchar2(70) := 
    'storage_rep_metrics_pkg.calc_storage_history';

  -- host history collection related constants
  g_host_storage_hist_coll constant varchar2(50) := 
    'Host_Storage_History_Collection';

  -- add target callback procedure name
  g_start_collection_callback constant varchar2(50) := 
    'storage_rep_metrics.start_storage_rep_collection';

  -- delete target callback procedure name
  g_stop_collection_callback constant varchar2(50) := 
    'storage_rep_metrics.stop_storage_rep_collection';

  /*--------------------------------------------------------*/
  /*--------------- Group repository metric constants ------*/
  /*--------------------------------------------------------*/
  
  -- group storage history metric name (it is a table metric)

  g_group_storage_rep_metric constant varchar2(30) 
    := 'group_storage_history';

  -- other metric related constants for group targets
  g_grp_storage_rep_metric_lbl constant varchar2(30) := 
    g_host_storage_rep_metric_lbl;
  g_grp_storage_hist_met_nlsid constant varchar2(30) := 
    'group_hist_metric_nlsid';
  g_grp_storage_hist_desc constant varchar2(50) := 
    'Group Storage History';
  g_grp_storage_rep_metric_short  constant varchar2(20) := 
    'Storage History';
  g_grp_storage_rep_metric_proc  constant varchar2(70) := 
    'storage_rep_metrics_pkg.calc_storage_history';

  -- group history collection related constants
  G_GROUP_STORAGE_HIST_COLL CONSTANT VARCHAR2(50) := 
    'Group_Storage_History_Collection';

  
  /*--------------------------------------------------------*/
  /*--------- constants to create repository metric --------*/
  /*--------------------------------------------------------*/

  G_GRP_COLUMN_NAME_LIST  CONSTANT mgmt_short_string_array := 
    mgmt_short_string_array
    (
      storage_rep_metrics_pkg.G_TOTAL_USED,
      storage_rep_metrics_pkg.G_TOTAL_FREE,
      storage_rep_metrics_pkg.G_TOTAL_UNALLOCATED,
      storage_rep_metrics_pkg.G_TOTAL_ALLOCATED,
      storage_rep_metrics_pkg.G_TOTAL_OVERHEAD,
      storage_rep_metrics_pkg.G_DB_USED,
      storage_rep_metrics_pkg.G_DB_FREE,
      storage_rep_metrics_pkg.G_LOCAL_FS_USED,
      storage_rep_metrics_pkg.G_LOCAL_FS_FREE,
      storage_rep_metrics_pkg.G_WRITEABLE_NFS_USED,
      storage_rep_metrics_pkg.G_WRITEABLE_NFS_FREE,
      storage_rep_metrics_pkg.G_VOL_UNALLOCATED,
      storage_rep_metrics_pkg.G_VOL_ALLOCATED,
      storage_rep_metrics_pkg.G_VOL_OVERHEAD,
      storage_rep_metrics_pkg.G_ASM_ALLOCATED,
      storage_rep_metrics_pkg.G_ASM_UNALLOCATED,
      storage_rep_metrics_pkg.G_ASM_OVERHEAD,
      storage_rep_metrics_pkg.G_DISKS_ALLOCATED,
      storage_rep_metrics_pkg.G_DISKS_UNALLOCATED,
      storage_rep_metrics_pkg.G_TOTAL_HOSTS,
      storage_rep_metrics_pkg.G_SUMMARIZED_HOSTS,
      storage_rep_metrics_pkg.G_TOTAL_DBS,
      storage_rep_metrics_pkg.G_SUMMARIZED_DBS,
      storage_rep_metrics_pkg.G_TOTAL_ASM,
      storage_rep_metrics_pkg.G_SUMMARIZED_ASM,
      storage_rep_metrics_pkg.G_UNMONITORED_NFS,
      storage_rep_metrics_pkg.G_OTHER_MAP_ERR,
      storage_rep_metrics_pkg.G_HOST_METRIC_ERR,
      storage_rep_metrics_pkg.G_DB_METRIC_ERR,
      storage_rep_metrics_pkg.G_ASM_METRIC_ERR
    );

  G_GRP_COLUMN_LABEL_LIST  CONSTANT mgmt_short_string_array := 
    mgmt_short_string_array
    (
      storage_rep_metrics_pkg.G_TOTAL_USED_LBL,
      storage_rep_metrics_pkg.G_TOTAL_FREE_LBL,
      storage_rep_metrics_pkg.G_TOTAL_UNALLOCATED_LBL,
      storage_rep_metrics_pkg.G_TOTAL_ALLOCATED_LBL,
      storage_rep_metrics_pkg.G_TOTAL_OVERHEAD_LBL,
      storage_rep_metrics_pkg.G_DB_USED_LBL,
      storage_rep_metrics_pkg.G_DB_FREE_LBL,
      storage_rep_metrics_pkg.G_LOCAL_FS_USED_LBL,
      storage_rep_metrics_pkg.G_LOCAL_FS_FREE_LBL,
      storage_rep_metrics_pkg.G_WRITEABLE_NFS_USED_LBL,
      storage_rep_metrics_pkg.G_WRITEABLE_NFS_FREE_LBL,
      storage_rep_metrics_pkg.G_VOL_UNALLOCATED_LBL,
      storage_rep_metrics_pkg.G_VOL_ALLOCATED_LBL,
      storage_rep_metrics_pkg.G_VOL_OVERHEAD_LBL,
      storage_rep_metrics_pkg.G_ASM_ALLOCATED_LBL,
      storage_rep_metrics_pkg.G_ASM_UNALLOCATED_LBL,
      storage_rep_metrics_pkg.G_ASM_OVERHEAD_LBL,
      storage_rep_metrics_pkg.G_DISKS_ALLOCATED_LBL,
      storage_rep_metrics_pkg.G_DISKS_UNALLOCATED_LBL,
      storage_rep_metrics_pkg.G_TOTAL_HOSTS_LBL,
      storage_rep_metrics_pkg.G_SUMMARIZED_HOSTS_LBL,
      storage_rep_metrics_pkg.G_TOTAL_DBS_LBL,
      storage_rep_metrics_pkg.G_SUMMARIZED_DBS_LBL,
      storage_rep_metrics_pkg.G_TOTAL_ASM_LBL,
      storage_rep_metrics_pkg.G_SUMMARIZED_ASM_LBL,
      storage_rep_metrics_pkg.G_UNMONITORED_NFS_LBL,
      storage_rep_metrics_pkg.G_OTHER_MAP_ERR_LBL,
      storage_rep_metrics_pkg.G_HOST_METRIC_ERR_LBL,
      storage_rep_metrics_pkg.G_DB_METRIC_ERR_LBL,
      storage_rep_metrics_pkg.G_ASM_METRIC_ERR_LBL
    );
  G_GRP_COLUMN_NLSID_LIST  CONSTANT mgmt_short_string_array := 
    mgmt_short_string_array
    (
      storage_rep_metrics_pkg.G_TOTAL_USED_NLSID,
      storage_rep_metrics_pkg.G_TOTAL_FREE_NLSID,
      storage_rep_metrics_pkg.G_TOTAL_UNALLOCATED_NLSID,
      storage_rep_metrics_pkg.G_TOTAL_ALLOCATED_NLSID,
      storage_rep_metrics_pkg.G_TOTAL_OVERHEAD_NLSID,
      storage_rep_metrics_pkg.G_DB_USED_NLSID,
      storage_rep_metrics_pkg.G_DB_FREE_NLSID,
      storage_rep_metrics_pkg.G_LOCAL_FS_USED_NLSID,
      storage_rep_metrics_pkg.G_LOCAL_FS_FREE_NLSID,
      storage_rep_metrics_pkg.G_WRITEABLE_NFS_USED_NLSID,
      storage_rep_metrics_pkg.G_WRITEABLE_NFS_FREE_NLSID,
      storage_rep_metrics_pkg.G_VOL_UNALLOCATED_NLSID,
      storage_rep_metrics_pkg.G_VOL_ALLOCATED_NLSID,
      storage_rep_metrics_pkg.G_VOL_OVERHEAD_NLSID,
      storage_rep_metrics_pkg.G_ASM_ALLOCATED_NLSID,
      storage_rep_metrics_pkg.G_ASM_UNALLOCATED_NLSID,
      storage_rep_metrics_pkg.G_ASM_OVERHEAD_NLSID,
      storage_rep_metrics_pkg.G_DISKS_ALLOCATED_NLSID,
      storage_rep_metrics_pkg.G_DISKS_UNALLOCATED_NLSID,
      storage_rep_metrics_pkg.G_TOTAL_HOSTS_NLSID,
      storage_rep_metrics_pkg.G_SUMMARIZED_HOSTS_NLSID,
      storage_rep_metrics_pkg.G_TOTAL_DBS_NLSID,
      storage_rep_metrics_pkg.G_SUMMARIZED_DBS_NLSID,
      storage_rep_metrics_pkg.G_TOTAL_ASM_NLSID,
      storage_rep_metrics_pkg.G_SUMMARIZED_ASM_NLSID,
      storage_rep_metrics_pkg.G_UNMONITORED_NFS_NLSID,
      storage_rep_metrics_pkg.G_OTHER_MAP_ERR_NLSID,
      storage_rep_metrics_pkg.G_HOST_METRIC_ERR_NLSID,
      storage_rep_metrics_pkg.G_DB_METRIC_ERR_NLSID,
      storage_rep_metrics_pkg.G_ASM_METRIC_ERR_NLSID
    );

  G_HOST_COLUMN_NAME_LIST  CONSTANT mgmt_short_string_array := 
    mgmt_short_string_array
    (
      storage_rep_metrics_pkg.G_TOTAL_USED,
      storage_rep_metrics_pkg.G_TOTAL_FREE,
      storage_rep_metrics_pkg.G_TOTAL_UNALLOCATED,
      storage_rep_metrics_pkg.G_TOTAL_ALLOCATED,
      storage_rep_metrics_pkg.G_TOTAL_OVERHEAD,
      storage_rep_metrics_pkg.G_DB_USED,
      storage_rep_metrics_pkg.G_DB_FREE,
      storage_rep_metrics_pkg.G_LOCAL_FS_USED,
      storage_rep_metrics_pkg.G_LOCAL_FS_FREE,
      storage_rep_metrics_pkg.G_WRITEABLE_NFS_USED,
      storage_rep_metrics_pkg.G_WRITEABLE_NFS_FREE,
      storage_rep_metrics_pkg.G_VOL_UNALLOCATED,
      storage_rep_metrics_pkg.G_VOL_ALLOCATED,
      storage_rep_metrics_pkg.G_VOL_OVERHEAD,
      storage_rep_metrics_pkg.G_ASM_ALLOCATED,
      storage_rep_metrics_pkg.G_ASM_UNALLOCATED,
      storage_rep_metrics_pkg.G_ASM_OVERHEAD,
      storage_rep_metrics_pkg.G_DISKS_ALLOCATED,
      storage_rep_metrics_pkg.G_DISKS_UNALLOCATED,
      storage_rep_metrics_pkg.G_SUMMARIZED_HOSTS,
      storage_rep_metrics_pkg.G_TOTAL_DBS,
      storage_rep_metrics_pkg.G_SUMMARIZED_DBS,
      storage_rep_metrics_pkg.G_TOTAL_ASM,
      storage_rep_metrics_pkg.G_SUMMARIZED_ASM,
      storage_rep_metrics_pkg.G_UNMONITORED_NFS,
      storage_rep_metrics_pkg.G_OTHER_MAP_ERR,
      storage_rep_metrics_pkg.G_HOST_METRIC_ERR,
      storage_rep_metrics_pkg.G_DB_METRIC_ERR,
      storage_rep_metrics_pkg.G_ASM_METRIC_ERR
    );

  G_HOST_COLUMN_LABEL_LIST  CONSTANT mgmt_short_string_array := 
    mgmt_short_string_array
    (
      storage_rep_metrics_pkg.G_TOTAL_USED_LBL,
      storage_rep_metrics_pkg.G_TOTAL_FREE_LBL,
      storage_rep_metrics_pkg.G_TOTAL_UNALLOCATED_LBL,
      storage_rep_metrics_pkg.G_TOTAL_ALLOCATED_LBL,
      storage_rep_metrics_pkg.G_TOTAL_OVERHEAD_LBL,
      storage_rep_metrics_pkg.G_DB_USED_LBL,
      storage_rep_metrics_pkg.G_DB_FREE_LBL,
      storage_rep_metrics_pkg.G_LOCAL_FS_USED_LBL,
      storage_rep_metrics_pkg.G_LOCAL_FS_FREE_LBL,
      storage_rep_metrics_pkg.G_WRITEABLE_NFS_USED_LBL,
      storage_rep_metrics_pkg.G_WRITEABLE_NFS_FREE_LBL,
      storage_rep_metrics_pkg.G_VOL_UNALLOCATED_LBL,
      storage_rep_metrics_pkg.G_VOL_ALLOCATED_LBL,
      storage_rep_metrics_pkg.G_VOL_OVERHEAD_LBL,
      storage_rep_metrics_pkg.G_ASM_ALLOCATED_LBL,
      storage_rep_metrics_pkg.G_ASM_UNALLOCATED_LBL,
      storage_rep_metrics_pkg.G_ASM_OVERHEAD_LBL,
      storage_rep_metrics_pkg.G_DISKS_ALLOCATED_LBL,
      storage_rep_metrics_pkg.G_DISKS_UNALLOCATED_LBL,
      storage_rep_metrics_pkg.G_HOST_SUMM_HOSTS_LBL,
      storage_rep_metrics_pkg.G_TOTAL_DBS_LBL,
      storage_rep_metrics_pkg.G_SUMMARIZED_DBS_LBL,
      storage_rep_metrics_pkg.G_TOTAL_ASM_LBL,
      storage_rep_metrics_pkg.G_SUMMARIZED_ASM_LBL,
      storage_rep_metrics_pkg.G_UNMONITORED_NFS_LBL,
      storage_rep_metrics_pkg.G_OTHER_MAP_ERR_LBL,
      storage_rep_metrics_pkg.G_HOST_METRIC_ERR_LBL,
      storage_rep_metrics_pkg.G_DB_METRIC_ERR_LBL,
      storage_rep_metrics_pkg.G_ASM_METRIC_ERR_LBL
    );
  G_HOST_COLUMN_NLSID_LIST  CONSTANT mgmt_short_string_array := 
    mgmt_short_string_array
    (
      storage_rep_metrics_pkg.G_TOTAL_USED_NLSID,
      storage_rep_metrics_pkg.G_TOTAL_FREE_NLSID,
      storage_rep_metrics_pkg.G_TOTAL_UNALLOCATED_NLSID,
      storage_rep_metrics_pkg.G_TOTAL_ALLOCATED_NLSID,
      storage_rep_metrics_pkg.G_TOTAL_OVERHEAD_NLSID,
      storage_rep_metrics_pkg.G_DB_USED_NLSID,
      storage_rep_metrics_pkg.G_DB_FREE_NLSID,
      storage_rep_metrics_pkg.G_LOCAL_FS_USED_NLSID,
      storage_rep_metrics_pkg.G_LOCAL_FS_FREE_NLSID,
      storage_rep_metrics_pkg.G_WRITEABLE_NFS_USED_NLSID,
      storage_rep_metrics_pkg.G_WRITEABLE_NFS_FREE_NLSID,
      storage_rep_metrics_pkg.G_VOL_UNALLOCATED_NLSID,
      storage_rep_metrics_pkg.G_VOL_ALLOCATED_NLSID,
      storage_rep_metrics_pkg.G_VOL_OVERHEAD_NLSID,
      storage_rep_metrics_pkg.G_ASM_ALLOCATED_NLSID,
      storage_rep_metrics_pkg.G_ASM_UNALLOCATED_NLSID,
      storage_rep_metrics_pkg.G_ASM_OVERHEAD_NLSID,
      storage_rep_metrics_pkg.G_DISKS_ALLOCATED_NLSID,
      storage_rep_metrics_pkg.G_DISKS_UNALLOCATED_NLSID,
      storage_rep_metrics_pkg.G_HOST_SUMM_HOSTS_NLSID,
      storage_rep_metrics_pkg.G_TOTAL_DBS_NLSID,
      storage_rep_metrics_pkg.G_SUMMARIZED_DBS_NLSID,
      storage_rep_metrics_pkg.G_TOTAL_ASM_NLSID,
      storage_rep_metrics_pkg.G_SUMMARIZED_ASM_NLSID,
      storage_rep_metrics_pkg.G_UNMONITORED_NFS_NLSID,
      storage_rep_metrics_pkg.G_OTHER_MAP_ERR_NLSID,
      storage_rep_metrics_pkg.G_HOST_METRIC_ERR_NLSID,
      storage_rep_metrics_pkg.G_DB_METRIC_ERR_NLSID,
      storage_rep_metrics_pkg.G_ASM_METRIC_ERR_NLSID
    );
  --------------------------------------------------------
  --
  --  Name: calc_storage_history
  --
  --  Package: storage_rep_metrics
  --
  --  Purpose:
  --    Calculates storage host history related repository metrics.
  --    Returns the result in the form of mgmt_metric_results.
  --    The calculated data includes:
  --    1. host_overhead
  --    2. host_used
  --    3. host_free
  --    4. host_unallocated
  --    5. host_allocated
  --    6. db_used
  --    7. db_free
  --    8. local_fs_used
  --    9. local_fs_free
  --   10. writeable_nfs_used
  --   11. writeable_nfs_free
  --   12. vol_allocated
  --   13. vol_unallocated
  --   14. vol_overhead
  --   15. asm_allocated
  --   16. asm_unallocated
  --   17. asm_overhead
  --   18. disk_allocated
  --   19. disk_unallocated
  --
  --  IN Parameters:
  --    p_target_guid - the target guid if the host
  --    p_metric_guid - the metric guid of the repository metric
  --
  --  OUT Parameters:
  --    p_metric_result      - host storage repository metric
  --                           calculation results as required by
  --                           the repository metrics API.
  --
  --  NOTE:
  --  The signature of this procedure is dictated by the
  --  the repository collections SDK requirements.
  -----------------------------------------------------------

  PROCEDURE calc_storage_history 
  ( 
    p_target_guid IN raw, 
    p_metric_guid IN raw, 
    p_metric_result OUT mgmt_metric_results 
  );

  --------------------------------------------------------
  --
  --  Name: test_rep_metrics
  --
  --  Package: storage_rep_metrics
  --
  --  Purpose:
  --   Execute the storage repository metrics for the 
  --   specified target and print results to stdout
  --   . The target can be a host or a composite
  --------------------------------------------------------
  PROCEDURE test_rep_metrics
  (
    p_target_name   mgmt_targets.target_name%TYPE,
    p_target_type   mgmt_targets.target_type%TYPE DEFAULT MGMT_GLOBAL.G_HOST_TARGET_TYPE
  );

  --------------------------------------------------------
  --
  --  Name: create_storage_rep_hist_metric
  --
  --  Package: storage_rep_metrics
  --
  --  Purpose:
  --
  --    To add group storage history repository metric that 
  --    gets collected daily. The metric contains storage related data 
  --    to be shown in the storage history UI of group (or other
  --    similar "aggregate" target type.  Note that this API should
  --    be used for a target type that can have more than one
  --    hosts associated with it. Also the target type home page
  --    should register a "Storage Details" related link.
  --
  --  IN Parameters:
  --    p_target_type - type of the target
  --    p_type_meta_ver - the target type meta version
  -- 
  --  OUT Parameters:
  -----------------------------------------------------------

  PROCEDURE create_storage_rep_hist_metric
  (
    p_target_type IN mgmt_targets.target_type%TYPE,
    p_type_meta_ver IN mgmt_metrics.type_meta_ver%TYPE
  );

END storage_rep_metrics_pkg;
/
SHOW ERRORS;


