Rem
Rem $Header: storage_ui_group_pkgdef.sql 20-jul-2005.11:33:23 ajdsouza Exp $
Rem
Rem storage_ui_group_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      storage_ui_group_pkgdef.sql - sql procedures/functions
Rem                                    used by storage UI for groups.
Rem
Rem    DESCRIPTION
Rem      contains methods invoked by the middle tier to render
Rem      storage UI for groups.
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ajdsouza    07/13/05 - add fn get_host_targets
Rem    rmenon      02/24/05 - 
Rem    rmenon      11/04/04 - consolidated storage error logic
Rem    rmenon      09/20/04 - 
Rem    rmenon      09/08/04 - group refresh, allocation summary subtab,
Rem                           usage sumary subtab  related methods
Rem    rmenon      08/24/04 - rmenon_storage_ui
Rem    rmenon      08/23/04 - Created
Rem

SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

create or replace package storage_ui_group_pkg 
as
  /*
    -- global constants
   */

  G_GRP_STORAGE_HIST_ENABLED      CONSTANT VARCHAR2(30) := 
      'GROUP_STORAGE_HISTORY_ENABLED';

  G_GROUP_REFRESH_JOB_TYPE        CONSTANT VARCHAR2( 20 ) := 'RefreshGroupStorage';
  g_group_job_desc_prefix         CONSTANT VARCHAR2(40)   := 
   'Refreshing group storage for group: ';

  ------------------------------------------------------
  --  Name: get_job_execution_status
  --
  --  Package: storage_ui_group_pkg
  --
  --  Purpose:
  --    returns status of the job
  --
  --  IN Parameters:
  --    p_job_name - the job name
  --    p_execution_id - the job execution id
  --
  --  OUT Parameters:
  --    p_job_execution_status - status of job execution
  -----------------------------------------------------------

  PROCEDURE get_job_execution_status
  ( 
    p_job_name IN mgmt_job.job_name%TYPE,
    p_execution_id IN mgmt_job_exec_summary.execution_id%TYPE,
    p_job_execution_status IN OUT mgmt_job_exec_summary.status%TYPE
  );

  ------------------------------------------------------
  --  Name: get_host_targets
  --
  --  Package: storage_ui_group_pkg
  --
  --  Purpose:
  --    returns list of hosts with storage collections
  --
  --  IN Parameters:
  --    p_group_name - the group name
  --
  --  OUT Parameters:
  --    p_host_list - the list of hosts
  ----------------------------------------------------------
  PROCEDURE get_host_targets
  (
    p_aggregate_name IN  mgmt_targets.target_name%TYPE,
    p_aggregate_type IN  mgmt_targets.target_type%TYPE,
    p_host_list      OUT MGMT_MEDIUM_STRING_TABLE
  );

  ------------------------------------------------------
  --  Name: get_alloc_summary_by_host
  --
  --  Package: storage_ui_group_pkg
  --
  --  Purpose:
  --    gets the allocation summary by host data to be rendered
  --    in storage group UI.
  --
  --  IN Parameters:
  --    p_target_name - the target name of group
  --    p_target_type - the target type of group
  -- 
  --  OUT Parameters:
  --    p_storage_unit - the storage unit in which UI will render
  --    p_asm_exists - 'Y', if at least one host in group has ASM
  --                        data, 'N' otherwise
  --    p_volume_exists - 'Y', if at least one host in group has volume
  --                        data, 'N' otherwise
  --
  --    p_local_disk_exists - 'Y', if at least one host in group has 
  --                        local disks data, 'N' otherwise
  --    p_writeable_nfs_exists - 'Y', if at least one host in group has 
  --                        writeable NFS data, 'N' otherwise
  --    p_alloc_summary_cursor - ref cursor to allocation summary by host
  --                             data
  -----------------------------------------------------------

  procedure get_alloc_summary_by_host ( 
    p_target_name in varchar2,
    p_target_type in varchar2,
    p_storage_unit in out varchar2,
    p_asm_exists in out varchar2,
    p_volume_exists in out varchar2,
    p_local_disk_exists in out varchar2,
    p_writeable_nfs_exists in out varchar2,
    p_alloc_summary_cursor in out sys_refcursor );

  ------------------------------------------------------
  --  Name: get_usage_summary_by_host
  --
  --  Package: storage_ui_group_pkg
  --
  --  Purpose:
  --    gets the usage summary by host data to be rendered
  --    in storage group UI.
  --
  --  IN Parameters:
  --    p_target_name - the target name of group
  --    p_target_type - the target type of group
  -- 
  --  OUT Parameters:
  --    p_storage_unit - the storage unit in which UI will render
  --    p_db_exists - 'Y', if at least one host in group has db
  --                        data, 'N' otherwise
  --    p_local_fs_exists - 'Y', if at least one host in group has 
  --                        local fs data, 'N' otherwise
  --    p_writeable_nfs_exists - 'Y', if at least one host in group has 
  --                        writeable NFS data, 'N' otherwise
  --    p_usage_summary_cursor - ref cursor to usage summary by host
  --                             data
  -----------------------------------------------------------
  procedure get_usage_summary_by_host ( 
    p_target_name in varchar2,
    p_target_type in varchar2,
    p_storage_unit in out varchar2,
    p_db_exists in out varchar2,
    p_local_fs_exists in out varchar2,
    p_writeable_nfs_exists in out varchar2,
    p_usage_summary_cursor in out sys_refcursor );

  ------------------------------------------------------
  --  Name: set_group_history_flag
  --
  --  Package: storage_ui_group_pkg
  --
  --  Purpose:
  --    this procedure enables or disables group storage history.
  --    If invoked with a value of 'Y' for p_enable_disable_flag,
  --    it enables group storage history. 
  --    If invoked with a value other than 'Y' for p_enable_disable_flag,
  --    it disables group storage history. Note that this procedure
  --    just sets a flag that determines the enabling of group
  --    storage history - it does not take any actions related to 
  --    group history. For example, disabling group storage history
  --    will not result in any purging of existing history data.
  --    only the UI would stop showing history and the repository
  --    collection would disable itself in the next run.
  -- 
  --  IN Parameters:
  --    p_target_name - the target name of group
  --    p_target_type - the target type of group
  --    p_enable_disable_flag - the flag that enables or disables
  --                            group storage. If 'Y', enables,
  --                            otherwise disables group storage
  -- 
  --  OUT Parameters:
  -----------------------------------------------------------
  procedure set_group_history_flag(
    p_target_name in varchar2,
    p_target_type in varchar2,
    p_enable_disable_flag in varchar2 );

  ------------------------------------------------------
  --  Name: enable_hist_and_run_coll
  --
  --  Package: storage_ui_group_pkg
  --
  --  Purpose:
  --    this procedure enables group storage history. It then
  --    runs the repository collection that would calculate
  --    grup storage history for this group once.
  -- 
  --  IN Parameters:
  --    p_target_name - the target name of group
  --    p_target_type - the target type of group
  -- 
  --  OUT Parameters:
  -----------------------------------------------------------
  procedure enable_hist_and_run_coll(
    p_target_name in varchar2,
    p_target_type in varchar2 );

  ------------------------------------------------------
  --  Name: get_storage_hist_enabled
  --
  --  Package: storage_ui_group_pkg
  --
  --  Purpose:
  --    this function returns 'Y' if storage history for a group
  --    is enabled, 'N' otherwise.
  -- 
  --  IN Parameters:
  --    p_group_name - the target name of group
  --    p_target_type - the target type of group
  -- 
  --  Returns:
  --    'Y' if storage history for a group is enabled, 'N' otherwise.
  -----------------------------------------------------------
  function get_storage_hist_enabled ( p_group_name in varchar2,
    p_target_type in varchar2 default mgmt_global.G_COMPOSITE_TARGET_TYPE )
    return varchar2;

END;
/
SHOW ERRORS;
