Rem
Rem $Header: storage_ui_host_pkgdef.sql 16-jun-2005.17:47:57 ajere Exp $
Rem
Rem storage_ui_host_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      storage_ui_host_pkgdef.sql 
Rem
Rem    DESCRIPTION
Rem      package for retrieving host storage ui data
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ajere       06/16/05 - Fix bug# 4300002 
Rem    rmenon      02/16/05 - added timezone retrieval (bug 4186450)
Rem    rmenon      12/20/04 - 
Rem    rmenon      11/04/04 - consolidated storage error logic
Rem    rmenon      09/21/04 - 
Rem    rmenon      09/08/04 - 
Rem    rmenon      08/18/04 - 
Rem    rmenon      08/16/04 - refresh functionality;
Rem                           errors page functionality
Rem                           host storage history functionality;
Rem    ajdsouza    08/09/04 - 
Rem    rmenon      08/02/04 - rmenon_storage_refresh_error_page_checkin
Rem    rmenon      08/02/04 - created new file in storage component;
Rem                           added code for refresh logic; 
Rem                           integration of host detail page
Rem                           with real data; error page.
Rem    rmenon      07/07/04 - 
Rem    rmenon      06/28/04 - rmenon_storage_disks_tab_ui
Rem    rmenon      06/10/04 - Created
Rem

Rem SET ECHO ON
Rem SET FEEDBACK 1
Rem SET NUMWIDTH 10
Rem SET LINESIZE 80
Rem SET TRIMSPOOL ON
Rem SET TAB OFF
Rem SET PAGESIZE 100

create or replace package storage_ui_host_pkg
as

  /* global constants */
  G_MODULE_NAME constant varchar2(30) := 'STORAGE_UI_HOST_PKG';
  THREE_MONTHS constant varchar2(2) := '3M';
  ONE_MONTH    constant varchar2(2) := '1M';
  ONE_YEAR     constant varchar2(3) := '12M';
  DAYS_PER_MONTH constant int       := 30;

  /*------------------------------------------------------
    Name: get_host_disks_storage

    Package: storage_ui_host_pkg

    Purpose:
      gets storage data to render the storage information for 
      the local disks on a host.

    IN Parameters:
      p_target_name - the target name (host name)
      p_target_type - the target type. we pass it only in the
        hope that the same function could perhaps be used
        for non-host target types
      p_resource_type - resource type(e.g. 'Disk', 'Partition' 
        etc.) For selecting all resources set this to '%'.

    OUT Parameters:
      p_disks_storage_data - storage data of disks on the host
      p_resource_types     - distinct resource types for disks -
                             e.g. 'Disk', 'Partition' etc.
   -------------------------------------------------------*/

  PROCEDURE get_host_disks_storage ( p_target_name IN VARCHAR2,
    p_target_type IN VARCHAR2 default mgmt_global.G_HOST_TARGET_TYPE,
    p_resource_type IN VARCHAR2,
    p_disks_storage_data IN OUT SYS_REFCURSOR,
    p_resource_types IN OUT SYS_REFCURSOR );

  ----------------------------------------------------------
  --  Name: get_host_volumes_storage
  --
  --   Package: storage_ui_host_pkg
  --
  --   Purpose:
  --     gets storage data to render the storage information for 
  --     the volumes on a host.
  --
  --   IN Parameters:
  --      p_target_name - the target name (host name)
  --     p_target_type - the target type. 
  --     p_resource_type - resource type(e.g. 'Disk', 'Partition' 
  --       etc.) For selecting all resources set this to '%'.

  --   OUT Parameters:
  --     p_prod_vendor_comb_count - number of rows that have distinct
  --                                  vendor and product combinations
  --     p_prod_vendor_combination - number of distinct product and
  --                                 vendor combinations. This info
  --                                 is used to render the UI in
  --                                 different ways if there is only
  --                                 one vendor product versus many.
  --     p_vol_storage_data - storage data of volumes on the host
  --     p_resource_types     - distinct resource types for volumes -
  --                            e.g. 'Volume', 'Plex' etc.
  ---------------------------------------------------------

  PROCEDURE get_host_volumes_storage ( p_target_name IN VARCHAR2,
    p_target_type IN VARCHAR2 default mgmt_global.G_HOST_TARGET_TYPE,
    p_resource_type IN VARCHAR2,
    p_prod_vendor_comb_count IN OUT number,
    p_prod_vendor_combination IN OUT SYS_REFCURSOR,
    p_vol_storage_data IN OUT SYS_REFCURSOR,
    p_resource_types IN OUT SYS_REFCURSOR );
  ----------------------------------------------------------
  --  Name: get_host_fs_storage
  --
  --   Package: storage_ui_host_pkg
  --
  --   Purpose:
  --     gets storage details of file systems (local and network)
  --     on a host.
  --
  --   IN Parameters:
  --     p_target_name - the target name 
  --     p_target_type - the target type. 
  --     p_resource_type - resource type(e.g. 'ufs', 'nfs' etc.)
  --                       For selecting all resources set this to '%'.
  --
  --   OUT Parameters:
  --     p_fs_storage_data - storage data of fs on the host
  --     p_resource_types     - distinct resource types for fs -
  --                            e.g. 'ufs', 'nfs' etc.
  ---------------------------------------------------------

  PROCEDURE get_host_fs_storage ( 
    p_target_name IN VARCHAR2,
    p_target_type IN VARCHAR2 default mgmt_global.G_HOST_TARGET_TYPE,
    p_resource_type IN VARCHAR2,
    p_fs_storage_data IN OUT SYS_REFCURSOR,
    p_resource_types IN OUT SYS_REFCURSOR );

  ----------------------------------------------------------
  --  Name: get_host_db_storage
  --
  --   Package: storage_ui_host_pkg
  --
  --   Purpose:
  --     gets storage details of databases (non rac and rac)
  --     on a host.
  --
  --   IN Parameters:
  --     p_target_name - the target name 
  --     p_target_type - the target type. 
  --     p_storage_unit - the storage unit
  --
  --   OUT Parameters:
  --     p_nonrac_db_count - count of how many non rac
  --                         dbs exist on the host. Based on this 
  --                         and p_rac_db_count, one of the three 
  --                         cursors is populated.
  --     p_rac_db_count - count of how many rac 
  --                      dbs exist on the host. Based on this
  --                      count and p_nonrac_db_count, one of the 
  --                       three cursors is populated.
  --     p_db_storage_data - This cursor contains one of the following:
  --                       * storage data of standalone
  --                         dbs on the host
  --                         (if only non-rac dbs exist)
  --                       * storage data of RAC dbs on the host
  --                             (if only RAC dbs exist)
  --                       * storage data of standalone and RAC
  --                         dbs on the host (if both exist)
  ---------------------------------------------------------

  PROCEDURE get_host_db_storage ( 
    p_target_name IN VARCHAR2,
    p_target_type IN VARCHAR2 default mgmt_global.G_HOST_TARGET_TYPE,
    p_storage_unit IN VARCHAR2,
    p_nonrac_db_count IN OUT int,
    p_rac_db_count IN OUT int,
    p_db_storage_data IN OUT SYS_REFCURSOR );
    
  ----------------------------------------------------------
  --  Name: get_host_asm_storage
  --
  --   Package: storage_ui_host_pkg
  --
  --   Purpose:
  --     gets storage details of ASM on a host.
  --
  --   IN Parameters:
  --     p_target_name - the target name 
  --     p_target_type - the target type. 
  --     p_storage_unit - the storage unit
  --
  --   OUT Parameters:
  --     p_asm_storage_data - cursor containing asm storage
  --                          data.
  ---------------------------------------------------------

  PROCEDURE get_host_asm_storage 
  ( 
    p_target_name IN VARCHAR2,
    p_target_type IN VARCHAR2 default mgmt_global.G_HOST_TARGET_TYPE,
    p_storage_unit IN VARCHAR2,
    p_asm_storage_data IN OUT SYS_REFCURSOR 
  );

  --------------------------------------------------------
  --  Name: get_info_for_storage_refresh
  --
  --  Package: storage_ui_host_pkg
  --
  --  Purpose:
  --    gets the information needed to complete an on-demand refresh 
  --    of the storage data of a host.
  --
 --   IN Parameters:
  --    p_target_name - the host name 
  --    p_target_type - the target type. we pass it only in the
  --      hope that the same function could perhaps be used
  --      for non-host target types
  --
  --  OUT Parameters:
  --    p_info_for_storage_refresh - ref cursor containing
  --      information required to refresh host storage data.
  ---------------------------------------------------------

  PROCEDURE get_info_for_storage_refresh 
  ( 
    p_target_name IN VARCHAR2,
    p_target_type IN VARCHAR2 default mgmt_global.G_HOST_TARGET_TYPE,
    p_info_for_storage_refresh IN OUT SYS_REFCURSOR 
  );

  --------------------------------------------------------
  --  Name: get_hosts_sharing_resource
  --
  --  Package: storage_ui_host_pkg
  --
  --  Purpose:
  --    gets list of hosts sharing a given resource.
  --    The resource could be disks, volumes etc.
  --
  --  IN Parameters:
  --    p_target_name - the host name 
  --    p_target_type - the target type. we pass it only in the
  --      hope that the same function could perhaps be used
  --      for non-host target types
  --    p_global_unique_id - the global unique id of the
  --      resource.
  --               
  --  OUT Parameters:
  --    p_target_timezone_region - target timezone region
  --    p_collection_timestamp - latest collection timestamp
  --                             of history data.
  --    p_hosts_sharing_resource - list of hosts sharing 
  --                               the given resource.
  -----------------------------------------------------------
  PROCEDURE get_hosts_sharing_resource 
  (
    p_target_name IN VARCHAR2,
    p_target_type IN VARCHAR2 default mgmt_global.G_HOST_TARGET_TYPE,
    p_global_unique_id IN VARCHAR2,
    p_target_timezone_region IN OUT VARCHAR2,
    p_collection_timestamp IN OUT date, 
    p_hosts_sharing_resource IN OUT SYS_REFCURSOR 
  );

END;
/
show errors;

