Rem
Rem $Header: storage_ui_util_pkgbody.sql 31-jan-2005.14:52:28 rmenon Exp $
Rem
Rem storage_ui_util_pkgbody.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      storage_ui_util_pkgbody.sql 
Rem
Rem    DESCRIPTION
Rem      utilities used in rendering storage reports UI.
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rmenon      01/31/05 - formatted as per standards; tried to add
Rem                           sql trace methods - but failed as sysman
Rem                           does not have direct "alter session" privilege.
Rem    rmenon      01/10/05 - 
Rem    rmenon      09/28/04 - added target type parameter to 
Rem                           raise_err_if_no_snapshot
Rem    rmenon      08/27/04 - added method raise_err_if_no_snapshot
Rem    rmenon      08/16/04 - 
Rem    rmenon      08/02/04 - rmenon_storage_refresh_error_page_checkin
Rem    rmenon      08/02/04 - created new file in storage component;
Rem                           integration of host detail page
Rem                           with real data; error page.
Rem    rmenon      07/07/04 - 
Rem    rmenon      06/28/04 - rmenon_storage_disks_tab_ui
Rem    rmenon      06/10/04 - Created
Rem

Rem SET ECHO ON
Rem SET FEEDBACK 1
Rem SET NUMWIDTH 10
Rem SET LINESIZE 80
Rem SET TRIMSPOOL ON
Rem SET TAB OFF
Rem SET PAGESIZE 100

CREATE OR REPLACE PACKAGE BODY storage_ui_util_pkg
as
  /*-------------   convert_into_storage_unit ----------
    converts the given number into a given storage unit

    PARAMETERS
    ----------
      p_storage_data_in_bytes - storage data (assumes it represents 
                         storage data is in bytes )
      p_storage_unit - the unit to which the passed storage 
        data should be converted to. If the storage unit is not
        defined to be one of the recognized constants, it returns
        the original number without any conversion.
       
    RETURNS
    -------
      the converted storage data number.

    IMPLEMENTATION NOTES
    --------------------
   -------------------------------------------------------*/
  FUNCTION convert_into_storage_unit ( p_storage_data_in_bytes IN NUMBER,
    p_storage_unit IN VARCHAR2 )
    RETURN NUMBER
  IS
    l_result_storage_data number;
  BEGIN
    l_result_storage_data := p_storage_data_in_bytes;

    IF( p_storage_unit = storage_ui_util_pkg.GB ) THEN
      l_result_storage_data := p_storage_data_in_bytes/BYTES_PER_GB;
    elsif ( p_storage_unit = storage_ui_util_pkg.TB ) THEN
      l_result_storage_data := p_storage_data_in_bytes/BYTES_PER_TB;
    END IF;

    RETURN round( l_result_storage_data, 2);
  END convert_into_storage_unit;

  /*-----------------   get_ui_storage_unit ----------
    gets the storage Unit that would be used to render the 
    UI given a list of storage data numbers. It assumes that
    the numbers passed represent storage data in bytes. 

    PARAMETERS
    ----------
      p_number1 - the first storage data number
      p_number2 - the second storage data number

    RETURNS
    -------
      one of the following strings representing the storage unit.

       storage_ui_util_pkg.GB for Giga bytes
       storage_ui_util_pkg.TB for Tera bytes
      
    Implementation notes
    --------------------
   -------------------------------------------------------*/

  FUNCTION get_ui_storage_unit ( p_number1 IN NUMBER,
    p_number2 IN NUMBER)
    RETURN VARCHAR2
  IS
    l_ui_storage_unit varchar2(2);
    l_min_value number;
    l_max_value number;
  BEGIN
    l_max_value := greatest ( p_number1, p_number2 );
    l_min_value := least ( p_number1, p_number2 );
    --dbms_application_info.set_client_info( userenv('client_info')+1 );
    l_ui_storage_unit := storage_ui_util_pkg.GB;

    -- following logic would be refined further
    -- as we learn
    IF( ( l_max_value > 5000000000000 ) OR
        ( l_min_value > 100000000000 ) ) THEN
      l_ui_storage_unit := storage_ui_util_pkg.TB;
    END IF;

    RETURN l_ui_storage_unit;
  END get_ui_storage_unit;

  --------------------------------------------------------
  --  Name: set_storage_context
  --
  --  Package: storage_ui_util_pkg
  --
  --  Purpose:
  --    sets the storage context - used in querying from 
  --    parameterized views that use the context to store
  --    commonly used bind variables.
  -- 
  --  IN Parameters:
  --    p_name - the variable name in the storage_context
  --    p_value - the variable value in the storage_context
  --               
  --  OUT Parameters:
  --    
  -----------------------------------------------------------

  PROCEDURE set_storage_context( p_name IN VARCHAR2, 
    p_value IN VARCHAR2 )
  IS
  BEGIN
    dbms_session.set_context( 'storage_context', p_name, p_value );
  END set_storage_context;

  --------------------------------------------------------
  --  Name: set_storage_context
  --
  --  Package: storage_ui_util_pkg
  --
  --  Purpose:
  --    sets the storage context - used in querying from 
  --    parameterized views that use the context to store
  --    commonly used bind variables.
  -- 
  --  IN Parameters:
  --    p_name - the variable name in the storage_context
  --    p_value - the variable value in the storage_context
  --               
  --  OUT Parameters:
  --    
  -----------------------------------------------------------

  PROCEDURE set_storage_context( p_name in varchar2, 
    p_value IN NUMBER )
  IS
  BEGIN
    dbms_session.set_context( 'storage_context', p_name, p_value );
  END set_storage_context;

  --------------------------------------------------------
  --  Name: set_storage_context
  --
  --  Package: storage_ui_util_pkg
  --
  --  Purpose:
  --    sets the storage context - used in querying from 
  --    parameterized views that use the context to store
  --    commonly used bind variables.
  -- 
  --  IN Parameters:
  --    p_name - the variable name in the storage_context
  --    p_value - the variable value in the storage_context
  --               
  --  OUT Parameters:
  --    
  --  Implementation Notes:
  --    We use the to_char function to store the date as
  --    a character string.
  -----------------------------------------------------------

  PROCEDURE set_storage_context( p_name in varchar2, 
    p_value in date )
  IS
  BEGIN
    dbms_session.set_context( 'storage_context', p_name, 
      to_char( p_value, 'yyyymmddhh24miss') );
  END set_storage_context;

  --------------------------------------------------------
  --  Name: raise_err_if_no_snapshot
  --
  --  Package: storage_ui_util_pkg
  --
  --  Purpose:
  --    raises an error if the host storage snapshot doesnot
  --    exist for the given host name.
  -- 
  --  IN Parameters:
  --    p_target_name - the host or group name
  --    p_target_type - the target type
  --               
  --  OUT Parameters:
  --    
  -----------------------------------------------------------

  PROCEDURE raise_err_if_no_snapshot 
  ( 
    p_target_name in varchar2,
    p_target_type in varchar2 
  )
  IS
    l_count number;
  BEGIN
    -- currently deals with hosts only
    IF( p_target_type != mgmt_global.G_HOST_TARGET_TYPE ) THEN
      RETURN;
    END IF;
    
    select count(*)
    into l_count
    from dual
    where exists
    (
      select snap.ecm_snapshot_id
      from mgmt_storage_report_data data,
           mgmt$ecm_current_snapshots snap
      where data.ecm_snapshot_id = snap.ecm_snapshot_id
        and target_name = p_target_name
        and target_type = mgmt_global.G_HOST_TARGET_TYPE
    );

    IF( l_count != 0 ) THEN
      raise_application_error
      ( 
        mgmt_global.STORAGE_SNAPSHOT_MISSING_ERR,
        mgmt_global.STORAGE_SNAPSHOT_MISSING_ERR_M || p_target_name 
      );
    END IF;
  END raise_err_if_no_snapshot;

END storage_ui_util_pkg;
/
SHOW ERRORS;

