Rem
Rem $Header: storage_ui_util_pkgdef.sql 31-jan-2005.14:52:28 rmenon Exp $
Rem
Rem storage_ui_util_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      storage_ui_util_pkgdef.sql 
Rem
Rem    DESCRIPTION
Rem      utilities used in rendering storage reports UI.
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rmenon      01/31/05 - formatted as per standards; tried to add
Rem                           sql trace methods - but failed as sysman
Rem                           does not have direct "alter session" privilege.
Rem    rmenon      11/03/04 - moved some constants into 
Rem                           storage_ui_common_pkg
Rem    rmenon      09/22/04 - 
Rem    rmenon      08/27/04 - 
Rem    rmenon      08/16/04 - 
Rem    ajdsouza    08/09/04 - 
Rem    rmenon      08/02/04 - rmenon_storage_refresh_error_page_checkin
Rem    rmenon      08/02/04 - created new file in storage component;
Rem                           integration of host detail page
Rem                           with real data; error page.
Rem    rmenon      07/07/04 - 
Rem    rmenon      06/28/04 - rmenon_storage_disks_tab_ui
Rem    rmenon      06/10/04 - Created
Rem

Rem SET ECHO ON
Rem SET FEEDBACK 1
Rem SET NUMWIDTH 10
Rem SET LINESIZE 80
Rem SET TRIMSPOOL ON
Rem SET TAB OFF
Rem SET PAGESIZE 100

CREATE OR REPLACE PACKAGE storage_ui_util_pkg
AS
  /* constants */

  YES CONSTANT VARCHAR2(2) := 'Y';
  NO CONSTANT VARCHAR2(2) := 'N';
  GB CONSTANT VARCHAR2(2) := 'GB';
  TB CONSTANT VARCHAR2(2) := 'TB';
  BYTES_PER_GB CONSTANT NUMBER := 1073741824; 
  BYTES_PER_TB CONSTANT NUMBER := 1099511627776; 

  /*-------------   convert_into_storage_unit ----------
    converts the given number into a given storage unit

    PARAMETERS
    ----------
      p_storage_data_in_bytes - storage data (assumes it represents 
                         storage data is in bytes )
      p_storage_unit - the unit to which the passed storage 
        data should be converted to. If the storage unit is not
        defined to be one of the recognized constants, it returns
        the original number without any conversion.
       
    RETURNS
    -------
      the converted storage data number.
   -------------------------------------------------------*/

  FUNCTION convert_into_storage_unit 
  ( 
    p_storage_data_in_bytes IN NUMBER,
    p_storage_unit IN VARCHAR2 
  )
  RETURN NUMBER;

  /*-----------------   get_ui_storage_unit ----------
    gets the storage Unit that would be used to render the 
    UI given a list of storage data numbers. It assumes that
    the numbers passed represent storage data IN bytes. 

    PARAMETERS
    ----------
      p_number1 - the first storage data number
      p_number2 - the second storage data number

    RETURNS
    -------
      one of the following strings representing the storage unit.

       storage_ui_util_pkg.GB for Giga bytes
       storage_ui_util_pkg.TB for Tera bytes
      
   -------------------------------------------------------*/

  FUNCTION get_ui_storage_unit 
  ( 
    p_number1 IN NUMBER,
    p_number2 IN NUMBER
  )
  RETURN VARCHAR2;

  --------------------------------------------------------
  --  Name: set_storage_context
  --
  --  Package: storage_ui_util_pkg
  --
  --  Purpose:
  --    sets the storage context - used IN querying from 
  --    parameterized views that use the context to store
  --    commonly used bind variables.
  -- 
  --  IN Parameters:
  --    p_name - the variable name in the storage_context
  --    p_value - the variable value in the storage_context
  --               
  --  OUT Parameters:
  --    
  -----------------------------------------------------------

  PROCEDURE set_storage_context
  ( 
    p_name IN VARCHAR2, 
    p_value IN VARCHAR2 
  );

  --------------------------------------------------------
  --  Name: set_storage_context
  --
  --  Package: storage_ui_util_pkg
  --
  --  Purpose:
  --    sets the storage context - used in querying from 
  --    parameterized views that use the context to store
  --    commonly used bind variables.
  -- 
  --  IN Parameters:
  --    p_name - the variable name in the storage_context
  --    p_value - the variable value in the storage_context
  --               
  --  OUT Parameters:
  --    
  -----------------------------------------------------------

  PROCEDURE set_storage_context
  ( 
    p_name IN VARCHAR2, 
    p_value IN NUMBER 
  );

  --------------------------------------------------------
  --  Name: set_storage_context
  --
  --  Package: storage_ui_util_pkg
  --
  --  Purpose:
  --    sets the storage context - used IN querying from 
  --    parameterized views that use the context to store
  --    commonly used bind variables.
  -- 
  --  IN Parameters:
  --    p_name - the variable name in the storage_context
  --    p_value - the variable value in the storage_context
  --               
  --  OUT Parameters:
  --    
  -----------------------------------------------------------
  PROCEDURE set_storage_context
  ( 
    p_name IN VARCHAR2, 
    p_value IN date 
  );

  --------------------------------------------------------
  --  Name: raise_err_if_no_snapshot
  --
  --  Package: storage_ui_util_pkg
  --
  --  Purpose:
  --    raises an error if the host storage snapshot doesnot
  --    exist for the given host name.
  -- 
  --  IN Parameters:
  --    p_target_name - the host or group name
  --    p_target_type - the target type
  --               
  --  OUT Parameters:
  --    
  -----------------------------------------------------------

  PROCEDURE raise_err_if_no_snapshot 
  ( 
    p_target_name IN VARCHAR2,
    p_target_type IN VARCHAR2 
  );

END storage_ui_util_pkg;
/
SHOW ERRORS;

