Rem drv: <create type="indexes" pos="storage/storage_indexes.sql+"/>
Rem
Rem $Header: swlib_indexes.sql 08-nov-2006.03:04:44 kashukla Exp $
Rem
Rem swlib_indexes.sql
Rem
Rem Copyright (c) 2004, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      swlib_indexes.sql - indexes for swlib tables
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    kashukla    11/08/06 - Backport kashukla_bug-5607004 from main
Rem    kashukla    11/06/06 - fixing deadlock bug: 5607004
Rem    wsmit       08/01/05 - purging
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    kashukla    04/01/05 - altering table MGMT_SWLIB_REVISION_PARAMETERS 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    wsmit       01/20/05 - ensure reference order 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    wsmit       09/02/04 - wsmit_more_swlib_impl
Rem    wsmit       08/27/04 - add a couple more 
Rem    wsmit       08/26/04 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

ALTER TABLE MGMT_SWLIB_ENTITY_PLATFORMS
  ADD CONSTRAINT MGMT_SWLIB_PLAT_PK
    PRIMARY KEY(ENTITY_ID, PLATFORM);

ALTER TABLE MGMT_SWLIB_ENTITY_PARAMETERS
  ADD CONSTRAINT MGMT_SWLIB_PAR_PK
    PRIMARY KEY(ENTITY_ID, NAME);

ALTER TABLE MGMT_SWLIB_REVISION_PARAMETERS
  ADD CONSTRAINT MGMT_SWLIB_REV_PAR_PK
    PRIMARY KEY(REVISION_ID, NAME);
    
ALTER TABLE MGMT_SWLIB_ENTITY_DATA
  ADD CONSTRAINT MGMT_SWLIB_DAT_PK
    PRIMARY KEY(REVISION_ID);

CREATE INDEX MGMT_SWLIB_DIR_IDX1 ON 
  MGMT_SWLIB_DIRECTORIES(PARENT_ID)
;

CREATE INDEX MGMT_SWLIB_ENT_IDX1 ON
  MGMT_SWLIB_ENTITIES(DIRECTORY_ID, TYPE, NAME)
;

CREATE INDEX MGMT_SWLIB_REV_IDX1 ON
  MGMT_SWLIB_ENTITY_REVISIONS(ENTITY_ID, REVISION)
;

CREATE INDEX MGMT_SWLIB_REF_IDX1 ON
  MGMT_SWLIB_ENTITY_REFERENCES(TARGET_ID)
;


CREATE INDEX MGMT_SWLIB_REF_IDX2 ON
  MGMT_SWLIB_ENTITY_REFERENCES(TARGET_REVISION_ID)
;

CREATE INDEX MGMT_SWLIB_REF_IDX3 ON
  MGMT_SWLIB_ENTITY_REFERENCES(SOURCE_ID, REFINDEX)
;

CREATE INDEX MGMT_SWLIB_DOC_IDX1 ON
  MGMT_SWLIB_ENTITY_DOCUMENTS(REVISION_ID, REFERENCE_ID, NAME)
;

CREATE INDEX MGMT_SWLIB_DOC_IDX2 ON
  MGMT_SWLIB_ENTITY_DOCUMENTS(REFERENCE_ID)
;

CREATE INDEX MGMT_SWLIB_PAR_IDX1 ON
  MGMT_SWLIB_ENTITY_PARAMETERS(NAME, VALUE)
;

CREATE INDEX MGMT_SWLIB_REV_PAR_IDX1 ON
  MGMT_SWLIB_REVISION_PARAMETERS(NAME, VALUE)
;

CREATE INDEX MGMT_SWLIB_PLAT_IDX1 ON
  MGMT_SWLIB_ENTITY_PLATFORMS(PLATFORM)
;

CREATE INDEX MGMT_SWLIB_DATA_IDX1 ON
  MGMT_SWLIB_ENTITY_DATA(EXTERNAL_KEY)
;
