Rem drv: <create type="pkgdefs" pos="rca/rca_pkgdef.sql+"/>
Rem
Rem $Header: swlib_pkgdef.sql 01-aug-2005.17:58:35 wsmit Exp $
Rem
Rem swlib_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      swlib_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    wsmit       08/01/05 - purging
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    wsmit       06/14/05 - sql inject issues 
Rem    kashukla    01/19/05 - edited update_entity() 
Rem    kashukla    12/08/04 - adding procedure delete_entity 
Rem    wsmit       10/14/04 - add place to store root filepath 
Rem    wsmit       08/26/04 - add directory 
Rem    rmadampa    07/25/04 - 
Rem    rmadampa    07/22/04 - rmadampa_swlib_sql_scripts
Rem    rmadampa    07/19/04 - Created
Rem

CREATE OR REPLACE PACKAGE MGMT_SWLIB AS

PROCEDURE get_current_entity_version(entityId raw);

FUNCTION get_next_version(curr_ver VARCHAR2) RETURN VARCHAR2;

PROCEDURE test_gnv(v VARCHAR2);

PROCEDURE insert_entity(p_entity            IN MGMT_SWLIB_ENTITY_RECORD,
                        p_entity_id_hex     OUT VARCHAR2,
                        p_revision_id_hex   OUT VARCHAR2,
                        p_revision          OUT VARCHAR2,
                        p_result            OUT NUMBER,--success/error code
                        p_err_desc          OUT VARCHAR2);

PROCEDURE update_entity(p_entity            IN MGMT_SWLIB_ENTITY_RECORD,
			p_reference_list    IN MGMT_SWLIB_REFERENCE_LIST,
			p_en_is_dirty	    IN NUMBER,
                        p_revision	    OUT VARCHAR2,
			p_revision_id_hex   OUT VARCHAR2,
                        p_result            OUT NUMBER,--success/error code
                        p_err_desc          OUT VARCHAR2);

PROCEDURE delete_entity(p_entity_id	    IN VARCHAR2,
			p_entity_rev	    IN VARCHAR2,
			p_result	    OUT NUMBER,--success/error code
			p_err_desc	    OUT VARCHAR2);

PROCEDURE insert_revision(p_revision_rec    IN MGMT_SWLIB_REVISION_RECORD,
                          p_entity_id_hex   IN VARCHAR2,
                          p_revision_id_hex OUT VARCHAR2,
                          p_revision        OUT VARCHAR2,
                          p_result          OUT NUMBER,--success/error code
                          p_err_desc        OUT VARCHAR2);

PROCEDURE insert_references(p_references        IN MGMT_SWLIB_REFERENCE_LIST,
                            p_revision_id_hex   IN VARCHAR2,
                            p_result            OUT NUMBER,--success/error code
                            p_err_desc          OUT VARCHAR2);


PROCEDURE insert_directory(p_directory MGMT_SWLIB_DIRECTORY_RECORD,
                           p_directory_id_hex	OUT VARCHAR2,
			   p_result		OUT NUMBER,--success/error code
                           p_err_desc           OUT VARCHAR2);

PROCEDURE update_directory(p_directory MGMT_SWLIB_DIRECTORY_RECORD,
                           p_result		OUT NUMBER,--success/error code
                           p_err_desc           OUT VARCHAR2);

PROCEDURE update_filepaths(p_paths MGMT_SWLIB_PATH_LIST,
                           p_result             OUT NUMBER,--success/error code
                           p_err_desc           OUT VARCHAR2);

PROCEDURE purge(p_files                 OUT MGMT_SWLIB_PATH_LIST,
                p_result		OUT NUMBER,--success/error code
		p_err_desc		OUT VARCHAR2);

END MGMT_SWLIB;
/
show errors;
/
