Rem drv: <create type="pkgdefs" pos="gensvc/gensvc_pkgdefs.sql+"/>
Rem
Rem $Header: system_pkgdef.sql 02-dec-2005.12:37:36 gan Exp $
Rem
Rem system_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      system_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gan         12/02/05 - Backport gan_bug-4669119 from main 
Rem    neearora    08/01/05 - Bug 4525467. modified create_system to accept
Rem                           type_meta_ver
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    neearora    03/01/05 - added owner input parameter in modify_system and 
Rem                           create_system procedure 
Rem    neearora    02/23/05 - Added new procedure upsert_system 
Rem    ramalhot    02/02/05 - changed signature for system_pre_delete_callback 
Rem    gan         10/14/04 - add pre target deletion cb 
Rem    gan         10/13/04 - code refactoring 
Rem    gan         10/06/04 - move some function tto util 
Rem    gan         10/05/04 - gan_system_api_1
Rem    gan         10/01/04 - Created
Rem

CREATE or REPLACE PACKAGE EM_SYSTEM AS
G_MODULE_NAME constant VARCHAR2(100) := 'EM_SYSTEM';

-- PROCEDURE: CREATE_SYSTEM
-- PURPOSE:
--   Creates a system 
-- IN PARAMETERS
--   p_system_name: Name of the system
--   p_system_type: type of the system
--   p_members: NV pair containing member taret names and their types
--   p_owner: Owner of the system
-- OUT PARAMETERS
--   NONE
-- ERROR CODES:
--  TARGET_DOES_NOT_EXIST: If any of the members do not exist
--
--
PROCEDURE CREATE_SYSTEM(p_system_name IN VARCHAR2,
                        p_system_type IN VARCHAR2,
                        p_members IN SMP_EMD_NVPAIR_ARRAY,
                        p_timezone_region IN VARCHAR2,
                        p_owner IN VARCHAR2 DEFAULT NULL,
                        p_type_meta_ver   IN VARCHAR2 DEFAULT '1.0'
);

-- PROCEDURE: MODIFY_SYSTEM
-- PURPOSE:
--   Modifies the members of a system
-- IN PARAMETERS
--   p_system_name: Name of the system
--   p_system_type: type of the system
--   p_new_members: NV pair containing the new set of member taret names and their types
--                  to be added to the system
--   p_owner: New owner of the system
-- OUT PARAMETERS
--   NONE
-- ERROR CODES:
--  TARGET_DOES_NOT_EXIST: If any of the targets do not exist
PROCEDURE MODIFY_SYSTEM(p_system_name IN VARCHAR2, 
                        p_system_type IN VARCHAR2,
                        p_new_members IN SMP_EMD_NVPAIR_ARRAY,
                        p_owner IN VARCHAR2 DEFAULT NULL);
                        
-- PROCEDURE: MODIFY_SYSTEM
-- PURPOSE:
--   Modifies the members of a system
-- IN PARAMETERS
--   p_system_name: Name of the system
--   p_system_type: type of the system
--   p_members_add: NV pair containing the member taret names and their types
--                  to be added to the system
--   p_members_del: NV pair containing the member taret names and their types
--                  to be deleted from the system. Any associations based on 
--                   these targets are also deleted.
--   p_owner: New owner of the system
-- OUT PARAMETERS
--   NONE
-- ERROR CODES:
--  TARGET_DOES_NOT_EXIST: If any of the targets do not exist
PROCEDURE MODIFY_SYSTEM(p_system_name IN VARCHAR2, p_system_type IN VARCHAR2,
                        p_members_add IN SMP_EMD_NVPAIR_ARRAY,
                        p_members_del IN SMP_EMD_NVPAIR_ARRAY,
                        p_owner IN VARCHAR2 DEFAULT NULL);
 

--
-- PROCEDURE: DELETE_SYSTEM
-- PURPOSE:
--   Deletes a system
-- IN PARAMETERS
--   p_system_name: Name of the system
--   p_system_type: type of the system
-- OUT PARAMETERS
--   NONE
-- ERROR CODES:
--  INSUFFICIENT_PRIV_ERR: If user does not have enough privileges
--
PROCEDURE DELETE_SYSTEM(p_system_name IN VARCHAR2, p_system_type IN VARCHAR2);


--
-- PROCEDURE: IS_SYSTEM
-- PURPOSE:
--   check if a type implements system interface
-- IN PARAMETERS
--   p_target_type: type of the system
-- OUT PARAMETERS
--   NONE
-- ERROR CODES:
-- RETURN: 1 for is, 0 for is-not
--
FUNCTION is_system(p_target_type IN VARCHAR2) RETURN NUMBER;

--
-- PROCEDURE: get_impacted_services
-- PURPOSE:
--   get all services impacted by a system change, such as target remove 
--   from system, system deletion. The impacted services run on the system and
--   its ancestors
-- IN PARAMETERS
--   p_system_guid: the system
--   p_targets: targets to remove from the system. 
--    If it is NULL, treate as all targets associations are removed.
--    Only guid field in mgmt_guid_array is used
-- OUT PARAMETERS
--   NONE
-- RETURN: array of service guid, only guid field in mgmt_guid_array 
--         is populated
--
FUNCTION get_impacted_services(p_system_guid IN RAW,
                               p_targets IN MGMT_GUID_ARRAY)
RETURN MGMT_GUID_ARRAY;

--
-- PROCEDURE: member_deletion_callback
-- PURPOSE:
--   callback when member assoc is deleted
--
PROCEDURE member_deletion_callback(p_assoc_def_name IN VARCHAR2,
                              p_source_target_name IN VARCHAR2,
                              p_source_target_type IN VARCHAR2,
                              p_assoc_target_name IN VARCHAR2,
                              p_assoc_target_type IN VARCHAR2,
                              p_scope_target_name IN VARCHAR2,
                              p_scope_target_type IN VARCHAR2);

--
-- PROCEDURE: runs_on_deletion_callback
-- PURPOSE:
--   callback when runs on assoc is deleted
--
PROCEDURE runs_on_deletion_callback(p_assoc_def_name IN VARCHAR2,
                              p_source_target_name IN VARCHAR2,
                              p_source_target_type IN VARCHAR2,
                              p_assoc_target_name IN VARCHAR2,
                              p_assoc_target_type IN VARCHAR2,
                              p_scope_target_name IN VARCHAR2,
                              p_scope_target_type IN VARCHAR2);

--
-- PROCEDURE: system_pre_del_callback
-- PURPOSE
--   callback when system is about to be deleted. Will cleanup the 
--   dependens assocs and metric dependency for all services running on it
PROCEDURE system_pre_del_callback(p_target_name IN VARCHAR2,
                                  p_target_type IN VARCHAR2,
                                  p_target_guid IN RAW);


--
-- PROCEDURE: upsert_system
-- PURPOSE
--   this procedure will be used by emctl to create/update the system. If the system with the
--   given name and type is not present then it will create a new system otherwise it will update 
--   the existing system, the p_members will be merged with existing members.
PROCEDURE upsert_system(p_upsert IN NUMBER,
                        p_system_name IN VARCHAR2,
                        p_system_type IN VARCHAR2,
                        p_members IN SMP_EMD_NVPAIR_ARRAY,
                        p_timezone_region IN VARCHAR2);


END;
/
show error;
