set define off
Rem
Rem $Header: em_system_dashboard_pkgbody.sql 03-jun-2008.12:16:39 jashukla Exp $
Rem
Rem em_system_dashboard_pkgbody.sql
Rem
Rem Copyright (c) 2004, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      em_system_dashboard_pkgbody.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jashukla    06/03/08 - Bug 7144619 remove internal identifiers
Rem    paachary    09/03/07 - Fixing per issue for getting violation counts
Rem    paachary    07/31/07 - Fixing bug 6270153
Rem    paachary    09/03/07 - XbranchMerge paachary_bug-6270153_1 from main
Rem    vmotamar    06/11/07 - Bug No : 6120884
Rem    ramehta     11/23/06 - adding entry for jboss_partition
Rem    bram        04/06/06 - Bug-5137855
Rem    bram        07/12/06 - Backport bram_bug-5137855 from main 
Rem    vmotamar    07/10/06 - Backport vmotamar_bug-5046489 from main 
Rem    vmotamar    02/22/06 - Fixing Bug 5019031 (Performance bug)
Rem    vkarpura    11/30/05 - Add 10.1.3 Cluster Support 
Rem    vmotamar    09/06/05 - Fix drilldown issue - now drilldown for unknow target status also contains
Rem                           Agent Down and Target Unreachable statuses
Rem    vmotamar    07/28/05 - Bug Nos :4517410,4504124,4517435
Rem    vkgarg      07/21/05 - get severity_guid in get_alert_info 
Rem    paachary    07/19/05 - Modifying the signatures of 
Rem                           get_alert_info and get_dashboard_preferences APIs.
Rem    paachary    07/14/05 - Handling Composites with unknown Status
Rem    pratagar    07/12/05 - Handling null conditions
Rem    paachary    06/22/05 - Bug 4406329 (PERF: PAGE TIMING VIOLATION: /TARGET/SYSTEM/SYSTEMDASHBOARD)
Rem    vmotamar    06/22/05 - Rectify websphere_cell spelling
Rem    vmotamar    05/15/05 - System dashboard will now support target types oracle_ias, weblogic_domain, webpshere_cell, 
Rem                           oracle_ias_farm, oracle_ias_cluster, apart from target types contained within the "is_group" and
Rem                           "is_system" properties.
Rem                            Also made changes to display the "ALERTS" only for "UP" and "DOWN" targets.
Rem                            For other target status, we display "UNKNOWN" status.
Rem    nanand      05/13/05 - moving GET_SYSTEM_DETAILS from 
Rem                           em_dashboard_service 
Rem    vmotamar    05/03/05 - Performance improvement
Rem    vmotamar    04/19/05 - Bug-4309057
Rem    paachary    03/27/05 - Added check for composite targets not containing any members
Rem    paachary    01/31/05 - Modified the query displaying alerts / severity for tgts and groups
Rem    paachary    01/28/05 - Modified for displaying the availability status and severity state 
Rem                           of targets for full view and rollup view
Rem    vmotamar    01/25/05 - Dashboard to handle All Columns(Policy Violations, Compliance Score,etc)
Rem    paachary    01/11/05 - Changed the sql query to include the column with column types 0,1 and 2 
Rem                           Changed the em_metric_obj to include target_property_value 
Rem                           for columns with types 1 and 2
Rem    paachary    12/31/04 - Changed the signatures of 
Rem                           get_alert_info, get_target_info_full and get_target_info_rollup
Rem                           to include p_aggregate_target_type as an input parameter
Rem    vmotamar    12/28/04 - New procedure: get_dashboard_preferences, adding target type
Rem                           for metric name (tool tip for metric columns) 
Rem    vmotamar    12/23/04 - Change to accomodate metric_abbreviation of em_metric_obj to 
Rem                           handle upto 256 chars 

Rem    paachary    12/21/04 - Change to handle Redundancy group
Rem    vmotamar    12/14/04 - Change to handle Null pointer exception for metric abbreviation
Rem    vmotamar    11/29/04 - Changes to include "System" target type
Rem    vmotamar    10/21/04 - 
Rem    vmotamar    10/13/04 - vmotamar_sys_dash
Rem    vmotamar    10/13/04 - Created
Rem

CREATE OR REPLACE PACKAGE BODY em_system_dashboard
AS
    TYPE number_table IS TABLE OF NUMBER;
    p_member_guid_array      SMP_EMD_TARGET_REC_ARRAY;
    sum_cnt_array            NUMBER_TABLE;
    tgt_array                MGMT_TARGET_GUID_ARRAY;
    p_critical_cnt_array     NUMBER_TABLE;
    p_warning_cnt_array      NUMBER_TABLE;
    metricguids_array        MGMT_TARGET_GUID_ARRAY;
    source_tgt_array         MGMT_TARGET_GUID_ARRAY;
    avail_cnt_array          NUMBER_TABLE;
    metric_guidarray         MGMT_TARGET_GUID_ARRAY;
    guidarray                MGMT_TARGET_GUID_ARRAY;
    count_array              NUMBER_TABLE;
    p_target_type_arr        VARCHAR2_TABLE;
    tgtid_array              MGMT_TARGET_GUID_ARRAY;
    colltn_cnt_array         NUMBER_TABLE;
    metric_idarray           MGMT_TARGET_GUID_ARRAY;
    trgetguidarray           MGMT_TARGET_GUID_ARRAY;
    l_tgtid_array_count      PLS_INTEGER DEFAULT 0;
    l_trgetguidarray_count   PLS_INTEGER DEFAULT 0;
    l_source_tgt_array_count PLS_INTEGER DEFAULT 0;
    l_guidarray_count        PLS_INTEGER DEFAULT 0;
    l_sum_cnt_array_count    PLS_INTEGER DEFAULT 0;

-- Private routine : get_composite_target_types
-- Purpose : This method is used to fetch all the target types with properties is_system and is_group and
--           their values set to 1.
--           This method is an important one to determine whether to display a dashboard for teh above target types or not.
--           The target types fetched from this method is used throughout the package
-- NOTE    : Incase there is a need to add more target types or to support target types belonging to certain properties,
--           include those target types or properties only in this function. This procedure  will drive in acheiving the
--           functionalities to display dashboard for all those target types.
-- Input Parameters :
-- Return Value: The above target types.

FUNCTION get_composite_target_types
RETURN SMP_EMD_NVPAIR_ARRAY
IS
   p_tgtypelist SMP_EMD_NVPAIR_ARRAY := SMP_EMD_NVPAIR_ARRAY();
BEGIN

    SELECT SMP_EMD_NVPAIR(target_type,null)
    BULK COLLECT INTO p_tgtypelist
    FROM mgmt_type_properties
    WHERE
        ((property_name = MGMT_GLOBAL.G_IS_GROUP_PROP AND property_value='1') OR
        (property_name  = MGMT_GLOBAL.G_IS_SYSTEM_PROP AND property_value='1'))
   ORDER BY target_type;

   RETURN p_tgtypelist;
END get_composite_target_types;

-- Private routine : is_target_type_aggregate
-- Purpose : We support Dashboard for all target types which are obtained from the procedure get_composite_target_types.
--           Please refer get_composite_target_types for more details.
-- Input Parameters : target type -- mandatory
--                    p_target_type_list -- mandatory
--                    This list contains all the target types obtained from the procedure get_composite_target_types.
--                    Apart from these target types, the routine also fetches the following target types
--                    oracle_ias, weblogic_domain, websphere_cell, oracle_ias_farm, oracle_ias_cluster and oc4j.
-- Return Value:
--               TRUE in case the type of target is of an aggregate type
--               FALSE in case the target is standalone

FUNCTION is_target_type_aggregate
(
    p_target_type      IN VARCHAR2,
    p_target_type_list IN SMP_EMD_NVPAIR_ARRAY,
    p_target_guid      IN VARCHAR2 DEFAULT NULL
)
RETURN VARCHAR2
IS
    l_count        NUMBER DEFAULT 0;
    l_flat_tgt_cnt NUMBER DEFAULT 0;
BEGIN
    IF (p_target_type in
	        (MGMT_GLOBAL.G_IAS_TARGET_TYPE,
        	'weblogic_domain',      -- need to replace this with the GLOBAL CONSTANT once it is available.
	        MGMT_GLOBAL.G_OC4J_TARGET_TYPE,
	        'websphere_cell',       -- need to replace this with the GLOBAL CONSTANT Once it is available.
        	'oracle_ias_farm',      -- need to replace this with the GLOBAL CONSTANT once it is available.
        	'oracle_ias_cluster',      -- need to replace this with the GLOBAL CONSTANT once it is available.
	        'oracle_ias_jmx_cluster', -- need to REPLACE this with the GLOBAL CONSTANT once it is available.
                'jboss_partition'))  -- need to REPLACE this with the GLOBAL CONSTANT once it is available.
    THEN
        IF (p_target_guid IS NOT NULL) THEN
           SELECT count(*)
           INTO   l_flat_tgt_cnt
           FROM   mgmt_flat_target_assoc
           WHERE  source_target_guid = p_target_guid AND
	          is_membership = 1;
           IF (l_flat_tgt_cnt > 0 ) THEN
             RETURN 'TRUE';
           ELSE
             RETURN 'FALSE';
           END IF;
       ELSE
           RETURN 'TRUE';
       END IF;
    ELSE
        IF (p_target_type_list is NOT NULL and p_target_type_list.COUNT != 0) THEN
            FOR itgtlistcnt in 1..p_target_type_list.COUNT
	    LOOP
                IF (p_target_type = p_target_type_list(itgtlistcnt).name) THEN
	            l_count := 1;
	            EXIT;
        	END IF;
           END LOOP;
       	   IF (l_count > 0)
	   THEN
               RETURN 'TRUE'; -- The target type is not standalone
	   ELSE
               RETURN 'FALSE';
	   END IF;
       ELSE
           RETURN 'FALSE';
       END IF;
    END IF;
END is_target_type_aggregate;

-- Private routine : get_target_properties
-- Purpose : To get the column value of those non-metric columns which are defined as generic /general
--           The values are stored in the mgmt_target_properties table
-- Input Parameters : target_guid: associated target_guid of the aggregate target being passed to the system dashboard
--                    property_name : the column name of the target being displayed on the system dashboard
--
-- Return Value: Value for the column (for the associated target being passed)
-- If the value is not found, then the return value will be "-".

FUNCTION get_target_properties
(
    p_target_guid IN mgmt_targets.target_guid%TYPE,
    p_property_name IN VARCHAR2
)
RETURN VARCHAR2
IS
    p_prop_value mgmt_target_properties.property_value%TYPE;
BEGIN
    FOR C1 IN
    (
        SELECT  property_value
        FROM    mgmt_target_properties
        WHERE   target_guid = p_target_guid AND
                property_name = p_property_name
    )
    LOOP
        p_prop_value := c1.property_value;
    END LOOP;
    IF (p_prop_value is NULL) THEN
        RETURN '-';
    ELSE
       RETURN p_prop_value;
   END IF;
END get_target_properties;

-- Private Routine : get_rollup_metric_status
-- Purpose : Get Rollup Metric Status for Group /System
-- Called in Full View, when the Group for which Dashboard is displayed contains a Sub Group / system
-- Input Parameters
-- p_group_guid : GUID of the Sub Group / system
-- p_metric_guid : Metric Guid for which the Rolluo Status is to be caluclated
-- p_metric_target_type :Target Type to which the current metric is applicable (to save a round trip to database)
-- Return Value
-- Worst Status of the Metric, applicable to member argets who belong to the Target Type, for which the Metric is applicable
-- Possible Values : Not Applicable, Unknown, Critical, Warning, Metric Collection Error, Threshold Not Set
FUNCTION get_rollup_metric_status
(
    p_group_guid          IN RAW,
    p_metric_guid         IN RAW,
    p_metric_target_type  IN VARCHAR2
)
RETURN VARCHAR2
IS
   l_count           NUMBER;
   l_warning_count   NUMBER;
   l_critical_count  NUMBER;

   l_flat_count    NUMBER;
   l_count_metric_threshold    NUMBER;
BEGIN

    -- Check whether the Group / System target contains any Targets of Target Type, to which the Metric is applicable
    -- In case Not, this Metric is not applicable to this GROUP
    l_count := 0;
    IF (tgtid_array IS NOT NULL AND l_tgtid_array_count > 0) THEN
        FOR i in 1..l_tgtid_array_count
        LOOP
            IF (tgtid_array(i) = p_group_guid) THEN
                IF (p_metric_target_type = p_target_type_arr(i)) THEN
                    l_count := 1;
                    EXIT;
                ELSE
                    l_count := 0;
                END IF;
            END IF;
        END LOOP;
        IF ( l_count = 0 ) THEN
            RETURN('Not Applicable');
        END IF;
    END IF;

    -- Check for Metric Collection Error for members of the group. In case of any errors, then return "Metric Collection Error".
    IF (trgetguidarray IS NOT NULL AND l_trgetguidarray_count > 0) THEN
        FOR i in 1..l_trgetguidarray_count
        LOOP
         IF  ( (p_group_guid = trgetguidarray(i) OR trgetguidarray(i) IS NULL) AND p_metric_guid = metric_idarray(i)) THEN
                IF (colltn_cnt_array(i) > 0 ) THEN
                 RETURN('Metric Collection Error');
             END IF;
            END IF;
        END LOOP;
    END IF;

    --Check whether we have atleast one target, with matching Target Type in Status UP
    -- In case Not, Metric Status is Unknown
    IF (tgt_array IS NOT NULL AND l_sum_cnt_array_count > 0) THEN
        FOR i IN 1..l_sum_cnt_array_count
        LOOP
            IF (p_group_guid = tgt_array(i)) THEN
                IF (sum_cnt_array(i) < 1) THEN
                    RETURN ('Unknown');
                END IF;
            END IF;
        END LOOP;
    END IF;

    -- Check if the Group / Aggregate target Contains any Target, which has the input Metric State IN Critical/Warning State
    -- If Yes, Return Critical/Warning as applicable
    IF (metricguids_array IS NOT NULL AND l_source_tgt_array_count > 0) THEN
        FOR i IN 1..l_source_tgt_array_count
        LOOP
             IF (p_metric_guid = metricguids_array(i) AND p_group_guid = source_tgt_array(i) ) THEN
                IF (p_critical_cnt_array(i) > 0 ) THEN
                    RETURN('Critical');
                ELSIF (p_warning_cnt_array(i) > 0) THEN
                    RETURN('Warning');
                END IF;
             END if;
         END LOOP;
    END IF;

    -- Check if the Group / aggregate target Contains any Target, for which Metric Threshold is Not Set
    -- If Yes, Return 'Metric Threshold Not Set'
    l_count := 0;
    IF (guidarray IS NOT NULL AND l_guidarray_count > 0) THEN
        FOR i IN 1..l_guidarray_count
        LOOP
        IF ((p_group_guid = guidarray(i) OR guidarray(i) IS NULL ) AND p_metric_guid  = metric_guidarray(i)) THEN
              IF ( (1-avail_cnt_array(i)) > 0 ) THEN
                  RETURN('Metric Threshold Not Set');
              END IF;
          END if;
        END LOOP;
    END IF;

    --Everything is Fine
    -- Return Clear
    RETURN('Clear');
END get_rollup_metric_status;

-- Private Routine
-- Purpose : Get Metric Status for a Stand Alone Target and Metric Combination
-- Input Parameters
-- p_target_guid : GUID of the Target
-- p_metric_guid : Metric Guid whose Status is to be returned
-- Return Value
-- Possible Values : Not Applicable, Unknown, Critical, Warning, Metric Collection Error, Threshold Not Set
FUNCTION get_metric_status
(
    p_target_guid IN RAW,
    p_metric_guid IN RAW
)
RETURN VARCHAR2
IS
    l_found boolean default FALSE;
    l_count NUMBER;

    l_metric_status VARCHAR2(64);

BEGIN
    --First Check Whether Metric Threshold is Set of Not
    SELECT count(*)
    INTO l_count
    FROM mgmt_policy_assoc_cfg
    WHERE object_guid=p_target_guid
    AND  policy_guid=p_metric_guid;

    IF (l_count=0) THEN
        l_metric_status:='Metric Threshold Not Set';
        RETURN l_metric_status;
    END IF;

    -- Check for Metric Collection Errors
    SELECT count(*)
    INTO l_count
    FROM mgmt_current_metric_errors
    WHERE target_guid=p_target_guid
    AND metric_guid=p_metric_guid;

    IF (l_count>0) THEN
        l_metric_status:='Metric Collection Error';
        RETURN l_metric_status;
    END IF;

    -- Check table "mgmt_metric_severity
    -- If Severity Code for Target_GUID and Metric_GUID Code combination
    -- is 20 : return 'Warning'
    -- is 25 : return Critical
    -- any other value or no data found return 'Clear'
    FOR c1 IN
    (
        SELECT  severity_code
        FROM    mgmt_current_severity
        WHERE   target_guid=p_target_guid AND
                metric_guid=p_metric_guid
    )
    LOOP
        IF (c1.severity_code=mgmt_global.G_SEVERITY_WARNING) THEN
            l_metric_status:='Warning';
        ELSIF (c1.severity_code=mgmt_global.G_SEVERITY_CRITICAL) THEN
            l_metric_status:='Critical';
        END IF;
        RETURN l_metric_status;
    END LOOP; --c1

    -- C1 returned zero rows
    -- Return Clear
    RETURN('Clear');
END get_metric_status;

-- Purpose : To determine the refresh frequency and view preference of System Dashboard
-- Input Parameters
-- p_target_name : Name of Group / System, for which the Dashboard is painted
-- p_target_type : Target Type to which the Dashboard is limited to
-- Output Parameters
-- p_view_type : Full or Rollup view preferred by user (Default : Full view)
-- p_refresh_frequency : refresh frequency as specified by user (Default : 3 mins)
-- p_alerts_table_required : A flag whether to display the Alerts Table or not in the dashboard
PROCEDURE get_dashboard_preferences
(
    p_target_name       IN  VARCHAR2,
    p_target_type       IN  VARCHAR2,
    p_view_type         OUT VARCHAR2,
    p_refresh_frequency     OUT VARCHAR2,
    p_alerts_table_required OUT VARCHAR2
)
IS
    l_target_guid mgmt_targets.target_guid%type DEFAULT NULL;
BEGIN
    -- Initialize with default values
    p_view_type:='Full';
    p_refresh_frequency:='3';

    BEGIN
        l_target_guid := mgmt_target.get_target_guid
                         (
                             target_type_in=>p_target_type,
                             target_name_in=>p_target_name
                         );
    EXCEPTION
        WHEN OTHERS THEN
            RETURN;
    END;
   p_view_type := get_target_properties
                  (
                      p_target_guid => l_target_guid,
                      p_property_name => 'Dashboard_View_Type'
                  );
   IF (p_view_type = '-' ) THEN
       p_view_type := 'Full'; -- Default Value if not set.
   END IF;
   p_refresh_frequency := get_target_properties
                         (
                             p_target_guid => l_target_guid,
                             p_property_name => 'Dashboard_Refresh_Time'
                         );
   IF (p_refresh_frequency = '-' ) THEN
       p_refresh_frequency := '3'; -- Default Value if not set.
   END IF;
    p_alerts_table_required := get_target_properties
                               (
                                   p_target_guid => l_target_guid,
                                   p_property_name => 'Dashboard_Alert_Table'
                               );
    IF (p_alerts_table_required = '-') THEN
        p_alerts_table_required := 'On'; -- Default value if not set
    END IF;

END get_dashboard_preferences;

-- Purpose : Get Description for Seveity Codes, the table "mgmt_current_severity" returns
-- Input Parameters
-- p_severity_guid : Self Explanatory
-- Return Value
-- Description of the Severity GUID as defined in constants in "mgmt_global"
FUNCTION get_severity_description
(
    p_severity_code IN NUMBER
)
RETURN VARCHAR2
IS
    l_severity_description VARCHAR2(255);
    l_severity_code VARCHAR2(5) := to_char(ltrim(rtrim(p_severity_code)));
BEGIN
    CASE l_severity_code
        WHEN NULL THEN l_severity_description := NULL;
        WHEN MGMT_GLOBAL.G_SEVERITY_COMMENT THEN l_severity_description := 'Comment';
        WHEN MGMT_GLOBAL.G_SEVERITY_CLEAR THEN l_severity_description := 'Clear';
        WHEN MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL  THEN l_severity_description := 'Information';
        WHEN MGMT_GLOBAL.G_SEVERITY_WARNING THEN l_severity_description := 'Warning';
        WHEN MGMT_GLOBAL.G_SEVERITY_CRITICAL THEN l_severity_description := 'Critical';
        WHEN MGMT_GLOBAL.G_SEVERITY_UNREACHABLE_CLEAR THEN l_severity_description := 'Agent Unreachable Clear';
        WHEN MGMT_GLOBAL.G_SEVERITY_UNREACHABLE_START THEN l_severity_description := 'Agent Unreachable';
        WHEN MGMT_GLOBAL.G_SEVERITY_BLACKOUT_START THEN l_severity_description := 'Blackout Start';
        WHEN MGMT_GLOBAL.G_SEVERITY_BLACKOUT_END THEN l_severity_description := 'Blackout End';
        WHEN MGMT_GLOBAL.G_SEVERITY_ERROR_END THEN l_severity_description := 'Metric Evaluation Error Start';
        WHEN MGMT_GLOBAL.G_SEVERITY_ERROR_START THEN l_severity_description := 'Metric Evaluation Error End';
        WHEN MGMT_GLOBAL.G_SEVERITY_NO_BEACONS THEN l_severity_description := 'No Beacons';
        WHEN MGMT_GLOBAL.G_SEVERITY_UNKNOWN THEN l_severity_description:= 'Status Unknown';
        ELSE l_severity_description := 'INVALID SEVERITY CODE';
    END CASE;
    RETURN l_severity_description;
END get_severity_description;

-- Purpose : Get Name of the input Metric_GUID, Need this information to build links in System Dashboard
-- Input Parameters
-- p_metric_guid : Self Explanatory
-- Return Value
-- Metric Name for the Metric GUID, from table MGMT_METRICS
-- Deprecating this function for performance reasons
FUNCTION get_metric_name
(
    p_metric_guid IN RAW
)
RETURN VARCHAR2
IS
    l_metric_name mgmt_metrics.metric_name%type;
BEGIN
    l_metric_name:=null;
    FOR c1 IN
    (
        SELECT metric_name
        FROM mgmt_metrics
        WHERE metric_guid=p_metric_guid
        AND rownum<2
    )
    LOOP
        l_metric_name:=c1.metric_name;
    END LOOP;

    IF (l_metric_name IS null) THEN
        RETURN('Invalid Metric GUID'); -- Column Metric_Name is NOT NULL
    ELSE
        RETURN l_metric_name;
    END IF;
END get_metric_name;

-- Purpose : Get Metric Column for the input Metric_GUID, Need this information to build links in System Dashboard
-- Input Parameters
-- p_metric_guid : Self Explanatory
-- Return Value
-- Metric Name for the Metric Column, from table MGMT_METRICS
-- Deprecating this function for performance reasons
FUNCTION get_metric_column
(
    p_metric_guid IN RAW
)
RETURN VARCHAR2
IS
    l_metric_column mgmt_metrics.metric_column%type;
BEGIN
    l_metric_column:=null;
    FOR c1 IN
    (
        SELECT metric_column
        FROM mgmt_metrics
        WHERE metric_guid=p_metric_guid
        AND rownum<2
    )
    LOOP
        l_metric_column:=c1.metric_column;
    END LOOP;

    IF (l_metric_column IS null) THEN
        RETURN('Invalid Metric GUID'); -- Column Metric_Name is NOT NULL
    ELSE
        RETURN l_metric_column;
    END IF;
END get_metric_column;

-- Purpose : Get Description for Seveity Codes, the table "mgmt_current_availability" returns
-- Input Parameters
-- p_current_status : Self Explanatory
-- Return Value
-- Description of the Status ID as defined in constants in "mgmt_global"
FUNCTION get_availability_status_desc
(
    p_current_status IN NUMBER
)
RETURN VARCHAR2
IS
    l_availability_description VARCHAR2(255);
    l_current_status VARCHAR2(5) := to_char(ltrim(rtrim(p_current_status)));
BEGIN

    CASE l_current_status
        WHEN NULL THEN l_availability_description := NULL;
        WHEN MGMT_GLOBAL.G_STATUS_DOWN THEN l_availability_description := 'Target Down';
        WHEN MGMT_GLOBAL.G_STATUS_UP THEN l_availability_description := 'Target Up';
        WHEN MGMT_GLOBAL.G_STATUS_ERROR THEN l_availability_description := 'Status Error';
        WHEN MGMT_GLOBAL.G_STATUS_AGENT_DOWN THEN l_availability_description := 'Agent Down';
        WHEN MGMT_GLOBAL.G_STATUS_UNREACHABLE THEN l_availability_description := 'Target Unreachable';
        WHEN MGMT_GLOBAL.G_STATUS_BLACKOUT THEN l_availability_description := 'Target Under Blackout';
        WHEN MGMT_GLOBAL.G_STATUS_UNKNOWN THEN l_availability_description := 'Target Status Unknown';
        ELSE l_availability_description := 'INVALID AVAILABILITY STATUS CODE';
    END CASE;
    RETURN l_availability_description;
END get_availability_status_desc;

-- Purpose : To Drive the Alerts Section of the System Dashboard
-- Three possibilities :
-- 1.All (p_target_type and p_target_status are NULL)
-- 2.That Belong to a Specific Target Type (All hosts or databases) (p_target_status is null) and
-- 3. That Belong to a Specific Target Type and of a Specific Status (All hosts that are down)
-- Alerts will be displayed for those targets which have "UP" and "DOWN" status.
-- Input Parameters
-- p_aggregate_target_type : Name of the aggregate target type, which is having the value in the property_name as "is_system" and "is_group"
-- p_aggregate_name : Name of the target belonging to an aggregate target type, for which the Dashboard is Painted
-- p_alerts_table_required : A flag to show whether the Alerts Table is to be displayed or not.
--                           In case its On, then return the cursor with filled up values,  
--                           else return the cursor with one record having all values as NULL
-- p_target_status : Status of the Targets which need to be included in Dashboard (optional)
-- p_target_type : Target Type to which the Dashboard is limited to
-- Out Parameters
-- p_alerts : encompasses all information we need to display in the "Alerts" Section of Dashboard
-- p_critical_cnt : Stores the total critial counts for the aggregate
-- p_warning_cnt : Stores the total warning counts for the aggregate
-- p_down_cnt : Stores the total down counts for the aggregate
PROCEDURE get_alert_info
(
    p_aggregate_name           IN  VARCHAR2,
    p_aggregate_target_type    IN  VARCHAR2,
    p_alerts_table_required    IN  VARCHAR2 DEFAULT 'On',
    p_target_type              IN  VARCHAR2 DEFAULT NULL,
    p_target_status            IN  VARCHAR2 DEFAULT NULL,
    p_alerts                   OUT CURSOR_TYPE,
    p_critical_cnt             OUT NUMBER,
    p_warning_cnt              OUT NUMBER,
    p_down_cnt                 OUT NUMBER
)
IS
    TYPE cur_alerts_count IS REF CURSOR;
    l_aggregate_guid       mgmt_targets.target_guid%TYPE DEFAULT NULL;
    is_target_aggregate    VARCHAR2(10) DEFAULT NULL;
    p_tgtypelist           SMP_EMD_NVPAIR_ARRAY := SMP_EMD_NVPAIR_ARRAY();
    c_alert_count          cur_alerts_count;
    p_cnt                  NUMBER DEFAULT 0;
    p_current_status       mgmt_current_availability.current_status%TYPE;
    p_severity_code        mgmt_current_severity.severity_code%TYPE;
    p_severity_type        mgmt_current_severity.severity_type%TYPE;
    p_default_username     VARCHAR2(20) := '&lt;SYSTEM&gt;';

BEGIN
    p_tgtypelist := get_composite_target_types;
    -- Table "mgmt_flat_target_assoc" stores only GUIDs of both Parents and Children
    -- Get GUID of aggregate
    -- Validate the p_aggregate_target_type with the list of aggregate target types available in the system
    -- The system currently supports all the target types available from the procedure get_composite_target_types.
    is_target_aggregate := is_target_type_aggregate(p_aggregate_target_type,p_tgtypelist);
    IF (is_target_aggregate ='TRUE') THEN
        FOR c1 IN
        (
            SELECT
                target_guid aggregate_guid
            FROM
                mgmt_targets
            WHERE
                target_name=p_aggregate_name AND
                target_type=p_aggregate_target_type
        )
        LOOP
            l_aggregate_guid:=c1.aggregate_guid;
        END LOOP;
    ELSE
        RETURN;
    END IF;
    IF (l_aggregate_guid IS NULL) THEN  -- Aggregate target Does Not Exist
       return;
    END IF;
    
    -- Display the cursor only if the Dashboard_Alert_Table property has been set.
    IF (p_alerts_table_required = 'On') THEN
        -- Have restricted the number of records to return the latest 2000 records (based on the alert timestamp).
        -- Writing separate cursor for all the applicable value conditions of p_target_type and p_target_status
        -- for enhancing the performance.
         IF (p_target_type IS NULL AND p_target_status IS NULL) THEN
         -- This will be invoked for the "Full View" from the members atb page.
             OPEN p_alerts FOR
             SELECT
                 target_guid,
                 target_name,
                 target_type,
                 target_status,
                 metric_name,
                 metric_column,
                 key_value,
                 alrt_timestmp,
                 alert_message,
                 message_nlsid,
                 message_params,
                 severity_description,
                 severity_type,
                 alert_comment,
                 severity_guid
             FROM
             (
             SELECT
                 mgmt_current_availability.target_guid,
                 mgmt_targets.target_name,
                 mgmt_targets.target_type,
                 mgmt_current_availability.current_status target_status,  -- 0 denotes target down
                 mgmt_metrics_info.metric_name metric_name,
                 mgmt_metrics_info.metric_column metric_column,
                 mgmt_current_severity.key_value,
                 mgmt_current_severity.collection_timestamp alrt_timestmp,
                 mgmt_current_severity.message alert_message,
                 mgmt_current_severity.message_nlsid message_nlsid,
                 mgmt_current_severity.message_params message_params,
                 NVL(em_system_dashboard.get_severity_description(mgmt_current_severity.severity_code), 'Severity Code is Null' )severity_description,
                 mgmt_current_severity.severity_type severity_type,
                 (
                    SELECT nvl(a1.user_name,p_default_username)||' : '||a1.message
                    FROM  mgmt_severity_annotation a1
                    WHERE severity_guid = mgmt_current_severity.severity_guid
                    AND rownum < 2 and
                    collection_timestamp =
                    (
                      SELECT max(collection_timestamp)
                      FROM mgmt_severity_annotation 
                      WHERE severity_guid = mgmt_current_severity.severity_guid
                    )
                 ) alert_comment,
                 mgmt_current_severity.severity_guid severity_guid
             FROM
                 mgmt_current_severity, mgmt_targets, mgmt_current_availability,
                 (
             SELECT
                 DISTINCT metric_guid,
                 metric_name,
                 metric_column
             FROM
                 mgmt_metrics
                 ) mgmt_metrics_info
             WHERE
                 mgmt_current_availability.current_status IN (MGMT_GLOBAL.G_STATUS_UP, MGMT_GLOBAL.G_STATUS_DOWN) AND
                 mgmt_metrics_info.metric_guid = mgmt_current_severity.metric_guid AND
                 mgmt_targets.target_guid = mgmt_current_severity.target_guid AND
                 mgmt_targets.target_guid = mgmt_current_availability.target_guid AND
                 mgmt_targets.target_guid IN
                 (
                  SELECT
                  mgmt_flat_target_assoc.assoc_target_guid
                  FROM
                  mgmt_flat_target_assoc, mgmt_targets
                  WHERE
                  mgmt_flat_target_assoc.source_target_guid = upper(l_aggregate_guid) AND
                  mgmt_flat_target_assoc.is_membership=1 AND
                  mgmt_flat_target_assoc.assoc_target_guid=mgmt_targets.target_guid AND
                  mgmt_targets.target_type NOT IN
                 (select distinct name from table(cast(p_tgtypelist as SMP_EMD_NVPAIR_ARRAY)))
                 )
             ORDER BY alrt_timestmp DESC
             )
             WHERE ROWNUM < 2001;
        ELSIF (p_target_type IS NOT NULL AND p_target_status IS NULL) THEN
        -- This will be invoked from the "Rollup View" for a particular target type.
             OPEN p_alerts FOR
             SELECT
                 target_guid,
                 target_name,
                 target_type,
                 target_status,
                 metric_name,
                 metric_column,
                 key_value,
                 alrt_timestmp,
                 alert_message,
                 message_nlsid,
                 message_params,
                 severity_description,
                 severity_type,
                 alert_comment,
                 severity_guid
             FROM
             (
             SELECT
                 mgmt_current_availability.target_guid,
                 mgmt_targets.target_name,
                 mgmt_targets.target_type,
                 mgmt_current_availability.current_status target_status,  -- 0 denotes target down
                 mgmt_metrics_info.metric_name metric_name,
                 mgmt_metrics_info.metric_column metric_column,
                 mgmt_current_severity.key_value,
                 mgmt_current_severity.collection_timestamp alrt_timestmp,
                 mgmt_current_severity.message alert_message,
                 mgmt_current_severity.message_nlsid message_nlsid,
                 mgmt_current_severity.message_params message_params,
                 NVL(em_system_dashboard.get_severity_description(mgmt_current_severity.severity_code), 'Severity Code is Null' )severity_description,
                 mgmt_current_severity.severity_type severity_type,
                 (
                    SELECT nvl(a1.user_name,p_default_username)||' : '||a1.message
                    FROM  mgmt_severity_annotation a1
                    WHERE severity_guid = mgmt_current_severity.severity_guid
                    AND rownum < 2 and
                    collection_timestamp =
                    (
                      SELECT max(collection_timestamp)
                      FROM mgmt_severity_annotation 
                      WHERE severity_guid = mgmt_current_severity.severity_guid
                    )
                 ) alert_comment,
                 mgmt_current_severity.severity_guid severity_guid
             FROM
                 mgmt_current_severity, mgmt_targets, mgmt_current_availability,
                 (
             SELECT
                 DISTINCT metric_guid,
                 metric_name,
                 metric_column
             FROM
                 mgmt_metrics
                 ) mgmt_metrics_info
             WHERE
                 mgmt_current_availability.current_status IN (MGMT_GLOBAL.G_STATUS_UP, MGMT_GLOBAL.G_STATUS_DOWN) AND
                 mgmt_metrics_info.metric_guid = mgmt_current_severity.metric_guid AND
                 mgmt_targets.target_guid = mgmt_current_severity.target_guid AND
                 mgmt_targets.target_guid = mgmt_current_availability.target_guid AND
                 mgmt_targets.TARGET_TYPE = p_target_type AND
                 mgmt_targets.target_guid IN
                 (
                  SELECT
                  mgmt_flat_target_assoc.assoc_target_guid
                  FROM
                  mgmt_flat_target_assoc, mgmt_targets
                  WHERE
                  mgmt_flat_target_assoc.source_target_guid = upper(l_aggregate_guid) AND
                  mgmt_flat_target_assoc.is_membership=1 AND
                  mgmt_flat_target_assoc.assoc_target_guid=mgmt_targets.target_guid AND
                  mgmt_targets.target_type NOT IN
                 (select distinct name from table(cast(p_tgtypelist as SMP_EMD_NVPAIR_ARRAY)))
                 )
             ORDER BY alrt_timestmp DESC
             )
             WHERE ROWNUM < 2001;
        ELSIF (p_target_type IS NOT NULL AND p_target_status IS NOT NULL AND
           p_target_status IN (MGMT_GLOBAL.G_STATUS_UP, MGMT_GLOBAL.G_STATUS_DOWN)) THEN
         -- This will be invoked from the "Rollup View" for a particular target type and for a particular status.
         -- The alerts will be displayed only for targets which have "UP" and "DOWN" statuses.
             OPEN p_alerts FOR
             SELECT
                 target_guid,
                 target_name,
                 target_type,
                 target_status,
                 metric_name,
                 metric_column,
                 key_value,
                 alrt_timestmp,
                 alert_message,
                 message_nlsid,
                 message_params,
                 severity_description,
                 severity_type,
                 alert_comment,
                 severity_guid
             FROM
             (
             SELECT
                 mgmt_current_availability.target_guid,
                 mgmt_targets.target_name,
                 mgmt_targets.target_type,
                 mgmt_current_availability.current_status target_status,  -- 0 denotes target down
                 mgmt_metrics_info.metric_name metric_name,
                 mgmt_metrics_info.metric_column metric_column,
                 mgmt_current_severity.key_value,
                 mgmt_current_severity.collection_timestamp alrt_timestmp,
                 mgmt_current_severity.message alert_message,
                 mgmt_current_severity.message_nlsid message_nlsid,
                 mgmt_current_severity.message_params message_params,
                 NVL(em_system_dashboard.get_severity_description(mgmt_current_severity.severity_code), 'Severity Code is Null' )severity_description,
                 mgmt_current_severity.severity_type severity_type,
                 (
                    SELECT nvl(a1.user_name,p_default_username)||' : '||a1.message
                    FROM  mgmt_severity_annotation a1
                    WHERE severity_guid = mgmt_current_severity.severity_guid
                    AND rownum < 2 and
                    collection_timestamp =
                    (
                      SELECT max(collection_timestamp)
                      FROM mgmt_severity_annotation 
                      WHERE severity_guid = mgmt_current_severity.severity_guid
                    )
                 ) alert_comment,
                 mgmt_current_severity.severity_guid severity_guid
             FROM
                 mgmt_current_severity, mgmt_targets, mgmt_current_availability,
                 (
             SELECT
                 DISTINCT metric_guid,
                 metric_name,
                 metric_column
             FROM
                 mgmt_metrics
                 ) mgmt_metrics_info
             WHERE
                 mgmt_metrics_info.metric_guid = mgmt_current_severity.metric_guid AND
                 mgmt_targets.target_guid = mgmt_current_severity.target_guid AND
                 mgmt_targets.target_guid = mgmt_current_availability.target_guid AND
                 mgmt_current_availability.current_status=p_target_status AND
                 mgmt_targets.TARGET_TYPE = p_target_type AND
                 mgmt_targets.target_guid IN
                 (
                  SELECT
                  mgmt_flat_target_assoc.assoc_target_guid
                  FROM
                  mgmt_flat_target_assoc, mgmt_targets
                  WHERE
                  mgmt_flat_target_assoc.source_target_guid = upper(l_aggregate_guid) AND
                  mgmt_flat_target_assoc.is_membership=1 AND
                  mgmt_flat_target_assoc.assoc_target_guid=mgmt_targets.target_guid AND
                  mgmt_targets.target_type NOT IN
                 (select distinct name from table(cast(p_tgtypelist as SMP_EMD_NVPAIR_ARRAY)))
                 )
             ORDER BY alrt_timestmp DESC
             )
             WHERE ROWNUM < 2001;
        END IF;
    ELSE
        OPEN p_alerts FOR
            SELECT
                NULL AS target_guid,
                NULL AS target_name,
                NULL AS target_type,
                NULL AS target_status,
                NULL AS metric_name,
                NULL AS metric_column,
                NULL AS key_value,
                NULL AS alrt_timestmp,
                NULL AS alert_message,
                NULL AS message_nlsid,
                NULL AS message_params,
                NULL AS severity_description,
                NULL AS severity_type,
                NULL AS alert_comment,
                NULL AS severity_guid
            FROM
                DUAL;
    END IF;
    p_down_cnt := 0;
    p_warning_cnt := 0;
    p_critical_cnt := 0;

   -- Introduced this SQL to return the total number of Critical, Warning and Down targets for the provided aggregate target.
    -- Writing separate cursor for all the applicable value conditions of p_target_type and p_target_status
    -- for enhancing the performance.
     IF (p_target_type IS NULL AND p_target_status IS NULL) THEN
     OPEN c_alert_count FOR
      SELECT
          count(*) cnt,
          current_status,
          severity_code,
          severity_type
      FROM
          mgmt_current_availability,
          mgmt_current_severity ,
          mgmt_targets
      WHERE
          mgmt_current_availability.current_status IN (MGMT_GLOBAL.G_STATUS_UP, MGMT_GLOBAL.G_STATUS_DOWN) AND
          mgmt_current_availability.target_guid = mgmt_current_severity.target_guid and
          mgmt_current_availability.target_guid = mgmt_targets.target_guid and
         -- mgmt_targets.target_type = NVL(p_target_type,mgmt_targets.target_type) and
         -- mgmt_current_availability.current_status = NVL(p_target_status,mgmt_current_availability.current_status) AND
          mgmt_current_availability.target_guid in
          (
              SELECT
                  mgmt_flat_target_assoc.assoc_target_guid
              FROM
                  mgmt_flat_target_assoc, mgmt_targets
              WHERE
                  mgmt_flat_target_assoc.source_target_guid = l_aggregate_guid AND
                  mgmt_flat_target_assoc.is_membership=1 AND
                  mgmt_flat_target_assoc.assoc_target_guid=mgmt_targets.target_guid AND
                  mgmt_targets.target_type NOT IN
                 (select distinct name from table(cast(p_tgtypelist as SMP_EMD_NVPAIR_ARRAY)))
          )   GROUP BY current_status,severity_code,severity_type;

     ELSIF (p_target_type IS NOT NULL AND p_target_status IS NULL) THEN
     OPEN c_alert_count FOR
      SELECT
          count(*) cnt,
          current_status,
          severity_code,
          severity_type
      FROM
          mgmt_current_availability,
          mgmt_current_severity ,
          mgmt_targets
      WHERE
          mgmt_current_availability.current_status IN (MGMT_GLOBAL.G_STATUS_UP, MGMT_GLOBAL.G_STATUS_DOWN) AND
          mgmt_current_availability.target_guid = mgmt_current_severity.target_guid AND
          mgmt_current_availability.target_guid = mgmt_targets.target_guid AND
          mgmt_targets.target_type = p_target_type AND
         -- mgmt_current_availability.current_status = NVL(p_target_status,mgmt_current_availability.current_status) AND
          mgmt_current_availability.target_guid IN
          (
              SELECT
                  mgmt_flat_target_assoc.assoc_target_guid
              FROM
                  mgmt_flat_target_assoc, mgmt_targets
              WHERE
                  mgmt_flat_target_assoc.source_target_guid = l_aggregate_guid AND
                  mgmt_flat_target_assoc.is_membership=1 AND
                  mgmt_flat_target_assoc.assoc_target_guid=mgmt_targets.target_guid AND
                  mgmt_targets.target_type NOT IN
                 (select distinct name from table(cast(p_tgtypelist as SMP_EMD_NVPAIR_ARRAY)))
          )   GROUP BY current_status,severity_code,severity_type;
     ELSIF (p_target_type IS NOT NULL AND p_target_status IS NOT NULL AND
            p_target_status IN (MGMT_GLOBAL.G_STATUS_UP, MGMT_GLOBAL.G_STATUS_DOWN)) THEN
     OPEN c_alert_count FOR
      SELECT
          count(*) cnt,
          current_status,
          severity_code,
          severity_type
      FROM
          mgmt_current_availability,
          mgmt_current_severity ,
          mgmt_targets
      WHERE
          mgmt_current_availability.target_guid = mgmt_current_severity.target_guid AND
          mgmt_current_availability.target_guid = mgmt_targets.target_guid AND
          mgmt_targets.target_type = p_target_type AND
          mgmt_current_availability.current_status = p_target_status AND
          mgmt_current_availability.target_guid IN
          (
              SELECT
                  mgmt_flat_target_assoc.assoc_target_guid
              FROM
                  mgmt_flat_target_assoc, mgmt_targets
              WHERE
                  mgmt_flat_target_assoc.source_target_guid = l_aggregate_guid AND
                  mgmt_flat_target_assoc.is_membership=1 AND
                  mgmt_flat_target_assoc.assoc_target_guid=mgmt_targets.target_guid AND
                  mgmt_targets.target_type NOT IN
                 (select distinct name from table(cast(p_tgtypelist as SMP_EMD_NVPAIR_ARRAY)))
          )   GROUP BY current_status,severity_code,severity_type;
    END IF;
    LOOP
        FETCH c_alert_count INTO p_cnt, p_current_status, p_severity_code, p_severity_type;
        EXIT WHEN c_alert_count%NOTFOUND;
        IF ( p_current_status = MGMT_GLOBAL.G_STATUS_DOWN AND p_severity_code = MGMT_GLOBAL.G_SEVERITY_CRITICAL AND
             p_severity_type = 1) THEN
            p_down_cnt := p_down_cnt + p_cnt;
        ELSIF (p_severity_code = MGMT_GLOBAL.G_SEVERITY_CRITICAL AND p_current_status != MGMT_GLOBAL.G_STATUS_DOWN ) THEN
            p_critical_cnt := p_critical_cnt + p_cnt;
        ELSIF (p_severity_code = MGMT_GLOBAL.G_SEVERITY_WARNING AND p_current_status != MGMT_GLOBAL.G_STATUS_DOWN ) THEN
            p_warning_cnt := p_warning_cnt + p_cnt;
        END IF;
    END LOOP;
END get_alert_info;

-- Purpose : To Drive the Target Section of the System Dashboard in "FULL" view
-- Three possibilities :
-- 1.All (p_target_type and p_target_status are NULL)
-- 2.That Belong to a Specific Target Type (All hosts or databases) (p_target_status is null) and
-- 3. That Belong to a Specific Target Type and of a Specific Status (All hosts that are down)
-- Input Parameters
-- p_aggregate_target_type : Name of the aggregate target type, which is having the value in the property_name as "is_system" and "is_group"
-- p_aggregate_name : Name of the target belonging to an aggregate target type, for which the Dashboard is Painted
-- p_target_status : Status of the Targets which need to be included in Dashboard (optional)
-- p_target_type : Target Type to which the Dashboard is limited to
-- Out Parameters
-- EM_TARGET_ARRAY : encompasses Target GUID, Name, Status, Alert and Metric Information
PROCEDURE get_target_info_full
(
    p_aggregate_name        IN  VARCHAR2,
    p_aggregate_target_type IN  VARCHAR2,
    p_target_type           IN  VARCHAR2 DEFAULT NULL,
    p_target_status         IN  VARCHAR2 DEFAULT NULL,
    p_target_details        OUT NOCOPY EM_TARGET_ARRAY
)
IS
    TYPE MetricTab                 IS TABLE OF mgmt_metrics.metric_guid%TYPE;
    TYPE MetricAbbreviationTab     IS TABLE OF mgmt_group_custom_columns.abbreviation%TYPE;
    TYPE TargetGuidCurType         IS REF CURSOR;
    TYPE metriccolumnarray         IS TABLE OF mgmt_metrics.metric_column%TYPE;
    TYPE metricnamearray           IS TABLE OF mgmt_metrics.metric_name%TYPE;
    TYPE MetricPropertyNameTab     IS TABLE OF mgmt_target_prop_defs.property_name%TYPE;
    TYPE MetricColumnLabelTab      IS TABLE OF mgmt_target_prop_defs.property_display_name%TYPE;
    TYPE MetricColumnLabelNLSIDTab IS TABLE OF mgmt_target_prop_defs.property_display_nlsid%TYPE;
    TYPE MetricTargetTypeTab       IS TABLE OF mgmt_group_custom_columns.target_type%TYPE;
    TYPE Metricdisplay_orderTab    IS TABLE OF mgmt_group_custom_columns.display_order%TYPE;
    TYPE ColumnTypeTab             IS TABLE OF mgmt_group_custom_columns.column_type%TYPE;
    TYPE severity_code             IS TABLE OF mgmt_current_severity.severity_code%TYPE;
    TYPE severity_type             IS TABLE OF mgmt_current_severity.severity_type%TYPE;
    TYPE current_status            IS TABLE OF mgmt_current_availability.current_status%TYPE;
    TYPE target_id                 IS TABLE OF mgmt_targets.target_guid%TYPE;
    TYPE targetname                IS TABLE OF mgmt_targets.target_name%TYPE;
    TYPE count_severity            IS TABLE OF NUMBER;
    TYPE metric_value              IS TABLE OF mgmt_current_metrics.value%TYPE;

    TYPE p_policy_record IS RECORD
	(
	    target_guid       mgmt_targets.target_guid%TYPE,
	    p_information_cnt NUMBER,
	    p_warning_cnt     NUMBER,
	    p_critical_cnt    NUMBER,
	    p_compliance_scre NUMBER
	);
    TYPE p_policy_table            IS TABLE OF p_policy_record INDEX BY BINARY_INTEGER;

    l_count                        NUMBER DEFAULT 0;
    has_member_targets             BOOLEAN DEFAULT TRUE;
    l_target_counter               NUMBER DEFAULT 0;
    l_metric_counter               NUMBER DEFAULT 0;
    l_alert_counter                NUMBER DEFAULT 0;
    l_status_counter               NUMBER DEFAULT 0;
    l_policy_details_counter       NUMBER DEFAULT 0;
    l_select_statement             VARCHAR2(4000) DEFAULT NULL;
    l_select_clause                VARCHAR2(1000) DEFAULT NULL;
    l_from_clause                  VARCHAR2(1000) DEFAULT NULL;
    l_where_clause                 VARCHAR2(4000) DEFAULT NULL;
    l_aggregate_guid               mgmt_targets.target_guid%type DEFAULT NULL;
    l_metric_target_type           mgmt_metrics.target_type%type DEFAULT NULL;
    l_metric_abbreviation_array    MetricAbbreviationTab;
    l_tgt_type_metric_abbrev_array MetricAbbreviationTab :=MetricAbbreviationTab();
    l_metric_target_type_array     varchar2_table := varchar2_table();
    l_metric_label_array           varchar2_table := varchar2_table();
    l_metric_label_nlsid_array     varchar2_table := varchar2_table();
    l_metric_prop_name_array       varchar2_table := varchar2_table();
    targetGuidCur                  TargetGuidCurType;  -- declare cursor variable
    l_target_guid_array            mgmt_target_guid_array;
    l_metricguid_array             mgmt_target_guid_array;
    p_metricguid_arr               mgmt_target_guid_array;
    l_targettype_metricguid_array  mgmt_target_guid_array := mgmt_target_guid_array();
    p_metriccolumn_arr             metriccolumnarray;
    p_metricname_arr               metricnamearray;
    l_metric_value                 mgmt_current_metrics.value%type;
    l_metric_property_name_array   MetricPropertyNameTab := MetricPropertyNameTab();
    l_column_label_array           MetricColumnLabelTab := MetricColumnLabelTab();
    l_column_label_nlsid_array     MetricColumnLabelNLSIDTab := MetricColumnLabelNLSIDTab();
    l_target_type_array            MetricTargetTypeTab := MetricTargetTypeTab();
    l_display_order_array          Metricdisplay_orderTab :=Metricdisplay_orderTab() ;
    l_column_type_array            ColumnTypeTab := ColumnTypeTab();
    is_target_aggregate            VARCHAR2(10) DEFAULT NULL;
    p_plcy_information_count       NUMBER DEFAULT 0;
    p_plcy_warning_count           NUMBER DEFAULT 0;
    p_plcy_critical_count          NUMBER DEFAULT 0;
    p_compliance_score             NUMBER DEFAULT 0;
    p_severity_code_array          severity_code;
    p_severity_code_comp_array     severity_code;
    p_severity_type_array          severity_type;
    p_severity_type_comp_array     severity_type;
    p_current_status_array         current_status;
    p_current_status_comp_array    current_status;
    p_tgt_status_comp_array        current_status;
    p_curr_status_array            current_status;
    p_target_guid_array            target_id;
    p_target_guid_comp_array       target_id;
    p_tgt_guid_comp_array          target_id;
    p_tgt_id_array                 target_id;
    p_tgt_name_array               targetname;
    p_count_severity_array         count_severity;
    p_count_severity_comp_array    count_severity;
    p_status_count_comp_array      count_severity;
    p_value_array                  metric_value := metric_value();
    p_tgt_details                  SMP_EMD_NVPAIR_ARRAY := SMP_EMD_NVPAIR_ARRAY();
    p_metdet_array                 SMP_EMD_NVPAIR_ARRAY := SMP_EMD_NVPAIR_ARRAY();
    p_tgtypelist                   SMP_EMD_NVPAIR_ARRAY := SMP_EMD_NVPAIR_ARRAY();
    p_policy_rec                   p_policy_record;
    p_policy_arr                   p_policy_table;
    l_count_array                  count_severity;
    l_source_tgt_guid_array        mgmt_target_guid_array := mgmt_target_guid_array();
    p_target_guid_array_cnt        PLS_INTEGER := 0;
    icnt                           PLS_INTEGER := 0;
    p_tgt_details_cnt              PLS_INTEGER := 0;
    p_tgt_guid_comp_array_cnt      PLS_INTEGER := 0;
    p_metricguid_arr_cnt           PLS_INTEGER := 0;
    l_metricguid_array_cnt         PLS_INTEGER := 0;
    p_target_guid_comp_array_cnt   PLS_INTEGER := 0;
    l_prop_name_count              NUMBER := 0;

     -- Inline procedure to calculate the policy violations for all the targets (standalone or nested group/systems)
     -- with the supplied group / system.
    PROCEDURE get_tgt_policy_violation_detls
    (
         p_aggregate_GUID        IN VARCHAR2,
         p_targetguid_array      IN SMP_EMD_NVPAIR_ARRAY
    )
    IS
        l_policy_viol_prop  NUMBER := 1;
        l_policy_comp_prop  NUMBER := 1;
    BEGIN
       -- This is specifically usd for checking of the policy violation column has been selected for that group / system for which the
       -- dashboard is launched.
       -- This query returns the policy violation and compliance score for all the targets which are included in the group / system.
        SELECT /*+ INDEX(e) */ tgt.parent AS target_guid,
            SUM(DECODE(e.max_violation_level, MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
                    e.non_exempt_violations_logged,0)) AS information_count,
            SUM(DECODE(e.max_violation_level, MGMT_GLOBAL.G_SEVERITY_WARNING,
                    e.non_exempt_violations_logged,0)) AS warning_count,
            SUM(DECODE(e.max_violation_level, MGMT_GLOBAL.G_SEVERITY_CRITICAL,
                    e.non_exempt_violations_logged,0)) AS critical_count,
            ROUND(AVG(DECODE(tgt.parent,tgt.child,compliance_score,0))) AS compliance_score
        BULK COLLECT INTO p_policy_arr
        FROM   ( 
                    SELECT  /*+ cardinality(t1 10) */ HEXTORAW(t1.name) parent , HEXTORAW(t1.name) child 
                    FROM  TABLE(CAST(p_targetguid_array AS SMP_EMD_NVPAIR_ARRAY)) t1              
                    UNION
                    SELECT /*+ cardinality(t2 10) */ tm.source_target_guid AS parent, 
                            tm.assoc_target_guid AS child
                    FROM    TABLE(CAST(p_targetguid_array AS SMP_EMD_NVPAIR_ARRAY)) t2,
                            mgmt_flat_target_assoc tm
                    WHERE  tm.source_target_guid = HEXTORAW(t2.name)
                      AND  tm.is_membership = 1
            ) tgt,
            mgmt_policy_assoc_eval_summ e
        WHERE  tgt.child     = e.target_guid (+)
            AND  EXISTS
                (   SELECT /*+ INDEX(r) */ 1
                    FROM   mgmt_policies r
                    WHERE  r.policy_guid = e.policy_guid
                      AND  r.policy_type = 2)
       GROUP BY tgt.parent ;
    END get_tgt_policy_violation_detls;
BEGIN
    -- Get all the applicable target types belonging to is_group and is_system properties.
    p_tgtypelist := get_composite_target_types;
    -- Table "mgmt_flat_target_assoc" stores only GUIDs of both Parents and Children
    -- Get GUID of aggregate target
    -- Validate the p_aggregate_target_type with the list of aggregate target types available in the system
    -- The system currently supports all the aggregate target types
    -- which are having the value in the property_name as "is_system" and "is_group"
    is_target_aggregate := is_target_type_aggregate(p_aggregate_target_type,p_tgtypelist);
    IF (is_target_aggregate ='TRUE') THEN
         FOR c1 IN
        (
            SELECT
                target_guid aggregate_guid
            FROM
                mgmt_targets
            WHERE
                target_name=p_aggregate_name AND
                target_type = p_aggregate_target_type
        )
        LOOP
            l_aggregate_guid:=c1.aggregate_guid;
        END LOOP;
    ELSE
        RETURN;
    END IF;
    IF (l_aggregate_guid IS NULL) THEN  -- Aggregate target Does Not Exist
       RETURN;
    END IF;

    -- First get the GUIDs of Targets you will display in the Dashboard
    -- Three possibilities : 1.All (p_target_type and p_target_status are NULL)
    -- 2.That Belong to a Specific Target Type (All hosts or databases) (p_target_status is null) and
    -- 3. That Belong to a Specific Target Type and of a Specific Status (All hosts that are down)
    IF (p_target_type IS NULL AND p_target_status IS NULL) THEN
        OPEN targetGuidCur FOR
            SELECT  assoc_target_guid
            FROM    mgmt_target_assocs
            WHERE   mgmt_target_assocs.source_target_guid=l_aggregate_guid
            INTERSECT
            SELECT  assoc_target_guid
            FROM    mgmt_flat_target_assoc
            WHERE   mgmt_flat_target_assoc.source_target_guid=l_aggregate_guid AND
                    mgmt_flat_target_assoc.is_membership = 1;
    ELSIF (p_target_type IS NOT NULL AND p_target_status IS NULL) THEN
        OPEN targetGuidCur FOR
            SELECT  assoc_target_guid
            FROM    mgmt_flat_target_assoc,
                    mgmt_targets
            WHERE   mgmt_flat_target_assoc.is_membership=1 AND
                    mgmt_flat_target_assoc.source_target_guid= l_aggregate_guid AND
                    mgmt_flat_target_assoc.assoc_target_guid=mgmt_targets.target_guid AND
                    mgmt_targets.target_type = p_target_type;
    ELSIF (p_target_status IS NOT NULL) THEN
        IF (p_target_status=MGMT_GLOBAL.G_STATUS_UNKNOWN) THEN
             OPEN targetGuidCur FOR
                 SELECT  assoc_target_guid
                 FROM    mgmt_flat_target_assoc,
                         mgmt_targets,
                         mgmt_current_availability
                  WHERE  mgmt_flat_target_assoc.is_membership=1 AND
                         mgmt_flat_target_assoc.source_target_guid=l_aggregate_guid AND
                         mgmt_targets.target_type =p_target_type AND
                         mgmt_current_availability.current_status IN (
                                                                        to_number(MGMT_GLOBAL.G_STATUS_UNKNOWN), 
                                                                        to_number(MGMT_GLOBAL.G_STATUS_AGENT_DOWN), 
                                                                        to_number(MGMT_GLOBAL.G_STATUS_UNREACHABLE)) AND
                         mgmt_flat_target_assoc.assoc_target_guid=mgmt_targets.target_guid AND
                         mgmt_current_availability.target_guid(+)=mgmt_flat_target_assoc.assoc_target_guid;
	    ELSE -- IF (p_target_status=MGMT_GLOBAL.G_STATUS_UNKNOWN)
            OPEN targetGuidCur FOR
                SELECT  assoc_target_guid
                FROM    mgmt_flat_target_assoc,
                        mgmt_targets,
                        mgmt_current_availability
                WHERE   mgmt_flat_target_assoc.is_membership=1 AND
                        mgmt_flat_target_assoc.source_target_guid=l_aggregate_guid AND
                        mgmt_targets.target_type =p_target_type AND
                        mgmt_current_availability.current_status = TO_NUMBER(p_target_status) AND
                        mgmt_flat_target_assoc.assoc_target_guid=mgmt_targets.target_guid AND
                        mgmt_current_availability.target_guid(+)=mgmt_flat_target_assoc.assoc_target_guid;

     	END IF;-- IF (p_target_status=MGMT_GLOBAL.G_STATUS_UNKNOWN)

    END IF;
    FETCH targetGuidCur BULK COLLECT INTO l_target_guid_array;
    CLOSE targetGuidCur;

    -- An aggregate target / group contains member targets.
    -- The GROUP Creator specifies what columns (both metric and non-metric related columns)
    -- needs to be tracked for each "target_type"
    -- For example, IF we SELECT "oracle_database - Lock Limit Usage (%)", "oracle_database - Database SID"
    -- THEN we display the values of above columns for all members of type "database" of the Group
    -- For this, we query the MGMT_GROUP_CUSTOM_COLUMNS table.
    WITH all_cols AS
          (
            SELECT DISTINCT composite_target_guid, 
                            column_type, 
                            member_metric_guid,
                            property_name, 
                            target_type, 
                            abbreviation, 
                            display_order,
                            view_type
              FROM mgmt_group_custom_columns
             WHERE composite_target_guid = l_aggregate_guid
          ),
    selected_cols as
    (
        SELECT
            distinct all_cols.display_order display_order,
            all_cols.column_type,
            all_cols.member_metric_guid member_metric_guid,
            all_cols.abbreviation abbreviation,
            all_cols.property_name property_name,
            m.column_label  column_label,
	    m.column_label_nlsid column_label_nlsid,
            all_cols.target_type target_type
        FROM
            all_cols,
            mgmt_metrics m
        WHERE
            all_cols.column_type=em_groups_ui.G_COLUMN_TYPE_METRIC AND
            m.metric_guid = all_cols.member_metric_guid    AND
            m.num_keys = 0    AND
            m.usage_type = 0 AND
            m.metric_type = 0 AND
            NOT (m.metric_name='Response' AND m.metric_column='Status')
        UNION ALL
        SELECT
            all_cols.display_order display_order,
            all_cols.column_type,
            null as  member_metric_guid ,
            all_cols.abbreviation abbreviation,
            all_cols.property_name property_name,
            p.property_display_name column_label,
	    p.property_display_nlsid column_label_nlsid,
            all_cols.target_type    target_type
        FROM
            all_cols,
            mgmt_target_prop_defs p
        WHERE
            all_cols.column_type=em_groups_ui.G_COLUMN_TYPE_PROPERTY    AND
            all_cols.target_type =  p.target_type AND
            p.property_name = all_cols.property_name AND
            p.hidden_flag = 0 AND
            p.credential_flag = 0
        UNION ALL
        SELECT
            display_order,
            all_cols.column_type,
            null as  member_metric_guid ,
            all_cols.abbreviation abbreviation,
            all_cols.property_name property_name,
            g.property_display_name column_label,
	    g.property_display_nlsid column_label_nlsid,
            all_cols.target_type target_type
        FROM
            all_cols,
            mgmt_all_target_props g
        WHERE
            all_cols.column_type=em_groups_ui.G_COLUMN_TYPE_GEN_PROPERTY and
            all_cols.property_name=g.property_name
        UNION ALL
        SELECT
            display_order,
            all_cols.column_type,
            null as  member_metric_guid ,
            all_cols.abbreviation abbreviation,
            all_cols.property_name property_name,
            all_cols.property_name as column_label,
	    null as column_label_nlsid,
            null as target_type
        FROM
            all_cols
        WHERE
            all_cols.column_type =em_groups_ui.G_COLUMN_TYPE_GENERAL AND
            all_cols.property_name NOT IN
                (
                    emd_pref.MGMT_USER_PREF_AVAIL_COL,
                    emd_pref.MGMT_USER_PREF_NAME_COL
                )
    )
    SELECT DISTINCT
         display_order,
         column_type,
         member_metric_guid ,
         abbreviation,
         property_name,
         column_label,
         column_label_nlsid,
         target_type
    BULK COLLECT
    INTO
         l_display_order_array,
         l_column_type_array,
         l_metricguid_array,
         l_metric_abbreviation_array,
         l_metric_property_name_array,
         l_column_label_array,
         l_column_label_nlsid_array,
         l_target_type_array
    FROM
        selected_cols
    ORDER BY
        display_order;

     SELECT count(*)
     INTO   l_prop_name_count
     FROM    mgmt_group_custom_columns
     WHERE  composite_target_guid = l_aggregate_guid
        AND property_name = emd_pref.MGMT_USER_PREF_NAME_COL;

   -- If there are no records are retrieved from the MGMT_GROUP_CUSTOM_COLUMNS table for the particular target,
   -- then try getting records from MGMT_CSTMZ_CUSTOM_COLUMNS table.
    IF ((l_column_type_array.COUNT = 0 OR l_column_type_array IS NULL)
        AND l_prop_name_count = 0 ) THEN
        WITH all_cols AS
          (
            SELECT DISTINCT composite_target_guid, 
                            column_type, 
                            member_metric_guid,
                            property_name,
                            target_type,
                            abbreviation, 
                            display_order,
                            view_type
              FROM mgmt_cstmz_custom_columns
             WHERE composite_target_guid = l_aggregate_guid
          ),
        selected_cols as
        (
        SELECT
            distinct all_cols.display_order display_order,
            all_cols.column_type,
            all_cols.member_metric_guid member_metric_guid,
            all_cols.abbreviation abbreviation,
            all_cols.property_name property_name,
            m.column_label  column_label,
            m.column_label_nlsid column_label_nlsid,
            all_cols.target_type target_type
        FROM
            all_cols,
            mgmt_metrics m
        WHERE
            all_cols.column_type=em_groups_ui.G_COLUMN_TYPE_METRIC AND
            m.metric_guid = all_cols.member_metric_guid    AND
            m.num_keys = 0    AND
            m.usage_type = 0 AND
            m.metric_type = 0 AND
            NOT (m.metric_name='Response' AND m.metric_column='Status')
        UNION ALL
        SELECT
            all_cols.display_order display_order,
            all_cols.column_type,
            null as  member_metric_guid ,
            all_cols.abbreviation abbreviation,
            all_cols.property_name property_name,
            p.property_display_name column_label,
            p.property_display_nlsid column_label_nlsid,
            all_cols.target_type    target_type
        FROM
            all_cols,
            mgmt_target_prop_defs p
        WHERE
            all_cols.column_type=em_groups_ui.G_COLUMN_TYPE_PROPERTY    AND
            all_cols.target_type =  p.target_type AND
            p.property_name = all_cols.property_name AND
            p.hidden_flag = 0 AND
            p.credential_flag = 0
        UNION ALL
        SELECT
            display_order,
            all_cols.column_type,
            null as  member_metric_guid ,
            all_cols.abbreviation abbreviation,
            all_cols.property_name property_name,
            g.property_display_name column_label,
            g.property_display_nlsid column_label_nlsid,
            all_cols.target_type target_type
        FROM
            all_cols,
            mgmt_all_target_props g
        WHERE
            all_cols.column_type=em_groups_ui.G_COLUMN_TYPE_GEN_PROPERTY and
            all_cols.property_name=g.property_name
        UNION ALL
        SELECT
            display_order,
            all_cols.column_type,
            null as  member_metric_guid ,
            all_cols.abbreviation abbreviation,
            all_cols.property_name property_name,
            all_cols.property_name as column_label,
            null as column_label_nlsid,
            null as target_type
        FROM
            all_cols
        WHERE
            all_cols.column_type =em_groups_ui.G_COLUMN_TYPE_GENERAL AND
            all_cols.property_name NOT IN
            (
                emd_pref.MGMT_USER_PREF_AVAIL_COL,
                emd_pref.MGMT_USER_PREF_NAME_COL
            )
        )
        SELECT
         display_order,
         column_type,
         member_metric_guid ,
         abbreviation,
         property_name,
         column_label,
         column_label_nlsid,
         target_type
        BULK COLLECT
        INTO
         l_display_order_array,
         l_column_type_array,
         l_metricguid_array,
         l_metric_abbreviation_array,
         l_metric_property_name_array,
         l_column_label_array,
         l_column_label_nlsid_array,
         l_target_type_array
        FROM
        selected_cols
        ORDER BY
        display_order;
        
        SELECT count(*)
        INTO   l_prop_name_count
        FROM   mgmt_cstmz_custom_columns
        WHERE  composite_target_guid = l_aggregate_guid
           AND property_name = emd_pref.MGMT_USER_PREF_NAME_COL;

    END IF;
/*
    IF (p_aggregate_target_type IN
    	        (MGMT_GLOBAL.G_IAS_TARGET_TYPE,
        	'weblogic_domain',     
	        MGMT_GLOBAL.G_OC4J_TARGET_TYPE,                
	        'websphere_cell',      
        	'oracle_ias_farm',     
        	'oracle_ias_cluster',     
	        'oracle_ias_jmx_cluster','jboss_partition')) 
    THEN
    END IF;
*/
        IF ((l_metric_property_name_array IS NULL OR l_metric_property_name_array.COUNT = 0)
            AND l_prop_name_count = 0)
        THEN 
            l_display_order_array.extend;
            l_display_order_array(1):= 1;
            l_column_type_array.extend;
            l_column_type_array(1) := em_groups_ui.G_COLUMN_TYPE_GENERAL;
            l_metricguid_array.extend;
            l_metricguid_array(1) := NULL;
            l_metric_abbreviation_array.extend;
            l_metric_abbreviation_array(1) := 'STATUS';
            l_metric_property_name_array.extend;
            l_metric_property_name_array(1) := emd_pref.MGMT_USER_PREF_STATUS_COLUMN;
            l_column_label_array.extend;
            l_column_label_array(1) := emd_pref.MGMT_USER_PREF_STATUS_COLUMN;
            l_column_label_nlsid_array.extend;
            l_column_label_nlsid_array(1) := NULL;
            l_target_type_array.extend;
            l_target_type_array(1) := NULL;
        
            l_display_order_array.extend;
            l_display_order_array(2):= 2;
            l_column_type_array.extend;
            l_column_type_array(2) := em_groups_ui.G_COLUMN_TYPE_GENERAL;
            l_metricguid_array.extend;
            l_metricguid_array(2) := NULL;
            l_metric_abbreviation_array.extend;
            l_metric_abbreviation_array(2) := 'TYPE';
            l_metric_property_name_array.extend;
            l_metric_property_name_array(2) := emd_pref.MGMT_USER_PREF_TYPE_COL;
            l_column_label_array.extend;
            l_column_label_array(2) := emd_pref.MGMT_USER_PREF_TYPE_COL;
            l_column_label_nlsid_array.extend;
            l_column_label_nlsid_array(2) := NULL;
            l_target_type_array.extend;
            l_target_type_array(2) := NULL;
            l_display_order_array.extend;
            l_display_order_array(3):= 3;
            l_column_type_array.extend;
            l_column_type_array(3) := em_groups_ui.G_COLUMN_TYPE_GENERAL;
            l_metricguid_array.extend;
            l_metricguid_array(3) := NULL;
            l_metric_abbreviation_array.extend;
            l_metric_abbreviation_array(3) := 'ALERTS';
            l_metric_property_name_array.extend;
            l_metric_property_name_array(1) := emd_pref.MGMT_USER_PREF_ALERTS_COL;
            l_column_label_array.extend;
            l_column_label_array(3) := emd_pref.MGMT_USER_PREF_ALERTS_COL;
            l_column_label_nlsid_array.extend;
            l_column_label_nlsid_array(3) := NULL;
            l_target_type_array.extend;
            l_target_type_array(3) := NULL;

            l_display_order_array.extend;
            l_display_order_array(4):= 4;
            l_column_type_array.extend;
            l_column_type_array(4) := em_groups_ui.G_COLUMN_TYPE_GENERAL;
            l_metricguid_array.extend;
            l_metricguid_array(4) := NULL;
            l_metric_abbreviation_array.extend;
            l_metric_abbreviation_array(4) := 'POLICY_VIOLATIONS';
            l_metric_property_name_array.extend;
            l_metric_property_name_array(4) := emd_pref.MGMT_USER_PREF_POL_VIOL_COL;
            l_column_label_array.extend;
            l_column_label_array(4) := emd_pref.MGMT_USER_PREF_POL_VIOL_COL;
            l_column_label_nlsid_array.extend;
            l_column_label_nlsid_array(4) := NULL;
            l_target_type_array.extend;
            l_target_type_array(4) := NULL;
        END IF;

    l_metricguid_array_cnt    := l_metricguid_array.COUNT;

   -- Loop through each of the columns selected and store the abbreviation and column labels
   -- to be displayed on the dashboard.
    IF (l_metricguid_array IS NOT NULL) AND (l_metricguid_array_cnt>0) THEN
        l_metric_counter:=0;
        FOR i IN 1..l_metricguid_array_cnt
        LOOP
            IF (p_target_type IS NOT NULL) THEN
                  IF((l_column_type_array(i) = em_groups_ui.G_COLUMN_TYPE_GENERAL) OR
                    (l_column_type_array(i) = em_groups_ui.G_COLUMN_TYPE_GEN_PROPERTY )) THEN
                    l_metric_counter:=l_metric_counter+1;
                    l_targettype_metricguid_array.extend;
                    l_targettype_metricguid_array(l_metric_counter):=l_metricguid_array(i);

                    l_tgt_type_metric_abbrev_array.extend;
                    l_tgt_type_metric_abbrev_array(l_metric_counter):= l_metric_abbreviation_array(i);

                    l_metric_target_type_array.extend;
                    l_metric_target_type_array(l_metric_counter):=l_target_type_array(i);

                    l_metric_label_array.extend;
                    l_metric_label_array(l_metric_counter):=l_column_label_array(i);

                    l_metric_label_nlsid_array.extend;
                    l_metric_label_nlsid_array(l_metric_counter):=l_column_label_nlsid_array(i);

                    l_metric_prop_name_array.extend;
                    l_metric_prop_name_array(l_metric_counter):= l_metric_property_name_array(i);
               END IF;
                -- Filter out Metrics Related to this Target Type Alone
                IF (l_target_type_array(i)=p_target_type) THEN
                    l_metric_counter:=l_metric_counter+1;

                    l_targettype_metricguid_array.extend;
                    l_targettype_metricguid_array(l_metric_counter):=l_metricguid_array(i);

                    l_tgt_type_metric_abbrev_array.extend;
                    l_tgt_type_metric_abbrev_array(l_metric_counter):= l_metric_abbreviation_array(i);

                    l_metric_target_type_array.extend;
                    l_metric_target_type_array(l_metric_counter):=l_target_type_array(i);

                    l_metric_label_array.extend;
                    l_metric_label_array(l_metric_counter):=l_column_label_array(i);

                    l_metric_label_nlsid_array.extend;
                    l_metric_label_nlsid_array(l_metric_counter):=l_column_label_nlsid_array(i);

                    l_metric_prop_name_array.extend;
                    l_metric_prop_name_array(l_metric_counter):= l_metric_property_name_array(i);
               END IF;
            ELSE -- Show all metrics related to this aggregate target in Full View
                    l_metric_counter:=l_metric_counter+1;

                    l_metric_target_type_array.extend;
                    l_metric_target_type_array(l_metric_counter):=l_target_type_array(i);

                    l_metric_label_array.extend;
                    l_metric_label_array(l_metric_counter):=l_column_label_array(i);

                    l_metric_label_nlsid_array.extend;
                    l_metric_label_nlsid_array(l_metric_counter):=l_column_label_nlsid_array(i);

                    l_metric_prop_name_array.extend;
                    l_metric_prop_name_array(l_metric_counter):= l_metric_property_name_array(i);

                    -- To get Abbreviation Info on Dashboard, uncomment line below
                    --l_metric_label_array(l_metric_counter):=l_metric_abbreviation_array(i);
            END IF;
        END LOOP; -- end i
        l_metric_counter:=0;  -- reset counter, after processing
    END IF; -- if (l_metricguid_array_cnt>0) ends

    -- If Full View is for a Specific Target Type,
    --restrict processing only to those Metrics which are applicable to it
    IF (p_target_type IS NOT NULL) THEN
       l_metricguid_array:=l_targettype_metricguid_array;
       l_metric_abbreviation_array:=l_tgt_type_metric_abbrev_array;
    END IF;

    l_metricguid_array_cnt := l_metricguid_array.COUNT;

    -- First get the target types, target names, targert guids and current status for all the target_guids got for the
    -- supplied aggregate guid, by joining mgmt_targets and mgmt_current_availability tables.
    -- This is done to avoid hitting the same tables for every target guid in the loop.
    -- So, fetching the required info in arrays so that they could be used in the loop without hitting the tables.
        SELECT
            SMP_EMD_NVPAIR(mt.target_guid,mt.target_type),
            mt.target_name,
            mca.current_status
        BULK COLLECT INTO
            p_tgt_details,
            p_tgt_name_array,
            p_curr_status_array
        FROM
            mgmt_targets mt, mgmt_current_availability mca
        WHERE
            mt.target_guid IN
            (SELECT * FROM TABLE (CAST(l_target_guid_array AS MGMT_TARGET_GUID_ARRAY))) AND
            mt.target_guid  = mca.target_guid(+);

    -- Fetching the severity code, status and counts of the associated standalone targets of the aggregate target.
    -- This is done to avoid hitting the same tables for every target guid in the loop.
        SELECT
            nvl(severity_code,0),
            current_status,
            tgtdet.name target_guid,
            count(*) count_severity,
            nvl(severity_type,0)
        BULK COLLECT INTO
            p_severity_code_array,
            p_current_status_array,
            p_target_guid_array,
            p_count_severity_array,
            p_severity_type_array
        FROM
            mgmt_current_severity,
            mgmt_current_availability,
            (SELECT *
            FROM TABLE (CAST(p_tgt_details AS smp_emd_nvpair_array))) tgtdet
        WHERE
            mgmt_current_availability.target_guid  = tgtdet.name AND
            mgmt_current_severity.target_guid(+) = tgtdet.name and
            tgtdet.value NOT IN
           (select distinct name from table(cast(p_tgtypelist as SMP_EMD_NVPAIR_ARRAY)))
        GROUP BY
             tgtdet.name,
             severity_code,
             current_status,
             severity_type;

    -- Fetching the severity code, status and counts of the associated aggregate targets of the aggregate target.
    -- This is done to avoid hitting the same tables for every target guid in the loop.
        SELECT
            severity_code,
            current_status,
            target_guid,
            count_severity,
            severity_type
        BULK COLLECT INTO
            p_severity_code_comp_array,
            p_current_status_comp_array,
            p_target_guid_comp_array,
            p_count_severity_comp_array,
            p_severity_type_comp_array
        FROM
        (
        SELECT
            nvl(severity_code,0) severity_code,
            current_status,
            mgmt_flat_Target_assoc.source_target_guid target_guid,
            count(*) count_severity,
            nvl(severity_type,0) severity_type
        FROM
            mgmt_current_severity,
            mgmt_current_availability,
            mgmt_flat_target_assoc,
            mgmt_targets,
            (SELECT *
             FROM TABLE (CAST(p_tgt_details AS smp_emd_nvpair_array))) tgtdet
             WHERE
                mgmt_flat_target_assoc.source_target_guid = tgtdet.name AND
                mgmt_flat_target_assoc.assoc_target_guid = mgmt_targets.target_guid AND
                mgmt_current_availability.target_guid(+) = mgmt_targets.target_guid AND
                mgmt_current_severity.target_guid(+) = mgmt_targets.target_guid AND
                mgmt_flat_target_assoc.is_membership = 1 AND
                mgmt_targets.target_type NOT IN
               (select distinct name from table(cast(p_tgtypelist as SMP_EMD_NVPAIR_ARRAY)))
        GROUP BY
            mgmt_flat_Target_assoc.source_target_guid,
            severity_code,
            current_status,
            severity_type
        UNION ALL
        SELECT
            nvl(severity_code,0) severity_code,
            current_status,
            mgmt_flat_Target_assoc.assoc_target_guid target_guid,
            count(*) count_severity,
            nvl(severity_type,0) severity_type
        FROM
            mgmt_current_severity,
            mgmt_current_availability,
            mgmt_flat_target_assoc,
            mgmt_targets
             WHERE
                mgmt_flat_target_assoc.source_target_guid = l_aggregate_guid AND
                mgmt_flat_target_assoc.assoc_target_guid = mgmt_targets.target_guid AND
                mgmt_current_availability.target_guid(+) = mgmt_targets.target_guid AND
                mgmt_current_severity.target_guid(+) = mgmt_targets.target_guid AND
                mgmt_flat_target_assoc.is_membership = 1 AND
                mgmt_targets.target_type IN
	                                        (MGMT_GLOBAL.G_IAS_TARGET_TYPE,
        	                                 'weblogic_domain',
                                                 MGMT_GLOBAL.G_OC4J_TARGET_TYPE,
	                                         'websphere_cell',
        	                                 'oracle_ias_farm',
        	                                 'oracle_ias_cluster',
	                                         'oracle_ias_jmx_cluster','jboss_partition')
        GROUP BY
            mgmt_flat_Target_assoc.assoc_target_guid,
            severity_code,
            current_status,
            severity_type
            );

    -- Fetching the statuses and status counts for all the aggregate targets which are associated to the
    -- supplied aggregate target.
    -- This is done to avoid hitting the same tables for every target guid in the loop.
        SELECT
           current_status,
           mfta.source_target_guid,
           count(*) status_count
        BULK COLLECT INTO
           p_tgt_status_comp_array,
           p_tgt_guid_comp_array,
           p_status_count_comp_array
        FROM
           mgmt_current_availability mca,
           mgmt_flat_target_assoc mfta,
           mgmt_targets mt,
           (SELECT * FROM TABLE (CAST(p_tgt_details AS SMP_EMD_NVPAIR_ARRAY))) tgtdet
        WHERE
           mfta.source_target_guid = tgtdet.name AND
           mt.target_guid = mca.target_guid(+) AND
           mt.target_guid = mfta.assoc_target_guid(+) AND
           mfta.is_membership = 1 AND
           mt.target_type NOT IN
           (select distinct name from table(cast(p_tgtypelist as SMP_EMD_NVPAIR_ARRAY)))
        GROUP BY
            mfta.source_target_guid,
            current_status;

    -- Fetching all the required information in bulk for obtaining the counts of policy violation for stand alone targets
    -- instead of processing the same in loop.

    get_tgt_policy_violation_detls
    (
        l_aggregate_guid,
        p_targetguid_array => p_tgt_details
    );

    -- Getting the metric name and metric column for all the metric guids in bulk and using the
    -- information in the loop instead of hitting the same table in loop for every metric guid.
    SELECT
        DISTINCT metric_guid,
        metric_column,
        metric_name
    BULK COLLECT INTO
        p_metricguid_arr,
        p_metriccolumn_arr,
        p_metricname_arr
    FROM
        mgmt_metrics
    WHERE
        metric_guid IN
    (
    SELECT *
        FROM TABLE(CAST(l_metricguid_array AS mgmt_target_guid_array))
    );

    -- Getting the metric values for all the target guid and metric guid combination in bulk and using the
    -- information in the loop instead of hitting the same table in loop for every target guid and metric guid combination.
    SELECT
        SMP_EMD_NVPAIR(target_guid,metric_guid),
        value
    BULK COLLECT INTO
        p_metdet_array,
        p_value_array
    FROM   mgmt_current_metrics
    WHERE metric_guid in
    (
    SELECT *
    FROM TABLE(CAST(l_metricguid_array AS mgmt_target_guid_array))
    ) AND
    target_guid IN
    (SELECT * FROM TABLE (CAST(l_target_guid_array AS MGMT_TARGET_GUID_ARRAY)))
    ;

    SELECT COUNT(source_target_guid),
           guids.column_value target_guid
    BULK COLLECT INTO
           l_count_array,
           l_source_tgt_guid_array
    FROM   mgmt_target_assocs,
           TABLE (CAST(l_target_guid_array AS MGMT_TARGET_GUID_ARRAY)) guids
    WHERE  source_target_guid(+) = guids.column_value
    GROUP BY guids.column_value;

    -- Used different counters for getting the count (length) of the array rather than doing .COUNT in loops.
    IF (p_target_guid_array IS NOT NULL) THEN
        p_target_guid_array_cnt   := p_target_guid_array.COUNT;
    END IF;
    p_tgt_details_cnt         := p_tgt_details.COUNT;
    IF (p_tgt_guid_comp_array IS NOT NULL ) THEN
        p_tgt_guid_comp_array_cnt := p_tgt_guid_comp_array.COUNT;
    END IF;
    p_metricguid_arr_cnt      := p_metricguid_arr.COUNT;
    IF (p_target_guid_comp_array IS NOT NULL) THEN
        p_target_guid_comp_array_cnt := p_target_guid_comp_array.COUNT;
    END IF;

   -- Get all the composite targets within the passed in group / system.

    SELECT  SMP_EMD_TARGET_REC
            (mgmt_flat_target_assoc.assoc_target_guid,
             target_type,
             guids.column_value,
             null)
    BULK COLLECT INTO
            p_member_guid_array
    FROM    mgmt_flat_target_assoc,
            mgmt_targets,
            TABLE (CAST(l_target_guid_array AS MGMT_TARGET_GUID_ARRAY)) guids
    WHERE
            mgmt_flat_target_assoc.source_target_guid = guids.column_value AND
            mgmt_flat_target_assoc.is_membership=1 AND
            mgmt_flat_target_assoc.assoc_target_guid=mgmt_targets.target_guid AND
            mgmt_targets.target_type NOT IN
                (SELECT DISTINCT name
                FROM TABLE(CAST(p_tgtypelist as SMP_EMD_NVPAIR_ARRAY)));
    IF (p_member_guid_array.COUNT > 0 AND p_member_guid_array IS NOT NULL ) THEN

        -- Get the availability of the members of the nested groups.
        SELECT  SUM(DECODE(current_status,1,1,0)),
                guids.metricname
        BULK COLLECT INTO
                sum_cnt_array,
                tgt_array
        FROM    mgmt_current_availability,
                TABLE(CAST(p_member_guid_array AS SMP_EMD_TARGET_REC_ARRAY)) guids
        WHERE   target_guid = guids.targetname(+)
        GROUP BY
                guids.metricname;
        IF (sum_cnt_array IS NOT NULL AND sum_cnt_array.COUNT > 0) THEN
            l_sum_cnt_array_count := sum_cnt_array.COUNT;
        END IF;

        -- Get the sum of critical and warning alerts for the metrics of members within the groups
        SELECT  SUM(DECODE(severity_code,mgmt_global.G_SEVERITY_CRITICAL,1,0)) critical_count,
                SUM (DECODE(severity_code,mgmt_global.G_SEVERITY_WARNING,1,0)) warning_count,
                metrics.column_value,
                guids.metricname
        BULK COLLECT INTO
                p_critical_cnt_array,
                p_warning_cnt_array,
                metricguids_array,
                source_tgt_array
        FROM    mgmt_current_severity,
                TABLE(CAST(l_metricguid_array AS MGMT_TARGET_GUID_ARRAY)) metrics,
                TABLE(CAST(p_member_guid_array AS SMP_EMD_TARGET_REC_ARRAY)) guids
        WHERE   metric_guid(+)=metrics.column_value AND
                target_guid = guids.targetname(+)
        GROUP BY
                metrics.column_value,
                guids.metricname ;
        IF (source_tgt_array IS NOT NULL AND source_tgt_array.COUNT > 0) THEN
            l_source_tgt_array_count := source_tgt_array.COUNT;
        END IF;

        -- Get the threshold status of the members of the nested groups
        SELECT  DISTINCT DECODE(policy_guid,metrics.column_value,TO_NUMBER(1),TO_NUMBER(0)) ,
                metrics.column_value,
                guids.metricname
        BULK COLLECT INTO
                avail_cnt_array,
                metric_guidarray,
                guidarray
        FROM    mgmt_policy_assoc_cfg,
                TABLE(CAST(l_metricguid_array AS MGMT_TARGET_GUID_ARRAY)) metrics,
                TABLE(CAST(p_member_guid_array AS SMP_EMD_TARGET_REC_ARRAY)) guids
        WHERE   policy_guid(+) =metrics.column_value AND 
                object_guid= guids.targetname(+); --AND 
                --object_type = 2 AND 
                --policy_type = 1;
        IF (guidarray IS NOT NULL AND guidarray.COUNT > 0) THEN
            l_guidarray_count := guidarray.COUNT;
        END IF;

        -- Get the applicability of the metric target types for the members of the nested groups
        SELECT  DISTINCT DECODE(guids.targettype,typetab.column_value ,TO_NUMBER(1),TO_NUMBER(0)),
                guids.metricname,guids.targettype
        BULK COLLECT INTO
                count_array,
                tgtid_array,
                p_target_type_arr
        FROM    mgmt_target_memberships,
                TABLE(CAST(p_member_guid_array AS SMP_EMD_TARGET_REC_ARRAY)) guids,
                TABLE(CAST(l_metric_target_type_array AS VARCHAR2_TABLE)) typetab
        WHERE
                member_target_guid(+) = guids.TARGETNAME AND
                guids.TARGETTYPE(+) = typetab.column_value AND
                typetab.column_value IS NOT NULL;
        IF (tgtid_array IS NOT NULL AND tgtid_array.COUNT > 0) THEN
            l_tgtid_array_count := tgtid_array.COUNT;
        END IF;

       -- Get Metric Collections for the members of the targets.
       SELECT  DISTINCT DECODE(metric_guid,metrics.column_value,TO_NUMBER(1),TO_NUMBER(0)) ,
                metrics.column_value,
                guids.metricname
        BULK COLLECT INTO
                colltn_cnt_array,
                metric_idarray,
                trgetguidarray
        FROM    mgmt_current_metric_errors,
                TABLE(CAST(l_metricguid_array AS MGMT_TARGET_GUID_ARRAY)) metrics,
                TABLE(CAST(p_member_guid_array AS SMP_EMD_TARGET_REC_ARRAY)) guids
        WHERE   metric_guid(+) =metrics.column_value AND
                target_guid = guids.targetname(+);
        IF (trgetguidarray IS NOT NULL AND trgetguidarray.COUNT > 0) THEN
            l_trgetguidarray_count := trgetguidarray.COUNT;
        END IF;
    END IF;

    -- Initialize array to store target information
    p_target_details := em_target_array();
    l_target_counter:=0;
    IF (l_target_guid_array IS NOT NULL) AND (l_target_guid_array.count>0) THEN
       FOR i IN 1..l_target_guid_array.count
       LOOP
           has_member_targets := TRUE;
           IF (l_source_tgt_guid_array.COUNT > 0 AND l_source_tgt_guid_array IS NOT NULL) THEN
               FOR isourcecnt in 1..l_source_tgt_guid_array.COUNT
               LOOP
                   IF (l_source_tgt_guid_array(isourcecnt) = l_target_guid_array(i)) THEN
	               IF (l_count_array(isourcecnt) = 0) THEN
                           IF (p_tgt_details_cnt > 0 AND p_tgt_details IS NOT NULL ) THEN
                               FOR itgtcnt in 1..p_tgt_details_cnt
                               LOOP
                                   IF (p_tgt_details(itgtcnt).name = l_target_guid_array(i)) THEN
                                       is_target_aggregate := is_target_type_aggregate
				                              (p_tgt_details(itgtcnt).value,
							       p_tgtypelist,
							       p_tgt_details(itgtcnt).name);
                                       IF (is_target_aggregate = 'TRUE') THEN
                                           has_member_targets := FALSE;
                                           l_target_counter:=l_target_counter+1;
                                           p_target_details.extend;
                                           p_target_details(l_target_counter) := em_target_obj(null,null,null,null,null,null,null,null);
                                           p_target_details(l_target_counter).target_guid:=l_target_guid_array(i);
                                           p_target_details(l_target_counter).target_name:=p_tgt_name_array(itgtcnt);
                                           p_target_details(l_target_counter).target_type:=p_tgt_details(itgtcnt).value;
                                           p_target_details(l_target_counter).status_details := em_status_array();
                                           p_target_details(l_target_counter).is_aggregate := 1;
                                           l_metric_counter:=0;
                                           l_policy_details_counter := 0;
                                           p_target_details(l_target_counter).metric_details := em_metric_array();
                                           p_target_details(l_target_counter).policy_details := em_policy_viol_array();
                                           EXIT;
                                       ELSE
                                           has_member_targets := TRUE;
                                           EXIT;
                                       END IF;
                                   END IF;
                               END LOOP;
                           END IF;
                       END IF;
                   END IF;
               END LOOP;
           END IF;
           IF (has_member_targets = TRUE ) THEN
               -- Get Target Specfic Info
               IF (p_tgt_details_cnt > 0 AND p_tgt_details IS NOT NULL) THEN
                   FOR itgtcnt in 1..p_tgt_details_cnt
                   LOOP
                       IF (p_tgt_details(itgtcnt).name = l_target_guid_array(i)) THEN
                           l_target_counter:=l_target_counter+1;
                           p_target_details.extend;
                           p_target_details(l_target_counter) := em_target_obj(null,null,null,null,null,null,null,null);
                           p_target_details(l_target_counter).target_guid:=l_target_guid_array(i);
                           p_target_details(l_target_counter).target_name:=p_tgt_name_array(itgtcnt);
                           p_target_details(l_target_counter).target_type:=p_tgt_details(itgtcnt).value;
                           -- Status Information for the target Start
                           p_target_details(l_target_counter).status_details := em_status_array();
                           l_status_counter:=0;
                           is_target_aggregate := is_target_type_aggregate
			                            (p_tgt_details(itgtcnt).value,
			                             p_tgtypelist,
						     p_target_details(l_target_counter).target_guid);
                           IF (is_target_aggregate ='FALSE') THEN    -- Stand Alone Target
                               -- Then the is_aggregate flag should be 0.
                               p_target_details(l_target_counter).is_aggregate := 0;
                               l_status_counter:=l_status_counter+1;
                               p_target_details(l_target_counter).status_details.extend;
                               p_target_details(l_target_counter).status_details(l_status_counter) :=
                                            em_status_obj
                                                (
                                                    p_curr_status_array(itgtcnt),
                                                    1
                                                );
                           ELSE -- the target is an aggregate
                               IF (p_tgt_guid_comp_array_cnt > 0 AND p_tgt_guid_comp_array IS NOT NULL) THEN
                                   FOR icnt in 1..p_tgt_guid_comp_array_cnt
                                   LOOP
                                       IF (p_tgt_guid_comp_array(icnt) = p_target_details(l_target_counter).target_guid ) THEN
                                          -- If the target is of an aggregate type, then the is_aggregate flag should be 1
                                           p_target_details(l_target_counter).is_aggregate := 1;
                                           l_status_counter:=l_status_counter+1;
                                           p_target_details(l_target_counter).status_details.extend;
                                           p_target_details(l_target_counter).status_details(l_status_counter) :=
                                                    em_status_obj
                                                        (
                                                            p_tgt_status_comp_array(icnt),
                                                            p_status_count_comp_array(icnt)
                                                        );
                                       END IF;
                                   END LOOP;-- end p_tgt_guid_comp_array_cnt
                               END IF;
                           END IF;
                    -- Status Information for the target Ends
                       END IF;
                   END LOOP;-- end C1
               END IF;
                -- Target Specific Information Complete

        -- Now determine metric statuses (for each summary metric defined at group level)
                IF (l_metricguid_array_cnt > 0 AND l_metricguid_array IS NOT NULL) THEN
                    l_metric_counter:=0; -- Start Metric Eveluation for the target
                    l_policy_details_counter := 0;
                    p_target_details(l_target_counter).metric_details := em_metric_array();
                    p_target_details(l_target_counter).policy_details := em_policy_viol_array();

                    FOR i IN 1..l_metricguid_array_cnt  -- for each and every summary metric defined for the group / aggregate target
                    LOOP
                        -- Process next metric
                        l_metric_counter:=l_metric_counter+1;
                        p_target_details(l_target_counter).metric_details.extend;
                        p_target_details(l_target_counter).metric_details(l_metric_counter) := em_metric_obj(null,null,null,null,null,null,null);
                    -- Tooltip on Metric Abbreviation should look like "Host: CPU Utilization(%)" (metric_name below)
                    -- First Get Metric Name and Metric Column and Metric Name (for URLs)
                    -- For columns containing both the metric data (dynamic) and general data, the metric name and abbr columns are to be populated.
                        p_target_details(l_target_counter).metric_details(l_metric_counter).metric_name:=l_metric_target_type_array(l_metric_counter)||': '||l_metric_label_array(l_metric_counter)||': '||l_metric_label_nlsid_array(l_metric_counter);
                        p_target_details(l_target_counter).metric_details(l_metric_counter).metric_abbreviation:=nvl(l_metric_abbreviation_array(i), substr(p_target_details(l_target_counter).metric_details(l_metric_counter).metric_name,1,64));
                        p_target_details(l_target_counter).metric_details(l_metric_counter).target_property_value := NULL;
                        -- In case of Metric related columns containing dynamic data
                        -- or incase the target is of aggregate type, the metric guid is populated
                        IF (l_metricguid_array(i) IS NOT NULL) THEN
                            IF (p_metricguid_arr_cnt > 0 AND p_metricguid_arr IS NOT NULL) THEN
                                FOR imetcnt in 1..p_metricguid_arr_cnt
                                LOOP
                                    IF (p_metricguid_arr(imetcnt) = l_metricguid_array(i)) THEN
                                        p_target_details(l_target_counter).metric_details(l_metric_counter).metric_column:= p_metriccolumn_arr(imetcnt);
                                        p_target_details(l_target_counter).metric_details(l_metric_counter).metric_involved_name:=p_metricname_arr(imetcnt);
                                        EXIT;
                                    END IF;
                                END LOOP;
                            END IF;
                        ELSE
                        -- In case the columns being selected are of generic or general type,
                        -- (the values will be usually static, ex: port number, host name, db SID etc), the metric guid column will be null
                        -- We do not have to pass the metric column and involved name
                            p_target_details(l_target_counter).metric_details(l_metric_counter).metric_column := NULL;
                            p_target_details(l_target_counter).metric_details(l_metric_counter).metric_involved_name := NULL;
                        END IF;
                        -- Now Get The Status of the Metric
                        -- Possible Values of Metric Status
                        -- Not Applicable (the target may be a database, but the summary metric column could be defined for another member, an host)
                        -- If applicable (OK, Warning, Critical, Unknown, Metric Collection Error, No Metric Threshold Set)
                        is_target_aggregate := is_target_type_aggregate
			                        (p_target_details(l_target_counter).target_type,
						 p_tgtypelist,
						 p_target_details(l_target_counter).target_guid);
                        IF (is_target_aggregate ='TRUE') THEN
                        -- Target is of an Aggregate type
                            IF (l_metricguid_array(i) IS NOT NULL) THEN
                            -- In case of Metric related columns containing dynamic data, the metric guid is populated
                                p_target_details(l_target_counter).metric_details(l_metric_counter).metric_status:=
                                    get_rollup_metric_status
                                        (
                                            p_group_guid =>p_target_details(l_target_counter).target_guid,
                                            p_metric_guid =>l_metricguid_array(i),
                                            p_metric_target_type=>l_metric_target_type_array(i)
                                        );
                            ELSE
                            -- target is of aggregate type.
                            -- check if the column "Policy Violations" has been selected to be displayed on the dashboard.
                                IF (l_metric_prop_name_array(l_metric_counter) in
                                   (emd_pref.MGMT_USER_PREF_POL_VIOL_COL) ) THEN
                                   IF (p_policy_arr.COUNT != 0 AND p_policy_arr IS NOT NULL)
                                   THEN
                                       FOR itgtcnt IN 1..p_policy_arr.count
                                       LOOP
                                           p_plcy_information_count := null;
                                           p_plcy_warning_count := null;
                                           p_plcy_critical_count := null;
                                           p_compliance_score := null;
                                           IF (p_target_details(l_target_counter).target_guid = p_policy_arr(itgtcnt).target_guid)
                                           THEN
                                               p_plcy_information_count :=  p_policy_arr(itgtcnt).p_information_cnt;
                                               p_plcy_warning_count := p_policy_arr(itgtcnt).p_warning_cnt;
                                               p_plcy_critical_count := p_policy_arr(itgtcnt).p_critical_cnt;
                                               p_compliance_score :=  p_policy_arr(itgtcnt).p_compliance_scre;
                                               EXIT;
                                           END IF;
                                       END LOOP;
                                   END IF;
                            -- Since we get all the three counts (informational, critcal and warning counts of polic violations in a single query), set the policy details object
                            -- to contain these counts.
                                   l_policy_details_counter:=l_policy_details_counter+1;
                                   p_target_details(l_target_counter).policy_details.extend;
                                   p_target_details(l_target_counter).policy_details(l_policy_details_counter) :=
                                            em_policy_viol_obj
                                            (
                                                em_system_dashboard.get_severity_description(MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL),
                                                p_plcy_information_count
                                            );
                                   l_policy_details_counter:=l_policy_details_counter+1;
                                   p_target_details(l_target_counter).policy_details.extend;
                                   p_target_details(l_target_counter).policy_details(l_policy_details_counter) :=
                                            em_policy_viol_obj
                                            (
                                                em_system_dashboard.get_severity_description(MGMT_GLOBAL.G_SEVERITY_WARNING),
                                                p_plcy_warning_count
                                            );
                                   l_policy_details_counter:=l_policy_details_counter+1;
                                   p_target_details(l_target_counter).policy_details.extend;
                                   p_target_details(l_target_counter).policy_details(l_policy_details_counter) :=
                                            em_policy_viol_obj
                                            (
                                                em_system_dashboard.get_severity_description(MGMT_GLOBAL.G_SEVERITY_CRITICAL),
                                                p_plcy_critical_count
                                            );
                                END IF;
                                -- In case of aggregate targets, the values of generic / general columns are not applicable.
                                p_target_details(l_target_counter).metric_details(l_metric_counter).metric_column := NULL;
                                p_target_details(l_target_counter).metric_details(l_metric_counter).metric_involved_name := NULL;
                                p_target_details(l_target_counter).metric_details(l_metric_counter).target_property_value := '-';
                            END IF;
                        ELSE
                        -- Target is not of an Aggregate type, this is a Stand Alone Target
                            IF (l_metricguid_array(i) IS NULL) THEN
                                -- The column values of generic / general columns are retrieved in target_property_value attribute of em_metric_obj object.
                                IF (l_metric_prop_name_array(l_metric_counter) in
                                   (emd_pref.MGMT_USER_PREF_POL_VIOL_COL, emd_pref.MGMT_USER_PREF_POL_COMP_COLUMN) ) THEN
                                -- Check if the policy violations / compliance score columns have been selected.
                                     IF (p_policy_arr.count != 0 AND p_policy_arr IS NOT NULL)
                                     THEN
                                         FOR itgtcnt IN 1..p_policy_arr.count
                                         LOOP
                                             p_plcy_information_count := null;
                                             p_plcy_warning_count := null;
                                             p_plcy_critical_count := null;
                                             p_compliance_score := null;
                                             IF ((p_target_details(l_target_counter).target_guid = p_policy_arr(itgtcnt).target_guid)
					                            AND (p_target_details(l_target_counter).status_details(l_status_counter).status_type = mgmt_global.G_STATUS_UP))
                                             THEN
                                                 p_plcy_information_count :=  p_policy_arr(itgtcnt).p_information_cnt;
                                                 p_plcy_warning_count := p_policy_arr(itgtcnt).p_warning_cnt;
                                                 p_plcy_critical_count := p_policy_arr(itgtcnt).p_critical_cnt;
                                                 p_compliance_score :=  p_policy_arr(itgtcnt).p_compliance_scre;
                                                 EXIT;
                                             END IF;
                                         END LOOP;
                                     END IF;
                              -- Since we get all the three counts (informational, critcal and warning counts of polic violations in a single query), set the policy details object
                              -- to contain these counts.
                                     l_policy_details_counter:=l_policy_details_counter+1;
                                     p_target_details(l_target_counter).policy_details.extend;
                                     p_target_details(l_target_counter).policy_details(l_policy_details_counter) :=
                                            em_policy_viol_obj
                                            (
                                                em_system_dashboard.get_severity_description(MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL),
                                                p_plcy_information_count
                                            );
                                     l_policy_details_counter:=l_policy_details_counter+1;
                                     p_target_details(l_target_counter).policy_details.extend;
                                     p_target_details(l_target_counter).policy_details(l_policy_details_counter) :=
                                            em_policy_viol_obj
                                            (
                                                em_system_dashboard.get_severity_description(MGMT_GLOBAL.G_SEVERITY_WARNING),
                                                p_plcy_warning_count
                                            );
                                     l_policy_details_counter:=l_policy_details_counter+1;
                                     p_target_details(l_target_counter).policy_details.extend;
                                     p_target_details(l_target_counter).policy_details(l_policy_details_counter) :=
                                            em_policy_viol_obj
                                            (
                                                em_system_dashboard.get_severity_description(MGMT_GLOBAL.G_SEVERITY_CRITICAL),
                                                p_plcy_critical_count
                                            );

                            -- Initialize the policy details array to store the compliance score value.
                                     l_policy_details_counter:=l_policy_details_counter+1;
                                     p_target_details(l_target_counter).policy_details.extend;
                                     p_target_details(l_target_counter).policy_details(l_policy_details_counter) :=
                                            em_policy_viol_obj
                                            (
                                                'ComplianceScore',
                                                p_compliance_score
                                            );
                                END IF;
                                    p_target_details(l_target_counter).metric_details(l_metric_counter).target_property_value :=
                                    get_target_properties
                                        (
                                            p_target_guid => p_target_details(l_target_counter).target_guid,
                                            p_property_name =>l_metric_prop_name_array(l_metric_counter)
                                        );
                            ELSE
                            -- If Target is NOT UP, Metric Status is UNKNOWN
                                IF (l_metric_target_type_array(i)<>p_target_details(l_target_counter).target_type) THEN
                                    p_target_details(l_target_counter).metric_details(l_metric_counter).metric_status:='Not Applicable';

                                -- Target Type to which the Metric is applicable and the Target Type of the Cyrrent Target do not match
                                -- Return 'Not Applicable'
                                ELSIF  (p_target_details(l_target_counter).status_details(l_status_counter).status_type!=mgmt_global.G_STATUS_UP) THEN
                                    p_target_details(l_target_counter).metric_details(l_metric_counter).metric_status:='Unknown';
                                -- get status of applicable metric
                                ELSE
                                    IF (l_metricguid_array(i) IS NOT NULL) THEN
                                        p_target_details(l_target_counter).metric_details(l_metric_counter).metric_status:=
                                            get_metric_status
                                                (
                                                    p_target_guid =>p_target_details(l_target_counter).target_guid,
                                                    p_metric_guid =>l_metricguid_array(i)
                                                );
                                    END IF;
                                END IF;
                            END IF;
                        END IF;
            -- Metric Status Calculation Complete

        -- Now get Metric Value
                        is_target_aggregate := is_target_type_aggregate
			                        (p_target_details(l_target_counter).target_type,
						 p_tgtypelist,
						 p_target_details(l_target_counter).target_guid);
                        IF (is_target_aggregate ='FALSE') THEN
                            -- Stand Alone Target
                            IF (l_metricguid_array(i) IS NOT NULL) THEN
                                IF (p_target_details(l_target_counter).metric_details(l_metric_counter).metric_status!='Unknown')
                                AND (p_target_details(l_target_counter).metric_details(l_metric_counter).metric_status!='Not Applicable') THEN
                                    l_metric_value :=NULL;
                                    IF (p_metdet_array.COUNT > 0 AND p_metdet_array IS NOT NULL) THEN
                                        FOR imetcnt IN 1..p_metdet_array.COUNT
                                        LOOP
                                            IF (p_metdet_array(imetcnt).name = p_target_details(l_target_counter).target_guid AND
                                                p_metdet_array(imetcnt).value = l_metricguid_array(i))
                                            THEN
                                                l_metric_value:=p_value_array(imetcnt);
                                                EXIT;
                                            END IF;
                                        END LOOP;
                                    END IF;
                                    p_target_details(l_target_counter).metric_details(l_metric_counter).metric_value:=nvl(l_metric_value,0);
                                ELSE
                                    p_target_details(l_target_counter).metric_details(l_metric_counter).metric_value:=NULL;
                                END IF;
                            ELSE
                                p_target_details(l_target_counter).metric_details(l_metric_counter).metric_column := NULL;
                                p_target_details(l_target_counter).metric_details(l_metric_counter).metric_involved_name := NULL;
                                p_target_details(l_target_counter).metric_details(l_metric_counter).metric_value:=NULL;
                            END IF;
                        END IF;
                        -- END Metric Value Calculation
                    END LOOP;-- END i, finished processing metric info
                END IF;  -- if (metricguid_array.count>0) ends
                    -- Metric Related Information Complete
               -- Now process Alert Info for the Target
               -- Return, alert_type=warning, alert_count
               --         alert_type=critical, alert_count
               --         status = down, status_count
               p_target_details(l_target_counter).alert_details := em_alert_array();
               l_alert_counter:=0;
               is_target_aggregate := is_target_type_aggregate
	                              (p_target_details(l_target_counter).target_type,
				       p_tgtypelist,
				       p_target_details(l_target_counter).target_guid);
               IF (is_target_aggregate ='FALSE') THEN
                   -- Standalone Target
                   -- This query will provide the alert state (critical / warning) and the availability (down / up)
                   -- for the standalone targets within the aggregate target.
                   IF (p_target_guid_array_cnt > 0 AND p_target_guid_array IS NOT NULL) THEN
                        icnt := 1;
                        LOOP
                            IF (icnt > p_target_guid_array_cnt) THEN
                                EXIT;
                            END IF;
                            IF (p_target_details(l_target_counter).target_guid = p_target_guid_array(icnt)) THEN
                                l_alert_counter:=l_alert_counter+1;
                                p_target_details(l_target_counter).alert_details.extend;
                                p_target_details(l_target_counter).alert_details(l_alert_counter) :=
                                                                    em_alert_obj
                                                                    (
                                                                        null,
                                                                        p_count_severity_array(icnt),
                                                                        p_severity_code_array(icnt),
                                                                        p_severity_type_array(icnt),
                                                                        p_current_status_array(icnt),
                                                                        p_target_guid_array(icnt)
                                                                    );
                            END IF;
                            icnt := icnt + 1;
                        END LOOP;
                   END IF;
               ELSE  -- the Current Target is of an aggregate type
                    -- This query will return all the states and alerts of the member targets beloning to the
                    -- aggregate target type.
                    -- If a member target is down, then the severity code is shown as "DOWN"
                    -- else, it will show the alert state (either critical / warning )
                   IF ( p_target_guid_comp_array_cnt > 0 AND p_target_guid_comp_array IS NOT NULL) THEN
                       icnt := 1;
                       LOOP
                           IF (icnt > p_target_guid_comp_array_cnt) THEN
                               EXIT;
                           END IF;
                           IF (p_target_details(l_target_counter).target_guid = p_target_guid_comp_array(icnt)) THEN
                                l_alert_counter:=l_alert_counter+1;
                                p_target_details(l_target_counter).alert_details.extend;
                                p_target_details(l_target_counter).alert_details(l_alert_counter) :=
                                                                    em_alert_obj
                                                                    (
                                                                        null,
                                                                        p_count_severity_comp_array(icnt),
                                                                        p_severity_code_comp_array(icnt),
                                                                        p_severity_type_comp_array(icnt),
                                                                        p_current_status_comp_array(icnt),
                                                                        p_target_guid_comp_array(icnt)
                                                                    );
                           END IF;
                           icnt := icnt + 1;
                       END LOOP;
                   END IF;
               END IF; --(c1.target_type not belongs to aggregate type
           END IF;
       END LOOP;  --for i in 1..l_target_guid_array.count
       -- Go to Next Target
    END IF;  -- IF (l_target_guid_array.count>0)
    IF (p_member_guid_array  IS NOT NULL and p_member_guid_array.COUNT > 0) THEN
        p_member_guid_array.DELETE;
        IF (sum_cnt_array  IS NOT NULL) THEN
            sum_cnt_array.DELETE;
        END IF;
        IF (tgt_array IS NOT NULL) THEN
            tgt_array.DELETE;
        END IF;
        IF (p_critical_cnt_array IS NOT NULL) THEN
            p_critical_cnt_array.DELETE;
        END IF;
        IF (p_warning_cnt_array IS NOT NULL) THEN
            p_warning_cnt_array.DELETE;
        END IF;
        IF (metricguids_array IS NOT NULL) THEN
            metricguids_array.DELETE;
        END IF;
        IF (source_tgt_array IS NOT NULL) THEN
            source_tgt_array.DELETE;
        END IF;
        IF (avail_cnt_array IS NOT NULL) THEN
            avail_cnt_array.DELETE;
        END IF;
        IF (metric_guidarray IS NOT NULL) THEN
            metric_guidarray.DELETE;
        END IF;
        IF (guidarray IS NOT NULL) THEN
            guidarray.DELETE;
        END IF;
        IF (count_array IS NOT NULL) THEN
            count_array.DELETE;
        END IF;
        IF (p_target_type_arr IS NOT NULL) THEN
            p_target_type_arr.DELETE;
        END IF;
        IF (tgtid_array IS NOT NULL) THEN
            tgtid_array.DELETE;
        END IF;
        IF (colltn_cnt_array IS NOT NULL) THEN
            colltn_cnt_array.DELETE;
        END IF;
        IF (metric_idarray IS NOT NULL) THEN
            metric_idarray.DELETE;
        END IF;
        IF (trgetguidarray IS NOT NULL) THEN
            trgetguidarray.DELETE;
        END IF;
    END IF;
    IF (p_policy_arr IS NOT NULL) THEN
        p_policy_arr.DELETE;
    END IF;
    IF (l_metric_abbreviation_array IS NOT NULL) THEN
        l_metric_abbreviation_array.DELETE;
    END IF;
    IF (l_tgt_type_metric_abbrev_array IS NOT NULL) THEN
        l_tgt_type_metric_abbrev_array.DELETE;
    END IF;
    IF (l_metric_target_type_array IS NOT NULL) THEN
    l_metric_target_type_array.DELETE;
    END IF;
    IF (l_metric_label_array IS NOT NULL) THEN
        l_metric_label_array.DELETE;
    END IF;
    IF (l_metric_label_nlsid_array IS NOT NULL) THEN
    l_metric_label_nlsid_array.DELETE;
    END IF;
    IF (l_metric_prop_name_array IS NOT NULL) THEN
        l_metric_prop_name_array.DELETE;
    END IF;
    IF (l_target_guid_array IS NOT NULL) THEN
        l_target_guid_array.DELETE;
    END IF;
    IF (l_metricguid_array IS NOT NULL) THEN
        l_metricguid_array.DELETE;
    END IF;
    IF (p_metricguid_arr IS NOT NULL) THEN
        p_metricguid_arr.DELETE;
    END IF;
    IF (l_targettype_metricguid_array IS NOT NULL) THEN
        l_targettype_metricguid_array.DELETE;
    END IF;
    IF (p_metriccolumn_arr IS NOT NULL) THEN
        p_metriccolumn_arr.DELETE;
    END IF;
    IF (p_metricname_arr IS NOT NULL) THEN
        p_metricname_arr.DELETE;
    END IF;
    IF (l_metric_property_name_array IS NOT NULL) THEN
        l_metric_property_name_array.DELETE;
    END IF;
    IF (l_column_label_array IS NOT NULL) THEN
        l_column_label_array.DELETE;
    END IF;
    IF (l_column_label_nlsid_array IS NOT NULL) THEN
        l_column_label_nlsid_array.DELETE;
    END IF;
    IF (l_target_type_array IS NOT NULL) THEN
        l_target_type_array.DELETE;
    END IF;
    IF (l_display_order_array IS NOT NULL) THEN
        l_display_order_array.DELETE;
    END IF;
    IF (l_column_type_array IS NOT NULL) THEN
        l_column_type_array.DELETE;
    END IF;
    IF (p_severity_code_array IS NOT NULL) THEN
        p_severity_code_array.DELETE;
    END IF;
    IF (p_severity_code_comp_array IS NOT NULL) THEN
        p_severity_code_comp_array.DELETE;
    END IF;
    IF (p_severity_type_array IS NOT NULL) THEN
        p_severity_type_array.DELETE;
    END IF;
    IF (p_severity_type_comp_array IS NOT NULL) THEN
        p_severity_type_comp_array.DELETE;
    END IF;
    IF (p_current_status_array IS NOT NULL) THEN
        p_current_status_array.DELETE;
    END IF;
    IF (p_current_status_comp_array IS NOT NULL) THEN
        p_current_status_comp_array.DELETE;
    END IF;
    IF (p_tgt_status_comp_array IS NOT NULL) THEN
        p_tgt_status_comp_array.DELETE;
    END IF;
    IF (p_curr_status_array IS NOT NULL) THEN
        p_curr_status_array.DELETE;
    END IF;
    IF (p_target_guid_array IS NOT NULL) THEN
        p_target_guid_array.DELETE;
    END IF;
    IF (p_target_guid_comp_array IS NOT NULL) THEN
        p_target_guid_comp_array.DELETE;
    END IF;
    IF (p_tgt_guid_comp_array IS NOT NULL) THEN
        p_tgt_guid_comp_array.DELETE;
    END IF;
    IF (p_tgt_name_array IS NOT NULL) THEN
        p_tgt_name_array.DELETE;
    END IF;
    IF (p_count_severity_array IS NOT NULL) THEN
        p_count_severity_array.DELETE;
    END IF;
    IF (p_count_severity_comp_array IS NOT NULL) THEN
        p_count_severity_comp_array.DELETE;
    END IF;
    IF (p_status_count_comp_array IS NOT NULL) THEN
        p_status_count_comp_array.DELETE;
    END IF;
    IF (p_value_array IS NOT NULL) THEN
        p_value_array.DELETE;
    END IF;
    IF (p_tgt_details IS NOT NULL) THEN
        p_tgt_details.DELETE;
    END IF;
    IF (p_metdet_array IS NOT NULL) THEN
        p_metdet_array.DELETE;
    END IF;
    IF (p_tgtypelist IS NOT NULL) THEN
        p_tgtypelist.DELETE;
    END IF;
    IF (l_count_array IS NOT NULL) THEN
        l_count_array.DELETE;
    END IF;
    IF (l_source_tgt_guid_array IS NOT NULL) THEN
        l_source_tgt_guid_array.DELETE;
    END IF;

END get_target_info_full;

-- Purpose : To Drive the Target Section of the System Dashboard in "ROLLUP" view
-- Input Parameters
-- p_aggregate_target_type : Name of the aggregate type, which is having the value in the property_name as "is_system" and "is_group"
-- p_aggregate_name : Name of the target belonging to an aggregate target type, for which the Dashboard is Painted
-- Out Parameters
-- EM_TARGETTYPE_ARRAY : encompasses Target Type Name, Status, Alert and Metric Information
PROCEDURE get_target_info_rollup
(
    p_aggregate_name        IN  VARCHAR2,
    p_aggregate_target_type IN  VARCHAR2,
    p_target_type_details   OUT NOCOPY EM_TARGETTYPE_ARRAY
)
IS
    TYPE current_status_tab IS TABLE OF mgmt_current_availability.current_status%type;
    TYPE target_type_tab IS TABLE OF mgmt_targets.target_type%type;
    TYPE severity_code_table IS TABLE OF mgmt_current_severity.severity_code%type;
    TYPE severity_type_table IS TABLE OF mgmt_current_severity.severity_type%type;
    l_target_type_counter           NUMBER;
    l_status_counter                NUMBER;
    l_alert_counter                 NUMBER;
    l_count                         NUMBER;
    l_aggregate_guid                mgmt_targets.target_guid%TYPE;
    is_target_aggregate             VARCHAR2(10) DEFAULT NULL;
    p_tgtypelist                    SMP_EMD_NVPAIR_ARRAY := SMP_EMD_NVPAIR_ARRAY();
    p_target_details_array          SMP_EMD_NVPAIR_ARRAY := SMP_EMD_NVPAIR_ARRAY();
    p_target_type_arr1              VARCHAR2_TABLE := VARCHAR2_TABLE();
    p_status_count_array            NUMBER_TABLE := NUMBER_TABLE();
    p_cur_status_array              current_status_tab;
    p_tgt_typ_array                 target_type_tab;
    p_target_details_array_count    PLS_INTEGER := 0;
    p_tgt_typ_array_count           PLS_INTEGER := 0;
    p_target_type_arr_count         PLS_INTEGER := 0;
    p_severity_code_array           severity_code_table;
    p_current_status_array          current_status_tab;
    p_count_severity_array          NUMBER_TABLE := NUMBER_TABLE();
    p_severity_type_array           severity_type_table;
    p_ttype_array                   target_type_tab;
    p_ttype_array_count             PLS_INTEGER := 0;
BEGIN
    -- Get all the applicable target types.
    p_tgtypelist := get_composite_target_types;

    -- The system currently supports all the target types which are returned by the procedure get_composite_target_types.
    is_target_aggregate := is_target_type_aggregate(p_aggregate_target_type,p_tgtypelist);
    IF (is_target_aggregate ='TRUE') THEN
    -- Get GUID of the supplied target target.
        FOR c1 IN
        (
            SELECT
                target_guid aggregate_guid
            FROM
                mgmt_targets
            WHERE
                target_name=p_aggregate_name AND
                target_type = p_aggregate_target_type
        )
        LOOP
            l_aggregate_guid:=c1.aggregate_guid;
        END LOOP;
    ELSE
        RETURN;
    END IF;
    IF (l_aggregate_guid IS NULL) THEN  -- Aggregate target Does Not Exist
        RETURN;
    END IF;

    p_target_type_arr := VARCHAR2_TABLE();

    /* Get all the target types present in the supplied group*/
    SELECT  mgmt_targets.target_type target_type
    BULK COLLECT INTO p_target_type_arr
    FROM    mgmt_flat_target_assoc, mgmt_targets
    WHERE   mgmt_flat_target_assoc.source_target_guid = l_aggregate_guid AND
            mgmt_flat_target_assoc.is_membership=1 AND
            mgmt_flat_target_assoc.assoc_target_guid=mgmt_targets.target_guid AND
            mgmt_targets.target_type NOT IN
                (select distinct name from table(cast(p_tgtypelist as SMP_EMD_NVPAIR_ARRAY)))
    ORDER BY target_type;

    /* Select the distinct target types from the above array and populate another array */
    SELECT DISTINCT column_value
    BULK COLLECT INTO p_target_type_arr1
    FROM TABLE(CAST(p_target_type_arr AS VARCHAR2_TABLE));

    p_target_type_arr := p_target_type_arr1;

    IF (p_target_type_arr.COUNT > 0 AND p_target_type_arr IS NOT NULL) THEN
        p_target_type_arr_count := p_target_type_arr.COUNT;
    END IF;

    /* Get all the assoc targets and their corresponding target types */
    SELECT  SMP_EMD_NVPAIR(mgmt_flat_target_assoc.assoc_target_guid,
                           mgmt_targets.target_type)
    BULK COLLECT INTO p_target_details_array
    FROM   mgmt_flat_target_assoc,
           mgmt_targets
    WHERE  mgmt_flat_target_assoc.source_target_guid = l_aggregate_guid AND
           mgmt_flat_target_assoc.is_membership=1 AND
           mgmt_flat_target_assoc.assoc_target_guid=mgmt_targets.target_guid AND
           mgmt_targets.target_type IN
           (SELECT column_value
            FROM TABLE(CAST(p_target_type_arr AS VARCHAR2_TABLE)));

    IF (p_target_details_array.COUNT > 0 AND p_target_details_array IS NOT NULL) THEN
        p_target_details_array_count := p_target_details_array.COUNT;
	   END IF;

    /* Get the availability and the target types of all the targets within the group */
    SELECT  current_status,
            target_type_tab.value target_type,
            count(*) status_count
    BULK COLLECT INTO
            p_cur_status_array,
            p_tgt_typ_array,
            p_status_count_array
    FROM    mgmt_current_availability,
            TABLE(CAST(p_target_details_array AS SMP_EMD_NVPAIR_ARRAY)) target_type_tab
    WHERE   target_guid = target_type_tab.name
    GROUP BY target_type_tab.value,
             current_status;

    IF (p_tgt_typ_array.COUNT > 0 AND p_tgt_typ_array IS NOT NULL) THEN
        p_tgt_typ_array_count := p_tgt_typ_array.COUNT;
    END IF;

    /* Get the severity and the target types of all the targets within the group */
    SELECT  severity_code,
            current_status,
            count(*) count_severity,
            severity_type,
            target_type_tab.value target_type
    BULK COLLECT INTO
            p_severity_code_array,
            p_current_status_array,
            p_count_severity_array,
            p_severity_type_array,
            p_ttype_array
    FROM    mgmt_current_severity,
            mgmt_current_availability,
            mgmt_targets,
            TABLE(CAST(p_target_details_array AS SMP_EMD_NVPAIR_ARRAY)) target_type_tab
    WHERE   mgmt_targets.target_guid = mgmt_current_availability.target_guid AND
            mgmt_targets.target_guid = mgmt_current_severity.target_guid(+) AND
            mgmt_current_availability.target_guid = target_type_tab.name
    GROUP BY  target_type_tab.value,
              severity_code,
              current_status,
              severity_type;

    IF (p_ttype_array.COUNT > 0 AND p_ttype_array IS NOT NULL) THEN
        p_ttype_array_count := p_ttype_array.COUNT;
    END IF;

    l_target_type_counter:=0;
    p_target_type_details := em_targettype_array();
    -- First Get the RollupTarget Types contained in this group
    -- Need to access the Flat Target List, contained in this group
    -- The associated member targets should not contain targets of aggregate target types.
    IF (p_target_type_arr_count > 0 AND p_target_type_arr IS NOT NULL)
    THEN
        FOR itgttypecnt IN 1..p_target_type_arr_count
        LOOP
            l_target_type_counter:=l_target_type_counter+1;
            p_target_type_details.extend;
            p_target_type_details(l_target_type_counter) := em_targettype_obj(null,null,null);
            p_target_type_details(l_target_type_counter).target_type_name:=p_target_type_arr(itgttypecnt);
            -- Now get the Status Information for each Target Type
            -- Need to access all Flat Targets in "p_aggregate_name", that belong to current Target Type in Cursor
            l_status_counter:=0;
            p_target_type_details(l_target_type_counter).status_details := em_status_array();
            IF (p_tgt_typ_array_count > 0 AND p_tgt_typ_array IS NOT NULL)
            THEN
                FOR istatscnt IN 1..p_tgt_typ_array_count
                LOOP
                    IF (p_target_type_arr(itgttypecnt) = p_tgt_typ_array(istatscnt))
                    THEN
                        l_status_counter:=l_status_counter+1;
                        p_target_type_details(l_target_type_counter).status_details.extend;
                        p_target_type_details(l_target_type_counter).status_details(l_status_counter) :=
                                    em_status_obj(
                                                    p_cur_status_array(istatscnt),
                                                    p_status_count_array(istatscnt)
                                                  );
                    END IF;

                    --p_target_type_details(l_target_type_counter).status_details(l_status_counter).status_type:=c2.current_status;
                    --p_target_type_details(l_target_type_counter).status_details(l_status_counter).status_count:=c2.status_count;
                END LOOP;
            END IF;
            -- Status Information for Target Current Type Ends

            -- Now process Alert Info for the Target
            -- Return, alert_type=warning,  alert_count
            --         alert_type=critical, alert_count
            --         Target Down, target_count
            p_target_type_details(l_target_type_counter).alert_details := em_alert_array();
            l_alert_counter:=0;
            -- This query provides the alert state and the Down status (if applicable)
            -- for all the target members of the aggregate for which the dashboard is launched.
            IF (p_ttype_array_count > 0 AND p_ttype_array IS NOT NULL)
            THEN
                FOR ialert_count IN 1..p_ttype_array_count
                LOOP
                    IF (p_ttype_array(ialert_count) = p_target_type_arr(itgttypecnt))
                    THEN
                        l_alert_counter:=l_alert_counter+1;
                        p_target_type_details(l_target_type_counter).alert_details.extend;
                        p_target_type_details(l_target_type_counter).alert_details(l_alert_counter) := em_alert_obj(null,null,null,null,null,null);
                        IF (p_current_status_array(ialert_count) IN (MGMT_GLOBAL.G_STATUS_UP,MGMT_GLOBAL.G_STATUS_DOWN)) THEN
                            IF (p_severity_type_array(ialert_count) IS NOT NULL) THEN
                                IF ( (p_current_status_array(ialert_count) = MGMT_GLOBAL.G_STATUS_DOWN) AND (p_severity_code_array(ialert_count) = MGMT_GLOBAL.G_SEVERITY_CRITICAL)
                                      AND p_severity_type_array(ialert_count) = 1)THEN
                                    p_target_type_details(l_target_type_counter).alert_details(l_alert_counter).alert_type:=em_system_dashboard.get_availability_status_desc(p_current_status_array(ialert_count));
                                ELSIF (p_current_status_array(ialert_count) != MGMT_GLOBAL.G_STATUS_DOWN) THEN
                                    p_target_type_details(l_target_type_counter).alert_details(l_alert_counter).alert_type:=em_system_dashboard.get_severity_description(p_severity_code_array(ialert_count));
                                END IF;
                                p_target_type_details(l_target_type_counter).alert_details(l_alert_counter).alert_count:=p_count_severity_array(ialert_count);
                            ELSIF (p_severity_type_array(ialert_count) IS NULL) THEN
                                p_target_type_details(l_target_type_counter).alert_details(l_alert_counter).alert_count:=1;
                                p_target_type_details(l_target_type_counter).alert_details(l_alert_counter).alert_type:=em_system_dashboard.get_severity_description(MGMT_GLOBAL.G_SEVERITY_CLEAR);
                            END IF;
                        ELSE
                            p_target_type_details(l_target_type_counter).alert_details(l_alert_counter).alert_type:=em_system_dashboard.get_severity_description(MGMT_GLOBAL.G_SEVERITY_UNKNOWN);
                            p_target_type_details(l_target_type_counter).alert_details(l_alert_counter).alert_count:=1;
                        END IF;
                     END IF;
                END LOOP;
            --END processing Alert Info for Target Type
           END IF;
        END LOOP;
    END IF;
    IF (p_target_type_arr IS NOT NULL) THEN
        p_target_type_arr.DELETE;
    END IF;
    IF (p_target_details_array IS NOT NULL) THEN
        p_target_details_array.DELETE;
    END IF;
    IF (p_target_type_arr1 IS NOT NULL) THEN
        p_target_type_arr1.DELETE;
    END IF;
    IF (p_status_count_array IS NOT NULL) THEN
        p_status_count_array.DELETE;
    END IF;
    IF (p_cur_status_array IS NOT NULL) THEN
        p_cur_status_array.DELETE;
    END IF;
    IF (p_tgt_typ_array IS NOT NULL) THEN
        p_tgt_typ_array.DELETE;
    END IF;
    IF (p_severity_code_array IS NOT NULL) THEN
        p_severity_code_array.DELETE;
    END IF;
    IF (p_current_status_array IS NOT NULL) THEN
        p_current_status_array.DELETE;
    END IF;
    IF (p_count_severity_array IS NOT NULL) THEN
        p_count_severity_array.DELETE;
    END IF;
    IF (p_severity_type_array IS NOT NULL) THEN
        p_severity_type_array.DELETE;
    END IF;
    IF (p_ttype_array IS NOT NULL) THEN
        p_ttype_array.DELETE;
    END IF;
END get_target_info_rollup;

--This procedure is being used by Services dashboard
--Please contact Services dashboard team for concerns
--if any
PROCEDURE GET_SYSTEM_DETAILS
(
    p_service_name  IN VARCHAR2,
    p_target_type   IN VARCHAR2,
    p_system_details OUT em_system_obj
)
IS
    l_service_guid  mgmt_targets.target_guid%type DEFAULT NULL;
    l_status_counter NUMBER;


BEGIN
    -- First get the GUID of the Service you are working
    FOR c1 IN
    (
        SELECT
            target_guid service_guid
        FROM
            mgmt_targets
        WHERE
            target_name=p_service_name AND
            target_type=p_target_type
    )
    LOOP
        l_service_guid := c1.service_guid;
    END LOOP;


    IF (l_service_guid IS NULL) THEN
        RETURN;
    ELSE
        p_system_details := em_system_obj(NULL, NULL, NULL, NULL);
        l_status_counter:=0;
    END IF;

    -- Get Info about System associated with this Service
    FOR c1 IN
    (

        SELECT
            target_guid system_guid,
            target_name system_name,
            target_type system_type
        FROM
             mgmt_targets
        WHERE
            target_guid IN
                (
                    SELECT assoc_target_guid
                    FROM mgmt_target_assocs
                    WHERE source_target_guid=l_service_guid
                    AND assoc_guid IN
                        (
                          SELECT assoc_guid
                          FROM mgmt_target_assoc_defs
                          WHERE assoc_def_name = mgmt_assoc.ASSOC_DEF_RUNS_ON
                        )
                )

    )
    LOOP
        p_system_details.system_guid:=c1.system_guid;
        p_system_details.system_name:=c1.system_name;
        p_system_details.system_type:=c1.system_type;
    END LOOP;
    IF (p_system_details.system_guid IS NULL) THEN
       RETURN;
    ELSE
        p_system_details.status_details := em_status_array();
    END IF;
    -- Get Availability Status Info for "Stand Alone" Targets this System Contains
    -- If System Contains a Sub System, you cannot determine the availability of this Sub System
    -- Obtain Availability of Flat Targets Instead
    FOR c2 IN
    (
        SELECT
            current_status,
            count(*) status_count
        FROM
             mgmt_current_availability
        WHERE
            target_guid IN
                (
                    SELECT
                        mgmt_flat_target_assoc.assoc_target_guid
                    FROM
                        mgmt_flat_target_assoc, mgmt_targets
                    WHERE
                        mgmt_flat_target_assoc.source_target_guid = p_system_details.system_guid AND
                        mgmt_flat_target_assoc.is_membership=1 AND
                        mgmt_flat_target_assoc.assoc_target_guid=mgmt_targets.target_guid AND
                        mgmt_targets.target_type != MGMT_GLOBAL.G_GENERIC_SYSTEM_TYPE
                )
        GROUP BY current_status
    )
    LOOP
        l_status_counter:=l_status_counter+1;
        p_system_details.status_details.extend;
        p_system_details.status_details(l_status_counter) := em_status_obj(null,null);

        --p_target_details(l_target_counter).status_details(l_status_counter).status_type:=get_availability_status_desc(p_current_status=>c2.current_status);
        p_system_details.status_details(l_status_counter).status_type:=c2.current_status;
        p_system_details.status_details(l_status_counter).status_count:=c2.status_count;

    END LOOP;-- end c2

END GET_SYSTEM_DETAILS;

END em_system_dashboard;
/

Show errors
set define on
