Rem
Rem $Header: em_system_dashboard_pkgdef.sql 28-jul-2005.01:38:45 vmotamar Exp $
Rem
Rem em_system_dashboard_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      em_system_dashboard_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    vmotamar    07/28/05 - Bug Nos :4517410,4504124,4517435
Rem    paachary    07/19/05 - Modifying the signatures of 
Rem                           get_alert_info and get_dashboard_preferences APIs.
Rem    nanand      05/13/05 - comments for GET_SYSTEM_DETAILS 
Rem    nanand      05/13/05 - moving GET_SYSTEM_DETAILS from 
Rem                           em_dashboard_service 
Rem    paachary    05/15/05 - Transaction for including ias, weblogic_domain, webpshere_cell, oracle_ias_farm, oracle_ias_cluster
Rem                           target types apart from target types for "is_group" and "is_system" properties.
Rem                           Deprecated get_metric_name and get_metric_column functions for performance reasons.
Rem                           Instead of using thse functions in the queries, direcctly queried the table 
Rem                           to get the desired results.
Rem    vmotamar    05/04/05 - Performance improvement
Rem    vmotamar    04/19/05 - Bug No 4309057
Rem    paachary    12/31/04 - Changed the signatures of 
Rem                           get_alert_info, get_target_info_full and get_target_info_rollup
Rem                           to include p_aggregate_target_type as an input parameter
Rem    vmotamar    12/28/04 - new procedure: get_dashboard_preferences
Rem    vmotamar    10/13/04 - vmotamar_sys_dash
Rem    vmotamar    10/13/04 - Created
Rem

CREATE OR REPLACE PACKAGE em_system_dashboard
AS

--
-- Type and constant definitions
--
TYPE CURSOR_TYPE IS REF CURSOR;

-- Purpose : Get Description for Seveity Codes, the table "mgmt_current_severity" returns
-- Input Parameters
-- p_severity_guid : Self Explanatory
-- Return Value
-- Description of the Severity GUID as defined in constants in "mgmt_global"
FUNCTION get_severity_description
(
    p_severity_code IN NUMBER
)
RETURN VARCHAR2;

-- Purpose : Get Name of the input Metric_GUID, Need this information to build links in System Dashboard
-- Input Parameters
-- p_metric_guid : Self Explanatory
-- Return Value
-- Metric Name for the Metric GUID, from table MGMT_METRICS
-- Deprecating this function for performance reasons.
/*
FUNCTION get_metric_name
(
    p_metric_guid IN RAW
)
RETURN VARCHAR2;
*/

-- Purpose : Get Metric Column for the input Metric_GUID, Need this information to build links in System Dashboard
-- Input Parameters
-- p_metric_guid : Self Explanatory
-- Return Value
-- Metric Name for the Metric Column, from table MGMT_METRICS
-- Deprecating this function for performance reasons.
/*
FUNCTION get_metric_column
(
    p_metric_guid IN RAW
)
RETURN VARCHAR2;
*/

-- Purpose : Get Description for Seveity Codes, the table "mgmt_current_availability" returns
-- Input Parameters
-- p_current_status : Self Explanatory
-- Return Value
-- Description of the Status ID as defined in constants in "mgmt_global"
FUNCTION get_availability_status_desc
(
    p_current_status IN NUMBER
)
RETURN VARCHAR2;

-- Purpose : To determine the refresh frequency and view preference of System Dashboard
-- Input Parameters
-- p_target_name : Name of Group, for which the Dashboard is painted
-- p_target_type : Target Type to which the Dashboard is limited to
-- Output Parameters
-- p_view_type : Full or Rollup view preferred by user (Default : Full view)
-- p_refresh_frequency : refresh frequency as specified by user (Default : 3 mins)
-- p_alerts_table_required : Whether the alerts table is required for this group or not.
PROCEDURE get_dashboard_preferences
(
    p_target_name           IN  VARCHAR2,
    p_target_type           IN  VARCHAR2,
    p_view_type             OUT VARCHAR2,
    p_refresh_frequency     OUT VARCHAR2,
    p_alerts_table_required OUT VARCHAR2
);

-- Purpose : To Drive the Alerts Section of the System Dashboard
-- Three possibilities :
-- 1.All (p_target_type and p_target_status are NULL)
-- 2.That Belong to a Specific Target Type (All hosts or databases) (p_target_status is null) and
-- 3. That Belong to a Specific Target Type and of a Specific Status (All hosts that are down)
-- Input Parameters
-- p_aggregate_target_type : Name of the aggregate target type, which is having the value in the property_name as "is_system" and "is_group"
-- p_aggregate_name : Name of the target belonging to an aggregate target type, for which the Dashboard is Painted
-- p_alerts_table_required : Whether the alerts table is required for this group or not.
-- p_target_status : Status of the Targets which need to be included in Dashboard (optional)
-- p_target_type : Target Type to which the Dashboard is limited to
-- Out Parameters
-- p_alerts : encompasses all information we need to display in the "Alerts" Section of Dashboard
-- p_critical_cnt : Stores the total critial counts for the aggregate
-- p_warning_cnt : Stores the total warning counts for the aggregate
-- p_down_cnt : Stores the total down counts for the aggregate
PROCEDURE get_alert_info
(
    p_aggregate_name         IN  VARCHAR2,
    p_aggregate_target_type  IN  VARCHAR2,
    p_alerts_table_required  IN  VARCHAR2 DEFAULT 'On',
    p_target_type            IN  VARCHAR2 DEFAULT NULL,
    p_target_status          IN  VARCHAR2 DEFAULT NULL,
    p_alerts                 OUT CURSOR_TYPE,
    p_critical_cnt           OUT NUMBER,
    p_warning_cnt            OUT NUMBER,
    p_down_cnt               OUT NUMBER
);


-- Purpose : To Drive the Target Section of the System Dashboard in "FULL" view
-- Three possibilities :
-- 1.All (p_target_type and p_target_status are NULL)
-- 2.That Belong to a Specific Target Type (All hosts or databases) (p_target_status is null) and
-- 3. That Belong to a Specific Target Type and of a Specific Status (All hosts that are down)
-- Input Parameters
-- p_aggregate_target_type : Name of the aggregate target type, which is having the value in the property_name as "is_system" and "is_group"
-- p_aggregate_name : Name of the target belonging to an aggregate target type, for which the Dashboard is Painted
-- p_target_status : Status of the Targets which need to be included in Dashboard (optional)
-- p_target_type : Target Type to which the Dashboard is limited to
-- Out Parameters
-- EM_TARGET_ARRAY : encompasses Target GUID, Name, Status, Alert and Metric Information
PROCEDURE get_target_info_full
(
    p_aggregate_name        IN  VARCHAR2,
    p_aggregate_target_type IN  VARCHAR2,
    p_target_type           IN  VARCHAR2 DEFAULT NULL,
    p_target_status         IN  VARCHAR2 DEFAULT NULL,
    p_target_details        OUT EM_TARGET_ARRAY
);

-- Purpose : To Drive the Target Section of the System Dashboard in "ROLLUP" view
-- Input Parameters
-- p_aggregate_target_type : Name of the aggregate type, which is having the value in the property_name as "is_system" and "is_group"
-- p_aggregate_name : Name of the target belonging to an aggregate target type, for which the Dashboard is Painted
-- Out Parameters
-- EM_TARGETTYPE_ARRAY : encompasses Target Type Name, Status, Alert and Metric Information
PROCEDURE get_target_info_rollup
(
    p_aggregate_name          IN  VARCHAR2,
    p_aggregate_target_type   IN  VARCHAR2,
    p_target_type_details     OUT EM_TARGETTYPE_ARRAY
);

-- Purpose : To get the system name/type and components of the system and their statuses
-- Input Parameters
-- p_service_name : Name of the service
-- p_target_type : target_type of the service
-- p_system_details : em_system_obj encompassing system name/type and components of the system and their statuses
PROCEDURE GET_SYSTEM_DETAILS
(
    p_service_name  IN VARCHAR2,
    p_target_type   IN VARCHAR2,
    p_system_details OUT em_system_obj
);

end em_system_dashboard;
/

show errors
