Rem drv: <create type="pkgdefs" pos="target/relocate_target_pkgdef.sql+"/>
Rem
Rem $Header: default_homepage_pkgdef.sql 18-jul-2005.01:10:26 gsbhatia Exp $
Rem
Rem default_homepage_pkgdef.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      default_homepage_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    07/18/05 - Add repmgr header 
Rem    vagarwal    07/13/05 - vagarwal_bug-4321324
Rem    vagarwal    07/07/05 - Created
Rem

CREATE OR REPLACE PACKAGE em_default_home AS

-- Package level Type Definition 
   TYPE cursorType IS REF CURSOR;

--Module Name to be used for log4plSql
MODULE_NAME CONSTANT VARCHAR2(22) := 'EM.TARGET.DEF_HOMEPAGE';


--
-- Name: get_alert_info
--
-- Package: em_default_home
--
-- Purpose: 
--  Gets the Alerts information to be displayed in the sdk homepage template,
--  for a given target
-- IN parameters:
--   target_name_in: VARCHAR2 the name of the target 
--   target_type_in: VARCHAR2 the type of the target
--   is_single_target_in: BOOLEAN is this a single target or an aggregate target
--   include_self_in: BOOLEAN if aggr target, include self in the alerts count?
--   txn_name_in: transaction name - defaults to null
--
-- OUT parameters:
--  metric_errors_count: NUMBER
--  alerts_cur_out: CURSORTYPE containing alerts information
--
-- ERROR codes:
--
PROCEDURE get_alert_data(
    p_target_name_in         IN VARCHAR2,
    p_target_type_in         IN VARCHAR2,
    p_is_single_target_in    IN NUMBER,
    p_include_self_in        IN NUMBER,
    p_txn_name_in            IN VARCHAR2,
    p_metric_error_count_out OUT NUMBER,
    p_alert_cur_out          OUT CURSORTYPE);

--
-- Name: get_general_data
--
-- Package: em_default_home
--
-- Purpose: 
--  Gets the header information to be displayed in the sdk homepage template,
--  for a given target
-- IN parameters:
--   target_name_in: VARCHAR2 the name of the target 
--   target_type_in: VARCHAR2 the type of the target
--
-- OUT parameters:
--   p_pct_available_out: NUMBER %availability for this target
--   p_avail_cur_out: cursor containing availability information
--
-- ERROR codes:
--
PROCEDURE get_general_data(
    p_target_name_in         IN VARCHAR2,
    p_target_type_in         IN VARCHAR2,
    p_pct_available_out      OUT NUMBER,
    p_avail_cur_out          OUT CURSORTYPE );
    
end em_default_home;
/
show errors;
