Rem drv: <create type="pkgdefs" pos="target/target_ui_pkgdef.sql+"/>
Rem
Rem $Header: emcore/source/oracle/sysman/emdrep/sql/core/latest/target/relocate_target_pkgdef.sql /st_emcore_10.2.0.4.2db11.2/1 2009/03/25 11:24:45 joyoon Exp $
Rem
Rem relocate_target_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      relocate_target_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    rzkrishn    02/21/05 - get siblings as well in getRelatedTargets 
Rem    rzkrishn    01/12/05 - procedure to find if duplicate target 
Rem    rzkrishn    08/19/04 - using space as default in callbacks 
Rem    rzkrishn    07/30/04 - callback can't be NULL in delete_tgt_relocation 
Rem    rzkrishn    07/14/04 - rzkrishn_oms_side_of_13253
Rem    rzkrishn    07/07/04 - adding callbacks 
Rem    rzkrishn    06/15/04 - Created
Rem

--
-- Package: em_target_relocate
--
-- PURPOSE:
--       This package contains internal procedures used by target relocation.
--        
--
-- NOTES:
--
CREATE OR REPLACE PACKAGE EM_TARGET_RELOCATE
AS

-- Package level Type Definition
   TYPE CURSORTYPE IS REF CURSOR;

--
-- compare_agent_versions
--
-- Takes 2 agent URL;s and determine if agent1 is of higher, equal or 
-- lower version than agent2.
-- returns 0 if equal, 1 if agent1 > agent2, -1 agent1 < agent2
--
FUNCTION compare_agent_versions( p_src_agent_target IN VARCHAR2,
                              p_dest_agent_target IN VARCHAR2 ) RETURN NUMBER;


--
-- is_cluster_target
--
-- Takes a target type and determines if it is a]cluster target or not.
-- Returns FALSE if non-cluster target. TRUE if cluster target.
--
FUNCTION is_cluster_target(p_target_type IN VARCHAR2) RETURN INTEGER; 


--
-- find_agent_monitoring_for_tgt
--
-- Takes a targetname, target type and determines the current agent
-- monitoring for that target.
--
PROCEDURE  find_agent_monitoring_for_tgt(p_target_name IN VARCHAR2,
                                            p_target_type IN VARCHAR2,
                                            p_agent_target OUT VARCHAR2);


--
-- find_emd_url_for_target
--
-- takes a target name and target type and finds the EMD url of
-- the agent monitoring the target.
--
FUNCTION find_emd_url_for_target(p_target_name IN VARCHAR2,
                                 p_target_type IN VARCHAR2) RETURN STRING;  


--
-- find_target_guid
--
-- takes a target name and target type and finds
-- its target guid.
--
FUNCTION find_target_guid(p_target_name IN VARCHAR2,
                          p_target_type IN VARCHAR2)
                RETURN STRING; 

--
-- check_preconditions
--
-- Checks all the sql conditions to determine if target can be moved.
-- returns TRUE for ok to proceed, FALSE for failure to proceed.
-- 1. check if src agent version <= dest agent version
-- 2. user has privileges to move the target. 
-- 3. target to be moved is not a cluster target.
--
FUNCTION check_preconditions( p_target_name IN VARCHAR2,
                            p_target_type IN VARCHAR2,
                            p_user_name IN VARCHAR2,
                            p_src_agent_target IN VARCHAR2,
                            p_dest_agent_target IN VARCHAR2 ) RETURN INTEGER;
 
--
-- PROCEDURE: add_tgt_relocation_callback
--
-- PURPOSE
--   Adds a callback to the repository. This callback is called whenever
--   that target is relocated from one agent to another.
--
--  PROCEDURE callback_name( target_name   IN VARCHAR2,
--                           target_type   IN VARCHAR2,
--                           old_agent_url IN VARCHAR2,
--                           new_agent_url IN VARCHAR2);
--
--
PROCEDURE add_tgt_relocation_callback( p_callback_name   IN VARCHAR2,
                                       p_target_name IN VARCHAR2 DEFAULT ' ',
                                       p_target_type IN VARCHAR2 DEFAULT ' ');

--
-- PROCEDURE: delete_tgt_relocation_callback
--
-- PURPOSE
--   Deletes a callback from repository.
--
--  PROCEDURE callback_name( target_name   IN VARCHAR2,
--                           target_type   IN VARCHAR2,
--                           old_agent_url IN VARCHAR2,
--                           new_agent_url IN VARCHAR2);
--
--
PROCEDURE delete_tgt_relocation_callback( p_callback_name   IN VARCHAR2,
                                       p_target_name IN VARCHAR2 DEFAULT ' ',
                                       p_target_type IN VARCHAR2 DEFAULT ' ');

--
-- PROCEDURE: exec_tgt_relocation_callbacks
--
-- Execute callbacks for target relocation.
--
PROCEDURE exec_tgt_relocation_callbacks( p_target_name   IN VARCHAR2,
                                         p_target_type   IN VARCHAR2,
                                         p_old_agent_url  IN VARCHAR2,
                                         p_new_agent_url  IN VARCHAR2);

--
-- PROCEDURE: update_tables_for_relocation
--
-- PURPOSE
--  updates MGMT_TARGETS, MGMT_DUPLICATE_TARGETS and invoke
--  all the callbacks registered.
--
PROCEDURE update_tables_for_relocation( p_target_name IN VARCHAR2,
                                        p_target_type IN VARCHAR2,
                                        p_old_agent_url IN VARCHAR2,
                                        p_new_agent_url IN VARCHAR2);

--
-- PROCEDURE get_cli_blackouts_for_target
--
-- PURPOSE
--  gets a cursor to fetch all CLI blackouts for the target given the 
--  target name, target type and emd_url.
--
PROCEDURE get_cli_blackouts_for_target ( p_target_name IN VARCHAR2,
                                         p_target_type IN VARCHAR2,
                                         p_emd_url     IN VARCHAR2,
                                         p_cli_blackouts_cur OUT CURSORTYPE ); 


--
--  PROCEDURE get_related_targets
--
-- PURPOSE
--  gets related targets given a target.
--
PROCEDURE get_related_targets ( p_target_name IN VARCHAR2,
                                p_target_type IN VARCHAR2,
                                p_emd_url     IN VARCHAR2,
                                p_related_parents_cur OUT CURSORTYPE,
                                p_related_children_cur OUT CURSORTYPE,
                                p_related_siblings_cur OUT CURSORTYPE );

--
-- check_if_duplicate_target 
--
-- Takes a target, source agent and destination agent url. determines if the 
-- target is monitored by source agent and is considered as duplicate for
-- destination agent.
-- returns 1 if duplicate, 0 if not duplicate. 
--
FUNCTION check_if_duplicate_target( p_target_name IN VARCHAR2,
                                    p_target_type IN VARCHAR2,
                                    p_src_agent_url IN VARCHAR2,
                                    p_dest_agent_url IN VARCHAR2 ) 
                           RETURN INTEGER;

--
-- Handle master agent switch in case of relocating target.
-- When a given target to be relocated is a member of cluster 
-- and the agent was master, OMS will find a new master if there is 
-- good one, otherwise it will keep the current master
-- 
PROCEDURE relocate_master_agent(p_target_name IN VARCHAR2,
                                p_target_type IN VARCHAR2,
                                p_old_agent_url IN VARCHAR2,
                                p_new_agent_url IN VARCHAR2 );

END EM_TARGET_RELOCATE;
/ 
show errors;
