Rem
Rem $Header: target_folders_pkgdef.sql 10-may-2005.14:49:56 rpatti Exp $
Rem
Rem target_folders_pkgdef.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      target_folders_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rpatti      05/10/05 - rpatti_bug-4147142
Rem    rpatti      05/02/05 - Created
Rem

CREATE OR REPLACE PACKAGE em_folders_ui AS

-- Package level Type Definition 
   TYPE cursorType IS REF CURSOR;

/*
 * set_default_metric_preferences - set the default metrics to show up in the
 *                                  summary for a given user
 *
 *   p_user_name     - the user being modified
 *   p_callback_type - type of modification; may be one of:
 *                       MGMT_USER.USER_CREATED_CALLBACK
 *                       MGMT_USER.USER_DROPPED_CALLBACK
 */
PROCEDURE set_default_subtab_preferences(p_user_name     IN VARCHAR2,
                                         p_callback_type IN NUMBER);

/**
 This procedure takes as input a target type and returns a list of summary 
 metrics, non-hidden properties, and generic columns that a user may display
 in the sub-tab for the target type in question. The current choice setting
 is also returned.
 */
PROCEDURE getSubTabPreferrences (
              p_target_type_in     IN  VARCHAR2,
              p_user_prefs_cur_out OUT cursorType,
              p_def_prefs_cur_out  OUT cursorType);

/**
  Insert the preferences of the user - for metrics to be shown 
  in the dense UI for a given type
 */
PROCEDURE saveSummaryMetricsInfo (
              p_target_type_in     IN  VARCHAR2,
              p_sel_metrics_in     IN  MGMT_SUBTAB_PREF_ARRAY
);

end em_folders_ui;
/

show errors;

