Rem drv: <create type="pkgbodys" pos="user_model/user_model_pkgbodys.sql+"/>
Rem
Rem $Header: emcore/source/oracle/sysman/emdrep/sql/core/latest/target/target_pkgbody.sql /st_emcore_10.2.0.4.2db11.2/2 2009/02/26 20:39:36 jsadras Exp $
Rem
Rem target_pkgbody.sql
Rem
Rem Copyright (c) 2002, 2009, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      target_pkgbody.sql - Support procedures related to targets
Rem        that are used internally (these are not part of the sdk)
Rem
Rem    DESCRIPTION
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       jsadras  11/10/08 - Bug:7361774, fix perf issues
Rem       jsadras  09/23/08 - Bug:7426016, add dbms_assert calls
Rem       pmodi    05/07/08 - Backport pmodi_bug-7010707 from
Rem                           st_emcore_10.2.0.1.0
Rem       neearora 08/14/07 - bug 6339945
Rem       neearora 08/16/07 - Backport neearora_bug-6339945 from main
Rem       neearora 05/11/07 - Backport neearora_bug-5111102 from main
Rem       kmanicka 05/10/06 - implement pdp
Rem       nqureshi 04/18/07 - XbranchMerge kmanicka_pdp5 from main
Rem       neearora 03/26/07 - bug 5691940
Rem       neearora 04/12/07  - Backport neearora_bug-5691940 from main
Rem       neearora 03/26/07  - bug 5916549
Rem       neearora 03/28/07 - Backport neearora_bug-5916549 from main
Rem       aptrived 04/18/06 - Bug#5152908, Calling delete_target_metrics_1day 
Rem                           when is_metric_deletion_enabled > 0 
Rem       pmodi    10/27/06 - change order by clause - Backport pmodi_bug-5602027 
Rem                           from main
Rem       neearora 02/09/06 - Bug 4724832. Update collection_timestamp using 
Rem                           cursor in case of PK violations 
Rem       neearora 02/09/06 - Bug 4724832. Update collection_timestamp using 
Rem                           cursor in case of PK violations 
Rem       neearora 08/06/06 - Backport neearora_bug-4724832 from main
Rem       neearora 08/06/06 - Backport neearora_bug-4969057 from main
Rem       neearora 06/06/06 - bug 5194980. submit a job to propogate the 
Rem                           display_name to agent 
Rem       neearora 06/06/06 - bug 5194980. submit a job to propogate the 
Rem                           display_name to agent 
Rem       neearora 07/25/06 - Backport neearora_bug-5194980 from main 
Rem       neearora 07/25/06 - Backport neearora_bug-5186115 from main 
Rem       neearora 05/02/06 - Bug 4969057. Changed SQLERRM to SQLCODE in 
Rem                           remove_cluster_member
Rem       neearora 04/10/06 - Changed modify_target API to pass credentials 
Rem                           information to Agent if prop_to_agent is true 
Rem       neearora 04/23/06 - Bug 5108394. Adding function 
Rem                           is_agent_monitoring_target 
Rem       neearora 07/16/06 - Backport neearora_bug-5108394 from main 
Rem       rkpandey 12/01/05 - Backport rkpandey_bug-4671204 from main 
Rem       neearora 04/20/06 - Bug 5111102. Removed code to set the dynamic property  
Rem                           to null in upsert_target_properties 
Rem       rkpandey 11/20/05 - Bug 4671204: Avoid rac deadlock 
Rem       rpinnama 09/01/05  - 
Rem       jsadras  08/17/05  - exec_metaver_upd_callback: handle catprop 
Rem                            changes 
Rem       rkpandey 07/27/05  - Added get_agent_version 
Rem       rkpandey 07/19/05  - Added remove_cluster_member and 
Rem                            set_master_agent 
Rem       gan      07/12/05  - commit in post deletion 
Rem       gsbhatia 07/01/05  - New repmgr header impl 
Rem       rpinnama 06/23/05  - Implement tzrgn callbacks 
Rem       rpinnama 06/14/05  - Fix set_target_tzrgn API
Rem       pmodi    05/31/05  - Bug:4391453- target_delete to delete data from 
Rem                            OCS-Like table too 
Rem       pmodi    05/12/05  - Bug-4358700: Type exists check before insert 
Rem       pmodi    05/03/05  - get default target_type_display_name from 
Rem                            mgmt_target_types table
Rem       pmodi    05/13/05  - Bug-4351915: Remove time function for true 
Rem                            distinct 
Rem       jsadras  04/21/05  - get registration lock procedure 
Rem       ramalhot 04/04/05  - modified modify target 
Rem       neearora 03/24/05  - add check_type_ver_guid 
Rem       neearora 03/17/05  - Added check to verify the callback name during 
Rem                            registration of  pre/post delete target callback, 
Rem                            to prevent SQL injection 
Rem       jsadras  03/10/05  - add target property callback 
Rem       ramalhot 03/09/05  - moved add target code from sdk pkg to here 
Rem       rpinnama 02/25/05  - Add proc for handle target type version ROWSET
Rem       pmodi    02/22/05  - Add setter/getter for repo tzr 

Rem       neearora 02/22/05  - added a new procedure get_factory_type 
Rem       dcawley  02/21/05  - Replace enter super user mode
Rem       neearora 02/17/05  - now pre/post delete callbacks are called as 
Rem                            super user 
Rem       ramalhot 02/02/05 -  fixed bug 4161214 Rem       
Rem       rkpandey 01/05/05 - delete_agent_target added 
Rem       ramalhot 01/17/05 - g_member_guid->g_contains_guid
Rem       ramalhot 01/11/05 - call pre-delete callbacks as super-user 
Rem       rpinnama 01/06/05 - Add target type procedures 
Rem       rpinnama 11/29/04 - Add set_target_tzrgn API. 
Rem       rkpandey 11/06/04 - Support to delete empty parent clusters 
Rem       ramalhot 10/14/04 - Change parameter name 
Rem       ramalhot 10/14/04 - another version of pre delete callcbackk added 
Rem       streddy  10/11/04 - Fix typo in delete_callback 
Rem       ramalhot 08/25/04 - cutover to new assoc tables 
Rem       skini    05/08/03 - skini_jobsystem_rac_support
Rem
Rem

-- 
-- Package: em_target
--
-- PURPOSE: 
--    This package contains internal procedures used by various
--    subsystems to obtain target (and metric) information.
--
-- NOTES: 
--
CREATE OR REPLACE PACKAGE BODY EM_TARGET
AS
-- Forward Declarations
  PROCEDURE  check_required_properties
  (
    p_target_type IN mgmt_targets.target_type%TYPE,
    p_properties  IN MGMT_TARGET_PROPERTY_LIST
  );

  PROCEDURE insert_target_properties
  (
    p_target_guid IN mgmt_targets.target_guid%TYPE,
    p_properties  IN MGMT_TARGET_PROPERTY_LIST
  );

  PROCEDURE insert_monitoring_credentials
  (
    p_target_name   IN mgmt_targets.target_name%TYPE,
    p_target_type   IN mgmt_targets.target_type%TYPE,
    p_type_meta_ver IN mgmt_targets.type_meta_ver%TYPE,
    p_monitoring_credentials IN SMP_EMD_NVPAIR_ARRAY
  );

  PROCEDURE check_member_targets_priv
  (
    p_member_targets IN MGMT_USER_GUID_ARRAY,
    p_privilege      IN VARCHAR2,
    p_user           IN VARCHAR2
  );

  PROCEDURE check_aggregate
  (
    p_target_type VARCHAR2
  );

  PROCEDURE modify_members
  (
    p_aggregate_name    IN mgmt_targets.target_name%TYPE,
    p_aggregate_type    IN mgmt_targets.target_type%TYPE,
    p_targets_to_add    IN SMP_EMD_NVPAIR_ARRAY,
    p_targets_to_remove IN SMP_EMD_NVPAIR_ARRAY
  );

  PROCEDURE check_aggregate_members
  (
    p_aggregate_type VARCHAR2,
    p_members SMP_EMD_NVPAIR_ARRAY
  ); 

  FUNCTION is_multi_agent_target
  (
    p_target_name IN mgmt_targets.target_name%TYPE,
    p_target_type IN mgmt_targets.target_type%TYPE
  ) RETURN NUMBER ;

  PROCEDURE upsert_target_properties
  (
    p_target_name        IN mgmt_targets.target_name%TYPE,
    p_target_type        IN mgmt_targets.target_type%TYPE,
    p_target_guid        IN mgmt_targets.target_guid%TYPE,
    p_properties         IN MGMT_TARGET_PROPERTY_LIST,
    p_propagate_to_agent IN NUMBER DEFAULT 0
  );


  PROCEDURE submit_mod_tgt_dispname_job
  (
    p_target_name VARCHAR2,
    p_target_type VARCHAR2,
    p_target_display_name VARCHAR2
  );


  PROCEDURE update_tzrgn_for_violations(p_target_guid RAW,
                                        p_curr_tzrgn VARCHAR2,
                                        p_new_tzrgn VARCHAR2,
                                        p_forward BOOLEAN);
  PROCEDURE update_tzrgn_for_avail(p_target_guid RAW,
                                   p_curr_tzrgn VARCHAR2,
                                   p_new_tzrgn VARCHAR2,
                                   p_forward BOOLEAN);

  FUNCTION IS_ERROR_ON_OVERLAP_TIME RETURN BOOLEAN ;

  FUNCTION ADJUST_TZ(p_in_date DATE,
                     p_curr_tzrgn VARCHAR2,
                     p_new_tzrgn VARCHAR2)
  RETURN DATE;

-- End Forward Declarations


G_TARGET_CALLBACK_OBJ CONSTANT VARCHAR2(30):='MGMT_TARGET_META_VER_CBK_OBJ';

-- Return the metric guid for the response metric for this target
-- A NO_DATA_FOUND is raised if the metric does not exist
FUNCTION get_response_metric_guid(p_target_guid RAW) RETURN RAW IS
l_response_metric_guid MGMT_METRICS.metric_guid%TYPE;
BEGIN
    SELECT met.metric_guid INTO l_response_metric_guid
        FROM MGMT_TARGETS tgt, MGMT_METRICS met
       WHERE tgt.target_guid = p_target_guid
         AND tgt.target_type = met.target_type
         AND met.metric_name = MGMT_GLOBAL.G_AVAIL_METRIC_NAME
         AND met.metric_column = MGMT_GLOBAL.G_AVAIL_METRIC_COLUMN
         AND met.type_meta_ver = tgt.type_meta_ver
         AND (met.category_prop_1 = tgt.category_prop_1 OR 
              met.category_prop_1 = ' ')
         AND (met.category_prop_2 = tgt.category_prop_2 OR 
              met.category_prop_2 = ' ')
         AND (met.category_prop_3 = tgt.category_prop_3 OR 
              met.category_prop_3 = ' ')
         AND (met.category_prop_4 = tgt.category_prop_4 OR 
              met.category_prop_4 = ' ')
         AND (met.category_prop_5 = tgt.category_prop_5 OR 
              met.category_prop_5 = ' ');

    RETURN l_response_metric_guid;
END;

--
-- delete_empty_cluster_target
--  
-- Checks if the cluster target has no members  
-- and delete empty cluster target from the repository 
--
PROCEDURE delete_empty_cluster_target(p_target_name IN VARCHAR2,
                                 p_target_type IN VARCHAR2) IS
l_child_count NUMBER;
BEGIN

    IF (EMDW_LOG.p_is_info_set)
    THEN
        EMDW_LOG.INFO('Entering: p_target_name:'||p_target_name||' p_target_type:'||p_target_type,'EM_TARGET.delete_empty_cluster_target');
    END IF;
--   IF (p_target_name != ' ' AND p_target_type != ' ') THEN ... already checked this condition in DeleteTarget.java
    SELECT count(a.assoc_target_guid) into l_child_count
      FROM MGMT_TARGETS t, MGMT_TARGET_ASSOCS a
     WHERE t.target_name = p_target_name
       AND t.target_type = p_target_type
       AND a.source_target_guid = t.target_guid
       AND a.assoc_guid = mgmt_assoc.g_contains_guid;

    IF (EMDW_LOG.p_is_info_set)
    THEN
        EMDW_LOG.INFO('No of Children for '||p_target_name||p_target_type||' is '||l_child_count,'EM_TARGET.delete_empty_cluster_target');
    END IF;

        IF (l_child_count = 0) THEN
            BEGIN
            MGMT_ADMIN.delete_target(p_target_name, p_target_type);
            EXCEPTION
            WHEN OTHERS THEN
               IF (EMDW_LOG.p_is_error_set)
               THEN
                   EMDW_LOG.ERROR('Error Deleting parent target '||p_target_name||p_target_type,'EM_TARGET.delete_empty_cluster_target');
                END IF;
            END;
        END IF;
    IF (EMDW_LOG.p_is_info_set)
    THEN
        EMDW_LOG.INFO('Exiting','EM_TARGET.delete_empty_cluster_target');
    END IF;

END;



--
-- get_cluster_target_info
--
-- Obtain information about a cluster identified by 
-- p_cluster_name and p_cluster_type. 
-- 
PROCEDURE get_cluster_target_info(p_cluster_name VARCHAR2,
                                  p_cluster_type VARCHAR2,
                                  p_master_instance_name_out OUT VARCHAR2,
                                  p_master_instance_type_out OUT VARCHAR2,
                                  p_master_emd_url_out OUT VARCHAR2,
                                  p_instance_cursor_out OUT TGT_CURSOR) IS

l_cluster_target_guid MGMT_TARGETS.target_guid%TYPE;
l_master_instance_guid MGMT_TARGETS.target_guid%TYPE;

l_is_cluster NUMBER;
BEGIN
    -- If the instance is not a cluster, throw an illegal argument
    -- exception
    BEGIN
        SELECT property_value INTO l_is_cluster FROM 
          MGMT_TYPE_PROPERTIES WHERE 
            target_type=p_cluster_type AND
            property_name=MGMT_GLOBAL.G_IS_CLUSTER_PROP;

        IF l_is_cluster=0 THEN
            raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
                  'The specified target is not a cluster');
        END IF;

    EXCEPTION
    WHEN NO_DATA_FOUND THEN
        raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
          'The specified target is not a cluster');
    END;
        
    -- Determine the "master" emd. This is the emd that is 
    -- currently associated with the cluster target
    BEGIN
        SELECT target_guid, emd_url INTO 
            l_cluster_target_guid, p_master_emd_url_out FROM
          MGMT_TARGETS WHERE 
              target_name=p_cluster_name AND
              target_type=p_cluster_type;
    EXCEPTION
    WHEN NO_DATA_FOUND THEN
        raise_application_error(MGMT_GLOBAL.INVALID_TARGET_ERR,
           'The target ' || p_cluster_name || ':' || p_cluster_type ||
           ' does not exist');
    END;

    -- Determine the "master" instance: the instance being monitored
    -- by the master emd. There should be exactly one such instance.
    SELECT t.target_name, t.target_type, assoc_target_guid INTO
        p_master_instance_name_out, p_master_instance_type_out, 
                 l_master_instance_guid FROM
      MGMT_TARGET_ASSOCS m, MGMT_TARGETS t WHERE 
         source_target_guid=l_cluster_target_guid AND
         assoc_target_guid=t.target_guid AND
         assoc_guid = MGMT_ASSOC.g_contains_guid AND
         t.emd_url=p_master_emd_url_out;

    -- The only way to determine the instance is through the 
    -- memberships table. We assume that all members are instances
    -- Select all other instances
    OPEN p_instance_cursor_out FOR 
     SELECT t.target_name, t.target_type, emd_url FROM
      MGMT_TARGET_ASSOCS m, MGMT_TARGETS t WHERE 
         m.source_target_guid=l_cluster_target_guid AND
         m.assoc_target_guid != l_master_instance_guid AND
         m.assoc_guid = MGMT_ASSOC.g_contains_guid AND
         m.assoc_target_guid=t.target_guid;

             
END;

  PROCEDURE add_tgt_deletion_callback
  (
    p_callback_type  IN NUMBER,
    p_procedure_name IN VARCHAR2,
    p_target_name    IN mgmt_targets.target_name%TYPE DEFAULT ' ',
    p_target_type    IN mgmt_targets.target_type%TYPE DEFAULT ' ',
    p_delete_order   IN NUMBER DEFAULT 8
  )
  AS
  l_error_message VARCHAR2(1000);
  BEGIN
    EM_CHECK.check_not_null(p_procedure_name,'p_procedure_name');

    IF NOT EM_CHECK.is_valid_signature(p_procedure_name,
                      mgmt_short_string_array('VARCHAR2','VARCHAR2','RAW'),
                      l_error_message)
    THEN
      raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,l_error_message) ;
    END IF ;

    INSERT
      INTO mgmt_callbacks
           (callback_type,callback_name,selector_1,selector_2,
            selector_3,eval_order)
    VALUES (p_callback_type,
            p_procedure_name,
            p_target_name,
            p_target_type,
            p_delete_order,
            p_delete_order);
  EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
      raise_application_error(mgmt_global.invalid_params_err,
                              'callback  already exist');  
  END add_tgt_deletion_callback;

  PROCEDURE add_tgt_pre_deletion_callback
  (
    p_procedure_name IN VARCHAR2,
    p_target_name    IN mgmt_targets.target_name%TYPE DEFAULT ' ',
    p_target_type    IN mgmt_targets.target_type%TYPE DEFAULT ' ',
    p_delete_order   IN NUMBER DEFAULT 8
  )
  IS
  BEGIN
    add_tgt_deletion_callback(MGMT_GLOBAL.G_TARGET_PRE_DEL_CALLBACK,
                              p_procedure_name,
                              p_target_name,
                              p_target_type,
                              p_delete_order);
  END add_tgt_pre_deletion_callback;

  PROCEDURE add_tgt_post_deletion_callback
  (
    p_procedure_name IN VARCHAR2,
    p_target_name    IN mgmt_targets.target_name%TYPE DEFAULT ' ',
    p_target_type    IN mgmt_targets.target_type%TYPE DEFAULT ' ',
    p_delete_order   IN NUMBER DEFAULT 8
  )
  IS
  BEGIN
    add_tgt_deletion_callback(MGMT_GLOBAL.G_TARGET_POST_DEL_CALLBACK,
                              p_procedure_name,
                              p_target_name,
                              p_target_type,
                              p_delete_order);
  END add_tgt_post_deletion_callback;

  PROCEDURE del_tgt_deletion_callback
  (
    p_callback_type  IN NUMBER,
    p_procedure_name IN VARCHAR2,
    p_target_name    IN mgmt_targets.target_name%TYPE DEFAULT ' ',
    p_target_type    IN mgmt_targets.target_type%TYPE DEFAULT ' '
  )
  AS
  BEGIN
    DELETE
      FROM mgmt_callbacks
     WHERE callback_type = p_callback_type 
       AND callback_name = p_procedure_name
       AND selector_1 = p_target_name
       AND selector_2 = p_target_type;
  END del_tgt_deletion_callback;
  
  PROCEDURE del_tgt_pre_deletion_callback
  (
    p_procedure_name IN VARCHAR2,
    p_target_name    IN mgmt_targets.target_name%TYPE DEFAULT ' ',
    p_target_type    IN mgmt_targets.target_type%TYPE DEFAULT ' '
  )
  IS 
  BEGIN 
    del_tgt_deletion_callback(MGMT_GLOBAL.G_TARGET_PRE_DEL_CALLBACK,
                              p_procedure_name,
                              p_target_name,
                              p_target_type);

  END del_tgt_pre_deletion_callback;

  PROCEDURE del_tgt_post_deletion_callback
  (
    p_procedure_name IN VARCHAR2,
    p_target_name    IN mgmt_targets.target_name%TYPE DEFAULT ' ',
    p_target_type    IN mgmt_targets.target_type%TYPE DEFAULT ' '
  )
  IS 
  BEGIN 
    del_tgt_deletion_callback(MGMT_GLOBAL.G_TARGET_POST_DEL_CALLBACK,
                              p_procedure_name,
                              p_target_name,
                              p_target_type);

  END del_tgt_post_deletion_callback;

  -- Internal Procedure 
  -- Execute target deletion callbacks
  --
  PROCEDURE exec_tgt_del_callbacks
  (
    p_target_name   IN mgmt_targets.target_name%TYPE,
    p_target_type   IN mgmt_targets.target_type%TYPE,
    p_target_guid   IN mgmt_targets.target_guid%TYPE,
    p_callback_type IN NUMBER
  )
  IS
    l_current_user mgmt_targets.owner%TYPE := MGMT_USER.get_current_em_user();
  BEGIN

    -- Call the target deletion callbacks
    FOR callback IN (SELECT callback_name
                       FROM  mgmt_callbacks
                      WHERE callback_type = p_callback_type 
                        AND ( selector_2 = p_target_type OR
                              selector_2 = ' '
                            )
                        AND ( selector_1 = p_target_name OR
                              selector_1 = ' '
                            )
                      ORDER BY eval_order ASC
                    )
    LOOP
      -- Enter super-user mode. This is necessary because some callbacks 
      -- involves making calls to the security system that only super-users
      -- are allowed to make
      SETEMUSERCONTEXT(MGMT_USER.GET_REPOSITORY_OWNER, 
                       MGMT_USER.OP_SET_IDENTIFIER);

      BEGIN
        EXECUTE IMMEDIATE
          'BEGIN ' || EM_CHECK.qualified_sql_name(callback.callback_name) ||
                 '(:1, :2, :3); END; ' USING
           p_target_name, p_target_type, p_target_guid ;
        IF p_callback_type = mgmt_global.G_TARGET_POST_DEL_CALLBACK THEN
           COMMIT;
        END IF;
      EXCEPTION
      -- Ignore exceptions so that main transaction is not affected; we do not
      -- treat callback exceptions on par with repository exceptions. In other
      -- words, we will not let some callback mess up repository operations.
        WHEN OTHERS THEN
          mgmt_log.log_error(v_module_name_in => 'TARGET',
                             v_error_code_in  =>  0,
                             v_error_msg_in   => SUBSTR(SQLERRM, 1, 2000));
          -- Revert back to being the same user as we entered
          SETEMUSERCONTEXT(l_current_user, MGMT_USER.OP_SET_IDENTIFIER);
      END;
      -- Revert back to being the same user as we entered
      SETEMUSERCONTEXT(l_current_user, MGMT_USER.OP_SET_IDENTIFIER);
    END LOOP;
  END;

  --
  -- Execute target pre deletion callbacks
  --
  PROCEDURE exec_tgt_pre_del_callbacks
  (
    p_targets IN SMP_EMD_TGT_OBJECT_TBL 
  )
  IS
  BEGIN
    FOR i IN 1..p_targets.COUNT
    LOOP
      exec_tgt_del_callbacks(p_targets(i).target_name,
                             p_targets(i).target_type,
                             p_targets(i).target_guid,
                             mgmt_global.G_TARGET_PRE_DEL_CALLBACK);
    END LOOP;
  END exec_tgt_pre_del_callbacks;

  --
  -- Execute target post deletion callbacks
  --
  PROCEDURE exec_tgt_post_del_callbacks
  (
    p_targets IN SMP_EMD_TGT_OBJECT_TBL 
  )
  IS
  BEGIN
    FOR i IN 1..p_targets.COUNT
    LOOP
      exec_tgt_del_callbacks(p_targets(i).target_name,
                             p_targets(i).target_type,
                             p_targets(i).target_guid,
                             mgmt_global.G_TARGET_POST_DEL_CALLBACK);
    END LOOP;
  END exec_tgt_post_del_callbacks;

  --
  -- Execute tzrgn update callbacks
  --
  PROCEDURE exec_tzrgn_update_callbacks
            (p_target_guid  IN mgmt_targets.target_guid%TYPE,
             p_target_type  IN mgmt_targets.target_type%TYPE,
             p_old_tzrgn    IN mgmt_targets.timezone_region%TYPE,
             p_new_tzrgn    IN mgmt_targets.timezone_region%TYPE
            )
  IS
    l_error_msg    VARCHAR2(4000);
    l_callback_obj mgmt_tzrgn_update_cbk_obj ;
    l_proc_name    VARCHAR2(32) := 'exec_tzrgn_update_callbacks : ';
  BEGIN  
    IF EMDW_LOG.P_IS_INFO_SET THEN
    EMDW_LOG.DEBUG(l_proc_name || ' Enter :'||
             ' Target= ['|| p_target_guid || ']' ||
             ' type= ['|| p_target_type || ']' ||
             ' tzrgn old = ['|| p_old_tzrgn || ']' ||
             ' tzrgn new = ['|| p_new_tzrgn || ']',
             l_proc_name) ;
    END IF  ;
    FOR rec IN ( SELECT cbk.callback_name, tgt.target_name
                   FROM mgmt_callbacks cbk, mgmt_targets tgt
                  WHERE tgt.target_guid   = p_target_guid
                    AND cbk.callback_type = MGMT_GLOBAL.G_TZRGN_UPDATE_CALLBACK
                    AND tgt.target_type   LIKE cbk.selector_1 ESCAPE '\'
                 ORDER BY cbk.eval_order,cbk.callback_name 
               )
    LOOP
      BEGIN
        IF EMDW_LOG.P_IS_DEBUG_SET THEN
          EMDW_LOG.DEBUG(l_proc_name || 'Executing '||
               rec.callback_name, l_proc_name) ;
        END IF ;

        l_callback_obj := MGMT_TZRGN_UPDATE_CBK_OBJ.NEW(
                          p_target_guid => p_target_guid,
                          p_target_type => p_target_type,
                          p_from_tzrgn  => p_old_tzrgn,
                          p_to_tzrgn    => p_new_tzrgn) ;

        EXECUTE IMMEDIATE 
          'BEGIN '|| EM_CHECK.QUALIFIED_SQL_NAME(rec.callback_name)|| 
                     '(:1); END;'
          USING l_callback_obj ;
      EXCEPTION
        WHEN OTHERS THEN
          l_error_msg := sqlerrm|| ' when  executing callback '|| 
               rec.callback_name || 
             ' Target='||rec.target_name ||
             ' type='|| p_target_type ||
             ' timezone region old ='|| p_old_tzrgn ||
             ' timezone region new ='|| p_new_tzrgn;
          mgmt_log.log_error(v_module_name_in => 'TARGET',
                             v_error_code_in  =>  SQLCODE,
                             v_error_msg_in   => SUBSTR(l_error_msg, 1, 2000));
        IF EMDW_LOG.P_IS_ERROR_SET
        THEN
          EMDW_LOG.ERROR(l_proc_name || 'Exception '||rec.callback_name
                       ||':'||sqlerrm, l_proc_name) ;
        END IF ;
      END ;
    END LOOP ;
    IF EMDW_LOG.P_IS_INFO_SET THEN
      EMDW_LOG.INFO(l_proc_name || 'Exit',l_proc_name) ;
    END IF ;

  END exec_tzrgn_update_callbacks ;


  --
  -- PURPOSE: Sets the timezone region for the given target.
  -- 
  PROCEDURE set_target_tzrgn(p_target_guid     IN RAW, 
                             p_timezone_region IN VARCHAR2)
  IS
    l_curr_tzrgn mgmt_targets.timezone_region%TYPE;
    l_sysdate     DATE;
    l_target_type mgmt_targets.target_type%TYPE;
    l_adj_sysdate DATE;
    l_avail_exist NUMBER := 0;
    l_forward BOOLEAN := false;
    l_error_on_overlap_time BOOLEAN;
  BEGIN

    l_error_on_overlap_time := IS_ERROR_ON_OVERLAP_TIME() ;

    IF l_error_on_overlap_time THEN
      EXECUTE IMMEDIATE 'ALTER SESSION SET ERROR_ON_OVERLAP_TIME=FALSE'; 
    END IF;

    BEGIN
      SELECT timezone_region, target_type
        INTO l_curr_tzrgn, l_target_type
        FROM mgmt_targets
       WHERE target_guid = p_target_guid;
    EXCEPTION
      WHEN OTHERS THEN
        raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR, 'Invalid target guid = ' || 
	  p_target_guid);
    END;

    l_sysdate := SYSDATE;
    l_adj_sysdate := MGMT_GLOBAL.ADJUST_TZ(l_sysdate, l_curr_tzrgn, p_timezone_region);

    IF(l_adj_sysdate > l_sysdate) THEN 
      l_forward := TRUE;
    ELSE
      l_forward := FALSE; 
    END IF; 

    BEGIN 
      SELECT count(*)
        INTO l_avail_exist
        FROM MGMT_CURRENT_AVAILABILITY
       WHERE target_guid = p_target_guid;    
    EXCEPTION
      WHEN NO_DATA_FOUND THEN 
        NULL;
    END;
    -- Fix availability
    IF (l_avail_exist != 0 ) THEN
      -- Get availability lock for the target
      EM_SEVERITY.lock_avail_for_tgt(p_target_guid);

      -- Availability History 
      update_tzrgn_for_avail(p_target_guid, l_curr_tzrgn, p_timezone_region, l_forward);

    END IF;

    -- Fix Violations
    -- update mgmt_violations mgmt_violation_context and mgmt_current_violation
    update_tzrgn_for_violations(p_target_guid, l_curr_tzrgn, p_timezone_region, l_forward);

    -- If a callback is implemented, invoke the callbacks here to 
    -- reflect changes related to the timezone region change.
    exec_tzrgn_update_callbacks(
        p_target_guid => p_target_guid,
        p_target_type => l_target_type,
        p_old_tzrgn   => l_curr_tzrgn,
        p_new_tzrgn   => p_timezone_region);

    -- Finally, update the timezone region in the mgmt_targets table
    -- Need to set this flag, so that the timezone region column on the 
    -- target can be updated.
    EMD_LOADER.set_tzrgn_change;

    UPDATE mgmt_targets
       SET timezone_region = p_timezone_region
     WHERE target_guid = p_target_guid;

    EMD_LOADER.clear_tzrgn_change;

    IF l_error_on_overlap_time THEN
      EXECUTE IMMEDIATE 'ALTER SESSION SET ERROR_ON_OVERLAP_TIME=TRUE'; 
    END IF;

  END set_target_tzrgn;

  PROCEDURE update_tzrgn_for_violations(p_target_guid RAW,
                                        p_curr_tzrgn VARCHAR2,
                                        p_new_tzrgn VARCHAR2,
                                        p_forward BOOLEAN)
  IS
    l_viol_guids EMD_LOADER.p_guid_list_type;
    l_policy_guids EMD_LOADER.p_MetricGUIDList;
    l_key_values EMD_LOADER.p_keyValueList;
    l_orig_coll_date EMD_LOADER.p_date_list_type;
    l_coll_date EMD_LOADER.p_date_list_type; 

    l_rev_viol_guids EMD_LOADER.p_guid_list_type;
    l_rev_policy_guids EMD_LOADER.p_MetricGUIDList;
    l_rev_key_values EMD_LOADER.p_keyValueList;
    l_rev_orig_coll_date EMD_LOADER.p_date_list_type;
    l_rev_coll_date EMD_LOADER.p_date_list_type;

    -- to update last and current violation table
    l_curr_cnt NUMBER; 
    l_curr_viol_guids EMD_LOADER.p_guid_list_type;
    l_curr_coll_date EMD_LOADER.p_date_list_type;
    l_curr_policy_guids EMD_LOADER.p_MetricGUIDList;
    l_curr_key_values EMD_LOADER.p_keyValueList;
    l_curr_orig_coll_date EMD_LOADER.p_date_list_type;

    l_prev_policy_guid RAW(16) := NULL;
    l_perv_key_value   VARCHAR2(256) := NULL;

    l_curr_rec_date DATE := NULL; 
    l_prev_rec_date DATE := NULL; 
    l_cnt NUMBER;
    
  BEGIN

    SELECT violation_guid, policy_guid, key_value,  
           collection_timestamp coll_date, collection_timestamp orig_coll_date 
      BULK COLLECT INTO l_viol_guids, l_policy_guids, l_key_values, 
                        l_coll_date, l_orig_coll_date
      FROM mgmt_violations 
     WHERE target_guid = p_target_guid 
     ORDER BY policy_guid, key_value, collection_timestamp;

    IF (l_viol_guids IS NOT NULL AND l_viol_guids.count > 0) THEN
      l_cnt := l_viol_guids.COUNT + 1;
      FOR i IN 1..l_viol_guids.count
      LOOP

        IF(l_prev_policy_guid IS NOT NULL AND 
           l_perv_key_value IS NOT NULL AND 
           (l_prev_policy_guid != l_policy_guids(i) OR l_perv_key_value != l_key_values(i))
           )
        THEN 
          l_prev_rec_date := NULL;

          -- we will use these set of array to update
          -- last and current violation table
          l_curr_cnt := l_curr_viol_guids.COUNT + 1;
          l_curr_viol_guids(l_curr_cnt) := l_viol_guids(i - 1) ;
          l_curr_policy_guids(l_curr_cnt) := l_policy_guids(i - 1);
          l_curr_key_values(l_curr_cnt) := l_key_values(i - 1);
          l_curr_coll_date(l_curr_cnt) := l_coll_date(i - 1);
          l_curr_orig_coll_date(l_curr_cnt) := l_orig_coll_date(i - 1);
        END IF;    

        l_curr_rec_date := ADJUST_TZ(l_coll_date(i),
                                     p_curr_tzrgn,
                                     p_new_tzrgn);

        IF(l_prev_rec_date IS NOT NULL AND l_prev_rec_date >= l_curr_rec_date) THEN
          IF (l_orig_coll_date(i - 1) = l_orig_coll_date(i)) THEN
            l_curr_rec_date := l_prev_rec_date;
          ELSE
            l_curr_rec_date := l_prev_rec_date + 1/(24*60*60);
          END IF;

          -- Calling this to make sure that new time which is being computed 
          -- after adding 1 sec is valid time in new tzr
          l_curr_rec_date := ADJUST_TZ(l_curr_rec_date,
                                     p_new_tzrgn,
                                     p_new_tzrgn);
        END IF;

        l_coll_date(i)  :=  l_curr_rec_date;
        l_prev_rec_date :=  l_curr_rec_date;

        IF(p_forward)
        THEN -- reverse the list as updating in ascending order can lead to PK violation.
          l_rev_viol_guids(l_cnt - i) := l_viol_guids(i);
          l_rev_policy_guids(l_cnt - i) := l_policy_guids(i);
          l_rev_key_values(l_cnt - i) := l_key_values(i);
          l_rev_orig_coll_date(l_cnt - i) := l_orig_coll_date(i);
          l_rev_coll_date(l_cnt - i) := l_coll_date(i);
        END IF;

        l_prev_policy_guid := l_policy_guids(i);
        l_perv_key_value   := l_key_values(i);

      END LOOP;
      l_curr_cnt := l_curr_viol_guids.COUNT + 1;
      l_curr_viol_guids(l_curr_cnt) := l_viol_guids(l_cnt - 1) ;
      l_curr_policy_guids(l_curr_cnt) := l_policy_guids(l_cnt - 1);
      l_curr_key_values(l_curr_cnt) := l_key_values(l_cnt - 1);
      l_curr_coll_date(l_curr_cnt) := l_coll_date(l_cnt - 1);
      l_curr_orig_coll_date(l_curr_cnt) := l_orig_coll_date(l_cnt - 1);
        
      IF(p_forward)
      THEN
        FORALL i IN l_rev_viol_guids.FIRST..l_viol_guids.LAST
        UPDATE MGMT_VIOLATIONS
           SET collection_timestamp = l_rev_coll_date(i)
         WHERE violation_guid = l_rev_viol_guids(i);

        FORALL i IN l_rev_policy_guids.FIRST..l_rev_policy_guids.LAST
        UPDATE MGMT_VIOLATION_CONTEXT
           SET collection_timestamp = l_rev_coll_date(i)
         WHERE target_guid = p_target_guid
           AND policy_guid = l_rev_policy_guids(i)
           AND key_value   = l_rev_key_values(i)
           AND collection_timestamp = l_rev_orig_coll_date(i);
      ELSE   
        FORALL i IN l_viol_guids.FIRST..l_viol_guids.LAST
        UPDATE MGMT_VIOLATIONS
           SET collection_timestamp = l_coll_date(i)
         WHERE violation_guid = l_viol_guids(i);

        FORALL i IN l_policy_guids.FIRST..l_policy_guids.LAST
        UPDATE MGMT_VIOLATION_CONTEXT
           SET collection_timestamp = l_coll_date(i)
         WHERE target_guid = p_target_guid
           AND policy_guid = l_policy_guids(i)
           AND key_value   = l_key_values(i)
           AND collection_timestamp = l_orig_coll_date(i);
      END IF;

      FORALL i IN l_curr_viol_guids.FIRST..l_curr_viol_guids.LAST
      UPDATE mgmt_current_violation 
         SET collection_timestamp = l_curr_coll_date(i)
      WHERE violation_guid = l_curr_viol_guids(i);

      FORALL i IN l_curr_policy_guids.FIRST..l_curr_policy_guids.LAST
      UPDATE mgmt_last_violation 
         SET collection_timestamp = l_curr_coll_date(i)
       WHERE target_guid = p_target_guid
           AND policy_guid = l_curr_policy_guids(i)
           AND key_value = l_curr_key_values(i)
           AND collection_timestamp = l_curr_orig_coll_date(i);

    END IF; 
  END update_tzrgn_for_violations;

  PROCEDURE update_tzrgn_for_avail(p_target_guid RAW,
                                   p_curr_tzrgn VARCHAR2,
                                   p_new_tzrgn VARCHAR2,
                                   p_forward BOOLEAN)
  IS
    l_orig_start_date EMD_LOADER.p_date_list_type;
    l_start_date EMD_LOADER.p_date_list_type;
    l_end_date EMD_LOADER.p_date_list_type;
    l_status EMD_LOADER.p_number_list_type;

    l_rev_orig_start_date EMD_LOADER.p_date_list_type;
    l_rev_start_date EMD_LOADER.p_date_list_type;
    l_rev_end_date EMD_LOADER.p_date_list_type;
    l_rev_status EMD_LOADER.p_number_list_type;

    l_curr_start_date DATE := NULL;
    l_prev_start_date DATE := NULL;

    l_curr_end_date DATE := NULL;
    l_prev_end_date DATE := NULL;
    l_cnt NUMBER;
  BEGIN
      -- Availability marker
      UPDATE mgmt_availability_marker
         SET marker_timestamp = MGMT_GLOBAL.ADJUST_TZ(marker_timestamp,
                                                      p_curr_tzrgn,
                                                      p_new_tzrgn)
       WHERE target_guid = p_target_guid;

      -- Fix ping
      -- NOTE: Only successful update will be for the agent
      UPDATE mgmt_emd_ping
         SET last_heartbeat_ts = MGMT_GLOBAL.ADJUST_TZ(last_heartbeat_ts,
                                                       p_curr_tzrgn,
                                                       p_new_tzrgn),
             unrch_start_ts = MGMT_GLOBAL.ADJUST_TZ(unrch_start_ts,
                                                       p_curr_tzrgn,
                                                       p_new_tzrgn)
       WHERE target_guid = p_target_guid;

    SELECT current_status, 
           start_collection_timestamp start_date, start_collection_timestamp orig_start_date, 
           end_collection_timestamp
      BULK COLLECT INTO l_status, l_start_date, l_orig_start_date, l_end_date
      FROM mgmt_availability
     WHERE target_guid = p_target_guid
     ORDER BY start_collection_timestamp, NVL(end_collection_timestamp, TO_DATE('2100-12-31','YYYY-MM-DD'));

    IF (l_status IS NOT NULL AND l_status.count > 0) THEN
      l_cnt := l_status.COUNT + 1;
      FOR i IN 1..l_status.count
      LOOP
        l_curr_start_date := ADJUST_TZ(l_start_date(i),
                                       p_curr_tzrgn,
                                       p_new_tzrgn);

        l_curr_end_date := ADJUST_TZ(l_end_date(i),
                                     p_curr_tzrgn,
                                     p_new_tzrgn);

        IF(l_prev_end_date IS NOT NULL AND l_prev_end_date > l_curr_start_date)
        THEN
          l_curr_start_date := l_prev_end_date;
        END IF;

        IF ((l_curr_end_date IS NOT NULL) AND (l_curr_end_date <= l_curr_start_date)) THEN
          -- if original start and end date are same then donot increment the end time by 1 sec  
          IF (l_end_date(i) != l_orig_start_date(i)) THEN
            l_curr_end_date := l_curr_start_date + 1/(24*60*60);

            -- Calling this to make sure that new time which is being computed 
            -- after adding 1 sec is valid time in new tzr
            l_curr_end_date := ADJUST_TZ(l_curr_end_date,
                                         p_new_tzrgn,
                                         p_new_tzrgn);
          ELSE
            l_curr_end_date := l_curr_start_date;
          END IF;
        END IF;

        l_start_date(i)   :=  l_curr_start_date;
        l_end_date(i)     :=  l_curr_end_date;          
        l_prev_start_date :=  l_curr_start_date;
        l_prev_end_date   :=  l_curr_end_date;

        IF(p_forward)
        THEN -- reverse the list as updating in ascending order can lead to PK violation.
          l_rev_status(l_cnt - i ) := l_status(i);
          l_rev_orig_start_date(l_cnt - i) := l_orig_start_date(i);
          l_rev_start_date(l_cnt - i) := l_start_date(i);
          l_rev_end_date(l_cnt -i) := l_end_date(i);
        END IF;
      END LOOP;

      IF(p_forward)
      THEN
        FORALL i IN l_rev_status.FIRST..l_rev_status.LAST
        UPDATE MGMT_AVAILABILITY
           SET start_collection_timestamp = l_rev_start_date(i),
               end_collection_timestamp = l_rev_end_date(i)
         WHERE target_guid = p_target_guid
           AND current_status = l_rev_status(i)
           AND start_collection_timestamp = l_rev_orig_start_date(i);
      ELSE
        FORALL i IN l_status.FIRST..l_status.LAST
        UPDATE MGMT_AVAILABILITY
           SET start_collection_timestamp = l_start_date(i),
               end_collection_timestamp = l_end_date(i)
         WHERE target_guid = p_target_guid
           AND current_status = l_status(i)
           AND start_collection_timestamp = l_orig_start_date(i);
      END IF;
   
      UPDATE mgmt_current_availability
         SET start_collection_timestamp = l_start_date(l_cnt - 1)
      WHERE target_guid = p_target_guid;

    END IF;
  END update_tzrgn_for_avail;


  FUNCTION ADJUST_TZ(p_in_date DATE,
                     p_curr_tzrgn VARCHAR2,
                     p_new_tzrgn VARCHAR2)
  RETURN DATE
  IS
   l_ret_date DATE; 
   INVALID_TIME EXCEPTION;
   -- ORA-01878: specified field not found in datetime or interval
   PRAGMA EXCEPTION_INIT (INVALID_TIME,-1878); 
  BEGIN
    BEGIN
      l_ret_date :=  MGMT_GLOBAL.ADJUST_TZ(p_in_date,
                                           p_curr_tzrgn,
                                           p_new_tzrgn);
    EXCEPTION 
    WHEN INVALID_TIME THEN
    l_ret_date :=  MGMT_GLOBAL.ADJUST_TZ((trunc(p_in_date,'HH24') + 1/24),
                                         p_curr_tzrgn,
                                         p_new_tzrgn);
    END;
    return l_ret_date;
  END ADJUST_TZ;

  -- to check if flag ERROR_ON_OVERLAP_TIME is set 
  -- to true or false
  FUNCTION IS_ERROR_ON_OVERLAP_TIME RETURN BOOLEAN
  IS
    l_ret_val BOOLEAN;
    l_date DATE;
  BEGIN
   BEGIN
     SELECT MGMT_GLOBAL.ADJUST_TZ( to_date('30-OCT-05 01:30:39','DD-MON-YY HH24:MI:SS'),
                                           'US/Pacific','US/Pacific'
                                 )
       INTO l_date
       FROM DUAL;
     l_ret_val :=  FALSE;
   EXCEPTION
     WHEN OTHERS THEN
     l_ret_val :=  TRUE;
   END;
   RETURN l_ret_val;
  END IS_ERROR_ON_OVERLAP_TIME;

  FUNCTION get_targets_for_agent
  (
    p_target_name mgmt_targets.target_name%TYPE,
    p_target_type mgmt_targets.target_type%TYPE
  )RETURN SMP_EMD_TGT_OBJECT_TBL
  IS
    l_distinct_targets SMP_EMD_TGT_OBJECT_TBL := new SMP_EMD_TGT_OBJECT_TBL();
    l_targets SMP_EMD_TGT_OBJECT_TBL := new SMP_EMD_TGT_OBJECT_TBL();
    l_member_targets SMP_EMD_TGT_OBJECT_TBL := new SMP_EMD_TGT_OBJECT_TBL();
    l_empty_parent_targets SMP_EMD_TGT_OBJECT_TBL := new SMP_EMD_TGT_OBJECT_TBL();
  BEGIN

    IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('get_targets_for_agent:Entry',MODULE_NAME);
    END IF;

    -- Find all the targets monitored by this agent which are not cluster
/*
    SELECT SMP_EMD_TGT_OBJECT(target_name, target_type, target_guid, null, null, null)
      BULK COLLECT INTO l_targets
      FROM (SELECT DISTINCT st.target_name, st.target_type, st.target_guid
              FROM mgmt_target_assocs a,
                   mgmt_targets st,
                   mgmt_targets at
             WHERE a.assoc_guid = MGMT_ASSOC.g_monitored_by_guid
               AND at.target_name = p_target_name
               AND at.target_type = p_target_type
               AND a.assoc_target_guid = at.target_guid
               AND st.target_guid = a.source_target_guid 
               AND st.target_guid NOT IN ( SELECT t.target_guid
                                             FROM mgmt_targets t,
                                                  mgmt_type_properties p
                                            WHERE p.target_type = t.target_type
                                              AND p.property_name = MGMT_GLOBAL.G_IS_CLUSTER_PROP));
*/

    SELECT SMP_EMD_TGT_OBJECT(at.target_name, at.target_type, at.target_guid, null, null, null)
      BULK COLLECT INTO l_targets
      FROM mgmt_targets at,
           mgmt_targets t
     WHERE t.target_name = p_target_name
       AND t.target_type = p_target_type
       AND t.emd_url = at.emd_url
       AND NOT EXISTS ( SELECT NULL
                          FROM mgmt_type_properties p
                         WHERE p.target_type = at.target_type
                           AND p.property_name = MGMT_GLOBAL.G_IS_CLUSTER_PROP);

    -- Add agent to the collection ;
    l_targets.extend();
    l_targets(l_targets.LAST) := NEW SMP_EMD_TGT_OBJECT( p_target_name, 
                                                         p_target_type,
                                                         mgmt_target.get_target_guid(p_target_name, p_target_type), null, null, null);
      
    -- Add cluster target to be deleted 
    SELECT SMP_EMD_TGT_OBJECT(target_name, target_type, target_guid, null, null, null)
      BULK COLLECT INTO l_empty_parent_targets
      FROM (SELECT /*+CARDINALITY(t 50) */ DISTINCT ct.target_name, ct.target_type, ct.target_guid 
              FROM  TABLE(CAST(l_targets AS SMP_EMD_TGT_OBJECT_TBL)) t, 
                    mgmt_targets ct, 
                    mgmt_flat_target_assoc m, 
                    mgmt_type_properties p
             WHERE t.target_guid = m.assoc_target_guid
               AND m.source_target_guid = ct.target_guid
               AND m.is_membership = 1
               AND ct.target_type = p.target_type
               AND p.property_name = MGMT_GLOBAL.G_IS_CLUSTER_PROP
               AND NOT EXISTS( SELECT om.assoc_target_guid
                                 FROM MGMT_FLAT_TARGET_ASSOC om 
                                WHERE ct.target_guid = om.SOURCE_TARGET_GUID
                                  AND om.is_membership = 1
                                MINUS
                                SELECT /*+CARDINALITY(s 50)*/ s.target_guid
                                  FROM TABLE(CAST(l_targets AS SMP_EMD_TGT_OBJECT_TBL)) s));


    FOR i IN 1..l_empty_parent_targets.count
    LOOP
      l_targets.extend;
      l_targets(l_targets.LAST) := l_empty_parent_targets(i);
    END LOOP;

    IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('Got'||l_targets.COUNT||' targets.',MODULE_NAME);
    END IF;

    IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('get_targets_for_agent:Exit',MODULE_NAME);
    END IF;

    return l_targets;

  END get_targets_for_agent;



  PROCEDURE submit_delete_agent_job
  (
    p_target_name VARCHAR2,
    p_target_type VARCHAR2,
    l_target_names_array MGMT_JOB_VECTOR_PARAMS,
    l_target_types_array MGMT_JOB_VECTOR_PARAMS
  )
  IS
  l_job_params MGMT_JOB_PARAM_LIST;
  l_job_targets MGMT_JOB_TARGET_LIST;
  l_schedule MGMT_JOB_SCHEDULE_RECORD;
  l_job_name VARCHAR2(64);
  l_job_id RAW(16);
  l_execution_id RAW(16);
  l_delete_members VARCHAR2(10) := 'false';
  l_force_delete VARCHAR2(10) := 'false';
  BEGIN

    -- This job has no targets.
    l_job_targets := MGMT_JOB_TARGET_LIST();

    l_job_params := MGMT_JOB_PARAM_LIST();
    l_job_params.extend(4);
    l_job_params(1) := MGMT_JOB_PARAM_RECORD('agentTargetName', 1,
                                             p_target_name, null);
    l_job_params(2) := MGMT_JOB_PARAM_RECORD('agentTargetType', 1,
                                             p_target_type, null);
    l_job_params(3) := MGMT_JOB_PARAM_RECORD('affectedTargetNames', 0,
                                              null, l_target_names_array);
    l_job_params(4) := MGMT_JOB_PARAM_RECORD('affectedTargetTypes', 0,
                                              null, l_target_types_array);

    -- Its schedule is immediate.
    l_schedule := MGMT_JOBS.get_job_schedule_record(MGMT_JOBS.ONE_TIME_FREQUENCY_CODE,
                                           SYSDATE, null, 0, 0, 0, null, null,
                                           MGMT_JOBS.TIMEZONE_REPOSITORY,
                                           0, 0, null);

    l_job_name := 'DELAGNTTGT_JOB_' || SYS_GUID();

    -- Submit the job as a system job so that system thread pool is used
    MGMT_JOBS.submit_job(l_job_name,
                        'This is a delete agent target job',
                        'DeleteAgentTargetJob',
                        l_job_targets,
                        l_job_params,
                        l_schedule,
                        l_job_id,
                        l_execution_id,
                        null,
                        MGMT_JOB_ENGINE.SYSTEM_JOB_RETRY);

  END;

  -- Procedure to delete a host and all the targets hosted on it.
  PROCEDURE delete_agent_target
  (
    p_target_name IN mgmt_targets.target_name%TYPE,
    p_target_type IN mgmt_targets.target_type%TYPE,
    p_raise_composite_error IN BOOLEAN,
    p_delete_members IN BOOLEAN DEFAULT FALSE,
    p_delete_sync IN BOOLEAN DEFAULT FALSE
  ) 
  IS
    l_current_user mgmt_targets.owner%TYPE := MGMT_USER.get_current_em_user;
    l_emd_url mgmt_targets.emd_url%TYPE;
    l_guid_cursor MGMT_USER.GUID_CURSOR;
    l_target_guid  mgmt_targets.target_guid%TYPE;
    l_target_count NUMBER := 0;
    l_target_guids MGMT_USER_GUID_ARRAY := NEW MGMT_USER_GUID_ARRAY();
    l_target_nvpair_array SMP_EMD_NVPAIR_ARRAY := NEW SMP_EMD_NVPAIR_ARRAY();
    l_target_names_array MGMT_JOB_VECTOR_PARAMS := NEW MGMT_JOB_VECTOR_PARAMS();
    l_target_types_array MGMT_JOB_VECTOR_PARAMS := NEW MGMT_JOB_VECTOR_PARAMS();
    l_targets SMP_EMD_TGT_OBJECT_TBL:= NEW SMP_EMD_TGT_OBJECT_TBL();
  BEGIN
    IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('delete_agent_target:Entry',MODULE_NAME);
    END IF;
    -- check info about the target
    BEGIN
      SELECT target_guid, emd_url
        INTO l_target_guid, l_emd_url
        FROM mgmt_targets 
       WHERE target_name = p_target_name
         AND target_type = p_target_type;

    EXCEPTION
      WHEN NO_DATA_FOUND THEN
        -- Target does not exist in targets table, check in mgmt_targets_delete
        BEGIN
          SELECT target_guid, emd_url
            INTO l_target_guid, l_emd_url
            FROM mgmt_targets_delete 
           WHERE target_name = p_target_name
             AND target_type = p_target_type
	     AND delete_complete_time IS NULL;

          raise_application_error(MGMT_GLOBAL.TARGET_BEING_DELETED_ERR,
                                 'Target ' || p_target_name || ':' || p_target_type ||
                                 ' is currently in the process of being deleted');
        EXCEPTION
          WHEN NO_DATA_FOUND THEN
            raise_application_error(MGMT_GLOBAL.TARGET_DOES_NOT_EXIST_ERR, 
	                            MGMT_GLOBAL.TARGET_DOES_NOT_EXIST_ERR_M);
        END;
    END;

    -- Switch the master agent for multi-agent targets if necessary
    em_master_agent.process_agent_deletion(l_target_guid);
  
    
    -- Delete duplicate targets..
    DELETE FROM MGMT_DUPLICATE_TARGETS WHERE duplicate_emd_url = l_emd_url;

    -- Get all the targets that has to deleted 
    l_targets := get_targets_for_agent(p_target_name,
                                       p_target_type);

    l_target_guids.extend(l_targets.COUNT);
    FOR i IN 1..l_targets.COUNT
    LOOP
      l_target_guids(i) := l_targets(i).target_guid;
    END LOOP;

    -- The user issuing this call must have FULL privilege on all the targets 

    l_guid_cursor := MGMT_USER.has_priv(l_current_user,MGMT_USER.FULL_TARGET,l_target_guids);

    FETCH l_guid_cursor INTO l_target_guid;
    WHILE l_guid_cursor%FOUND
    LOOP
      l_target_count := l_target_count + 1;
      FETCH l_guid_cursor INTO l_target_guid;
    END LOOP;
    CLOSE l_guid_cursor;

    IF (l_target_count != l_targets.count) THEN
      raise_application_error(MGMT_GLOBAL.INSUFFICIENT_PRIVILEGES_ERR,
        'The current user does not have sufficient privileges to perform this action');
    END IF;

    -- Merge the targets into mgmt_target_delete 
    MERGE 
     INTO mgmt_targets_delete dt
    USING (SELECT DISTINCT 
                  t.target_name target_name,
                  t.target_type target_type, 
                  t.target_guid target_guid, 
                  t.emd_url emd_url, 
                  t.timezone_region timezone_region, 
                  NULL delete_complete_time
             FROM TABLE(CAST(l_target_guids AS MGMT_TARGET_GUID_ARRAY)) st,
                  mgmt_targets t
            WHERE t.target_guid = st.column_value
          ) v
       ON (dt.target_guid = v.target_guid )
     WHEN MATCHED THEN
       UPDATE SET dt.emd_url = v.emd_url,
                  dt.timezone_region = v.timezone_region, 
                  dt.delete_request_time = MGMT_GLOBAL.sysdate_tzrgn(v.timezone_region) ,
                  dt.delete_complete_time = v.delete_complete_time
     WHEN NOT MATCHED THEN 
       INSERT
             (target_name, target_type, target_guid, emd_url, 
              timezone_region, delete_request_time, delete_complete_time)
       VALUES
             (v.target_name, v.target_type, v.target_guid,
              v.emd_url, v.timezone_region,
             MGMT_GLOBAL.sysdate_tzrgn(v.timezone_region) , v.delete_complete_time
             );

    -- add one loaded api for bulk callbacks  
    -- execute pre delete callbacks 
--    l_target_nvpair_array.extend(l_targets.count);
    l_target_names_array.extend(l_targets.count);
    l_target_types_array.extend(l_targets.count);

    FOR i IN 1..l_targets.count
    LOOP
--      l_target_nvpair_array(i) := new SMP_EMD_NVPAIR(l_targets(i).target_name, l_targets(i).target_type);
      l_target_names_array(i) := l_targets(i).target_name;
      l_target_types_array(i) := l_targets(i).target_type;
      IF (emdw_log.p_is_info_set)THEN
        emdw_log.info('Entered Values into l_target_names_array :'||l_target_names_array(i), MODULE_NAME);
      END IF;
    END LOOP;
    
    exec_tgt_pre_del_callbacks(l_targets);

    -- Remove the entries for the targets from the target table 
     DELETE 
       FROM mgmt_targets 
      WHERE target_guid IN (SELECT * 
                              FROM TABLE(CAST(l_target_guids AS MGMT_USER_GUID_ARRAY))
                           ); 

    -- Submit a job to continue with the deletion
    IF p_delete_sync = FALSE THEN
      IF (emdw_log.p_is_info_set)THEN
        emdw_log.info('Submitting delete_host_job ',MODULE_NAME);
      END IF;
      submit_delete_agent_job(p_target_name, p_target_type,
                             l_target_names_array, l_target_types_array);

    ELSE 
      COMMIT;
      -- Delete the target synchronously
      delete_agent_target_internal(p_target_name, p_target_type, l_target_names_array, l_target_types_array);

      -- Delete the mgmt_targets_delete entries also.
      DELETE 
        FROM mgmt_targets_delete 
       WHERE target_guid IN (SELECT * 
                             FROM TABLE(CAST(l_target_guids AS MGMT_USER_GUID_ARRAY))
                            );

    END IF;

    IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('delete_agent_target:Exit',MODULE_NAME);
    END IF;
  END delete_agent_target; 

  -- Actually delete the host target from the repository. This should
  -- never be called externally. It is only called from the system
  -- job that deletes the target from the emd   
  PROCEDURE delete_agent_target_internal
  (
    p_target_name IN mgmt_targets.target_name%TYPE,
    p_target_type IN mgmt_targets.target_type%TYPE,
    p_member_target_names IN MGMT_JOB_VECTOR_PARAMS,
    p_member_target_types IN MGMT_JOB_VECTOR_PARAMS
  )
  IS
    l_counter INTEGER :=0;
    l_current_user VARCHAR2(256) := MGMT_USER.GET_CURRENT_EM_USER;
    l_del_complete_time mgmt_targets_delete.delete_complete_time%TYPE;
    l_delete_stmt VARCHAR2(4000);
    l_member_targets_array SMP_EMD_NVPAIR_ARRAY := SMP_EMD_NVPAIR_ARRAY();
    l_targets SMP_EMD_TGT_OBJECT_TBL:= NEW SMP_EMD_TGT_OBJECT_TBL();
    l_target_guid mgmt_targets.target_guid%TYPE;
    l_target_guids MGMT_TARGET_GUID_ARRAY := NEW MGMT_TARGET_GUID_ARRAY();
    l_target_guids_list VARCHAR2(32767) := '';
    l_timezone_rgn mgmt_targets.timezone_region%TYPE;

  BEGIN

    IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('delete_agent_target_internal:Entry',MODULE_NAME);
    END IF;

    -- Ensure that the caller is a super-user.
    IF MGMT_USER.has_priv(l_current_user, 'SUPER_USER') = 0 THEN
      raise_application_error(MGMT_GLOBAL.INSUFFICIENT_PRIVILEGES_ERR,
       'Only superusers can call delete_agent_target_internal');
    END IF;

    IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('Passed User Check',MODULE_NAME);
    END IF;

    BEGIN
      SELECT timezone_region, target_guid
        INTO l_timezone_rgn, l_target_guid
        FROM mgmt_targets_delete 
       WHERE target_name = p_target_name 
         AND target_type = p_target_type
         AND delete_complete_time IS NULL;
    EXCEPTION
      WHEN NO_DATA_FOUND THEN
        raise_application_error(MGMT_GLOBAL.TARGET_DOES_NOT_EXIST_ERR,
          ' The target does not exist or may have already been deleted: '||
          ' Target name = ' || p_target_name || 
          ' and Target type = ' || p_target_type);   
    END;

    l_del_complete_time := MGMT_GLOBAL.SYSDATE_TZRGN(l_timezone_rgn);

    l_member_targets_array.extend(p_member_target_names.COUNT);
    FOR i IN 1..p_member_target_names.COUNT
    LOOP
      l_member_targets_array(i) := NEW SMP_EMD_NVPAIR(p_member_target_names(i), p_member_target_types(i));
      IF (emdw_log.p_is_info_set)THEN
        emdw_log.info('Inserted value into l_member_targets_array'||l_member_targets_array(i).name||l_member_targets_array(i).value,MODULE_NAME);
      END IF;
    END LOOP;

    SELECT SMP_EMD_TGT_OBJECT(m.name, m.value, t.target_guid, null, null, null) BULK COLLECT
      INTO l_targets
      FROM TABLE(CAST(l_member_targets_array AS SMP_EMD_NVPAIR_ARRAY))m,
           mgmt_targets_delete t
     WHERE t.target_name = m.name 
       AND t.target_type = m.value;

    l_target_guids.extend(l_targets.COUNT);
    FOR i IN 1..l_targets.COUNT
    LOOP
      IF (i = l_targets.COUNT) THEN
        l_target_guids_list := l_target_guids_list || 'HEXTORAW('''||l_targets(i).target_guid||''') ';
      ELSE
        l_target_guids_list := l_target_guids_list || 'HEXTORAW('''||l_targets(i).target_guid||'''), ';
      END IF;
        l_target_guids(i) := l_targets(i).target_guid;
    END LOOP;
  
    FOR crec IN ( SELECT o.name table_name , c.name column_name
                    FROM sys.obj$ o, sys.tab$ t ,sys.col$ c
                   WHERE o.owner# = userenv('SCHEMAID')
                     AND c.name like ('%TARGET_GUID%')
                     AND c.obj# = o.obj#
                     AND (o.name like ('MGMT_%') OR o.name like ('OCS_%'))
                     AND o.obj# = t.obj#
                     AND bitand(t.property, 1) = 0
                     AND bitand(c.property,32) = 0
                     AND bitand(c.property,512) = 0
                     AND o.name NOT IN  (SELECT table_name
                                           FROM MGMT_TARGET_DELETE_EXCEPTIONS)
                   ORDER BY o.name
                )
    LOOP
      l_delete_stmt := 'DELETE FROM ' || DBMS_ASSERT.ENQUOTE_NAME(crec.table_name,FALSE) || 
                       ' WHERE ' || DBMS_ASSERT.ENQUOTE_NAME(crec.column_name,FALSE) || ' IN ('||l_target_guids_list||') '||
                       '   AND ROWNUM <= '||mgmt_global.MAX_COMMIT;
    LOOP
      EXECUTE IMMEDIATE l_delete_stmt;
      l_counter := SQL%ROWCOUNT;
      COMMIT;        
      IF l_counter < mgmt_global.MAX_COMMIT THEN
        EXIT;
      END IF;

    END LOOP;
  END LOOP;

  --TODO Add overloaded procedures that take nvpair array
  IF (MGMT_ADMIN.is_metric_deletion_enabled > 0) THEN
    MGMT_ADMIN.delete_target_metrics_raw(l_target_guids);
    MGMT_ADMIN.delete_target_metrics_1hour(l_target_guids);
    MGMT_ADMIN.delete_target_metrics_1day(l_target_guids);
  END IF;

  -- save point..
  COMMIT;

    exec_tgt_post_del_callbacks(l_targets);
  COMMIT;

  FOR i IN 1..l_targets.COUNT
  LOOP
    -- Delete the targets_delete entry, as there is no agent to send
    -- data 
    DELETE FROM mgmt_targets_delete
     WHERE target_guid=l_targets(i).target_guid
       AND emd_url IS NULL;

    -- Do not delete the entry from mgmt_targets_delete 
    -- but set the delete completion timestamp
    -- This entry will be used by the loader to block any delayed data
    -- being loaded into the repository.
    -- Any data/severity/.. will be discarded if it is before the
    -- completion time
    -- We are using Agent completion time (which accounts
    -- for time skew also).
    -- This entry would be deleted when loader receives data from this agent
    -- 1 hr past the completion time 
    UPDATE mgmt_targets_delete
       SET delete_complete_time = l_del_complete_time
     WHERE target_guid=l_targets(i).target_guid
       AND emd_url IS NOT NULL;
  END LOOP;

  COMMIT;

   IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('delete_agent_target_internal:Exit',MODULE_NAME);
   END IF;

END delete_agent_target_internal;

  -- Target type related procedures

  --
  -- FUNCTION: generate_target_type_guid
  --
  -- PURPOSE: 
  --   Generates a guid for the target type
  FUNCTION generate_target_type_guid(p_target_type IN VARCHAR2)
      RETURN RAW IS
  BEGIN
    RETURN DBMS_OBFUSCATION_TOOLKIT.md5(
             input => UTL_RAW.cast_to_raw('ora$target_type' ||
                            ';'|| p_target_type));
  END generate_target_type_guid;
   

  --
  -- FUNCTION: generate_type_version_guid
  --
  -- PURPOSE: 
  --   Generates a guid for the target type version
  FUNCTION generate_type_ver_guid(p_target_type IN VARCHAR2,
                                  p_type_meta_ver IN VARCHAR2 DEFAULT '1.0')
      RETURN RAW IS
  BEGIN
    RETURN DBMS_OBFUSCATION_TOOLKIT.md5(
             input => UTL_RAW.cast_to_raw('ora$target_type_ver' ||
                            ';'|| p_target_type || ';' || p_type_meta_ver));
  END generate_type_ver_guid;


  --
  -- FUNCTION: compare_type_meta_vers
  --
  -- PURPOSE: 
  --   Compares two type_meta_vers and returns the bigger one
  -- NOTE : NULL for any of the meta version is treated as 1.0
  FUNCTION compare_type_meta_vers(p_type_meta_ver_1 IN VARCHAR2,
                                  p_type_meta_ver_2 IN VARCHAR2)
      RETURN NUMBER IS
    l_type_meta_ver_1 mgmt_targets.type_meta_ver%TYPE;
    l_type_meta_ver_2 mgmt_targets.type_meta_ver%TYPE;
    l_major_ver_1 NUMBER := 0;
    l_minor_ver_1 NUMBER := 0;
    l_major_ver_2 NUMBER := 0;
    l_minor_ver_2 NUMBER := 0;
    l_ver_numb_1  NUMBER := 0;
    l_ver_numb_2  NUMBER := 0;
    l_ret_value NUMBER := 0;
  BEGIN

    l_ver_numb_1 := type_meta_ver_to_num(p_type_meta_ver_1);
    l_ver_numb_2 := type_meta_ver_to_num(p_type_meta_ver_2);

    IF (l_ver_numb_1 > l_ver_numb_2) THEN
      l_ret_value := 1;
    ELSIF (l_ver_numb_1 < l_ver_numb_2) THEN
      l_ret_value := -1;
    ELSE
      l_ret_value := 0;
    END IF;

    RETURN l_ret_value;

  END compare_type_meta_vers;

  --
  -- FUNCTION: type_meta_ver_to_num
  --
  -- PURPOSE: 
  --   Converts the given type meta ver to number using the following:
  --   The number returned is 100000*maj_ver + min_ver
  FUNCTION type_meta_ver_to_num(p_type_meta_ver IN VARCHAR2)
    RETURN NUMBER IS
    l_type_meta_ver mgmt_targets.type_meta_ver%TYPE;
    l_minor_ver NUMBER := 0;
    l_major_ver NUMBER := 0;
    l_ret_numb  NUMBER := 0;
  BEGIN
    l_type_meta_ver := NVL(substr(p_type_meta_ver, 1, 8), '1.0');
    l_major_ver := TO_NUMBER( SUBSTR(l_type_meta_ver, 1, INSTR(l_type_meta_ver, '.') -1));
    l_minor_ver := TO_NUMBER( SUBSTR(l_type_meta_ver, INSTR(l_type_meta_ver, '.') + 1));

    l_ret_numb := (100000 * l_major_ver) + l_minor_ver;

    RETURN l_ret_numb;

  END type_meta_ver_to_num;

  -- Procedure to set repository time zone
  -- This should be set at the repository creation time and should never be changed after creation.

  PROCEDURE set_repository_timezone 
  (
    p_repo_timezone IN VARCHAR2
  )
  IS
  BEGIN 
    IF p_repo_timezone IS NULL THEN
      raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
                    'Repository timezone can not be set to NULL');
    END IF; 

    MERGE 
     INTO mgmt_parameters p
    USING (SELECT EM_REPOSITORY_TIMEZONE parameter_name, p_repo_timezone parameter_value FROM DUAL) p1
       ON (p.parameter_name = p1.parameter_name)
     WHEN MATCHED THEN 
       UPDATE 
          SET p.parameter_value = p1.parameter_value
     WHEN NOT MATCHED THEN
       INSERT (parameter_name, parameter_value, parameter_comment, internal_flag)
       VALUES (p1.parameter_name, p1.parameter_value, 'Repository timezone', 1) ;

  END set_repository_timezone; 

  --  Function to get repository time zone 

  FUNCTION get_repository_timezone RETURN VARCHAR2
  IS
    l_timezone MGMT_TARGETS.timezone_region%TYPE;
  BEGIN
    BEGIN
      SELECT parameter_value
        INTO l_timezone
        FROM mgmt_parameters
       WHERE parameter_name = EM_REPOSITORY_TIMEZONE ;
    EXCEPTION
      WHEN NO_DATA_FOUND THEN
      l_timezone := TO_CHAR(SYSTIMESTAMP,'TZR') ;
    END;
    RETURN l_timezone ;
  END get_repository_timezone;

  --
  -- FUNCTION:  get_factory_type
  --
  -- PURPOSE: 
  --   Returns the factory type for a given target_type
  -- IN parameters:
  --   p_target_type : Target type of the target
  -- OUT parameters:
  --   Retuns 0 if target_type is DEFAULT 
  --          1 if target_type is GROUP 
  --          2 if target_type is SYSTEM 
  -- ERROR CODES:
  --   None
  -- 
  FUNCTION get_factory_type(p_target_type IN VARCHAR2)
    RETURN NUMBER IS
  BEGIN

    IF (MGMT_TARGET.get_type_property(p_target_type,MGMT_GLOBAL.G_IS_AGGREGATE_SERVICE_PROP,0)=1) THEN
      RETURN AGG_SERVICE_FACTORY_TYPE;
    END IF;    


    IF (MGMT_TARGET.get_type_property(p_target_type,MGMT_GLOBAL.G_IS_SERVICE_PROP,0)=1) THEN
      RETURN SERVICE_FACTORY_TYPE;
    END IF;    

    IF (MGMT_TARGET.get_type_property(p_target_type,MGMT_GLOBAL.G_IS_CLUSTER_PROP,0)=1) THEN
      RETURN CLUSTER_FACTORY_TYPE;
    END IF;    

    IF (MGMT_TARGET.get_type_property(p_target_type,MGMT_GLOBAL.G_IS_GROUP_PROP,0)=1) THEN
      RETURN GROUP_FACTORY_TYPE;
    END IF;    

    IF (MGMT_TARGET.get_type_property(p_target_type,MGMT_GLOBAL.G_IS_COMPOSITE_PROP,0)=1) THEN
      RETURN COMPOSITE_FACTORY_TYPE;
    END IF;    

    IF (MGMT_TARGET.get_type_property(p_target_type,MGMT_GLOBAL.G_IS_SYSTEM_PROP,0)=1) THEN
      RETURN SYSTEM_FACTORY_TYPE;
    END IF;    

    RETURN DEFAULT_FACTORY_TYPE;

  END get_factory_type;  

  PROCEDURE check_is_def_target_factory
  (
    p_target_type IN mgmt_targets.target_type%TYPE
  )
  IS
   l_factory_type NUMBER(1); 
  BEGIN
    
    l_factory_type := get_factory_type(p_target_type);

    IF (l_factory_type = SYSTEM_FACTORY_TYPE) THEN
        raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
        'Use of inappropriate api to create/modify target, Use MGMT_SYSTEM.create_system or modify_system ');
    END IF;

    IF l_factory_type = AGG_SERVICE_FACTORY_TYPE THEN
        raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
        'Use of inappropriate api to create/modify target, Use MGMT_SERVICE.create_aggregate_service or modify_aggregate_service');
    END IF;

    IF l_factory_type = SERVICE_FACTORY_TYPE THEN
        raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
        'Use of inappropriate api to create/modify target, Use MGMT_SERVICE.create_service or modify_service');
    END IF;

    --IF l_factory_type = CLUSTER_FACTORY_TYPE THEN
    --    raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
    --    'Use of inappropriate api to create/modify target, Use MGMT_GROUP.add_red_group or modify_red_group');
    --END IF;

    IF l_factory_type = GROUP_FACTORY_TYPE THEN
        raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
        'Use of inappropriate api to create/modify target, Use MGMT_GROUP.create_group or modify_group');
    END IF;

  END check_is_def_target_factory;

  --
  -- Lock registration so that other sessions cannot register
  -- The same target type simultaneously
  --
  PROCEDURE get_type_registration_lock(p_target_type IN VARCHAR2) 
  IS
  l_lock_handle mgmt_lock_util.lock_handle_type ;
  BEGIN
    l_lock_handle := mgmt_lock_util.get_exclusive_lock
                       (p_lock_type=>MGMT_LOCK_UTIL.TARGET_TYPE_LOCK,
                        p_lock_value=>p_target_type,
                        p_timeout_secs=>3600) ; 
  END get_type_registration_lock ;

  -- PL/SQL Procedure used by loader to handle target type versions ROWSET
  PROCEDURE add_target_type_version
    (p_target_type           IN VARCHAR2,
     p_type_meta_ver         IN VARCHAR2 DEFAULT '1.0',
     p_type_display_name     IN VARCHAR2 DEFAULT NULL,
     p_type_display_nlsid    IN VARCHAR2 DEFAULT NULL,
     p_type_resource_bundle  IN VARCHAR2 DEFAULT NULL,
     p_target_type_ver_guid  IN RAW      DEFAULT NULL)
  IS
  BEGIN

    -- p_target_type_ver_guid is not being used.
    -- This GUID is calculated in the register_target_type API.

   BEGIN
     EM_TARGET.check_type_ver_guid
     (
       p_target_type => p_target_type,
       p_type_meta_ver => p_type_meta_ver
     );
   EXCEPTION  
     WHEN MGMT_GLOBAL.type_ver_not_exist THEN  
       MGMT_TARGET.register_target_type(
         p_target_type_in => p_target_type,
         p_type_meta_ver_in => p_type_meta_ver,
         p_type_display_name_in => p_type_display_name,
         p_type_display_nlsid_in => p_type_display_nlsid,
         p_type_resource_bundle_in => p_type_resource_bundle);
   END;

  END add_target_type_version;

  PROCEDURE add_target
  (
    p_target_guid OUT mgmt_targets.target_guid%TYPE, 
    p_target_name IN  mgmt_targets.target_name%TYPE,
    p_target_type IN  mgmt_targets.target_type%TYPE,
    p_host_name   IN  mgmt_targets.target_name%TYPE,
    p_properties  IN  MGMT_TARGET_PROPERTY_LIST
                        DEFAULT NULL,
    p_aggregates  IN  SMP_EMD_NVPAIR_ARRAY
                       DEFAULT NULL,
    p_monitoring_credentials IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL,
    p_target_display_name    IN mgmt_targets.display_name%TYPE 
                                  DEFAULT NULL,
    p_type_display_name      IN mgmt_targets.type_display_name%TYPE 
                                  DEFAULT NULL,
    p_agent_url       IN mgmt_targets.emd_url%TYPE 
                           DEFAULT NULL,
    p_tz_rgn          IN mgmt_targets.timezone_region%TYPE 
                           DEFAULT NULL, 
    p_mon_mode        IN mgmt_targets.monitoring_mode%TYPE 
                           DEFAULT MGMT_GLOBAL.G_MON_MODE_DEFAULT,
    p_type_meta_ver   IN VARCHAR2 
                           DEFAULT '1.0',
    p_category_prop_1 IN mgmt_targets.category_prop_1%TYPE
                           DEFAULT ' ',
    p_category_prop_2 IN mgmt_targets.category_prop_2%TYPE 
                           DEFAULT ' ',
    p_category_prop_3 IN mgmt_targets.category_prop_3%TYPE
                           DEFAULT ' ',
    p_category_prop_4 IN mgmt_targets.category_prop_4%TYPE
                           DEFAULT ' ',
    p_category_prop_5 IN mgmt_targets.category_prop_5%TYPE
                            DEFAULT ' ',
    p_repository_only_target   IN NUMBER 
                                    DEFAULT 0,
    p_target_owner             IN mgmt_targets.owner%TYPE
                                    DEFAULT NULL,
    p_is_group                 IN NUMBER 
                                    DEFAULT 0,
    p_required_parent_target_priv IN VARCHAR2 
                                    DEFAULT NULL,
    p_required_target_priv        IN VARCHAR2 
                                    DEFAULT NULL
  )
  IS
    l_agent_guid          MGMT_TARGETS.target_guid%TYPE;
    l_aggregate_guid      MGMT_TARGETS.target_guid%TYPE;

    l_current_user        VARCHAR2(256) := MGMT_USER.get_current_em_user;

    l_emd_url             MGMT_TARGETS.emd_url%TYPE;
    l_host_name           MGMT_TARGETS.host_name%TYPE;
    l_target_name         MGMT_TARGETS.target_name%TYPE := trim(p_target_name);
    l_target_owner        MGMT_TARGETS.owner%TYPE := nvl(p_target_owner,l_current_user);
    l_targets_to_add      SMP_EMD_NVPAIR_ARRAY;
    l_target_type         MGMT_TARGETS.target_type%TYPE := trim(p_target_type);
    l_target_display_name MGMT_TARGETS.display_name%TYPE := nvl(p_target_display_name,l_target_name);
    l_type_display_name   MGMT_TARGETS.display_name%TYPE := NULL;
    l_tzoffset            NUMBER := TO_NUMBER(TO_CHAR(SYSTIMESTAMP,'TZH'))* 60;
    l_tz_rgn              MGMT_TARGETS.timezone_region%TYPE := nvl(p_tz_rgn, get_repository_timezone);
    l_agent_name VARCHAR2(256);
    l_agent_port VARCHAR2(64);

  BEGIN
    IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('add_target:Entry p_target_name ='||p_target_name ||
                                    ' p_target_type ='||p_target_type ||
                                    ' p_host_name ='  ||p_host_name   ||
                                    ' p_target_display_name ='  ||p_target_display_name   ||
                                    ' p_agent_url ='  ||  p_agent_url  ||
                                    ' p_tz_rgn = '  || p_tz_rgn   ||
                                    ' p_mon_mode ='  || p_mon_mode  ||
                                    ' p_type_meta_ver ='  || p_type_meta_ver  ||
                                    ' p_category_prop_1 ='  || p_category_prop_1   ||
                                    ' p_category_prop_2 ='  || p_category_prop_2   ||
                                    ' p_category_prop_3 ='  || p_category_prop_3   ||
                                    ' p_category_prop_4 ='  || p_category_prop_4   ||
                                    ' p_category_prop_5 ='  || p_category_prop_5   ||
                                    ' p_repository_only_target ='  || p_repository_only_target   ||
                                    ' p_target_owner ='  || p_target_owner  ||
                                    ' p_is_group ='  || p_is_group  ||
                                    ' p_required_parent_target_priv ='  || p_required_parent_target_priv  ||
                                    ' p_required_target_priv ='  || p_required_target_priv  ||
                                    ' ', MODULE_NAME);
    END IF;

    IF p_type_display_name IS NOT NULL THEN
      l_type_display_name := p_type_display_name ;
    ELSE
      BEGIN
        SELECT type_display_name 
          INTO l_type_display_name 
          FROM mgmt_target_types
         WHERE target_type = l_target_type ;
      EXCEPTION
        WHEN NO_DATA_FOUND THEN
          l_type_display_name := l_target_type;
      END;
    END IF;

    -- Check that the target is not an agent target
    -- Targets of agent type cannot be added through this API
    IF ( (l_target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) AND
         (p_agent_url IS NULL) ) THEN
      raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
        'Agent target can be added only by providing agent URL.');
    END IF;

    --check whether all required properties are there
    --check_required_properties(l_target_type, p_properties); 

    -- User must have the required target privilege
    IF p_required_target_priv IS NOT NULL AND 
       MGMT_USER.has_priv(l_current_user, p_required_target_priv) = 0 
    THEN
      raise_application_error(MGMT_GLOBAL.INSUFFICIENT_PRIVILEGES_ERR,
            p_required_target_priv ||' privilege is required to create this target');
    END IF;

    -- generate target guid 
    p_target_guid := MGMT_TARGET.generate_target_guid(l_target_name, l_target_type);

    -- Enter super-user mode. This is necessary because this operation
    -- involves making calls to the security system that only super-users
    -- are allowed to make
    SETEMUSERCONTEXT(MGMT_USER.get_repository_owner, 
                     MGMT_USER.OP_SET_IDENTIFIER);


    -- find host and agent for the target 
    IF (p_agent_url IS NOT NULL) THEN
      IF (l_target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) THEN
        l_emd_url := p_agent_url;
        l_host_name := p_host_name;
      ELSE
        BEGIN

          SELECT timezone_delta, timezone_region, emd_url, host_name
            INTO l_tzoffset, l_tz_rgn, l_emd_url, l_host_name
            FROM MGMT_TARGETS
           WHERE emd_url = p_agent_url
             AND target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE;

        EXCEPTION
          -- We have seen cases where agent does not send agent target
          -- -or- sends an incorrect target_guid for agent
          WHEN NO_DATA_FOUND THEN
            -- Try to get agent_guid based on name and port
            EMD_LOADER.get_name_port_from_emd_url(p_agent_url, l_agent_name, l_agent_port);

            BEGIN
              SELECT target_guid, emd_url
                INTO l_agent_guid, l_emd_url
                FROM mgmt_targets
               WHERE emd_url LIKE '%://'||l_agent_name||':'||l_agent_port||'/%'
                 AND target_type = mgmt_global.G_AGENT_TARGET_TYPE;
            EXCEPTION
              WHEN NO_DATA_FOUND THEN
                raise_application_error(MGMT_GLOBAL.TARGET_DOES_NOT_EXIST_ERR,
                'Specified agent ' || p_agent_url || ' does not exist');
            END;
        END;
      END IF;
    ELSIF p_host_name IS NOT NULL THEN
      BEGIN

          SELECT timezone_delta, timezone_region, emd_url, host_name
            INTO l_tzoffset, l_tz_rgn, l_emd_url, l_host_name
            FROM MGMT_TARGETS 
           WHERE target_name=p_host_name 
             AND target_type=MGMT_GLOBAL.G_HOST_TARGET_TYPE;

      EXCEPTION
          WHEN NO_DATA_FOUND THEN
             -- For emrep and other repository only target
            IF (p_repository_only_target != 1) THEN
             raise_application_error(MGMT_GLOBAL.TARGET_DOES_NOT_EXIST_ERR,
              'Specified host ' || p_host_name || ' does not exist');
            END IF;
      END;
    END IF;

    -- insert the recored into mgmt_targets table 
    BEGIN
      INSERT 
        INTO MGMT_TARGETS
             (target_name, target_type, target_guid, host_name, emd_url, 
              timezone_delta, timezone_region, display_name, type_display_name,
              monitoring_mode, type_meta_ver, category_prop_1, category_prop_2,
              category_prop_3, category_prop_4, category_prop_5,owner,is_group) 
      VALUES
             (l_target_name, l_target_type, p_target_guid, l_host_name, l_emd_url, 
              l_tzoffset, l_tz_rgn, l_target_display_name, l_type_display_name,
              p_mon_mode, p_type_meta_ver, p_category_prop_1, p_category_prop_2,
              p_category_prop_3, p_category_prop_4, p_category_prop_5,l_target_owner,p_is_group);

      -- Handle multi-agent targets 
      --  o Mark the first agent in the multi-agent list as the master.
      --  o Add this agent to the multi-agent list
      IF (emd_loader.is_multi_agent_target(p_mon_mode) = 1) THEN
        SELECT target_guid 
          INTO l_agent_guid
          FROM mgmt_targets
         WHERE target_type = mgmt_global.G_AGENT_TARGET_TYPE
           AND emd_url = l_emd_url;

        EM_MASTER_AGENT.initialize_master_agent(p_target_guid,
                                                l_agent_guid,
                                                MGMT_GLOBAL.SYSDATE_TZRGN(l_tz_rgn));

        EMD_LOADER.update_mat_agent_list(p_target_guid, l_emd_url);
      END IF;
    EXCEPTION
      WHEN DUP_VAL_ON_INDEX THEN
        -- Handle multi-agent targets - this is to handle duplicate
        -- entries
        IF (EMD_LOADER.is_multi_agent_target(p_mon_mode) = 1) THEN
          EMD_LOADER.update_mat_agent_list(p_target_guid, l_emd_url);
        ELSE
          raise_application_error(MGMT_GLOBAL.TARGET_ALREADY_EXISTS_ERR,
              'Specified target ' || l_target_name || ' of target type '|| l_target_type ||' already exist');
        END IF;
    END;

    -- Insert target properties
    insert_target_properties(p_target_guid, p_properties);

    -- Insert monitoring credentials
    insert_monitoring_credentials(l_target_name, 
                                  l_target_type,
                                  p_type_meta_ver,
                                  p_monitoring_credentials);

    -- Now add the target to each of the groups....
    IF p_aggregates IS NOT NULL AND p_aggregates.count > 0 THEN
      l_targets_to_add := SMP_EMD_NVPAIR_ARRAY();
      l_targets_to_add.extend(1);
      l_targets_to_add(1) := SMP_EMD_NVPAIR(l_target_name, l_target_type);

      FOR i IN 1..p_aggregates.count LOOP
        NULL;
        modify_aggregate_target(p_target_guid =>l_aggregate_guid,
                                p_target_name => p_aggregates(i).name, 
                                p_target_type =>p_aggregates(i).value,
                                p_member_targets_to_add =>l_targets_to_add,
                                p_required_target_priv => p_required_parent_target_priv);
      END LOOP;
    END IF;

    -- Finally, grant the user FULL privileges on the target
    MGMT_USER.grant_priv(l_current_user, MGMT_USER.FULL_TARGET, p_target_guid);

    -- execute all the "target-added" callbacks
    emd_loader.exec_target_addition_callbacks(l_target_name,
                                              l_target_type,
                                              p_target_guid);

    -- Revert back to being the same user as we entered
    SETEMUSERCONTEXT(l_current_user, MGMT_USER.OP_SET_IDENTIFIER);

    IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('add_target:Exit p_target_guid:='||p_target_guid, MODULE_NAME);
    END IF;
  EXCEPTION
    -- Always revert back to being the same user as we entered
    WHEN OTHERS THEN
        IF l_current_user IS NOT NULL THEN
          SETEMUSERCONTEXT(l_current_user, MGMT_USER.OP_SET_IDENTIFIER);
        END IF;
        IF (emdw_log.p_is_info_set)THEN
          emdw_log.info('add_target:Exit with Exception',MODULE_NAME);
        END IF;
        RAISE;
  END add_target;

  PROCEDURE modify_target
  (
    p_target_guid OUT mgmt_targets.target_guid%TYPE,
    p_target_name IN  mgmt_targets.target_name%TYPE,
    p_target_type IN  mgmt_targets.target_type%TYPE,
    p_properties  IN  MGMT_TARGET_PROPERTY_LIST
                        DEFAULT NULL,
    p_monitoring_credentials      IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL,
    p_target_display_name         IN mgmt_targets.display_name%TYPE
                                       DEFAULT NULL,
    p_type_display_name           IN mgmt_targets.type_display_name%TYPE 
                                       DEFAULT NULL,
    p_tz_rgn                      IN mgmt_targets.timezone_region%TYPE 
                                       DEFAULT NULL, 
    p_target_owner                IN mgmt_targets.owner%TYPE
                                       DEFAULT NULL, 
    p_propagate_to_agent          IN NUMBER
                                       DEFAULT 0,
    p_required_target_priv        IN VARCHAR2
                                       DEFAULT NULL
  )
  IS
    l_current_user            VARCHAR2(256) := MGMT_USER.get_current_em_user;
    l_current_timezone_region mgmt_targets.timezone_region%TYPE ;
    l_properties              MGMT_TARGET_PROPERTY_LIST := p_properties;
    l_target_name             mgmt_targets.target_name%TYPE := trim(p_target_name);
    l_target_owner            mgmt_targets.owner%TYPE ;
    l_target_type             mgmt_targets.target_type%TYPE := trim(p_target_type);
    l_prop_to_agent           BOOLEAN;
  BEGIN
    IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('modify_target:Entry p_target_name ='||p_target_name ||
                                    ' p_target_type ='||p_target_type ||
                                    ' p_target_display_name ='  ||p_target_display_name   ||
                                    ' p_type_display_name ='  ||p_type_display_name   ||
                                    ' p_target_owner ='  || p_target_owner  ||
                                    ' p_tz_rgn ='  || p_tz_rgn  ||
                                    ' p_propagate_to_agent ='  || p_propagate_to_agent ||
                                    ' p_required_target_priv ='  || p_required_target_priv  ||
                                    ' ', MODULE_NAME);
    END IF;
   
    BEGIN
      SELECT target_guid,owner,timezone_region 
        INTO p_target_guid,l_target_owner,l_current_timezone_region
        FROM MGMT_TARGETS 
       WHERE target_name=l_target_name 
         AND target_type=l_target_type;
    EXCEPTION
      WHEN NO_DATA_FOUND THEN
        raise_application_error(MGMT_GLOBAL.TARGET_DOES_NOT_EXIST_ERR,
        'The specified target ' || p_target_name || ' does not exist');
    END;

    -- Check that the user has permissions to modify the target
    IF p_required_target_priv IS NOT NULL AND 
       MGMT_USER.has_priv(l_current_user, p_required_target_priv,
                          l_target_name, l_target_type) = 0 
    THEN
        raise_application_error(MGMT_GLOBAL.INSUFFICIENT_PRIVILEGES_ERR,
        'The current user does not have enough privileges to perform this operation');
    END IF;

    -- modify target display name and type display name if specified
    IF ( (p_type_display_name IS NOT NULL) OR (p_target_display_name IS NOT NULL)) THEN 
      UPDATE MGMT_TARGETS 
         SET type_display_name = nvl(p_type_display_name, type_display_name),
             display_name      = nvl(p_target_display_name, display_name)
       WHERE target_guid  = p_target_guid;
    END IF;

    -- modify target timezone region if specified
    IF p_tz_rgn IS NOT NULL
    THEN
      set_target_tzrgn(p_target_guid,p_tz_rgn);
    END IF;

   -- Insert target properties
    IF p_properties IS NOT NULL THEN
       upsert_target_properties(l_target_name,
                                l_target_type, 
                                p_target_guid,
                                p_properties,
                                p_propagate_to_agent);
    END IF;
  
    -- Insert monitoring credentials
    IF p_monitoring_credentials IS NOT NULL THEN
      IF (p_propagate_to_agent = 1)
      THEN
        l_prop_to_agent := true;
      ELSE
        l_prop_to_agent := false;
      END IF;

      MGMT_CREDENTIAL.insert_monitoring_credentials(l_target_name,
                                                    l_target_type,
                                                    p_monitoring_credentials,
                                                    l_prop_to_agent);
    END IF;

    -- Modify the target owner
    IF p_target_owner IS NOT NULL THEN
        IF l_current_user = l_target_owner OR 
           MGMT_USER.has_priv(l_current_user, 'SUPER_USER') = 1 
        THEN
            UPDATE MGMT_TARGETS
               SET owner = p_target_owner
             WHERE target_guid=p_target_guid;
        ELSE
            raise_application_error(MGMT_GLOBAL.INSUFFICIENT_PRIVILEGES_ERR,
            'The current user does not have enough privileges to modify the target owner');
        END IF;
    END IF;

    IF (p_propagate_to_agent = 1 AND p_target_display_name IS NOT NULL)
    THEN
      submit_mod_tgt_dispname_job(l_target_name,l_target_type, p_target_display_name); 
    END IF;

    IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('modify_target:Exit',MODULE_NAME);
    END IF; 
  
  END modify_target;

  PROCEDURE add_aggregate_target
  (
    p_target_guid    OUT mgmt_targets.target_guid%TYPE,
    p_target_name    IN  mgmt_targets.target_name%TYPE,
    p_target_type    IN  mgmt_targets.target_type%TYPE,
    p_member_targets IN  SMP_EMD_NVPAIR_ARRAY 
                           DEFAULT NULL,
    p_host_name      IN  mgmt_targets.target_name%TYPE
                          DEFAULT NULL,
    p_properties     IN  MGMT_TARGET_PROPERTY_LIST
                          DEFAULT NULL,
    p_aggregates     IN  SMP_EMD_NVPAIR_ARRAY
                          DEFAULT NULL,
    p_monitoring_credentials IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL,
    p_target_display_name    IN mgmt_targets.display_name%TYPE
                                  DEFAULT NULL,
    p_type_display_name      IN mgmt_targets.type_display_name%TYPE 
                                   DEFAULT NULL,
    p_agent_url       IN mgmt_targets.emd_url%TYPE
                           DEFAULT NULL,
    p_tz_rgn          IN mgmt_targets.timezone_region%TYPE
                           DEFAULT NULL,
    p_mon_mode        IN mgmt_targets.monitoring_mode%TYPE
                           DEFAULT MGMT_GLOBAL.G_MON_MODE_DEFAULT,
    p_type_meta_ver   IN VARCHAR2
                           DEFAULT '1.0',
    p_category_prop_1 IN mgmt_targets.category_prop_1%TYPE
                           DEFAULT ' ',
    p_category_prop_2 IN mgmt_targets.category_prop_2%TYPE
                           DEFAULT ' ',
    p_category_prop_3 IN mgmt_targets.category_prop_3%TYPE
                           DEFAULT ' ',
    p_category_prop_4 IN mgmt_targets.category_prop_4%TYPE
                           DEFAULT ' ',
    p_category_prop_5 IN mgmt_targets.category_prop_5%TYPE
                            DEFAULT ' ',
    p_repository_only_target   IN NUMBER
                                    DEFAULT 0,
    p_target_owner             IN mgmt_targets.owner%TYPE
                                    DEFAULT NULL,
    p_is_group                    IN NUMBER 
                                       DEFAULT 0,
    p_required_parent_target_priv IN VARCHAR2
                                    DEFAULT NULL,
    p_required_target_priv        IN VARCHAR2
                                    DEFAULT NULL,
    p_required_member_priv        IN VARCHAR2
                                    DEFAULT NULL
  )
  IS
    l_current_user       VARCHAR2(256) := MGMT_USER.get_current_em_user;
    l_target_guid        mgmt_targets.target_guid%TYPE;
    l_target_name        mgmt_targets.target_name%TYPE := trim(p_target_name);
    l_target_type        mgmt_targets.target_type%TYPE := trim(p_target_type);
    l_members_guid_array MGMT_USER_GUID_ARRAY:= NEW MGMT_USER_GUID_ARRAY();
  BEGIN
    IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('add_aggregate_target:Entry p_target_name ='||p_target_name ||
                                    ' p_target_type ='||p_target_type ||
                                    ' p_host_name ='  ||p_host_name   ||
                                    ' p_target_display_name ='  ||p_target_display_name   ||
                                    ' p_type_display_name ='  ||p_type_display_name   ||
                                    ' p_agent_url ='  ||  p_agent_url  ||
                                    ' p_tz_rgn = '  || p_tz_rgn   ||
                                    ' p_mon_mode ='  || p_mon_mode  ||
                                    ' p_type_meta_ver ='  || p_type_meta_ver  ||
                                    ' p_category_prop_1 ='  || p_category_prop_1   ||
                                    ' p_category_prop_2 ='  || p_category_prop_2   ||
                                    ' p_category_prop_3 ='  || p_category_prop_3   ||
                                    ' p_category_prop_4 ='  || p_category_prop_4   ||
                                    ' p_category_prop_5 ='  || p_category_prop_5   ||
                                    ' p_repository_only_target ='  || p_repository_only_target   ||
                                    ' p_target_owner ='  || p_target_owner  ||
                                    ' p_is_group ='  || p_is_group  ||
                                    ' p_required_parent_target_priv ='  || p_required_parent_target_priv  ||
                                    ' p_required_target_priv ='  || p_required_target_priv  ||
                                    ' ', MODULE_NAME);
    END IF;

    -- Ensure that the specified target type is a aggregate target type
    check_aggregate(p_target_type);

    IF (p_member_targets IS NOT NULL AND 
        p_member_targets.COUNT != 0) 
    THEN

      -- Check whether Member to be added exist
      l_members_guid_array.extend(p_member_targets.COUNT);
      FOR i IN 1..p_member_targets.COUNT
      LOOP
        BEGIN
          l_members_guid_array(i) := MGMT_TARGET.get_target_guid(p_member_targets(i).name,
                                                                 p_member_targets(i).value);
        EXCEPTION
          WHEN MGMT_GLOBAL.target_does_not_exist THEN
            raise_application_error(MGMT_GLOBAL.MEMBER_DOES_NOT_EXIST_ERR,
                                    'The specified member target ' || p_member_targets(i).name ||':'||p_member_targets(i).value|| ' does not exist');
        END;
      END LOOP;


      -- For typed aggregates only members of a specific type can be added.
      check_aggregate_members(l_target_type, p_member_targets);

      -- The user must have spevcified privilege over all member targets
      IF ( p_required_member_priv IS NOT NULL) THEN
        check_member_targets_priv(l_members_guid_array,
                                  p_required_member_priv,
                                  l_current_user);
      END IF;
    END IF;

    add_target(p_target_guid => p_target_guid,
               p_target_name => p_target_name,
               p_target_type => p_target_type,
               p_host_name   => p_host_name,
               p_properties  => p_properties,
               p_aggregates  => p_aggregates,
               p_monitoring_credentials => p_monitoring_credentials,
               p_target_display_name => p_target_display_name,
               p_type_display_name => p_type_display_name,
               p_agent_url => p_agent_url,
               p_tz_rgn    => p_tz_rgn,
               p_mon_mode  => p_mon_mode,
               p_type_meta_ver  => p_type_meta_ver,
               p_category_prop_1 => p_category_prop_1,
               p_category_prop_2 => p_category_prop_2,
               p_category_prop_3 => p_category_prop_3,
               p_category_prop_4 => p_category_prop_4,
               p_category_prop_5 => p_category_prop_5,
               p_repository_only_target => p_repository_only_target,
               p_target_owner => p_target_owner,
               p_is_group => p_is_group,
               p_required_target_priv => p_required_target_priv,
               p_required_parent_target_priv => p_required_parent_target_priv
              );

    -- Insert member targets into the aggregate
    modify_members(l_target_name, l_target_type,
                    p_member_targets, null);

    IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('add_aggregate_target:Exit',MODULE_NAME);
    END IF;

  END add_aggregate_target;

  PROCEDURE modify_aggregate_target
  (
    p_target_guid OUT mgmt_targets.target_guid%TYPE,
    p_target_name IN  mgmt_targets.target_name%TYPE,
    p_target_type IN  mgmt_targets.target_type%TYPE,
    p_member_targets_to_add    IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL,
    p_member_targets_to_remove IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL,
    p_properties  IN  MGMT_TARGET_PROPERTY_LIST
                        DEFAULT NULL,
    p_monitoring_credentials      IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL,
    p_target_display_name         IN mgmt_targets.display_name%TYPE
                                       DEFAULT NULL,
    p_type_display_name           IN mgmt_targets.type_display_name%TYPE
                                       DEFAULT NULL,
    p_tz_rgn                      IN mgmt_targets.timezone_region%TYPE 
                                       DEFAULT NULL, 
    p_target_owner                IN mgmt_targets.owner%TYPE
                                       DEFAULT NULL,
    p_propagate_to_agent          IN NUMBER
                                       DEFAULT 0,
    p_required_target_priv        IN VARCHAR2
                                       DEFAULT NULL,
    p_required_member_priv        IN VARCHAR2
                                       DEFAULT NULL
    
  )
  IS
    l_current_user VARCHAR2(256) := MGMT_USER.get_current_em_user;
    l_target_name mgmt_targets.target_name%TYPE := trim(p_target_name);
    l_target_type mgmt_targets.target_type%TYPE := trim(p_target_type);
    l_target_guid mgmt_targets.target_guid%TYPE; 
    l_members_guid_array MGMT_USER_GUID_ARRAY:= NEW MGMT_USER_GUID_ARRAY();
  BEGIN
    IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('modify_aggregate_target:Entry p_target_name ='||p_target_name ||
                                    ' p_target_type ='||p_target_type ||
                                    ' p_target_display_name ='  ||p_target_display_name   ||
                                    ' p_type_display_name ='  ||p_type_display_name   ||
                                    ' p_tz_rgn ='  ||p_tz_rgn   ||
                                    ' p_target_owner ='  || p_target_owner  ||
                                    ' p_propagate_to_agent ='  || p_propagate_to_agent ||
                                    ' p_required_target_priv ='  || p_required_target_priv  ||
                                    ' p_required_member_priv ='  || p_required_member_priv  ||
                                    ' ', MODULE_NAME);
    END IF;

    -- Ensure that the specified target type is a aggregate target type
    check_aggregate(p_target_type);

    modify_target(p_target_guid => p_target_guid,
                  p_target_name => l_target_name,
                  p_target_type => l_target_type,
                  p_properties  => p_properties,
                  p_monitoring_credentials => p_monitoring_credentials,
                  p_target_display_name => p_target_display_name,
                  p_type_display_name => p_type_display_name,
                  p_tz_rgn => p_tz_rgn,
                  p_target_owner => p_target_owner,
                  p_propagate_to_agent => p_propagate_to_agent,
                  p_required_target_priv => p_required_target_priv
                 );

    IF (p_member_targets_to_add IS NOT NULL AND 
        p_member_targets_to_add.COUNT != 0) 
    THEN

      -- Check whether Member to be added exist
      l_members_guid_array.extend(p_member_targets_to_add.COUNT);
      FOR i IN 1..p_member_targets_to_add.COUNT 
      LOOP
        BEGIN
          l_members_guid_array(i) := MGMT_TARGET.get_target_guid(p_member_targets_to_add(i).name,
                                                                 p_member_targets_to_add(i).value);
        EXCEPTION 
          WHEN MGMT_GLOBAL.target_does_not_exist THEN
            raise_application_error(MGMT_GLOBAL.MEMBER_DOES_NOT_EXIST_ERR,
                                    'The specified member target ' || p_member_targets_to_add(i).name ||':'||p_member_targets_to_add(i).value|| ' does not exist');

        END; 
      END LOOP;


      -- Check that the user has required privilege over all the 
      -- members targets being added...
      IF p_required_member_priv IS NOT NULL
      THEN
        check_member_targets_priv(l_members_guid_array,
                                  p_required_member_priv,
                                  l_current_user);
      END IF;

      -- For typed aggregates, only members of a specific type can be added.
      check_aggregate_members(l_target_type, p_member_targets_to_add);
    END IF;

    -- Add/remove the specified targets
    IF p_member_targets_to_add IS NOT NULL OR
       p_member_targets_to_remove IS NOT NULL 
    THEN

        -- Modify its members
        modify_members(p_target_name, 
                       p_target_type, 
                       p_member_targets_to_add, 
                       p_member_targets_to_remove);
    END IF;
    


    IF (emdw_log.p_is_info_set)THEN
      emdw_log.info('modify_aggregate_target:Exit',MODULE_NAME);
    END IF;

  END modify_aggregate_target;


  -----------------------------------Internal Procedures/Functions-----------------------------
  PROCEDURE  check_required_properties
  (
    p_target_type IN mgmt_targets.target_type%TYPE,
    p_properties  IN MGMT_TARGET_PROPERTY_LIST
  )
  IS
    l_missing_req_prop_cnt NUMBER := 0;
  BEGIN
    SELECT count(*)
      INTO l_missing_req_prop_cnt
      FROM mgmt_target_prop_defs
     WHERE NOT EXISTS (SELECT 1
                         FROM (SELECT property_name, property_type
                                 FROM TABLE( CAST( p_properties AS MGMT_TARGET_PROPERTY_LIST))
                              ) prop_tab
                        WHERE  prop_tab.property_name = mgmt_target_prop_defs.property_name
                          AND  prop_tab.property_type = mgmt_target_prop_defs.property_type
                      )
      AND mgmt_target_prop_defs.target_type = p_target_type
      AND mgmt_target_prop_defs.required_flag = 1 ;

    IF l_missing_req_prop_cnt > 0 THEN
        raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
        'Required property missing for the specified target');
    END IF;
  END check_required_properties; 
  
  PROCEDURE insert_target_properties
  (
    p_target_guid IN mgmt_targets.target_guid%TYPE,
    p_properties  IN MGMT_TARGET_PROPERTY_LIST
  )
  IS
  BEGIN
    IF (p_properties IS NOT NULL) AND (p_properties.count > 0) THEN
      FOR i IN 1..p_properties.count LOOP
        INSERT INTO MGMT_TARGET_PROPERTIES
            (target_guid, property_name, property_type, property_value) 
          VALUES
            (p_target_guid, p_properties(i).property_name,
             p_properties(i).property_type, p_properties(i).property_value);
      END LOOP;
    END IF;
  END insert_target_properties; 
 
  
  PROCEDURE insert_monitoring_credentials
  (
    p_target_name   IN mgmt_targets.target_name%TYPE,
    p_target_type   IN mgmt_targets.target_type%TYPE,
    p_type_meta_ver IN mgmt_targets.type_meta_ver%TYPE,
    p_monitoring_credentials IN SMP_EMD_NVPAIR_ARRAY
  )
  IS
    l_cred_array MGMT_TARGET_CRED_ARRAY;
    l_cred_rows MGMT_CRED_ROW_ARRAY;
    l_cred_record MGMT_TARGET_CRED_RECORD;
    l_cred_set_name MGMT_CREDENTIAL_SETS.set_name%TYPE;

  BEGIN
    IF p_monitoring_credentials IS NOT NULL THEN
        -- We assume here that there is only one monitoring credential
        -- set defined for the target
        BEGIN
          SELECT set_name INTO l_cred_set_name
            FROM   MGMT_CREDENTIAL_SETS
           WHERE  target_type = p_target_type
             AND    target_type_meta_ver = p_type_meta_ver
             AND    set_usage=MGMT_CREDENTIAL.MONITORING_SET_USAGE
             AND    ROWNUM=1;
        EXCEPTION
          WHEN NO_DATA_FOUND THEN
            raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
             'No monitoring credential set found for type ' ||
             p_target_type);
        END;

        -- Create a target credential record from the specified
        -- name-value pairs
        l_cred_rows := MGMT_CRED_ROW_ARRAY();
        l_cred_rows.extend(p_monitoring_credentials.COUNT);

        FOR i IN 1..l_cred_rows.COUNT LOOP
            l_cred_rows(i) := 
                MGMT_CRED_ROW_RECORD(p_monitoring_credentials(i).name, 
                                     p_monitoring_credentials(i).value);
        END LOOP;

        l_cred_record := 
                   MGMT_TARGET_CRED_RECORD.NEW(p_target_name,
                                               p_target_type,
                                               MGMT_CRED_RECORD.NEW(null,
                                                                    l_cred_set_name,
                                                                    l_cred_rows));

        l_cred_array := MGMT_TARGET_CRED_ARRAY();
        l_cred_array.extend(1);
        l_cred_array(1) := l_cred_record;

        MGMT_CREDENTIAL.set_target_credentials(l_cred_array);
    END IF;

  END insert_monitoring_credentials;

  -- Check that the target type is an aggregate: throw an exception
  -- if not. Internal method
  PROCEDURE check_aggregate
  (
    p_target_type VARCHAR2
  )
  IS
    l_is_aggregate NUMBER := 0;
  BEGIN
    l_is_aggregate := MGMT_TARGET.get_type_property(p_target_type,
                                    MGMT_GLOBAL.G_IS_AGGREGATE_PROP,
                                    '0');

    IF l_is_aggregate = 0 THEN
        raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
        'The specified target is not an aggregate, type =  ' || p_target_type);
    END IF;

  END check_aggregate;

  -- Check that the current user has the specified privilege on each one
  -- of the specified member targets
  PROCEDURE check_member_targets_priv
  (
    p_member_targets IN MGMT_USER_GUID_ARRAY,
    p_privilege      IN VARCHAR2,
    p_user           IN VARCHAR2
  ) IS
  BEGIN
    IF p_privilege IS NULL THEN
      RETURN;
    END IF;
    
    IF p_member_targets IS NOT NULL AND
       p_member_targets.count > 0 THEN
        -- The caller must have the requested privilege over all member targets
        FOR i IN 1..p_member_targets.count LOOP

            IF MGMT_USER.has_priv(p_user,
                                  p_privilege,
                                  p_member_targets(i)) = 0 THEN
                raise_application_error(MGMT_GLOBAL.INSUFFICIENT_PRIVILEGES_ERR,
                'The current user must have ' || p_privilege || ' privilege over all member targets');
            END IF;
        END LOOP;

    END IF;
  END check_member_targets_priv;

  -- Add/remove members for a group or composite: internal method
  PROCEDURE modify_members
  (
    p_aggregate_name    IN mgmt_targets.target_name%TYPE,
    p_aggregate_type    IN mgmt_targets.target_type%TYPE,
    p_targets_to_add    IN SMP_EMD_NVPAIR_ARRAY,
    p_targets_to_remove IN SMP_EMD_NVPAIR_ARRAY
  ) 
  IS
  BEGIN
    -- Handle the targets to remove from the group first....
    IF p_targets_to_remove IS NOT NULL AND
       p_targets_to_remove.COUNT > 0
    THEN
            -- delete the member type  Target Associations 
          em_assoc.delete_target_assocs( p_assoc_def_name => mgmt_assoc.ASSOC_DEF_CONTAINS,
                                         p_source_target_name => p_aggregate_name,
                                         p_source_target_type => p_aggregate_type,
                                         p_assoc_targets_list => p_targets_to_remove,
                                         p_suppress_error => TRUE );
    END IF;

    -- Handle targets to add....
    IF p_targets_to_add IS NOT NULL AND
       p_targets_to_add.COUNT > 0
    THEN
          -- Create a MEMBER type Target Associations 
          em_assoc.create_target_assocs( p_assoc_def_name => mgmt_assoc.ASSOC_DEF_CONTAINS,
                                         p_source_target_name => p_aggregate_name,
                                         p_source_target_type => p_aggregate_type,
                                         p_assoc_targets_list => p_targets_to_add,
                                         p_suppress_error => TRUE );
    END IF;

  END modify_members;

  -- Check that the specified members can all be added to the group
  -- whose type is p_group_type. This enforces that only targets of
  -- a pre-defined type can be added to typed groups.
  PROCEDURE check_aggregate_members
  (
    p_aggregate_type VARCHAR2,
    p_members SMP_EMD_NVPAIR_ARRAY
  ) 
  IS
    l_member_target_type VARCHAR2(1024);
  BEGIN
    l_member_target_type := MGMT_TARGET.get_type_property(p_aggregate_type, 
                                              MGMT_GLOBAL.G_MEMBER_TYPE_PROP, 
                          null);

    IF l_member_target_type IS NULL THEN
        -- This group is not a typed group:
        -- Any kind of target can be added to this group
        RETURN;
    ELSE
      IF p_members IS NOT NULL THEN
        -- This group is a typed group: the only targets that can
        -- be added to this group are targets of type l_member_target_type
        FOR i in 1..p_members.count LOOP
            IF p_members(i).value != l_member_target_type THEN
                raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
                'Cannot add target ' || p_members(i).name || ':' ||
                 p_members(i).value ||
                ' to typed aggregate of base type ' || l_member_target_type);
            END IF;
        END LOOP;
      END IF;
    END IF;
  END check_aggregate_members;

  PROCEDURE upsert_target_properties
  (
    p_target_name        IN mgmt_targets.target_name%TYPE,
    p_target_type        IN mgmt_targets.target_type%TYPE,
    p_target_guid        IN mgmt_targets.target_guid%TYPE,
    p_properties         IN MGMT_TARGET_PROPERTY_LIST,
    p_propagate_to_agent IN NUMBER DEFAULT 0
  )
  IS 
    l_properties MGMT_TARGET_PROPERTY_LIST:= p_properties;
    l_data_set_guid RAW(16);
    l_operation_guid RAW(16);
    l_data_guids MGMT_USER_GUID_ARRAY;
    l_targets MGMT_JOB_TARGET_LIST;
  BEGIN

    IF p_properties IS NULL THEN 
      RETURN;
    END IF;

    FOR i IN 1..l_properties.count LOOP
      --use merge stmt
      UPDATE MGMT_TARGET_PROPERTIES 
         SET property_value = l_properties(i).property_value 
       WHERE target_guid    = p_target_guid 
         AND property_name  = l_properties(i).property_name 
         AND property_type  = l_properties(i).property_type;

      IF SQL%ROWCOUNT=0 THEN
        INSERT 
          INTO MGMT_TARGET_PROPERTIES
               (target_guid, property_name,
                property_type, property_value) 
        VALUES
               (p_target_guid, l_properties(i).property_name,
                l_properties(i).property_type, l_properties(i).property_value);
      END IF;
    END LOOP;

    -- Submit a job to asynchronously update the EMDs if p_propagate_to_agent=1
    -- (update current/master agent) or if it is a multi-agent target (update
    -- standby agents)
    IF l_properties.count > 0 THEN
      IF (is_multi_agent_target(p_target_name, p_target_type) = 1 OR
            p_propagate_to_agent = 1) 
      THEN
        l_data_set_guid := MGMT_TARGET_UPDATE.submit_properties_data(
                           p_target_name, p_target_type, l_properties);

        l_data_guids := MGMT_USER_GUID_ARRAY();
        l_data_guids.extend(1);
        l_data_guids(1) := l_data_set_guid;
 
        l_targets := MGMT_JOB_TARGET_LIST();
        l_targets.extend(1);
        l_targets(1) := MGMT_JOB_TARGET_RECORD(p_target_name, p_target_type);
    
        l_operation_guid := MGMT_TARGET_UPDATE.submit_update_operation(
                                  l_data_guids, l_targets, p_propagate_to_agent);
      END IF;
    END IF;

  END upsert_target_properties;

  --
  -- Checks whether a given target is a multi-agent target or not
  --
  FUNCTION is_multi_agent_target
  (
    p_target_name IN mgmt_targets.target_name%TYPE,
    p_target_type IN mgmt_targets.target_type%TYPE
  ) RETURN NUMBER 
  IS
  BEGIN
     RETURN emd_loader.is_multi_agent_target(p_target_name,
                                             p_target_type);
  END is_multi_agent_target;

  PROCEDURE exec_metaver_upd_callback
    (p_callback_array IN mgmt_target_meta_ver_cbk_array) 
  IS
  CURSOR callbacks_cur(p_array IN mgmt_target_meta_ver_cbk_array)
  IS
  SELECT callback_name,
         mgmt_target_meta_ver_cbk_obj.NEW(changes.target_guid,
                                          changes.target_type,
                                          changes.from_meta_ver,
                                          changes.to_meta_ver,
                                          changes.from_catprop_array,
                                          changes.to_catprop_array
                                          ) callback_obj
    FROM mgmt_callbacks call,
         TABLE(CAST(p_array AS mgmt_target_meta_ver_cbk_array)) changes
   WHERE call.callback_type      = MGMT_GLOBAL.G_TARGET_METAVER_UPD_CALLBACK
     AND (selector_1 = changes.target_type OR selector_1 = ' ')
     AND (selector_2 = changes.to_meta_ver OR selector_2 = ' ') 
    ORDER BY changes.target_type,
             changes.target_guid,
             call.eval_order,
             call.callback_name ;
  BEGIN
    IF EMDW_LOG.P_IS_INFO_SET
    THEN
      EMDW_LOG.INFO('exec_metaver_upd_callback:Enter',MODULE_NAME);
    END IF ;

    FOR callback IN callbacks_cur(p_callback_array)
    LOOP
      BEGIN
        IF EMDW_LOG.P_IS_DEBUG_SET
        THEN
          EMDW_LOG.DEBUG('exec_metaver_upd_callback:Calling '||
            callback.callback_name||
            ' Target='||callback.callback_obj.target_guid||
            ' from_ver='||callback.callback_obj.from_meta_ver||
            ' to_ver='||callback.callback_obj.to_meta_ver,
            MODULE_NAME) ;
        END IF ;
        EXECUTE IMMEDIATE
          'BEGIN ' || EM_CHECK.qualified_sql_name(callback.callback_name) ||
                 '(:1); END; ' USING
           callback.callback_obj ;
      EXCEPTION
      -- Ignore exceptions so that main transaction is not affected; we do not
      -- treat callback exceptions on par with repository exceptions. In other
      -- words, we will not let some callback mess up repository operations.
        WHEN OTHERS THEN
          IF EMDW_LOG.P_IS_INFO_SET
          THEN
            EMDW_LOG.INFO('exec_metaver_upd_callback:Exception '||sqlerrm,
              MODULE_NAME) ;
          END IF ;
          mgmt_log.log_error(v_module_name_in => 'TARGET',
                             v_error_code_in  =>  0,
                             v_error_msg_in   => SUBSTR(SQLERRM, 1, 2000));
      END ;
    END LOOP ;

    IF EMDW_LOG.P_IS_INFO_SET
    THEN
      EMDW_LOG.INFO('exec_metaver_upd_callback:Exit',MODULE_NAME) ;
    END IF ;
  END exec_metaver_upd_callback ;

  -- FUNCTION: get_type_ver_guid.
  -- 
  -- PURPOSE:
  --    Return the GUID of the given target type for the given meta version
  --    If the target type of given meta version is not present then type_ver_not_exist exception is thrown
  -- IN parameters:
  --   p_target_type : Target type
  --   p_type_meta_ver : Meta version of the target type
  -- OUT parameters:
  --   None
  -- ERROR CODES:
  --   None
  -- EXCEPTION
  --   type_ver_not_exist
  FUNCTION get_type_ver_guid(p_target_type IN VARCHAR2, p_type_meta_ver IN VARCHAR2)
    RETURN RAW
  IS 
   l_target_type_guid mgmt_target_types.target_type_guid%TYPE;
  BEGIN
    IF EMDW_LOG.P_IS_INFO_SET
    THEN
      EMDW_LOG.INFO('get_type_ver_guid:Entry p_target_type = ' || p_target_type ||
                     ' p_type_meta_ver = ' ||  p_type_meta_ver, MODULE_NAME);
    END IF ;

    SELECT target_type_guid into l_target_type_guid
      FROM mgmt_target_types 
    WHERE target_type = p_target_type
    AND   max_type_meta_ver = p_type_meta_ver;
  
    IF EMDW_LOG.P_IS_INFO_SET
    THEN
      EMDW_LOG.INFO('get_type_ver_guid:Exit', MODULE_NAME);
    END IF ;

    RETURN l_target_type_guid; 
    
    EXCEPTION WHEN NO_DATA_FOUND THEN
      raise_application_error(MGMT_GLOBAL.TARGET_TYPE_VER_NOT_EXIST_ERR,
                              'The specified target type version does not exist (' ||
                                p_target_type || ':' || p_type_meta_ver || ')');
  END; 

  -- PROCEDURE: check_type_ver_guid.
  -- 
  -- PURPOSE:
  --   Check that the given target type is registered for the given meta version
  --    If the target type of given meta version is not registered then type_ver_not_exist exception is thrown
  -- IN parameters:
  --   p_target_type : Target type
  --   p_type_meta_ver : Meta version of the target type
  -- OUT parameters:
  --   None
  -- ERROR CODES:
  --   None
  -- EXCEPTION
  --   type_ver_not_exist
  PROCEDURE check_type_ver_guid(p_target_type IN VARCHAR2, p_type_meta_ver IN VARCHAR2)
  IS
   l_target_type_guid mgmt_target_types.target_type_guid%TYPE;
  BEGIN
    IF EMDW_LOG.P_IS_INFO_SET
    THEN
      EMDW_LOG.INFO('check_type_ver_guid:Entry p_target_type = ' || p_target_type ||
                     ' p_type_meta_ver = ' ||  p_type_meta_ver, MODULE_NAME);
    END IF ;

    l_target_type_guid := get_type_ver_guid(p_target_type,p_type_meta_ver);

    IF EMDW_LOG.P_IS_INFO_SET
    THEN
      EMDW_LOG.INFO('check_type_ver_guid:Exit', MODULE_NAME);
    END IF ;

  END check_type_ver_guid;

  -- Check that the target type is cluster: throw an exception
  -- if not. Internal method
  PROCEDURE check_cluster
  (
    p_target_type IN mgmt_targets.target_type%TYPE
  )
  IS
    l_is_cluster NUMBER := 0;
  BEGIN
    l_is_cluster := MGMT_TARGET.get_type_property(p_target_type,
                                      MGMT_GLOBAL.G_IS_CLUSTER_PROP,
                                      '0');

    IF l_is_cluster = 0 THEN
      raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
      'Target Type '||p_target_type||' is not a cluster target type.');
    END IF;

  END;

  --
  -- PROCEDURE : get_agent_version
  --
  -- PURPOSE
  --
  --   Gets the agent version.
  --  
  -- PARAMETERS
  --    IN parameters
  --         p_emd_url: emd_url of the agent
  --    OUT parameters 
  --         p_agent_version: version of the agent
  --  See signature.
  --
  -- NOTES
  --
  PROCEDURE get_agent_version
  (
    p_emd_url IN mgmt_targets.emd_url%TYPE,
    p_agent_version OUT mgmt_target_properties.property_value%TYPE
  )
  IS
    l_agent_guid mgmt_targets.target_guid%TYPE;
    l_agent_name mgmt_targets.target_name%TYPE;
  BEGIN
    
    IF EMDW_LOG.P_IS_INFO_SET THEN 
      EMDW_LOG.INFO('get_agent_version: Enter ' || p_emd_url, MODULE_NAME) ; 
    END IF ;

    BEGIN 
      SELECT target_name, target_guid 
        INTO l_agent_name, l_agent_guid
        FROM mgmt_targets
       WHERE emd_url = p_emd_url
         AND target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE;
    EXCEPTION
      WHEN NO_DATA_FOUND THEN
        raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR, 'No agent with emd_url '||p_emd_url);
    END;

    BEGIN 
      SELECT property_value
        INTO p_agent_version
        FROM mgmt_target_properties
       WHERE property_name = 'Version'
         AND target_guid = l_agent_guid;
    EXCEPTION
      WHEN NO_DATA_FOUND THEN
        raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR, 'Could not find verision  for agent '||l_agent_name);
    END;

    IF EMDW_LOG.P_IS_INFO_SET THEN 
      EMDW_LOG.INFO('get_agent_version: Exit ', MODULE_NAME) ; 
    END IF ;

  END get_agent_version;

  --
  -- PROCEDURE: remove_cluster_member
  --
  -- PURPOSE: 
  --   Remove the cluster member from the cluster target.
  --   This api does not delete the cluster member, it just removes the
  --   association with the cluster target.
  PROCEDURE remove_cluster_member
  (
    p_cluster_name IN mgmt_targets.target_name%TYPE,
    p_cluster_type IN mgmt_targets.target_type%TYPE,
    p_member_name IN mgmt_targets.target_name%TYPE,
    p_member_type IN mgmt_targets.target_type%TYPE
  )
  IS
    l_agent_guid mgmt_targets.target_guid%TYPE;
    l_cluster_guid mgmt_targets.target_guid%TYPE;
    l_member_guid mgmt_targets.target_guid%TYPE;
    l_count NUMBER;
  BEGIN

    IF EMDW_LOG.P_IS_INFO_SET THEN 
      EMDW_LOG.INFO('remove_cluster_member: Enter ' || p_cluster_name || ', ' || p_cluster_type ||
                     ', ' || p_member_name || ', ' || p_member_type, MODULE_NAME) ; 
    END IF ;

    check_cluster(p_cluster_type);
   
    l_cluster_guid := MGMT_TARGET.get_target_guid(p_cluster_name, p_cluster_type);
   
    l_member_guid := MGMT_TARGET.get_target_guid(p_member_name, p_member_type);

    BEGIN 
      SELECT assoc_target_guid
        INTO l_agent_guid
        FROM mgmt_target_assocs a
       WHERE a.source_target_guid = l_member_guid
         AND a.assoc_guid = MGMT_ASSOC.G_MONITORED_BY_GUID;
    EXCEPTION
      WHEN NO_DATA_FOUND THEN
        raise_application_error(SQLCODE, 'Could not find agent for target '||p_member_name||':'||p_member_type);
    END;

    -- Check if the association exists.
    SELECT count(*) 
      INTO l_count
      FROM mgmt_target_assocs a
     WHERE a.source_target_guid = l_cluster_guid
       AND a.assoc_guid = MGMT_ASSOC.G_CONTAINS_GUID
       AND a.assoc_target_guid = l_member_guid
       AND a.scope_target_guid = MGMT_ASSOC.GLOBAL_SCOPE_TARGET_GUID;

    IF l_count < 1 THEN
      raise_application_error(MGMT_GLOBAL.ASSOC_DOES_NOT_EXIST_ERR, p_member_name||':'||p_member_type||
                                ' is not a member of cluster '||p_cluster_name||':'||p_cluster_type);
    END IF;
  
    EM_ASSOC.delete_target_assoc(MGMT_ASSOC.G_CONTAINS_GUID,
                                   l_cluster_guid, 
                                   l_member_guid);
  
   SELECT count(*)
     INTO l_count
     FROM mgmt_master_agent
    WHERE agent_guid = l_agent_guid
      AND target_guid = l_cluster_guid
      AND end_timestamp IS NULL;
   
   IF (l_count > 0) THEN
     EM_MASTER_AGENT.process_agent_deletion(l_agent_guid);
   ELSE
     DELETE
       FROM mgmt_target_agent_assoc
      WHERE target_guid = l_cluster_guid
        AND agent_guid = l_agent_guid;
   END IF;
   
    IF EMDW_LOG.P_IS_INFO_SET THEN 
      EMDW_LOG.INFO('remove_cluster_member: Exit ', MODULE_NAME) ; 
    END IF ;

  EXCEPTION
    WHEN OTHERS THEN
      IF (EMDW_LOG.p_is_error_set) THEN
        EMDW_LOG.ERROR('Exception in remove_cluster_member.', MODULE_NAME);
      END IF;
      raise_application_error(SQLCODE, 'Error removing Cluster Target Member.');
  END remove_cluster_member;
  
  
  --
  -- PROCEDURE: set_master_agent
  --
  -- PURPOSE: 
  --   To set the specific agent to be the master agent.
  --
  PROCEDURE set_master_agent
  (
    p_target_name IN mgmt_targets.target_name%TYPE,
    p_target_type IN mgmt_targets.target_type%TYPE,
    p_agent_name IN  mgmt_targets.target_name%TYPE
  )
  IS
    l_agent_guid mgmt_targets.target_guid%TYPE;
    l_target_guid mgmt_targets.target_guid%TYPE;
    l_target_tzrgn  mgmt_targets.timezone_region%TYPE;
    l_timestamp DATE;
  BEGIN

    IF EMDW_LOG.P_IS_INFO_SET THEN 
      EMDW_LOG.INFO('set_master_agent: Enter ' || p_target_name || ', ' || p_target_type ||
                     ', ' || p_agent_name, MODULE_NAME) ; 
    END IF ;

    l_target_guid := MGMT_TARGET.get_target_guid(p_target_name, p_target_type);

    SELECT timezone_region
      INTO l_target_tzrgn
      FROM mgmt_targets
     WHERE target_guid = l_target_guid;
       
    l_agent_guid := MGMT_TARGET.get_target_guid(p_agent_name, MGMT_GLOBAL.G_AGENT_TARGET_TYPE);
     
    l_timestamp := MGMT_GLOBAL.sysdate_tzrgn(l_target_tzrgn);
  
    EM_MASTER_AGENT.set_new_master_agent(l_target_guid, l_agent_guid, l_timestamp);

    IF EMDW_LOG.P_IS_INFO_SET THEN 
      EMDW_LOG.INFO('set_master_agent: Exit ', MODULE_NAME) ; 
    END IF ;
  END set_master_agent;

 FUNCTION is_agent_monitoring_target
 (
   p_target_guid IN mgmt_targets.target_guid%TYPE,
   p_emd_url IN  mgmt_targets.emd_url%TYPE
 ) RETURN BOOLEAN
 IS
  agent_mon_target BOOLEAN := false;
  l_cnt NUMBER := 0;
 BEGIN
   SELECT COUNT(*)
     INTO l_cnt
     FROM mgmt_targets
    WHERE target_guid = p_target_guid
      AND emd_url = p_emd_url;

   IF (l_cnt = 0)
   THEN
     agent_mon_target := false;
   ELSE
     agent_mon_target := true;
   END IF;

   RETURN agent_mon_target;
 END is_agent_monitoring_target;

 PROCEDURE submit_mod_tgt_dispname_job
  (
    p_target_name VARCHAR2,
    p_target_type VARCHAR2,
    p_target_display_name VARCHAR2
  )
  IS
  l_job_params MGMT_JOB_PARAM_LIST;
  l_job_targets MGMT_JOB_TARGET_LIST;
  l_schedule MGMT_JOB_SCHEDULE_RECORD;
  l_job_name VARCHAR2(64);
  l_job_id RAW(16);
  l_execution_id RAW(16);
  BEGIN

    -- This job has no targets.
    l_job_targets := MGMT_JOB_TARGET_LIST();
    l_job_targets.extend(1);
    l_job_targets(1) := MGMT_JOB_TARGET_RECORD(p_target_name,p_target_type);


    l_job_params := MGMT_JOB_PARAM_LIST();
    l_job_params.extend(1);
    l_job_params(1) := MGMT_JOB_PARAM_RECORD('targetDisplayName', 1,
                                            p_target_display_name , null);

    -- Its schedule is immediate.
    l_schedule := MGMT_JOBS.get_job_schedule_record(MGMT_JOBS.ONE_TIME_FREQUENCY_CODE,
                                           SYSDATE, null, 0, 0, 0, null, null,
                                           MGMT_JOBS.TIMEZONE_REPOSITORY,
                                           0, 0, null);

    l_job_name := 'MODTGTDISPNAME_JOB_' || SYS_GUID();

    -- Submit the job as a system job so that system thread pool is used
    MGMT_JOBS.submit_job(l_job_name,
                        'This is a modify target display name job',
                        'ModifyTargetDispNameJob',
                        l_job_targets,
                        l_job_params,
                        l_schedule,
                        l_job_id,
                        l_execution_id,
                        null,
                        MGMT_JOB_ENGINE.SYSTEM_JOB_RETRY);

  END submit_mod_tgt_dispname_job;

END EM_TARGET;
/

show errors
