Rem drv: <create type="pkgdefs" pos="user_model/user_model_pkgdefs.sql+"/>
Rem
Rem $Header: target_pkgdef.sql 16-jul-2006.23:24:46 neearora Exp $
Rem
Rem target_pkgdef.sql
Rem
Rem Copyright (c) 2002, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      target_pkgdef.sql - Support procedures related to targets
Rem        that are used internally (these are not part of the sdk)
Rem
Rem    DESCRIPTION
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       neearora 07/16/06  - Backport neearora_bug-5108394 from main 
Rem       neearora 04/23/06  - Bug 5108394. Adding function 
Rem                            is_agent_monitoring_target 
Rem       rkpandey 07/27/05  - Added get_agent_version 
Rem       rkpandey 07/19/05  - Added remove_cluster_member and 
Rem                            set_master_agent 
Rem       gsbhatia 07/01/05  - New repmgr header impl 
Rem       jsadras  04/21/05  - add registration lock 
Rem       ramalhot 04/05/05 -  type_display_name added to add_target 
Rem       neearora 03/24/05 - add check_type_ver_guid 
Rem       ramalhot 03/11/05 - add/modify target added 
Rem       jsadras  03/10/05 - add target metaver update callback 
Rem       rpinnama 02/25/05 - Add loader proc for handle target type versions 
Rem       pmodi    02/22/05 - Add setter/getter for repo tzr 
Rem       neearora 02/22/05 - added a new procedure get_factory_type 
Rem       ramalhot 02/03/05 - 
Rem       rkpandey 01/05/05 - delete_agent_target added 
Rem       ramalhot 01/11/05 - default value of order parameter changed in 
Rem                           add_tgt_pre_del_callback 
Rem       rpinnama 01/06/05 - Add target type procedures 
Rem       rpinnama 11/29/04 - Add set_target_tzrgn API. 
Rem       rkpandey 11/06/04 - Added delete_empty_cluster_target 
Rem       ramalhot 10/14/04 - Change parameter name 
Rem       ramalhot 10/14/04 - another version of pre delete callcbackk added 
Rem       ramalhot 08/18/04 - pre delete callback added 
Rem       skini    05/08/03 - skini_jobsystem_rac_support
Rem
Rem

-- 
-- Package: em_target
--
-- PURPOSE: 
--    This package contains internal procedures used by various
--    subsystems to obtain target (and metric) information.
--
-- NOTES: 
--
CREATE OR REPLACE PACKAGE EM_TARGET
AS

TYPE TGT_CURSOR IS REF CURSOR;
-- Module name used for logging
MODULE_NAME CONSTANT VARCHAR2(9)         := 'em.target';

EM_REPOSITORY_TIMEZONE CONSTANT VARCHAR2(32) := 'em_repository_timezone' ;

-- Constant for Default Factory Type
DEFAULT_FACTORY_TYPE CONSTANT NUMBER(1)  := 0;
-- Constant for Group Factory Type
GROUP_FACTORY_TYPE CONSTANT NUMBER(1)    := 1;
-- Constant for System Factory Type
SYSTEM_FACTORY_TYPE CONSTANT NUMBER(1)   := 2;
-- Constant for Service Factory Type
SERVICE_FACTORY_TYPE CONSTANT NUMBER(1)   := 3;
-- Constant for AggregateService Factory Type
AGG_SERVICE_FACTORY_TYPE CONSTANT NUMBER(1)   := 4;
-- Constant for Composite Factory Type
COMPOSITE_FACTORY_TYPE CONSTANT NUMBER(1)   := 5;
-- Constant for Cluster Factory Type
CLUSTER_FACTORY_TYPE CONSTANT NUMBER(1)   := 6;

--
-- get_response_metric_guid
--
-- Return the metric guid for the response metric for this target
-- A NO_DATA_FOUND is raised if the metric does not exist
--
FUNCTION get_response_metric_guid(p_target_guid RAW) RETURN RAW;

--
-- get_cluster_target_info
--
-- Obtain information about a cluster identified by 
-- p_cluster_name and p_cluster_type. Information about
-- the target is supplied in the following OUT parameters:
--
-- p_master_instance_name, p_master_instance_type: The name and 
--     type of the cluster instance that is currently on the 
--     "master" emd for the rac
-- p_master_emd_url: The current master emd url
-- p_instance_cursor_out: A cursor that includes the
--   (target name, target type, emd url) of each instance
--   that is not on the master
-- 

--
-- PROCEDURE: delete_empty_cluster_target
--
-- PURPOSE:
-- Check if the specified cluster target does not have any 
-- members. If it does not have members then delete the target.
--
-- IN Parameters:
--  p_target_name: Name of target
--  p_target_type: Type of target
--
PROCEDURE delete_empty_cluster_target(p_target_name IN VARCHAR2,
                          p_target_type IN VARCHAR2);

PROCEDURE get_cluster_target_info(p_cluster_name VARCHAR2,
                                  p_cluster_type VARCHAR2,
                                  p_master_instance_name_out OUT VARCHAR2,
                                  p_master_instance_type_out OUT VARCHAR2,
                                  p_master_emd_url_out OUT VARCHAR2,
                                  p_instance_cursor_out OUT TGT_CURSOR);


-- Procedure ADD_TARGET_PRE_DELETION_CALLBACK 
--
-- PURPOSE: To add a callback that will be called when a target is 
--   deleted (when delete_target() is called).

-- IN parameters:
--   p_procedure_name_in: The name of the callback procedure. This must
--      have the following signature: 
--      PROCEDURE PROC(p_target_name VARCHAR2, p_target_type VARCHAR2);
--   p_target_name : target name for which this callback should be removed (optional) 
--   p_target_type : Target type for which this callback should be removed (optional) 
--   p_delete_order : Order in which the callback should be called
--                    Valid range - 0 through 9
--                    0 - will be called first.
--                    9 - will be called last
--    Components that do not depend on any other components should register
--    themselves as 8. Example: assoc
--    Components for which no other components depend on them should register
--    themselves as 0. Example: system deletion callbacks
-- OUT parameters: 
--   No out parameters 
-- ERROR CODES:
--   None 
PROCEDURE add_tgt_pre_deletion_callback
(
    p_procedure_name IN VARCHAR2,
    p_target_name    IN mgmt_targets.target_name%TYPE DEFAULT ' ',
    p_target_type    IN mgmt_targets.target_type%TYPE DEFAULT ' ',
    p_delete_order   IN NUMBER DEFAULT 8
);

  -- Procedure ADD_TARGET_POST_DELETION_CALLBACK 
  --
  -- PURPOSE: To add a callback that will be called when a target is 
  --   deleted (when delete_target() is called).

  -- IN parameters:
  --   p_procedure_name_in: The name of the callback procedure. This must
  --      have the following signature: 
  --      PROCEDURE PROC(p_target_name VARCHAR2, p_target_type VARCHAR2,p_target_guid RAW);
  --   p_target_name : target name for which this callback should be removed (optional) 
  --   p_target_type : Target type for which this callback should be removed (optional) 
  --   p_delete_order : Order in which the callback should be called
  --                    Valid range - 0 through 9
  --                    0 - will be called first.
  --                    9 - will be called last
  --    Components that do not depend on any other components should register
  --    themselves as 9. Example: assoc
  --    Components for which no other components depend on them should register
  --    themselves as 0. Example: system deletion callbacks
  -- OUT parameters: 
  --   No out parameters 
  -- ERROR CODES:
  --   None 
  PROCEDURE add_tgt_post_deletion_callback
  (
    p_procedure_name IN VARCHAR2,
    p_target_name    IN mgmt_targets.target_name%TYPE DEFAULT ' ',
    p_target_type    IN mgmt_targets.target_type%TYPE DEFAULT ' ',
    p_delete_order   IN NUMBER DEFAULT 8
  );
  
  -- Procedure DEL_TAREET_PRE_DELETION_CALLBACK 
  --
  -- PURPOSE: To remove a callback that will be called when an target is
  --   deleted from the repository.
  -- IN parameters:
  --   p_procedure_name: The name of the callback procedure.
  --   p_target_name : target name for which this callback should be removed (optional)
  --   p_target_type : Target type for which this callback should be removed (optional)
  -- OUT parameters:
  --   No out parameters
  -- ERROR CODES:
  --   None
  PROCEDURE del_tgt_pre_deletion_callback
  (
    p_procedure_name IN VARCHAR2,
    p_target_name    IN mgmt_targets.target_name%TYPE DEFAULT ' ',
    p_target_type    IN mgmt_targets.target_type%TYPE DEFAULT ' '
  );

  PROCEDURE del_tgt_post_deletion_callback
  (
    p_procedure_name IN VARCHAR2,
    p_target_name    IN mgmt_targets.target_name%TYPE DEFAULT ' ',
    p_target_type    IN mgmt_targets.target_type%TYPE DEFAULT ' '
  );

  PROCEDURE exec_tgt_pre_del_callbacks
  (
    p_targets IN SMP_EMD_TGT_OBJECT_TBL 
  );

  PROCEDURE exec_tgt_post_del_callbacks
  (
    p_targets IN SMP_EMD_TGT_OBJECT_TBL 
  );

  -- Procedure SET_TARGET_TZRGN
  --
  -- PURPOSE: Sets the timezone region for the given target.
  -- 
  -- IN parameters:
  --   p_target_guid : The target guid for which the timezone region needs to be set.
  --   p_timezone_region : The timezone region to be set.
  --
  -- OUT parameters:
  --   No out parameters
  -- ERROR CODES:
  --   None
  PROCEDURE set_target_tzrgn(p_target_guid     IN RAW, 
                             p_timezone_region IN VARCHAR2);


  --                                  --
  -- Target type related procedures   --
  --                                  --

  --
  -- FUNCTION: generate_target_type_guid
  --
  -- PURPOSE: 
  --   Generates a guid for the target type
  FUNCTION generate_target_type_guid(p_target_type IN VARCHAR2)
      RETURN RAW;

  --
  -- FUNCTION: generate_type_version_guid
  --
  -- PURPOSE: 
  --   Generates a guid for the target type version
  FUNCTION generate_type_ver_guid(p_target_type IN VARCHAR2,
                                  p_type_meta_ver IN VARCHAR2 DEFAULT '1.0')
      RETURN RAW;


  --
  -- FUNCTION: compare_type_meta_vers
  --
  -- PURPOSE: 
  --   Compares two type_meta_vers and returns the bigger one
  -- IN parameters:
  --   p_type_meta_ver_1 : The first type meta version
  --   p_type_meta_ver_2 : The second type meta version
  -- OUT parameters:
  --   Retuns 1 if p_type_meta_ver_1 > p_type_meta_ver_2
  --         -1 if p_type_meta_ver_1 < p_type_meta_ver_2
  --          0 if p_type_meta_ver_1 = p_type_meta_ver_2
  -- ERROR CODES:
  --   None
  -- NOTES
  --   NULL meta ver is treated as equivalent to 1.0
  --
  FUNCTION compare_type_meta_vers(p_type_meta_ver_1 IN VARCHAR2,
                                  p_type_meta_ver_2 IN VARCHAR2)
      RETURN NUMBER;

  --
  -- FUNCTION: type_meta_ver_to_num
  --
  -- PURPOSE: 
  --   Converts the given type meta ver to number using the following:
  --   The number returned is 1000*maj_ver + min_ver
  -- IN parameters:
  --   p_type_meta_ver : The type meta version to be converted to number
  -- NOTES
  --   NULL meta ver is treated as equivalent to 1.0
  --   Also the assumption is that the minor version will never exceed 999
  FUNCTION type_meta_ver_to_num(p_type_meta_ver IN VARCHAR2)
    RETURN NUMBER;

  -- This should never be called externally! Only called from
  -- the system job that backgrounds the deletion


  PROCEDURE delete_agent_target_internal
  (
    p_target_name IN mgmt_targets.target_name%TYPE,
    p_target_type IN mgmt_targets.target_type%TYPE,
    p_member_target_names IN MGMT_JOB_VECTOR_PARAMS,
    p_member_target_types IN MGMT_JOB_VECTOR_PARAMS
  );

  -- Procedure to delete a host and all the targets hosted on it.
  --
  -- PRRPOSE:
  --
  -- IN parameters:
  --   p_target_name: VARCHAR2 The name of the target to be deleted
  --   p_target_type: VARCHAR2 The type of the target to be deleted
  --   p_delete_members: NUMBER Set to 1 for a composite target if you
  --     want all its members to be deleted as well. Defaults to 0.     
  --   p_delete_sync: BOOLEAN Set to TRUE if the agent deletion has to be 
  --     done in a synchronous fashion.
  --
  -- OUT parameters:
  -- No out parameters
  -- ERROR CODES:
  -- 20206: Target does not exist
  --

  PROCEDURE delete_agent_target
  (
    p_target_name IN mgmt_targets.target_name%TYPE,
    p_target_type IN mgmt_targets.target_type%TYPE,
    p_raise_composite_error IN BOOLEAN,
    p_delete_members IN BOOLEAN DEFAULT FALSE,
    p_delete_sync IN BOOLEAN DEFAULT FALSE
  );


  -- Procedure to set repository time zone
  --
  -- PURPOSE : To set default repository time zone. 
  --           This should be set at the repository creation time and should never be changed after creation.
  --
  -- IN parameters:
  --   p_repo_timezone : VARCHAR2 The timezone which to be set for repository
  --
  -- OUT parameter:
  --   None
  --
  -- ERROR CODES:
  --   MGMT_GLOBAL.INVALID_PARAM - If p_rep_timezone is NULL
  
  PROCEDURE set_repository_timezone 
  (
    p_repo_timezone IN VARCHAR2
  );

  -- Function to get repository time zone
  --
  -- PURPOSE : To get repository time zone. If repository timezone is not set the it will return timezone from SYSTIMESTAMP
  --
  -- IN parameters:
  --   None
  --
  -- OUT parameter:
  --   None
  --
  -- Return value:
  --   varchar2 The time zone of repository.
  
  FUNCTION get_repository_timezone RETURN VARCHAR2 ;


  --
  -- FUNCTION:  get_factory_type
  --
  -- PURPOSE: 
  --   Returns the factory type for a given target_type
  -- IN parameters:
  --   p_target_type : Target type of the target
  -- OUT parameters:
  --   Retuns 0 if target_type is DEFAULT 
  --          1 if target_type is GROUP 
  --          2 if target_type is SYSTEM 
  -- ERROR CODES:
  --   None
  --
  FUNCTION get_factory_type(p_target_type IN VARCHAR2)
    RETURN NUMBER;
  --
  -- Get registration lock 
  -- This needs to be acquired to prevent target type/version registrations
  --
  PROCEDURE get_type_registration_lock(p_target_type IN VARCHAR2) ;

  -- PL/SQL Procedure used by loader to handle target type versions ROWSET
  PROCEDURE add_target_type_version
    (p_target_type           IN VARCHAR2,
     p_type_meta_ver         IN VARCHAR2 DEFAULT '1.0',
     p_type_display_name     IN VARCHAR2 DEFAULT NULL,
     p_type_display_nlsid    IN VARCHAR2 DEFAULT NULL,
     p_type_resource_bundle  IN VARCHAR2 DEFAULT NULL,
     p_target_type_ver_guid  IN RAW      DEFAULT NULL);

  PROCEDURE add_target
  (
    p_target_guid OUT mgmt_targets.target_guid%TYPE, 
    p_target_name IN  mgmt_targets.target_name%TYPE,
    p_target_type IN  mgmt_targets.target_type%TYPE,
    p_host_name   IN  mgmt_targets.target_name%TYPE,
    p_properties  IN  MGMT_TARGET_PROPERTY_LIST
                        DEFAULT NULL,
    p_aggregates  IN  SMP_EMD_NVPAIR_ARRAY
                       DEFAULT NULL,
    p_monitoring_credentials IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL,
    p_target_display_name    IN mgmt_targets.display_name%TYPE 
                                  DEFAULT NULL,
    p_type_display_name      IN mgmt_targets.type_display_name%TYPE 
                                  DEFAULT NULL,
    p_agent_url       IN mgmt_targets.emd_url%TYPE 
                           DEFAULT NULL,
    p_tz_rgn          IN mgmt_targets.timezone_region%TYPE 
                           DEFAULT NULL, 
    p_mon_mode        IN mgmt_targets.monitoring_mode%TYPE 
                           DEFAULT MGMT_GLOBAL.G_MON_MODE_DEFAULT,
    p_type_meta_ver   IN VARCHAR2 
                           DEFAULT '1.0',
    p_category_prop_1 IN mgmt_targets.category_prop_1%TYPE
                           DEFAULT ' ',
    p_category_prop_2 IN mgmt_targets.category_prop_2%TYPE 
                           DEFAULT ' ',
    p_category_prop_3 IN mgmt_targets.category_prop_3%TYPE
                           DEFAULT ' ',
    p_category_prop_4 IN mgmt_targets.category_prop_4%TYPE
                           DEFAULT ' ',
    p_category_prop_5 IN mgmt_targets.category_prop_5%TYPE
                            DEFAULT ' ',
    p_repository_only_target   IN NUMBER 
                                    DEFAULT 0,
    p_target_owner             IN mgmt_targets.owner%TYPE
                                    DEFAULT NULL,
    p_is_group                 IN NUMBER 
                                    DEFAULT 0,
    p_required_parent_target_priv IN VARCHAR2 
                                    DEFAULT NULL,
    p_required_target_priv        IN VARCHAR2 
                                    DEFAULT NULL
  );

  PROCEDURE modify_target
  (
    p_target_guid OUT mgmt_targets.target_guid%TYPE,
    p_target_name IN  mgmt_targets.target_name%TYPE,
    p_target_type IN  mgmt_targets.target_type%TYPE,
    p_properties  IN  MGMT_TARGET_PROPERTY_LIST
                        DEFAULT NULL,
    p_monitoring_credentials      IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL,
    p_target_display_name         IN mgmt_targets.display_name%TYPE
                                       DEFAULT NULL,
    p_type_display_name           IN mgmt_targets.type_display_name%TYPE 
                                       DEFAULT NULL,
    p_tz_rgn                      IN mgmt_targets.timezone_region%TYPE
                                       DEFAULT NULL,
    p_target_owner                IN mgmt_targets.owner%TYPE
                                       DEFAULT NULL,
    p_propagate_to_agent          IN NUMBER
                                       DEFAULT 0,
    p_required_target_priv        IN VARCHAR2
                                       DEFAULT NULL
  );

  PROCEDURE add_aggregate_target
  (
    p_target_guid    OUT mgmt_targets.target_guid%TYPE,
    p_target_name    IN  mgmt_targets.target_name%TYPE,
    p_target_type    IN  mgmt_targets.target_type%TYPE,
    p_member_targets IN  SMP_EMD_NVPAIR_ARRAY 
                           DEFAULT NULL,
    p_host_name      IN  mgmt_targets.target_name%TYPE
                          DEFAULT NULL,
    p_properties     IN  MGMT_TARGET_PROPERTY_LIST
                          DEFAULT NULL,
    p_aggregates     IN  SMP_EMD_NVPAIR_ARRAY
                          DEFAULT NULL,
    p_monitoring_credentials IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL,
    p_target_display_name    IN mgmt_targets.display_name%TYPE
                                  DEFAULT NULL,
    p_type_display_name      IN mgmt_targets.type_display_name%TYPE 
                                  DEFAULT NULL,
    p_agent_url       IN mgmt_targets.emd_url%TYPE
                           DEFAULT NULL,
    p_tz_rgn          IN mgmt_targets.timezone_region%TYPE
                           DEFAULT NULL,
    p_mon_mode        IN mgmt_targets.monitoring_mode%TYPE
                           DEFAULT MGMT_GLOBAL.G_MON_MODE_DEFAULT,
    p_type_meta_ver   IN VARCHAR2
                           DEFAULT '1.0',
    p_category_prop_1 IN mgmt_targets.category_prop_1%TYPE
                           DEFAULT ' ',
    p_category_prop_2 IN mgmt_targets.category_prop_2%TYPE
                           DEFAULT ' ',
    p_category_prop_3 IN mgmt_targets.category_prop_3%TYPE
                           DEFAULT ' ',
    p_category_prop_4 IN mgmt_targets.category_prop_4%TYPE
                           DEFAULT ' ',
    p_category_prop_5 IN mgmt_targets.category_prop_5%TYPE
                            DEFAULT ' ',
    p_repository_only_target   IN NUMBER
                                    DEFAULT 0,
    p_target_owner             IN mgmt_targets.owner%TYPE
                                    DEFAULT NULL,
    p_is_group                 IN NUMBER 
                                    DEFAULT 0,
    p_required_parent_target_priv IN VARCHAR2
                                    DEFAULT NULL,
    p_required_target_priv        IN VARCHAR2
                                    DEFAULT NULL,
    p_required_member_priv        IN VARCHAR2
                                    DEFAULT NULL
  );

  PROCEDURE modify_aggregate_target
  (
    p_target_guid OUT mgmt_targets.target_guid%TYPE,
    p_target_name IN  mgmt_targets.target_name%TYPE,
    p_target_type IN  mgmt_targets.target_type%TYPE,
    p_member_targets_to_add    IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL,
    p_member_targets_to_remove IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL,
    p_properties  IN  MGMT_TARGET_PROPERTY_LIST
                        DEFAULT NULL,
    p_monitoring_credentials      IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL,
    p_target_display_name         IN mgmt_targets.display_name%TYPE
                                       DEFAULT NULL,
    p_type_display_name           IN mgmt_targets.type_display_name%TYPE 
                                       DEFAULT NULL,
    p_tz_rgn                      IN mgmt_targets.timezone_region%TYPE
                                       DEFAULT NULL,
    p_target_owner                IN mgmt_targets.owner%TYPE
                                       DEFAULT NULL,
    p_propagate_to_agent          IN NUMBER
                                       DEFAULT 0,
    p_required_target_priv        IN VARCHAR2
                                       DEFAULT NULL,
    p_required_member_priv        IN VARCHAR2
                                       DEFAULT NULL
    
  );

  PROCEDURE check_is_def_target_factory
  (
    p_target_type IN mgmt_targets.target_type%TYPE
  );

  --
  -- Execute the target property change callbacks
  --
  PROCEDURE exec_metaver_upd_callback
    (p_callback_array IN mgmt_target_meta_ver_cbk_array) ;

  -- FUNCTION: get_type_ver_guid.
  -- 
  -- PURPOSE:
  --    Return the GUID of the given target type for the given meta version
  --    If the target type of given meta version is not present then type_ver_not_exist exception is thrown
  -- IN parameters:
  --   p_target_type : Target type
  --   p_type_meta_ver : Meta version of the target type
  -- OUT parameters:
  --   None
  -- ERROR CODES:
  --   None
  -- EXCEPTION
  --   type_ver_not_exist
  FUNCTION get_type_ver_guid(p_target_type IN VARCHAR2, p_type_meta_ver IN VARCHAR2)
    RETURN RAW;

  -- PROCEDURE: check_type_ver_guid.
  -- 
  -- PURPOSE:
  --   Check that the given target type is registered for the given meta version
  --    If the target type of given meta version is not registered then type_ver_not_exist exception is thrown
  -- IN parameters:
  --   p_target_type : Target type
  --   p_type_meta_ver : Meta version of the target type
  -- OUT parameters:
  --   None
  -- ERROR CODES:
  --   None
  -- EXCEPTION
  --   type_ver_not_exist
  PROCEDURE check_type_ver_guid(p_target_type IN VARCHAR2, p_type_meta_ver IN VARCHAR2);

  --
  -- PROCEDURE : get_agent_version
  --
  -- PURPOSE
  --
  --   Gets the agent version.
  --  
  -- PARAMETERS
  --    IN parameters
  --         p_emd_url: emd_url of the agent
  --    OUT parameters 
  --         p_agent_version: version of the agent
  --  See signature.
  --
  -- NOTES
  --
  PROCEDURE get_agent_version
  (
    p_emd_url IN mgmt_targets.emd_url%TYPE,
    p_agent_version OUT mgmt_target_properties.property_value%TYPE
  );

  --
  -- PROCEDURE: remove_cluster_member
  --
  -- PURPOSE: 
  --   Remove the cluster member from the cluster target.
  -- 
  -- IN PARAMETERS:
  --   p_cluster_name: Name of the cluster target.
  --   p_cluster_type: Target type of the cluster target.
  --   p_member_name: Name of the member target.
  --   p_member_type: Target type of the member target.
  --   
  -- OUT PARAMETERS
  --   No out parameters.
  --
  -- NOTES
  --   This api does not delete the cluster member, it just removes the
  --   association with the cluster target.
  -- 

  PROCEDURE remove_cluster_member
  (
    p_cluster_name IN mgmt_targets.target_name%TYPE,
    p_cluster_type IN mgmt_targets.target_type%TYPE,
    p_member_name IN mgmt_targets.target_name%TYPE,
    p_member_type IN mgmt_targets.target_type%TYPE
  );

  --
  -- PROCEDURE: set_master_agent
  --
  -- PURPOSE:
  --   To set the specific agent to be the master agent.
  --
  -- IN PARAMETERS:
  --   p_target_name: The cluster target for which the master agent is to be set.
  --   p_target_type: The cluster target type.
  --   p_agent_name : The agent name which should be set as the master agent.
  --
  -- OUT PARAMETERS:
  --  No out parameters.
  --
  -- NOTES
  --
  PROCEDURE set_master_agent
  (
    p_target_name IN MGMT_TARGETS.TARGET_NAME%TYPE,
    p_target_type IN MGMT_TARGETS.TARGET_TYPE%TYPE,
    p_agent_name IN MGMT_TARGETS.TARGET_NAME%TYPE
  );

  --
  -- PROCEDURE: is_agent_monitoring_target
  --
  -- PURPOSE:
  --   To check whether the input agent is monitoring the input agent or not
  --
  -- IN PARAMETERS:
  --   p_target_guid: Guid of the target.
  --   p_emd_url: EMD URL of the agent.
  --
  -- OUT PARAMETERS:
  --  boolean : true if agent having emd_url = p_emd_url is monitoring target 
  --            specified by p_target_guid otherwise false
  --
  -- NOTES
  --
 FUNCTION is_agent_monitoring_target
 (
   p_target_guid IN mgmt_targets.target_guid%TYPE,
   p_emd_url IN  mgmt_targets.emd_url%TYPE
 ) RETURN BOOLEAN;


END EM_TARGET;
/

show errors
