rem handle target type host

BEGIN 
mgmt_target.register_target_type(
    p_target_type_in => 'host',
    p_type_meta_ver_in => '3.1',
    p_type_display_name_in => 'Host',
    p_type_display_nlsid_in => 'host_name',
    p_type_resource_bundle_in => MGMT_TARGET.G_DEFAULT_RESOURCE_BUNDLE);
END;
/

BEGIN 
emd_loader.end_metadata_set('host','3.1','MGMT_TARGET_TYPE_VERSIONS');
END;
/
DECLARE
  l_type_property_list SMP_EMD_NVPAIR_ARRAY;
  l_type_property SMP_EMD_NVPAIR;
BEGIN

l_type_property_list := SMP_EMD_NVPAIR_ARRAY();
l_type_property := SMP_EMD_NVPAIR( 'disallow_redundancy_group',
                                 '1');
l_type_property_list.extend(1);
l_type_property_list(l_type_property_list.count) := l_type_property;

mgmt_target.add_target_type_properties(
  p_target_type_in => 'host',
  p_type_property_list_in => l_type_property_list);
END;

/
BEGIN 
em_type_registry.upsert_target_assoc_def
(
  p_assoc_name => 'cluster_instance',
  p_source_target_type => 'host',
  p_assoc_target_type => 'cluster',
  p_scope_target_type => mgmt_assoc.GLOBAL_SCOPE_TARGET_TYPE,
  p_assoc_name_nlsid => NULL,
  p_description => NULL,
  p_description_nlsid => NULL,
  p_assoc_type => 'RELATES_TO',
  p_cardinality => mgmt_assoc.OPTIONAL_MULTI_CARDINAL);
END;
/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cpuLoad_1min',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Run Queue Length (1 minute average)',
        p_column_label_nlsid => 'host_load_cpuLoad_1min',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'CPU Load (1min)',
        p_short_name_nlsid => 'host_load_cpuLoad_1min_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cpuLoad',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Run Queue Length (5 minute average)',
        p_column_label_nlsid => 'host_load_cpuLoad',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'CPU Load (5min)',
        p_short_name_nlsid => 'host_load_cpuLoad_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cpuLoad_15min',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Run Queue Length (15 minute average)',
        p_column_label_nlsid => 'host_load_cpuLoad_15min',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'CPU Load (15min)',
        p_short_name_nlsid => 'host_load_cpuLoad_15min_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'noOfProcs',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Processes',
        p_column_label_nlsid => 'host_load_noOfProcs',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'noOfUsers',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Users',
        p_column_label_nlsid => 'host_load_noOfUsers',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'longestServ',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Longest Service Time (ms)',
        p_column_label_nlsid => 'host_longest_serv',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Longest IO(ms)',
        p_short_name_nlsid => 'host_longest_serv_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'activeMem',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Active Memory, Kilobytes',
        p_column_label_nlsid => 'host_load_activeMem',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'pgScanRate',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Memory Page Scan Rate (per second)',
        p_column_label_nlsid => 'host_load_pgscanrate',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Page Scan rate',
        p_short_name_nlsid => 'host_load_pgscanrate_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'totIO',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Disk I/O Per Second',
        p_column_label_nlsid => 'host_tot_io',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Total IO/sec',
        p_short_name_nlsid => 'host_tot_io_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'swapUtil',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Swap Utilization (%)',
        p_column_label_nlsid => 'host_load_swapUtil',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => 'Swap Util %',
        p_short_name_nlsid => 'host_load_swapUtil_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'memUsedPct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Memory Utilization (%)',
        p_column_label_nlsid => 'host_load_memUsedPct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => 'Mem Util %',
        p_short_name_nlsid => 'host_load_memUsedPct_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'memfreePct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Free Memory (%)',
        p_column_label_nlsid => 'host_load_memfreePct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'logicMemfreePct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Free Logical Memory (%)',
        p_column_label_nlsid => 'host_load_logicMemfreePct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;
NULL;
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cpuUtil',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'CPU Utilization (%)',
        p_column_label_nlsid => 'host_load_cpuIdle',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => 'CPU Util %',
        p_short_name_nlsid => 'host_load_cpuIdle_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cpuUser',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'CPU in User Mode (%)',
        p_column_label_nlsid => 'host_load_cpuUser',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cpuKernel',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'CPU in System Mode (%)',
        p_column_label_nlsid => 'host_load_cpuKernel',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cpuIOWait',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'CPU in I/O Wait (%)',
        p_column_label_nlsid => 'host_load_cpuIOWait',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => 'CPU IO Wait %',
        p_short_name_nlsid => 'host_load_cpuIOWait_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'Load',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Load',
    p_metric_label_nlsid => 'host_load',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cpuLoad_1min',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Run Queue Length (1 minute average)',
        p_column_label_nlsid => 'host_load_cpuLoad_1min',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'CPU Load (1min)',
        p_short_name_nlsid => 'host_load_cpuLoad_1min_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cpuLoad',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Run Queue Length (5 minute average)',
        p_column_label_nlsid => 'host_load_cpuLoad',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'CPU Load (5min)',
        p_short_name_nlsid => 'host_load_cpuLoad_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cpuLoad_15min',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Run Queue Length (15 minute average)',
        p_column_label_nlsid => 'host_load_cpuLoad_15min',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'CPU Load (15min)',
        p_short_name_nlsid => 'host_load_cpuLoad_15min_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'noOfProcs',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Processes',
        p_column_label_nlsid => 'host_load_noOfProcs',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Process Count',
        p_short_name_nlsid => 'host_load_noOfProcs_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'noOfUsers',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Users',
        p_column_label_nlsid => 'host_load_noOfUsers',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'activeMem',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Active Memory, Kilobytes',
        p_column_label_nlsid => 'host_load_activeMem',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'pgScanRate',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Memory Page Scan Rate (per second)',
        p_column_label_nlsid => 'host_load_pgscanrate',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Page Scan rate',
        p_short_name_nlsid => 'host_load_pgscanrate_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'totIO',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Total Disk I/O Per Second',
        p_column_label_nlsid => 'host_tot_io',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Total IO/sec',
        p_short_name_nlsid => 'host_tot_io_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'swapUtil',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Swap Utilization (%)',
        p_column_label_nlsid => 'host_load_swapUtil',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => 'Swap Util %',
        p_short_name_nlsid => 'host_load_swapUtil_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'memUsedPct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Memory Utilization (%)',
        p_column_label_nlsid => 'host_load_memUsedPct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => 'Mem Util %',
        p_short_name_nlsid => 'host_load_memUsedPct_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'memfreePct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Free Memory (%)',
        p_column_label_nlsid => 'host_load_memfreePct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'logicMemfreePct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Free Logical Memory (%)',
        p_column_label_nlsid => 'host_load_logicMemfreePct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;
NULL;
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cpuUtil',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'CPU Utilization (%)',
        p_column_label_nlsid => 'host_load_cpuIdle',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => 'CPU Util %',
        p_short_name_nlsid => 'host_load_cpuIdle_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cpuUser',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'CPU in User Mode (%)',
        p_column_label_nlsid => 'host_load_cpuUser',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => 'CPU Usr Mode %',
        p_short_name_nlsid => 'host_load_cpuUser_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cpuKernel',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'CPU in System Mode (%)',
        p_column_label_nlsid => 'host_load_cpuKernel',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => 'CPU Sys Mode %',
        p_short_name_nlsid => 'host_load_cpuKernel_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cpuIOWait',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'CPU in I/O Wait (%)',
        p_column_label_nlsid => 'host_load_cpuIOWait',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => 'CPU IO Wait %',
        p_short_name_nlsid => 'host_load_cpuIOWait_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => '_LoadInternal',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN,
    p_metric_label => '_LoadInternal',
    p_metric_label_nlsid => 'host_load_internal',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'mountPoint',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Mount Point',
        p_column_label_nlsid => 'host_filesys_mountPoint',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'fileSystem',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Filesystem',
        p_column_label_nlsid => 'host_filesys_fileSystem',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Filesystem Size (MB)',
        p_column_label_nlsid => 'host_filesys_size',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'pctAvailable',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Filesystem Space Available (%)',
        p_column_label_nlsid => 'host_filesys_pctAvailable',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'Filesystems',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Filesystems',
    p_metric_label_nlsid => 'host_filesys',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'interface',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Network Interface Name',
        p_column_label_nlsid => 'host_network_interface',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'inpErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => ' Network Interface Input Errors (%) ',
        p_column_label_nlsid => 'host_network_inpErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'outErrors',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Network Interface Output Errors (%)',
        p_column_label_nlsid => 'host_network_outErrors',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'collisions',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Network Interface Collisions (%)',
        p_column_label_nlsid => 'host_network_collisions',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'readRate',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Network Interface Read (MB/s)',
        p_column_label_nlsid => 'host_network_readRate',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'writeRate',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Network Interface Write (MB/s)',
        p_column_label_nlsid => 'host_network_writeRate',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'readThroughput',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Network Interface Read Utilization (%)',
        p_column_label_nlsid => 'host_network_readthroughput',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'writeThroughput',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Network Interface Write Utilization (%)',
        p_column_label_nlsid => 'host_network_writeThroughput',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'totalThroughput',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Network Interface Combined Utilization (%)',
        p_column_label_nlsid => 'host_network_totalThroughput',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'totalRate',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Network Interface Total I/O Rate (MB/sec)',
        p_column_label_nlsid => 'host_network_totalRate',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'totalErrorRate',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Network Interface Total Error Rate (%)',
        p_column_label_nlsid => 'host_network_totalErrorRate',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'Network',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Network Interfaces',
    p_metric_label_nlsid => 'host_network',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'user',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'User Name',
        p_column_label_nlsid => 'host_users_user',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'numLogons',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Number of Logons ',
        p_column_label_nlsid => 'host_users_numLogons',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'Users',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Users',
    p_metric_label_nlsid => 'host_users',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'pmem',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Memory Utilization for Top Processes (%)',
        p_column_label_nlsid => 'host_topProcs_pmem',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'pcpu',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'CPU Utilization for Top Processes (%)',
        p_column_label_nlsid => 'host_topProcs_pcpu',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'tottime',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'CPU Time for Top Processes',
        p_column_label_nlsid => 'host_topProcs_tottime',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'pvmsize',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Virtual Memory Utilization (KB)',
        p_column_label_nlsid => 'host_topProcs_pvmsize',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'pressize',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Physical Memory Utilization (KB)',
        p_column_label_nlsid => 'host_topProcs_pressize',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'userName',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Process User ID',
        p_column_label_nlsid => 'host_topProcs_userName',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'pid',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Process ID',
        p_column_label_nlsid => 'host_topProcs_pid',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'commandArgs',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Command and Arguments',
        p_column_label_nlsid => 'host_topProcs_commandArgs',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'Processes',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Top Processes',
    p_metric_label_nlsid => 'host_topProcs',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'cpuNumber',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'CPU Number',
        p_column_label_nlsid => 'host_cpu_number',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'userTimePct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'CPU User Time (%)',
        p_column_label_nlsid => 'host_user_time_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'systemTimePct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'CPU System Time (%)',
        p_column_label_nlsid => 'host_system_time_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'idleTimePct',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'CPU Idle Time (%)',
        p_column_label_nlsid => 'host_idle_time_pct',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'CPUUsage',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'CPU Usage',
    p_metric_label_nlsid => 'host_cpu_usage',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'BufferActivitybread',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Reads (per second)',
        p_column_label_nlsid => 'host_buffer_activity_bread',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'BufferActivitybwrit',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical Writes (per second)',
        p_column_label_nlsid => 'host_buffer_activity_bwrit',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'BufferActivitylread',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Buffer Cache Reads (per second)',
        p_column_label_nlsid => 'host_buffer_activity_lread',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'BufferActivitylwrit',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Buffer Cache Writes (per second)',
        p_column_label_nlsid => 'host_buffer_activity_lwrit',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'BufferActivityrcache',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Buffer Cache Read Hit Ratio (%)',
        p_column_label_nlsid => 'host_buffer_activity_rcache',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'BufferActivitywcache',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Buffer Cache Write Hit Ratio (%)',
        p_column_label_nlsid => 'host_buffer_activity_wcache',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'BufferActivitypread',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical I/O Reads (per second) ',
        p_column_label_nlsid => 'host_buffer_activity_pread',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'BufferActivitypwrit',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Physical I/O Writes (per second)',
        p_column_label_nlsid => 'host_buffer_activity_pwrit',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'BufferActivity',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Buffer Activity',
    p_metric_label_nlsid => 'host_buffer_activity',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'DiskActivitydevice',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Disk Device',
        p_column_label_nlsid => 'host_disk_activity_device',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'DiskActivitybusy',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Disk Device Busy (%)',
        p_column_label_nlsid => 'host_disk_activity_busy',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'diskActivReadsPerSec',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Disk Reads (per second)',
        p_column_label_nlsid => 'host_disk_activity_reads_per_sec',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'diskActivWritesPerSec',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Disk Writes (per second)',
        p_column_label_nlsid => 'host_disk_activity_writes_per_sec',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'diskActivNReadsDiff',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Difference in Number of Reads',
        p_column_label_nlsid => 'host_disk_activity_nreadsdiff',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'diskActivNWritesDiff',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Difference in Number of Writes',
        p_column_label_nlsid => 'host_disk_activity_nwritesdiff',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'DiskBlkioTicks',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Bulk IO Ticks',
        p_column_label_nlsid => 'host_disk_activity_blkioticks',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'DiskActivityavserv',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Average Disk I/O Service Time (ms)',
        p_column_label_nlsid => 'host_disk_activity_avserv',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'diskActivReadsBlks',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Disk Blocks Reads (per second)',
        p_column_label_nlsid => 'host_disk_activity_blocks_read_per_sec',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'diskActivWritesBlks',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Disk Block Writes (per second)',
        p_column_label_nlsid => 'host_disk_activity_blocks_written_per_sec',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'DiskActivity',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Disk Activity',
    p_metric_label_nlsid => 'host_disk_activity',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Pgactive',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Active Pages',
        p_column_label_nlsid => 'host_paging_activity_pgactive',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PginactiveDirty',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Inactive Dirty Pages',
        p_column_label_nlsid => 'host_paging_activity_pgdirty',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PginactiveClean',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Inactive Clean Pages',
        p_column_label_nlsid => 'host_paging_activity_pgclean',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PagingActivityppgout',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Pages Paged-out (per second)',
        p_column_label_nlsid => 'host_paging_activity_ppgout',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PagingActivityppgin',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Pages Paged-in (per second)',
        p_column_label_nlsid => 'host_paging_activity_ppgin',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PagingActivitypgscan',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Pages Scanned by Page Stealing Daemon (per second)',
        p_column_label_nlsid => 'host_paging_activity_pgscan',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;
NULL;

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'PagingActivity',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Paging Activity',
    p_metric_label_nlsid => 'host_paging_activity',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'TablesStatusfilesz',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Number Of Used File Handles',
        p_column_label_nlsid => 'host_tables_status_filesz',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'TablesStatusfilepsz',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Percentage Of Used File Handles',
        p_column_label_nlsid => 'host_tables_status_filepsz',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'TablesStatusinodsz',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Size of Inode Table',
        p_column_label_nlsid => 'host_tables_status_inodsz',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'TablesStatussupersz',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Number Of Super Block Handlers Allocated',
        p_column_label_nlsid => 'host_tables_status_supersz',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'TablesStatuspsupersz',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Percentage Of Allocated Super Block Handlers',
        p_column_label_nlsid => 'host_tables_status_psupersz',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'TablesStatusdquotsz',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Number Of Allocated Disk Quota Entries',
        p_column_label_nlsid => 'host_tables_status_dquotsz',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'TablesStatuspdquotsz',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Percentage Of Allocated Disk Quota Entries',
        p_column_label_nlsid => 'host_tables_status_pdquotsz',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'TablesStatusrtsigsz',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Number Of Queued RT Signals',
        p_column_label_nlsid => 'host_tables_status_rtsigsz',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'TablesStatusprtsigsz',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Percentage Of Queued RT Signals',
        p_column_label_nlsid => 'host_tables_status_prtsigsz',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'TablesStatus',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Process, Inode, File Tables Statistics',
    p_metric_label_nlsid => 'host_tables_status',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'SSSActivityswpin',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'System Swapins (per second)',
        p_column_label_nlsid => 'host_sss_activity_swpin',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'SSSActivityswpot',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'System Swapouts (per second)',
        p_column_label_nlsid => 'host_sss_activity_swpot',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'SSSActivitybswin',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Swapins Transfers (per second)',
        p_column_label_nlsid => 'host_sss_activity_bswin',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'SSSActivitybswot',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Swapout Transfers (per second)',
        p_column_label_nlsid => 'host_sss_activity_bswot',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'SSSActivitybswch',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Process Context Switches (per second)',
        p_column_label_nlsid => 'host_sss_activity_bswch',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'SSSActivity',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Switch/Swap Activity',
    p_metric_label_nlsid => 'host_sss_activity',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'Inventory',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_EXTERNAL,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Inventory',
    p_metric_label_nlsid => 'host_Inventory',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'collected_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'collected_time',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'linuxProvision',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Linux_Provision',
    p_metric_label_nlsid => 'host_linuxProvision',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Name',
        p_column_label_nlsid => 'host_collectSnapshot_name',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'collectSnapshot',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN,
    p_metric_label => 'Collect Snapshot',
    p_metric_label_nlsid => 'host_collectSnapshot',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ID',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Script',
        p_column_label_nlsid => 'host_udm_id',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'NumValue',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'User Defined Numeric Metric',
        p_column_label_nlsid => 'host_udm_value',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'StrValue',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'User Defined String Metric',
        p_column_label_nlsid => 'host_udm_strvalue',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'UDM',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'User Defined Metrics',
    p_metric_label_nlsid => 'host_udm',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 1,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 1,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'swapfile',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Swap File',
        p_column_label_nlsid => 'host_swap_swapfile',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'swaplen',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Swap Size',
        p_column_label_nlsid => 'host_swap_swaplen',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'swapfreesize',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Swap Free',
        p_column_label_nlsid => 'host_swap_swapfree',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'Swap_Area_Status',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Swap Area Status',
    p_metric_label_nlsid => 'host_swap',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'osName',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Operating System',
        p_column_label_nlsid => 'host_osConfig_osName',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'osVersion',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'OS Version',
        p_column_label_nlsid => 'host_osConfig_osVersion',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'osPatchLevel',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'OS Patch Level',
        p_column_label_nlsid => 'host_osConfig_osPatchLevel',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Platform',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Platform',
        p_column_label_nlsid => 'host_osConfig_platform',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Boottime',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Started since',
        p_column_label_nlsid => 'host_osConfig_boottime',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'IPAddress',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'IP address',
        p_column_label_nlsid => 'host_osConfig_ipAddress',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => '_OSConfig',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN,
    p_metric_label => '_OSConfig',
    p_metric_label_nlsid => 'host_osConfig',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'hs_supportparam',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Support Parameter',
        p_column_label_nlsid => 'hs_supportparam',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'is_hs_supported',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Supported',
        p_column_label_nlsid => 'hs_IsSupported',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'HostStorageSupport',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Host Storage Support',
    p_metric_label_nlsid => 'hs_support',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'yastBinary',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Yast Binary Path',
        p_column_label_nlsid => 'host_yastInfo_yastBinary',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'yastPatch',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Yast Patch Installed?',
        p_column_label_nlsid => 'host_yastInfo_yastPatch',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'yastEMWrapperScriptsPath',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'EM Yast Wrapper Scripts Path',
        p_column_label_nlsid => 'host_yastInfo_yastEMWrapperScriptsPath',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => '_YastInfo',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN,
    p_metric_label => '_YastInfo',
    p_metric_label_nlsid => 'host_yastInfo',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'openPorts',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Open Ports',
    p_metric_label_nlsid => 'host_open_ports_ESM',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'insecureServices',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Insecure Services',
    p_metric_label_nlsid => 'host_insecure_services_ESM',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'property',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'property',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'value',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'executeStack',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Execute Stack',
    p_metric_label_nlsid => 'execute_stack_ESM',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'file_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'File or Directory Name',
        p_column_label_nlsid => 'host_file_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'file_attribute_not_found',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'File or Directory Attribute Not Found',
        p_column_label_nlsid => 'host_file_attribute_not_found',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'file_permissions',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'File or Directory Permissions',
        p_column_label_nlsid => 'host_file_permissions',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'file_size',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'File or Directory Size (MB)',
        p_column_label_nlsid => 'host_file_size',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'file_sizechangerate',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'File or Directory Size Change Rate (KB/minute)',
        p_column_label_nlsid => 'host_file_sizechangerate',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'FileMonitoring',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'File and Directory Monitoring',
    p_metric_label_nlsid => 'file_monitoring',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'host_proc_zombie_percnt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Processes in Zombie State (%)',
        p_column_label_nlsid => 'host_proc_zombie_percnt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'proc_zombie',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Zombie Processes',
    p_metric_label_nlsid => 'host_proc_zombie',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'prog_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Program Name',
        p_column_label_nlsid => 'host_prog_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'owner',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Owner',
        p_column_label_nlsid => 'host_prog_owner',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'prog_max_cpu_util',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Program''s Max CPU Utilization (%) ',
        p_column_label_nlsid => 'host_prog_max_cpu_util',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'prog_total_cpu_util',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Program''s Total CPU Utilization (%) ',
        p_column_label_nlsid => 'host_prog_total_cpu_util',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'prog_max_cpu_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Program''s Max CPU Time Accumulated (Minutes) ',
        p_column_label_nlsid => 'host_prog_max_cpu_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'prog_total_cpu_time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Program''s Total CPU Time Accumulated (Minutes) ',
        p_column_label_nlsid => 'host_prog_total_cpu_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'prog_max_rss',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Program''s Max Resident Memory (MB) ',
        p_column_label_nlsid => 'host_prog_max_rss',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'prog_max_process_count',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Program''s Max Process Count',
        p_column_label_nlsid => 'host_prog_max_process_count',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'prog_min_process_count',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Program''s Min Process Count',
        p_column_label_nlsid => 'host_prog_min_process_count',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'ProgramResourceUtilization',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Program Resource Utilization',
    p_metric_label_nlsid => 'host_prog_util',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'log_file_name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Log File Name',
        p_column_label_nlsid => 'host_log_file_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'log_file_match_pattern',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Match Pattern in Perl',
        p_column_label_nlsid => 'host_log_file_match_pattern',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'log_file_ignore_pattern',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Ignore Pattern in Perl',
        p_column_label_nlsid => 'host_log_file_ignore_pattern',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'timestamp',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Time Stamp',
        p_column_label_nlsid => 'host_time_stamp',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 0,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'log_file_match_count',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Log File Pattern Matched Line Count',
        p_column_label_nlsid => 'host_log_file_match_count',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'log_file_message',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Log File Pattern Matched Content',
        p_column_label_nlsid => 'host_log_file_message',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'LogFileMonitoring',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Log File Monitoring',
    p_metric_label_nlsid => 'log_file_monitoring',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ChassisIndex',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Chassis Index',
        p_column_label_nlsid => 'host_PSChassisIndex',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PSIndex',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Power Supply Index',
        p_column_label_nlsid => 'host_PSIndex',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PowerSupplyStatus',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Power Supply Status',
        p_column_label_nlsid => 'host_PowerSupplyStatus',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'SupplyLocation',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Location',
        p_column_label_nlsid => 'host_SupplyLocation',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'OutputWatts',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Output (Tenths of Watts)',
        p_column_label_nlsid => 'host_OutputWatts',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('Dell_PowerEdge')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'PowerSupply',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Power Supplies',
    p_metric_label_nlsid => 'host_PowerSupply',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ChassisIndex',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Chassis Index',
        p_column_label_nlsid => 'host_PCIDChassisIndex',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PCIDeviceIndex',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'PCI Device Index',
        p_column_label_nlsid => 'host_PCIDeviceIndex',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PCIIndex',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'System Slot Index',
        p_column_label_nlsid => 'host_PCIIndex',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'PCIDeviceStatus',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'PCI Device Status',
        p_column_label_nlsid => 'host_PCIDeviceStatus',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Manufacturer',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Manufacturer',
        p_column_label_nlsid => 'host_Manufacturer',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Description',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Description',
        p_column_label_nlsid => 'host_Description',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('Dell_PowerEdge')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'PCIDevice',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'PCI Devices',
    p_metric_label_nlsid => 'host_PCIDevice',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ChassisIndex',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Chassis Index',
        p_column_label_nlsid => 'host_BChassisIndex',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'BiosIndex',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'System BIOS Index',
        p_column_label_nlsid => 'host_BiosIndex',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'BiosStatus',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'System BIOS Status',
        p_column_label_nlsid => 'host_BiosStatus',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'BiosSize',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Size',
        p_column_label_nlsid => 'host_BiosSize',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'BiosVersion',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Version',
        p_column_label_nlsid => 'host_BiosVersion',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'BiosManufacturer',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Manufacturer',
        p_column_label_nlsid => 'host_BiosManufacturer',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('Dell_PowerEdge')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'Bios',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'System BIOS',
    p_metric_label_nlsid => 'host_Bios',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ChassisIndex',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Chassis Index',
        p_column_label_nlsid => 'host_FChassisIndex',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'FanIndex',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Fan Index',
        p_column_label_nlsid => 'host_FanIndex',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'FanStatus',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Fan Status',
        p_column_label_nlsid => 'host_FanStatus',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'FanLocation',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Location',
        p_column_label_nlsid => 'host_FanLocation',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('Dell_PowerEdge')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'Fan',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Fans',
    p_metric_label_nlsid => 'host_Fan',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ChassisIndex',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Chassis Index',
        p_column_label_nlsid => 'host_TChassisIndex',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ProbeIndex',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Temperature Probe Index',
        p_column_label_nlsid => 'host_ProbeIndex',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'TemperatureStatus',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Temperature Probe Status',
        p_column_label_nlsid => 'host_TemperatureStatus',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'TemperatureLocation',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Location',
        p_column_label_nlsid => 'host_TemperatureLocation',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'TemperatureReading',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Current Temperature',
        p_column_label_nlsid => 'host_TemperatureReading',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('Dell_PowerEdge')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'Temperature',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Temperature',
    p_metric_label_nlsid => 'host_Temperature',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ChassisIndex',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Chassis Index',
        p_column_label_nlsid => 'host_PChassisIndex',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ProcessorIndex',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Processor Index',
        p_column_label_nlsid => 'host_ProcessorIndex',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ProcessorManufacturer',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Manufacturer',
        p_column_label_nlsid => 'host_ProcessorManufacturer',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ProcessorStatus',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Processor Status',
        p_column_label_nlsid => 'host_ProcessorStatus',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ProcessorFamily',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Family',
        p_column_label_nlsid => 'host_ProcessorFamily',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ProcessorMaxSpeed',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Speed (MHz)',
        p_column_label_nlsid => 'host_ProcessorMaxSpeed',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ProcessorVersion',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Version',
        p_column_label_nlsid => 'host_ProcessorVersion',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('Dell_PowerEdge')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'Processor',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Processors',
    p_metric_label_nlsid => 'host_Processor',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ChassisIndex',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Chassis',
        p_column_label_nlsid => 'host_MChassisIndex',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'MemoryIndex',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Index',
        p_column_label_nlsid => 'host_MemoryIndex',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'MemoryStatus',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Memory Status',
        p_column_label_nlsid => 'host_MemoryStatus',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'MemoryType',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Type',
        p_column_label_nlsid => 'host_MemoryType',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'MemoryLocation',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Location',
        p_column_label_nlsid => 'host_MemoryLocation',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'MemoryBankLocation',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Bank Location',
        p_column_label_nlsid => 'host_MemoryBankLocation',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'MemorySize',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Size (MB)',
        p_column_label_nlsid => 'host_MemorySize',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('Dell_PowerEdge')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'Memory',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Memory Devices',
    p_metric_label_nlsid => 'host_Memory',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'StateSettings',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Remote Access Card State',
        p_column_label_nlsid => 'host_StateSettings',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'RACStatus',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Remote Access Card Status',
        p_column_label_nlsid => 'host_RACStatus',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ProductName',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Product Name',
        p_column_label_nlsid => 'host_ProductName',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Version',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Version',
        p_column_label_nlsid => 'host_Version',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'LanSettings',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'LAN Settings',
        p_column_label_nlsid => 'host_LanSettings',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'IPAddress',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'IP Address',
        p_column_label_nlsid => 'host_IPAddress',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'NetmaskAddress',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Network Mask Address',
        p_column_label_nlsid => 'host_NetmaskAddress',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'GatewayAddress',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Gateway Address',
        p_column_label_nlsid => 'host_GatewayAddress',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'DHCPSettings',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'DHCP Settings',
        p_column_label_nlsid => 'host_DHCPSettings',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux'),
        p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('Dell_PowerEdge')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'RemoteAccessCard',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Remote Access Card',
    p_metric_label_nlsid => 'host_RemoteAccessCard',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'key_value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'key for storage entity',
        p_column_label_nlsid => 'host_storage_report_key_value',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'key',
        p_short_name_nlsid => 'host_storage_report_key_value_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'global_unique_id',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Globally Unique Identifier for storage entity',
        p_column_label_nlsid => 'host_storage_report_global_unique_id',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Globally Unique Identifier',
        p_short_name_nlsid => 'host_storage_report_global_unique_id_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'name',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Name for storage entity',
        p_column_label_nlsid => 'host_storage_report_name',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Name',
        p_short_name_nlsid => 'host_storage_report_name_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'storage_layer',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Storage Layer for storage entity',
        p_column_label_nlsid => 'host_storage_report_storage_layer',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Storage Layer',
        p_short_name_nlsid => 'host_storage_report_storage_layer_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'em_query_flag',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Query Flag for storage entity',
        p_column_label_nlsid => 'host_storage_report_em_query_flag',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Query Flag',
        p_short_name_nlsid => 'host_storage_report_em_query_flag_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'entity_type',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Entity Type for storage entity',
        p_column_label_nlsid => 'host_storage_report_entity_type',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Entity type',
        p_short_name_nlsid => 'host_storage_report_entity_type_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'rawsizeb',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Raw Size for storage entity',
        p_column_label_nlsid => 'host_storage_report_rawsizeb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Raw Size',
        p_short_name_nlsid => 'host_storage_report_rawsizeb_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sizeb',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Size for storage entity',
        p_column_label_nlsid => 'host_storage_report_sizeb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Size',
        p_short_name_nlsid => 'host_storage_report_sizeb_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'usedb',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Used Size for storage entity',
        p_column_label_nlsid => 'host_storage_report_usedb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Used Size',
        p_short_name_nlsid => 'host_storage_report_usedb_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'freeb',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Free Size for storage entity',
        p_column_label_nlsid => 'host_storage_report_freeb',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Free Size',
        p_short_name_nlsid => 'host_storage_report_freeb_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'a1',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Attribute for storage entity',
        p_column_label_nlsid => 'host_storage_report_a1',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Attribute',
        p_short_name_nlsid => 'host_storage_report_a1_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'a2',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Attribute for storage entity',
        p_column_label_nlsid => 'host_storage_report_a2',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Attribute',
        p_short_name_nlsid => 'host_storage_report_a2_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'a3',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Attribute for storage entity',
        p_column_label_nlsid => 'host_storage_report_a3',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Attribute',
        p_short_name_nlsid => 'host_storage_report_a3_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'a4',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Attribute for storage entity',
        p_column_label_nlsid => 'host_storage_report_a4',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Attribute',
        p_short_name_nlsid => 'host_storage_report_a4_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'a5',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Attribute for storage entity',
        p_column_label_nlsid => 'host_storage_report_a5',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Attribute',
        p_short_name_nlsid => 'host_storage_report_a5_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'a6',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Attribute for storage entity',
        p_column_label_nlsid => 'host_storage_report_a6',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Attribute',
        p_short_name_nlsid => 'host_storage_report_a6_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'a7',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Attribute for storage entity',
        p_column_label_nlsid => 'host_storage_report_a7',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Attribute',
        p_short_name_nlsid => 'host_storage_report_a7_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'a8',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Attribute for storage entity',
        p_column_label_nlsid => 'host_storage_report_a8',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Attribute',
        p_short_name_nlsid => 'host_storage_report_a8_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'storage_reporting_data',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Storage Data',
    p_metric_label_nlsid => 'storage_reporting_data',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'key_value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'key for storage entity',
        p_column_label_nlsid => 'host_storage_report_key_value',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'key',
        p_short_name_nlsid => 'host_storage_report_key_value_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'parent_key_value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Key for storage entity',
        p_column_label_nlsid => 'host_storage_report_parent_key_value',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Key for the parent Storage Entity',
        p_short_name_nlsid => 'host_storage_report_parent_key_value_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'storage_reporting_keys',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Storage Data Keys',
    p_metric_label_nlsid => 'storage_reporting_keys',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'key_value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'key for storage entity',
        p_column_label_nlsid => 'host_storage_report_key_value',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'key',
        p_short_name_nlsid => 'host_storage_report_key_value_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'value',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Alias value for storage entity',
        p_column_label_nlsid => 'host_storage_report_alias_value',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Alias value for the Storage Entity',
        p_short_name_nlsid => 'host_storage_report_alias_value_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'file_type',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Storage entity File Type',
        p_column_label_nlsid => 'host_storage_report_alias_file_type',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Storage Entity File Type',
        p_short_name_nlsid => 'host_storage_report_alias_file_type_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'storage_reporting_alias',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Storage Data Aliases',
    p_metric_label_nlsid => 'storage_reporting_alias',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'type',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Type of message',
        p_column_label_nlsid => 'host_storage_report_type',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Type',
        p_short_name_nlsid => 'host_storage_report_type_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'message_counter',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Message Counter',
        p_column_label_nlsid => 'host_storage_report_message_counter',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Message Counter',
        p_short_name_nlsid => 'host_storage_report_message_counter_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'message_id',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Message Id',
        p_column_label_nlsid => 'host_storage_report_message_id',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Message Id',
        p_short_name_nlsid => 'host_storage_report_message_id_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'message_params',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Message Parameters',
        p_column_label_nlsid => 'host_storage_report_message_paramms',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Message Parameters',
        p_short_name_nlsid => 'host_storage_report_message_params_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'action_id',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Action Id',
        p_column_label_nlsid => 'host_storage_report_action_id',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Action Id',
        p_short_name_nlsid => 'host_storage_report_action_id_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'action_params',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Action Parameters',
        p_column_label_nlsid => 'host_storage_report_action_params',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Action Parameters',
        p_short_name_nlsid => 'host_storage_report_action_params_short',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'storage_reporting_issues',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Storage Data Issues',
    p_metric_label_nlsid => 'storage_reporting_issues',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'vip',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Virtual IP Name',
        p_column_label_nlsid => 'host_crs_vip_name',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'relocated',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Virtual IP Relocated',
        p_column_label_nlsid => 'host_crs_vip_relocated',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'current_node',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Current Node',
        p_column_label_nlsid => 'host_crs_current_node',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux'),
        p_catprop_4_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','11gR1')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'VIPRelocation',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'CRS Virtual IP Relocation Status',
    p_metric_label_nlsid => 'host_crs_vip_relocation',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'nodeapps',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Nodeapp',
        p_column_label_nlsid => 'host_crs_nodeapps',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'status',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Nodeapp Status',
        p_column_label_nlsid => 'host_nodeapps_status',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux'),
        p_catprop_4_choices => MGMT_CATEGORY_PROP_ARRAY('10gR1','10gR2','11gR1')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'CRSResource',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'CRS Nodeapp Status',
    p_metric_label_nlsid => 'host_crs_nodeapp_status',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'timeLine',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Time/Line Number',
        p_column_label_nlsid => 'alertLog_timeLine',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'clusterwareErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Clusterware Service Alert Log Error',
        p_column_label_nlsid => 'alertLog_clusterwareErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'resourceErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'CRS Resource Alert Log Error',
        p_column_label_nlsid => 'alertLog_resourceErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'ocrErrStack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'OCR Alert Log Error',
        p_column_label_nlsid => 'alertLog_ocrErrStack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 0,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'alertLogName',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Alert Log Name',
        p_column_label_nlsid => 'alertLog_fileName',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux'),
        p_catprop_4_choices => MGMT_CATEGORY_PROP_ARRAY('10gR2','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'CRSAlert',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Clusterware Alert Log',
    p_metric_label_nlsid => 'host_crs_alert_log',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'CRS_status',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Clusterware Status',
        p_column_label_nlsid => 'crs_metric_status',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux'),
        p_catprop_4_choices => MGMT_CATEGORY_PROP_ARRAY('10gR2','11gR1','11gR2')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'CRSStatus',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Clusterware',
    p_metric_label_nlsid => 'crs_metric',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'nodeName',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'nodeName',
        p_column_label_nlsid => ' ',
        p_is_key => 1,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'clusterName',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'clusterName',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'clusterHome',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'clusterHome',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'nodeList',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'nodeList',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'nodeStatus',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'nodeStatus',
        p_column_label_nlsid => ' ',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := MGMT_VALIDIF_ARRAY();
  l_valid_if := MGMT_VALIDIF_OBJ.NEW(
        p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY('Linux')
  );
l_valid_if_list.extend(1);
l_valid_if_list(1) := l_valid_if;
  em_type_registry.upsert_metric(
    p_target_type => 'host',
    p_metric_name => 'ClusterNodeInformation',
    p_type_meta_ver => '3.1',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_RAW,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'ClusterNodeInformation',
    p_metric_label_nlsid => NULL,
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
emd_loader.end_metadata_set('host','3.1','MGMT_METRICS');
END;
/

BEGIN 
MGMT_TARGET.UPSERT_TARGET_PROPERTY_DEF(
              v_target_type => 'host',
              v_type_meta_ver => '3.1',
              v_property_name => 'CommunityString',
              v_property_type => 'INSTANCE',
              v_property_display_name => 'SNMP Community String (Default: public)',
              v_property_display_nlsid => 'host_snmp_community_string',
              v_required_flag => 0,
              v_credential_flag => 1,
              v_default_value => 'public',
              v_computed_flag => 0 );

MGMT_TARGET.UPSERT_TARGET_PROPERTY_DEF(
              v_target_type => 'host',
              v_type_meta_ver => '3.1',
              v_property_name => 'LIMIT_TO',
              v_property_type => 'INSTANCE',
              v_property_display_name => 'Disk Activity Metrics Collection Max Rows Upload(>0) Default:16',
              v_property_display_nlsid => 'maximum_disk_activity_rows_upload',
              v_required_flag => 0,
              v_credential_flag => 0,
              v_default_value => '16',
              v_computed_flag => 0 );

MGMT_TARGET.UPSERT_TARGET_PROPERTY_DEF(
              v_target_type => 'host',
              v_type_meta_ver => '3.1',
              v_property_name => 'SNMPHostname',
              v_property_type => 'INSTANCE',
              v_property_display_name => 'SNMP Hostname',
              v_property_display_nlsid => 'host_snmp_hostname',
              v_required_flag => 0,
              v_credential_flag => 0,
              v_default_value => '127.0.0.1',
              v_computed_flag => 0 );

MGMT_TARGET.UPSERT_TARGET_PROPERTY_DEF(
              v_target_type => 'host',
              v_type_meta_ver => '3.1',
              v_property_name => 'Timeout',
              v_property_type => 'INSTANCE',
              v_property_display_name => 'SNMP Timeout (Default: 10 seconds)',
              v_property_display_nlsid => 'host_snmp_timeout',
              v_required_flag => 0,
              v_credential_flag => 0,
              v_default_value => '10',
              v_computed_flag => 0 );

END;
/

BEGIN 
emd_loader.end_metadata_set('host','3.1','MGMT_TARGET_PROP_DEFS');
END;
/
DECLARE
  l_ref MGMT_CRED_TYPE_REF;
  l_ref_list MGMT_CRED_TYPE_REF_ARRAY;
  l_type_column MGMT_CRED_TYPE_COL_RECORD;
  l_type_column_list MGMT_CRED_TYPE_COL_ARRAY;
  l_type_col_val MGMT_CRED_TYPE_COL_VAL;
  l_type_col_val_list MGMT_CRED_TYPE_COL_VAL_ARRAY; 
  l_ref_type_meta_ver MGMT_METRICS.TYPE_META_VER%TYPE; 
  col_count INTEGER;
  ref_count INTEGER;
  l_type_column_display_name MGMT_CREDENTIAL_TYPE_COLUMNS.TYPE_COLUMN_DISPLAY_NAME%TYPE;
  l_type_column_display_nlsid MGMT_CREDENTIAL_TYPE_COLUMNS.TYPE_COLUMN_DISPLAY_NLSID%TYPE;
  l_key MGMT_CREDENTIAL_TYPE_COLUMNS.KEY%TYPE;
BEGIN 

l_ref_list := MGMT_CRED_TYPE_REF_ARRAY();
l_type_column_list := MGMT_CRED_TYPE_COL_ARRAY();

emd_loader.end_metadata_set('host','3.1','MGMT_CREDENTIAL_TYPE_COLUMNS');

l_type_col_val_list := MGMT_CRED_TYPE_COL_VAL_ARRAY();

l_type_column := MGMT_CRED_TYPE_COL_RECORD(
            type_column_name => 'HostUserName',
            key => 1,
            ref_name => NULL,
            ref_column_name => NULL,
            type_column_display_name => 'UserName',
            type_column_display_nlsid => 'CREDS_HOST_USERNAME',
            col_values => l_type_col_val_list
                      );


l_type_column_list.extend(1);
col_count := l_type_column_list.count;
l_type_column_list(col_count) :=  l_type_column;
emd_loader.end_metadata_set('host','3.1','MGMT_CREDENTIAL_TYPE_COLUMNS');

l_type_col_val_list := MGMT_CRED_TYPE_COL_VAL_ARRAY();

l_type_column := MGMT_CRED_TYPE_COL_RECORD(
            type_column_name => 'HostPassword',
            key => 0,
            ref_name => NULL,
            ref_column_name => NULL,
            type_column_display_name => 'Password',
            type_column_display_nlsid => 'CREDS_HOST_Password',
            col_values => l_type_col_val_list
                      );


l_type_column_list.extend(1);
col_count := l_type_column_list.count;
l_type_column_list(col_count) :=  l_type_column;
mgmt_credential.create_credential_type( 
       p_target_type => 'host',
       p_type_name => 'HostCreds',
       p_target_type_meta_ver => '3.1',
       p_type_display_name => 'Host Credentials',
       p_type_display_nlsid => 'CREDS_HOST_HOSTCREDS',
       p_description => '' ,
       p_refs => l_ref_list,
       p_type_columns => l_type_column_list
        );
EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  BEGIN 
    BEGIN 
    insert into MGMT_CREDENTIAL_TYPES ( target_type, target_type_meta_ver, type_name, type_display_name, type_display_nlsid, description ) values ( 'host','3.1','HostCreds','Host Credentials','CREDS_HOST_HOSTCREDS','' );
    EXCEPTION
      WHEN DUP_VAL_ON_INDEX THEN
      update MGMT_CREDENTIAL_TYPES set 
         target_type = 'host',
         target_type_meta_ver = '3.1',
         type_name = 'HostCreds',
         type_display_name = 'Host Credentials',
         type_display_nlsid = 'CREDS_HOST_HOSTCREDS',
         description = ''
      WHERE
         target_type = 'host' AND 
         target_type_meta_ver = '3.1' AND 
         type_name = 'HostCreds';
    END;
     BEGIN 
      insert into MGMT_CREDENTIAL_TYPE_COLUMNS ( target_type, target_type_meta_ver, type_name, type_column_name, ref_name, ref_column_name, type_column_display_name, type_column_display_nlsid, key ) values ( 'host','3.1','HostCreds','HostUserName',NULL,NULL,'UserName','CREDS_HOST_USERNAME',1 );
    EXCEPTION
      WHEN DUP_VAL_ON_INDEX THEN
    UPDATE MGMT_CREDENTIAL_TYPE_COLUMNS SET 
      target_type = 'host',
      target_type_meta_ver = '3.1',
      type_name = 'HostCreds',
      type_column_name = 'HostUserName',
      ref_name = NULL,
      ref_column_name = NULL,
      type_column_display_name = 'UserName',
      type_column_display_nlsid = 'CREDS_HOST_USERNAME',
      key = 1
    WHERE 
      target_type = 'host' AND 
      target_type_meta_ver = '3.1' AND 
      type_name = 'HostCreds' AND 
      type_column_name = 'HostUserName' ;
    END;
     BEGIN 
      insert into MGMT_CREDENTIAL_TYPE_COLUMNS ( target_type, target_type_meta_ver, type_name, type_column_name, ref_name, ref_column_name, type_column_display_name, type_column_display_nlsid, key ) values ( 'host','3.1','HostCreds','HostPassword',NULL,NULL,'Password','CREDS_HOST_Password',0 );
    EXCEPTION
      WHEN DUP_VAL_ON_INDEX THEN
    UPDATE MGMT_CREDENTIAL_TYPE_COLUMNS SET 
      target_type = 'host',
      target_type_meta_ver = '3.1',
      type_name = 'HostCreds',
      type_column_name = 'HostPassword',
      ref_name = NULL,
      ref_column_name = NULL,
      type_column_display_name = 'Password',
      type_column_display_nlsid = 'CREDS_HOST_Password',
      key = 0
    WHERE 
      target_type = 'host' AND 
      target_type_meta_ver = '3.1' AND 
      type_name = 'HostCreds' AND 
      type_column_name = 'HostPassword' ;
    END;
  END;
 END;
/
BEGIN 
emd_loader.end_metadata_set('host','3.1','MGMT_CREDENTIAL_TYPES');
END;
/
DECLARE
  l_ref MGMT_CRED_TYPE_REF;
  l_ref_list MGMT_CRED_TYPE_REF_ARRAY;
  l_type_column MGMT_CRED_TYPE_COL_RECORD;
  l_type_column_list MGMT_CRED_TYPE_COL_ARRAY;
  l_type_col_val MGMT_CRED_TYPE_COL_VAL;
  l_type_col_val_list MGMT_CRED_TYPE_COL_VAL_ARRAY; 
  l_ref_type_meta_ver MGMT_METRICS.TYPE_META_VER%TYPE; 
  col_count INTEGER;
  ref_count INTEGER;
  l_type_column_display_name MGMT_CREDENTIAL_TYPE_COLUMNS.TYPE_COLUMN_DISPLAY_NAME%TYPE;
  l_type_column_display_nlsid MGMT_CREDENTIAL_TYPE_COLUMNS.TYPE_COLUMN_DISPLAY_NLSID%TYPE;
  l_key MGMT_CREDENTIAL_TYPE_COLUMNS.KEY%TYPE;
BEGIN 

l_ref_list := MGMT_CRED_TYPE_REF_ARRAY();
l_type_column_list := MGMT_CRED_TYPE_COL_ARRAY();

emd_loader.end_metadata_set('host','3.1','MGMT_CREDENTIAL_TYPE_COLUMNS');

l_type_col_val_list := MGMT_CRED_TYPE_COL_VAL_ARRAY();

l_type_column := MGMT_CRED_TYPE_COL_RECORD(
            type_column_name => 'InstallUserName',
            key => 1,
            ref_name => NULL,
            ref_column_name => NULL,
            type_column_display_name => 'UserName',
            type_column_display_nlsid => 'CREDS_INSTALL_USER',
            col_values => l_type_col_val_list
                      );


l_type_column_list.extend(1);
col_count := l_type_column_list.count;
l_type_column_list(col_count) :=  l_type_column;
emd_loader.end_metadata_set('host','3.1','MGMT_CREDENTIAL_TYPE_COLUMNS');

l_type_col_val_list := MGMT_CRED_TYPE_COL_VAL_ARRAY();

l_type_column := MGMT_CRED_TYPE_COL_RECORD(
            type_column_name => 'InstallPassword',
            key => 0,
            ref_name => NULL,
            ref_column_name => NULL,
            type_column_display_name => 'Password',
            type_column_display_nlsid => 'CREDS_INSTALL_PASSWORD',
            col_values => l_type_col_val_list
                      );


l_type_column_list.extend(1);
col_count := l_type_column_list.count;
l_type_column_list(col_count) :=  l_type_column;
emd_loader.end_metadata_set('host','3.1','MGMT_CREDENTIAL_TYPE_COLUMNS');

l_type_col_val_list := MGMT_CRED_TYPE_COL_VAL_ARRAY();

l_type_column := MGMT_CRED_TYPE_COL_RECORD(
            type_column_name => 'OMSRegistrationPassword',
            key => 0,
            ref_name => NULL,
            ref_column_name => NULL,
            type_column_display_name => 'Registration Password',
            type_column_display_nlsid => 'CREDS_OMS_REGISTRATION_PASSWORD',
            col_values => l_type_col_val_list
                      );


l_type_column_list.extend(1);
col_count := l_type_column_list.count;
l_type_column_list(col_count) :=  l_type_column;
emd_loader.end_metadata_set('host','3.1','MGMT_CREDENTIAL_TYPE_COLUMNS');

l_type_col_val_list := MGMT_CRED_TYPE_COL_VAL_ARRAY();

l_type_column := MGMT_CRED_TYPE_COL_RECORD(
            type_column_name => 'ProvCompPasswd',
            key => 0,
            ref_name => NULL,
            ref_column_name => NULL,
            type_column_display_name => 'Comp Password',
            type_column_display_nlsid => 'CREDS_COMP_SECRET_PASSWORD',
            col_values => l_type_col_val_list
                      );


l_type_column_list.extend(1);
col_count := l_type_column_list.count;
l_type_column_list(col_count) :=  l_type_column;
mgmt_credential.create_credential_type( 
       p_target_type => 'host',
       p_type_name => 'ProvisionCreds',
       p_target_type_meta_ver => '3.1',
       p_type_display_name => 'Provisioning Credentials',
       p_type_display_nlsid => 'CREDS_PROVISION',
       p_description => '' ,
       p_refs => l_ref_list,
       p_type_columns => l_type_column_list
        );
EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  BEGIN 
    BEGIN 
    insert into MGMT_CREDENTIAL_TYPES ( target_type, target_type_meta_ver, type_name, type_display_name, type_display_nlsid, description ) values ( 'host','3.1','ProvisionCreds','Provisioning Credentials','CREDS_PROVISION','' );
    EXCEPTION
      WHEN DUP_VAL_ON_INDEX THEN
      update MGMT_CREDENTIAL_TYPES set 
         target_type = 'host',
         target_type_meta_ver = '3.1',
         type_name = 'ProvisionCreds',
         type_display_name = 'Provisioning Credentials',
         type_display_nlsid = 'CREDS_PROVISION',
         description = ''
      WHERE
         target_type = 'host' AND 
         target_type_meta_ver = '3.1' AND 
         type_name = 'ProvisionCreds';
    END;
     BEGIN 
      insert into MGMT_CREDENTIAL_TYPE_COLUMNS ( target_type, target_type_meta_ver, type_name, type_column_name, ref_name, ref_column_name, type_column_display_name, type_column_display_nlsid, key ) values ( 'host','3.1','ProvisionCreds','InstallUserName',NULL,NULL,'UserName','CREDS_INSTALL_USER',1 );
    EXCEPTION
      WHEN DUP_VAL_ON_INDEX THEN
    UPDATE MGMT_CREDENTIAL_TYPE_COLUMNS SET 
      target_type = 'host',
      target_type_meta_ver = '3.1',
      type_name = 'ProvisionCreds',
      type_column_name = 'InstallUserName',
      ref_name = NULL,
      ref_column_name = NULL,
      type_column_display_name = 'UserName',
      type_column_display_nlsid = 'CREDS_INSTALL_USER',
      key = 1
    WHERE 
      target_type = 'host' AND 
      target_type_meta_ver = '3.1' AND 
      type_name = 'ProvisionCreds' AND 
      type_column_name = 'InstallUserName' ;
    END;
     BEGIN 
      insert into MGMT_CREDENTIAL_TYPE_COLUMNS ( target_type, target_type_meta_ver, type_name, type_column_name, ref_name, ref_column_name, type_column_display_name, type_column_display_nlsid, key ) values ( 'host','3.1','ProvisionCreds','InstallPassword',NULL,NULL,'Password','CREDS_INSTALL_PASSWORD',0 );
    EXCEPTION
      WHEN DUP_VAL_ON_INDEX THEN
    UPDATE MGMT_CREDENTIAL_TYPE_COLUMNS SET 
      target_type = 'host',
      target_type_meta_ver = '3.1',
      type_name = 'ProvisionCreds',
      type_column_name = 'InstallPassword',
      ref_name = NULL,
      ref_column_name = NULL,
      type_column_display_name = 'Password',
      type_column_display_nlsid = 'CREDS_INSTALL_PASSWORD',
      key = 0
    WHERE 
      target_type = 'host' AND 
      target_type_meta_ver = '3.1' AND 
      type_name = 'ProvisionCreds' AND 
      type_column_name = 'InstallPassword' ;
    END;
     BEGIN 
      insert into MGMT_CREDENTIAL_TYPE_COLUMNS ( target_type, target_type_meta_ver, type_name, type_column_name, ref_name, ref_column_name, type_column_display_name, type_column_display_nlsid, key ) values ( 'host','3.1','ProvisionCreds','OMSRegistrationPassword',NULL,NULL,'Registration Password','CREDS_OMS_REGISTRATION_PASSWORD',0 );
    EXCEPTION
      WHEN DUP_VAL_ON_INDEX THEN
    UPDATE MGMT_CREDENTIAL_TYPE_COLUMNS SET 
      target_type = 'host',
      target_type_meta_ver = '3.1',
      type_name = 'ProvisionCreds',
      type_column_name = 'OMSRegistrationPassword',
      ref_name = NULL,
      ref_column_name = NULL,
      type_column_display_name = 'Registration Password',
      type_column_display_nlsid = 'CREDS_OMS_REGISTRATION_PASSWORD',
      key = 0
    WHERE 
      target_type = 'host' AND 
      target_type_meta_ver = '3.1' AND 
      type_name = 'ProvisionCreds' AND 
      type_column_name = 'OMSRegistrationPassword' ;
    END;
     BEGIN 
      insert into MGMT_CREDENTIAL_TYPE_COLUMNS ( target_type, target_type_meta_ver, type_name, type_column_name, ref_name, ref_column_name, type_column_display_name, type_column_display_nlsid, key ) values ( 'host','3.1','ProvisionCreds','ProvCompPasswd',NULL,NULL,'Comp Password','CREDS_COMP_SECRET_PASSWORD',0 );
    EXCEPTION
      WHEN DUP_VAL_ON_INDEX THEN
    UPDATE MGMT_CREDENTIAL_TYPE_COLUMNS SET 
      target_type = 'host',
      target_type_meta_ver = '3.1',
      type_name = 'ProvisionCreds',
      type_column_name = 'ProvCompPasswd',
      ref_name = NULL,
      ref_column_name = NULL,
      type_column_display_name = 'Comp Password',
      type_column_display_nlsid = 'CREDS_COMP_SECRET_PASSWORD',
      key = 0
    WHERE 
      target_type = 'host' AND 
      target_type_meta_ver = '3.1' AND 
      type_name = 'ProvisionCreds' AND 
      type_column_name = 'ProvCompPasswd' ;
    END;
  END;
 END;
/
BEGIN 
emd_loader.end_metadata_set('host','3.1','MGMT_CREDENTIAL_TYPES');
END;
/
DECLARE
  l_set_column MGMT_CRED_SET_COL_RECORD;
  l_set_column_list MGMT_CRED_SET_COL_ARRAY;
  l_set_col_val MGMT_CRED_SET_COL_VAL;
  l_set_col_val_list MGMT_CRED_SET_COL_VAL_ARRAY;
BEGIN 

l_set_column_list := MGMT_CRED_SET_COL_ARRAY();
emd_loader.end_metadata_set('host','3.1','MGMT_CREDENTIAL_SET_COLUMNS');
l_set_col_val_list := MGMT_CRED_SET_COL_VAL_ARRAY();
l_set_column := MGMT_CRED_SET_COL_RECORD(
            type_column_name => 'HostUserName',
            set_column_name => 'username',
            set_column_values => l_set_col_val_list,
          set_column_display_name => 'Normal Username',
          set_column_display_nlsid => 'CREDS_NORMAL_USER'
                        );
l_set_column_list.extend(1);
l_set_column_list(1) :=  l_set_column;
emd_loader.end_metadata_set('host','3.1','MGMT_CREDENTIAL_SET_COLUMNS');
l_set_col_val_list := MGMT_CRED_SET_COL_VAL_ARRAY();
l_set_column := MGMT_CRED_SET_COL_RECORD(
            type_column_name => 'HostPassword',
            set_column_name => 'password',
            set_column_values => l_set_col_val_list,
          set_column_display_name => 'Normal Password',
          set_column_display_nlsid => 'CREDS_NORMAL_PASSWORD'
                        );
l_set_column_list.extend(1);
l_set_column_list(2) :=  l_set_column;
mgmt_credential.create_credential_set(
         p_target_type => 'host',
         p_set_name => 'HostCredsNormal',
         p_set_usage => 'PREFERRED_CRED',
         p_set_context_type => 'TARGET',
         p_set_context => NULL,
         p_set_display_name => 'Normal Host Credentials',
         p_set_display_nlsid => 'CREDS_HOST_HOSTCREDS_NORMAL',
         p_type_name => 'HostCreds',
         p_set_columns => l_set_column_list,
         p_target_type_meta_ver => '3.1');
EXCEPTION
WHEN DUP_VAL_ON_INDEX THEN
BEGIN 
  BEGIN 
    insert into MGMT_CREDENTIAL_SETS ( target_type, target_type_meta_ver, set_name, set_display_name, set_display_nlsid, credential_type_name, set_usage, set_context_type, set_context ) values ( 'host','3.1','HostCredsNormal','Normal Host Credentials','CREDS_HOST_HOSTCREDS_NORMAL','HostCreds','PREFERRED_CRED','TARGET',' '  );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SETS  set 
     target_type = 'host',
    target_type_meta_ver = '3.1',
    set_name = 'HostCredsNormal',
    set_display_name = 'Normal Host Credentials',
    set_display_nlsid = 'CREDS_HOST_HOSTCREDS_NORMAL',
    credential_type_name = 'HostCreds',
    set_usage = 'PREFERRED_CRED',
    set_context_type = 'TARGET',
    set_context = ' '
  WHERE 
    target_type = 'host' AND 
    target_type_meta_ver = '3.1' AND 
    set_name = 'HostCredsNormal';
  END;
  BEGIN 
    insert into MGMT_CREDENTIAL_SET_COLUMNS ( target_type, target_type_meta_ver, set_name, set_column_name, set_column_display_name, set_column_display_nlsid, type_column_name ) values ( 'host','3.1','HostCredsNormal','username','Normal Username','CREDS_NORMAL_USER','HostUserName' );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SET_COLUMNS set 
     target_type = 'host',
    target_type_meta_ver = '3.1',
    set_name = 'HostCredsNormal',
    set_column_name = 'username',
    set_column_display_name = 'Normal Username',
    set_column_display_nlsid = 'CREDS_NORMAL_USER',
    type_column_name = 'HostUserName'
   WHERE
     target_type = 'host' AND 
     target_type_meta_ver = '3.1' AND 
     set_name = 'HostCredsNormal' AND 
     set_column_name = 'username';
  END;
  BEGIN 
    insert into MGMT_CREDENTIAL_SET_COLUMNS ( target_type, target_type_meta_ver, set_name, set_column_name, set_column_display_name, set_column_display_nlsid, type_column_name ) values ( 'host','3.1','HostCredsNormal','password','Normal Password','CREDS_NORMAL_PASSWORD','HostPassword' );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SET_COLUMNS set 
     target_type = 'host',
    target_type_meta_ver = '3.1',
    set_name = 'HostCredsNormal',
    set_column_name = 'password',
    set_column_display_name = 'Normal Password',
    set_column_display_nlsid = 'CREDS_NORMAL_PASSWORD',
    type_column_name = 'HostPassword'
   WHERE
     target_type = 'host' AND 
     target_type_meta_ver = '3.1' AND 
     set_name = 'HostCredsNormal' AND 
     set_column_name = 'password';
  END;
END; 
END;
/
BEGIN 
emd_loader.end_metadata_set('host','3.1','MGMT_CREDENTIAL_SETS');
END;
/
DECLARE
  l_set_column MGMT_CRED_SET_COL_RECORD;
  l_set_column_list MGMT_CRED_SET_COL_ARRAY;
  l_set_col_val MGMT_CRED_SET_COL_VAL;
  l_set_col_val_list MGMT_CRED_SET_COL_VAL_ARRAY;
BEGIN 

l_set_column_list := MGMT_CRED_SET_COL_ARRAY();
emd_loader.end_metadata_set('host','3.1','MGMT_CREDENTIAL_SET_COLUMNS');
l_set_col_val_list := MGMT_CRED_SET_COL_VAL_ARRAY();
l_set_column := MGMT_CRED_SET_COL_RECORD(
            type_column_name => 'HostUserName',
            set_column_name => 'username',
            set_column_values => l_set_col_val_list,
          set_column_display_name => 'Privileged Username',
          set_column_display_nlsid => 'CREDS_PRIV_USER'
                        );
l_set_column_list.extend(1);
l_set_column_list(1) :=  l_set_column;
emd_loader.end_metadata_set('host','3.1','MGMT_CREDENTIAL_SET_COLUMNS');
l_set_col_val_list := MGMT_CRED_SET_COL_VAL_ARRAY();
l_set_column := MGMT_CRED_SET_COL_RECORD(
            type_column_name => 'HostPassword',
            set_column_name => 'password',
            set_column_values => l_set_col_val_list,
          set_column_display_name => 'Privileged Password',
          set_column_display_nlsid => 'CREDS_PRIV_PASSWORD'
                        );
l_set_column_list.extend(1);
l_set_column_list(2) :=  l_set_column;
mgmt_credential.create_credential_set(
         p_target_type => 'host',
         p_set_name => 'HostCredsPriv',
         p_set_usage => 'PREFERRED_CRED',
         p_set_context_type => 'TARGET',
         p_set_context => NULL,
         p_set_display_name => 'Privileged Host Credentials',
         p_set_display_nlsid => 'CREDS_HOST_HOSTCREDS_PRIVILEGED',
         p_type_name => 'HostCreds',
         p_set_columns => l_set_column_list,
         p_target_type_meta_ver => '3.1');
EXCEPTION
WHEN DUP_VAL_ON_INDEX THEN
BEGIN 
  BEGIN 
    insert into MGMT_CREDENTIAL_SETS ( target_type, target_type_meta_ver, set_name, set_display_name, set_display_nlsid, credential_type_name, set_usage, set_context_type, set_context ) values ( 'host','3.1','HostCredsPriv','Privileged Host Credentials','CREDS_HOST_HOSTCREDS_PRIVILEGED','HostCreds','PREFERRED_CRED','TARGET',' '  );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SETS  set 
     target_type = 'host',
    target_type_meta_ver = '3.1',
    set_name = 'HostCredsPriv',
    set_display_name = 'Privileged Host Credentials',
    set_display_nlsid = 'CREDS_HOST_HOSTCREDS_PRIVILEGED',
    credential_type_name = 'HostCreds',
    set_usage = 'PREFERRED_CRED',
    set_context_type = 'TARGET',
    set_context = ' '
  WHERE 
    target_type = 'host' AND 
    target_type_meta_ver = '3.1' AND 
    set_name = 'HostCredsPriv';
  END;
  BEGIN 
    insert into MGMT_CREDENTIAL_SET_COLUMNS ( target_type, target_type_meta_ver, set_name, set_column_name, set_column_display_name, set_column_display_nlsid, type_column_name ) values ( 'host','3.1','HostCredsPriv','username','Privileged Username','CREDS_PRIV_USER','HostUserName' );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SET_COLUMNS set 
     target_type = 'host',
    target_type_meta_ver = '3.1',
    set_name = 'HostCredsPriv',
    set_column_name = 'username',
    set_column_display_name = 'Privileged Username',
    set_column_display_nlsid = 'CREDS_PRIV_USER',
    type_column_name = 'HostUserName'
   WHERE
     target_type = 'host' AND 
     target_type_meta_ver = '3.1' AND 
     set_name = 'HostCredsPriv' AND 
     set_column_name = 'username';
  END;
  BEGIN 
    insert into MGMT_CREDENTIAL_SET_COLUMNS ( target_type, target_type_meta_ver, set_name, set_column_name, set_column_display_name, set_column_display_nlsid, type_column_name ) values ( 'host','3.1','HostCredsPriv','password','Privileged Password','CREDS_PRIV_PASSWORD','HostPassword' );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SET_COLUMNS set 
     target_type = 'host',
    target_type_meta_ver = '3.1',
    set_name = 'HostCredsPriv',
    set_column_name = 'password',
    set_column_display_name = 'Privileged Password',
    set_column_display_nlsid = 'CREDS_PRIV_PASSWORD',
    type_column_name = 'HostPassword'
   WHERE
     target_type = 'host' AND 
     target_type_meta_ver = '3.1' AND 
     set_name = 'HostCredsPriv' AND 
     set_column_name = 'password';
  END;
END; 
END;
/
BEGIN 
emd_loader.end_metadata_set('host','3.1','MGMT_CREDENTIAL_SETS');
END;
/
DECLARE
  l_set_column MGMT_CRED_SET_COL_RECORD;
  l_set_column_list MGMT_CRED_SET_COL_ARRAY;
  l_set_col_val MGMT_CRED_SET_COL_VAL;
  l_set_col_val_list MGMT_CRED_SET_COL_VAL_ARRAY;
BEGIN 

l_set_column_list := MGMT_CRED_SET_COL_ARRAY();
emd_loader.end_metadata_set('host','3.1','MGMT_CREDENTIAL_SET_COLUMNS');
l_set_col_val_list := MGMT_CRED_SET_COL_VAL_ARRAY();
l_set_column := MGMT_CRED_SET_COL_RECORD(
            type_column_name => 'HostUserName',
            set_column_name => 'OHUsername',
            set_column_values => l_set_col_val_list,
          set_column_display_name => 'Oracle Home UserName',
          set_column_display_nlsid => 'CREDS_OH_USER'
                        );
l_set_column_list.extend(1);
l_set_column_list(1) :=  l_set_column;
emd_loader.end_metadata_set('host','3.1','MGMT_CREDENTIAL_SET_COLUMNS');
l_set_col_val_list := MGMT_CRED_SET_COL_VAL_ARRAY();
l_set_column := MGMT_CRED_SET_COL_RECORD(
            type_column_name => 'HostPassword',
            set_column_name => 'OHPassword',
            set_column_values => l_set_col_val_list,
          set_column_display_name => 'Oracle Home Password',
          set_column_display_nlsid => 'CREDS_OH_PASSWORD'
                        );
l_set_column_list.extend(1);
l_set_column_list(2) :=  l_set_column;
mgmt_credential.create_credential_set(
         p_target_type => 'host',
         p_set_name => 'OHCreds',
         p_set_usage => 'PREFERRED_CRED',
         p_set_context_type => 'CONTAINER',
         p_set_context => NULL,
         p_set_display_name => NULL,
         p_set_display_nlsid => NULL,
         p_type_name => 'HostCreds',
         p_set_columns => l_set_column_list,
         p_target_type_meta_ver => '3.1');
EXCEPTION
WHEN DUP_VAL_ON_INDEX THEN
BEGIN 
  BEGIN 
    insert into MGMT_CREDENTIAL_SETS ( target_type, target_type_meta_ver, set_name, set_display_name, set_display_nlsid, credential_type_name, set_usage, set_context_type, set_context ) values ( 'host','3.1','OHCreds',NULL,NULL,'HostCreds','PREFERRED_CRED','CONTAINER',' '  );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SETS  set 
     target_type = 'host',
    target_type_meta_ver = '3.1',
    set_name = 'OHCreds',
    set_display_name = NULL,
    set_display_nlsid = NULL,
    credential_type_name = 'HostCreds',
    set_usage = 'PREFERRED_CRED',
    set_context_type = 'CONTAINER',
    set_context = ' '
  WHERE 
    target_type = 'host' AND 
    target_type_meta_ver = '3.1' AND 
    set_name = 'OHCreds';
  END;
  BEGIN 
    insert into MGMT_CREDENTIAL_SET_COLUMNS ( target_type, target_type_meta_ver, set_name, set_column_name, set_column_display_name, set_column_display_nlsid, type_column_name ) values ( 'host','3.1','OHCreds','OHUsername','Oracle Home UserName','CREDS_OH_USER','HostUserName' );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SET_COLUMNS set 
     target_type = 'host',
    target_type_meta_ver = '3.1',
    set_name = 'OHCreds',
    set_column_name = 'OHUsername',
    set_column_display_name = 'Oracle Home UserName',
    set_column_display_nlsid = 'CREDS_OH_USER',
    type_column_name = 'HostUserName'
   WHERE
     target_type = 'host' AND 
     target_type_meta_ver = '3.1' AND 
     set_name = 'OHCreds' AND 
     set_column_name = 'OHUsername';
  END;
  BEGIN 
    insert into MGMT_CREDENTIAL_SET_COLUMNS ( target_type, target_type_meta_ver, set_name, set_column_name, set_column_display_name, set_column_display_nlsid, type_column_name ) values ( 'host','3.1','OHCreds','OHPassword','Oracle Home Password','CREDS_OH_PASSWORD','HostPassword' );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SET_COLUMNS set 
     target_type = 'host',
    target_type_meta_ver = '3.1',
    set_name = 'OHCreds',
    set_column_name = 'OHPassword',
    set_column_display_name = 'Oracle Home Password',
    set_column_display_nlsid = 'CREDS_OH_PASSWORD',
    type_column_name = 'HostPassword'
   WHERE
     target_type = 'host' AND 
     target_type_meta_ver = '3.1' AND 
     set_name = 'OHCreds' AND 
     set_column_name = 'OHPassword';
  END;
END; 
END;
/
BEGIN 
emd_loader.end_metadata_set('host','3.1','MGMT_CREDENTIAL_SETS');
END;
/
DECLARE
  l_set_column MGMT_CRED_SET_COL_RECORD;
  l_set_column_list MGMT_CRED_SET_COL_ARRAY;
  l_set_col_val MGMT_CRED_SET_COL_VAL;
  l_set_col_val_list MGMT_CRED_SET_COL_VAL_ARRAY;
BEGIN 

l_set_column_list := MGMT_CRED_SET_COL_ARRAY();
emd_loader.end_metadata_set('host','3.1','MGMT_CREDENTIAL_SET_COLUMNS');
l_set_col_val_list := MGMT_CRED_SET_COL_VAL_ARRAY();
l_set_column := MGMT_CRED_SET_COL_RECORD(
            type_column_name => 'HostUserName',
            set_column_name => 'username',
            set_column_values => l_set_col_val_list,
          set_column_display_name => 'UserName',
          set_column_display_nlsid => 'CREDS_UDM_USER'
                        );
l_set_column_list.extend(1);
l_set_column_list(1) :=  l_set_column;
emd_loader.end_metadata_set('host','3.1','MGMT_CREDENTIAL_SET_COLUMNS');
l_set_col_val_list := MGMT_CRED_SET_COL_VAL_ARRAY();
l_set_column := MGMT_CRED_SET_COL_RECORD(
            type_column_name => 'HostPassword',
            set_column_name => 'password',
            set_column_values => l_set_col_val_list,
          set_column_display_name => 'Password',
          set_column_display_nlsid => 'CREDS_UDM_PASSWORD'
                        );
l_set_column_list.extend(1);
l_set_column_list(2) :=  l_set_column;
mgmt_credential.create_credential_set(
         p_target_type => 'host',
         p_set_name => 'HostUDMCreds',
         p_set_usage => 'MONITORING',
         p_set_context_type => 'COLLECTION',
         p_set_context => NULL,
         p_set_display_name => NULL,
         p_set_display_nlsid => NULL,
         p_type_name => 'HostCreds',
         p_set_columns => l_set_column_list,
         p_target_type_meta_ver => '3.1');
EXCEPTION
WHEN DUP_VAL_ON_INDEX THEN
BEGIN 
  BEGIN 
    insert into MGMT_CREDENTIAL_SETS ( target_type, target_type_meta_ver, set_name, set_display_name, set_display_nlsid, credential_type_name, set_usage, set_context_type, set_context ) values ( 'host','3.1','HostUDMCreds',NULL,NULL,'HostCreds','MONITORING','COLLECTION',' '  );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SETS  set 
     target_type = 'host',
    target_type_meta_ver = '3.1',
    set_name = 'HostUDMCreds',
    set_display_name = NULL,
    set_display_nlsid = NULL,
    credential_type_name = 'HostCreds',
    set_usage = 'MONITORING',
    set_context_type = 'COLLECTION',
    set_context = ' '
  WHERE 
    target_type = 'host' AND 
    target_type_meta_ver = '3.1' AND 
    set_name = 'HostUDMCreds';
  END;
  BEGIN 
    insert into MGMT_CREDENTIAL_SET_COLUMNS ( target_type, target_type_meta_ver, set_name, set_column_name, set_column_display_name, set_column_display_nlsid, type_column_name ) values ( 'host','3.1','HostUDMCreds','username','UserName','CREDS_UDM_USER','HostUserName' );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SET_COLUMNS set 
     target_type = 'host',
    target_type_meta_ver = '3.1',
    set_name = 'HostUDMCreds',
    set_column_name = 'username',
    set_column_display_name = 'UserName',
    set_column_display_nlsid = 'CREDS_UDM_USER',
    type_column_name = 'HostUserName'
   WHERE
     target_type = 'host' AND 
     target_type_meta_ver = '3.1' AND 
     set_name = 'HostUDMCreds' AND 
     set_column_name = 'username';
  END;
  BEGIN 
    insert into MGMT_CREDENTIAL_SET_COLUMNS ( target_type, target_type_meta_ver, set_name, set_column_name, set_column_display_name, set_column_display_nlsid, type_column_name ) values ( 'host','3.1','HostUDMCreds','password','Password','CREDS_UDM_PASSWORD','HostPassword' );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SET_COLUMNS set 
     target_type = 'host',
    target_type_meta_ver = '3.1',
    set_name = 'HostUDMCreds',
    set_column_name = 'password',
    set_column_display_name = 'Password',
    set_column_display_nlsid = 'CREDS_UDM_PASSWORD',
    type_column_name = 'HostPassword'
   WHERE
     target_type = 'host' AND 
     target_type_meta_ver = '3.1' AND 
     set_name = 'HostUDMCreds' AND 
     set_column_name = 'password';
  END;
END; 
END;
/
BEGIN 
emd_loader.end_metadata_set('host','3.1','MGMT_CREDENTIAL_SETS');
END;
/
DECLARE
  l_set_column MGMT_CRED_SET_COL_RECORD;
  l_set_column_list MGMT_CRED_SET_COL_ARRAY;
  l_set_col_val MGMT_CRED_SET_COL_VAL;
  l_set_col_val_list MGMT_CRED_SET_COL_VAL_ARRAY;
BEGIN 

l_set_column_list := MGMT_CRED_SET_COL_ARRAY();
emd_loader.end_metadata_set('host','3.1','MGMT_CREDENTIAL_SET_COLUMNS');
l_set_col_val_list := MGMT_CRED_SET_COL_VAL_ARRAY();
l_set_column := MGMT_CRED_SET_COL_RECORD(
            type_column_name => 'InstallUserName',
            set_column_name => 'InstallUserName',
            set_column_values => l_set_col_val_list,
          set_column_display_name => 'Install Username',
          set_column_display_nlsid => 'CREDS_INSTALL_USER'
                        );
l_set_column_list.extend(1);
l_set_column_list(1) :=  l_set_column;
emd_loader.end_metadata_set('host','3.1','MGMT_CREDENTIAL_SET_COLUMNS');
l_set_col_val_list := MGMT_CRED_SET_COL_VAL_ARRAY();
l_set_column := MGMT_CRED_SET_COL_RECORD(
            type_column_name => 'InstallPassword',
            set_column_name => 'InstallPassword',
            set_column_values => l_set_col_val_list,
          set_column_display_name => 'Install Password',
          set_column_display_nlsid => 'CREDS_INSTALL_PASSWORD'
                        );
l_set_column_list.extend(1);
l_set_column_list(2) :=  l_set_column;
emd_loader.end_metadata_set('host','3.1','MGMT_CREDENTIAL_SET_COLUMNS');
l_set_col_val_list := MGMT_CRED_SET_COL_VAL_ARRAY();
l_set_column := MGMT_CRED_SET_COL_RECORD(
            type_column_name => 'OMSRegistrationPassword',
            set_column_name => 'OMSRegistrationPassword',
            set_column_values => l_set_col_val_list,
          set_column_display_name => 'OMS REG Password',
          set_column_display_nlsid => 'CREDS_OMS_REGISTRATION_PASSWORD'
                        );
l_set_column_list.extend(1);
l_set_column_list(3) :=  l_set_column;
emd_loader.end_metadata_set('host','3.1','MGMT_CREDENTIAL_SET_COLUMNS');
l_set_col_val_list := MGMT_CRED_SET_COL_VAL_ARRAY();
l_set_column := MGMT_CRED_SET_COL_RECORD(
            type_column_name => 'ProvCompPasswd',
            set_column_name => 'ProvCompPasswd',
            set_column_values => l_set_col_val_list,
          set_column_display_name => 'Comp Password',
          set_column_display_nlsid => 'CREDS_COMP_SECRET_PASSWORD'
                        );
l_set_column_list.extend(1);
l_set_column_list(4) :=  l_set_column;
mgmt_credential.create_credential_set(
         p_target_type => 'host',
         p_set_name => 'ProvisionCredsPref',
         p_set_usage => 'PREFERRED_CRED',
         p_set_context_type => 'CONTAINER',
         p_set_context => NULL,
         p_set_display_name => 'Provisioning Credentials',
         p_set_display_nlsid => 'CREDS_PROVISION',
         p_type_name => 'ProvisionCreds',
         p_set_columns => l_set_column_list,
         p_target_type_meta_ver => '3.1');
EXCEPTION
WHEN DUP_VAL_ON_INDEX THEN
BEGIN 
  BEGIN 
    insert into MGMT_CREDENTIAL_SETS ( target_type, target_type_meta_ver, set_name, set_display_name, set_display_nlsid, credential_type_name, set_usage, set_context_type, set_context ) values ( 'host','3.1','ProvisionCredsPref','Provisioning Credentials','CREDS_PROVISION','ProvisionCreds','PREFERRED_CRED','CONTAINER',' '  );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SETS  set 
     target_type = 'host',
    target_type_meta_ver = '3.1',
    set_name = 'ProvisionCredsPref',
    set_display_name = 'Provisioning Credentials',
    set_display_nlsid = 'CREDS_PROVISION',
    credential_type_name = 'ProvisionCreds',
    set_usage = 'PREFERRED_CRED',
    set_context_type = 'CONTAINER',
    set_context = ' '
  WHERE 
    target_type = 'host' AND 
    target_type_meta_ver = '3.1' AND 
    set_name = 'ProvisionCredsPref';
  END;
  BEGIN 
    insert into MGMT_CREDENTIAL_SET_COLUMNS ( target_type, target_type_meta_ver, set_name, set_column_name, set_column_display_name, set_column_display_nlsid, type_column_name ) values ( 'host','3.1','ProvisionCredsPref','InstallUserName','Install Username','CREDS_INSTALL_USER','InstallUserName' );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SET_COLUMNS set 
     target_type = 'host',
    target_type_meta_ver = '3.1',
    set_name = 'ProvisionCredsPref',
    set_column_name = 'InstallUserName',
    set_column_display_name = 'Install Username',
    set_column_display_nlsid = 'CREDS_INSTALL_USER',
    type_column_name = 'InstallUserName'
   WHERE
     target_type = 'host' AND 
     target_type_meta_ver = '3.1' AND 
     set_name = 'ProvisionCredsPref' AND 
     set_column_name = 'InstallUserName';
  END;
  BEGIN 
    insert into MGMT_CREDENTIAL_SET_COLUMNS ( target_type, target_type_meta_ver, set_name, set_column_name, set_column_display_name, set_column_display_nlsid, type_column_name ) values ( 'host','3.1','ProvisionCredsPref','InstallPassword','Install Password','CREDS_INSTALL_PASSWORD','InstallPassword' );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SET_COLUMNS set 
     target_type = 'host',
    target_type_meta_ver = '3.1',
    set_name = 'ProvisionCredsPref',
    set_column_name = 'InstallPassword',
    set_column_display_name = 'Install Password',
    set_column_display_nlsid = 'CREDS_INSTALL_PASSWORD',
    type_column_name = 'InstallPassword'
   WHERE
     target_type = 'host' AND 
     target_type_meta_ver = '3.1' AND 
     set_name = 'ProvisionCredsPref' AND 
     set_column_name = 'InstallPassword';
  END;
  BEGIN 
    insert into MGMT_CREDENTIAL_SET_COLUMNS ( target_type, target_type_meta_ver, set_name, set_column_name, set_column_display_name, set_column_display_nlsid, type_column_name ) values ( 'host','3.1','ProvisionCredsPref','OMSRegistrationPassword','OMS REG Password','CREDS_OMS_REGISTRATION_PASSWORD','OMSRegistrationPassword' );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SET_COLUMNS set 
     target_type = 'host',
    target_type_meta_ver = '3.1',
    set_name = 'ProvisionCredsPref',
    set_column_name = 'OMSRegistrationPassword',
    set_column_display_name = 'OMS REG Password',
    set_column_display_nlsid = 'CREDS_OMS_REGISTRATION_PASSWORD',
    type_column_name = 'OMSRegistrationPassword'
   WHERE
     target_type = 'host' AND 
     target_type_meta_ver = '3.1' AND 
     set_name = 'ProvisionCredsPref' AND 
     set_column_name = 'OMSRegistrationPassword';
  END;
  BEGIN 
    insert into MGMT_CREDENTIAL_SET_COLUMNS ( target_type, target_type_meta_ver, set_name, set_column_name, set_column_display_name, set_column_display_nlsid, type_column_name ) values ( 'host','3.1','ProvisionCredsPref','ProvCompPasswd','Comp Password','CREDS_COMP_SECRET_PASSWORD','ProvCompPasswd' );
  EXCEPTION
  WHEN DUP_VAL_ON_INDEX THEN
  update MGMT_CREDENTIAL_SET_COLUMNS set 
     target_type = 'host',
    target_type_meta_ver = '3.1',
    set_name = 'ProvisionCredsPref',
    set_column_name = 'ProvCompPasswd',
    set_column_display_name = 'Comp Password',
    set_column_display_nlsid = 'CREDS_COMP_SECRET_PASSWORD',
    type_column_name = 'ProvCompPasswd'
   WHERE
     target_type = 'host' AND 
     target_type_meta_ver = '3.1' AND 
     set_name = 'ProvisionCredsPref' AND 
     set_column_name = 'ProvCompPasswd';
  END;
END; 
END;
/
BEGIN 
emd_loader.end_metadata_set('host','3.1','MGMT_CREDENTIAL_SETS');
END;
/
commit;
