rem handle target type oracle_emd

BEGIN 
mgmt_target.register_target_type(
    p_target_type_in => 'oracle_emd',
    p_type_meta_ver_in => '3.0',
    p_type_display_name_in => 'Agent',
    p_type_display_nlsid_in => 'oracle_emd_name',
    p_type_resource_bundle_in => MGMT_TARGET.G_DEFAULT_RESOURCE_BUNDLE);
END;
/

BEGIN 
emd_loader.end_metadata_set('oracle_emd','3.0','MGMT_TARGET_TYPE_VERSIONS');
END;
/
DECLARE
  l_type_property_list SMP_EMD_NVPAIR_ARRAY;
  l_type_property SMP_EMD_NVPAIR;
BEGIN

l_type_property_list := SMP_EMD_NVPAIR_ARRAY();
l_type_property := SMP_EMD_NVPAIR( 'disallow_redundancy_group',
                                 '1');
l_type_property_list.extend(1);
l_type_property_list(l_type_property_list.count) := l_type_property;

mgmt_target.add_target_type_properties(
  p_target_type_in => 'oracle_emd',
  p_type_property_list_in => l_type_property_list);
END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Status',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Status',
        p_column_label_nlsid => 'emd_resp_stat',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Status',
        p_short_name_nlsid => 'emd_resp_stat_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'NmoSetuidStatus',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Nmo Setuid Status',
        p_column_label_nlsid => 'emd_nmo_stat',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Nmo Status',
        p_short_name_nlsid => 'emd_nmo_stat_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_emd',
    p_metric_name => 'Response',
    p_type_meta_ver => '3.0',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Response',
    p_metric_label_nlsid => 'emd_resp',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'time',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Time (seconds)',
        p_column_label_nlsid => 'emd_ulimit_time',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'file',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'File (blocks)',
        p_column_label_nlsid => 'emd_ulimit_file',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'data',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Data (kbytes)',
        p_column_label_nlsid => 'emd_ulimit_data',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'stack',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Stack (kbytes)',
        p_column_label_nlsid => 'emd_ulimit_stack',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'coredump',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'CoreDump (blocks)',
        p_column_label_nlsid => 'emd_ulimit_coredump',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'nofiles',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'NoFiles (descriptors)',
        p_column_label_nlsid => 'emd_ulimit_nofiles',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'vmemory',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Virtual Mem (kbytes)',
        p_column_label_nlsid => 'emd_ulimit_vmemory',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_emd',
    p_metric_name => 'EMDUserLimits',
    p_type_meta_ver => '3.0',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'User Limit Info',
    p_metric_label_nlsid => 'emd_ulimit',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'HostInfoPID',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Process ID',
        p_column_label_nlsid => 'emd_hostinfo_pid',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Process ID',
        p_short_name_nlsid => 'emd_hostinfo_pid_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'HostInfocpu',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'CPU Usage (%)',
        p_column_label_nlsid => 'emd_hostinfo_cpu',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => 'CPU Usage%',
        p_short_name_nlsid => 'emd_hostinfo_cpu_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'HostInfovsz',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Virtual Memory Utilization (KB)',
        p_column_label_nlsid => 'emd_hostinfo_vsz',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Virtual Mem(KB)',
        p_short_name_nlsid => 'emd_hostinfo_vsz_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'HostInfosza',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Resident Memory Utilization (KB)',
        p_column_label_nlsid => 'emd_hostinfo_asz',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Resident Mem',
        p_short_name_nlsid => 'emd_hostinfo_asz_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'HostInfoszp',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Resident Memory Utilization (%)',
        p_column_label_nlsid => 'emd_hostinfo_szp',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__standard_percent',
        p_short_name => 'Resident Mem %',
        p_short_name_nlsid => 'emd_hostinfo_szp_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'HostInforegf',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Number Files Open',
        p_column_label_nlsid => 'emd_hostinfo_regf',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Files open',
        p_short_name_nlsid => 'emd_hostinfo_regf_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'HostInforegh',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Number Handles Open',
        p_column_label_nlsid => 'emd_hostinfo_regh',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Handles open',
        p_short_name_nlsid => 'emd_hostinfo_regh_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'HostInfonumt',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Number Threads Created',
        p_column_label_nlsid => 'emd_hostinfo_numt',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Num. Threads',
        p_short_name_nlsid => 'emd_hostinfo_numt_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'AgentInfovsz',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Agent Virtual Memory Utilization (KB)',
        p_column_label_nlsid => 'agent_info_vsz',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Agent Virtual Mem(KB)',
        p_short_name_nlsid => 'agent_info_vsz_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'AgentInfores',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Agent Resident Memory Utilization (KB)',
        p_column_label_nlsid => 'agent_info_res',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => 'Agent Resident Mem(KB)',
        p_short_name_nlsid => 'agent_info_res_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;
NULL;
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'HostInfovszGrowth',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Virtual Memory Utilization Growth (%)',
        p_column_label_nlsid => 'emd_hostinfo_vszg',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '%',
        p_unit_nlsid => 'em__sys__generic_percent',
        p_short_name => 'VM Growth(%)',
        p_short_name_nlsid => 'emd_hostinfo_vszg_short',
        p_is_for_summary => 1,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_emd',
    p_metric_name => 'ProcessInfo',
    p_type_meta_ver => '3.0',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Agent Process Statistics',
    p_metric_label_nlsid => 'emd_hostinfo',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'username',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'User Name',
        p_column_label_nlsid => 'emd_username',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'groupname',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Group Name',
        p_column_label_nlsid => 'emd_groupname',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'groups',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Other Groups',
        p_column_label_nlsid => 'emd_groups',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'emdlocation',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Location',
        p_column_label_nlsid => 'emd_location',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_emd',
    p_metric_name => 'EMDIdentity',
    p_type_meta_ver => '3.0',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'User Identification',
    p_metric_label_nlsid => 'emd_id',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'nfilestoupload',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Number of Files to Upload',
        p_column_label_nlsid => 'emd_upoloadstats_ftu',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'sizembtoupload',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Size of Files to Upload (MB)',
        p_column_label_nlsid => 'emd_uploadstats_stu',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;
NULL;

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'uploadrate',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Upload Rate (KB/sec)',
        p_column_label_nlsid => 'emd_uploadstats_ur',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_emd',
    p_metric_name => 'EMDUploadStats',
    p_type_meta_ver => '3.0',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Upload Statistics',
    p_metric_label_nlsid => 'emd_uploadstats',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
emd_loader.end_metadata_set('oracle_emd','3.0','MGMT_METRICS');
END;
/
commit;
