rem handle target type oracle_emrep

BEGIN 
mgmt_target.register_target_type(
    p_target_type_in => 'oracle_emrep',
    p_type_meta_ver_in => '3.0',
    p_type_display_name_in => 'OMS and Repository',
    p_type_display_nlsid_in => 'oracle_emrep_name',
    p_type_resource_bundle_in => MGMT_TARGET.G_DEFAULT_RESOURCE_BUNDLE);
END;
/

BEGIN 
emd_loader.end_metadata_set('oracle_emrep','3.0','MGMT_TARGET_TYPE_VERSIONS');
END;
/
DECLARE
  l_type_property_list SMP_EMD_NVPAIR_ARRAY;
  l_type_property SMP_EMD_NVPAIR;
BEGIN

l_type_property_list := SMP_EMD_NVPAIR_ARRAY();
l_type_property := SMP_EMD_NVPAIR( 'disallow_redundancy_group',
                                 '1');
l_type_property_list.extend(1);
l_type_property_list(l_type_property_list.count) := l_type_property;

l_type_property := SMP_EMD_NVPAIR( 'disallow_template',
                                 '1');
l_type_property_list.extend(1);
l_type_property_list(l_type_property_list.count) := l_type_property;

mgmt_target.add_target_type_properties(
  p_target_type_in => 'oracle_emrep',
  p_type_property_list_in => l_type_property_list);
END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'Status',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_NUMBER,
        p_column_label => 'Status',
        p_column_label_nlsid => 'oracle_emrep_resp_status',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_emrep',
    p_metric_name => 'Response',
    p_type_meta_ver => '3.0',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Response',
    p_metric_label_nlsid => 'oracle_emrep_resp',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
 EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
END;
/

BEGIN 

  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.extend(1);
  EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST(EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST.COUNT)
        := MGMT_METRIC_COLUMN_OBJ.NEW(
        p_column_name => 'notificationStatus',
        p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
        p_column_label => 'Notification UpDown',
        p_column_label_nlsid => 'notification_updown',
        p_is_key => 0,
        p_description => '',
        p_description_nlsid => '',
        p_unit => '',
        p_unit_nlsid => '',
        p_short_name => '',
        p_short_name_nlsid => '',
        p_is_for_summary => 0,
        p_statefull => 1,
        p_is_renderable => 1,
        p_non_thresholded_alerts => 0);
NULL;

 END;
/

DECLARE
  l_valid_if           MGMT_VALIDIF_OBJ;
  l_valid_if_list      MGMT_VALIDIF_ARRAY;
  l_category           MGMT_CATEGORY_OBJ;
  l_category_list      MGMT_CATEGORY_ARRAY;
BEGIN

  l_valid_if_list := NULL;
  em_type_registry.upsert_metric(
    p_target_type => 'oracle_emrep',
    p_metric_name => 'Notification_Status',
    p_type_meta_ver => '3.0',
    p_valid_if_list => l_valid_if_list,
    p_metric_type => MGMT_GLOBAL.G_METRIC_TYPE_TABLE,
    p_usage_type => MGMT_GLOBAL.G_USAGE_VIEW_COLLECT,
    p_metric_label => 'Notification Status',
    p_metric_label_nlsid => 'notification_status',
    p_description => NULL,
    p_description_nlsid => NULL,
    p_unit => NULL,
    p_unit_nlsid => NULL,
    p_short_name => NULL,
    p_short_name_nlsid => NULL,
    p_is_repository => 0,
    p_source_type => 0,
    p_keys_from_mult_colls => 0,
    p_category_list => l_category_list,
    p_metric_column_list => EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST,
    p_is_transposed => 0,
    p_is_test_metric => 0,
    p_remote => 0,
    p_has_push => 0,
    p_has_pull => 1);

    EM_TYPE_REGISTRY.S_METRIC_COLUMN_LIST := MGMT_METRIC_COLUMN_ARRAY();
  END;

/

BEGIN 
emd_loader.end_metadata_set('oracle_emrep','3.0','MGMT_METRICS');
END;
/

BEGIN 
MGMT_TARGET.UPSERT_TARGET_PROPERTY_DEF(
              v_target_type => 'oracle_emrep',
              v_type_meta_ver => '3.0',
              v_property_name => 'MachineName',
              v_property_type => 'INSTANCE',
              v_property_display_name => 'Repository machine name',
              v_property_display_nlsid => 'oracle_emrep_MachineName_iprop',
              v_required_flag => 0,
              v_credential_flag => 0,
              v_default_value => '',
              v_computed_flag => 0 );

MGMT_TARGET.UPSERT_TARGET_PROPERTY_DEF(
              v_target_type => 'oracle_emrep',
              v_type_meta_ver => '3.0',
              v_property_name => 'Port',
              v_property_type => 'INSTANCE',
              v_property_display_name => 'Repository port',
              v_property_display_nlsid => 'oracle_emrep_Port_iprop',
              v_required_flag => 0,
              v_credential_flag => 0,
              v_default_value => '',
              v_computed_flag => 0 );

MGMT_TARGET.UPSERT_TARGET_PROPERTY_DEF(
              v_target_type => 'oracle_emrep',
              v_type_meta_ver => '3.0',
              v_property_name => 'SID',
              v_property_type => 'INSTANCE',
              v_property_display_name => 'Repository SID',
              v_property_display_nlsid => 'oracle_emrep_SID_iprop',
              v_required_flag => 0,
              v_credential_flag => 0,
              v_default_value => '',
              v_computed_flag => 0 );

MGMT_TARGET.UPSERT_TARGET_PROPERTY_DEF(
              v_target_type => 'oracle_emrep',
              v_type_meta_ver => '3.0',
              v_property_name => 'ConnectDescriptor',
              v_property_type => 'INSTANCE',
              v_property_display_name => 'Repository Connect Descriptor',
              v_property_display_nlsid => 'oracle_emrep_ConnectDescriptor_iprop',
              v_required_flag => 0,
              v_credential_flag => 0,
              v_default_value => '',
              v_computed_flag => 0 );

MGMT_TARGET.UPSERT_TARGET_PROPERTY_DEF(
              v_target_type => 'oracle_emrep',
              v_type_meta_ver => '3.0',
              v_property_name => 'UserName',
              v_property_type => 'INSTANCE',
              v_property_display_name => 'Repository username',
              v_property_display_nlsid => 'oracle_emrep_UserName_iprop',
              v_required_flag => 1,
              v_credential_flag => 1,
              v_default_value => '',
              v_computed_flag => 0 );

MGMT_TARGET.UPSERT_TARGET_PROPERTY_DEF(
              v_target_type => 'oracle_emrep',
              v_type_meta_ver => '3.0',
              v_property_name => 'password',
              v_property_type => 'INSTANCE',
              v_property_display_name => 'Repository password',
              v_property_display_nlsid => 'oracle_emrep_password_iprop',
              v_required_flag => 1,
              v_credential_flag => 1,
              v_default_value => '',
              v_computed_flag => 0 );

END;
/

BEGIN 
emd_loader.end_metadata_set('oracle_emrep','3.0','MGMT_TARGET_PROP_DEFS');
END;
/
commit;
