Rem drv: <create type="pkgdefs" pos="target/default_homepage_pkgdef.sql+"/>
Rem
Rem $Header: emcore/source/oracle/sysman/emdrep/sql/core/latest/template/template_pkgdef.sql /st_emcore_10.2.0.4.2db11.2/1 2008/09/21 22:56:55 paachary Exp $
Rem
Rem template_pkgdef.sql
Rem
Rem Copyright (c) 2005, 2008, Oracle and/or its affiliates. All rights reserved.
Rem
Rem    NAME
Rem      template_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    paachary    09/17/08 - Backport paachary_bug-7258269 from
Rem                           st_emcore_10.2.0.1.0
Rem    gsbhatia    07/18/05 - Fix repmgr header 
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    rpinnama    06/09/05 - rpinnama_bug-4012083
Rem    rpinnama    05/03/05 - Created
Rem

CREATE OR REPLACE PACKAGE em_template
AS

  G_MODULE_NAME CONSTANT VARCHAR2(30) := 'EM_TEMPLATE';

  --
  -- FUNCTION: generate_template_guid
  --
  -- PURPOSE:
  --   Given a target type,  template name, this function 
  --   computes the template guid for the template. The guid is an MD5 hash of
  --   the target type and template name. 
  --
  -- IN Parameters:
  --   p_target_type: The type of the target
  --   p_template_name: The name of the template
  --
  -- RETURN:
  --   The generated template guid
  --
  FUNCTION generate_template_guid(p_target_type   IN VARCHAR2,
                                  p_template_name IN VARCHAR2)
    RETURN RAW;


  -- Template copy API
  --
  -- FUNCTION: generate_template_copy_guid
  --
  -- PURPOSE:
  --   Generates a template copy guid with given target_type
  --   template_name, target_name and copy_req_guid
  --
  FUNCTION generate_template_copy_guid (
      p_target_type        IN VARCHAR2,
      p_template_name      IN VARCHAR2,
      p_target_name        IN VARCHAR2 DEFAULT ' ',
      p_copy_req_guid      IN RAW)
     RETURN RAW;


  PROCEDURE get_object_settings(p_object_guid IN RAW,
                                p_object_type IN NUMBER,
                                p_metric_list OUT MGMT_MNTR_METRIC_ARRAY,
                                p_policy_list OUT MGMT_MNTR_POLICY_ARRAY,
                                p_coll_list   OUT MGMT_MNTR_COLLECTION_ARRAY);

    -- Public API - create_template
    -- IN Parameters 
    --        p_target_type
    --        p_source_target_name
    --        p_template_name
    --        p_description
    --        p_is_out_of_box
    -- OUT Parameters
    --        p_message_array
    --        p_return_status -  1 => success
    --                           0 => failure
    -- Description
    --      This API copies all the metric settings of the source target and 
    --      creates a monitoring template  with the name provided.
    PROCEDURE create_template( p_target_type           IN VARCHAR2,
                               p_source_target_name    IN VARCHAR2,
                               p_template_name         IN VARCHAR2,
                               p_description           IN VARCHAR2 DEFAULT '',
                               p_is_out_of_box         IN NUMBER DEFAULT 0,
                               p_message_array         OUT SMP_EMD_STRING_ARRAY,
                               p_return_status         OUT NUMBER);

    -- Public API - apply_template
    -- IN Parameters 
    --        p_target_type
    --        p_template_name
    --        p_apply_option
    --        p_dest_targets_list
    --        p_udm_cred_array
    -- OUT Parameters
    --        p_message_array
    --        p_return_status -  1 => success
    --                           0 => failure
    -- Description
    --      This API applies the monitoring std to the list of valid targets from the list of targets
    --      specified by the user.
    PROCEDURE apply_template(  p_template_name       IN VARCHAR2, 
                               p_target_type         IN VARCHAR2,
                               p_apply_option        IN NUMBER := 2,
                               p_dest_targets_list   IN MGMT_TARGET_ARRAY,
                               p_udm_cred_array      IN UDM_CRED_ARRAY DEFAULT NULL,
                               p_message_array       OUT SMP_EMD_STRING_ARRAY,
                               p_return_status       OUT NUMBER);


END em_template;
/

show errors

