Rem drv: <create type="type_bodys" pos="sdk/sdk_types_body.sql+"/>
Rem
Rem $Header: template_type_bodys.sql 25-jul-2006.23:17:57 pratagar Exp $
Rem
Rem template_type_bodys.sql
Rem
Rem Copyright (c) 2004, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      template_type_bodys.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    pratagar    07/25/06 - Backport pratagar_bug-4653111 from main 
Rem    pratagar    12/20/05 - mgmt_mntr_metric modified
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    rpinnama    10/10/04 - Change template to mntr 
Rem    rpinnama    09/30/04 - Add credentials to collection object 
Rem    rpinnama    09/28/04 - rpinnama_template_api_3
Rem    rpinnama    09/27/04 - Created
Rem


CREATE OR REPLACE TYPE BODY mgmt_template_access AS
    -- Constructs a new mgmt_template_access object
    -- Used to support type evolution in case we need to add
    -- more columns or obsolete columns
    STATIC FUNCTION NEW( 
        p_user_name   IN VARCHAR2,
        p_privilege   IN VARCHAR2
      ) 
    RETURN mgmt_template_access AS
    BEGIN
      RETURN mgmt_template_access(p_user_name, p_privilege);
    END NEW;
END;
/
show errors

@&EM_SQL_ROOT/core/10.2.0.3/template/template_types_body.sql

CREATE OR REPLACE TYPE BODY mgmt_mntr_policy AS
    -- Constructs a new mgmt_mntr_policy object
    -- Used to support type evolution in case we need to add
    -- more columns or obsolete columns
    STATIC FUNCTION NEW( 
        p_policy_name   IN VARCHAR2,
        p_coll_name     IN VARCHAR2,
	p_is_enabled    IN NUMBER DEFAULT 1,
	p_key_val_list  IN MGMT_POLICY_KEY_VAL_ARRAY DEFAULT NULL
      ) 
    RETURN mgmt_mntr_policy AS
    BEGIN
      RETURN mgmt_mntr_policy(p_policy_name, 
          p_coll_name, p_is_enabled, p_key_val_list);
    END NEW;
END;
/
show errors

CREATE OR REPLACE TYPE BODY mgmt_coll_prop AS
    -- Constructs a new mgmt_coll_prop object
    -- Used to support type evolution in case we need to add
    -- more columns or obsolete columns
    STATIC FUNCTION NEW( 
        p_name   IN VARCHAR2,
        p_value  IN VARCHAR2
      ) 
    RETURN mgmt_coll_prop AS
    BEGIN
      RETURN mgmt_coll_prop(p_name, p_value);
    END NEW;
END;
/
show errors

CREATE OR REPLACE TYPE BODY mgmt_coll_metric AS
    -- Constructs a new mgmt_coll_metric object
    -- Used to support type evolution in case we need to add
    -- more columns or obsolete columns
    STATIC FUNCTION NEW( 
        p_metric_name    IN VARCHAR2,
        p_property_list  IN MGMT_COLL_PROP_ARRAY DEFAULT NULL,
	p_credentials    IN MGMT_CRED_ARRAY DEFAULT NULL
      ) 
    RETURN mgmt_coll_metric AS
    BEGIN
      RETURN mgmt_coll_metric(p_metric_name, p_property_list, p_credentials);
    END NEW;
END;
/
show errors

CREATE OR REPLACE TYPE BODY mgmt_mntr_ca AS
    -- Constructs a new mgmt_mntr_access object
    -- Used to support type evolution in case we need to add
    -- more columns or obsolete columns
    STATIC FUNCTION NEW( 
        p_ca_name    IN VARCHAR2,
        p_ca_creds   IN MGMT_JOB_CRED_ARRAY
      ) 
    RETURN mgmt_mntr_ca AS
    BEGIN
      RETURN mgmt_mntr_ca(p_ca_name, p_ca_creds);
    END NEW;
END;
/
show errors

CREATE OR REPLACE TYPE BODY mgmt_mntr_collection AS
    -- Constructs a new mgmt_mntr_collection object
    -- Used to support type evolution in case we need to add
    -- more columns or obsolete columns
    STATIC FUNCTION NEW( 
        p_coll_name        IN VARCHAR2,
        p_is_enabled       IN NUMBER DEFAULT 1,
	p_is_transposed    IN NUMBER DEFAULT 0,
	p_store_metric     IN NUMBER DEFAULT 1,
	p_upload_frequency IN NUMBER DEFAULT 1,
	p_schedule_ex      IN VARCHAR2 DEFAULT NULL,
	p_schedule         IN MGMT_COLL_SCHEDULE_OBJ DEFAULT NULL,
	p_metric_list      IN MGMT_COLL_METRIC_ARRAY DEFAULT NULL
      ) 
    RETURN mgmt_mntr_collection AS
    BEGIN
      RETURN mgmt_mntr_collection( p_coll_name, p_is_enabled, p_is_transposed,
          p_store_metric, p_upload_frequency, p_schedule_ex, p_schedule,
	  p_metric_list);
    END NEW;
END;
/
show errors

