Rem drv: <create type="pkgbodys" pos="template_pkgbody.sql+"/>
Rem
Rem $Header: emcore/source/oracle/sysman/emdrep/sql/core/latest/template/template_ui_pkgbody.sql /st_emcore_10.2.0.4.2db11.2/1 2008/09/21 22:56:55 paachary Exp $
Rem
Rem template_ui_pkgbody.sql
Rem
Rem Copyright (c) 2008, Oracle and/or its affiliates. All rights reserved.
Rem
Rem    NAME
Rem      template_ui_pkgbody.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    paachary    07/16/08 - Adding new SDK APIs
Rem    paachary    04/11/08 - creating a new package for 10g codeline
Rem    paachary    04/11/08 - Created
Rem

CREATE OR REPLACE PACKAGE BODY mgmt_template_ui
AS

    -- Public API - modify_purge_policy
    -- IN Parameters 
    --        p_policy_name
    --        p_policy_type
    --        p_purge_proc_name
    --        p_retention_days
    -- OUT Parameters
    --        none
    -- Description
    --      This API modifies the purge policy for template/ stds history tables.
    PROCEDURE modify_purge_policy(  p_policy_name       IN VARCHAR2 DEFAULT 'MGMT_TARGET_UPDATE_HISTORY',
                                    p_policy_type       IN NUMBER   DEFAULT EM_PURGE.G_POLICY_TYPE_SYSTEM,
                                    p_purge_proc_name   IN VARCHAR2 DEFAULT 'MGMT_TARGET_UPDATE.PURGE',
                                    p_retention_days    IN NUMBER   DEFAULT 180,
                                    p_policy_desc       IN VARCHAR2 DEFAULT 'Purge policy for target update history.')
    IS
        l_retention_days NUMBER := p_retention_days;
    BEGIN   
        IF (l_retention_days IS NULL)
        THEN
            l_retention_days := 180; 
        END IF;
        em_purge.drop_purge_policy(p_policy_name => p_policy_name );

        em_purge.add_purge_policy(p_policy_name       => p_policy_name,
                                  p_policy_type       => p_policy_type,
                                  p_purge_proc_name   => p_purge_proc_name,
                                  p_retention_hours   => l_retention_days * 24,
                                  p_policy_desc       => p_policy_desc,
                                  p_retent_group_name => EM_PURGE.G_RETENTION_GROUP_LVL2_SUMMARY);
    END modify_purge_policy;


    -- Public API - create_template
    -- IN Parameters 
    --        p_target_type
    --        p_source_target_name
    --        p_template_name
    --        p_description
    --        p_is_out_of_box
    -- OUT Parameters
    --        p_message_array
    --        p_return_status -  1 => success
    --                           0 => failure
    -- Description
    --      This API copies all the metric settings of the source target and creates a monitoring std
    --      with the name provided.
    PROCEDURE create_template( p_target_type           IN VARCHAR2,
                               p_source_target_name    IN VARCHAR2,
                               p_template_name         IN VARCHAR2,
                               p_description           IN VARCHAR2 DEFAULT '',
                               p_is_out_of_box         IN NUMBER DEFAULT 0,
                               p_message_array         OUT SMP_EMD_STRING_ARRAY,
                               p_return_status         OUT NUMBER)
    IS
        l_msg_cntr              PLS_INTEGER := 0;
        l_is_out_of_box         NUMBER := p_is_out_of_box;
    BEGIN
        IF ( l_is_out_of_box IS NULL )
        THEN
            l_is_out_of_box := 0;
        END IF;

        p_message_array := SMP_EMD_STRING_ARRAY();
        p_return_status := 0;
        IF (p_template_name IS NULL OR 
            p_template_name = '')
        THEN
            l_msg_cntr := p_message_array.COUNT;
            p_message_array.EXTEND;
            l_msg_cntr := l_msg_cntr + 1;
            p_message_array(l_msg_cntr) := 'Monitoring Template is invalid. Creation of Monitoring Template is aborted';
            p_return_status := 0;
        ELSE
            IF (l_is_out_of_box IS NULL OR 
                LENGTH(l_is_out_of_box) = 0 OR 
                l_is_out_of_box NOT IN (0,1))
            THEN
                l_msg_cntr := p_message_array.COUNT;
                p_message_array.EXTEND;
                l_msg_cntr := l_msg_cntr + 1;
                p_message_array(l_msg_cntr) := 'Monitoring Template'||q'['s p_is_out_of_box]'||' value is not valid. '||
                                               'The value should be 0 or 1. '||
                                               'Creation of Monitoring Template is aborted';
                p_return_status := 0;
            ELSE                
                em_template.create_template( p_target_type           => p_target_type,
                                             p_source_target_name    => p_source_target_name,
                                             p_template_name         => p_template_name,
                                             p_description           => p_description,                                             
                                             p_is_out_of_box         => l_is_out_of_box,
                                             p_message_array         => p_message_array,
                                             p_return_status         => p_return_status );
            END IF;
        END IF;
    EXCEPTION
        WHEN OTHERS THEN
            p_return_status := 0;
            l_msg_cntr := p_message_array.COUNT;
            p_message_array.EXTEND;
            l_msg_cntr := l_msg_cntr + 1;
            p_message_array(l_msg_cntr) := 'Exception During Create '||sqlerrm||'.Creation of Monitoring Template aborted.';
    END create_template;

    -- Public API - apply_template
    -- IN Parameters 
    --        p_target_type
    --        p_template_name
    --        p_apply_option
    --        p_dest_targets_list
    --        p_udm_cred_array
    -- OUT Parameters
    --        p_message_array
    --        p_return_status -  1 => success
    --                           0 => failure
    -- Description
    --      This API applies the monitoring std to the list of valid targets from the list of targets
    --      specified by the user.
     PROCEDURE apply_template( p_template_name       IN VARCHAR2, 
                               p_target_type         IN VARCHAR2,
                               p_apply_option        IN NUMBER := 2,
                               p_dest_targets_list   IN MGMT_TARGET_ARRAY,
                               p_udm_cred_array      IN UDM_CRED_ARRAY DEFAULT NULL,
                               p_message_array       OUT SMP_EMD_STRING_ARRAY,
                               p_return_status       OUT NUMBER)
    IS
        l_msg_cntr      PLS_INTEGER := 0;
        l_std_guid      mgmt_templates.template_guid%TYPE;
        l_target_type   mgmt_templates.target_type%TYPE;
    BEGIN        
        p_message_array := SMP_EMD_STRING_ARRAY();
        p_return_status := 0;
        BEGIN
            l_std_guid := mgmt_template.get_template_guid
                                 ( p_target_type   => p_target_type,
                                   p_template_name => p_template_name);

            em_template.apply_template(   p_template_name       => p_template_name,
                                          p_target_type         => p_target_type,
                                          p_apply_option        => p_apply_option,
                                          p_dest_targets_list   => p_dest_targets_list,
                                          p_udm_cred_array      => p_udm_cred_array,
                                          p_message_array       => p_message_array,
                                          p_return_status       => p_return_status);
        EXCEPTION
            WHEN OTHERS THEN
                l_msg_cntr := p_message_array.COUNT;
                p_message_array.EXTEND;
                l_msg_cntr := l_msg_cntr + 1;
                p_message_array(l_msg_cntr) := 'Monitoring Template is invalid. '||sqlerrm||
                                               ': Apply of template is aborted';
                p_return_status := 0;            
        END;
    END apply_template;

    -- Public API - delete_monitoring_std
    -- IN Parameters 
    --        p_target_type
    --        p_template_name
    -- OUT Parameters
    --        p_message
    --        p_return_status -  1 => success
    --                           0 => failure
    -- Description
    --      This API deletes the specified monitoring std.
    PROCEDURE delete_template(    p_target_type           IN VARCHAR2,
                                  p_template_name         IN VARCHAR2,
                                  p_message               OUT VARCHAR2,
                                  p_return_status         OUT NUMBER)
    IS
    BEGIN
        p_return_status := 1;
        mgmt_template.delete_template( p_target_type    => p_target_type,
                                       p_template_name  => p_template_name);
        p_message := 'Monitoring Template '||p_template_name||' deleted successfully';
    EXCEPTION
        WHEN OTHERS THEN
            p_return_status := 0;
            p_message := sqlerrm;
    END delete_template;
END mgmt_template_ui;
/

show errors;
